/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.store.LobStorage;
import org.h2.util.DateTimeUtils;
import org.h2.util.MathUtils;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLob;
import org.h2.value.ValueLobDb;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Data {
    public static final int LENGTH_INT = 4;
    private static final int goto = 8;
    private static final int char = 32;
    private static final int d = 48;
    private static final int else = 56;
    private static final int long = 58;
    private static final int b = 59;
    private static final int for = 60;
    private static final int void = 62;
    private static final int new = 64;
    private static final int byte = 65;
    private static final int c = 66;
    private static final int try = 67;
    private static final int if = 68;
    private static final int a = 100;
    private static final long case = 60000L;
    protected byte[] data;
    private int int;
    private final DataHandler do;

    protected Data(DataHandler dataHandler, byte[] byArray) {
        this.do = dataHandler;
        this.data = byArray;
    }

    public void setInt(int n2, int n3) {
        byte[] byArray = this.data;
        byArray[n2] = (byte)(n3 >> 24);
        byArray[n2 + 1] = (byte)(n3 >> 16);
        byArray[n2 + 2] = (byte)(n3 >> 8);
        byArray[n2 + 3] = (byte)n3;
    }

    public void writeInt(int n2) {
        byte[] byArray = this.data;
        byArray[this.int] = (byte)(n2 >> 24);
        byArray[this.int + 1] = (byte)(n2 >> 16);
        byArray[this.int + 2] = (byte)(n2 >> 8);
        byArray[this.int + 3] = (byte)n2;
        this.int += 4;
    }

    public int readInt() {
        byte[] byArray = this.data;
        int n2 = (byArray[this.int] << 24) + ((byArray[this.int + 1] & 0xFF) << 16) + ((byArray[this.int + 2] & 0xFF) << 8) + (byArray[this.int + 3] & 0xFF);
        this.int += 4;
        return n2;
    }

    public static int getStringLen(String string) {
        int n2 = string.length();
        return Data.a(string, n2) + Data.getVarIntLen(n2);
    }

    private static int a(String string, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '\u0800') {
                n3 += 2;
                continue;
            }
            if (c2 < '\u0080') continue;
            ++n3;
        }
        return n2 + n3;
    }

    public String readString() {
        int n2 = this.readVarInt();
        return this.do(n2);
    }

    private String do(int n2) {
        byte[] byArray = this.data;
        int n3 = this.int;
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            cArray[i2] = (n4 = byArray[n3++] & 0xFF) < 128 ? (char)n4 : (n4 >= 224 ? (char)(((n4 & 0xF) << 12) + ((byArray[n3++] & 0x3F) << 6) + (byArray[n3++] & 0x3F)) : (char)(((n4 & 0x1F) << 6) + (byArray[n3++] & 0x3F)));
        }
        this.int = n3;
        return new String(cArray);
    }

    public void writeString(String string) {
        int n2 = string.length();
        this.writeVarInt(n2);
        this.if(string, n2);
    }

    private void if(String string, int n2) {
        int n3 = this.int;
        byte[] byArray = this.data;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '\u0080') {
                byArray[n3++] = (byte)c2;
                continue;
            }
            if (c2 >= '\u0800') {
                byArray[n3++] = (byte)(0xE0 | c2 >> 12);
                byArray[n3++] = (byte)(c2 >> 6 & 0x3F);
                byArray[n3++] = (byte)(c2 & 0x3F);
                continue;
            }
            byArray[n3++] = (byte)(0xC0 | c2 >> 6);
            byArray[n3++] = (byte)(c2 & 0x3F);
        }
        this.int = n3;
    }

    public static Data create(DataHandler dataHandler, int n2) {
        return new Data(dataHandler, new byte[n2]);
    }

    public static Data create(DataHandler dataHandler, byte[] byArray) {
        return new Data(dataHandler, byArray);
    }

    public int length() {
        return this.int;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public void reset() {
        this.int = 0;
    }

    public void write(byte[] byArray, int n2, int n3) {
        System.arraycopy(byArray, n2, this.data, this.int, n3);
        this.int += n3;
    }

    public void read(byte[] byArray, int n2, int n3) {
        System.arraycopy(this.data, this.int, byArray, n2, n3);
        this.int += n3;
    }

    public void writeByte(byte by) {
        this.data[this.int++] = by;
    }

    public byte readByte() {
        return this.data[this.int++];
    }

    public long readLong() {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public void writeLong(long l2) {
        this.writeInt((int)(l2 >>> 32));
        this.writeInt((int)l2);
    }

    public void writeValue(Value value) {
        int n2 = this.int;
        if (value == ValueNull.INSTANCE) {
            this.data[this.int++] = 0;
            return;
        }
        int n3 = value.getType();
        switch (n3) {
            case 1: {
                this.writeByte((byte)(value.getBoolean() != false ? 65 : 64));
                break;
            }
            case 2: {
                this.writeByte((byte)n3);
                this.writeByte(value.getByte());
                break;
            }
            case 3: {
                this.writeByte((byte)n3);
                this.writeShortInt(value.getShort());
                break;
            }
            case 4: {
                int n4 = value.getInt();
                if (n4 < 0) {
                    this.writeByte((byte)66);
                    this.writeVarInt(-n4);
                    break;
                }
                if (n4 < 16) {
                    this.writeByte((byte)(32 + n4));
                    break;
                }
                this.writeByte((byte)n3);
                this.writeVarInt(n4);
                break;
            }
            case 5: {
                long l2 = value.getLong();
                if (l2 < 0L) {
                    this.writeByte((byte)67);
                    this.writeVarLong(-l2);
                    break;
                }
                if (l2 < 8L) {
                    this.writeByte((byte)(48L + l2));
                    break;
                }
                this.writeByte((byte)n3);
                this.writeVarLong(l2);
                break;
            }
            case 6: {
                BigDecimal bigDecimal = value.getBigDecimal();
                if (BigDecimal.ZERO.equals(bigDecimal)) {
                    this.writeByte((byte)56);
                    break;
                }
                if (BigDecimal.ONE.equals(bigDecimal)) {
                    this.writeByte((byte)57);
                    break;
                }
                int n5 = bigDecimal.scale();
                BigInteger bigInteger = bigDecimal.unscaledValue();
                int n6 = bigInteger.bitLength();
                if (n6 <= 63) {
                    if (n5 == 0) {
                        this.writeByte((byte)58);
                        this.writeVarLong(bigInteger.longValue());
                        break;
                    }
                    this.writeByte((byte)59);
                    this.writeVarInt(n5);
                    this.writeVarLong(bigInteger.longValue());
                    break;
                }
                this.writeByte((byte)n3);
                this.writeVarInt(n5);
                byte[] byArray = bigInteger.toByteArray();
                this.writeVarInt(byArray.length);
                this.write(byArray, 0, byArray.length);
                break;
            }
            case 9: {
                this.writeByte((byte)n3);
                this.writeVarLong(DateTimeUtils.getTimeLocal(value.getTimeNoCopy()));
                break;
            }
            case 10: {
                this.writeByte((byte)n3);
                long l3 = DateTimeUtils.getTimeLocal(value.getDateNoCopy());
                this.writeVarLong(l3 / 60000L);
                break;
            }
            case 11: {
                this.writeByte((byte)n3);
                Timestamp timestamp = value.getTimestampNoCopy();
                this.writeVarLong(DateTimeUtils.getTimeLocal(timestamp));
                this.writeVarInt(timestamp.getNanos());
                break;
            }
            case 19: {
                this.writeByte((byte)n3);
                byte[] byArray = value.getBytesNoCopy();
                this.writeVarInt(byArray.length);
                this.write(byArray, 0, byArray.length);
                break;
            }
            case 12: {
                byte[] byArray = value.getBytesNoCopy();
                int n7 = byArray.length;
                if (n7 < 32) {
                    this.writeByte((byte)(100 + n7));
                    this.write(byArray, 0, byArray.length);
                    break;
                }
                this.writeByte((byte)n3);
                this.writeVarInt(byArray.length);
                this.write(byArray, 0, byArray.length);
                break;
            }
            case 20: {
                this.writeByte((byte)n3);
                ValueUuid valueUuid = (ValueUuid)value;
                this.writeLong(valueUuid.getHigh());
                this.writeLong(valueUuid.getLow());
                break;
            }
            case 13: {
                String string = value.getString();
                int n8 = string.length();
                if (n8 < 32) {
                    this.writeByte((byte)(68 + n8));
                    this.if(string, n8);
                    break;
                }
                this.writeByte((byte)n3);
                this.writeString(string);
                break;
            }
            case 14: 
            case 21: {
                this.writeByte((byte)n3);
                this.writeString(value.getString());
                break;
            }
            case 7: {
                double d2 = value.getDouble();
                if (d2 == 0.0 || d2 == 1.0) {
                    this.writeByte((byte)(60.0 + d2));
                    break;
                }
                this.writeByte((byte)n3);
                this.writeVarLong(MathUtils.reverseLong(Double.doubleToLongBits(d2)));
                break;
            }
            case 8: {
                float f2 = value.getFloat();
                if (f2 == 0.0f || f2 == 1.0f) {
                    this.writeByte((byte)(62.0f + f2));
                    break;
                }
                this.writeByte((byte)n3);
                this.writeVarInt(MathUtils.reverseInt(Float.floatToIntBits(value.getFloat())));
                break;
            }
            case 15: 
            case 16: {
                this.writeByte((byte)n3);
                if (value instanceof ValueLob) {
                    ValueLob valueLob = (ValueLob)value;
                    valueLob.convertToFileIfRequired(this.do);
                    byte[] byArray = valueLob.getSmall();
                    if (byArray == null) {
                        int n9 = -1;
                        if (!valueLob.isLinked()) {
                            n9 = -2;
                        }
                        this.writeVarInt(n9);
                        this.writeVarInt(valueLob.getTableId());
                        this.writeVarInt(valueLob.getObjectId());
                        this.writeVarLong(valueLob.getPrecision());
                        this.writeByte((byte)(valueLob.useCompression() ? 1 : 0));
                        if (n9 != -2) break;
                        this.writeString(valueLob.getFileName());
                        break;
                    }
                    this.writeVarInt(byArray.length);
                    this.write(byArray, 0, byArray.length);
                    break;
                }
                ValueLobDb valueLobDb = (ValueLobDb)value;
                byte[] byArray = valueLobDb.getSmall();
                if (byArray == null) {
                    this.writeVarInt(-3);
                    this.writeVarInt(valueLobDb.getTableId());
                    this.writeVarLong(valueLobDb.getLobId());
                    this.writeVarLong(valueLobDb.getPrecision());
                    break;
                }
                this.writeVarInt(byArray.length);
                this.write(byArray, 0, byArray.length);
                break;
            }
            case 17: {
                this.writeByte((byte)n3);
                Value[] valueArray = ((ValueArray)value).getList();
                this.writeVarInt(valueArray.length);
                for (Value value2 : valueArray) {
                    this.writeValue(value2);
                }
                break;
            }
            default: {
                DbException.throwInternalError("type=" + value.getType());
            }
        }
        if (SysProperties.CHECK2 && this.int - n2 != Data.a(value, this.do)) {
            throw DbException.throwInternalError("value size error: got " + (this.int - n2) + " expected " + Data.a(value, this.do));
        }
    }

    public Value readValue() {
        int n2 = this.data[this.int++] & 0xFF;
        switch (n2) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 65: {
                return ValueBoolean.get(true);
            }
            case 64: {
                return ValueBoolean.get(false);
            }
            case 66: {
                return ValueInt.get(-this.readVarInt());
            }
            case 4: {
                return ValueInt.get(this.readVarInt());
            }
            case 67: {
                return ValueLong.get(-this.readVarLong());
            }
            case 5: {
                return ValueLong.get(this.readVarLong());
            }
            case 2: {
                return ValueByte.get(this.readByte());
            }
            case 3: {
                return ValueShort.get(this.readShortInt());
            }
            case 56: {
                return (ValueDecimal)ValueDecimal.ZERO;
            }
            case 57: {
                return (ValueDecimal)ValueDecimal.ONE;
            }
            case 58: {
                return ValueDecimal.get(BigDecimal.valueOf(this.readVarLong()));
            }
            case 59: {
                int n3 = this.readVarInt();
                return ValueDecimal.get(BigDecimal.valueOf(this.readVarLong(), n3));
            }
            case 6: {
                int n4 = this.readVarInt();
                int n5 = this.readVarInt();
                byte[] byArray = Utils.newBytes(n5);
                this.read(byArray, 0, n5);
                BigInteger bigInteger = new BigInteger(byArray);
                return ValueDecimal.get(new BigDecimal(bigInteger, n4));
            }
            case 10: {
                long l2 = this.readVarLong() * 60000L;
                return ValueDate.getNoCopy(new Date(DateTimeUtils.getTimeGMT(l2)));
            }
            case 9: {
                return ValueTime.get(new Time(DateTimeUtils.getTimeGMT(this.readVarLong())));
            }
            case 11: {
                Timestamp timestamp = new Timestamp(DateTimeUtils.getTimeGMT(this.readVarLong()));
                timestamp.setNanos(this.readVarInt());
                return ValueTimestamp.getNoCopy(timestamp);
            }
            case 12: {
                int n6 = this.readVarInt();
                byte[] byArray = Utils.newBytes(n6);
                this.read(byArray, 0, n6);
                return ValueBytes.getNoCopy(byArray);
            }
            case 19: {
                int n7 = this.readVarInt();
                byte[] byArray = Utils.newBytes(n7);
                this.read(byArray, 0, n7);
                return ValueJavaObject.getNoCopy(byArray);
            }
            case 20: {
                return ValueUuid.get(this.readLong(), this.readLong());
            }
            case 13: {
                return ValueString.get(this.readString());
            }
            case 14: {
                return ValueStringIgnoreCase.get(this.readString());
            }
            case 21: {
                return ValueStringFixed.get(this.readString());
            }
            case 62: {
                return ValueFloat.get(0.0f);
            }
            case 63: {
                return ValueFloat.get(1.0f);
            }
            case 60: {
                return ValueDouble.get(0.0);
            }
            case 61: {
                return ValueDouble.get(1.0);
            }
            case 7: {
                return ValueDouble.get(Double.longBitsToDouble(MathUtils.reverseLong(this.readVarLong())));
            }
            case 8: {
                return ValueFloat.get(Float.intBitsToFloat(MathUtils.reverseInt(this.readVarInt())));
            }
            case 15: 
            case 16: {
                int n8 = this.readVarInt();
                if (n8 >= 0) {
                    byte[] byArray = Utils.newBytes(n8);
                    this.read(byArray, 0, n8);
                    return LobStorage.createSmallLob(n2, byArray);
                }
                if (n8 == -3) {
                    int n9 = this.readVarInt();
                    long l3 = this.readVarLong();
                    long l4 = this.readVarLong();
                    LobStorage lobStorage = this.do.getLobStorage();
                    ValueLobDb valueLobDb = ValueLobDb.create(n2, lobStorage, null, n9, l3, l4);
                    return valueLobDb;
                }
                int n10 = this.readVarInt();
                int n11 = this.readVarInt();
                long l5 = 0L;
                boolean bl = false;
                if (n8 == -1 || n8 == -2) {
                    l5 = this.readVarLong();
                    bl = this.readByte() == 1;
                }
                ValueLob valueLob = ValueLob.open(n2, this.do, n10, n11, l5, bl);
                if (n8 == -2) {
                    valueLob.setFileName(this.readString(), false);
                }
                return valueLob;
            }
            case 17: {
                int n12 = this.readVarInt();
                Value[] valueArray = new Value[n12];
                for (int i2 = 0; i2 < n12; ++i2) {
                    valueArray[i2] = this.readValue();
                }
                return ValueArray.get(valueArray);
            }
        }
        if (n2 >= 32 && n2 < 48) {
            return ValueInt.get(n2 - 32);
        }
        if (n2 >= 48 && n2 < 56) {
            return ValueLong.get(n2 - 48);
        }
        if (n2 >= 100 && n2 < 132) {
            int n13 = n2 - 100;
            byte[] byArray = Utils.newBytes(n13);
            this.read(byArray, 0, n13);
            return ValueBytes.getNoCopy(byArray);
        }
        if (n2 >= 68 && n2 < 100) {
            return ValueString.get(this.do(n2 - 68));
        }
        throw DbException.get(90030, "type: " + n2);
    }

    public int getValueLen(Value value) {
        return Data.a(value, this.do);
    }

    private static int a(Value value, DataHandler dataHandler) {
        if (value == ValueNull.INSTANCE) {
            return 1;
        }
        switch (value.getType()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                int n2 = value.getInt();
                if (n2 < 0) {
                    return 1 + Data.getVarIntLen(-n2);
                }
                if (n2 < 16) {
                    return 1;
                }
                return 1 + Data.getVarIntLen(n2);
            }
            case 5: {
                long l2 = value.getLong();
                if (l2 < 0L) {
                    return 1 + Data.getVarLongLen(-l2);
                }
                if (l2 < 8L) {
                    return 1;
                }
                return 1 + Data.getVarLongLen(l2);
            }
            case 7: {
                double d2 = value.getDouble();
                if (d2 == 0.0 || d2 == 1.0) {
                    return 1;
                }
                return 1 + Data.getVarLongLen(MathUtils.reverseLong(Double.doubleToLongBits(d2)));
            }
            case 8: {
                float f2 = value.getFloat();
                if (f2 == 0.0f || f2 == 1.0f) {
                    return 1;
                }
                return 1 + Data.getVarIntLen(MathUtils.reverseInt(Float.floatToIntBits(value.getFloat())));
            }
            case 13: {
                String string = value.getString();
                int n3 = string.length();
                if (n3 < 32) {
                    return 1 + Data.a(string, n3);
                }
                return 1 + Data.getStringLen(string);
            }
            case 14: 
            case 21: {
                return 1 + Data.getStringLen(value.getString());
            }
            case 6: {
                BigDecimal bigDecimal = value.getBigDecimal();
                if (BigDecimal.ZERO.equals(bigDecimal)) {
                    return 1;
                }
                if (BigDecimal.ONE.equals(bigDecimal)) {
                    return 1;
                }
                int n4 = bigDecimal.scale();
                BigInteger bigInteger = bigDecimal.unscaledValue();
                int n5 = bigInteger.bitLength();
                if (n5 <= 63) {
                    if (n4 == 0) {
                        return 1 + Data.getVarLongLen(bigInteger.longValue());
                    }
                    return 1 + Data.getVarIntLen(n4) + Data.getVarLongLen(bigInteger.longValue());
                }
                byte[] byArray = bigInteger.toByteArray();
                return 1 + Data.getVarIntLen(n4) + Data.getVarIntLen(byArray.length) + byArray.length;
            }
            case 9: {
                return 1 + Data.getVarLongLen(DateTimeUtils.getTimeLocal(value.getTimeNoCopy()));
            }
            case 10: {
                long l3 = DateTimeUtils.getTimeLocal(value.getDateNoCopy());
                return 1 + Data.getVarLongLen(l3 / 60000L);
            }
            case 11: {
                Timestamp timestamp = value.getTimestampNoCopy();
                return 1 + Data.getVarLongLen(DateTimeUtils.getTimeLocal(timestamp)) + Data.getVarIntLen(timestamp.getNanos());
            }
            case 19: {
                byte[] byArray = value.getBytesNoCopy();
                return 1 + Data.getVarIntLen(byArray.length) + byArray.length;
            }
            case 12: {
                byte[] byArray = value.getBytesNoCopy();
                int n6 = byArray.length;
                if (n6 < 32) {
                    return 1 + byArray.length;
                }
                return 1 + Data.getVarIntLen(byArray.length) + byArray.length;
            }
            case 20: {
                return 17;
            }
            case 15: 
            case 16: {
                int n7 = 1;
                if (value instanceof ValueLob) {
                    ValueLob valueLob = (ValueLob)value;
                    valueLob.convertToFileIfRequired(dataHandler);
                    byte[] byArray = valueLob.getSmall();
                    if (byArray == null) {
                        int n8 = -1;
                        if (!valueLob.isLinked()) {
                            n8 = -2;
                        }
                        n7 += Data.getVarIntLen(n8);
                        n7 += Data.getVarIntLen(valueLob.getTableId());
                        n7 += Data.getVarIntLen(valueLob.getObjectId());
                        n7 += Data.getVarLongLen(valueLob.getPrecision());
                        ++n7;
                        if (n8 == -2) {
                            n7 += Data.getStringLen(valueLob.getFileName());
                        }
                    } else {
                        n7 += Data.getVarIntLen(byArray.length);
                        n7 += byArray.length;
                    }
                } else {
                    ValueLobDb valueLobDb = (ValueLobDb)value;
                    byte[] byArray = valueLobDb.getSmall();
                    if (byArray == null) {
                        n7 += Data.getVarIntLen(-3);
                        n7 += Data.getVarIntLen(valueLobDb.getTableId());
                        n7 += Data.getVarLongLen(valueLobDb.getLobId());
                        n7 += Data.getVarLongLen(valueLobDb.getPrecision());
                    } else {
                        n7 += Data.getVarIntLen(byArray.length);
                        n7 += byArray.length;
                    }
                }
                return n7;
            }
            case 17: {
                Value[] valueArray = ((ValueArray)value).getList();
                int n9 = 1 + Data.getVarIntLen(valueArray.length);
                for (Value value2 : valueArray) {
                    n9 += Data.a(value2, dataHandler);
                }
                return n9;
            }
        }
        throw DbException.throwInternalError("type=" + value.getType());
    }

    public void setPos(int n2) {
        this.int = n2;
    }

    public void writeShortInt(int n2) {
        byte[] byArray = this.data;
        byArray[this.int++] = (byte)(n2 >> 8);
        byArray[this.int++] = (byte)n2;
    }

    public short readShortInt() {
        byte[] byArray = this.data;
        return (short)(((byArray[this.int++] & 0xFF) << 8) + (byArray[this.int++] & 0xFF));
    }

    public void truncate(int n2) {
        if (this.int > n2) {
            byte[] byArray = new byte[n2];
            System.arraycopy(this.data, 0, byArray, 0, n2);
            this.int = n2;
            this.data = byArray;
        }
    }

    public static int getVarIntLen(int n2) {
        if ((n2 & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n2 & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n2 & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n2 & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void writeVarInt(int n2) {
        while ((n2 & 0xFFFFFF80) != 0) {
            this.data[this.int++] = (byte)(0x80 | n2 & 0x7F);
            n2 >>>= 7;
        }
        this.data[this.int++] = (byte)n2;
    }

    public int readVarInt() {
        byte by = this.data[this.int];
        if (by >= 0) {
            ++this.int;
            return by;
        }
        return this.if(by);
    }

    private int if(int n2) {
        int n3 = n2 & 0x7F;
        n2 = this.data[this.int + 1];
        if (n2 >= 0) {
            this.int += 2;
            return n3 | n2 << 7;
        }
        n3 |= (n2 & 0x7F) << 7;
        n2 = this.data[this.int + 2];
        if (n2 >= 0) {
            this.int += 3;
            return n3 | n2 << 14;
        }
        n3 |= (n2 & 0x7F) << 14;
        n2 = this.data[this.int + 3];
        if (n2 >= 0) {
            this.int += 4;
            return n3 | n2 << 21;
        }
        this.int += 5;
        return n3 |= (n2 & 0x7F) << 21 | this.data[this.int + 4] << 28;
    }

    public static int getVarLongLen(long l2) {
        int n2 = 1;
        while ((l2 >>>= 7) != 0L) {
            ++n2;
        }
        return n2;
    }

    public void writeVarLong(long l2) {
        while ((l2 & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.data[this.int++] = (byte)(l2 & 0x7FL | 0x80L);
            l2 >>>= 7;
        }
        this.data[this.int++] = (byte)l2;
    }

    public long readVarLong() {
        long l2;
        if ((l2 = (long)this.data[this.int++]) >= 0L) {
            return l2;
        }
        l2 &= 0x7FL;
        int n2 = 7;
        while (true) {
            long l3 = this.data[this.int++];
            l2 |= (l3 & 0x7FL) << n2;
            if (l3 >= 0L) {
                return l2;
            }
            n2 += 7;
        }
    }

    public void checkCapacity(int n2) {
        if (this.int + n2 >= this.data.length) {
            this.a(n2);
        }
    }

    private void a(int n2) {
        byte[] byArray = Utils.newBytes((this.data.length + n2) * 2);
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        this.data = byArray;
    }

    public void fillAligned() {
        int n2;
        this.int = n2 = MathUtils.roundUpInt(this.int + 2, 16);
        if (this.data.length < n2) {
            this.checkCapacity(n2 - this.data.length);
        }
    }
}

