/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.store.fs.FileSystem;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.SortedProperties;
import org.h2.util.StringUtils;
import org.h2.value.Transfer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileLock
implements Runnable {
    public static final int LOCK_NO = 0;
    public static final int LOCK_FILE = 1;
    public static final int LOCK_SOCKET = 2;
    public static final int LOCK_SERIALIZED = 3;
    public static final int LOCK_FS = 4;
    private static final String b = "FileLock";
    private static final String do = "file";
    private static final String e = "socket";
    private static final String for = "serialized";
    private static final int case = 16;
    private static final int byte = 25;
    private static final int char = 2000;
    private volatile String f;
    private volatile ServerSocket a;
    private FileSystem int;
    private int d;
    private Trace long;
    private long new;
    private String if;
    private String goto;
    private Properties try;
    private boolean c;
    private String else;
    private Thread void;

    public FileLock(TraceSystem traceSystem, String string, int n2) {
        this.long = traceSystem.getTrace("fileLock");
        this.f = string;
        this.d = n2;
    }

    public synchronized void lock(int n2) {
        this.int = FileSystem.getInstance(this.f);
        this.for();
        if (this.c) {
            DbException.throwInternalError("already locked");
        }
        switch (n2) {
            case 1: {
                this.a();
                break;
            }
            case 2: {
                this.if();
                break;
            }
            case 3: {
                this.do();
                break;
            }
        }
        this.c = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unlock() {
        if (!this.c) {
            return;
        }
        try {
            if (this.f != null && this.load().equals(this.try)) {
                this.int.delete(this.f);
            }
            if (this.a != null) {
                this.a.close();
            }
        }
        catch (Exception exception) {
            this.long.debug(exception, "unlock");
        }
        finally {
            this.f = null;
            this.a = null;
            this.c = false;
        }
        try {
            if (this.void != null) {
                this.void.interrupt();
            }
        }
        catch (Exception exception) {
            this.long.debug(exception, "unlock");
        }
    }

    public void setProperty(String string, String string2) {
        if (string2 == null) {
            this.try.remove(string);
        } else {
            this.try.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties save() {
        try {
            OutputStream outputStream = this.int.openFileOutputStream(this.f, false);
            try {
                this.try.store(outputStream, b);
            }
            finally {
                outputStream.close();
            }
            this.new = this.int.getLastModified(this.f);
            if (this.long.isDebugEnabled()) {
                this.long.debug("save {0}", this.try);
            }
            return this.try;
        }
        catch (IOException iOException) {
            throw this.a("Could not save properties " + this.f, iOException);
        }
    }

    private void for() {
        Object object;
        Properties properties = this.load();
        String string = properties.getProperty("server");
        if (string == null) {
            return;
        }
        boolean bl = false;
        String string2 = properties.getProperty("id");
        try {
            object = NetUtils.createSocket(string, 9092, false);
            Transfer transfer = new Transfer(null);
            transfer.setSocket((Socket)object);
            transfer.init();
            transfer.writeInt(6);
            transfer.writeInt(8);
            transfer.writeString(null);
            transfer.writeString(null);
            transfer.writeString(string2);
            transfer.writeInt(14);
            transfer.flush();
            int n2 = transfer.readInt();
            if (n2 == 1) {
                bl = true;
            }
            transfer.close();
            ((Socket)object).close();
        }
        catch (IOException iOException) {
            return;
        }
        if (bl) {
            object = DbException.get(90020, "Server is running");
            throw ((DbException)object).addSQL(string + "/" + string2);
        }
    }

    public Properties load() {
        try {
            SortedProperties sortedProperties = SortedProperties.loadProperties(this.f);
            if (this.long.isDebugEnabled()) {
                this.long.debug("load {0}", sortedProperties);
            }
            return sortedProperties;
        }
        catch (IOException iOException) {
            throw this.a("Could not load properties " + this.f, iOException);
        }
    }

    private void int() {
        for (int i2 = 0; i2 < 160; ++i2) {
            long l2 = this.int.getLastModified(this.f);
            long l3 = System.currentTimeMillis() - l2;
            if (l3 < -2000L) {
                try {
                    Thread.sleep(2L * (long)this.d);
                }
                catch (Exception exception) {
                    this.long.debug(exception, "sleep");
                }
                return;
            }
            if (l3 > 2000L) {
                return;
            }
            try {
                Thread.sleep(25L);
                continue;
            }
            catch (Exception exception) {
                this.long.debug(exception, "sleep");
            }
        }
        throw this.a("Lock file recently modified", null);
    }

    private void new() {
        byte[] byArray = MathUtils.secureRandomBytes(16);
        String string = StringUtils.convertBytesToString(byArray);
        this.else = Long.toHexString(System.currentTimeMillis()) + string;
        this.try.setProperty("id", this.else);
    }

    private void do() {
        this.if = for;
        this.int.createDirs(this.f);
        if (!this.int.createNewFile(this.f)) {
            try {
                this.try = this.load();
            }
            catch (DbException dbException) {
                // empty catch block
            }
            return;
        }
        this.try = new SortedProperties();
        this.try.setProperty("method", String.valueOf(this.if));
        this.new();
        this.save();
    }

    private void a() {
        this.if = do;
        this.try = new SortedProperties();
        this.try.setProperty("method", String.valueOf(this.if));
        this.new();
        this.int.createDirs(this.f);
        if (!this.int.createNewFile(this.f)) {
            this.int();
            String string = this.load().getProperty("method", do);
            if (!string.equals(do)) {
                throw this.a("Unsupported lock method " + string, null);
            }
            this.save();
            this.a(2 * this.d);
            if (!this.load().equals(this.try)) {
                throw this.a("Locked by another process");
            }
            this.int.delete(this.f);
            if (!this.int.createNewFile(this.f)) {
                throw this.a("Another process was faster", null);
            }
        }
        this.save();
        this.a(25);
        if (!this.load().equals(this.try)) {
            this.f = null;
            throw this.a("Concurrent update", null);
        }
        this.void = new Thread(this);
        this.void.setName("H2 File Lock Watchdog " + this.f);
        this.void.setDaemon(true);
        this.void.setPriority(9);
        this.void.start();
    }

    private void if() {
        this.if = e;
        this.try = new SortedProperties();
        this.try.setProperty("method", String.valueOf(this.if));
        this.new();
        this.goto = NetUtils.getLocalAddress();
        this.int.createDirs(this.f);
        if (!this.int.createNewFile(this.f)) {
            InetAddress inetAddress;
            this.int();
            long l2 = this.int.getLastModified(this.f);
            Properties properties = this.load();
            String string = properties.getProperty("method", e);
            if (string.equals(do)) {
                this.a();
                return;
            }
            if (!string.equals(e)) {
                throw this.a("Unsupported lock method " + string, null);
            }
            String string2 = properties.getProperty("ipAddress", this.goto);
            if (!this.goto.equals(string2)) {
                throw this.a("Locked by another computer: " + string2);
            }
            String string3 = properties.getProperty("port", "0");
            int n2 = Integer.parseInt(string3);
            try {
                inetAddress = InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {
                throw this.a("Unknown host " + string2, unknownHostException);
            }
            for (int i2 = 0; i2 < 3; ++i2) {
                try {
                    Socket socket = new Socket(inetAddress, n2);
                    socket.close();
                    throw this.a("Locked by another process");
                }
                catch (BindException bindException) {
                    throw this.a("Bind Exception", null);
                }
                catch (ConnectException connectException) {
                    this.long.debug(connectException, "socket not connected to port " + string3);
                    continue;
                }
                catch (IOException iOException) {
                    throw this.a("IOException", null);
                }
            }
            if (l2 != this.int.getLastModified(this.f)) {
                throw this.a("Concurrent update", null);
            }
            this.int.delete(this.f);
            if (!this.int.createNewFile(this.f)) {
                throw this.a("Another process was faster", null);
            }
        }
        try {
            this.a = NetUtils.createServerSocket(0, false);
            int n3 = this.a.getLocalPort();
            this.try.setProperty("ipAddress", this.goto);
            this.try.setProperty("port", String.valueOf(n3));
        }
        catch (Exception exception) {
            this.long.debug(exception, "lock");
            this.a = null;
            this.a();
            return;
        }
        this.save();
        this.void = new Thread(this);
        this.void.setDaemon(true);
        this.void.setName("H2 File Lock Watchdog (Socket) " + this.f);
        this.void.start();
    }

    private void a(int n2) {
        try {
            Thread.sleep(n2);
        }
        catch (InterruptedException interruptedException) {
            throw this.a("Sleep interrupted", interruptedException);
        }
    }

    private DbException a(String string, Throwable throwable) {
        return DbException.get(8000, throwable, string);
    }

    private DbException a(String string) {
        DbException dbException = DbException.get(90020, string);
        if (this.f != null) {
            try {
                Properties properties = this.load();
                String string2 = properties.getProperty("server") + "/" + properties.getProperty("id");
                dbException = dbException.addSQL(string2);
            }
            catch (DbException dbException2) {
                // empty catch block
            }
        }
        return dbException;
    }

    public static int getFileLockMethod(String string) {
        if (string == null || string.equalsIgnoreCase("FILE")) {
            return 1;
        }
        if (string.equalsIgnoreCase("NO")) {
            return 0;
        }
        if (string.equalsIgnoreCase("SOCKET")) {
            return 2;
        }
        if (string.equalsIgnoreCase("SERIALIZED")) {
            return 3;
        }
        if (string.equalsIgnoreCase("FS")) {
            return 4;
        }
        throw DbException.get(90060, string);
    }

    public String getUniqueId() {
        return this.else;
    }

    public void run() {
        try {
            while (this.f != null) {
                try {
                    if (!this.int.exists(this.f) || this.int.getLastModified(this.f) != this.new) {
                        this.save();
                    }
                    Thread.sleep(this.d);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                }
                catch (InterruptedException interruptedException) {
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (Exception exception) {
                    this.long.debug(exception, "watchdog");
                }
            }
            while (this.a != null) {
                try {
                    this.long.debug("watchdog accept");
                    Socket socket = this.a.accept();
                    socket.close();
                }
                catch (Exception exception) {
                    this.long.debug(exception, "watchdog");
                }
            }
        }
        catch (Exception exception) {
            this.long.debug(exception, "watchdog");
        }
        this.long.debug("watchdog end");
    }
}

