/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.lang.ref.Reference;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.security.SecureFileStore;
import org.h2.store.DataHandler;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileSystem;
import org.h2.util.TempFileDeleter;
import org.h2.util.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileStore {
    public static final int HEADER_LENGTH = 48;
    protected static byte[] empty;
    private static final String a;
    protected String name;
    protected DataHandler handler;
    private FileObject do;
    private long try;
    private long char;
    private Reference case;
    private boolean for = true;
    private boolean byte;
    private String int;
    private TempFileDeleter if;
    private boolean new;

    protected FileStore(DataHandler dataHandler, String string, String string2) {
        FileSystem fileSystem = FileSystem.getInstance(string);
        this.handler = dataHandler;
        this.name = string;
        this.int = string2;
        if (dataHandler != null) {
            this.if = dataHandler.getTempFileDeleter();
        }
        try {
            boolean bl = fileSystem.exists(string);
            if (bl && !fileSystem.canWrite(string)) {
                this.int = string2 = "r";
            } else {
                fileSystem.createDirs(string);
            }
            this.do = fileSystem.openFileObject(string, string2);
            if (string2.length() > 2) {
                this.byte = true;
            }
            if (bl) {
                this.char = this.do.length();
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, "name: " + string + " mode: " + string2);
        }
    }

    public static FileStore open(DataHandler dataHandler, String string, String string2) {
        return FileStore.open(dataHandler, string, string2, null, null, 0);
    }

    public static FileStore open(DataHandler dataHandler, String string, String string2, String string3, byte[] byArray) {
        return FileStore.open(dataHandler, string, string2, string3, byArray, 1024);
    }

    public static FileStore open(DataHandler dataHandler, String string, String string2, String string3, byte[] byArray, int n2) {
        FileStore fileStore = string3 == null ? new FileStore(dataHandler, string, string2) : new SecureFileStore(dataHandler, string, string2, string3, byArray, n2);
        return fileStore;
    }

    protected byte[] generateSalt() {
        return a.getBytes();
    }

    protected void initKey(byte[] byArray) {
    }

    public void setCheckedWriting(boolean bl) {
        this.for = bl;
    }

    private void a() {
        if (this.handler != null && this.for) {
            this.handler.checkWritingAllowed();
        }
    }

    private void if() {
        if (this.handler != null) {
            this.handler.checkPowerOff();
        }
    }

    public void init() {
        int n2 = 16;
        byte[] byArray = a.getBytes();
        if (this.length() < 48L) {
            this.for = false;
            this.writeDirect(byArray, 0, n2);
            byte[] byArray2 = this.generateSalt();
            this.writeDirect(byArray2, 0, n2);
            this.initKey(byArray2);
            this.write(byArray, 0, n2);
            this.for = true;
        } else {
            this.seek(0L);
            byte[] byArray3 = new byte[n2];
            this.readFullyDirect(byArray3, 0, n2);
            if (Utils.compareNotNull(byArray3, byArray) != 0) {
                throw DbException.get(90048, this.name);
            }
            byte[] byArray4 = new byte[n2];
            this.readFullyDirect(byArray4, 0, n2);
            this.initKey(byArray4);
            this.readFully(byArray3, 0, 16);
            if (this.new) {
                byArray3[10] = 66;
            }
            if (Utils.compareNotNull(byArray3, byArray) != 0) {
                throw DbException.get(90049, this.name);
            }
        }
    }

    public void close() {
        if (this.do != null) {
            try {
                FileStore.a("close", this.name, this.do);
                this.do.close();
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, this.name);
            }
            finally {
                this.do = null;
            }
        }
    }

    public void closeSilently() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeAndDeleteSilently() {
        if (this.do != null) {
            this.closeSilently();
            this.if.deleteFile(this.case, this.name);
            this.name = null;
        }
    }

    protected void readFullyDirect(byte[] byArray, int n2, int n3) {
        this.readFully(byArray, n2, n3);
    }

    public void readFully(byte[] byArray, int n2, int n3) {
        if (SysProperties.CHECK && (n3 < 0 || n3 % 16 != 0)) {
            DbException.throwInternalError("unaligned read " + this.name + " len " + n3);
        }
        this.if();
        try {
            this.do.readFully(byArray, n2, n3);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.name);
        }
        this.try += (long)n3;
    }

    public void seek(long l2) {
        if (SysProperties.CHECK && l2 % 16L != 0L) {
            DbException.throwInternalError("unaligned seek " + this.name + " pos " + l2);
        }
        try {
            if (l2 != this.try) {
                this.do.seek(l2);
                this.try = l2;
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.name);
        }
    }

    protected void writeDirect(byte[] byArray, int n2, int n3) {
        this.write(byArray, n2, n3);
    }

    public void write(byte[] byArray, int n2, int n3) {
        if (SysProperties.CHECK && (n3 < 0 || n3 % 16 != 0)) {
            DbException.throwInternalError("unaligned write " + this.name + " len " + n3);
        }
        this.a();
        this.if();
        try {
            this.do.write(byArray, n2, n3);
        }
        catch (IOException iOException) {
            if (this.do()) {
                try {
                    this.do.write(byArray, n2, n3);
                }
                catch (IOException iOException2) {
                    throw DbException.convertIOException(iOException2, this.name);
                }
            }
            throw DbException.convertIOException(iOException, this.name);
        }
        this.try += (long)n3;
        this.char = Math.max(this.try, this.char);
    }

    private boolean do() {
        if (this.handler == null) {
            return false;
        }
        this.handler.freeUpDiskSpace();
        return true;
    }

    private void a(long l2) throws IOException {
        int n2;
        long l3 = this.try;
        this.do.seek(this.char);
        if (empty == null) {
            empty = new byte[16384];
        }
        byte[] byArray = empty;
        while ((n2 = (int)Math.min(l2 - this.char, (long)byArray.length)) > 0) {
            this.do.write(byArray, 0, n2);
            this.char += (long)n2;
        }
        this.do.seek(l3);
    }

    public void setLength(long l2) {
        if (SysProperties.CHECK && l2 % 16L != 0L) {
            DbException.throwInternalError("unaligned setLength " + this.name + " pos " + l2);
        }
        this.if();
        this.a();
        try {
            if (this.byte && l2 > this.char) {
                this.a(l2);
            } else {
                this.do.setFileLength(l2);
            }
            this.char = l2;
        }
        catch (IOException iOException) {
            if (l2 > this.char && this.do()) {
                try {
                    this.do.setFileLength(l2);
                }
                catch (IOException iOException2) {
                    throw DbException.convertIOException(iOException2, this.name);
                }
            }
            throw DbException.convertIOException(iOException, this.name);
        }
    }

    public long length() {
        try {
            long l2 = this.char;
            if (SysProperties.CHECK2 && (l2 = this.do.length()) != this.char) {
                DbException.throwInternalError("file " + this.name + " length " + l2 + " expected " + this.char);
            }
            if (SysProperties.CHECK2 && l2 % 16L != 0L) {
                long l3 = l2 + 16L - l2 % 16L;
                this.do.setFileLength(l3);
                this.char = l3;
                DbException.throwInternalError("unaligned file length " + this.name + " len " + l2);
            }
            return l2;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.name);
        }
    }

    public long getFilePointer() {
        if (SysProperties.CHECK2) {
            try {
                if (this.do.getFilePointer() != this.try) {
                    DbException.throwInternalError();
                }
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, this.name);
            }
        }
        return this.try;
    }

    public void sync() {
        try {
            this.do.sync();
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.name);
        }
    }

    public void autoDelete() {
        if (this.case == null) {
            this.case = this.if.addFile(this.name, this);
        }
    }

    public void stopAutoDelete() {
        this.if.stopAutoDelete(this.case, this.name);
        this.case = null;
    }

    public void closeFile() throws IOException {
        this.do.close();
        this.do = null;
    }

    public void openFile() throws IOException {
        if (this.do == null) {
            this.do = FileSystem.getInstance(this.name).openFileObject(this.name, this.int);
            this.do.seek(this.try);
        }
    }

    private static void a(String string, String string2, Object object) {
        if (SysProperties.TRACE_IO) {
            System.out.println("FileStore." + string + " " + string2 + " " + object);
        }
    }

    public boolean isTextMode() {
        return this.new;
    }

    public boolean tryLock() {
        return this.do.tryLock();
    }

    public void releaseLock() {
        this.do.releaseLock();
    }

    static {
        a = "-- H2 0.5/B --      ".substring(0, 15) + "\n";
    }
}

