/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.tools.CompressTool;
import org.h2.util.IOUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueLobDb;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LobStorage {
    public static final int TABLE_ID_SESSION_VARIABLE = -1;
    public static final int TABLE_TEMP = -2;
    public static final String LOB_DATA_TABLE = "LOB_DATA";
    private static final String for = "INFORMATION_SCHEMA";
    private static final String case = "INFORMATION_SCHEMA.LOBS";
    private static final String try = "INFORMATION_SCHEMA.LOB_MAP";
    private static final String new = "INFORMATION_SCHEMA.LOB_DATA";
    private static final int goto = 20000;
    private static final int int = 4096;
    private Connection if;
    private HashMap long = New.hashMap();
    private long a;
    private CompressTool do = CompressTool.getInstance();
    private long[] byte = new long[8192];
    private final DataHandler else;
    private boolean char;

    public LobStorage(DataHandler dataHandler) {
        this.else = dataHandler;
    }

    public void init() {
        if (this.char) {
            return;
        }
        this.if = this.else.getLobConnection();
        this.char = true;
        if (this.if == null) {
            return;
        }
        try {
            Statement statement = this.if.createStatement();
            statement.execute("CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOBS(ID BIGINT PRIMARY KEY, BYTE_COUNT BIGINT, TABLE INT) HIDDEN");
            statement.execute("CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOB_MAP(LOB BIGINT, SEQ INT, HASH INT, BLOCK BIGINT, PRIMARY KEY(LOB, SEQ)) HIDDEN");
            statement.execute("CREATE INDEX IF NOT EXISTS INFORMATION_SCHEMA.INDEX_LOB_MAP_DATA_LOB ON INFORMATION_SCHEMA.LOB_MAP(BLOCK, LOB)");
            statement.execute("CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOB_DATA(BLOCK BIGINT PRIMARY KEY, COMPRESSED INT, DATA BINARY) HIDDEN");
            ResultSet resultSet = statement.executeQuery("SELECT MAX(BLOCK) FROM INFORMATION_SCHEMA.LOB_DATA");
            resultSet.next();
            this.a = resultSet.getLong(1) + 1L;
            statement.close();
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    private long a() throws SQLException {
        PreparedStatement preparedStatement = this.a("SELECT MAX(ID) FROM INFORMATION_SCHEMA.LOBS");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        return resultSet.getLong(1) + 1L;
    }

    public void removeAllForTable(int n2) {
        if (SysProperties.LOB_IN_DATABASE) {
            this.init();
            try {
                PreparedStatement preparedStatement = this.a("SELECT ID FROM INFORMATION_SCHEMA.LOBS WHERE TABLE = ?");
                preparedStatement.setInt(1, n2);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    this.a(resultSet.getLong(1));
                }
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
            if (n2 == -1) {
                this.removeAllForTable(-2);
            }
        }
        ValueLob.removeAllForTable(this.else, n2);
    }

    public static Value createSmallLob(int n2, byte[] byArray) {
        if (SysProperties.LOB_IN_DATABASE) {
            int n3 = n2 == 16 ? StringUtils.utf8Decode(byArray).length() : byArray.length;
            return ValueLobDb.createSmallLob(n2, byArray, n3);
        }
        return ValueLob.createSmallLob(n2, byArray);
    }

    private synchronized PreparedStatement a(String string) throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)this.long.get(string);
        if (preparedStatement == null) {
            preparedStatement = this.if.prepareStatement(string);
            this.long.put(string, preparedStatement);
        }
        return preparedStatement;
    }

    private void a(long l2) throws SQLException {
        PreparedStatement preparedStatement = this.a("SELECT BLOCK, HASH FROM INFORMATION_SCHEMA.LOB_MAP D WHERE D.LOB = ? AND NOT EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.LOB_MAP O WHERE O.BLOCK = D.BLOCK AND O.LOB <> ?)");
        preparedStatement.setLong(1, l2);
        preparedStatement.setLong(2, l2);
        ResultSet resultSet = preparedStatement.executeQuery();
        preparedStatement = this.a("DELETE FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ?");
        preparedStatement.setLong(1, l2);
        preparedStatement.execute();
        while (resultSet.next()) {
            long l3 = resultSet.getLong(1);
            int n2 = resultSet.getInt(2);
            this.a(n2, -1L);
            preparedStatement = this.a("DELETE FROM INFORMATION_SCHEMA.LOB_DATA WHERE BLOCK = ?");
            preparedStatement.setLong(1, l3);
            preparedStatement.execute();
        }
        preparedStatement = this.a("DELETE FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?");
        preparedStatement.setLong(1, l2);
        preparedStatement.execute();
    }

    public InputStream getInputStream(long l2) throws IOException {
        this.init();
        return new LobInputStream(this.if, l2);
    }

    private ValueLobDb a(InputStream inputStream, long l2, int n2) {
        byte[] byArray = new byte[20000];
        if (l2 < 0L) {
            l2 = Long.MAX_VALUE;
        }
        long l3 = 0L;
        int n3 = this.else.getMaxLengthInplaceLob();
        String string = this.else.getLobCompressionAlgorithm(n2);
        try {
            long l4 = this.a();
            try {
                int n4 = 0;
                while (l2 > 0L) {
                    byte[] byArray2;
                    int n5 = (int)Math.min(20000L, l2);
                    if ((n5 = IOUtils.readFully(inputStream, byArray, 0, n5)) <= 0) break;
                    l3 += (long)n5;
                    l2 -= (long)n5;
                    if (n5 != byArray.length) {
                        byArray2 = new byte[n5];
                        System.arraycopy(byArray, 0, byArray2, 0, n5);
                    } else {
                        byArray2 = byArray;
                    }
                    if (n4 == 0 && byArray2.length < 20000 && byArray2.length <= n3) {
                        ValueLobDb valueLobDb = ValueLobDb.createSmallLob(n2, byArray2, byArray2.length);
                        return valueLobDb;
                    }
                    this.storeBlock(l4, n4, byArray2, string);
                    ++n4;
                }
                return this.a(n2, l4, -2, l3);
            }
            catch (IOException iOException) {
                this.a(l4);
                throw DbException.convertIOException(iOException, "adding blob");
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    private ValueLobDb a(int n2, long l2, int n3, long l3) {
        try {
            PreparedStatement preparedStatement = this.a("INSERT INTO INFORMATION_SCHEMA.LOBS(ID, BYTE_COUNT, TABLE) VALUES(?, ?, ?)");
            preparedStatement.setLong(1, l2);
            preparedStatement.setLong(2, l3);
            preparedStatement.setInt(3, n3);
            preparedStatement.execute();
            ValueLobDb valueLobDb = ValueLobDb.create(n2, this, null, n3, l2, l3);
            return valueLobDb;
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    public ValueLobDb copyLob(int n2, long l2, int n3, long l3) {
        try {
            this.init();
            long l4 = this.a();
            PreparedStatement preparedStatement = this.a("INSERT INTO INFORMATION_SCHEMA.LOB_MAP(LOB, SEQ, HASH, BLOCK) SELECT ?, SEQ, HASH, BLOCK FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ?");
            preparedStatement.setLong(1, l4);
            preparedStatement.setLong(2, l2);
            preparedStatement.executeUpdate();
            preparedStatement = this.a("INSERT INTO INFORMATION_SCHEMA.LOBS(ID, BYTE_COUNT, TABLE) SELECT ?, BYTE_COUNT, ? FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?");
            preparedStatement.setLong(1, l4);
            preparedStatement.setLong(2, n3);
            preparedStatement.setLong(3, l2);
            preparedStatement.executeUpdate();
            ValueLobDb valueLobDb = ValueLobDb.create(n2, this, null, n3, l4, l3);
            return valueLobDb;
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    private long a(int n2) {
        int n3 = n2 & 0xFFF;
        long l2 = this.byte[n3];
        if (l2 == (long)n2) {
            return this.byte[n3 + 4096];
        }
        return -1L;
    }

    private void a(int n2, long l2) {
        int n3 = n2 & 0xFFF;
        this.byte[n3] = n2;
        this.byte[n3 + 4096] = l2;
    }

    synchronized void storeBlock(long l2, int n2, byte[] byArray, String string) throws SQLException {
        PreparedStatement preparedStatement;
        int n3;
        long l3;
        boolean bl = false;
        if (string != null) {
            byArray = this.do.compress(byArray, string);
        }
        if ((l3 = this.a(n3 = Arrays.hashCode(byArray))) != -1L) {
            preparedStatement = this.a("SELECT COMPRESSED, DATA FROM INFORMATION_SCHEMA.LOB_DATA WHERE BLOCK = ?");
            preparedStatement.setLong(1, l3);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                boolean bl2 = resultSet.getInt(1) != 0;
                byte[] byArray2 = resultSet.getBytes(2);
                if (bl2 == (string != null) && Arrays.equals(byArray, byArray2)) {
                    bl = true;
                }
            }
        }
        if (!bl) {
            l3 = this.a++;
            this.a(n3, l3);
            preparedStatement = this.a("INSERT INTO INFORMATION_SCHEMA.LOB_DATA(BLOCK, COMPRESSED, DATA) VALUES(?, ?, ?)");
            preparedStatement.setLong(1, l3);
            preparedStatement.setInt(2, string == null ? 0 : 1);
            preparedStatement.setBytes(3, byArray);
            preparedStatement.execute();
        }
        preparedStatement = this.a("INSERT INTO INFORMATION_SCHEMA.LOB_MAP(LOB, SEQ, HASH, BLOCK) VALUES(?, ?, ?, ?)");
        preparedStatement.setLong(1, l2);
        preparedStatement.setInt(2, n2);
        preparedStatement.setLong(3, n3);
        preparedStatement.setLong(4, l3);
        preparedStatement.execute();
    }

    public Value createBlob(InputStream inputStream, long l2) {
        if (SysProperties.LOB_IN_DATABASE) {
            this.init();
            if (this.if == null) {
                return ValueLobDb.createTempBlob(inputStream, l2, this.else);
            }
            return this.a(inputStream, l2, 15);
        }
        return ValueLob.createBlob(inputStream, l2, this.else);
    }

    public Value createClob(Reader reader, long l2) {
        if (SysProperties.LOB_IN_DATABASE) {
            this.init();
            if (this.if == null) {
                return ValueLobDb.createTempClob(reader, l2, this.else);
            }
            long l3 = l2 == -1L ? Long.MAX_VALUE : l2;
            CountingReaderInputStream countingReaderInputStream = new CountingReaderInputStream(reader, l3);
            ValueLobDb valueLobDb = this.a(countingReaderInputStream, Long.MAX_VALUE, 16);
            valueLobDb.setPrecision(countingReaderInputStream.getLength());
            return valueLobDb;
        }
        return ValueLob.createClob(reader, l2, this.else);
    }

    public void setTable(long l2, int n2) {
        try {
            this.init();
            PreparedStatement preparedStatement = this.a("UPDATE INFORMATION_SCHEMA.LOBS SET TABLE = ? WHERE ID = ?");
            preparedStatement.setInt(1, n2);
            preparedStatement.setLong(2, l2);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class CountingReaderInputStream
    extends InputStream {
        private final Reader a;
        private long for;
        private long do;
        private int new;
        private char[] int = new char[4096];
        private byte[] if;

        CountingReaderInputStream(Reader reader, long l2) {
            this.a = reader;
            this.do = l2;
            this.if = Utils.EMPTY_BYTES;
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            if (this.if == null) {
                return -1;
            }
            if (this.new >= this.if.length) {
                this.a();
                if (this.if == null) {
                    return -1;
                }
            }
            n3 = Math.min(n3, this.if.length - this.new);
            System.arraycopy(this.if, this.new, byArray, n2, n3);
            this.new += n3;
            return n3;
        }

        public int read() throws IOException {
            if (this.if == null) {
                return -1;
            }
            if (this.new >= this.if.length) {
                this.a();
                if (this.if == null) {
                    return -1;
                }
            }
            return this.if[this.new++];
        }

        private void a() throws IOException {
            int n2 = (int)Math.min((long)this.int.length, this.do);
            n2 = n2 > 0 ? this.a.read(this.int, 0, n2) : -1;
            if (n2 < 0) {
                this.if = null;
            } else {
                this.if = StringUtils.utf8Encode(new String(this.int, 0, n2));
                this.for += (long)n2;
                this.do -= (long)n2;
            }
            this.new = 0;
        }

        public long getLength() {
            return this.for;
        }

        public void close() throws IOException {
            this.a.close();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class LobInputStream
    extends InputStream {
        private final Connection new;
        private PreparedStatement int;
        private byte[] do;
        private int byte;
        private long if;
        private long try;
        private int for;
        private CompressTool a;

        public LobInputStream(Connection connection, long l2) throws IOException {
            this.new = connection;
            try {
                this.try = l2;
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT BYTE_COUNT FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?");
                preparedStatement.setLong(1, l2);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) {
                    throw DbException.get(90028, "Missing lob: " + l2).getSQLException();
                }
                this.if = resultSet.getLong(1);
                resultSet.close();
            }
            catch (SQLException sQLException) {
                throw DbException.convertToIOException(sQLException);
            }
        }

        public int read() throws IOException {
            this.a();
            if (this.if <= 0L) {
                return -1;
            }
            --this.if;
            return this.do[this.byte++] & 0xFF;
        }

        public int read(byte[] byArray) throws IOException {
            return this.a(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            return this.a(byArray, n2, n3);
        }

        private int a(byte[] byArray, int n2, int n3) throws IOException {
            if (n3 == 0) {
                return 0;
            }
            int n4 = 0;
            while (n3 > 0) {
                this.a();
                if (this.if <= 0L) break;
                int n5 = (int)Math.min((long)n3, this.if);
                n5 = Math.min(n5, this.do.length - this.byte);
                System.arraycopy(this.do, this.byte, byArray, n2, n5);
                this.byte += n5;
                n4 += n5;
                this.if -= (long)n5;
                n2 += n5;
                n3 -= n5;
            }
            return n4 == 0 ? -1 : n4;
        }

        private void a() throws IOException {
            if (this.do != null && this.byte < this.do.length) {
                return;
            }
            if (this.if <= 0L) {
                return;
            }
            try {
                if (this.int == null) {
                    this.int = this.new.prepareStatement("SELECT COMPRESSED, DATA FROM INFORMATION_SCHEMA.LOB_MAP M INNER JOIN INFORMATION_SCHEMA.LOB_DATA D ON M.BLOCK = D.BLOCK WHERE M.LOB = ? AND M.SEQ = ?");
                }
                this.int.setLong(1, this.try);
                this.int.setInt(2, this.for);
                ResultSet resultSet = this.int.executeQuery();
                if (!resultSet.next()) {
                    throw DbException.get(90028, "Missing lob entry: " + this.try + "/" + this.for).getSQLException();
                }
                ++this.for;
                int n2 = resultSet.getInt(1);
                this.do = resultSet.getBytes(2);
                if (n2 != 0) {
                    if (this.a == null) {
                        this.a = CompressTool.getInstance();
                    }
                    this.do = this.a.expand(this.do);
                }
                this.byte = 0;
            }
            catch (SQLException sQLException) {
                throw DbException.convertToIOException(sQLException);
            }
        }
    }
}

