/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.h2.compress.CompressLZF;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.DataReader;
import org.h2.store.InDoubtTransaction;
import org.h2.store.Page;
import org.h2.store.PageInputStream;
import org.h2.store.PageOutputStream;
import org.h2.store.PageStore;
import org.h2.store.PageStreamData;
import org.h2.store.PageStreamTrunk;
import org.h2.store.SessionState;
import org.h2.util.BitField;
import org.h2.util.IntArray;
import org.h2.util.IntIntHashMap;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PageLog {
    public static final int NOOP = 0;
    public static final int UNDO = 1;
    public static final int COMMIT = 2;
    public static final int PREPARE_COMMIT = 3;
    public static final int ROLLBACK = 4;
    public static final int ADD = 5;
    public static final int REMOVE = 6;
    public static final int TRUNCATE = 7;
    public static final int CHECKPOINT = 8;
    public static final int FREE_LOG = 9;
    static final int RECOVERY_STAGE_UNDO = 0;
    static final int RECOVERY_STAGE_ALLOCATE = 1;
    static final int RECOVERY_STAGE_REDO = 2;
    private static final boolean e = true;
    private final PageStore for;
    private Trace c;
    private Data case;
    private PageInputStream int;
    private PageOutputStream do;
    private int long;
    private int goto;
    private Data g;
    private int new;
    private int char;
    private int void;
    private int try;
    private CompressLZF d;
    private byte[] byte;
    private BitField h = new BitField();
    private BitField else = new BitField();
    private IntIntHashMap b = new IntIntHashMap();
    private HashMap f = New.hashMap();
    private BitField a;
    private boolean if;

    PageLog(PageStore pageStore) {
        this.for = pageStore;
        this.g = pageStore.createData();
        this.c = pageStore.getTrace();
        this.d = new CompressLZF();
        this.byte = new byte[pageStore.getPageSize() * 2];
    }

    void openForWriting(int n2, boolean bl) {
        this.c.debug("log openForWriting firstPage:{0}", n2);
        this.long = n2;
        ++this.new;
        this.do = new PageOutputStream(this.for, n2, this.else, this.new, bl);
        this.do.reserve(1);
        this.for.setLogFirstPage(this.new, n2, this.do.getCurrentDataPageId());
        this.case = this.for.createData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free() {
        if (this.c.isDebugEnabled()) {
            this.c.debug("log free");
        }
        int n2 = 0;
        if (this.do != null) {
            n2 = this.do.getCurrentDataPageId();
            this.do.freeReserved();
        }
        try {
            this.if = true;
            int n3 = 0;
            int n4 = 1024;
            int n5 = 0;
            PageStreamTrunk.Iterator iterator = new PageStreamTrunk.Iterator(this.for, this.long);
            while (this.long != 0 && this.long < this.for.getPageCount()) {
                PageStreamTrunk pageStreamTrunk = iterator.next();
                if (pageStreamTrunk == null) {
                    if (iterator.canDelete()) {
                        this.for.free(this.long, false);
                    }
                    break;
                }
                if (n5++ >= n4) {
                    n3 = pageStreamTrunk.getPos();
                    n5 = 0;
                    n4 *= 2;
                } else if (n3 != 0 && n3 == pageStreamTrunk.getPos()) {
                    throw DbException.throwInternalError("endless loop at " + pageStreamTrunk);
                }
                pageStreamTrunk.free(n2);
                this.long = pageStreamTrunk.getNextTrunk();
            }
        }
        finally {
            this.if = false;
        }
    }

    void openForReading(int n2, int n3, int n4) {
        this.new = n2;
        this.long = n3;
        this.goto = n4;
    }

    void recover(int n2) {
        if (this.c.isDebugEnabled()) {
            this.c.debug("log recover stage:{0}", n2);
        }
        if (n2 == 1) {
            PageInputStream pageInputStream = new PageInputStream(this.for, this.new, this.long, this.goto);
            this.a = pageInputStream.allocateAllPages();
            pageInputStream.close();
            return;
        }
        this.int = new PageInputStream(this.for, this.new, this.long, this.goto);
        DataReader dataReader = new DataReader(this.int);
        int n3 = 0;
        Data data = this.for.createData();
        try {
            byte by;
            int n4 = 0;
            while ((by = dataReader.read()) >= 0) {
                int n5;
                ++n4;
                if (by == 1) {
                    n5 = dataReader.readVarInt();
                    int n6 = dataReader.readVarInt();
                    if (n6 == 0) {
                        dataReader.readFully(data.getBytes(), 0, this.for.getPageSize());
                    } else if (n6 == 1) {
                        Arrays.fill(data.getBytes(), 0, this.for.getPageSize(), (byte)0);
                    } else {
                        dataReader.readFully(this.byte, 0, n6);
                        try {
                            this.d.expand(this.byte, 0, n6, data.getBytes(), 0, this.for.getPageSize());
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            DbException.convertToIOException(arrayIndexOutOfBoundsException);
                        }
                    }
                    if (n2 != 0) continue;
                    if (!this.h.get(n5)) {
                        if (this.c.isDebugEnabled()) {
                            this.c.debug("log undo {0}", n5);
                        }
                        this.for.writePage(n5, data);
                        this.h.set(n5);
                        this.else.set(n5);
                        continue;
                    }
                    if (!this.c.isDebugEnabled()) continue;
                    this.c.debug("log undo skip {0}", n5);
                    continue;
                }
                if (by == 5) {
                    n5 = dataReader.readVarInt();
                    int n7 = dataReader.readVarInt();
                    Row row = PageLog.readRow(dataReader, data);
                    if (n2 == 0) {
                        this.for.allocateIfIndexRoot(n4, n7, row);
                        continue;
                    }
                    if (n2 != 2) continue;
                    if (this.if(n5, n3, n4)) {
                        if (this.c.isDebugEnabled()) {
                            this.c.debug("log redo + table: {0} s:{1} {2}", n7, n5, row);
                        }
                        this.for.redo(n4, n7, row, true);
                        continue;
                    }
                    if (!this.c.isDebugEnabled()) continue;
                    this.c.debug("log ignore s:{0} + table:{1} {2}", n5, n7, row);
                    continue;
                }
                if (by == 6) {
                    n5 = dataReader.readVarInt();
                    int n8 = dataReader.readVarInt();
                    long l2 = dataReader.readVarLong();
                    if (n2 != 2) continue;
                    if (this.if(n5, n3, n4)) {
                        if (this.c.isDebugEnabled()) {
                            this.c.debug("log redo - table:{0} key:{1}", n8, l2);
                        }
                        this.for.redoDelete(n4, n8, l2);
                        continue;
                    }
                    if (!this.c.isDebugEnabled()) continue;
                    this.c.debug("log ignore s:{0} - table:{1} key:{2}", n5, n8, l2);
                    continue;
                }
                if (by == 7) {
                    n5 = dataReader.readVarInt();
                    int n9 = dataReader.readVarInt();
                    if (n2 != 2) continue;
                    if (this.if(n5, n3, n4)) {
                        if (this.c.isDebugEnabled()) {
                            this.c.debug("log redo truncate table:{0}", n9);
                        }
                        this.for.redoTruncate(n9);
                        continue;
                    }
                    if (!this.c.isDebugEnabled()) continue;
                    this.c.debug("log ignore s:{0} truncate table:{1}", n5, n9);
                    continue;
                }
                if (by == 3) {
                    n5 = dataReader.readVarInt();
                    String string = dataReader.readString();
                    if (this.c.isDebugEnabled()) {
                        this.c.debug("log prepare commit {0} {1} pos:{2}", n5, string, n4);
                    }
                    if (n2 != 0) continue;
                    int n10 = this.int.getDataPage();
                    this.a(n5, n10, string);
                    continue;
                }
                if (by == 4) {
                    n5 = dataReader.readVarInt();
                    if (!this.c.isDebugEnabled()) continue;
                    this.c.debug("log rollback {0} pos:{1}", n5, n4);
                    continue;
                }
                if (by == 2) {
                    n5 = dataReader.readVarInt();
                    if (this.c.isDebugEnabled()) {
                        this.c.debug("log commit {0} pos:{1}", n5, n4);
                    }
                    if (n2 != 0) continue;
                    this.a(n5, n3, n4);
                    continue;
                }
                if (by == 0) continue;
                if (by == 8) {
                    ++n3;
                    continue;
                }
                if (by == 9) {
                    n5 = dataReader.readVarInt();
                    for (int i2 = 0; i2 < n5; ++i2) {
                        int n11 = dataReader.readVarInt();
                        if (n2 != 2 || this.a.get(n11)) continue;
                        this.for.free(n11, false);
                    }
                    continue;
                }
                if (!this.c.isDebugEnabled()) continue;
                this.c.debug("log end");
                break;
            }
        }
        catch (DbException dbException) {
            if (dbException.getErrorCode() == 90030) {
                this.c.debug("log recovery stopped");
            }
            throw dbException;
        }
        catch (IOException iOException) {
            this.c.debug("log recovery completed");
        }
        this.h = new BitField();
        if (n2 == 2) {
            this.a = null;
        }
    }

    private void a(int n2, int n3, String string) {
        SessionState sessionState = this.a(n2);
        InDoubtTransaction inDoubtTransaction = string == null ? null : new InDoubtTransaction(this.for, n2, n3, string);
        sessionState.inDoubtTransaction = inDoubtTransaction;
    }

    public static Row readRow(DataReader dataReader, Data data) throws IOException {
        long l2 = dataReader.readVarLong();
        int n2 = dataReader.readVarInt();
        data.reset();
        data.checkCapacity(n2);
        dataReader.readFully(data.getBytes(), 0, n2);
        int n3 = data.readVarInt();
        Value[] valueArray = new Value[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            valueArray[i2] = data.readValue();
        }
        Row row = new Row(valueArray, -1);
        row.setKey(l2);
        return row;
    }

    boolean getUndo(int n2) {
        return this.h.get(n2);
    }

    void addUndo(int n2, Data data) {
        if (this.h.get(n2) || this.if) {
            return;
        }
        if (this.c.isDebugEnabled()) {
            this.c.debug("log undo {0}", n2);
        }
        if (SysProperties.CHECK && data == null) {
            DbException.throwInternalError("Undo entry not written");
        }
        this.h.set(n2);
        this.else.set(n2);
        Data data2 = this.if();
        data2.writeByte((byte)1);
        data2.writeVarInt(n2);
        if (data.getBytes()[0] == 0) {
            data2.writeVarInt(1);
        } else {
            int n3 = this.for.getPageSize();
            int n4 = this.d.compress(data.getBytes(), n3, this.byte, 0);
            if (n4 < n3) {
                data2.writeVarInt(n4);
                data2.checkCapacity(n4);
                data2.write(this.byte, 0, n4);
            } else {
                data2.writeVarInt(0);
                data2.checkCapacity(n3);
                data2.write(data.getBytes(), 0, n3);
            }
        }
        this.a(data2);
    }

    private void a(IntArray intArray) {
        if (this.c.isDebugEnabled()) {
            this.c.debug("log frees {0}..{1}", intArray.get(0), intArray.get(intArray.size() - 1));
        }
        Data data = this.if();
        data.writeByte((byte)9);
        int n2 = intArray.size();
        data.writeVarInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            data.writeVarInt(intArray.get(i2));
        }
        this.a(data);
    }

    private void a(Data data) {
        this.do.write(data.getBytes(), 0, data.length());
        data.reset();
    }

    void commit(int n2) {
        if (this.c.isDebugEnabled()) {
            this.c.debug("log commit s:{0}", n2);
        }
        if (this.for.getDatabase().getPageStore() == null) {
            return;
        }
        Data data = this.if();
        data.writeByte((byte)2);
        data.writeVarInt(n2);
        this.a(data);
        if (this.for.getDatabase().getFlushOnEachCommit()) {
            this.flush();
        }
    }

    void prepareCommit(Session session, String string) {
        if (this.c.isDebugEnabled()) {
            this.c.debug("log prepare commit s:{0}, {1}", session.getId(), string);
        }
        if (this.for.getDatabase().getPageStore() == null) {
            return;
        }
        int n2 = this.for.getPageSize();
        this.do.flush();
        this.do.fillPage();
        Data data = this.if();
        data.writeByte((byte)3);
        data.writeVarInt(session.getId());
        data.writeString(string);
        if (data.length() >= PageStreamData.getCapacity(n2)) {
            throw DbException.getInvalidValueException("transaction name (too long)", string);
        }
        this.a(data);
        this.a();
        this.do.fillPage();
        if (this.for.getDatabase().getFlushOnEachCommit()) {
            this.flush();
        }
    }

    void logAddOrRemoveRow(Session session, int n2, Row row, boolean bl) {
        int n3;
        if (this.c.isDebugEnabled()) {
            this.c.debug("log {0} s:{1} table:{2} row:{3}", bl ? "+" : "-", session.getId(), n2, row);
        }
        session.addLogPos(this.char, this.void);
        ++this.void;
        Data data = this.g;
        data.reset();
        int n4 = row.getColumnCount();
        data.writeVarInt(n4);
        data.checkCapacity(row.getByteCount(data));
        if (session.isRedoLogBinaryEnabled()) {
            for (n3 = 0; n3 < n4; ++n3) {
                data.writeValue(row.getValue(n3));
            }
        } else {
            for (n3 = 0; n3 < n4; ++n3) {
                Value value = row.getValue(n3);
                if (value.getType() == 12) {
                    data.writeValue(ValueNull.INSTANCE);
                    continue;
                }
                data.writeValue(value);
            }
        }
        Data data2 = this.if();
        data2.writeByte((byte)(bl ? 5 : 6));
        data2.writeVarInt(session.getId());
        data2.writeVarInt(n2);
        data2.writeVarLong(row.getKey());
        if (bl) {
            data2.writeVarInt(data.length());
            data2.checkCapacity(data.length());
            data2.write(data.getBytes(), 0, data.length());
        }
        this.a(data2);
    }

    void logTruncate(Session session, int n2) {
        if (this.c.isDebugEnabled()) {
            this.c.debug("log truncate s:{0} table:{1}", session.getId(), n2);
        }
        session.addLogPos(this.char, this.void);
        ++this.void;
        Data data = this.if();
        data.writeByte((byte)7);
        data.writeVarInt(session.getId());
        data.writeVarInt(n2);
        this.a(data);
    }

    void flush() {
        if (this.do != null) {
            this.a();
        }
    }

    void checkpoint() {
        Data data = this.if();
        data.writeByte((byte)8);
        this.a(data);
        this.h = new BitField();
        ++this.char;
        this.void = 0;
        this.do.flush();
        this.do.fillPage();
        int n2 = this.do.getCurrentDataPageId();
        this.b.put(this.char, n2);
    }

    int getLogSectionId() {
        return this.char;
    }

    long getLogPos() {
        return this.void;
    }

    void removeUntil(int n2) {
        if (n2 == 0) {
            return;
        }
        int n3 = this.b.get(n2);
        this.long = this.a(this.long, n3);
        this.for.setLogFirstPage(this.new, this.long, n3);
        while (this.try < n2) {
            if (this.try > 0) {
                this.b.remove(this.try);
            }
            ++this.try;
        }
    }

    private int a(int n2, int n3) {
        this.c.debug("log.removeUntil {0} {1}", n2, n3);
        while (true) {
            int n4;
            Page page = this.for.getPage(n2);
            PageStreamTrunk pageStreamTrunk = (PageStreamTrunk)page;
            this.new = pageStreamTrunk.getLogKey();
            if (pageStreamTrunk.contains(n3)) {
                return pageStreamTrunk.getPos();
            }
            n2 = pageStreamTrunk.getNextTrunk();
            IntArray intArray = new IntArray();
            intArray.add(pageStreamTrunk.getPos());
            int n5 = 0;
            while ((n4 = pageStreamTrunk.getPageData(n5)) != -1) {
                intArray.add(n4);
                ++n5;
            }
            this.a(intArray);
            this.do.free(pageStreamTrunk);
        }
    }

    void close() {
        this.c.debug("log close");
        if (this.do != null) {
            this.do.close();
            this.do = null;
        }
        this.case = null;
    }

    private boolean if(int n2, int n3, int n4) {
        SessionState sessionState = (SessionState)this.f.get(n2);
        if (sessionState == null) {
            return false;
        }
        return sessionState.isCommitted(n3, n4);
    }

    private void a(int n2, int n3, int n4) {
        SessionState sessionState = this.a(n2);
        sessionState.lastCommitLog = n3;
        sessionState.lastCommitPos = n4;
        sessionState.inDoubtTransaction = null;
    }

    private SessionState a(int n2) {
        Integer n3 = n2;
        SessionState sessionState = (SessionState)this.f.get(n3);
        if (sessionState == null) {
            sessionState = new SessionState();
            this.f.put(n3, sessionState);
            sessionState.sessionId = n2;
        }
        return sessionState;
    }

    long getSize() {
        return this.do == null ? 0L : this.do.getSize();
    }

    ArrayList getInDoubtTransactions() {
        ArrayList arrayList = New.arrayList();
        for (SessionState sessionState : this.f.values()) {
            InDoubtTransaction inDoubtTransaction = sessionState.inDoubtTransaction;
            if (inDoubtTransaction == null) continue;
            arrayList.add(inDoubtTransaction);
        }
        return arrayList;
    }

    void setInDoubtTransactionState(int n2, int n3, boolean bl) {
        PageStreamData pageStreamData = (PageStreamData)this.for.getPage(n3);
        pageStreamData.initWrite();
        Data data = this.for.createData();
        data.writeByte((byte)(bl ? 2 : 4));
        data.writeVarInt(n2);
        byte[] byArray = data.getBytes();
        pageStreamData.write(byArray, 0, byArray.length);
        byArray = new byte[pageStreamData.getRemaining()];
        pageStreamData.write(byArray, 0, byArray.length);
        pageStreamData.write();
    }

    void recoverEnd() {
        this.f = New.hashMap();
    }

    private void a() {
        this.do.flush();
    }

    private Data if() {
        if (this.case.length() == 0) {
            return this.case;
        }
        return this.for.createData();
    }

    int getMinPageId() {
        return this.do == null ? 0 : this.do.getMinPageId();
    }
}

