/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.CRC32;
import org.h2.command.ddl.CreateTableData;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MultiVersionIndex;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageBtreeLeaf;
import org.h2.index.PageBtreeNode;
import org.h2.index.PageDataIndex;
import org.h2.index.PageDataLeaf;
import org.h2.index.PageDataNode;
import org.h2.index.PageDataOverflow;
import org.h2.index.PageDelegateIndex;
import org.h2.index.PageIndex;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.store.Data;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.Page;
import org.h2.store.PageFreeList;
import org.h2.store.PageLog;
import org.h2.store.PageStreamData;
import org.h2.store.PageStreamTrunk;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.table.Table;
import org.h2.util.BitField;
import org.h2.util.Cache;
import org.h2.util.CacheLRU;
import org.h2.util.CacheObject;
import org.h2.util.CacheWriter;
import org.h2.util.IOUtils;
import org.h2.util.IntArray;
import org.h2.util.IntIntHashMap;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.ValueInt;
import org.h2.value.ValueString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PageStore
implements CacheWriter {
    public static final int PAGE_SIZE_MIN = 64;
    public static final int PAGE_SIZE_MAX = 32768;
    public static final int LOG_MODE_OFF = 0;
    public static final int LOG_MODE_SYNC = 2;
    private static final int o = 3;
    private static final int g = 4;
    private static final int C = 6;
    private static final int d = 1024;
    private static final int J = 20;
    private static final int s = 3;
    private static final int w = 3;
    private static final int G = 0;
    private static final int for = 1;
    private static final int q = -1;
    private static final int b = 1536;
    private Database A;
    private final Trace h;
    private String l;
    private FileStore e;
    private String long;
    private int p = 2048;
    private int if;
    private long x;
    private long j;
    private long H;
    private int z;
    private int r;
    private int c;
    private Cache goto;
    private int a;
    private boolean t;
    private long k;
    private int else;
    private PageLog case;
    private Schema int;
    private RegularTable F;
    private PageDataIndex do;
    private IntIntHashMap I = new IntIntHashMap();
    private HashMap void = New.hashMap();
    private HashMap m;
    private HashMap L;
    private boolean char;
    private long v = 0x1000000L;
    private Session byte;
    private BitField try = new BitField();
    private ArrayList u = New.arrayList();
    private boolean new;
    private ArrayList K;
    private IntIntHashMap E;
    private int y = 1;
    private Data n;
    private long i;
    private HashMap D;
    private int f = 2;
    private boolean B;

    public PageStore(Database database, String string, String string2, int n2) {
        this.l = string;
        this.long = string2;
        this.A = database;
        this.h = database.getTrace("pageStore");
        String string3 = database.getCacheType();
        this.goto = CacheLRU.getCache(this, string3, n2);
        this.byte = new Session(database, null, 0);
    }

    public void statisticsStart() {
        this.D = New.hashMap();
    }

    public HashMap statisticsEnd() {
        HashMap hashMap = this.D;
        this.D = null;
        return hashMap;
    }

    private void a(String string) {
        if (this.D != null) {
            Integer n2 = (Integer)this.D.get(string);
            this.D.put(string, n2 == null ? 1 : n2 + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyDirect(int n2, OutputStream outputStream) throws IOException {
        Database database = this.A;
        synchronized (database) {
            byte[] byArray = new byte[this.p];
            if (n2 >= this.else) {
                return -1;
            }
            this.e.seek((long)n2 << this.if);
            this.e.readFullyDirect(byArray, 0, this.p);
            ++this.H;
            outputStream.write(byArray, 0, this.p);
            return n2 + 1;
        }
    }

    public void open() {
        try {
            this.I.put(-1, 4);
            if (IOUtils.exists(this.l)) {
                long l2 = IOUtils.length(this.l);
                if (l2 < 384L) {
                    if (this.A.isReadOnly()) {
                        throw DbException.get(90030, this.l + " length: " + l2);
                    }
                    this.byte();
                } else {
                    this.long();
                }
            } else {
                this.byte();
            }
        }
        catch (DbException dbException) {
            this.close();
            throw dbException;
        }
    }

    private void byte() {
        this.setPageSize(this.p);
        this.a = PageFreeList.getPagesAddressed(this.p);
        this.e = this.A.openFile(this.l, this.long, false);
        this.try();
        this.t = true;
        this.goto();
        this.case();
        this.case = new PageLog(this);
        this.for(6);
        this.for();
        this.r = this.allocatePage();
        this.case.openForWriting(this.r, false);
        this.char = true;
        this.t = false;
        this.do();
    }

    private void try() {
        if (this.B && !this.e.tryLock()) {
            throw DbException.get(90020, this.l);
        }
    }

    private void long() {
        try {
            this.e = this.A.openFile(this.l, this.long, true);
        }
        catch (DbException dbException) {
            if (dbException.getErrorCode() == 90031) {
                throw DbException.get(90020, dbException, this.l);
            }
            throw dbException;
        }
        this.try();
        this.new();
        this.a = PageFreeList.getPagesAddressed(this.p);
        this.k = this.e.length();
        this.else = (int)(this.k / (long)this.p);
        if (this.else < 6) {
            if (this.A.isReadOnly()) {
                throw DbException.get(90030, this.l + " pageCount: " + this.else);
            }
            this.e.releaseLock();
            this.e.close();
            IOUtils.delete(this.l);
            this.byte();
            return;
        }
        this.if();
        this.case = new PageLog(this);
        this.case.openForReading(this.z, this.r, this.c);
        boolean bl = this.A.isMultiVersion();
        this.A.setMultiVersion(false);
        this.c();
        this.A.setMultiVersion(bl);
        if (!this.A.isReadOnly()) {
            this.t = true;
            this.case.free();
            this.r = this.allocatePage();
            this.case.openForWriting(this.r, false);
            this.t = false;
            this.try.set(0, this.else, true);
            this.checkpoint();
            this.b();
        }
    }

    private void b() {
        if (this.m != null) {
            this.void.putAll(this.m);
            for (PageIndex pageIndex : this.m.values()) {
                if (!pageIndex.getTable().isTemporary()) continue;
                pageIndex.truncate(this.byte);
                pageIndex.remove(this.byte);
            }
            this.byte.commit(true);
            this.m = null;
        }
        this.void.clear();
        this.void.put(-1, this.do);
    }

    private void void() {
        for (PageIndex pageIndex : this.void.values()) {
            pageIndex.writeRowCount();
        }
    }

    private void char() {
        ArrayList arrayList = this.goto.getAllChanged();
        Collections.sort(arrayList);
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeBack((CacheObject)arrayList.get(i2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint() {
        this.h.debug("checkpoint");
        if (this.case == null || this.A.isReadOnly()) {
            return;
        }
        Database database = this.A;
        synchronized (database) {
            this.A.checkPowerOff();
            this.void();
            this.case.checkpoint();
            this.char();
            int n2 = this.else();
            this.case.removeUntil(n2);
            this.char();
            this.case.checkpoint();
            if (this.h.isDebugEnabled()) {
                this.h.debug("writeFree");
            }
            byte[] byArray = new byte[16];
            byte[] byArray2 = new byte[this.p];
            for (int i2 = 3; i2 < this.else; ++i2) {
                if (this.if(i2)) {
                    this.try.clear(i2);
                    continue;
                }
                if (this.try.get(i2)) continue;
                if (this.h.isDebugEnabled()) {
                    this.h.debug("free {0}", i2);
                }
                this.e.seek((long)i2 << this.if);
                this.e.readFully(byArray, 0, 16);
                if (byArray[0] != 0) {
                    this.e.seek((long)i2 << this.if);
                    this.e.write(byArray2, 0, this.p);
                    ++this.j;
                }
                this.try.set(i2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compact(int n2) {
        int n3;
        int n4;
        boolean bl;
        if (!this.A.getSettings().pageStoreTrim) {
            return;
        }
        int n5 = -1;
        for (int i2 = this.int(this.else); i2 >= 0 && (n5 = this.do(i2).getLastUsed()) == -1; --i2) {
        }
        this.char();
        this.case.free();
        this.t = true;
        try {
            this.r = n5 + 1;
            this.allocatePage(this.r);
            this.case.openForWriting(this.r, true);
            this.case.checkpoint();
        }
        finally {
            this.t = false;
        }
        long l2 = System.currentTimeMillis();
        boolean bl2 = n2 == 82;
        boolean bl3 = bl = n2 == 84;
        if (this.A.getSettings().defragAlways) {
            bl = true;
            bl2 = true;
        }
        int n6 = this.A.getSettings().maxCompactTime;
        int n7 = this.A.getSettings().maxCompactCount;
        if (bl2 || bl) {
            n6 = Integer.MAX_VALUE;
            n7 = Integer.MAX_VALUE;
        }
        int n8 = bl2 ? 1536 : 1;
        int n9 = 6;
        int n10 = 0;
        block10: for (n4 = n5; n4 > 6 && n10 < n7; n4 -= n8) {
            for (n3 = n4 - n8 + 1; n3 <= n4; ++n3) {
                if (n3 <= 6 || !this.if(n3)) continue;
                Object object = this.A;
                synchronized (object) {
                    n9 = this.try(n9);
                    if (n9 == -1 || n9 >= n3) {
                        n10 = n7;
                        continue block10;
                    }
                    if (this.a(n3, n9)) {
                        ++n10;
                        long l3 = System.currentTimeMillis();
                        if (l3 > l2 + (long)n6) {
                            n10 = n7;
                            continue block10;
                        }
                    }
                    continue;
                }
            }
        }
        if (bl) {
            this.char();
            this.goto.clear();
            ArrayList arrayList = this.A.getAllTablesAndViews(false);
            this.K = New.arrayList();
            this.E = new IntIntHashMap();
            this.new = true;
            Session session = this.A.getSystemSession();
            for (Object object : arrayList) {
                if (((DbObjectBase)object).isTemporary() || !((Table)object).getTableType().equals("TABLE")) continue;
                Index index = ((Table)object).getScanIndex(session);
                Cursor cursor = index.find(session, null, null);
                while (cursor.next()) {
                    cursor.get();
                }
                for (Object object2 : ((Table)object).getIndexes()) {
                    if (object2 == index) continue;
                    cursor = object2.find(session, null, null);
                    while (cursor.next()) {
                    }
                }
            }
            this.new = false;
            n3 = 5;
            int n11 = 0;
            int n12 = this.K.size();
            for (int i3 = 0; i3 < n12; ++i3) {
                Page page;
                Object object2;
                this.char();
                int n13 = (Integer)this.K.get(i3);
                object2 = this.getPage(n13);
                if (!((Page)object2).canMove()) continue;
                while ((page = this.getPage(++n3)) != null && !page.canMove()) {
                }
                if (n3 == n13) continue;
                if ((n11 = this.try(n11)) == -1) {
                    DbException.throwInternalError("no free page for defrag");
                }
                this.goto.clear();
                this.a(n13, n3, n11);
                int n14 = this.E.get(n3);
                if (n14 != -1) {
                    this.K.set(n14, n13);
                    this.E.put(n13, n14);
                }
                this.K.set(i3, n3);
                this.E.put(n3, i3);
            }
            this.K = null;
            this.E = null;
        }
        this.checkpoint();
        this.case.checkpoint();
        this.void();
        this.case.checkpoint();
        this.char();
        this.commit(this.byte);
        this.char();
        this.case.checkpoint();
        this.case.free();
        this.t = true;
        try {
            this.setLogFirstPage(++this.z, 0, 0);
        }
        finally {
            this.t = false;
        }
        this.char();
        for (n4 = this.int(this.else); n4 >= 0 && (n5 = this.do(n4).getLastUsed()) == -1; --n4) {
        }
        n4 = n5 + 1;
        if (n4 < this.else) {
            this.try.set(n4, this.else, false);
        }
        this.else = n4;
        this.u.clear();
        this.h.debug("pageCount:{0}", this.else);
        long l4 = (long)this.else << this.if;
        if (this.e.length() != l4) {
            this.e.setLength(l4);
            ++this.j;
        }
    }

    private int try(int n2) {
        int n3 = -1;
        int n4 = this.int(n2);
        while (n2 < this.else && (n3 = this.do(n4).getFirstFree(n2)) == -1) {
            ++n4;
        }
        return n3;
    }

    private void a(int n2, int n3, int n4) {
        Page page;
        if (n2 < 6 || n3 < 6) {
            System.out.println(this.if(n2) + " " + this.if(n3));
            DbException.throwInternalError("can't swap " + n2 + " and " + n3);
        }
        if ((page = (Page)this.goto.get(n4)) != null) {
            DbException.throwInternalError("not free: " + page);
        }
        this.h.debug("swap {0} and {1} via {2}", n2, n3, n4);
        Page page2 = null;
        if (this.if(n2)) {
            page2 = this.getPage(n2);
            if (page2 != null) {
                page2.moveTo(this.byte, n4);
            }
            this.free(n2);
        }
        if (n4 != n3) {
            if (this.if(n3)) {
                Page page3 = this.getPage(n3);
                if (page3 != null) {
                    page3.moveTo(this.byte, n2);
                }
                this.free(n3);
            }
            if (page2 != null) {
                page = this.getPage(n4);
                if (page != null) {
                    page.moveTo(this.byte, n3);
                }
                this.free(n4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(int n2, int n3) {
        Page page;
        if (n2 < 6 || n3 == -1 || n3 >= n2 || !this.if(n2)) {
            return false;
        }
        Page page2 = (Page)this.goto.get(n3);
        if (page2 != null) {
            DbException.throwInternalError("not free: " + page2);
        }
        if ((page = this.getPage(n2)) == null) {
            this.new(n2);
        } else if (page instanceof PageStreamData || page instanceof PageStreamTrunk) {
            if (page.getPos() < this.case.getMinPageId()) {
                this.new(n2);
            }
        } else {
            this.h.debug("move {0} to {1}", page.getPos(), n3);
            try {
                page.moveTo(this.byte, n3);
            }
            finally {
                ++this.y;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getPage(int n2) {
        Database database = this.A;
        synchronized (database) {
            Page page = (Page)this.goto.get(n2);
            if (page != null) {
                return page;
            }
            Data data = this.createData();
            this.readPage(n2, data);
            byte by = data.readByte();
            if (by == 0) {
                return null;
            }
            data.readShortInt();
            data.readInt();
            if (!PageStore.checksumTest(data.getBytes(), n2, this.p)) {
                throw DbException.get(90030, "wrong checksum");
            }
            switch (by & 0xFFFFFFEF) {
                case 6: {
                    page = PageFreeList.read(this, data, n2);
                    break;
                }
                case 1: {
                    int n3 = data.readVarInt();
                    PageIndex pageIndex = (PageIndex)this.void.get(n3);
                    if (pageIndex == null) {
                        throw DbException.get(90030, "index not found " + n3);
                    }
                    if (!(pageIndex instanceof PageDataIndex)) {
                        throw DbException.get(90030, "not a data index " + n3 + " " + pageIndex);
                    }
                    PageDataIndex pageDataIndex = (PageDataIndex)pageIndex;
                    if (this.D != null) {
                        this.a(pageDataIndex.getTable().getName() + "." + pageDataIndex.getName() + " read");
                    }
                    page = PageDataLeaf.read(pageDataIndex, data, n2);
                    break;
                }
                case 2: {
                    int n4 = data.readVarInt();
                    PageIndex pageIndex = (PageIndex)this.void.get(n4);
                    if (pageIndex == null) {
                        throw DbException.get(90030, "index not found " + n4);
                    }
                    if (!(pageIndex instanceof PageDataIndex)) {
                        throw DbException.get(90030, "not a data index " + n4 + " " + pageIndex);
                    }
                    PageDataIndex pageDataIndex = (PageDataIndex)pageIndex;
                    if (this.D != null) {
                        this.a(pageDataIndex.getTable().getName() + "." + pageDataIndex.getName() + " read");
                    }
                    page = PageDataNode.read(pageDataIndex, data, n2);
                    break;
                }
                case 3: {
                    page = PageDataOverflow.read(this, data, n2);
                    if (this.D == null) break;
                    this.a("overflow read");
                    break;
                }
                case 4: {
                    int n5 = data.readVarInt();
                    PageIndex pageIndex = (PageIndex)this.void.get(n5);
                    if (pageIndex == null) {
                        throw DbException.get(90030, "index not found " + n5);
                    }
                    if (!(pageIndex instanceof PageBtreeIndex)) {
                        throw DbException.get(90030, "not a btree index " + n5 + " " + pageIndex);
                    }
                    PageBtreeIndex pageBtreeIndex = (PageBtreeIndex)pageIndex;
                    if (this.D != null) {
                        this.a(pageBtreeIndex.getTable().getName() + "." + pageBtreeIndex.getName() + " read");
                    }
                    page = PageBtreeLeaf.read(pageBtreeIndex, data, n2);
                    break;
                }
                case 5: {
                    int n6 = data.readVarInt();
                    PageIndex pageIndex = (PageIndex)this.void.get(n6);
                    if (pageIndex == null) {
                        throw DbException.get(90030, "index not found " + n6);
                    }
                    if (!(pageIndex instanceof PageBtreeIndex)) {
                        throw DbException.get(90030, "not a btree index " + n6 + " " + pageIndex);
                    }
                    PageBtreeIndex pageBtreeIndex = (PageBtreeIndex)pageIndex;
                    if (this.D != null) {
                        this.a(pageBtreeIndex.getTable().getName() + "." + pageBtreeIndex.getName() + " read");
                    }
                    page = PageBtreeNode.read(pageBtreeIndex, data, n2);
                    break;
                }
                case 7: {
                    page = PageStreamTrunk.read(this, data, n2);
                    break;
                }
                case 8: {
                    page = PageStreamData.read(this, data, n2);
                    break;
                }
                default: {
                    throw DbException.get(90030, "page=" + n2 + " type=" + by);
                }
            }
            this.goto.put(page);
            return page;
        }
    }

    private int else() {
        this.h.debug("getFirstUncommittedSection");
        Session[] sessionArray = this.A.getSessions(true);
        int n2 = this.case.getLogSectionId();
        for (Session session : sessionArray) {
            int n3 = session.getFirstUncommittedLog();
            if (n3 == -1 || n3 >= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private void new() {
        this.e.seek(48L);
        Data data = Data.create((DataHandler)this.A, new byte[16]);
        this.e.readFully(data.getBytes(), 0, 16);
        ++this.H;
        this.setPageSize(data.readInt());
        byte by = data.readByte();
        byte by2 = data.readByte();
        if (by2 > 3) {
            throw DbException.get(90048, this.l);
        }
        if (by > 3) {
            this.close();
            this.A.setReadOnly(true);
            this.long = "r";
            this.e = this.A.openFile(this.l, this.long, true);
        }
    }

    private void if() {
        Data data = this.createData();
        int n2 = 1;
        while (true) {
            if (n2 == 3) {
                throw DbException.get(90030, this.l);
            }
            data.reset();
            this.readPage(n2, data);
            CRC32 cRC32 = new CRC32();
            cRC32.update(data.getBytes(), 4, this.p - 4);
            int n3 = (int)cRC32.getValue();
            int n4 = data.readInt();
            if (n3 == n4) break;
            ++n2;
        }
        this.x = data.readLong();
        this.z = data.readInt();
        this.r = data.readInt();
        this.c = data.readInt();
    }

    public void setPageSize(int n2) {
        if (n2 < 64 || n2 > 32768) {
            throw DbException.get(90030, this.l + " pageSize: " + n2);
        }
        boolean bl = false;
        int n3 = 0;
        for (int i2 = 1; i2 <= n2; i2 += i2) {
            if (n2 == i2) {
                bl = true;
                break;
            }
            ++n3;
        }
        if (!bl) {
            throw DbException.get(90030, this.l);
        }
        this.p = n2;
        this.n = this.createData();
        this.if = n3;
    }

    private void goto() {
        Data data = Data.create((DataHandler)this.A, new byte[this.p - 48]);
        data.writeInt(this.p);
        data.writeByte((byte)3);
        data.writeByte((byte)3);
        this.e.seek(48L);
        this.e.write(data.getBytes(), 0, this.p - 48);
        ++this.j;
    }

    void setLogFirstPage(int n2, int n3, int n4) {
        if (this.h.isDebugEnabled()) {
            this.h.debug("setLogFirstPage key: {0} trunk: {1} data: {2}", n2, n3, n4);
        }
        this.z = n2;
        this.r = n3;
        this.c = n4;
        this.case();
    }

    private void case() {
        this.h.debug("writeVariableHeader");
        if (this.f == 2) {
            this.e.sync();
        }
        Data data = this.createData();
        data.writeInt(0);
        data.writeLong(this.getWriteCountTotal());
        data.writeInt(this.z);
        data.writeInt(this.r);
        data.writeInt(this.c);
        CRC32 cRC32 = new CRC32();
        cRC32.update(data.getBytes(), 4, this.p - 4);
        data.setInt(0, (int)cRC32.getValue());
        this.e.seek(this.p);
        this.e.write(data.getBytes(), 0, this.p);
        this.e.seek(this.p + this.p);
        this.e.write(data.getBytes(), 0, this.p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.h.debug("close");
        Database database = this.A;
        synchronized (database) {
            if (this.case != null) {
                this.case.close();
                this.case = null;
            }
            if (this.e != null) {
                try {
                    this.e.releaseLock();
                    this.e.close();
                }
                finally {
                    this.e = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushLog() {
        if (this.e != null) {
            Database database = this.A;
            synchronized (database) {
                this.case.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        if (this.e != null) {
            Database database = this.A;
            synchronized (database) {
                this.case.flush();
                this.e.sync();
            }
        }
    }

    public Trace getTrace() {
        return this.h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBack(CacheObject cacheObject) {
        Page page = (Page)cacheObject;
        if (this.h.isDebugEnabled()) {
            this.h.debug("writeBack {0}", page);
        }
        Database database = this.A;
        synchronized (database) {
            page.write();
            page.setChanged(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logUndo(Page page, Data data) {
        if (this.f == 0) {
            return;
        }
        Database database = this.A;
        synchronized (database) {
            int n2;
            this.int();
            this.A.checkWritingAllowed();
            if (!this.t && !this.case.getUndo(n2 = page.getPos())) {
                if (data == null) {
                    data = this.readPage(n2);
                }
                this.case.addUndo(n2, data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Page page) {
        Database database = this.A;
        synchronized (database) {
            if (this.h.isDebugEnabled() && !page.isChanged()) {
                this.h.debug("updateRecord {0}", page.toString());
            }
            this.int();
            this.A.checkWritingAllowed();
            page.setChanged(true);
            int n2 = page.getPos();
            if (SysProperties.CHECK && !this.t && this.f != 0) {
                this.case.addUndo(n2, null);
            }
            this.allocatePage(n2);
            this.goto.update(n2, page);
        }
    }

    private int int(int n2) {
        return (n2 - 3) / this.a;
    }

    private PageFreeList a(int n2) {
        return this.do(this.int(n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PageFreeList do(int n2) {
        PageFreeList pageFreeList = null;
        if (n2 < this.u.size() && (pageFreeList = (PageFreeList)this.u.get(n2)) != null) {
            return pageFreeList;
        }
        Database database = this.A;
        synchronized (database) {
            int n3 = 3 + n2 * this.a;
            while (n3 >= this.else) {
                this.do();
            }
            if (n3 < this.else) {
                pageFreeList = (PageFreeList)this.getPage(n3);
            }
            if (pageFreeList == null) {
                pageFreeList = PageFreeList.create(this, n3);
                this.goto.put(pageFreeList);
            }
            while (this.u.size() <= n2) {
                this.u.add(null);
            }
            this.u.set(n2, pageFreeList);
            return pageFreeList;
        }
    }

    private void new(int n2) {
        PageFreeList pageFreeList = this.a(n2);
        pageFreeList.free(n2);
    }

    void allocatePage(int n2) {
        PageFreeList pageFreeList = this.a(n2);
        pageFreeList.allocate(n2);
    }

    private boolean if(int n2) {
        return this.a(n2).isUsed(n2);
    }

    void allocatePages(IntArray intArray, int n2, BitField bitField, int n3) {
        intArray.ensureCapacity(intArray.size() + n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            n3 = n4 = this.a(bitField, n3);
            intArray.add(n4);
        }
    }

    public int allocatePage() {
        int n2 = this.a((BitField)null, 0);
        if (!this.t && this.f != 0) {
            this.case.addUndo(n2, this.n);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int a(BitField bitField, int n2) {
        Database database = this.A;
        synchronized (database) {
            PageFreeList pageFreeList;
            int n3;
            int n4 = 0;
            while ((n3 = (pageFreeList = this.do(n4)).allocate(bitField, n2)) < 0) {
                ++n4;
            }
            while (n3 >= this.else) {
                this.do();
            }
            if (this.h.isDebugEnabled()) {
                // empty if block
            }
            return n3;
        }
    }

    private void do() {
        int n2 = 0x100000 / this.p;
        int n3 = this.else * 20 / 100;
        if (n2 < n3) {
            n2 = (1 + n3 / n2) * n2;
        }
        this.for(n2);
    }

    private void for(int n2) {
        for (int i2 = this.else; i2 < this.else + n2; ++i2) {
            this.try.set(i2);
        }
        this.else += n2;
        long l2 = (long)this.else << this.if;
        this.e.setLength(l2);
        ++this.j;
        this.k = l2;
    }

    public void free(int n2) {
        this.free(n2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(int n2, boolean bl) {
        if (this.h.isDebugEnabled()) {
            // empty if block
        }
        Database database = this.A;
        synchronized (database) {
            this.goto.remove(n2);
            if (SysProperties.CHECK && !this.t && bl && this.f != 0) {
                this.case.addUndo(n2, null);
            }
            this.new(n2);
            if (this.t) {
                int n3;
                this.writePage(n2, this.createData());
                if (this.L != null && this.L.containsKey(n2) && (long)(n3 = ((Integer)this.L.get(n2)).intValue()) > this.case.getLogPos()) {
                    this.allocatePage(n2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeUnused(int n2) {
        if (this.h.isDebugEnabled()) {
            this.h.debug("freeUnused {0}", n2);
        }
        Database database = this.A;
        synchronized (database) {
            this.goto.remove(n2);
            this.new(n2);
            this.try.set(n2);
        }
    }

    public Data createData() {
        return Data.create((DataHandler)this.A, new byte[this.p]);
    }

    public Data readPage(int n2) {
        Data data = this.createData();
        this.readPage(n2, data);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readPage(int n2, Data data) {
        if (this.new && n2 >= 6 && this.E.get(n2) == -1) {
            this.E.put(n2, this.K.size());
            this.K.add(n2);
        }
        Database database = this.A;
        synchronized (database) {
            if (n2 < 0 || n2 >= this.else) {
                throw DbException.get(90030, n2 + " of " + this.else);
            }
            this.e.seek((long)n2 << this.if);
            this.e.readFully(data.getBytes(), 0, this.p);
            ++this.H;
        }
    }

    public int getPageSize() {
        return this.p;
    }

    public int getPageCount() {
        return this.else;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePage(int n2, Data data) {
        if (n2 <= 0) {
            DbException.throwInternalError("write to page " + n2);
        }
        byte[] byArray = data.getBytes();
        if (SysProperties.CHECK) {
            boolean bl;
            boolean bl2 = (n2 - 3) % this.a == 0;
            boolean bl3 = bl = byArray[0] == 6;
            if (byArray[0] != 0 && bl2 != bl) {
                throw DbException.throwInternalError();
            }
        }
        this.a(byArray, n2);
        Database database = this.A;
        synchronized (database) {
            this.e.seek((long)n2 << this.if);
            this.e.write(byArray, 0, this.p);
            ++this.j;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecord(int n2) {
        Database database = this.A;
        synchronized (database) {
            this.goto.remove(n2);
        }
    }

    Database getDatabase() {
        return this.A;
    }

    private void c() {
        PageDataIndex pageDataIndex;
        int n2;
        this.h.debug("log recover");
        this.t = true;
        this.case.recover(0);
        if (this.L != null) {
            Iterator iterator = this.L.keySet().iterator();
            while (iterator.hasNext()) {
                n2 = (Integer)iterator.next();
                if (this.h.isDebugEnabled()) {
                    this.h.debug("reserve {0}", n2);
                }
                this.allocatePage(n2);
            }
        }
        this.case.recover(1);
        this.for();
        this.a();
        this.case.recover(2);
        boolean bl = false;
        if (!this.A.isReadOnly()) {
            if (this.case.getInDoubtTransactions().size() == 0) {
                this.case.recoverEnd();
                n2 = this.else();
                this.case.removeUntil(n2);
            } else {
                bl = true;
            }
        }
        this.char = (pageDataIndex = (PageDataIndex)this.void.get(0)) == null;
        for (PageIndex pageIndex : this.void.values()) {
            if (pageIndex.getTable().isTemporary()) {
                if (this.m == null) {
                    this.m = New.hashMap();
                }
                this.m.put(pageIndex.getId(), pageIndex);
                continue;
            }
            pageIndex.close(this.byte);
        }
        this.allocatePage(4);
        this.void();
        this.t = false;
        this.L = null;
        this.char();
        this.goto.clear();
        this.u.clear();
        this.void.clear();
        this.void.put(-1, this.do);
        if (bl) {
            this.A.setReadOnly(true);
        }
        this.h.debug("log recover done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logAddOrRemoveRow(Session session, int n2, Row row, boolean bl) {
        if (this.f != 0 && !this.t) {
            Database database = this.A;
            synchronized (database) {
                this.case.logAddOrRemoveRow(session, n2, row, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Session session) {
        Database database = this.A;
        synchronized (database) {
            this.int();
            this.case.commit(session.getId());
            if (this.case.getSize() - this.i > this.v) {
                this.checkpoint();
                this.i = this.case.getSize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareCommit(Session session, String string) {
        Database database = this.A;
        synchronized (database) {
            this.case.prepareCommit(session, string);
        }
    }

    public boolean isNew() {
        return this.char;
    }

    void allocateIfIndexRoot(int n2, int n3, Row row) {
        if (n3 == -1) {
            int n4 = row.getValue(3).getInt();
            if (this.L == null) {
                this.L = New.hashMap();
            }
            this.L.put(n4, n2);
        }
    }

    void redoDelete(int n2, int n3, long l2) {
        Index index = (Index)this.void.get(n3);
        PageDataIndex pageDataIndex = (PageDataIndex)index;
        Row row = pageDataIndex.getRowWithKey(l2);
        this.redo(n2, n3, row, false);
    }

    void redo(int n2, int n3, Row row, boolean bl) {
        Index index;
        if (n3 == -1) {
            if (bl) {
                this.a(row, this.byte, true);
            } else {
                this.a(n2, row);
            }
        }
        if ((index = (Index)this.void.get(n3)) == null) {
            throw DbException.throwInternalError("Table not found: " + n3 + " " + row + " " + bl);
        }
        Table table = index.getTable();
        if (bl) {
            table.addRow(this.byte, row);
        } else {
            table.removeRow(this.byte, row);
        }
    }

    void redoTruncate(int n2) {
        Index index = (Index)this.void.get(n2);
        Table table = index.getTable();
        table.truncate(this.byte);
    }

    private void for() {
        CreateTableData createTableData = new CreateTableData();
        ArrayList arrayList = createTableData.columns;
        arrayList.add(new Column("ID", 4));
        arrayList.add(new Column("TYPE", 4));
        arrayList.add(new Column("PARENT", 4));
        arrayList.add(new Column("HEAD", 4));
        arrayList.add(new Column("OPTIONS", 13));
        arrayList.add(new Column("COLUMNS", 13));
        createTableData.schema = this.int = new Schema(this.A, 0, "", null, true);
        createTableData.tableName = "PAGE_INDEX";
        createTableData.id = -1;
        createTableData.temporary = false;
        createTableData.persistData = true;
        createTableData.persistIndexes = true;
        createTableData.create = false;
        createTableData.session = this.byte;
        this.F = new RegularTable(createTableData);
        this.do = (PageDataIndex)this.F.getScanIndex(this.byte);
        this.void.clear();
        this.void.put(-1, this.do);
    }

    private void a() {
        int n2;
        Row row;
        Cursor cursor = this.do.find(this.byte, null, null);
        while (cursor.next()) {
            row = cursor.get();
            n2 = row.getValue(1).getInt();
            if (n2 != 0) continue;
            this.a(row, this.byte, false);
        }
        cursor = this.do.find(this.byte, null, null);
        while (cursor.next()) {
            row = cursor.get();
            n2 = row.getValue(1).getInt();
            if (n2 == 0) continue;
            this.a(row, this.byte, false);
        }
    }

    private void a(int n2, Row row) {
        int n3 = row.getValue(0).getInt();
        PageIndex pageIndex = (PageIndex)this.void.get(n3);
        pageIndex.getTable().removeIndex(pageIndex);
        if (pageIndex instanceof PageBtreeIndex || pageIndex instanceof PageDelegateIndex) {
            if (pageIndex.isTemporary()) {
                this.byte.removeLocalTempTableIndex(pageIndex);
            } else {
                pageIndex.getSchema().remove(pageIndex);
            }
        }
        pageIndex.remove(this.byte);
        this.void.remove(n3);
    }

    private void a(Row row, Session session, boolean bl) {
        Index index;
        Object object;
        int n2 = row.getValue(0).getInt();
        int n3 = row.getValue(1).getInt();
        int n4 = row.getValue(2).getInt();
        int n5 = row.getValue(3).getInt();
        String string = row.getValue(4).getString();
        String string2 = row.getValue(5).getString();
        String[] stringArray = StringUtils.arraySplit(string2, ',', false);
        String[] stringArray2 = StringUtils.arraySplit(string, ',', false);
        if (this.h.isDebugEnabled()) {
            this.h.debug("addMeta id={0} type={1} root={2} parent={3} columns={4}", n2, n3, n5, n4, string2);
        }
        if (bl && n5 != 0) {
            this.writePage(n5, this.createData());
            this.allocatePage(n5);
        }
        this.I.put(n2, n5);
        if (n3 == 0) {
            object = new CreateTableData();
            if (SysProperties.CHECK && stringArray == null) {
                throw DbException.throwInternalError(row.toString());
            }
            int n6 = stringArray.length;
            for (int i2 = 0; i2 < n6; ++i2) {
                Column column = new Column("C" + i2, 4);
                ((CreateTableData)object).columns.add(column);
            }
            ((CreateTableData)object).schema = this.int;
            ((CreateTableData)object).tableName = "T" + n2;
            ((CreateTableData)object).id = n2;
            ((CreateTableData)object).temporary = stringArray2[2].equals("temp");
            ((CreateTableData)object).persistData = true;
            ((CreateTableData)object).persistIndexes = true;
            ((CreateTableData)object).create = false;
            ((CreateTableData)object).session = session;
            RegularTable regularTable = new RegularTable((CreateTableData)object);
            CompareMode compareMode = CompareMode.getInstance(stringArray2[0], Integer.parseInt(stringArray2[1]));
            regularTable.setCompareMode(compareMode);
            index = regularTable.getScanIndex(session);
        } else {
            IndexType indexType;
            Object object2;
            object = (Index)this.void.get(n4);
            if (object == null) {
                throw DbException.get(90030, "Table not found:" + n4 + " for " + row + " meta:" + this.void);
            }
            RegularTable regularTable = (RegularTable)object.getTable();
            Column[] columnArray = regularTable.getColumns();
            int n7 = stringArray.length;
            IndexColumn[] indexColumnArray = new IndexColumn[n7];
            for (int i3 = 0; i3 < n7; ++i3) {
                Object object3;
                object2 = stringArray[i3];
                IndexColumn[] indexColumnArray2 = new IndexColumn();
                int n8 = object2.indexOf(47);
                if (n8 >= 0) {
                    object3 = object2.substring(n8 + 1);
                    indexColumnArray2.sortType = Integer.parseInt((String)object3);
                    object2 = object2.substring(0, n8);
                }
                indexColumnArray2.column = object3 = columnArray[Integer.parseInt((String)object2)];
                indexColumnArray[i3] = indexColumnArray2;
            }
            if (stringArray2[3].equals("d")) {
                indexType = IndexType.createPrimaryKey(true, false);
                object2 = regularTable.getColumns();
                for (IndexColumn indexColumn : indexColumnArray) {
                    object2[indexColumn.column.getColumnId()].setNullable(false);
                }
            } else {
                indexType = IndexType.createNonUnique(true);
            }
            index = regularTable.addIndex(session, "I" + n2, n2, indexColumnArray, indexType, false, null);
        }
        object = index instanceof MultiVersionIndex ? (PageIndex)((MultiVersionIndex)index).getBaseIndex() : (PageIndex)index;
        this.void.put(n2, object);
    }

    public void addIndex(PageIndex pageIndex) {
        this.void.put(pageIndex.getId(), pageIndex);
    }

    /*
     * WARNING - void declaration
     */
    public void addMeta(PageIndex pageIndex, Session session) {
        void var9_18;
        void var9_15;
        int n2 = pageIndex instanceof PageDataIndex ? 0 : 1;
        IndexColumn[] indexColumnArray = pageIndex.getIndexColumns();
        StatementBuilder statementBuilder = new StatementBuilder();
        for (IndexColumn indexColumn : indexColumnArray) {
            statementBuilder.appendExceptFirst(",");
            int n3 = indexColumn.column.getColumnId();
            statementBuilder.append(n3);
            int n4 = indexColumn.sortType;
            if (n4 == 0) continue;
            statementBuilder.append('/');
            statementBuilder.append(n4);
        }
        String string = statementBuilder.toString();
        Table table = pageIndex.getTable();
        CompareMode compareMode = table.getCompareMode();
        String string2 = compareMode.getName() + "," + compareMode.getStrength() + ",";
        if (table.isTemporary()) {
            String string3 = string2 + "temp";
        }
        String string4 = (String)var9_15 + ",";
        if (pageIndex instanceof PageDelegateIndex) {
            String string5 = string4 + "d";
        }
        Row row = this.F.getTemplateRow();
        row.setValue(0, ValueInt.get(pageIndex.getId()));
        row.setValue(1, ValueInt.get(n2));
        row.setValue(2, ValueInt.get(table.getId()));
        row.setValue(3, ValueInt.get(pageIndex.getRootPageId()));
        row.setValue(4, ValueString.get((String)var9_18));
        row.setValue(5, ValueString.get(string));
        row.setKey(pageIndex.getId() + 1);
        this.do.add(session, row);
    }

    public void removeMeta(Index index, Session session) {
        if (!this.t) {
            this.a(index, session);
            this.void.remove(index.getId());
        }
    }

    private void a(Index index, Session session) {
        int n2 = index.getId() + 1;
        Row row = this.do.getRow(session, n2);
        if (row.getKey() != (long)n2) {
            throw DbException.get(90030, "key: " + n2 + " index: " + index + " table: " + index.getTable() + " row: " + row);
        }
        this.do.remove(session, row);
    }

    public void setMaxLogSize(long l2) {
        this.v = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInDoubtTransactionState(int n2, int n3, boolean bl) {
        boolean bl2 = this.A.isReadOnly();
        try {
            this.A.setReadOnly(false);
            this.case.setInDoubtTransactionState(n2, n3, bl);
        }
        finally {
            this.A.setReadOnly(bl2);
        }
    }

    public ArrayList getInDoubtTransactions() {
        return this.case.getInDoubtTransactions();
    }

    public boolean isRecoveryRunning() {
        return this.t;
    }

    private void int() {
        if (this.e == null) {
            throw DbException.get(90098);
        }
    }

    public long getWriteCountTotal() {
        return this.j + this.x;
    }

    public long getWriteCount() {
        return this.j;
    }

    public long getReadCount() {
        return this.H;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logTruncate(Session session, int n2) {
        Database database = this.A;
        synchronized (database) {
            if (!this.t) {
                this.case.logTruncate(session, n2);
            }
        }
    }

    public int getRootPageId(int n2) {
        return this.I.get(n2);
    }

    public Cache getCache() {
        return this.goto;
    }

    private void a(byte[] byArray, int n2) {
        int n3 = this.p;
        byte by = byArray[0];
        if (by == 0) {
            return;
        }
        int n4 = 255 + (by & 0xFF);
        int n5 = 255 + n4;
        n5 += (n4 += byArray[6] & 0xFF);
        n5 += (n4 += byArray[(n3 >> 1) - 1] & 0xFF);
        n5 += (n4 += byArray[n3 >> 1] & 0xFF);
        n5 += (n4 += byArray[n3 - 2] & 0xFF);
        byArray[1] = (byte)((n4 & 0xFF) + (n4 >> 8) ^ n2);
        byArray[2] = (byte)(((n5 += (n4 += byArray[n3 - 1] & 0xFF)) & 0xFF) + (n5 >> 8) ^ n2 >> 8);
    }

    public static boolean checksumTest(byte[] byArray, int n2, int n3) {
        int n4 = n3;
        int n5 = 255 + (byArray[0] & 0xFF);
        int n6 = 255 + n5;
        n6 += (n5 += byArray[6] & 0xFF);
        n6 += (n5 += byArray[(n4 >> 1) - 1] & 0xFF);
        n6 += (n5 += byArray[n4 >> 1] & 0xFF);
        n6 += (n5 += byArray[n4 - 2] & 0xFF);
        return byArray[1] == (byte)((n5 & 0xFF) + (n5 >> 8) ^ n2) && byArray[2] == (byte)(((n6 += (n5 += byArray[n4 - 1] & 0xFF)) & 0xFF) + (n6 >> 8) ^ n2 >> 8);
    }

    public void incrementChangeCount() {
        ++this.y;
    }

    public int getChangeCount() {
        return this.y;
    }

    public void setLogMode(int n2) {
        this.f = n2;
    }

    public int getLogMode() {
        return this.f;
    }

    public void setLockFile(boolean bl) {
        this.B = bl;
    }
}

