/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.h2.message.DbException;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileObjectInputStream;
import org.h2.store.fs.FileObjectMemory;
import org.h2.store.fs.FileObjectMemoryData;
import org.h2.store.fs.FileObjectOutputStream;
import org.h2.store.fs.FileSystem;
import org.h2.util.IOUtils;
import org.h2.util.New;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileSystemMemory
extends FileSystem {
    public static final String PREFIX = "memFS:";
    public static final String PREFIX_LZF = "memLZF:";
    private static final FileSystemMemory byte = new FileSystemMemory();
    private static final TreeMap try = new TreeMap();

    private FileSystemMemory() {
    }

    public static FileSystemMemory getInstance() {
        return byte;
    }

    public long length(String string) {
        return this.a(string).length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String string, String string2) {
        string = this.normalize(string);
        string2 = this.normalize(string2);
        TreeMap treeMap = try;
        synchronized (treeMap) {
            FileObjectMemoryData fileObjectMemoryData = this.a(string);
            fileObjectMemoryData.setName(string2);
            try.remove(string);
            try.put(string2, fileObjectMemoryData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createNewFile(String string) {
        TreeMap treeMap = try;
        synchronized (treeMap) {
            if (this.exists(string)) {
                return false;
            }
            this.a(string);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String string) {
        string = this.normalize(string);
        TreeMap treeMap = try;
        synchronized (treeMap) {
            return try.get(string) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String string) {
        string = this.normalize(string);
        TreeMap treeMap = try;
        synchronized (treeMap) {
            try.remove(string);
        }
    }

    public boolean tryDelete(String string) {
        this.delete(string);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listFiles(String string) {
        ArrayList arrayList = New.arrayList();
        TreeMap treeMap = try;
        synchronized (treeMap) {
            for (String string2 : try.tailMap(string).keySet()) {
                if (!string2.startsWith(string)) break;
                arrayList.add(string2);
            }
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecursive(String string, boolean bl) {
        string = this.normalize(string);
        TreeMap treeMap = try;
        synchronized (treeMap) {
            String string2;
            Iterator<String> iterator = try.tailMap(string).keySet().iterator();
            while (iterator.hasNext() && (string2 = iterator.next()).startsWith(string)) {
                iterator.remove();
            }
        }
    }

    public boolean isReadOnly(String string) {
        return !this.a(string).canWrite();
    }

    public boolean setReadOnly(String string) {
        return this.a(string).setReadOnly();
    }

    public String normalize(String string) {
        int n2 = (string = string.replace('\\', '/')).indexOf(":/");
        if (n2 > 0) {
            string = string.substring(0, n2 + 1) + string.substring(n2 + 2);
        }
        return string;
    }

    public String getParent(String string) {
        int n2 = (string = this.normalize(string)).lastIndexOf(47);
        if (n2 < 0) {
            n2 = string.indexOf(58) + 1;
        }
        return string.substring(0, n2);
    }

    public boolean isDirectory(String string) {
        return false;
    }

    public boolean isAbsolute(String string) {
        return true;
    }

    public String getAbsolutePath(String string) {
        return this.normalize(string);
    }

    public long getLastModified(String string) {
        return this.a(string).getLastModified();
    }

    public boolean canWrite(String string) {
        return true;
    }

    public void copy(String string, String string2) {
        try {
            OutputStream outputStream = this.openFileOutputStream(string2, false);
            InputStream inputStream = this.openFileInputStream(string);
            IOUtils.copyAndClose(inputStream, outputStream);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, "Can not copy " + string + " to " + string2);
        }
    }

    public void createDirs(String string) {
    }

    public String getFileName(String string) {
        int n2 = Math.max(string.indexOf(58), string.lastIndexOf(47));
        return n2 < 0 ? string : string.substring(n2 + 1);
    }

    public boolean fileStartsWith(String string, String string2) {
        string = this.normalize(string);
        string2 = this.normalize(string2);
        return string.startsWith(string2);
    }

    public OutputStream openFileOutputStream(String string, boolean bl) {
        try {
            FileObjectMemoryData fileObjectMemoryData = this.a(string);
            FileObjectMemory fileObjectMemory = new FileObjectMemory(fileObjectMemoryData);
            return new FileObjectOutputStream(fileObjectMemory, bl);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, string);
        }
    }

    public InputStream openFileInputStream(String string) {
        FileObjectMemoryData fileObjectMemoryData = this.a(string);
        FileObjectMemory fileObjectMemory = new FileObjectMemory(fileObjectMemoryData);
        return new FileObjectInputStream(fileObjectMemory);
    }

    public FileObject openFileObject(String string, String string2) {
        FileObjectMemoryData fileObjectMemoryData = this.a(string);
        return new FileObjectMemory(fileObjectMemoryData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObjectMemoryData a(String string) {
        string = this.normalize(string);
        TreeMap treeMap = try;
        synchronized (treeMap) {
            FileObjectMemoryData fileObjectMemoryData = (FileObjectMemoryData)try.get(string);
            if (fileObjectMemoryData == null) {
                boolean bl = string.startsWith(PREFIX_LZF);
                fileObjectMemoryData = new FileObjectMemoryData(string, bl);
                try.put(string, fileObjectMemoryData);
            }
            return fileObjectMemoryData;
        }
    }

    protected boolean accepts(String string) {
        return string.startsWith(PREFIX) || string.startsWith(PREFIX_LZF);
    }
}

