/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.Time;
import java.sql.Timestamp;
import org.h2.command.Parser;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.SequenceValue;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.SingleColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Column {
    public static final int NOT_NULLABLE = 0;
    public static final int NULLABLE = 1;
    public static final int NULLABLE_UNKNOWN = 2;
    private final int new;
    private final long c;
    private final int i;
    private final int e;
    private Table d;
    private String j;
    private int a;
    private boolean void = true;
    private Expression for;
    private Expression case;
    private String b;
    private String char;
    private boolean long;
    private long try;
    private long h;
    private boolean int;
    private Sequence goto;
    private boolean f;
    private TableFilter g;
    private int else;
    private SingleColumnResolver byte;
    private String do;
    private boolean if;

    public Column(String string, int n2) {
        this(string, n2, -1L, -1, -1);
    }

    public Column(String string, int n2, long l2, int n3, int n4) {
        this.j = string;
        this.new = n2;
        if (l2 == -1L && n3 == -1 && n4 == -1) {
            DataType dataType = DataType.getDataType(n2);
            l2 = dataType.defaultPrecision;
            n3 = dataType.defaultScale;
            n4 = dataType.defaultDisplaySize;
        }
        this.c = l2;
        this.i = n3;
        this.e = n4;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Column)) {
            return false;
        }
        Column column = (Column)object;
        if (this.d == null || column.d == null || this.j == null || column.j == null) {
            return false;
        }
        return this.d == column.d && this.j.equals(column.j);
    }

    public int hashCode() {
        if (this.d == null || this.j == null) {
            return 0;
        }
        return this.d.getId() ^ this.j.hashCode();
    }

    public Column getClone() {
        Column column = new Column(this.j, this.new, this.c, this.i, this.e);
        column.void = this.void;
        column.for = this.for;
        column.char = this.char;
        column.int = this.int;
        column.goto = this.goto;
        column.do = this.do;
        column.g = this.g;
        column.f = this.f;
        column.else = this.else;
        column.if = this.if;
        return column;
    }

    public Value convert(Value value) {
        try {
            return value.convertTo(this.new);
        }
        catch (DbException dbException) {
            if (dbException.getErrorCode() == 90021) {
                throw DbException.get(90021, value.getSQL() + " (" + this.getCreateSQL() + ")");
            }
            throw dbException;
        }
    }

    boolean getComputed() {
        return this.f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Value computeValue(Session session, Row row) {
        Column column = this;
        synchronized (column) {
            this.g.setSession(session);
            this.g.set(row);
            return this.for.getValue(session);
        }
    }

    public void setComputedExpression(Expression expression) {
        this.f = true;
        this.for = expression;
    }

    public void setTable(Table table, int n2) {
        this.d = table;
        this.a = n2;
    }

    public Table getTable() {
        return this.d;
    }

    public void setDefaultExpression(Session session, Expression expression) {
        if (expression != null && (expression = expression.optimize(session)).isConstant()) {
            expression = ValueExpression.get(expression.getValue(session));
        }
        this.for = expression;
    }

    public int getColumnId() {
        return this.a;
    }

    public String getSQL() {
        return Parser.quoteIdentifier(this.j);
    }

    public String getName() {
        return this.j;
    }

    public int getType() {
        return this.new;
    }

    public long getPrecision() {
        return this.c;
    }

    public int getDisplaySize() {
        return this.e;
    }

    public int getScale() {
        return this.i;
    }

    public void setNullable(boolean bl) {
        this.void = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value validateConvertUpdateSequence(Session session, Value value) {
        Object object;
        Object object2;
        if (value == null) {
            if (this.for == null) {
                value = ValueNull.INSTANCE;
            } else {
                object2 = this;
                synchronized (object2) {
                    value = this.for.getValue(session).convertTo(this.new);
                }
                if (this.if) {
                    session.setLastIdentity(value);
                }
            }
        }
        object2 = session.getDatabase().getMode();
        if (value == ValueNull.INSTANCE) {
            if (this.int) {
                object = this;
                synchronized (object) {
                    value = this.for.getValue(session).convertTo(this.new);
                }
            }
            if (value == ValueNull.INSTANCE && !this.void) {
                if (((Mode)object2).convertInsertNullToZero) {
                    object = DataType.getDataType(this.new);
                    value = ((DataType)object).decimal ? ValueInt.get(0).convertTo(this.new) : (((DataType)object).type == 11 ? ValueTimestamp.getNoCopy(new Timestamp(System.currentTimeMillis())) : (((DataType)object).type == 9 ? ValueTime.get(Time.valueOf("0:0:0")) : (((DataType)object).type == 10 ? ValueTimestamp.getNoCopy(new Timestamp(System.currentTimeMillis())).convertTo(((DataType)object).type) : ValueString.get("").convertTo(this.new))));
                } else {
                    throw DbException.get(90006, this.j);
                }
            }
        }
        if (this.case != null) {
            this.byte.setValue(value);
            Column column = this;
            synchronized (column) {
                object = this.case.getValue(session);
            }
            if (Boolean.FALSE.equals(((Value)object).getBoolean())) {
                throw DbException.get(23000, this.case.getSQL());
            }
        }
        value = value.convertScale(((Mode)object2).convertOnlyToSmallerScale, this.i);
        if (this.c > 0L && !value.checkPrecision(this.c)) {
            object = value.getTraceSQL();
            if (((String)object).length() > 127) {
                object = ((String)object).substring(0, 128) + "...";
            }
            throw DbException.get(90005, this.getCreateSQL(), (String)object + " (" + value.getPrecision() + ")");
        }
        this.a(session, value);
        return value;
    }

    private void a(Session session, Value value) {
        if (this.goto != null) {
            long l2 = this.goto.getCurrentValue();
            long l3 = this.goto.getIncrement();
            long l4 = value.getLong();
            boolean bl = false;
            if (l3 > 0L && l4 > l2) {
                bl = true;
            } else if (l3 < 0L && l4 < l2) {
                bl = true;
            }
            if (bl) {
                this.goto.setStartValue(l4 + l3);
                session.setLastIdentity(ValueLong.get(l4));
                this.goto.flush(session);
            }
        }
    }

    public void convertAutoIncrementToSequence(Session session, Schema schema, int n2, boolean bl) {
        String string;
        Object object;
        if (!this.long) {
            DbException.throwInternalError();
        }
        if ("IDENTITY".equals(this.char)) {
            this.char = "BIGINT";
        }
        int n3 = 0;
        while (true) {
            object = ValueUuid.getNewRandom();
            String string2 = ((ValueUuid)object).getString();
            string2 = string2.replace('-', '_').toUpperCase();
            string = "SYSTEM_SEQUENCE_" + string2;
            if (schema.findSequence(string) == null) break;
            ++n3;
        }
        Sequence sequence = new Sequence(schema, n2, string, true);
        sequence.setStartValue(this.try);
        sequence.setIncrement(this.h);
        if (!bl) {
            session.getDatabase().addSchemaObject(session, sequence);
        }
        this.setAutoIncrement(false, 0L, 0L);
        object = new SequenceValue(sequence);
        this.setDefaultExpression(session, (Expression)object);
        this.setSequence(sequence);
    }

    public void prepareExpression(Session session) {
        if (this.for != null) {
            this.g = new TableFilter(session, this.d, null, false, null);
            this.for.mapColumns(this.g, 0);
            this.for = this.for.optimize(session);
        }
    }

    public String getCreateSQL() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.j != null) {
            stringBuilder.append(Parser.quoteIdentifier(this.j)).append(' ');
        }
        if (this.char != null) {
            stringBuilder.append(this.char);
        } else {
            stringBuilder.append(DataType.getDataType((int)this.new).name);
            switch (this.new) {
                case 6: {
                    stringBuilder.append('(').append(this.c).append(", ").append(this.i).append(')');
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 21: {
                    if (this.c >= Integer.MAX_VALUE) break;
                    stringBuilder.append('(').append(this.c).append(')');
                    break;
                }
            }
        }
        if (this.for != null && (string = this.for.getSQL()) != null) {
            if (this.f) {
                stringBuilder.append(" AS ").append(string);
            } else if (this.for != null) {
                stringBuilder.append(" DEFAULT ").append(string);
            }
        }
        if (!this.void) {
            stringBuilder.append(" NOT NULL");
        }
        if (this.int) {
            stringBuilder.append(" NULL_TO_DEFAULT");
        }
        if (this.goto != null) {
            stringBuilder.append(" SEQUENCE ").append(this.goto.getSQL());
        }
        if (this.else != 0) {
            stringBuilder.append(" SELECTIVITY ").append(this.else);
        }
        if (this.do != null) {
            stringBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.do));
        }
        if (this.case != null) {
            stringBuilder.append(" CHECK ").append(this.b);
        }
        return stringBuilder.toString();
    }

    public boolean isNullable() {
        return this.void;
    }

    public void setOriginalSQL(String string) {
        this.char = string;
    }

    public String getOriginalSQL() {
        return this.char;
    }

    public Expression getDefaultExpression() {
        return this.for;
    }

    public boolean isAutoIncrement() {
        return this.long;
    }

    public void setAutoIncrement(boolean bl, long l2, long l3) {
        this.long = bl;
        this.try = l2;
        this.h = l3;
        this.void = false;
        if (bl) {
            this.int = true;
        }
    }

    public void setConvertNullToDefault(boolean bl) {
        this.int = bl;
    }

    public void rename(String string) {
        this.j = string;
    }

    public void setSequence(Sequence sequence) {
        this.goto = sequence;
    }

    public Sequence getSequence() {
        return this.goto;
    }

    public int getSelectivity() {
        return this.else == 0 ? 50 : this.else;
    }

    public void setSelectivity(int n2) {
        this.else = n2 = n2 < 0 ? 0 : (n2 > 100 ? 100 : n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCheckConstraint(Session session, Expression expression) {
        this.byte = new SingleColumnResolver(this);
        Column column = this;
        synchronized (column) {
            String string = this.j;
            if (this.j == null) {
                this.j = "VALUE";
            }
            expression.mapColumns(this.byte, 0);
            this.j = string;
        }
        expression = expression.optimize(session);
        this.byte.setValue(ValueNull.INSTANCE);
        column = this;
        synchronized (column) {
            expression.getValue(session);
        }
        this.case = this.case == null ? expression : new ConditionAndOr(0, this.case, expression);
        this.b = this.getCheckConstraintSQL(session, this.j);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getCheckConstraint(Session session, String string) {
        String string2;
        if (this.case == null) {
            return null;
        }
        Parser parser = new Parser(session);
        Object object = this;
        synchronized (object) {
            String string3 = this.j;
            this.j = string;
            string2 = this.case.getSQL();
            this.j = string3;
        }
        object = parser.parseExpression(string2);
        return object;
    }

    String getDefaultSQL() {
        return this.for == null ? null : this.for.getSQL();
    }

    int getPrecisionAsInt() {
        return MathUtils.convertLongToInt(this.c);
    }

    DataType getDataType() {
        return DataType.getDataType(this.new);
    }

    String getCheckConstraintSQL(Session session, String string) {
        Expression expression = this.getCheckConstraint(session, string);
        return expression == null ? "" : expression.getSQL();
    }

    public void setComment(String string) {
        this.do = string;
    }

    public String getComment() {
        return this.do;
    }

    public void setPrimaryKey(boolean bl) {
        this.if = bl;
    }

    boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (expressionVisitor.getType() == 7 && this.goto != null) {
            expressionVisitor.getDependencies().add(this.goto);
        }
        if (this.for != null && !this.for.isEverything(expressionVisitor)) {
            return false;
        }
        return this.case == null || this.case.isEverything(expressionVisitor);
    }

    public boolean isPrimaryKey() {
        return this.if;
    }

    public String toString() {
        return this.j;
    }
}

