/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.FunctionCall;
import org.h2.expression.TableFunction;
import org.h2.index.FunctionIndex;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FunctionTable
extends Table {
    private final FunctionCall aH;
    private final long aJ;
    private Expression aI;
    private LocalResult aK;
    private Value aL;

    public FunctionTable(Schema schema, Session session, Expression expression, FunctionCall functionCall) {
        super(schema, 0, functionCall.getName(), false, true);
        this.aI = expression;
        this.aH = functionCall;
        this.aJ = functionCall instanceof TableFunction ? ((TableFunction)functionCall).getRowCount() : Long.MAX_VALUE;
        functionCall.optimize(session);
        int n2 = functionCall.getType();
        if (n2 != 18) {
            throw DbException.get(90000, functionCall.getName());
        }
        int n3 = functionCall.getParameterCount();
        Expression[] expressionArray = new Expression[n3];
        Expression[] expressionArray2 = functionCall.getArgs();
        for (int i2 = 0; i2 < n3; ++i2) {
            expressionArray2[i2] = expressionArray2[i2].optimize(session);
            expressionArray[i2] = expressionArray2[i2];
        }
        ValueResultSet valueResultSet = functionCall.getValueForColumnList(session, expressionArray);
        if (valueResultSet == null) {
            throw DbException.get(90000, functionCall.getName());
        }
        ResultSet resultSet = valueResultSet.getResultSet();
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n4 = resultSetMetaData.getColumnCount();
            Column[] columnArray = new Column[n4];
            for (int i3 = 0; i3 < n4; ++i3) {
                columnArray[i3] = new Column(resultSetMetaData.getColumnName(i3 + 1), DataType.convertSQLTypeToValueType(resultSetMetaData.getColumnType(i3 + 1)), resultSetMetaData.getPrecision(i3 + 1), resultSetMetaData.getScale(i3 + 1), resultSetMetaData.getColumnDisplaySize(i3 + 1));
            }
            this.setColumns(columnArray);
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    public void lock(Session session, boolean bl, boolean bl2) {
    }

    public void close(Session session) {
    }

    public void unlock(Session session) {
    }

    public boolean isLockedExclusively() {
        return false;
    }

    public Index addIndex(Session session, String string, int n2, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    public void truncate(Session session) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    public boolean canDrop() {
        throw DbException.throwInternalError();
    }

    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("ALIAS");
    }

    public String getTableType() {
        return null;
    }

    public Index getScanIndex(Session session) {
        return new FunctionIndex(this, IndexColumn.wrap(this.columns));
    }

    public ArrayList getIndexes() {
        return null;
    }

    public boolean canGetRowCount() {
        return this.aJ != Long.MAX_VALUE;
    }

    public long getRowCount(Session session) {
        return this.aJ;
    }

    public String getCreateSQL() {
        return null;
    }

    public String getDropSQL() {
        return null;
    }

    public void checkRename() {
        throw DbException.getUnsupportedException("ALIAS");
    }

    public ResultInterface getResult(Session session) {
        ValueResultSet valueResultSet = this.int(session);
        if (valueResultSet == null) {
            return null;
        }
        if (this.aK != null && this.aL == valueResultSet) {
            this.aK.reset();
            return this.aK;
        }
        LocalResult localResult = LocalResult.read(session, valueResultSet.getResultSet(), 0);
        if (this.aH.isDeterministic()) {
            this.aK = localResult;
            this.aL = valueResultSet;
        }
        return localResult;
    }

    public ResultSet getResultSet(Session session) {
        ValueResultSet valueResultSet = this.int(session);
        return valueResultSet == null ? null : valueResultSet.getResultSet();
    }

    private ValueResultSet int(Session session) {
        this.aI = this.aI.optimize(session);
        Value value = this.aI.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return null;
        }
        return (ValueResultSet)value;
    }

    public boolean isFast() {
        return this.aH.isFast();
    }

    public long getMaxDataModificationId() {
        return Long.MAX_VALUE;
    }

    public Index getUniqueIndex() {
        return null;
    }

    public String getSQL() {
        return this.aH.getSQL();
    }

    public long getRowCountApproximation() {
        return this.aJ;
    }

    public boolean isDeterministic() {
        return this.aH.isDeterministic();
    }

    public boolean canReference() {
        return false;
    }
}

