/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import org.h2.command.Command;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintCheck;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.expression.ValueExpression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MetaIndex;
import org.h2.index.MultiVersionIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.store.InDoubtTransaction;
import org.h2.store.PageStore;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableView;
import org.h2.tools.Csv;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;
import org.h2.value.ValueStringIgnoreCase;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MetaTable
extends Table {
    public static final long ROW_COUNT_APPROXIMATION = 1000L;
    private static final String be = "Unicode";
    private static final int bd = 0;
    private static final int a8 = 1;
    private static final int a0 = 2;
    private static final int bc = 3;
    private static final int aZ = 4;
    private static final int bl = 5;
    private static final int bg = 6;
    private static final int aP = 7;
    private static final int bj = 8;
    private static final int aS = 9;
    private static final int aT = 10;
    private static final int aX = 11;
    private static final int aY = 12;
    private static final int bk = 13;
    private static final int bh = 14;
    private static final int aW = 15;
    private static final int bf = 16;
    private static final int bi = 17;
    private static final int a1 = 18;
    private static final int bb = 19;
    private static final int a3 = 20;
    private static final int a5 = 21;
    private static final int aU = 22;
    private static final int a4 = 23;
    private static final int aR = 24;
    private static final int aQ = 25;
    private static final int a2 = 26;
    private static final int ba = 27;
    private static final int a7 = 28;
    private final int aV;
    private final int a6;
    private MetaIndex a9;

    public MetaTable(Schema schema, int n2, int n3) {
        super(schema, n2, null, true, true);
        Column[] columnArray;
        this.aV = n3;
        String string = null;
        switch (n3) {
            case 0: {
                this.setObjectName("TABLES");
                columnArray = this.a("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "TABLE_TYPE", "STORAGE_TYPE", "SQL", "REMARKS", "LAST_MODIFICATION BIGINT", "ID INT", "TYPE_NAME", "TABLE_CLASS");
                string = "TABLE_NAME";
                break;
            }
            case 1: {
                this.setObjectName("COLUMNS");
                columnArray = this.a("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "ORDINAL_POSITION INT", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "CHARACTER_MAXIMUM_LENGTH INT", "CHARACTER_OCTET_LENGTH INT", "NUMERIC_PRECISION INT", "NUMERIC_PRECISION_RADIX INT", "NUMERIC_SCALE INT", "CHARACTER_SET_NAME", "COLLATION_NAME", "TYPE_NAME", "NULLABLE INT", "IS_COMPUTED BIT", "SELECTIVITY INT", "CHECK_CONSTRAINT", "SEQUENCE_NAME", "REMARKS", "SOURCE_DATA_TYPE SMALLINT");
                string = "TABLE_NAME";
                break;
            }
            case 2: {
                this.setObjectName("INDEXES");
                columnArray = this.a("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "NON_UNIQUE BIT", "INDEX_NAME", "ORDINAL_POSITION SMALLINT", "COLUMN_NAME", "CARDINALITY INT", "PRIMARY_KEY BIT", "INDEX_TYPE_NAME", "IS_GENERATED BIT", "INDEX_TYPE SMALLINT", "ASC_OR_DESC", "PAGES INT", "FILTER_CONDITION", "REMARKS", "SQL", "ID INT", "SORT_TYPE INT", "CONSTRAINT_NAME", "INDEX_CLASS");
                string = "TABLE_NAME";
                break;
            }
            case 3: {
                this.setObjectName("TABLE_TYPES");
                columnArray = this.a(new String[]{"TYPE"});
                break;
            }
            case 4: {
                this.setObjectName("TYPE_INFO");
                columnArray = this.a("TYPE_NAME", "DATA_TYPE INT", "PRECISION INT", "PREFIX", "SUFFIX", "PARAMS", "AUTO_INCREMENT BIT", "MINIMUM_SCALE SMALLINT", "MAXIMUM_SCALE SMALLINT", "RADIX INT", "POS INT", "CASE_SENSITIVE BIT", "NULLABLE SMALLINT", "SEARCHABLE SMALLINT");
                break;
            }
            case 5: {
                this.setObjectName("CATALOGS");
                columnArray = this.a(new String[]{"CATALOG_NAME"});
                break;
            }
            case 6: {
                this.setObjectName("SETTINGS");
                columnArray = this.a("NAME", "VALUE");
                break;
            }
            case 7: {
                this.setObjectName("HELP");
                columnArray = this.a("ID INT", "SECTION", "TOPIC", "SYNTAX", "TEXT");
                break;
            }
            case 8: {
                this.setObjectName("SEQUENCES");
                columnArray = this.a("SEQUENCE_CATALOG", "SEQUENCE_SCHEMA", "SEQUENCE_NAME", "CURRENT_VALUE BIGINT", "INCREMENT BIGINT", "IS_GENERATED BIT", "REMARKS", "CACHE BIGINT", "ID INT");
                break;
            }
            case 9: {
                this.setObjectName("USERS");
                columnArray = this.a("NAME", "ADMIN", "REMARKS", "ID INT");
                break;
            }
            case 10: {
                this.setObjectName("ROLES");
                columnArray = this.a("NAME", "REMARKS", "ID INT");
                break;
            }
            case 11: {
                this.setObjectName("RIGHTS");
                columnArray = this.a("GRANTEE", "GRANTEETYPE", "GRANTEDROLE", "RIGHTS", "TABLE_SCHEMA", "TABLE_NAME", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 12: {
                this.setObjectName("FUNCTION_ALIASES");
                columnArray = this.a("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "DATA_TYPE INT", "COLUMN_COUNT INT", "RETURNS_RESULT SMALLINT", "REMARKS", "ID INT", "SOURCE");
                break;
            }
            case 21: {
                this.setObjectName("FUNCTION_COLUMNS");
                columnArray = this.a("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "COLUMN_COUNT INT", "POS INT", "COLUMN_NAME", "DATA_TYPE INT", "TYPE_NAME", "PRECISION INT", "SCALE SMALLINT", "RADIX SMALLINT", "NULLABLE SMALLINT", "COLUMN_TYPE SMALLINT", "REMARKS", "COLUMN_DEFAULT");
                break;
            }
            case 13: {
                this.setObjectName("SCHEMATA");
                columnArray = this.a("CATALOG_NAME", "SCHEMA_NAME", "SCHEMA_OWNER", "DEFAULT_CHARACTER_SET_NAME", "DEFAULT_COLLATION_NAME", "IS_DEFAULT BIT", "REMARKS", "ID INT");
                break;
            }
            case 14: {
                this.setObjectName("TABLE_PRIVILEGES");
                columnArray = this.a("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                string = "TABLE_NAME";
                break;
            }
            case 15: {
                this.setObjectName("COLUMN_PRIVILEGES");
                columnArray = this.a("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                string = "TABLE_NAME";
                break;
            }
            case 16: {
                this.setObjectName("COLLATIONS");
                columnArray = this.a("NAME", "KEY");
                break;
            }
            case 17: {
                this.setObjectName("VIEWS");
                columnArray = this.a("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "VIEW_DEFINITION", "CHECK_OPTION", "IS_UPDATABLE", "STATUS", "REMARKS", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 18: {
                this.setObjectName("IN_DOUBT");
                columnArray = this.a("TRANSACTION", "STATE");
                break;
            }
            case 19: {
                this.setObjectName("CROSS_REFERENCES");
                columnArray = this.a("PKTABLE_CATALOG", "PKTABLE_SCHEMA", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CATALOG", "FKTABLE_SCHEMA", "FKTABLE_NAME", "FKCOLUMN_NAME", "ORDINAL_POSITION SMALLINT", "UPDATE_RULE SMALLINT", "DELETE_RULE SMALLINT", "FK_NAME", "PK_NAME", "DEFERRABILITY SMALLINT");
                string = "PKTABLE_NAME";
                break;
            }
            case 20: {
                this.setObjectName("CONSTRAINTS");
                columnArray = this.a("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "CONSTRAINT_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "UNIQUE_INDEX_NAME", "CHECK_EXPRESSION", "COLUMN_LIST", "REMARKS", "SQL", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 22: {
                this.setObjectName("CONSTANTS");
                columnArray = this.a("CONSTANT_CATALOG", "CONSTANT_SCHEMA", "CONSTANT_NAME", "DATA_TYPE INT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 23: {
                this.setObjectName("DOMAINS");
                columnArray = this.a("DOMAIN_CATALOG", "DOMAIN_SCHEMA", "DOMAIN_NAME", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "PRECISION INT", "SCALE INT", "TYPE_NAME", "SELECTIVITY INT", "CHECK_CONSTRAINT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 24: {
                this.setObjectName("TRIGGERS");
                columnArray = this.a("TRIGGER_CATALOG", "TRIGGER_SCHEMA", "TRIGGER_NAME", "TRIGGER_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "BEFORE BIT", "JAVA_CLASS", "QUEUE_SIZE INT", "NO_WAIT BIT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 25: {
                this.setObjectName("SESSIONS");
                columnArray = this.a("ID INT", "USER_NAME", "SESSION_START", "STATEMENT", "STATEMENT_START");
                break;
            }
            case 26: {
                this.setObjectName("LOCKS");
                columnArray = this.a("TABLE_SCHEMA", "TABLE_NAME", "SESSION_ID INT", "LOCK_TYPE");
                break;
            }
            case 27: {
                this.setObjectName("SESSION_STATE");
                columnArray = this.a("KEY", "SQL");
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + n3);
            }
        }
        this.setColumns(columnArray);
        if (string == null) {
            this.a6 = -1;
        } else {
            this.a6 = this.getColumn(string).getColumnId();
            IndexColumn[] indexColumnArray = IndexColumn.wrap(new Column[]{columnArray[this.a6]});
            this.a9 = new MetaIndex(this, indexColumnArray, false);
        }
    }

    private Column[] a(String ... stringArray) {
        Column[] columnArray = new Column[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string;
            int n2;
            String string2 = stringArray[i2];
            int n3 = string2.indexOf(32);
            if (n3 < 0) {
                n2 = this.database.getMode().lowerCaseIdentifiers ? 14 : 13;
                string = string2;
            } else {
                n2 = DataType.getTypeByName((String)string2.substring((int)(n3 + 1))).type;
                string = string2.substring(0, n3);
            }
            columnArray[i2] = new Column(string, n2);
        }
        return columnArray;
    }

    public String getDropSQL() {
        return null;
    }

    public String getCreateSQL() {
        return null;
    }

    public Index addIndex(Session session, String string, int n2, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        throw DbException.getUnsupportedException("META");
    }

    public void lock(Session session, boolean bl, boolean bl2) {
    }

    public boolean isLockedExclusively() {
        return false;
    }

    private String if(String string) {
        if (this.database.getMode().lowerCaseIdentifiers) {
            string = string == null ? null : StringUtils.toLowerEnglish(string);
        }
        return string;
    }

    private ArrayList try(Session session) {
        ArrayList arrayList = this.database.getAllTablesAndViews(true);
        ArrayList arrayList2 = session.getLocalTempTables();
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    private boolean a(Session session, String string, Value value, Value value2) {
        if (string == null || value == null && value2 == null) {
            return true;
        }
        Database database = session.getDatabase();
        if (this.database.getMode().lowerCaseIdentifiers) {
            ValueStringIgnoreCase valueStringIgnoreCase = ValueStringIgnoreCase.get(string);
            if (value.equals(value2) && database.compare(valueStringIgnoreCase, value) != 0) {
                return false;
            }
        } else {
            ValueString valueString = ValueString.get(string);
            if (value != null && database.compare(valueString, value) < 0) {
                return false;
            }
            if (value2 != null && database.compare(valueString, value2) > 0) {
                return false;
            }
        }
        return true;
    }

    private String a(String string) {
        return string == null ? "" : string;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList generateRows(Session session, SearchRow searchRow, SearchRow searchRow2) {
        Value value = null;
        Value value2 = null;
        if (this.a6 >= 0) {
            if (searchRow != null) {
                value = searchRow.getValue(this.a6);
            }
            if (searchRow2 != null) {
                value2 = searchRow2.getValue(this.a6);
            }
        }
        ArrayList arrayList = New.arrayList();
        String string = this.if(this.database.getShortName());
        switch (this.aV) {
            case 0: {
                for (Table table : this.try(session)) {
                    String string2 = this.if(table.getName());
                    if (!this.a(session, string2, value, value2) || table.isHidden()) continue;
                    String string3 = table.isTemporary() ? (table.isGlobalTemporary() ? "GLOBAL TEMPORARY" : "LOCAL TEMPORARY") : (table.isPersistIndexes() ? "CACHED" : "MEMORY");
                    this.a(arrayList, string, this.if(table.getSchema().getName()), string2, table.getTableType(), string3, table.getCreateSQL(), this.a(table.getComment()), "" + table.getMaxDataModificationId(), "" + table.getId(), null, table.getClass().getName());
                }
                break;
            }
            case 1: {
                for (Table table : this.try(session)) {
                    String string4 = this.if(table.getName());
                    if (!this.a(session, string4, value, value2) || table.isHidden()) continue;
                    Column[] columnArray = table.getColumns();
                    String string5 = this.database.getCompareMode().getName();
                    for (int i2 = 0; i2 < columnArray.length; ++i2) {
                        Column javaMethod = columnArray[i2];
                        Sequence sequence = javaMethod.getSequence();
                        this.a(arrayList, string, this.if(table.getSchema().getName()), string4, this.if(javaMethod.getName()), String.valueOf(i2 + 1), javaMethod.getDefaultSQL(), javaMethod.isNullable() ? "YES" : "NO", "" + DataType.convertTypeToSQLType(javaMethod.getType()), "" + javaMethod.getPrecisionAsInt(), "" + javaMethod.getPrecisionAsInt(), "" + javaMethod.getPrecisionAsInt(), "10", "" + javaMethod.getScale(), be, string5, this.if(DataType.getDataType((int)javaMethod.getType()).name), "" + (javaMethod.isNullable() ? 1 : 0), "" + (javaMethod.getComputed() ? "TRUE" : "FALSE"), "" + javaMethod.getSelectivity(), javaMethod.getCheckConstraintSQL(session, javaMethod.getName()), sequence == null ? null : sequence.getName(), this.a(javaMethod.getComment()), null);
                    }
                }
                break;
            }
            case 2: {
                for (Table table : this.try(session)) {
                    String string6 = this.if(table.getName());
                    if (!this.a(session, string6, value, value2) || table.isHidden()) continue;
                    ArrayList arrayList2 = table.getIndexes();
                    ArrayList arrayList3 = table.getConstraints();
                    for (int i3 = 0; arrayList2 != null && i3 < arrayList2.size(); ++i3) {
                        Object string21;
                        Index index = (Index)arrayList2.get(i3);
                        if (index.getCreateSQL() == null) continue;
                        String table2 = null;
                        for (int string24 = 0; arrayList3 != null && string24 < arrayList3.size(); ++string24) {
                            string21 = (Constraint)arrayList3.get(string24);
                            if (!((Constraint)string21).usesIndex(index)) continue;
                            if (index.getIndexType().isPrimaryKey()) {
                                if (!((Constraint)string21).getConstraintType().equals("PRIMARY KEY")) continue;
                                table2 = ((DbObjectBase)string21).getName();
                                continue;
                            }
                            table2 = ((DbObjectBase)string21).getName();
                        }
                        IndexColumn[] string20 = index.getIndexColumns();
                        string21 = index instanceof MultiVersionIndex ? ((MultiVersionIndex)index).getBaseIndex().getClass().getName() : index.getClass().getName();
                        for (int i2 = 0; i2 < string20.length; ++i2) {
                            IndexColumn indexColumn = string20[i2];
                            Column column = indexColumn.column;
                            this.a(arrayList, new String[]{string, this.if(table.getSchema().getName()), string6, index.getIndexType().isUnique() ? "FALSE" : "TRUE", this.if(index.getName()), "" + (i2 + 1), this.if(column.getName()), "0", index.getIndexType().isPrimaryKey() ? "TRUE" : "FALSE", index.getIndexType().getSQL(), index.getIndexType().getBelongsToConstraint() ? "TRUE" : "FALSE", "3", (indexColumn.sortType & 1) != 0 ? "D" : "A", "0", "", this.a(index.getComment()), index.getCreateSQL(), "" + index.getId(), "" + indexColumn.sortType, table2, string21});
                        }
                    }
                }
                break;
            }
            case 3: {
                this.a(arrayList, "TABLE");
                this.a(arrayList, "TABLE LINK");
                this.a(arrayList, "SYSTEM TABLE");
                this.a(arrayList, "VIEW");
                break;
            }
            case 5: {
                this.a(arrayList, string);
                break;
            }
            case 6: {
                Object object;
                Object object2 = this.database.getAllSettings().iterator();
                while (object2.hasNext()) {
                    object = (String[])object2.next();
                    String string8 = ((Setting)object).getStringValue();
                    if (string8 == null) {
                        string8 = "" + ((Setting)object).getIntValue();
                    }
                    this.a(arrayList, this.if(((DbObjectBase)object).getName()), string8);
                }
                this.a(arrayList, "info.BUILD_ID", "147");
                this.a(arrayList, "info.VERSION_MAJOR", "1");
                this.a(arrayList, "info.VERSION_MINOR", "2");
                this.a(arrayList, "info.VERSION", "" + Constants.getFullVersion());
                if (session.getUser().isAdmin()) {
                    for (String string9 : object2 = new String[]{"java.runtime.version", "java.vm.name", "java.vendor", "os.name", "os.arch", "os.version", "sun.os.patch.level", "file.separator", "path.separator", "line.separator", "user.country", "user.language", "user.variant", "file.encoding"}) {
                        this.a(arrayList, "property." + string9, SysProperties.getStringSetting(string9, ""));
                    }
                }
                this.a(arrayList, "EXCLUSIVE", this.database.getExclusiveSession() == null ? "FALSE" : "TRUE");
                this.a(arrayList, "MODE", this.database.getMode().getName());
                this.a(arrayList, "MULTI_THREADED", this.database.isMultiThreaded() ? "1" : "0");
                this.a(arrayList, "MVCC", this.database.isMultiVersion() ? "TRUE" : "FALSE");
                this.a(arrayList, "QUERY_TIMEOUT", "" + session.getQueryTimeout());
                this.a(arrayList, "LOG", "" + this.database.getLogMode());
                object2 = New.arrayList();
                object = this.database.getSettings().getSettings();
                for (String string10 : ((HashMap)object).keySet()) {
                    ((ArrayList)object2).add(string10);
                }
                Collections.sort(object2);
                Object object3 = ((ArrayList)object2).iterator();
                while (object3.hasNext()) {
                    String string11 = (String)object3.next();
                    this.a(arrayList, string11, (String)((HashMap)object).get(string11));
                }
                if (!this.database.isPersistent()) break;
                object3 = this.database.getPageStore();
                this.a(arrayList, "info.FILE_WRITE_TOTAL", "" + ((PageStore)object3).getWriteCountTotal());
                this.a(arrayList, "info.FILE_WRITE", "" + ((PageStore)object3).getWriteCount());
                this.a(arrayList, "info.FILE_READ", "" + ((PageStore)object3).getReadCount());
                this.a(arrayList, "info.PAGE_COUNT", "" + ((PageStore)object3).getPageCount());
                this.a(arrayList, "info.CACHE_MAX_SIZE", "" + ((PageStore)object3).getCache().getMaxMemory());
                this.a(arrayList, "info.CACHE_SIZE", "" + ((PageStore)object3).getCache().getMemory());
                break;
            }
            case 4: {
                for (DataType dataType : DataType.getTypes()) {
                    if (dataType.hidden || dataType.sqlType == 0) continue;
                    this.a(arrayList, dataType.name, String.valueOf(dataType.sqlType), String.valueOf(MathUtils.convertLongToInt(dataType.maxPrecision)), dataType.prefix, dataType.suffix, dataType.params, String.valueOf(dataType.autoIncrement), String.valueOf(dataType.minScale), String.valueOf(dataType.maxScale), dataType.decimal ? "10" : null, String.valueOf(dataType.sqlTypePos), String.valueOf(dataType.caseSensitive), "1", "3");
                }
                break;
            }
            case 7: {
                String string12 = "/org/h2/res/help.csv";
                try {
                    byte[] byArray = Utils.getResource(string12);
                    InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream(byArray));
                    ResultSet resultSet = Csv.getInstance().read(inputStreamReader, null);
                    int n2 = 0;
                    while (resultSet.next()) {
                        this.a(arrayList, String.valueOf(n2), resultSet.getString(1).trim(), resultSet.getString(2).trim(), resultSet.getString(3).trim(), resultSet.getString(4).trim());
                        ++n2;
                    }
                    break;
                }
                catch (Exception exception) {
                    throw DbException.convert(exception);
                }
            }
            case 8: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(3)) {
                    Sequence sequence = (Sequence)schemaObject;
                    this.a(arrayList, string, this.if(sequence.getSchema().getName()), this.if(sequence.getName()), String.valueOf(sequence.getCurrentValue()), String.valueOf(sequence.getIncrement()), sequence.getBelongsToTable() ? "TRUE" : "FALSE", this.a(sequence.getComment()), String.valueOf(sequence.getCacheSize()), "" + sequence.getId());
                }
                break;
            }
            case 9: {
                for (User user : this.database.getAllUsers()) {
                    this.a(arrayList, this.if(user.getName()), String.valueOf(user.isAdmin()), this.a(user.getComment()), "" + user.getId());
                }
                break;
            }
            case 10: {
                for (Role role : this.database.getAllRoles()) {
                    this.a(arrayList, this.if(role.getName()), this.a(role.getComment()), "" + role.getId());
                }
                break;
            }
            case 11: {
                for (Right right : this.database.getAllRights()) {
                    String string13;
                    Role role = right.getGrantedRole();
                    DbObject dbObject = right.getGrantee();
                    String string2 = string13 = dbObject.getType() == 2 ? "USER" : "ROLE";
                    if (role == null) {
                        Table table = right.getGrantedTable();
                        String table3 = this.if(table.getName());
                        if (!this.a(session, table3, value, value2)) continue;
                        this.a(arrayList, this.if(dbObject.getName()), string13, "", right.getRights(), this.if(table.getSchema().getName()), this.if(table.getName()), "" + right.getId());
                        continue;
                    }
                    this.a(arrayList, this.if(dbObject.getName()), string13, this.if(role.getName()), "", "", "", "" + right.getId());
                }
                break;
            }
            case 12: {
                for (DbObject dbObject : this.database.getAllSchemaObjects(9)) {
                    FunctionAlias functionAlias = (FunctionAlias)dbObject;
                    for (FunctionAlias.JavaMethod table4 : functionAlias.getJavaMethods()) {
                        int index = table4.getDataType() == 0 ? 1 : 2;
                        this.a(arrayList, string, functionAlias.getSchema().getName(), this.if(functionAlias.getName()), functionAlias.getJavaClassName(), functionAlias.getJavaMethodName(), "" + DataType.convertTypeToSQLType(table4.getDataType()), "" + table4.getColumnClasses().length, "" + index, this.a(functionAlias.getComment()), "" + functionAlias.getId(), functionAlias.getSource());
                    }
                }
                for (DbObject dbObject : this.database.getAllAggregates()) {
                    int n4 = 2;
                    this.a(arrayList, string, "PUBLIC", this.if(((DbObjectBase)dbObject).getName()), ((UserAggregate)dbObject).getJavaClassName(), "", "" + DataType.convertTypeToSQLType(0), "1", "" + n4, this.a(((DbObjectBase)dbObject).getComment()), "" + ((DbObjectBase)dbObject).getId(), "");
                }
                break;
            }
            case 21: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(9)) {
                    FunctionAlias functionAlias = (FunctionAlias)schemaObject;
                    for (FunctionAlias.JavaMethod session2 : functionAlias.getJavaMethods()) {
                        Class[] command = session2.getColumnClasses();
                        for (int l3 = 0; l3 < command.length; ++l3) {
                            Class clazz = command[l3];
                            int n2 = DataType.getTypeFromClass(clazz);
                            DataType dataType = DataType.getDataType(n2);
                            int n3 = clazz.isPrimitive() ? 0 : 1;
                            this.a(arrayList, string, functionAlias.getSchema().getName(), this.if(functionAlias.getName()), functionAlias.getJavaClassName(), functionAlias.getJavaMethodName(), "" + session2.getParameterCount(), "" + l3, "P" + (l3 + 1), "" + DataType.convertTypeToSQLType(dataType.type), dataType.name, "" + dataType.defaultPrecision, "" + dataType.defaultScale, "10", "" + n3, "1", "", null);
                        }
                    }
                }
                break;
            }
            case 13: {
                String string16 = this.database.getCompareMode().getName();
                for (Schema schema : this.database.getAllSchemas()) {
                    this.a(arrayList, string, this.if(schema.getName()), this.if(schema.getOwner().getName()), be, string16, "PUBLIC".equals(schema.getName()) ? "TRUE" : "FALSE", this.a(schema.getComment()), "" + schema.getId());
                }
                break;
            }
            case 14: {
                for (Right right : this.database.getAllRights()) {
                    String string17;
                    table = right.getGrantedTable();
                    if (table == null || table.isHidden() || !this.a(session, string17 = this.if(table.getName()), value, value2)) continue;
                    this.a(arrayList, right.getGrantee(), string, table, null, right.getRightMask());
                }
                break;
            }
            case 15: {
                for (Right right : this.database.getAllRights()) {
                    String string18;
                    table = right.getGrantedTable();
                    if (table == null || table.isHidden() || !this.a(session, string18 = this.if(table.getName()), value, value2)) continue;
                    DbObject dbObject = right.getGrantee();
                    int n7 = right.getRightMask();
                    for (Column column : table.getColumns()) {
                        this.a(arrayList, dbObject, string, table, column.getName(), n7);
                    }
                }
                break;
            }
            case 16: {
                for (Locale locale : Collator.getAvailableLocales()) {
                    this.a(arrayList, CompareMode.getName(locale), locale.toString());
                }
                break;
            }
            case 17: {
                for (Table table : this.try(session)) {
                    String string19;
                    if (!table.getTableType().equals("VIEW") || !this.a(session, string19 = this.if(table.getName()), value, value2)) continue;
                    TableView tableView = (TableView)table;
                    this.a(arrayList, string, this.if(table.getSchema().getName()), string19, table.getCreateSQL(), "NONE", "NO", tableView.isInvalid() ? "INVALID" : "VALID", this.a(tableView.getComment()), "" + tableView.getId());
                }
                break;
            }
            case 18: {
                ArrayList arrayList4 = this.database.getInDoubtTransactions();
                if (arrayList4 == null) break;
                for (InDoubtTransaction inDoubtTransaction : arrayList4) {
                    this.a(arrayList, inDoubtTransaction.getTransaction(), inDoubtTransaction.getState());
                }
                break;
            }
            case 19: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(5)) {
                    Constraint constraint = (Constraint)schemaObject;
                    if (!constraint.getConstraintType().equals("REFERENTIAL")) continue;
                    ConstraintReferential constraintReferential = (ConstraintReferential)constraint;
                    IndexColumn[] indexColumnArray = constraintReferential.getColumns();
                    IndexColumn[] indexColumnArray2 = constraintReferential.getRefColumns();
                    Table table = constraintReferential.getTable();
                    Table table2 = constraintReferential.getRefTable();
                    String string3 = this.if(table2.getName());
                    if (!this.a(session, string3, value, value2)) continue;
                    int n4 = this.do(constraintReferential.getUpdateAction());
                    int n5 = this.do(constraintReferential.getDeleteAction());
                    for (int i3 = 0; i3 < indexColumnArray.length; ++i3) {
                        this.a(arrayList, string, this.if(table2.getSchema().getName()), this.if(table2.getName()), this.if(indexColumnArray2[i3].column.getName()), string, this.if(table.getSchema().getName()), this.if(table.getName()), this.if(indexColumnArray[i3].column.getName()), String.valueOf(i3 + 1), String.valueOf(n4), String.valueOf(n5), this.if(constraintReferential.getName()), null, "7");
                    }
                }
                break;
            }
            case 20: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(5)) {
                    void indexColumnArray;
                    String string4;
                    Constraint constraint = (Constraint)schemaObject;
                    String string22 = constraint.getConstraintType();
                    String string23 = null;
                    Object var13_135 = null;
                    Table table = constraint.getTable();
                    if (table.isHidden()) continue;
                    Index index = constraint.getUniqueIndex();
                    String string5 = null;
                    if (index != null) {
                        string5 = index.getName();
                    }
                    if (!this.a(session, string4 = this.if(table.getName()), value, value2)) continue;
                    if (string22.equals("CHECK")) {
                        string23 = ((ConstraintCheck)constraint).getExpression().getSQL();
                    } else if (string22.equals("UNIQUE") || string22.equals("PRIMARY KEY")) {
                        IndexColumn[] indexColumnArray2 = ((ConstraintUnique)constraint).getColumns();
                    } else if (string22.equals("REFERENTIAL")) {
                        IndexColumn[] object = ((ConstraintReferential)constraint).getColumns();
                    }
                    String string6 = null;
                    if (indexColumnArray != null) {
                        StatementBuilder statementBuilder = new StatementBuilder();
                        for (void var23_187 : indexColumnArray) {
                            statementBuilder.appendExceptFirst(",");
                            statementBuilder.append(var23_187.column.getName());
                        }
                        string6 = statementBuilder.toString();
                    }
                    this.a(arrayList, string, this.if(constraint.getSchema().getName()), this.if(constraint.getName()), string22, string, this.if(table.getSchema().getName()), string4, string5, string23, string6, this.a(constraint.getComment()), constraint.getCreateSQL(), "" + constraint.getId());
                }
                break;
            }
            case 22: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(11)) {
                    Constant constant = (Constant)schemaObject;
                    ValueExpression valueExpression = constant.getValue();
                    this.a(arrayList, string, this.if(constant.getSchema().getName()), this.if(constant.getName()), "" + DataType.convertTypeToSQLType(valueExpression.getType()), this.a(constant.getComment()), valueExpression.getSQL(), "" + constant.getId());
                }
                break;
            }
            case 23: {
                for (UserDataType userDataType : this.database.getAllUserDataTypes()) {
                    Column column = userDataType.getColumn();
                    this.a(arrayList, string, "PUBLIC", this.if(userDataType.getName()), column.getDefaultSQL(), column.isNullable() ? "YES" : "NO", "" + column.getDataType().sqlType, "" + column.getPrecisionAsInt(), "" + column.getScale(), column.getDataType().name, "" + column.getSelectivity(), "" + column.getCheckConstraintSQL(session, "VALUE"), this.a(userDataType.getComment()), "" + userDataType.getCreateSQL(), "" + userDataType.getId());
                }
                break;
            }
            case 24: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(4)) {
                    TriggerObject triggerObject = (TriggerObject)schemaObject;
                    table = triggerObject.getTable();
                    this.a(arrayList, string, this.if(triggerObject.getSchema().getName()), this.if(triggerObject.getName()), triggerObject.getTypeNameList(), string, this.if(table.getSchema().getName()), this.if(table.getName()), "" + triggerObject.isBefore(), triggerObject.getTriggerClassName(), "" + triggerObject.getQueueSize(), "" + triggerObject.isNoWait(), this.a(triggerObject.getComment()), triggerObject.getCreateSQL(), "" + triggerObject.getId());
                }
                break;
            }
            case 25: {
                void var13_139;
                boolean bl = session.getUser().isAdmin();
                long l2 = System.currentTimeMillis();
                Session[] sessionArray = this.database.getSessions(false);
                int n6 = sessionArray.length;
                boolean bl2 = false;
                while (var13_139 < n6) {
                    Session session2 = sessionArray[var13_139];
                    if (bl || session2 == session) {
                        Command command = session2.getCurrentCommand();
                        long l3 = session2.getCurrentCommandStart();
                        if (l3 == 0L) {
                            l3 = l2;
                        }
                        this.a(arrayList, "" + session2.getId(), session2.getUser().getName(), new Timestamp(session2.getSessionStart()).toString(), command == null ? null : command.toString(), new Timestamp(l3).toString());
                    }
                    ++var13_139;
                }
                break;
            }
            case 26: {
                boolean bl = session.getUser().isAdmin();
                for (Session session3 : this.database.getSessions(false)) {
                    if (!bl && session3 != session) continue;
                    for (Table table : session3.getLocks()) {
                        this.a(arrayList, table.getSchema().getName(), table.getName(), "" + session3.getId(), table.isLockedExclusivelyBy(session3) ? "WRITE" : "READ");
                    }
                }
                break;
            }
            case 27: {
                String string26;
                for (String string27 : session.getVariableNames()) {
                    Value value3 = session.getVariable(string27);
                    this.a(arrayList, "@" + string27, "SET @" + string27 + " " + value3.getSQL());
                }
                for (Table table : session.getLocalTempTables()) {
                    this.a(arrayList, "TABLE " + table.getName(), table.getCreateSQL());
                }
                String[] stringArray = session.getSchemaSearchPath();
                if (stringArray != null && stringArray.length > 0) {
                    StatementBuilder statementBuilder = new StatementBuilder("SET SCHEMA_SEARCH_PATH ");
                    for (Object object : stringArray) {
                        statementBuilder.appendExceptFirst(", ");
                        statementBuilder.append(StringUtils.quoteIdentifier((String)object));
                    }
                    this.a(arrayList, "SCHEMA_SEARCH_PATH", statementBuilder.toString());
                }
                if ((string26 = session.getCurrentSchemaName()) == null) break;
                this.a(arrayList, "SCHEMA", "SET SCHEMA " + StringUtils.quoteIdentifier(string26));
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.aV);
            }
        }
        return arrayList;
    }

    private int do(int n2) {
        switch (n2) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 2;
            }
        }
        throw DbException.throwInternalError("action=" + n2);
    }

    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    public void removeChildrenAndResources(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    public void close(Session session) {
    }

    public void unlock(Session session) {
    }

    private void a(ArrayList arrayList, DbObject dbObject, String string, Table table, String string2, int n2) {
        if ((n2 & 1) != 0) {
            this.a(arrayList, dbObject, string, table, string2, "SELECT");
        }
        if ((n2 & 4) != 0) {
            this.a(arrayList, dbObject, string, table, string2, "INSERT");
        }
        if ((n2 & 8) != 0) {
            this.a(arrayList, dbObject, string, table, string2, "UPDATE");
        }
        if ((n2 & 2) != 0) {
            this.a(arrayList, dbObject, string, table, string2, "DELETE");
        }
    }

    private void a(ArrayList arrayList, DbObject dbObject, String string, Table table, String string2, String string3) {
        User user;
        String string4 = "NO";
        if (dbObject.getType() == 2 && (user = (User)dbObject).isAdmin()) {
            string4 = "YES";
        }
        if (string2 == null) {
            this.a(arrayList, null, this.if(dbObject.getName()), string, this.if(table.getSchema().getName()), this.if(table.getName()), string3, string4);
        } else {
            this.a(arrayList, null, this.if(dbObject.getName()), string, this.if(table.getSchema().getName()), this.if(table.getName()), this.if(string2), string3, string4);
        }
    }

    private void a(ArrayList arrayList, String ... stringArray) {
        Value[] valueArray = new Value[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            Value value = string == null ? ValueNull.INSTANCE : ValueString.get(string);
            Column column = this.columns[i2];
            value = column.convert(value);
            valueArray[i2] = value;
        }
        Row row = new Row(valueArray, 1);
        row.setKey(arrayList.size());
        arrayList.add(row);
    }

    public void checkRename() {
        throw DbException.getUnsupportedException("META");
    }

    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("META");
    }

    public void truncate(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    public long getRowCount(Session session) {
        throw DbException.throwInternalError();
    }

    public boolean canGetRowCount() {
        return false;
    }

    public boolean canDrop() {
        return false;
    }

    public String getTableType() {
        return "SYSTEM TABLE";
    }

    public Index getScanIndex(Session session) {
        return new MetaIndex(this, IndexColumn.wrap(this.columns), true);
    }

    public ArrayList getIndexes() {
        ArrayList arrayList = New.arrayList();
        if (this.a9 == null) {
            return arrayList;
        }
        arrayList.add(new MetaIndex(this, IndexColumn.wrap(this.columns), true));
        arrayList.add(this.a9);
        return arrayList;
    }

    public long getMaxDataModificationId() {
        switch (this.aV) {
            case 6: 
            case 18: 
            case 25: 
            case 26: 
            case 27: {
                return Long.MAX_VALUE;
            }
        }
        return this.database.getModificationDataId();
    }

    public Index getUniqueIndex() {
        return null;
    }

    public static int getMetaTableTypeCount() {
        return 28;
    }

    public long getRowCountApproximation() {
        return 1000L;
    }

    public boolean isDeterministic() {
        return true;
    }

    public boolean canReference() {
        return false;
    }
}

