/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.h2.command.ddl.Analyze;
import org.h2.command.ddl.CreateTableData;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintReferential;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.HashIndex;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MultiVersionIndex;
import org.h2.index.NonUniqueHashIndex;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageDataIndex;
import org.h2.index.PageDelegateIndex;
import org.h2.index.ScanIndex;
import org.h2.index.TreeIndex;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.schema.SchemaObject;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableBase;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RegularTable
extends TableBase {
    private Index aG;
    private long aF;
    private volatile Session aC;
    private HashSet av = New.hashSet();
    private Trace aw;
    private final ArrayList aA = New.arrayList();
    private long az;
    private boolean ax;
    private PageDataIndex aD;
    private int ay;
    private int aE;
    private boolean aB;

    public RegularTable(CreateTableData createTableData) {
        super(createTableData);
        this.aE = this.database.getSettings().analyzeAuto;
        this.isHidden = createTableData.isHidden;
        Object object = this.getColumns();
        int n2 = ((Column[])object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Column column = object[i2];
            if (!DataType.isLargeObject(column.getType())) continue;
            this.ax = true;
        }
        if (this.ax && !((Database)(object = createTableData.session.getDatabase())).isStarting()) {
            ((Database)object).getLobStorage().init();
        }
        if (createTableData.persistData && this.database.isPersistent()) {
            this.aD = new PageDataIndex(this, createTableData.id, IndexColumn.wrap(this.getColumns()), IndexType.createScan(createTableData.persistData), createTableData.create, createTableData.session);
            this.aG = this.aD;
        } else {
            this.aG = new ScanIndex(this, createTableData.id, IndexColumn.wrap(this.getColumns()), IndexType.createScan(createTableData.persistData));
        }
        this.aA.add(this.aG);
        this.aw = this.database.getTrace("lock");
    }

    public void close(Session session) {
        for (Index index : this.aA) {
            index.close(session);
        }
    }

    public Row getRow(Session session, long l2) {
        return this.aG.getRow(session, l2);
    }

    public void addRow(Session session, Row row) {
        int n2 = 0;
        this.az = this.database.getNextModificationDataId();
        if (this.database.isMultiVersion()) {
            row.setSessionId(session.getId());
        }
        try {
            int n3 = this.aA.size();
            while (n2 < n3) {
                Index index = (Index)this.aA.get(n2);
                index.add(session, row);
                this.a(session, index, 1);
                ++n2;
            }
            ++this.aF;
        }
        catch (Throwable throwable) {
            Object object;
            try {
                while (--n2 >= 0) {
                    object = (Index)this.aA.get(n2);
                    object.remove(session, row);
                    this.a(session, (Index)object, 0);
                }
            }
            catch (DbException dbException) {
                this.trace.error(dbException, "could not undo operation");
                throw dbException;
            }
            object = DbException.convert(throwable);
            if (((DbException)object).getErrorCode() == 23001) {
                for (int i2 = 0; i2 < this.aA.size(); ++i2) {
                    MultiVersionIndex multiVersionIndex;
                    Index index = (Index)this.aA.get(i2);
                    if (!index.getIndexType().isUnique() || !(index instanceof MultiVersionIndex) || !(multiVersionIndex = (MultiVersionIndex)index).isUncommittedFromOtherSession(session, row)) continue;
                    throw DbException.get(90131, index.getName());
                }
            }
            throw object;
        }
        this.for(session);
    }

    public void commit(short s, Row row) {
        this.az = this.database.getNextModificationDataId();
        int n2 = this.aA.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Index index = (Index)this.aA.get(i2);
            index.commit(s, row);
        }
    }

    private void a(Session session, Index index, int n2) {
        long l2;
        if (SysProperties.CHECK && !this.database.isMultiVersion() && !(index instanceof PageDelegateIndex) && (l2 = index.getRowCount(session)) != this.aF + (long)n2) {
            DbException.throwInternalError("rowCount expected " + (this.aF + (long)n2) + " got " + l2 + " " + this.getName() + "." + index.getName());
        }
    }

    public Index getScanIndex(Session session) {
        return (Index)this.aA.get(0);
    }

    public Index getUniqueIndex() {
        for (Index index : this.aA) {
            if (!index.getIndexType().isUnique()) continue;
            return index;
        }
        return null;
    }

    public ArrayList getIndexes() {
        return this.aA;
    }

    public Index addIndex(Session session, String string, int n2, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        Object object;
        if (indexType.isPrimaryKey()) {
            for (IndexColumn indexColumn : indexColumnArray) {
                Column column = indexColumn.column;
                if (column.isNullable()) {
                    throw DbException.get(90023, column.getName());
                }
                column.setPrimaryKey(true);
            }
        }
        if (this.isPersistIndexes() && indexType.isPersistent()) {
            int n3 = this.database.isStarting() && this.database.getPageStore().getRootPageId(n2) != 0 ? -1 : (!this.database.isStarting() && this.aD.getRowCount(session) != 0L ? -1 : this.a(indexType, indexColumnArray));
            if (n3 != -1) {
                this.aD.setMainIndexColumn(n3);
                object = new PageDelegateIndex(this, n2, string, indexType, this.aD, bl, session);
            } else {
                object = new PageBtreeIndex(this, n2, string, indexColumnArray, indexType, bl, session);
            }
        } else {
            object = indexType.isHash() && indexColumnArray.length <= 1 ? (indexType.isUnique() ? new HashIndex(this, n2, string, indexColumnArray, indexType) : new NonUniqueHashIndex(this, n2, string, indexColumnArray, indexType)) : new TreeIndex(this, n2, string, indexColumnArray, indexType);
        }
        if (this.database.isMultiVersion()) {
            object = new MultiVersionIndex((Index)object, this);
        }
        if (object.needRebuild() && this.aF > 0L) {
            try {
                long l2;
                Index index = this.getScanIndex(session);
                long l3 = l2 = index.getRowCount(session);
                Cursor cursor = index.find(session, null, null);
                long l4 = 0L;
                int n4 = (int)Math.min(this.aF, 10000L);
                ArrayList arrayList = New.arrayList(n4);
                String string3 = this.getName() + ":" + object.getName();
                int n5 = MathUtils.convertLongToInt(l3);
                while (cursor.next()) {
                    this.database.setProgress(1, string3, MathUtils.convertLongToInt(l4++), n5);
                    Row row = cursor.get();
                    arrayList.add(row);
                    if (arrayList.size() >= n4) {
                        this.a(session, arrayList, (Index)object);
                    }
                    --l2;
                }
                this.a(session, arrayList, (Index)object);
                if (SysProperties.CHECK && l2 != 0L) {
                    DbException.throwInternalError("rowcount remaining=" + l2 + " " + this.getName());
                }
            }
            catch (DbException dbException) {
                this.getSchema().freeUniqueName(string);
                try {
                    object.remove(session);
                }
                catch (DbException dbException2) {
                    this.trace.error(dbException2, "could not remove index");
                    throw dbException2;
                }
                throw dbException;
            }
        }
        boolean bl2 = this.isTemporary();
        object.setTemporary(bl2);
        if (object.getCreateSQL() != null) {
            object.setComment(string2);
            if (bl2 && !this.isGlobalTemporary()) {
                session.addLocalTempTableIndex((Index)object);
            } else {
                this.database.addSchemaObject(session, (SchemaObject)object);
            }
        }
        this.aA.add(object);
        this.setModified();
        return object;
    }

    private int a(IndexType indexType, IndexColumn[] indexColumnArray) {
        if (this.aD.getMainIndexColumn() != -1) {
            return -1;
        }
        if (!indexType.isPrimaryKey() || indexColumnArray.length != 1) {
            return -1;
        }
        IndexColumn indexColumn = indexColumnArray[0];
        if (indexColumn.sortType != 0) {
            return -1;
        }
        switch (indexColumn.column.getType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                return -1;
            }
        }
        return indexColumn.column.getColumnId();
    }

    public boolean canGetRowCount() {
        return true;
    }

    private void a(Session session, ArrayList arrayList, Index index) {
        final Index index2 = index;
        Collections.sort(arrayList, new Comparator(){

            public int compare(Row row, Row row2) {
                return index2.compareRows(row, row2);
            }
        });
        for (Row row : arrayList) {
            index.add(session, row);
        }
        arrayList.clear();
    }

    public boolean canDrop() {
        return true;
    }

    public long getRowCount(Session session) {
        if (this.database.isMultiVersion()) {
            return this.getScanIndex(session).getRowCount(session);
        }
        return this.aF;
    }

    public void removeRow(Session session, Row row) {
        int n2;
        if (this.database.isMultiVersion()) {
            if (row.isDeleted()) {
                throw DbException.get(90131, this.getName());
            }
            n2 = row.getSessionId();
            int n3 = session.getId();
            if (n2 == 0) {
                row.setSessionId(n3);
            } else if (n2 != n3) {
                throw DbException.get(90131, this.getName());
            }
        }
        this.az = this.database.getNextModificationDataId();
        try {
            for (n2 = this.aA.size() - 1; n2 >= 0; --n2) {
                Index index = (Index)this.aA.get(n2);
                index.remove(session, row);
                this.a(session, index, -1);
            }
            --this.aF;
        }
        catch (Throwable throwable) {
            try {
                while (++n2 < this.aA.size()) {
                    Index index = (Index)this.aA.get(n2);
                    index.add(session, row);
                    this.a(session, index, 0);
                }
            }
            catch (DbException dbException) {
                this.trace.error(dbException, "could not undo operation");
                throw dbException;
            }
            throw DbException.convert(throwable);
        }
        this.for(session);
    }

    public void truncate(Session session) {
        this.az = this.database.getNextModificationDataId();
        for (int i2 = this.aA.size() - 1; i2 >= 0; --i2) {
            Index index = (Index)this.aA.get(i2);
            index.truncate(session);
        }
        this.aF = 0L;
        this.ay = 0;
    }

    private void for(Session session) {
        if (this.aE == 0 || this.aE > this.ay++) {
            return;
        }
        this.ay = 0;
        int n2 = 2 * this.aE;
        if (n2 > 0) {
            this.aE = n2;
        }
        int n3 = session.getDatabase().getSettings().analyzeSample;
        Analyze.analyzeTable(session, this, n3, false);
    }

    public boolean isLockedExclusivelyBy(Session session) {
        return this.aC == session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Session session, boolean bl, boolean bl2) {
        int n2 = this.database.getLockMode();
        if (n2 == 0) {
            return;
        }
        if (!bl2 && this.database.isMultiVersion()) {
            if (bl) {
                bl = false;
            } else if (this.aC == null) {
                return;
            }
        }
        if (this.aC == session) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            try {
                this.a(session, n2, bl);
            }
            finally {
                session.setWaitForLock(null);
            }
        }
    }

    private void a(Session session, int n2, boolean bl) {
        this.a(session, bl, "requesting for");
        long l2 = 0L;
        boolean bl2 = false;
        while (this.aC != session) {
            if (bl) {
                if (this.aC == null) {
                    if (this.av.isEmpty()) {
                        this.a(session, bl, "added for");
                        session.addLock(this);
                        this.aC = session;
                        return;
                    }
                    if (this.av.size() == 1 && this.av.contains(session)) {
                        this.a(session, bl, "add (upgraded) for ");
                        this.aC = session;
                        return;
                    }
                }
            } else if (this.aC == null) {
                if (n2 == 3 && !this.database.isMultiThreaded() && !this.database.isMultiVersion()) {
                    return;
                }
                if (!this.av.contains(session)) {
                    this.a(session, bl, "ok");
                    session.addLock(this);
                    this.av.add(session);
                }
                return;
            }
            session.setWaitForLock(this);
            if (bl2) {
                ArrayList arrayList = this.checkDeadlock(session, null, null);
                if (arrayList != null) {
                    throw DbException.get(40001, this.a(arrayList));
                }
            } else {
                bl2 = true;
            }
            long l3 = System.currentTimeMillis();
            if (l2 == 0L) {
                l2 = l3 + (long)session.getLockTimeout();
            } else if (l3 >= l2) {
                this.a(session, bl, "timeout after " + session.getLockTimeout());
                throw DbException.get(50200, this.getName());
            }
            try {
                long l4;
                this.a(session, bl, "waiting for");
                if (this.database.getLockMode() == 2) {
                    for (int i2 = 0; i2 < 20; ++i2) {
                        long l5 = Runtime.getRuntime().freeMemory();
                        System.gc();
                        long l6 = Runtime.getRuntime().freeMemory();
                        if (l5 == l6) break;
                    }
                }
                if ((l4 = Math.min(100L, l2 - l3)) == 0L) {
                    l4 = 1L;
                }
                this.aB = true;
                this.database.wait(l4);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    private String a(ArrayList arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Session session : arrayList) {
            Table table = session.getWaitForLock();
            stringBuilder.append("\nSession ").append(session.toString()).append(" is waiting to lock ").append(table.toString()).append(" while locking ");
            int n2 = 0;
            for (Table table2 : session.getLocks()) {
                if (n2++ > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(table2.toString());
                if (!(table2 instanceof RegularTable)) continue;
                if (((RegularTable)table2).aC == session) {
                    stringBuilder.append(" (exclusive)");
                    continue;
                }
                stringBuilder.append(" (shared)");
            }
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList checkDeadlock(Session session, Session session2, Set set) {
        Class<RegularTable> clazz = RegularTable.class;
        synchronized (RegularTable.class) {
            if (session2 == null) {
                session2 = session;
                set = New.hashSet();
            } else {
                if (session2 == session) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return New.arrayList();
                }
                if (set.contains(session)) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return null;
                }
            }
            set.add(session);
            ArrayList arrayList = null;
            Object object = this.av.iterator();
            while (object.hasNext()) {
                Table table;
                Session session3 = (Session)object.next();
                if (session3 == session || (table = session3.getWaitForLock()) == null || (arrayList = table.checkDeadlock(session3, session2, set)) == null) continue;
                arrayList.add(session);
                break;
            }
            if (arrayList == null && this.aC != null && (object = this.aC.getWaitForLock()) != null && (arrayList = ((Table)object).checkDeadlock(this.aC, session2, set)) != null) {
                arrayList.add(session);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return arrayList;
        }
    }

    private void a(Session session, boolean bl, String string) {
        if (this.aw.isDebugEnabled()) {
            this.aw.debug("{0} {1} {2} {3}", session.getId(), bl ? "exclusive write lock" : "shared read lock", string, this.getName());
        }
    }

    public boolean isLockedExclusively() {
        return this.aC != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Session session) {
        if (this.database != null) {
            this.a(session, this.aC == session, "unlock");
            if (this.aC == session) {
                this.aC = null;
            }
            if (this.av.size() > 0) {
                this.av.remove(session);
            }
            Database database = this.database;
            synchronized (database) {
                if (this.database.getSessionCount() > 1 && this.aB) {
                    this.database.notifyAll();
                }
            }
        }
    }

    public Row createRow(Value[] valueArray) {
        return new Row(valueArray, -1);
    }

    public void setRowCount(long l2) {
        this.aF = l2;
    }

    public void removeChildrenAndResources(Session session) {
        super.removeChildrenAndResources(session);
        while (this.aA.size() > 1) {
            Index index = (Index)this.aA.get(1);
            if (index.getName() == null) continue;
            this.database.removeSchemaObject(session, index);
        }
        if (SysProperties.CHECK) {
            for (SchemaObject schemaObject : this.database.getAllSchemaObjects(1)) {
                Index index = (Index)schemaObject;
                if (index.getTable() != this) continue;
                DbException.throwInternalError("index not dropped: " + index.getName());
            }
        }
        this.aG.remove(session);
        this.database.removeMeta(session, this.getId());
        if (this.ax) {
            this.database.getLobStorage().removeAllForTable(this.getId());
        }
        this.aG = null;
        this.aC = null;
        this.av = null;
        this.invalidate();
    }

    public String toString() {
        return this.getSQL();
    }

    public void checkRename() {
    }

    public void checkSupportAlter() {
    }

    public boolean canTruncate() {
        ArrayList arrayList;
        if (this.getCheckForeignKeyConstraints() && this.database.getReferentialIntegrity() && (arrayList = this.getConstraints()) != null) {
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ConstraintReferential constraintReferential;
                Constraint constraint = (Constraint)arrayList.get(i2);
                if (!constraint.getConstraintType().equals("REFERENTIAL") || (constraintReferential = (ConstraintReferential)constraint).getRefTable() != this) continue;
                return false;
            }
        }
        return true;
    }

    public String getTableType() {
        return "TABLE";
    }

    public long getMaxDataModificationId() {
        return this.az;
    }

    public boolean getContainsLargeObject() {
        return this.ax;
    }

    public long getRowCountApproximation() {
        return this.aG.getRowCountApproximation();
    }

    public void setCompareMode(CompareMode compareMode) {
        this.compareMode = compareMode;
    }

    public boolean isDeterministic() {
        return true;
    }
}

