/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.h2.command.Prepared;
import org.h2.constraint.Constraint;
import org.h2.engine.DbObject;
import org.h2.engine.Right;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.result.SearchRow;
import org.h2.result.SimpleRow;
import org.h2.result.SimpleRowValue;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.SchemaObjectBase;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.PlanItem;
import org.h2.table.TableView;
import org.h2.util.New;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public abstract class Table
extends SchemaObjectBase {
    public static final int TYPE_CACHED = 0;
    public static final int TYPE_MEMORY = 1;
    public static final String TABLE_LINK = "TABLE LINK";
    public static final String SYSTEM_TABLE = "SYSTEM TABLE";
    public static final String TABLE = "TABLE";
    public static final String VIEW = "VIEW";
    public static final String EXTERNAL_TABLE_ENGINE = "EXTERNAL";
    protected Column[] columns;
    protected CompareMode compareMode;
    protected boolean isHidden;
    private final HashMap an = New.hashMap();
    private boolean al;
    private boolean ar;
    private ArrayList aj;
    private ArrayList at;
    private ArrayList ak;
    private ArrayList ap;
    private boolean am = true;
    private boolean ao;
    private boolean as;
    private Row aq;

    public Table(Schema schema, int n2, String string, boolean bl, boolean bl2) {
        this.initSchemaObjectBase(schema, n2, string, "table");
        this.al = bl;
        this.ar = bl2;
        this.compareMode = schema.getDatabase().getCompareMode();
    }

    public void rename(String string) {
        super.rename(string);
        if (this.at != null) {
            int n2 = this.at.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Constraint constraint = (Constraint)this.at.get(i2);
                constraint.rebuild();
            }
        }
    }

    public abstract void lock(Session var1, boolean var2, boolean var3);

    public abstract void close(Session var1);

    public abstract void unlock(Session var1);

    public abstract Index addIndex(Session var1, String var2, int var3, IndexColumn[] var4, IndexType var5, boolean var6, String var7);

    public abstract void removeRow(Session var1, Row var2);

    public abstract void truncate(Session var1);

    public abstract void addRow(Session var1, Row var2);

    public void commit(short s, Row row) {
    }

    public abstract void checkSupportAlter();

    public abstract String getTableType();

    public abstract Index getScanIndex(Session var1);

    public abstract Index getUniqueIndex();

    public abstract ArrayList getIndexes();

    public abstract boolean isLockedExclusively();

    public abstract long getMaxDataModificationId();

    public abstract boolean isDeterministic();

    public abstract boolean canGetRowCount();

    public boolean canReference() {
        return true;
    }

    public abstract boolean canDrop();

    public abstract long getRowCount(Session var1);

    public abstract long getRowCountApproximation();

    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError();
    }

    public void addDependencies(HashSet hashSet) {
        if (this.ak != null) {
            for (Sequence object : this.ak) {
                hashSet.add(object);
            }
        }
        ExpressionVisitor expressionVisitor = ExpressionVisitor.getDependenciesVisitor(hashSet);
        for (Column column : this.columns) {
            column.isEverything(expressionVisitor);
        }
    }

    public ArrayList getChildren() {
        ArrayList arrayList = New.arrayList();
        ArrayList arrayList2 = this.getIndexes();
        if (arrayList2 != null) {
            arrayList.addAll(arrayList2);
        }
        if (this.at != null) {
            arrayList.addAll(this.at);
        }
        if (this.aj != null) {
            arrayList.addAll(this.aj);
        }
        if (this.ak != null) {
            arrayList.addAll(this.ak);
        }
        if (this.ap != null) {
            arrayList.addAll(this.ap);
        }
        ArrayList arrayList3 = this.database.getAllRights();
        for (Right right : arrayList3) {
            if (right.getGrantedTable() != this) continue;
            arrayList.add(right);
        }
        return arrayList;
    }

    protected void setColumns(Column[] columnArray) {
        this.columns = columnArray;
        if (this.an.size() > 0) {
            this.an.clear();
        }
        for (int i2 = 0; i2 < columnArray.length; ++i2) {
            Column column = columnArray[i2];
            int n2 = column.getType();
            if (n2 == -1) {
                throw DbException.get(50004, column.getSQL());
            }
            column.setTable(this, i2);
            String string = column.getName();
            if (this.an.get(string) != null) {
                throw DbException.get(42121, string);
            }
            this.an.put(string, column);
        }
    }

    public void renameColumn(Column column, String string) {
        for (Column column2 : this.columns) {
            if (column2 == column || !column2.getName().equals(string)) continue;
            throw DbException.get(42121, string);
        }
        this.an.remove(column.getName());
        column.rename(string);
        this.an.put(string, column);
    }

    public boolean isLockedExclusivelyBy(Session session) {
        return false;
    }

    public void updateRows(Prepared prepared, Session session, RowList rowList) {
        Row row;
        int n2 = 0;
        rowList.reset();
        while (rowList.hasNext()) {
            if ((++n2 & 0x7F) == 0) {
                prepared.checkCanceled();
            }
            row = rowList.next();
            rowList.next();
            this.removeRow(session, row);
            session.log(this, (short)1, row);
        }
        rowList.reset();
        while (rowList.hasNext()) {
            if ((++n2 & 0x7F) == 0) {
                prepared.checkCanceled();
            }
            rowList.next();
            row = rowList.next();
            this.addRow(session, row);
            session.log(this, (short)0, row);
        }
    }

    public ArrayList getViews() {
        return this.ap;
    }

    public void removeChildrenAndResources(Session session) {
        Object object;
        while (this.ap != null && this.ap.size() > 0) {
            object = (TableView)this.ap.get(0);
            this.ap.remove(0);
            this.database.removeSchemaObject(session, (SchemaObject)object);
        }
        while (this.aj != null && this.aj.size() > 0) {
            object = (TriggerObject)this.aj.get(0);
            this.aj.remove(0);
            this.database.removeSchemaObject(session, (SchemaObject)object);
        }
        while (this.at != null && this.at.size() > 0) {
            object = (Constraint)this.at.get(0);
            this.at.remove(0);
            this.database.removeSchemaObject(session, (SchemaObject)object);
        }
        for (Right right : this.database.getAllRights()) {
            if (right.getGrantedTable() != this) continue;
            this.database.removeDatabaseObject(session, right);
        }
        this.database.removeMeta(session, this.getId());
        while (this.ak != null && this.ak.size() > 0) {
            object = (Sequence)this.ak.get(0);
            this.ak.remove(0);
            if (this.isTemporary() || this.database.getDependentTable((SchemaObject)object, this) != null) continue;
            this.database.removeSchemaObject(session, (SchemaObject)object);
        }
    }

    public void checkColumnIsNotReferenced(Column column) {
        ArrayList arrayList;
        int n2;
        if (this.at != null) {
            n2 = this.at.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Constraint constraint = (Constraint)this.at.get(i2);
                if (!constraint.containsColumn(column)) continue;
                throw DbException.get(90083, constraint.getSQL());
            }
        }
        if ((arrayList = this.getIndexes()) != null) {
            int n3 = arrayList.size();
            for (n2 = 0; n2 < n3; ++n2) {
                Index index = (Index)arrayList.get(n2);
                if (index.getColumns().length == 1 || index.getCreateSQL() == null || index.getColumnIndex(column) < 0) continue;
                throw DbException.get(90083, index.getSQL());
            }
        }
    }

    public Row getTemplateRow() {
        return new Row(new Value[this.columns.length], -1);
    }

    public SearchRow getTemplateSimpleRow(boolean bl) {
        if (bl) {
            return new SimpleRowValue(this.columns.length);
        }
        return new SimpleRow(new Value[this.columns.length]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Row getNullRow() {
        Table table = this;
        synchronized (table) {
            if (this.aq == null) {
                this.aq = new Row(new Value[this.columns.length], 1);
                for (int i2 = 0; i2 < this.columns.length; ++i2) {
                    this.aq.setValue(i2, ValueNull.INSTANCE);
                }
            }
            return this.aq;
        }
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public int getType() {
        return 0;
    }

    public Column getColumn(int n2) {
        return this.columns[n2];
    }

    public Column getColumn(String string) {
        Column column = (Column)this.an.get(string);
        if (column == null) {
            throw DbException.get(42122, string);
        }
        return column;
    }

    public PlanItem getBestPlanItem(Session session, int[] nArray) {
        PlanItem planItem = new PlanItem();
        planItem.setIndex(this.getScanIndex(session));
        planItem.cost = planItem.getIndex().getCost(session, null);
        ArrayList arrayList = this.getIndexes();
        if (arrayList != null && nArray != null) {
            int n2 = arrayList.size();
            for (int i2 = 1; i2 < n2; ++i2) {
                Index index = (Index)arrayList.get(i2);
                double d2 = index.getCost(session, nArray);
                if (!(d2 < planItem.cost)) continue;
                planItem.cost = d2;
                planItem.setIndex(index);
            }
        }
        return planItem;
    }

    public Index findPrimaryKey() {
        ArrayList arrayList = this.getIndexes();
        if (arrayList != null) {
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Index index = (Index)arrayList.get(i2);
                if (!index.getIndexType().isPrimaryKey()) continue;
                return index;
            }
        }
        return null;
    }

    public Index getPrimaryKey() {
        Index index = this.findPrimaryKey();
        if (index != null) {
            return index;
        }
        throw DbException.get(42112, "PRIMARY_KEY_");
    }

    public void validateConvertUpdateSequence(Session session, Row row) {
        for (int i2 = 0; i2 < this.columns.length; ++i2) {
            Value value;
            Value value2 = row.getValue(i2);
            Column column = this.columns[i2];
            if (column.getComputed()) {
                value2 = null;
                value = column.computeValue(session, row);
            }
            if ((value = column.validateConvertUpdateSequence(session, value2)) == value2) continue;
            row.setValue(i2, value);
        }
    }

    private void a(ArrayList arrayList, DbObject dbObject) {
        int n2;
        if (arrayList != null && (n2 = arrayList.indexOf(dbObject)) >= 0) {
            arrayList.remove(n2);
        }
    }

    public void removeIndex(Index index) {
        ArrayList arrayList = this.getIndexes();
        if (arrayList != null) {
            this.a(arrayList, index);
            if (index.getIndexType().isPrimaryKey()) {
                for (Column column : index.getColumns()) {
                    column.setPrimaryKey(false);
                }
            }
        }
    }

    void removeView(TableView tableView) {
        this.a(this.ap, tableView);
    }

    public void removeConstraint(Constraint constraint) {
        this.a(this.at, constraint);
    }

    public void removeSequence(Session session, Sequence sequence) {
        this.a(this.ak, sequence);
    }

    public void removeTrigger(TriggerObject triggerObject) {
        this.a(this.aj, triggerObject);
    }

    public void addView(TableView tableView) {
        this.ap = this.a(this.ap, (Object)tableView);
    }

    public void addConstraint(Constraint constraint) {
        if (this.at == null || this.at.indexOf(constraint) < 0) {
            this.at = this.a(this.at, (Object)constraint);
        }
    }

    public ArrayList getConstraints() {
        return this.at;
    }

    public void addSequence(Sequence sequence) {
        this.ak = this.a(this.ak, (Object)sequence);
    }

    public void addTrigger(TriggerObject triggerObject) {
        this.aj = this.a(this.aj, (Object)triggerObject);
    }

    private ArrayList a(ArrayList arrayList, Object object) {
        if (arrayList == null) {
            arrayList = New.arrayList();
        }
        arrayList.add(object);
        return arrayList;
    }

    public void fire(Session session, int n2, boolean bl) {
        if (this.aj != null) {
            for (TriggerObject triggerObject : this.aj) {
                triggerObject.fire(session, n2, bl);
            }
        }
    }

    public boolean hasSelectTrigger() {
        if (this.aj != null) {
            for (TriggerObject triggerObject : this.aj) {
                if (!triggerObject.isSelectTrigger()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean fireRow() {
        return this.at != null && this.at.size() > 0 || this.aj != null && this.aj.size() > 0;
    }

    public boolean fireBeforeRow(Session session, Row row, Row row2) {
        boolean bl = this.a(session, row, row2, true, false);
        this.a(session, row, row2, true);
        return bl;
    }

    private void a(Session session, Row row, Row row2, boolean bl) {
        if (this.at != null) {
            int n2 = this.at.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Constraint constraint = (Constraint)this.at.get(i2);
                if (constraint.isBefore() != bl) continue;
                constraint.checkRow(session, this, row, row2);
            }
        }
    }

    public void fireAfterRow(Session session, Row row, Row row2, boolean bl) {
        this.a(session, row, row2, false, bl);
        if (!bl) {
            this.a(session, row, row2, false);
        }
    }

    private boolean a(Session session, Row row, Row row2, boolean bl, boolean bl2) {
        if (this.aj != null) {
            for (TriggerObject triggerObject : this.aj) {
                boolean bl3 = triggerObject.fireRow(session, row, row2, bl, bl2);
                if (!bl3) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isGlobalTemporary() {
        return false;
    }

    public boolean canTruncate() {
        return false;
    }

    public void setCheckForeignKeyConstraints(Session session, boolean bl, boolean bl2) {
        if (bl && bl2 && this.at != null) {
            for (Constraint constraint : this.at) {
                constraint.checkExistingData(session);
            }
        }
        this.am = bl;
    }

    public boolean getCheckForeignKeyConstraints() {
        return this.am;
    }

    public Index getIndexForColumn(Column column, boolean bl) {
        ArrayList arrayList = this.getIndexes();
        if (arrayList != null) {
            int n2 = arrayList.size();
            for (int i2 = 1; i2 < n2; ++i2) {
                int n3;
                Index index = (Index)arrayList.get(i2);
                if (!index.canGetFirstOrLast() || (n3 = index.getColumnIndex(column)) != 0) continue;
                return index;
            }
        }
        return null;
    }

    public boolean getOnCommitDrop() {
        return this.ao;
    }

    public void setOnCommitDrop(boolean bl) {
        this.ao = bl;
    }

    public boolean getOnCommitTruncate() {
        return this.as;
    }

    public void setOnCommitTruncate(boolean bl) {
        this.as = bl;
    }

    public void removeIndexOrTransferOwnership(Session session, Index index) {
        boolean bl = false;
        if (this.at != null) {
            for (Constraint constraint : this.at) {
                if (!constraint.usesIndex(index)) continue;
                constraint.setIndexOwner(index);
                this.database.update(session, constraint);
                bl = true;
            }
        }
        if (!bl) {
            this.database.removeSchemaObject(session, index);
        }
    }

    public ArrayList checkDeadlock(Session session, Session session2, Set set) {
        return null;
    }

    public boolean isPersistIndexes() {
        return this.al;
    }

    public boolean isPersistData() {
        return this.ar;
    }

    public int compareTypeSave(Value value, Value value2) {
        if (value == value2) {
            return 0;
        }
        int n2 = Value.getHigherOrder(value.getType(), value2.getType());
        value = value.convertTo(n2);
        value2 = value2.convertTo(n2);
        return value.compareTypeSave(value2, this.compareMode);
    }

    public CompareMode getCompareMode() {
        return this.compareMode;
    }

    public void checkWritingAllowed() {
        this.database.checkWritingAllowed();
    }

    public Value getDefaultValue(Session session, Column column) {
        Expression expression = column.getDefaultExpression();
        Value value = expression == null ? column.validateConvertUpdateSequence(session, null) : expression.getValue(session);
        return column.convert(value);
    }

    public boolean isHidden() {
        return this.isHidden;
    }
}

