/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import org.h2.command.Parser;
import org.h2.command.dml.Select;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.index.Index;
import org.h2.index.IndexCondition;
import org.h2.index.IndexCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TableFilter
implements ColumnResolver {
    private static final int case = 0;
    private static final int do = 1;
    private static final int b = 2;
    private static final int for = 3;
    protected Session session;
    protected boolean joinOuterIndirect;
    private final Table i;
    private final Select e;
    private String d;
    private Index else;
    private int void;
    private boolean n;
    private boolean char;
    private final IndexCursor byte;
    private final ArrayList int = New.arrayList();
    private Expression g;
    private Expression m;
    private SearchRow try;
    private Row f;
    private int new;
    private TableFilter c;
    private boolean l;
    private TableFilter long;
    private ArrayList j;
    private boolean goto;
    private Expression k;
    private final int h;

    public TableFilter(Session session, Table table, String string, boolean bl, Select select) {
        this.session = session;
        this.i = table;
        this.d = string;
        this.e = select;
        this.byte = new IndexCursor();
        if (!bl) {
            session.getUser().checkRight(table, 1);
        }
        this.h = session.nextObjectId();
    }

    public Select getSelect() {
        return this.e;
    }

    public Table getTable() {
        return this.i;
    }

    public void lock(Session session, boolean bl, boolean bl2) {
        this.i.lock(session, bl, bl2);
        if (this.c != null) {
            this.c.lock(session, bl, bl2);
        }
    }

    public PlanItem getBestPlanItem(Session session, int n2) {
        PlanItem planItem;
        if (this.int.size() == 0) {
            planItem = new PlanItem();
            planItem.setIndex(this.i.getScanIndex(session));
            planItem.cost = planItem.getIndex().getCost(session, null);
        } else {
            int n3 = this.i.getColumns().length;
            int[] nArray = new int[n3];
            for (IndexCondition indexCondition : this.int) {
                int n4;
                if (!indexCondition.isEvaluatable()) continue;
                if (indexCondition.isAlwaysFalse()) {
                    nArray = null;
                    break;
                }
                int n5 = n4 = indexCondition.getColumn().getColumnId();
                nArray[n5] = nArray[n5] | indexCondition.getMask(this.int);
            }
            planItem = this.i.getBestPlanItem(session, nArray);
            planItem.cost -= planItem.cost * (double)this.int.size() / 100.0 / (double)n2;
        }
        if (this.long != null) {
            this.a(this.long);
            planItem.setNestedJoinPlan(this.long.getBestPlanItem(session, n2));
            planItem.cost += planItem.cost * planItem.getNestedJoinPlan().cost;
        }
        if (this.c != null) {
            this.a(this.c);
            planItem.setJoinPlan(this.c.getBestPlanItem(session, n2));
            planItem.cost += planItem.cost * planItem.getJoinPlan().cost;
        }
        return planItem;
    }

    private void a(TableFilter tableFilter) {
        if (this.session.getDatabase().getSettings().nestedJoins) {
            this.setEvaluatable(true);
            return;
        }
        do {
            TableFilter tableFilter2;
            Expression expression;
            if ((expression = tableFilter.getJoinCondition()) != null) {
                expression.setEvaluatable(this, true);
            }
            if ((tableFilter2 = tableFilter.getNestedJoin()) == null) continue;
            this.a(tableFilter2);
        } while ((tableFilter = tableFilter.getJoin()) != null);
    }

    public void setPlanItem(PlanItem planItem) {
        this.setIndex(planItem.getIndex());
        if (this.long != null && planItem.getNestedJoinPlan() != null) {
            this.long.setPlanItem(planItem.getNestedJoinPlan());
        }
        if (this.c != null && planItem.getJoinPlan() != null) {
            this.c.setPlanItem(planItem.getJoinPlan());
        }
    }

    public void prepare() {
        for (int i2 = 0; i2 < this.int.size(); ++i2) {
            Column column;
            IndexCondition indexCondition = (IndexCondition)this.int.get(i2);
            if (indexCondition.isAlwaysFalse() || this.else.getColumnIndex(column = indexCondition.getColumn()) >= 0) continue;
            this.int.remove(i2);
            --i2;
        }
        if (this.long != null) {
            if (SysProperties.CHECK && this.long == this) {
                DbException.throwInternalError("self join");
            }
            this.long.prepare();
        }
        if (this.c != null) {
            if (SysProperties.CHECK && this.c == this) {
                DbException.throwInternalError("self join");
            }
            this.c.prepare();
        }
        if (this.g != null) {
            this.g = this.g.optimize(this.session);
        }
        if (this.m != null) {
            this.m = this.m.optimize(this.session);
        }
    }

    public void startQuery(Session session) {
        this.session = session;
        this.void = 0;
        if (this.long != null) {
            this.long.startQuery(session);
        }
        if (this.c != null) {
            this.c.startQuery(session);
        }
    }

    public void reset() {
        if (this.long != null) {
            this.long.reset();
        }
        if (this.c != null) {
            this.c.reset();
        }
        this.new = 0;
        this.goto = false;
    }

    public boolean next() {
        if (this.new == 2) {
            return false;
        }
        if (this.new == 0) {
            this.byte.find(this.session, this.int);
            if (!this.byte.isAlwaysFalse()) {
                if (this.long != null) {
                    this.long.reset();
                }
                if (this.c != null) {
                    this.c.reset();
                }
            }
        } else if (this.c != null && this.c.next()) {
            return true;
        }
        while (this.new != 3) {
            if (this.byte.isAlwaysFalse()) {
                this.new = 2;
            } else if (this.long != null) {
                if (this.new == 0) {
                    this.new = 1;
                }
            } else {
                if ((++this.void & 0xFFF) == 0) {
                    this.a();
                }
                if (this.byte.next()) {
                    this.try = this.byte.getSearchRow();
                    this.f = null;
                    this.new = 1;
                } else {
                    this.new = 2;
                }
            }
            if (this.long != null && this.new == 1 && !this.long.next()) {
                this.new = 2;
                if (!this.l || this.goto) continue;
            }
            if (this.new == 2) {
                if (!this.l || this.goto) break;
                this.setNullRow();
            }
            if (!this.a(this.g)) continue;
            boolean bl = this.a(this.m);
            if (this.new == 1) {
                if (!bl) continue;
                this.goto = true;
            }
            if (this.c != null) {
                this.c.reset();
                if (!this.c.next()) continue;
            }
            if (this.new != 3 && !bl) continue;
            return true;
        }
        this.new = 2;
        return false;
    }

    protected void setNullRow() {
        this.new = 3;
        this.f = this.i.getNullRow();
        this.try = this.f;
        if (this.long != null) {
            this.long.visit(new TableFilterVisitor(){

                public void accept(TableFilter tableFilter) {
                    tableFilter.setNullRow();
                }
            });
        }
    }

    private void a() {
        this.session.checkCanceled();
    }

    private boolean a(Expression expression) {
        if (expression == null) {
            return true;
        }
        return Boolean.TRUE.equals(expression.getBooleanValue(this.session));
    }

    public Row get() {
        if (this.f == null && this.try != null) {
            this.f = this.byte.get();
        }
        return this.f;
    }

    public void set(Row row) {
        this.f = row;
        this.try = row;
    }

    public String getTableAlias() {
        if (this.d != null) {
            return this.d;
        }
        return this.i.getName();
    }

    public void addIndexCondition(IndexCondition indexCondition) {
        this.int.add(indexCondition);
    }

    public void addFilterCondition(Expression expression, boolean bl) {
        if (bl) {
            this.m = this.m == null ? expression : new ConditionAndOr(0, this.m, expression);
        } else {
            this.g = this.g == null ? expression : new ConditionAndOr(0, this.g, expression);
        }
    }

    public void addJoin(TableFilter tableFilter, boolean bl, boolean bl2, final Expression expression) {
        if (expression != null) {
            expression.mapColumns(this, 0);
            if (this.session.getDatabase().getSettings().nestedJoins) {
                this.visit(new TableFilterVisitor(){

                    public void accept(TableFilter tableFilter) {
                        expression.mapColumns(tableFilter, 0);
                    }
                });
                tableFilter.visit(new TableFilterVisitor(){

                    public void accept(TableFilter tableFilter) {
                        expression.mapColumns(tableFilter, 0);
                    }
                });
            }
        }
        if (bl2 && this.session.getDatabase().getSettings().nestedJoins) {
            if (this.long != null) {
                throw DbException.throwInternalError();
            }
            this.long = tableFilter;
            tableFilter.l = bl;
            if (bl) {
                this.visit(new TableFilterVisitor(){

                    public void accept(TableFilter tableFilter) {
                        tableFilter.joinOuterIndirect = true;
                    }
                });
            }
            if (expression != null) {
                tableFilter.mapAndAddFilter(expression);
            }
        } else if (this.c == null) {
            this.c = tableFilter;
            tableFilter.l = bl;
            if (this.session.getDatabase().getSettings().nestedJoins) {
                if (bl) {
                    tableFilter.visit(new TableFilterVisitor(){

                        public void accept(TableFilter tableFilter) {
                            tableFilter.joinOuterIndirect = true;
                        }
                    });
                }
            } else if (bl) {
                TableFilter tableFilter2 = tableFilter.c;
                while (tableFilter2 != null) {
                    tableFilter2.l = true;
                    tableFilter2 = tableFilter2.c;
                }
            }
            if (expression != null) {
                tableFilter.mapAndAddFilter(expression);
            }
        } else {
            this.c.addJoin(tableFilter, bl, bl2, expression);
        }
    }

    public void mapAndAddFilter(Expression expression) {
        expression.mapColumns(this, 0);
        this.addFilterCondition(expression, true);
        expression.createIndexConditions(this.session, this);
        if (this.long != null) {
            expression.mapColumns(this.long, 0);
            expression.createIndexConditions(this.session, this.long);
        }
        if (this.c != null) {
            this.c.mapAndAddFilter(expression);
        }
    }

    public TableFilter getJoin() {
        return this.c;
    }

    public boolean isJoinOuter() {
        return this.l;
    }

    public boolean isJoinOuterIndirect() {
        return this.joinOuterIndirect;
    }

    public String getPlanSQL(boolean bl) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            if (this.l) {
                stringBuilder.append("LEFT OUTER JOIN ");
            } else {
                stringBuilder.append("INNER JOIN ");
            }
        }
        if (this.long != null) {
            stringBuilder.append("(\n");
            TableFilter tableFilter = this.long;
            do {
                stringBuilder.append(tableFilter.getPlanSQL(tableFilter != this.long));
                stringBuilder.append("\n");
            } while ((tableFilter = tableFilter.getJoin()) != null);
            stringBuilder.append(") ON ");
            if (this.m == null) {
                stringBuilder.append("1=1");
            } else {
                stringBuilder.append(StringUtils.unEnclose(this.m.getSQL()));
            }
            return stringBuilder.toString();
        }
        stringBuilder.append(this.i.getSQL());
        if (this.d != null) {
            stringBuilder.append(' ').append(Parser.quoteIdentifier(this.d));
        }
        if (this.else != null) {
            stringBuilder.append(" /* ");
            object = new StatementBuilder();
            ((StatementBuilder)object).append(this.else.getPlanSQL());
            if (this.int.size() > 0) {
                ((StatementBuilder)object).append(": ");
                for (IndexCondition indexCondition : this.int) {
                    ((StatementBuilder)object).appendExceptFirst(" AND ");
                    ((StatementBuilder)object).append(indexCondition.getSQL());
                }
            }
            String string = StringUtils.quoteRemarkSQL(((StatementBuilder)object).toString());
            stringBuilder.append(string).append(" */");
        }
        if (bl) {
            stringBuilder.append(" ON ");
            if (this.m == null) {
                stringBuilder.append("1=1");
            } else {
                stringBuilder.append(StringUtils.unEnclose(this.m.getSQL()));
            }
        }
        if (this.g != null) {
            stringBuilder.append(" /* WHERE ");
            object = StringUtils.unEnclose(this.g.getSQL());
            object = StringUtils.quoteRemarkSQL((String)object);
            stringBuilder.append((String)object).append(" */");
        }
        if (this.void > 0) {
            stringBuilder.append(" /* scanCount: ").append(this.void).append(" */");
        }
        return stringBuilder.toString();
    }

    void removeUnusableIndexConditions() {
        for (int i2 = 0; i2 < this.int.size(); ++i2) {
            IndexCondition indexCondition = (IndexCondition)this.int.get(i2);
            if (indexCondition.isEvaluatable()) continue;
            this.int.remove(i2--);
        }
    }

    public Index getIndex() {
        return this.else;
    }

    public void setIndex(Index index) {
        this.else = index;
        this.byte.setIndex(index);
    }

    public void setUsed(boolean bl) {
        this.char = bl;
    }

    public boolean isUsed() {
        return this.char;
    }

    void setSession(Session session) {
        this.session = session;
    }

    public void removeJoin() {
        this.c = null;
    }

    public Expression getJoinCondition() {
        return this.m;
    }

    public void removeJoinCondition() {
        this.m = null;
    }

    public Expression getFilterCondition() {
        return this.g;
    }

    public void removeFilterCondition() {
        this.g = null;
    }

    public void setFullCondition(Expression expression) {
        this.k = expression;
        if (this.c != null) {
            this.c.setFullCondition(expression);
        }
    }

    void optimizeFullCondition(boolean bl) {
        if (this.k != null) {
            this.k.addFilterConditions(this, bl || this.l);
            if (this.long != null) {
                this.long.optimizeFullCondition(bl || this.l);
            }
            if (this.c != null) {
                this.c.optimizeFullCondition(bl || this.l);
            }
        }
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        tableFilter.setEvaluatable(bl);
        if (this.g != null) {
            this.g.setEvaluatable(tableFilter, bl);
        }
        if (this.m != null) {
            this.m.setEvaluatable(tableFilter, bl);
        }
        if (this.long != null) {
            this.long.setEvaluatable(tableFilter, bl);
        }
        if (this.c != null) {
            this.c.setEvaluatable(tableFilter, bl);
        }
    }

    public void setEvaluatable(boolean bl) {
        this.n = bl;
    }

    public String getSchemaName() {
        return this.i.getSchema().getName();
    }

    public Column[] getColumns() {
        return this.i.getColumns();
    }

    public Column[] getSystemColumns() {
        if (!this.session.getDatabase().getMode().systemColumns) {
            return null;
        }
        Column[] columnArray = new Column[3];
        columnArray[0] = new Column("oid", 4);
        columnArray[0].setTable(this.i, 0);
        columnArray[1] = new Column("ctid", 13);
        columnArray[1].setTable(this.i, 0);
        columnArray[2] = new Column("CTID", 13);
        columnArray[2].setTable(this.i, 0);
        return columnArray;
    }

    public Value getValue(Column column) {
        if (this.try == null) {
            return null;
        }
        int n2 = column.getColumnId();
        if (this.f == null) {
            Value value = this.try.getValue(n2);
            if (value != null) {
                return value;
            }
            this.f = this.byte.get();
        }
        return this.f.getValue(n2);
    }

    public TableFilter getTableFilter() {
        return this;
    }

    public void setAlias(String string) {
        this.d = string;
    }

    public Expression optimize(ExpressionColumn expressionColumn, Column column) {
        return expressionColumn;
    }

    public String toString() {
        return this.d != null ? this.d : this.i.toString();
    }

    public void addNaturalJoinColumn(Column column) {
        if (this.j == null) {
            this.j = New.arrayList();
        }
        this.j.add(column);
    }

    public boolean isNaturalJoinColumn(Column column) {
        return this.j != null && this.j.indexOf(column) >= 0;
    }

    public int hashCode() {
        return this.h;
    }

    public boolean hasInComparisons() {
        for (IndexCondition indexCondition : this.int) {
            int n2 = indexCondition.getCompareType();
            if (n2 != 10 && n2 != 9) continue;
            return true;
        }
        return false;
    }

    public void lockRowAdd(ArrayList arrayList) {
        if (this.new == 1) {
            arrayList.add(this.get());
        }
    }

    public void lockRows(ArrayList arrayList) {
        for (Row row : arrayList) {
            Row row2 = row.getCopy();
            this.i.removeRow(this.session, row);
            this.session.log(this.i, (short)1, row);
            this.i.addRow(this.session, row2);
            this.session.log(this.i, (short)0, row2);
        }
    }

    public TableFilter getNestedJoin() {
        return this.long;
    }

    public void visit(TableFilterVisitor tableFilterVisitor) {
        TableFilter tableFilter = this;
        do {
            tableFilterVisitor.accept(tableFilter);
            TableFilter tableFilter2 = tableFilter.long;
            if (tableFilter2 == null) continue;
            tableFilter2.visit(tableFilterVisitor);
        } while ((tableFilter = tableFilter.c) != null);
    }

    public boolean isEvaluatable() {
        return this.n;
    }

    public static interface TableFilterVisitor {
        public void accept(TableFilter var1);
    }
}

