/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.LinkedIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableLinkConnection;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TableLink
extends Table {
    private static final long bT = 100000L;
    private String bK;
    private String bG;
    private String bS;
    private String bC;
    private String bM;
    private String bE;
    private String bF;
    private TableLinkConnection bH;
    private HashMap bI = New.hashMap();
    private final ArrayList bJ = New.arrayList();
    private final boolean bB;
    private LinkedIndex bO;
    private DbException bQ;
    private boolean bP;
    private boolean bL;
    private boolean bR;
    private boolean bD;
    private boolean bN;

    public TableLink(Schema schema, int n2, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, boolean bl2) {
        super(schema, n2, string, false, true);
        this.bK = string2;
        this.bG = string3;
        this.bS = string4;
        this.bC = string5;
        this.bM = string6;
        this.bE = string7;
        this.bB = bl;
        try {
            this.char();
        }
        catch (DbException dbException) {
            this.bQ = dbException;
            if (!bl2) {
                throw dbException;
            }
            Column[] columnArray = new Column[]{};
            this.setColumns(columnArray);
            this.bO = new LinkedIndex(this, n2, IndexColumn.wrap(columnArray), IndexType.createNonUnique(false));
            this.bJ.add(this.bO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void char() {
        TableLinkConnection tableLinkConnection = this.bH = this.database.getLinkConnection(this.bK, this.bG, this.bS, this.bC);
        synchronized (tableLinkConnection) {
            try {
                this.case();
            }
            catch (Exception exception) {
                this.bH.close();
                this.bH = null;
                throw DbException.convert(exception);
            }
        }
    }

    private void case() throws SQLException {
        Object object;
        int n2;
        int n3;
        int n4;
        long l2;
        int n5;
        String string;
        Column[] columnArray;
        Object object2;
        DatabaseMetaData databaseMetaData = this.bH.getConnection().getMetaData();
        this.bP = databaseMetaData.storesLowerCaseIdentifiers();
        this.bL = databaseMetaData.storesMixedCaseIdentifiers();
        this.bR = databaseMetaData.supportsMixedCaseIdentifiers();
        ResultSet resultSet = databaseMetaData.getTables(null, this.bM, this.bE, null);
        if (resultSet.next() && resultSet.next()) {
            throw DbException.get(90080, this.bE);
        }
        resultSet.close();
        resultSet = databaseMetaData.getColumns(null, this.bM, this.bE, null);
        int n6 = 0;
        ArrayList arrayList = New.arrayList();
        HashMap hashMap = New.hashMap();
        String string2 = null;
        String string3 = null;
        while (resultSet.next()) {
            object2 = resultSet.getString("TABLE_CAT");
            if (string2 == null) {
                string2 = object2;
            }
            columnArray = resultSet.getString("TABLE_SCHEM");
            if (string3 == null) {
                string3 = columnArray;
            }
            if (!StringUtils.equals(string2, (String)object2) || !StringUtils.equals(string3, (String)columnArray)) {
                hashMap.clear();
                arrayList.clear();
                break;
            }
            string = resultSet.getString("COLUMN_NAME");
            string = this.do(string);
            n5 = resultSet.getInt("DATA_TYPE");
            l2 = resultSet.getInt("COLUMN_SIZE");
            l2 = this.a(n5, l2);
            n4 = resultSet.getInt("DECIMAL_DIGITS");
            n3 = MathUtils.convertLongToInt(l2);
            n2 = DataType.convertSQLTypeToValueType(n5);
            object = new Column(string, n2, l2, n4, n3);
            ((Column)object).setTable(this, n6++);
            arrayList.add(object);
            hashMap.put(string, object);
        }
        resultSet.close();
        this.bF = this.bE.indexOf(46) < 0 && !StringUtils.isNullOrEmpty(string3) ? string3 + "." + this.bE : this.bE;
        object2 = null;
        try {
            object2 = this.bH.getConnection().createStatement();
            resultSet = object2.executeQuery("SELECT * FROM " + this.bF + " T WHERE 1=0");
            if (arrayList.size() == 0) {
                columnArray = resultSet.getMetaData();
                n6 = 0;
                while (n6 < columnArray.getColumnCount()) {
                    string = columnArray.getColumnName(n6 + 1);
                    string = this.do(string);
                    n5 = columnArray.getColumnType(n6 + 1);
                    l2 = columnArray.getPrecision(n6 + 1);
                    l2 = this.a(n5, l2);
                    n4 = columnArray.getScale(n6 + 1);
                    n3 = columnArray.getColumnDisplaySize(n6 + 1);
                    n2 = DataType.convertSQLTypeToValueType(n5);
                    object = new Column(string, n2, l2, n4, n3);
                    ((Column)object).setTable(this, n6++);
                    arrayList.add(object);
                    hashMap.put(string, object);
                }
            }
            resultSet.close();
        }
        catch (Exception exception) {
            throw DbException.get(42102, exception, this.bE + "(" + exception.toString() + ")");
        }
        finally {
            JdbcUtils.closeSilently((Statement)object2);
        }
        columnArray = new Column[arrayList.size()];
        arrayList.toArray(columnArray);
        this.setColumns(columnArray);
        int n7 = this.getId();
        this.bO = new LinkedIndex(this, n7, IndexColumn.wrap(columnArray), IndexType.createNonUnique(false));
        this.bJ.add(this.bO);
        try {
            resultSet = databaseMetaData.getPrimaryKeys(null, this.bM, this.bE);
        }
        catch (Exception exception) {
            resultSet = null;
        }
        String string4 = "";
        if (resultSet != null && resultSet.next()) {
            ArrayList arrayList2 = New.arrayList();
            do {
                int n8 = resultSet.getInt("KEY_SEQ");
                if (string4 == null) {
                    string4 = resultSet.getString("PK_NAME");
                }
                while (arrayList2.size() < n8) {
                    arrayList2.add(null);
                }
                String string5 = resultSet.getString("COLUMN_NAME");
                string5 = this.do(string5);
                Column column = (Column)hashMap.get(string5);
                if (n8 == 0) {
                    arrayList2.add(column);
                    continue;
                }
                arrayList2.set(n8 - 1, column);
            } while (resultSet.next());
            this.a(arrayList2, IndexType.createPrimaryKey(false, false));
            resultSet.close();
        }
        try {
            resultSet = databaseMetaData.getIndexInfo(null, this.bM, this.bE, false, true);
        }
        catch (Exception exception) {
            resultSet = null;
        }
        String string6 = null;
        ArrayList arrayList3 = New.arrayList();
        IndexType indexType = null;
        if (resultSet != null) {
            while (resultSet.next()) {
                String string7;
                if (resultSet.getShort("TYPE") == 0 || string4.equals(string7 = resultSet.getString("INDEX_NAME"))) continue;
                if (string6 != null && !string6.equals(string7)) {
                    this.a(arrayList3, indexType);
                    string6 = null;
                }
                if (string6 == null) {
                    string6 = string7;
                    arrayList3.clear();
                }
                n2 = !resultSet.getBoolean("NON_UNIQUE") ? 1 : 0;
                indexType = n2 != 0 ? IndexType.createUnique(false, false) : IndexType.createNonUnique(false);
                object = resultSet.getString("COLUMN_NAME");
                object = this.do((String)object);
                Column column = (Column)hashMap.get(object);
                arrayList3.add(column);
            }
            resultSet.close();
        }
        if (string6 != null) {
            this.a(arrayList3, indexType);
        }
    }

    private long a(int n2, long l2) {
        switch (n2) {
            case 91: {
                l2 = Math.max(8L, l2);
                break;
            }
            case 93: {
                l2 = Math.max(23L, l2);
                break;
            }
            case 92: {
                l2 = Math.max(6L, l2);
            }
        }
        return l2;
    }

    private String do(String string) {
        if ((this.bL || this.bP) && string.equals(StringUtils.toLowerEnglish(string))) {
            string = StringUtils.toUpperEnglish(string);
        } else if (this.bL && !this.bR) {
            string = StringUtils.toUpperEnglish(string);
        }
        return string;
    }

    private void a(ArrayList arrayList, IndexType indexType) {
        Column[] columnArray = new Column[arrayList.size()];
        arrayList.toArray(columnArray);
        LinkedIndex linkedIndex = new LinkedIndex(this, 0, IndexColumn.wrap(columnArray), indexType);
        this.bJ.add(linkedIndex);
    }

    public String getDropSQL() {
        return "DROP TABLE IF EXISTS " + this.getSQL();
    }

    public String getCreateSQL() {
        StringBuilder stringBuilder = new StringBuilder("CREATE FORCE ");
        if (this.isTemporary()) {
            if (this.bD) {
                stringBuilder.append("GLOBAL ");
            } else {
                stringBuilder.append("LOCAL ");
            }
            stringBuilder.append("TEMPORARY ");
        }
        stringBuilder.append("LINKED TABLE ").append(this.getSQL());
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        stringBuilder.append('(').append(StringUtils.quoteStringSQL(this.bK)).append(", ").append(StringUtils.quoteStringSQL(this.bG)).append(", ").append(StringUtils.quoteStringSQL(this.bS)).append(", ").append(StringUtils.quoteStringSQL(this.bC)).append(", ").append(StringUtils.quoteStringSQL(this.bE)).append(')');
        if (this.bB) {
            stringBuilder.append(" EMIT UPDATES");
        }
        if (this.bN) {
            stringBuilder.append(" READONLY");
        }
        stringBuilder.append(" /*--hide--*/");
        return stringBuilder.toString();
    }

    public Index addIndex(Session session, String string, int n2, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        throw DbException.getUnsupportedException("LINK");
    }

    public void lock(Session session, boolean bl, boolean bl2) {
    }

    public boolean isLockedExclusively() {
        return false;
    }

    public Index getScanIndex(Session session) {
        return this.bO;
    }

    private void else() {
        if (this.bN) {
            throw DbException.get(90097);
        }
    }

    public void removeRow(Session session, Row row) {
        this.else();
        this.getScanIndex(session).remove(session, row);
    }

    public void addRow(Session session, Row row) {
        this.else();
        this.getScanIndex(session).add(session, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Session session) {
        if (this.bH != null) {
            try {
                this.bH.close();
            }
            finally {
                this.bH = null;
            }
        }
    }

    public synchronized long getRowCount(Session session) {
        String string = "SELECT COUNT(*) FROM " + this.bF;
        try {
            PreparedStatement preparedStatement = this.getPreparedStatement(string, false);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            long l2 = resultSet.getLong(1);
            resultSet.close();
            return l2;
        }
        catch (Exception exception) {
            throw this.wrapException(string, exception);
        }
    }

    public DbException wrapException(String string, Exception exception) {
        SQLException sQLException = DbException.toSQLException(exception);
        return DbException.get(90111, sQLException, string, sQLException.toString());
    }

    public String getQualifiedTable() {
        return this.bF;
    }

    public PreparedStatement getPreparedStatement(String string, boolean bl) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} :\n{1}", this.getName(), string);
        }
        try {
            if (this.bH == null) {
                throw this.bQ;
            }
            PreparedStatement preparedStatement = (PreparedStatement)this.bI.get(string);
            if (preparedStatement == null) {
                preparedStatement = this.bH.getConnection().prepareStatement(string);
                this.bI.put(string, preparedStatement);
            }
            if (bl) {
                this.bI.remove(string);
            }
            return preparedStatement;
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    public void unlock(Session session) {
    }

    public void checkRename() {
    }

    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("LINK");
    }

    public void truncate(Session session) {
        throw DbException.getUnsupportedException("LINK");
    }

    public boolean canGetRowCount() {
        return true;
    }

    public boolean canDrop() {
        return true;
    }

    public String getTableType() {
        return "TABLE LINK";
    }

    public void removeChildrenAndResources(Session session) {
        super.removeChildrenAndResources(session);
        this.close(session);
        this.database.removeMeta(session, this.getId());
        this.bK = null;
        this.bE = null;
        this.bC = null;
        this.bS = null;
        this.bG = null;
        this.bI = null;
        this.invalidate();
    }

    public boolean isOracle() {
        return this.bG.startsWith("jdbc:oracle:");
    }

    public ArrayList getIndexes() {
        return this.bJ;
    }

    public long getMaxDataModificationId() {
        return Long.MAX_VALUE;
    }

    public Index getUniqueIndex() {
        for (Index index : this.bJ) {
            if (!index.getIndexType().isUnique()) continue;
            return index;
        }
        return null;
    }

    public void updateRows(Prepared prepared, Session session, RowList rowList) {
        boolean bl;
        this.else();
        if (this.bB) {
            rowList.reset();
            while (rowList.hasNext()) {
                prepared.checkCanceled();
                Row row = rowList.next();
                Row row2 = rowList.next();
                this.bO.update(row, row2);
                session.log(this, (short)1, row);
                session.log(this, (short)0, row2);
            }
            bl = false;
        } else {
            bl = true;
        }
        if (bl) {
            super.updateRows(prepared, session, rowList);
        }
    }

    public void setGlobalTemporary(boolean bl) {
        this.bD = bl;
    }

    public void setReadOnly(boolean bl) {
        this.bN = bl;
    }

    public TableLinkConnection getConnection() {
        return this.bH;
    }

    public long getRowCountApproximation() {
        return 100000L;
    }

    public void reusePreparedStatement(PreparedStatement preparedStatement, String string) {
        this.bI.put(string, preparedStatement);
    }

    public boolean isDeterministic() {
        return false;
    }

    public void checkWritingAllowed() {
    }

    public void validateConvertUpdateSequence(Session session, Row row) {
        for (int i2 = 0; i2 < this.columns.length; ++i2) {
            Column column;
            Value value;
            Value value2 = row.getValue(i2);
            if (value2 == null || (value = (column = this.columns[i2]).validateConvertUpdateSequence(session, value2)) == value2) continue;
            row.setValue(i2, value);
        }
    }

    public Value getDefaultValue(Session session, Column column) {
        return null;
    }
}

