/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.CRC32;
import org.h2.compress.CompressLZF;
import org.h2.engine.MetaRecord;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SimpleRow;
import org.h2.security.SHA256;
import org.h2.store.Data;
import org.h2.store.DataHandler;
import org.h2.store.DataReader;
import org.h2.store.FileLister;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.LobStorage;
import org.h2.store.PageFreeList;
import org.h2.store.PageLog;
import org.h2.store.PageStore;
import org.h2.util.BitField;
import org.h2.util.IOUtils;
import org.h2.util.IntArray;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.SmallLRUCache;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.TempFileDeleter;
import org.h2.util.Tool;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueLobDb;
import org.h2.value.ValueLong;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Recover
extends Tool
implements DataHandler {
    private String gW;
    private int gR;
    private int g3;
    private String g2;
    private int gQ;
    private int gO;
    private boolean gV;
    private ArrayList gS;
    private HashSet gY;
    private HashMap gP;
    private HashMap g1;
    private boolean gU;
    private int gX;
    private FileStore g0;
    private int[] gZ;
    private Stats gT;

    public static void main(String ... stringArray) throws SQLException {
        new Recover().runTool(stringArray);
    }

    public void runTool(String ... stringArray) throws SQLException {
        String string = ".";
        String string2 = null;
        for (int i2 = 0; stringArray != null && i2 < stringArray.length; ++i2) {
            String string3 = stringArray[i2];
            if ("-dir".equals(string3)) {
                string = stringArray[++i2];
                continue;
            }
            if ("-db".equals(string3)) {
                string2 = stringArray[++i2];
                continue;
            }
            if ("-removePassword".equals(string3)) {
                this.gU = true;
                continue;
            }
            if ("-trace".equals(string3)) {
                this.gV = true;
                continue;
            }
            if (string3.equals("-help") || string3.equals("-?")) {
                this.showUsage();
                return;
            }
            this.throwUnsupportedOption(string3);
        }
        this.if(string, string2);
    }

    public static Reader readClob(String string) throws IOException {
        return new BufferedReader(new InputStreamReader(Recover.readBlob(string), "UTF-8"));
    }

    public static InputStream readBlob(String string) throws IOException {
        return new BufferedInputStream(IOUtils.openFileInputStream(string));
    }

    public static Value.ValueBlob readBlobDb(Connection connection, long l2, long l3) {
        DataHandler dataHandler = ((JdbcConnection)connection).getSession().getDataHandler();
        LobStorage lobStorage = dataHandler.getLobStorage();
        return ValueLobDb.create(15, lobStorage, null, -2, l2, l3);
    }

    public static Value.ValueClob readClobDb(Connection connection, long l2, long l3) {
        DataHandler dataHandler = ((JdbcConnection)connection).getSession().getDataHandler();
        LobStorage lobStorage = dataHandler.getLobStorage();
        return ValueLobDb.create(16, lobStorage, null, -2, l2, l3);
    }

    private void char(String string) {
        if (this.gV) {
            this.out.println(string);
        }
    }

    private void a(String string, Throwable throwable) {
        this.out.println(string + ": " + throwable.toString());
        if (this.gV) {
            throwable.printStackTrace(this.out);
        }
    }

    public static void execute(String string, String string2) throws SQLException {
        try {
            new Recover().if(string, string2);
        }
        catch (DbException dbException) {
            throw DbException.toSQLException(dbException);
        }
    }

    private void if(String string, String string2) {
        ArrayList arrayList = FileLister.getDatabaseFiles(string, string2, true);
        if (arrayList.size() == 0) {
            this.printNoDatabaseFilesFound(string, string2);
        }
        for (String string3 : arrayList) {
            if (string3.endsWith(".h2.db")) {
                this.byte(string3);
                continue;
            }
            if (!string3.endsWith(".lob.db")) continue;
            this.int(string3, false);
        }
    }

    private PrintWriter do(String string, String string2) {
        string = string.substring(0, string.length() - 3);
        String string3 = string + string2;
        this.char("Created file: " + string3);
        return new PrintWriter(IOUtils.getBufferedWriter(IOUtils.openFileOutputStream(string3, false)));
    }

    private void a(PrintWriter printWriter, String string, byte[] byArray) {
        int n2;
        int n3;
        printWriter.println("-- ERROR: " + string + " block: " + this.gR + " storageId: " + this.g3 + " recordLength: " + this.gQ + " valueId: " + this.gO);
        StringBuilder stringBuilder = new StringBuilder();
        for (n3 = 0; n3 < byArray.length; ++n3) {
            n2 = byArray[n3] & 0xFF;
            if (n2 >= 32 && n2 < 128) {
                stringBuilder.append((char)n2);
                continue;
            }
            stringBuilder.append('?');
        }
        printWriter.println("-- dump: " + stringBuilder.toString());
        stringBuilder = new StringBuilder();
        for (n3 = 0; n3 < byArray.length; ++n3) {
            n2 = byArray[n3] & 0xFF;
            stringBuilder.append(' ');
            if (n2 < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(n2));
        }
        printWriter.println("-- dump: " + stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void int(String string, boolean bl) {
        OutputStream outputStream = null;
        FileStore fileStore = null;
        int n2 = 0;
        String string2 = string + (bl ? ".comp" : "") + ".txt";
        BufferedInputStream bufferedInputStream = null;
        try {
            int n3;
            outputStream = IOUtils.openFileOutputStream(string2, false);
            fileStore = FileStore.open(null, string, "r");
            fileStore.init();
            bufferedInputStream = new BufferedInputStream(new FileStoreInputStream(fileStore, this, bl, false));
            byte[] byArray = new byte[4096];
            while ((n3 = ((InputStream)bufferedInputStream).read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n3);
                n2 += n3;
            }
            outputStream.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeSilently(outputStream);
            IOUtils.closeSilently(bufferedInputStream);
            this.a(fileStore);
            catch (Throwable throwable2) {
                IOUtils.closeSilently(outputStream);
                IOUtils.closeSilently(bufferedInputStream);
                this.a(fileStore);
                throw throwable2;
            }
        }
        IOUtils.closeSilently(outputStream);
        IOUtils.closeSilently(bufferedInputStream);
        this.a(fileStore);
        if (n2 == 0) {
            try {
                IOUtils.delete(string2);
            }
            catch (Exception exception) {
                this.a(string2, (Throwable)exception);
            }
        }
    }

    private String a(String string, Value value) {
        ValueLobDb valueLobDb;
        byte[] byArray;
        if (value instanceof ValueLob) {
            ValueLob valueLob = (ValueLob)value;
            byte[] byArray2 = valueLob.getSmall();
            if (byArray2 == null) {
                String string2;
                String string3 = valueLob.getFileName();
                String string4 = string2 = valueLob.getType() == 15 ? "BLOB" : "CLOB";
                if (valueLob.useCompression()) {
                    this.int(string3, true);
                    string3 = string3 + ".comp";
                }
                return "READ_" + string2 + "('" + string3 + ".txt')";
            }
        } else if (value instanceof ValueLobDb && (byArray = (valueLobDb = (ValueLobDb)value).getSmall()) == null) {
            String string5;
            String string6;
            int n2 = valueLobDb.getType();
            long l2 = valueLobDb.getLobId();
            long l3 = valueLobDb.getPrecision();
            if (n2 == 15) {
                string6 = "BLOB";
                string5 = "READ_BLOB_DB";
            } else {
                string6 = "CLOB";
                string5 = "READ_CLOB_DB";
            }
            this.g1.put(string, string6);
            return string5 + "(" + l2 + ", " + l3 + ")";
        }
        return value.getSQL();
    }

    private void try(String string) {
        this.gW = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void byte(String string) {
        this.try(string.substring(0, string.length() - ".h2.db".length()));
        PrintWriter printWriter = null;
        this.gT = new Stats();
        try {
            printWriter = this.do(string, ".sql");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB FOR \"" + this.getClass().getName() + ".readBlob\";");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB FOR \"" + this.getClass().getName() + ".readClob\";");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB_DB FOR \"" + this.getClass().getName() + ".readBlobDb\";");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB_DB FOR \"" + this.getClass().getName() + ".readClobDb\";");
            this.B();
            this.g0 = FileStore.open(null, string, this.gU ? "rw" : "r");
            long l2 = this.g0.length();
            try {
                this.g0.init();
            }
            catch (Exception exception) {
                this.a(printWriter, (Throwable)exception);
            }
            Data data = Data.create((DataHandler)this, 128);
            this.a(0L);
            this.g0.readFully(data.getBytes(), 0, 128);
            data.setPos(48);
            this.gX = data.readInt();
            byte by = data.readByte();
            byte by2 = data.readByte();
            printWriter.println("-- pageSize: " + this.gX + " writeVersion: " + by + " readVersion: " + by2);
            if (this.gX < 64 || this.gX > 32768) {
                this.gX = 2048;
                printWriter.println("-- ERROR: page size; using " + this.gX);
            }
            long l3 = l2 / (long)this.gX;
            this.gZ = new int[(int)l3];
            data = Data.create((DataHandler)this, this.gX);
            for (long i2 = 3L; i2 < l3; ++i2) {
                data.reset();
                this.a(i2);
                this.g0.readFully(data.getBytes(), 0, 32);
                data.readByte();
                data.readShortInt();
                this.gZ[(int)i2] = data.readInt();
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            data = Data.create((DataHandler)this, this.gX);
            for (long i3 = 1L; i3 != 3L; ++i3) {
                data.reset();
                this.a(i3);
                this.g0.readFully(data.getBytes(), 0, this.gX);
                CRC32 cRC32 = new CRC32();
                cRC32.update(data.getBytes(), 4, this.gX - 4);
                int n5 = (int)cRC32.getValue();
                int n6 = data.readInt();
                long l4 = data.readLong();
                int n7 = data.readInt();
                int n8 = data.readInt();
                int n9 = data.readInt();
                if (n5 == n6) {
                    n2 = n7;
                    n3 = n8;
                    n4 = n9;
                }
                printWriter.println("-- head " + i3 + ": writeCounter: " + l4 + " log key: " + n7 + " trunk: " + n8 + "/" + n9 + " crc expected " + n5 + " got " + n6 + " (" + (n5 == n6 ? "ok" : "different") + ")");
            }
            printWriter.println("-- firstTrunkPage: " + n3 + " firstDataPage: " + n4);
            PrintWriter printWriter2 = new PrintWriter(new OutputStream(){

                public void write(int n2) {
                }
            });
            this.a(printWriter2, l3);
            this.gT = new Stats();
            this.gS.clear();
            this.gY = New.hashSet();
            this.a(printWriter, l3);
            this.if(printWriter);
            try {
                this.a(printWriter, n2, n3, n4);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            printWriter.println("---- Statistics ----------");
            printWriter.println("-- page count: " + l3 + " free: " + this.gT.free);
            printWriter.println("-- page data head: " + this.gT.pageDataHead + " empty: " + this.gT.pageDataEmpty + " rows: " + this.gT.pageDataRows);
            for (int i4 = 0; i4 < this.gT.pageTypeCount.length; ++i4) {
                int n10 = this.gT.pageTypeCount[i4];
                if (n10 <= 0) continue;
                printWriter.println("-- page count type: " + i4 + " " + (long)(100 * n10) / l3 + "% count: " + n10);
            }
            printWriter.close();
        }
        catch (Throwable throwable) {
            try {
                this.a(printWriter, throwable);
            }
            catch (Throwable throwable2) {
                IOUtils.closeSilently(printWriter);
                this.a(this.g0);
                throw throwable2;
            }
            IOUtils.closeSilently(printWriter);
            this.a(this.g0);
        }
        IOUtils.closeSilently(printWriter);
        this.a(this.g0);
    }

    private void a(PrintWriter printWriter, long l2) {
        Data data = Data.create((DataHandler)this, this.gX);
        block13: for (long i2 = 3L; i2 < l2; ++i2) {
            data = Data.create((DataHandler)this, this.gX);
            this.a(i2);
            this.g0.readFully(data.getBytes(), 0, this.gX);
            int n2 = data.readByte();
            switch (n2) {
                case 0: {
                    int n3 = n2;
                    this.gT.pageTypeCount[n3] = this.gT.pageTypeCount[n3] + 1;
                    continue block13;
                }
                default: {
                    boolean bl = (n2 & 0x10) != 0;
                    n2 &= 0xFFFFFFEF;
                    if (!PageStore.checksumTest(data.getBytes(), (int)i2, this.gX)) {
                        printWriter.println("-- ERROR: page " + i2 + " checksum mismatch type: " + n2);
                    }
                    data.readShortInt();
                    switch (n2) {
                        case 1: {
                            int n4 = n2;
                            this.gT.pageTypeCount[n4] = this.gT.pageTypeCount[n4] + 1;
                            int n5 = data.readInt();
                            this.if(data.readVarInt());
                            int n6 = data.readVarInt();
                            short s = data.readShortInt();
                            printWriter.println("-- page " + i2 + ": data leaf " + (bl ? "(last) " : "") + "parent: " + n5 + " table: " + this.g3 + " entries: " + s + " columns: " + n6);
                            this.a(printWriter, data, bl, i2, n6, s);
                            continue block13;
                        }
                        case 2: {
                            int n7 = n2;
                            this.gT.pageTypeCount[n7] = this.gT.pageTypeCount[n7] + 1;
                            int n5 = data.readInt();
                            this.if(data.readVarInt());
                            int n6 = data.readInt();
                            short s = data.readShortInt();
                            printWriter.println("-- page " + i2 + ": data node " + (bl ? "(last) " : "") + "parent: " + n5 + " table: " + this.g3 + " entries: " + s + " rowCount: " + n6);
                            this.a(printWriter, data, i2, (int)s);
                            continue block13;
                        }
                        case 3: {
                            int n8 = n2;
                            this.gT.pageTypeCount[n8] = this.gT.pageTypeCount[n8] + 1;
                            printWriter.println("-- page " + i2 + ": data overflow " + (bl ? "(last) " : ""));
                            continue block13;
                        }
                        case 4: {
                            int n9 = n2;
                            this.gT.pageTypeCount[n9] = this.gT.pageTypeCount[n9] + 1;
                            int n5 = data.readInt();
                            this.if(data.readVarInt());
                            int n6 = data.readShortInt();
                            printWriter.println("-- page " + i2 + ": b-tree leaf " + (bl ? "(last) " : "") + "parent: " + n5 + " index: " + this.g3 + " entries: " + n6);
                            if (!this.gV) continue block13;
                            this.a(printWriter, data, n6, !bl);
                            continue block13;
                        }
                        case 5: {
                            int n10 = n2;
                            this.gT.pageTypeCount[n10] = this.gT.pageTypeCount[n10] + 1;
                            int n5 = data.readInt();
                            this.if(data.readVarInt());
                            printWriter.println("-- page " + i2 + ": b-tree node " + (bl ? "(last) " : "") + "parent: " + n5 + " index: " + this.g3);
                            this.a(printWriter, data, i2, !bl);
                            continue block13;
                        }
                        case 6: {
                            int n11 = n2;
                            this.gT.pageTypeCount[n11] = this.gT.pageTypeCount[n11] + 1;
                            printWriter.println("-- page " + i2 + ": free list " + (bl ? "(last)" : ""));
                            this.gT.free += this.a(printWriter, data, i2, l2);
                            continue block13;
                        }
                        case 7: {
                            int n12 = n2;
                            this.gT.pageTypeCount[n12] = this.gT.pageTypeCount[n12] + 1;
                            printWriter.println("-- page " + i2 + ": log trunk");
                            continue block13;
                        }
                        case 8: {
                            int n13 = n2;
                            this.gT.pageTypeCount[n13] = this.gT.pageTypeCount[n13] + 1;
                            printWriter.println("-- page " + i2 + ": log data");
                            continue block13;
                        }
                        default: {
                            printWriter.println("-- ERROR page " + i2 + " unknown type " + n2);
                        }
                    }
                }
            }
        }
    }

    private void a(PrintWriter printWriter, int n2, int n3, int n4) throws IOException {
        byte by;
        Data data = Data.create((DataHandler)this, this.gX);
        DataReader dataReader = new DataReader(new PageInputStream(printWriter, this, this.g0, n2, n3, n4, this.gX));
        printWriter.println("---- Transaction log ----------");
        CompressLZF compressLZF = new CompressLZF();
        while ((by = dataReader.read()) >= 0) {
            int n5;
            if (by == 0) continue;
            if (by == 1) {
                Object object;
                n5 = dataReader.readVarInt();
                int n6 = dataReader.readVarInt();
                byte[] byArray = new byte[this.gX];
                if (n6 == 0) {
                    dataReader.readFully(byArray, 0, this.gX);
                } else if (n6 != 1) {
                    object = new byte[n6];
                    dataReader.readFully((byte[])object, 0, n6);
                    try {
                        compressLZF.expand((byte[])object, 0, n6, byArray, 0, this.gX);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw DbException.convertToIOException(arrayIndexOutOfBoundsException);
                    }
                }
                object = "";
                int n7 = byArray[0];
                boolean bl = (n7 & 0x10) != 0;
                switch (n7 &= 0xFFFFFFEF) {
                    case 0: {
                        object = "empty";
                        break;
                    }
                    case 1: {
                        object = "data leaf " + (bl ? "(last)" : "");
                        break;
                    }
                    case 2: {
                        object = "data node " + (bl ? "(last)" : "");
                        break;
                    }
                    case 3: {
                        object = "data overflow " + (bl ? "(last)" : "");
                        break;
                    }
                    case 4: {
                        object = "b-tree leaf " + (bl ? "(last)" : "");
                        break;
                    }
                    case 5: {
                        object = "b-tree node " + (bl ? "(last)" : "");
                        break;
                    }
                    case 6: {
                        object = "free list " + (bl ? "(last)" : "");
                        break;
                    }
                    case 7: {
                        object = "log trunk";
                        break;
                    }
                    case 8: {
                        object = "log data";
                        break;
                    }
                    default: {
                        object = "ERROR: unknown type " + n7;
                    }
                }
                printWriter.println("-- undo page " + n5 + " " + (String)object);
                continue;
            }
            if (by == 5) {
                n5 = dataReader.readVarInt();
                this.if(dataReader.readVarInt());
                Row row = PageLog.readRow(dataReader, data);
                printWriter.println("-- session " + n5 + " table " + this.g3 + " add " + row.toString());
                continue;
            }
            if (by == 6) {
                n5 = dataReader.readVarInt();
                this.if(dataReader.readVarInt());
                long l2 = dataReader.readVarLong();
                printWriter.println("-- session " + n5 + " table " + this.g3 + " remove " + l2);
                continue;
            }
            if (by == 7) {
                n5 = dataReader.readVarInt();
                this.if(dataReader.readVarInt());
                printWriter.println("-- session " + n5 + " table " + this.g3 + " truncate");
                continue;
            }
            if (by == 2) {
                n5 = dataReader.readVarInt();
                printWriter.println("-- commit " + n5);
                continue;
            }
            if (by == 4) {
                n5 = dataReader.readVarInt();
                printWriter.println("-- rollback " + n5);
                continue;
            }
            if (by == 3) {
                n5 = dataReader.readVarInt();
                String string = dataReader.readString();
                printWriter.println("-- prepare commit " + n5 + " " + string);
                continue;
            }
            if (by == 0) continue;
            if (by == 8) {
                printWriter.println("-- checkpoint");
                continue;
            }
            if (by == 9) {
                n5 = dataReader.readVarInt();
                StringBuilder stringBuilder = new StringBuilder("-- free");
                for (int i2 = 0; i2 < n5; ++i2) {
                    stringBuilder.append(' ').append(dataReader.readVarInt());
                }
                printWriter.println(stringBuilder);
                continue;
            }
            printWriter.println("-- ERROR: unknown operation " + by);
            break;
        }
    }

    private String if(int n2) {
        this.g3 = n2;
        this.g2 = "O_" + String.valueOf(n2).replace('-', 'M');
        return this.g2;
    }

    private void a(PrintWriter printWriter, Data data, long l2, boolean bl) {
        int n2;
        int n3;
        int n4 = data.readInt();
        int n5 = data.readShortInt();
        int[] nArray = new int[n5 + 1];
        int[] nArray2 = new int[n5];
        nArray[n5] = data.readInt();
        this.a(printWriter, l2, nArray, n5);
        int n6 = Integer.MAX_VALUE;
        for (n3 = 0; n3 < n5; ++n3) {
            nArray[n3] = data.readInt();
            this.a(printWriter, l2, nArray, n3);
            n2 = data.readShortInt();
            n6 = Math.min(n2, n6);
            nArray2[n3] = n2;
        }
        n6 -= data.length();
        if (!this.gV) {
            return;
        }
        printWriter.println("--   empty: " + n6);
        for (n3 = 0; n3 < n5; ++n3) {
            Value value;
            n2 = nArray2[n3];
            data.setPos(n2);
            long l3 = data.readVarLong();
            if (bl) {
                value = ValueLong.get(l3);
            } else {
                try {
                    value = data.readValue();
                }
                catch (Throwable throwable) {
                    this.a(printWriter, "exception " + throwable, data.getBytes());
                    continue;
                }
            }
            printWriter.println("-- [" + n3 + "] child: " + nArray[n3] + " key: " + l3 + " data: " + value);
        }
        printWriter.println("-- [" + n5 + "] child: " + nArray[n5] + " rowCount: " + n4);
    }

    private int a(PrintWriter printWriter, Data data, long l2, long l3) {
        int n2;
        int n3 = PageFreeList.getPagesAddressed(this.gX);
        BitField bitField = new BitField();
        for (n2 = 0; n2 < n3; n2 += 8) {
            int n4 = data.readByte() & 0xFF;
            for (int i2 = 0; i2 < 8; ++i2) {
                if ((n4 & 1 << i2) == 0) continue;
                bitField.set(n2 + i2);
            }
        }
        n2 = 0;
        long l4 = 0L;
        for (long i3 = l2; l4 < (long)n3 && i3 < l3; ++l4, ++i3) {
            if (l4 == 0L || i3 % 100L == 0L) {
                if (l4 > 0L) {
                    printWriter.println();
                }
                printWriter.print("-- " + i3 + " ");
            } else if (i3 % 20L == 0L) {
                printWriter.print(" - ");
            } else if (i3 % 10L == 0L) {
                printWriter.print(' ');
            }
            printWriter.print(bitField.get((int)l4) ? (char)'1' : '0');
            if (bitField.get((int)l4)) continue;
            ++n2;
        }
        printWriter.println();
        return n2;
    }

    private void a(PrintWriter printWriter, Data data, int n2, boolean bl) {
        int n3;
        int n4;
        int[] nArray = new int[n2];
        int n5 = Integer.MAX_VALUE;
        for (n4 = 0; n4 < n2; ++n4) {
            n3 = data.readShortInt();
            n5 = Math.min(n3, n5);
            nArray[n4] = n3;
        }
        printWriter.println("--   empty: " + (n5 -= data.length()));
        for (n4 = 0; n4 < n2; ++n4) {
            Value value;
            n3 = nArray[n4];
            data.setPos(n3);
            long l2 = data.readVarLong();
            if (bl) {
                value = ValueLong.get(l2);
            } else {
                try {
                    value = data.readValue();
                }
                catch (Throwable throwable) {
                    this.a(printWriter, "exception " + throwable, data.getBytes());
                    continue;
                }
            }
            printWriter.println("-- [" + n4 + "] key: " + l2 + " data: " + value);
        }
    }

    private void a(PrintWriter printWriter, long l2, int[] nArray, int n2) {
        int n3 = nArray[n2];
        if (n3 < 0 || n3 >= this.gZ.length) {
            printWriter.println("-- ERROR [" + l2 + "] child[" + n2 + "]: " + n3 + " >= page count: " + this.gZ.length);
        } else if ((long)this.gZ[n3] != l2) {
            printWriter.println("-- ERROR [" + l2 + "] child[" + n2 + "]: " + n3 + " parent: " + this.gZ[n3]);
        }
    }

    private void a(PrintWriter printWriter, Data data, long l2, int n2) {
        int n3;
        int[] nArray = new int[n2 + 1];
        long[] lArray = new long[n2];
        nArray[n2] = data.readInt();
        this.a(printWriter, l2, nArray, n2);
        for (n3 = 0; n3 < n2; ++n3) {
            nArray[n3] = data.readInt();
            this.a(printWriter, l2, nArray, n3);
            lArray[n3] = data.readVarLong();
        }
        if (!this.gV) {
            return;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.println("-- [" + n3 + "] child: " + nArray[n3] + " key: " + lArray[n3]);
        }
        printWriter.println("-- [" + n2 + "] child: " + nArray[n2]);
    }

    private void a(PrintWriter printWriter, Data data, boolean bl, long l2, int n2, int n3) {
        int n4;
        int n5;
        int[] nArray;
        long[] lArray;
        block12: {
            lArray = new long[n3];
            nArray = new int[n3];
            long l3 = 0L;
            if (!bl) {
                l3 = data.readInt();
                printWriter.println("--   next: " + l3);
            }
            int n6 = this.gX;
            for (n5 = 0; n5 < n3; ++n5) {
                lArray[n5] = data.readVarLong();
                short s = data.readShortInt();
                n6 = Math.min(s, n6);
                nArray[n5] = s;
            }
            this.gT.pageDataRows += this.gX - n6;
            this.gT.pageDataHead += data.length();
            this.gT.pageDataEmpty += (long)(n6 -= data.length());
            if (this.gV) {
                printWriter.println("--   empty: " + n6);
            }
            if (!bl) {
                Data data2 = Data.create((DataHandler)this, this.gX);
                data.setPos(this.gX);
                long l4 = l2;
                while (true) {
                    int n7;
                    this.a(printWriter, l4, new int[]{(int)l3}, 0);
                    l4 = l3;
                    this.a(l3);
                    this.g0.readFully(data2.getBytes(), 0, this.gX);
                    data2.reset();
                    n4 = data2.readByte();
                    data2.readShortInt();
                    data2.readInt();
                    if (n4 == 19) {
                        n7 = data2.readShortInt();
                        printWriter.println("-- chain: " + l3 + " type: " + n4 + " size: " + n7);
                        data.checkCapacity(n7);
                        data.write(data2.getBytes(), data2.length(), n7);
                        break block12;
                    }
                    if (n4 != 3) break;
                    l3 = data2.readInt();
                    if (l3 == 0L) {
                        this.a(printWriter, "next:0", data2.getBytes());
                        break block12;
                    }
                    n7 = this.gX - data2.length();
                    printWriter.println("-- chain: " + l3 + " type: " + n4 + " size: " + n7 + " next: " + l3);
                    data.checkCapacity(n7);
                    data.write(data2.getBytes(), data2.length(), n7);
                }
                this.a(printWriter, "type: " + n4, data2.getBytes());
            }
        }
        for (n5 = 0; n5 < n3; ++n5) {
            int n8;
            String string;
            long l5 = lArray[n5];
            n4 = nArray[n5];
            if (this.gV) {
                printWriter.println("-- [" + n5 + "] storage: " + this.g3 + " key: " + l5 + " off: " + n4);
            }
            data.setPos(n4);
            Value[] valueArray = this.a(printWriter, data, n2);
            if (valueArray == null) continue;
            this.a(printWriter);
            this.a(printWriter, data, valueArray);
            if (!this.gU || this.g3 != 0 || !(string = valueArray[3].getString()).startsWith("CREATE USER ") || (n8 = Utils.indexOf(data.getBytes(), "SALT ".getBytes(), n4)) < 0) continue;
            String string2 = string.substring("CREATE USER ".length(), string.indexOf("SALT ") - 1);
            if (string2.startsWith("IF NOT EXISTS ")) {
                string2 = string2.substring("IF NOT EXISTS ".length());
            }
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            SHA256 sHA256 = new SHA256();
            byte[] byArray = sHA256.getKeyPasswordHash(string2, "".toCharArray());
            byte[] byArray2 = MathUtils.secureRandomBytes(8);
            byte[] byArray3 = sHA256.getHashWithSalt(byArray, byArray2);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SALT '").append(StringUtils.convertBytesToString(byArray2)).append("' HASH '").append(StringUtils.convertBytesToString(byArray3)).append('\'');
            byte[] byArray4 = stringBuilder.toString().getBytes();
            System.arraycopy(byArray4, 0, data.getBytes(), n8, byArray4.length);
            this.a(l2);
            this.g0.write(data.getBytes(), 0, this.gX);
            if (this.gV) {
                this.out.println("User: " + string2);
            }
            this.gU = false;
        }
    }

    private void a(long l2) {
        this.g0.seek(l2 * (long)this.gX);
    }

    private Value[] a(PrintWriter printWriter, Data data, int n2) {
        Value[] valueArray;
        this.gQ = n2;
        if (n2 <= 0) {
            this.a(printWriter, "columnCount<0", data.getBytes());
            return null;
        }
        try {
            valueArray = new Value[n2];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.a(printWriter, "out of memory", data.getBytes());
            return null;
        }
        return valueArray;
    }

    private void a(PrintWriter printWriter, Data data, Value[] valueArray) {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("INSERT INTO " + this.g2 + " VALUES(");
        this.gO = 0;
        while (this.gO < this.gQ) {
            try {
                object2 = data.readValue();
                valueArray[this.gO] = object2;
                if (this.gO > 0) {
                    stringBuilder.append(", ");
                }
                object = this.g2 + "." + this.gO;
                stringBuilder.append(this.a((String)object, (Value)object2));
            }
            catch (Exception exception) {
                this.a(printWriter, "exception " + exception, data.getBytes());
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.a(printWriter, "out of memory", data.getBytes());
            }
            ++this.gO;
        }
        stringBuilder.append(");");
        printWriter.println(stringBuilder.toString());
        if (this.g3 == 0) {
            try {
                object2 = new SimpleRow(valueArray);
                object = new MetaRecord((SearchRow)object2);
                this.gS.add(object);
                if (((MetaRecord)object).getObjectType() == 0) {
                    String string = valueArray[3].getString();
                    String string2 = this.case(string);
                    this.gP.put(((MetaRecord)object).getId(), string2);
                }
            }
            catch (Throwable throwable) {
                this.a(printWriter, throwable);
            }
        }
    }

    private void B() {
        this.gS = New.arrayList();
        this.gY = New.hashSet();
        this.gP = New.hashMap();
        this.g1 = New.hashMap();
    }

    private void if(PrintWriter printWriter) {
        String string;
        Object object;
        printWriter.println("---- Schema ----------");
        Collections.sort(this.gS);
        for (Object object2 : this.gS) {
            int n2 = ((MetaRecord)object2).getObjectType();
            if (n2 == 1 || n2 == 5) continue;
            object = ((MetaRecord)object2).getSQL();
            printWriter.println((String)object + ";");
        }
        boolean bl = false;
        for (Map.Entry entry : this.gP.entrySet()) {
            object = (Integer)entry.getKey();
            string = (String)entry.getValue();
            if (!this.gY.contains(object) || !string.startsWith("INFORMATION_SCHEMA.LOB")) continue;
            this.if((Integer)object);
            printWriter.println("DELETE FROM " + string + ";");
            printWriter.println("INSERT INTO " + string + " SELECT * FROM " + this.g2 + ";");
            if (!string.startsWith("INFORMATION_SCHEMA.LOBS")) continue;
            printWriter.println("UPDATE " + string + " SET TABLE = " + -2 + ";");
            bl = true;
        }
        for (Map.Entry entry : this.gP.entrySet()) {
            object = (Integer)entry.getKey();
            string = (String)entry.getValue();
            if (!this.gY.contains(object)) continue;
            this.if((Integer)object);
            if (string.startsWith("INFORMATION_SCHEMA.LOB")) continue;
            printWriter.println("INSERT INTO " + string + " SELECT * FROM " + this.g2 + ";");
        }
        for (Integer n3 : this.gY) {
            this.if(n3);
            printWriter.println("DROP TABLE " + this.g2 + ";");
        }
        printWriter.println("DROP ALIAS READ_BLOB;");
        printWriter.println("DROP ALIAS READ_CLOB;");
        printWriter.println("DROP ALIAS READ_BLOB_DB;");
        printWriter.println("DROP ALIAS READ_CLOB_DB;");
        if (bl) {
            printWriter.println("DELETE FROM INFORMATION_SCHEMA.LOBS WHERE TABLE = -2;");
        }
        for (MetaRecord metaRecord : this.gS) {
            int n4 = metaRecord.getObjectType();
            if (n4 != 1 && n4 != 5) continue;
            string = metaRecord.getSQL();
            printWriter.println(string + ";");
        }
    }

    private void a(PrintWriter printWriter) {
        if (!this.gY.contains(this.g3)) {
            this.gY.add(this.g3);
            StatementBuilder statementBuilder = new StatementBuilder("CREATE TABLE ");
            statementBuilder.append(this.g2).append('(');
            for (int i2 = 0; i2 < this.gQ; ++i2) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append('C').append(i2).append(' ');
                String string = (String)this.g1.get(this.g2 + "." + i2);
                if (string == null) {
                    statementBuilder.append("VARCHAR");
                    continue;
                }
                statementBuilder.append(string);
            }
            printWriter.println(statementBuilder.append(");").toString());
            printWriter.flush();
        }
    }

    private String case(String string) {
        int n2 = string.indexOf(" TABLE ");
        int n3 = string.indexOf(" VIEW ");
        if (n2 > 0 && n3 > 0) {
            if (n2 < n3) {
                n3 = -1;
            } else {
                n2 = -1;
            }
        }
        if (n3 > 0) {
            string = string.substring(n3 + " VIEW ".length());
        } else if (n2 > 0) {
            string = string.substring(n2 + " TABLE ".length());
        } else {
            return "UNKNOWN";
        }
        if (string.startsWith("IF NOT EXISTS ")) {
            string = string.substring("IF NOT EXISTS ".length());
        }
        boolean bl = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\"') {
                bl = !bl;
                continue;
            }
            if (bl || c2 > ' ' && c2 != '(') continue;
            string = string.substring(0, i2);
            return string;
        }
        return "UNKNOWN";
    }

    private void a(FileStore fileStore) {
        if (fileStore != null) {
            fileStore.closeSilently();
        }
    }

    private void a(PrintWriter printWriter, Throwable throwable) {
        if (printWriter != null) {
            printWriter.println("// error: " + throwable);
        }
        this.a("Error", throwable);
    }

    public String getDatabasePath() {
        return this.gW;
    }

    public FileStore openFile(String string, String string2, boolean bl) {
        return FileStore.open(this, string, "rw");
    }

    public void checkPowerOff() {
    }

    public void checkWritingAllowed() {
    }

    public void freeUpDiskSpace() {
    }

    public int getMaxLengthInplaceLob() {
        throw DbException.throwInternalError();
    }

    public String getLobCompressionAlgorithm(int n2) {
        return null;
    }

    public Object getLobSyncObject() {
        return this;
    }

    public SmallLRUCache getLobFileListCache() {
        return null;
    }

    public TempFileDeleter getTempFileDeleter() {
        return TempFileDeleter.getInstance();
    }

    public LobStorage getLobStorage() {
        return null;
    }

    public Connection getLobConnection() {
        return null;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class PageInputStream
    extends InputStream {
        private final PrintWriter if;
        private final FileStore char;
        private final Data try;
        private final int byte;
        private long new;
        private long case;
        private IntArray for = new IntArray();
        private boolean a;
        private int do;
        private int int;

        public PageInputStream(PrintWriter printWriter, DataHandler dataHandler, FileStore fileStore, int n2, long l2, long l3, int n3) {
            this.if = printWriter;
            this.char = fileStore;
            this.byte = n3;
            this.int = n2 - 1;
            this.new = l2;
            this.case = l3;
            this.try = Data.create(dataHandler, n3);
        }

        public int read() {
            byte[] byArray = new byte[]{0};
            int n2 = this.read(byArray);
            return n2 < 0 ? -1 : byArray[0] & 0xFF;
        }

        public int read(byte[] byArray) {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n2, int n3) {
            int n4;
            if (n3 == 0) {
                return 0;
            }
            int n5 = 0;
            while (n3 > 0 && (n4 = this.a(byArray, n2, n3)) >= 0) {
                n5 += n4;
                n2 += n4;
                n3 -= n4;
            }
            return n5 == 0 ? -1 : n5;
        }

        private int a(byte[] byArray, int n2, int n3) {
            this.a();
            if (this.a) {
                return -1;
            }
            int n4 = Math.min(this.do, n3);
            this.try.read(byArray, n2, n4);
            this.do -= n4;
            return n4;
        }

        private void a() {
            int n2;
            int n3;
            int n4;
            if (this.do > 0 || this.a) {
                return;
            }
            while (this.for.size() == 0) {
                if (this.new == 0L) {
                    this.a = true;
                    return;
                }
                this.char.seek(this.new * (long)this.byte);
                this.char.readFully(this.try.getBytes(), 0, this.byte);
                this.try.reset();
                if (!PageStore.checksumTest(this.try.getBytes(), (int)this.new, this.byte)) {
                    this.if.println("-- ERROR: checksum mismatch page: " + this.new);
                    this.a = true;
                    return;
                }
                byte by = this.try.readByte();
                this.try.readShortInt();
                if (by != 7) {
                    this.if.println("-- eof  page: " + this.new + " type: " + by + " expected type: " + 7);
                    this.a = true;
                    return;
                }
                this.try.readInt();
                int n5 = this.try.readInt();
                ++this.int;
                if (n5 != this.int) {
                    this.if.println("-- eof  page: " + this.new + " type: " + by + " expected key: " + this.int + " got: " + n5);
                }
                this.new = this.try.readInt();
                n4 = this.try.readShortInt();
                for (n3 = 0; n3 < n4; ++n3) {
                    n2 = this.try.readInt();
                    if (this.case != 0L) {
                        if ((long)n2 != this.case) continue;
                        this.case = 0L;
                    }
                    this.for.add(n2);
                }
            }
            if (this.for.size() > 0) {
                this.try.reset();
                long l2 = this.for.get(0);
                this.for.remove(0);
                this.char.seek(l2 * (long)this.byte);
                this.char.readFully(this.try.getBytes(), 0, this.byte);
                this.try.reset();
                n4 = this.try.readByte();
                if (n4 != 0 && !PageStore.checksumTest(this.try.getBytes(), (int)l2, this.byte)) {
                    this.if.println("-- ERROR: checksum mismatch page: " + l2);
                    this.a = true;
                    return;
                }
                this.try.readShortInt();
                n3 = this.try.readInt();
                n2 = this.try.readInt();
                if (n4 != 8) {
                    this.if.println("-- eof  page: " + l2 + " type: " + n4 + " parent: " + n3 + " expected type: " + 8);
                    this.a = true;
                    return;
                }
                if (n2 != this.int) {
                    this.if.println("-- eof  page: " + l2 + " type: " + n4 + " parent: " + n3 + " expected key: " + this.int + " got: " + n2);
                    this.a = true;
                    return;
                }
                this.do = this.byte - this.try.length();
            }
        }
    }

    static class Stats {
        long pageDataEmpty;
        int pageDataRows;
        int pageDataHead;
        int[] pageTypeCount = new int[10];
        int free;

        Stats() {
        }
    }
}

