/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.IOException;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.message.TraceSystem;
import org.h2.server.Service;
import org.h2.server.ShutdownHandler;
import org.h2.server.TcpServer;
import org.h2.server.pg.PgServer;
import org.h2.server.web.WebServer;
import org.h2.util.StringUtils;
import org.h2.util.Tool;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Server
extends Tool
implements Runnable,
ShutdownHandler {
    private Service g4;
    private Server g5;
    private Server g7;
    private Server g8;
    private ShutdownHandler g6;

    public Server() {
    }

    public Server(Service service, String ... stringArray) throws SQLException {
        this.g4 = service;
        try {
            service.init(stringArray);
        }
        catch (Exception exception) {
            throw DbException.toSQLException(exception);
        }
    }

    public static void main(String ... stringArray) throws SQLException {
        new Server().runTool(stringArray);
    }

    public void runTool(String ... stringArray) throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string = "";
        String string2 = "";
        boolean bl7 = true;
        for (int i2 = 0; stringArray != null && i2 < stringArray.length; ++i2) {
            String string3 = stringArray[i2];
            if (string3 == null) continue;
            if ("-?".equals(string3) || "-help".equals(string3)) {
                this.showUsage();
                return;
            }
            if (string3.startsWith("-web")) {
                if ("-web".equals(string3)) {
                    bl7 = false;
                    bl3 = true;
                    continue;
                }
                if ("-webAllowOthers".equals(string3) || "-webDaemon".equals(string3) || "-webSSL".equals(string3)) continue;
                if ("-webPort".equals(string3)) {
                    ++i2;
                    continue;
                }
                if ("-webScript".equals(string3)) {
                    ++i2;
                    continue;
                }
                this.throwUnsupportedOption(string3);
                continue;
            }
            if ("-browser".equals(string3)) {
                bl7 = false;
                bl4 = true;
                continue;
            }
            if (string3.startsWith("-tcp")) {
                if ("-tcp".equals(string3)) {
                    bl7 = false;
                    bl = true;
                    continue;
                }
                if ("-tcpAllowOthers".equals(string3) || "-tcpDaemon".equals(string3) || "-tcpSSL".equals(string3)) continue;
                if ("-tcpPort".equals(string3)) {
                    ++i2;
                    continue;
                }
                if ("-tcpPassword".equals(string3)) {
                    string = stringArray[++i2];
                    continue;
                }
                if ("-tcpShutdown".equals(string3)) {
                    bl7 = false;
                    bl5 = true;
                    string2 = stringArray[++i2];
                    continue;
                }
                if ("-tcpShutdownForce".equals(string3)) {
                    bl6 = true;
                    continue;
                }
                this.throwUnsupportedOption(string3);
                continue;
            }
            if (string3.startsWith("-pg")) {
                if ("-pg".equals(string3)) {
                    bl7 = false;
                    bl2 = true;
                    continue;
                }
                if ("-pgAllowOthers".equals(string3) || "-pgDaemon".equals(string3)) continue;
                if ("-pgPort".equals(string3)) {
                    ++i2;
                    continue;
                }
                this.throwUnsupportedOption(string3);
                continue;
            }
            if ("-properties".equals(string3)) {
                ++i2;
                continue;
            }
            if ("-trace".equals(string3) || "-ifExists".equals(string3)) continue;
            if ("-baseDir".equals(string3)) {
                ++i2;
                continue;
            }
            this.throwUnsupportedOption(string3);
        }
        if (bl7) {
            bl = true;
            bl2 = true;
            bl3 = true;
            bl4 = true;
        }
        if (bl5) {
            this.out.println("Shutting down TCP Server at " + string2);
            Server.shutdownTcpServer(string2, string, bl6, false);
        }
        if (bl3) {
            this.g5 = Server.createWebServer(stringArray);
            this.g5.setShutdownHandler(this);
            SQLException sQLException = null;
            try {
                this.g5.start();
            }
            catch (Exception exception) {
                sQLException = DbException.toSQLException(exception);
            }
            this.out.println(this.g5.getStatus());
            if (bl4) {
                Server.openBrowser(this.g5.getURL());
            }
            if (sQLException != null) {
                throw sQLException;
            }
        }
        if (bl) {
            this.g7 = Server.createTcpServer(stringArray);
            this.g7.start();
            this.out.println(this.g7.getStatus());
        }
        if (bl2) {
            this.g8 = Server.createPgServer(stringArray);
            this.g8.start();
            this.out.println(this.g8.getStatus());
        }
    }

    public static void shutdownTcpServer(String string, String string2, boolean bl, boolean bl2) throws SQLException {
        TcpServer.shutdown(string, string2, bl, bl2);
    }

    public String getStatus() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isRunning(false)) {
            stringBuilder.append(this.g4.getType()).append(" server running on ").append(this.g4.getURL()).append(" (");
            if (this.g4.getAllowOthers()) {
                stringBuilder.append("others can connect");
            } else {
                stringBuilder.append("only local connections");
            }
            stringBuilder.append(')');
        } else {
            stringBuilder.append("The ").append(this.g4.getType()).append(" server could not be started. Possible cause: another server is already running on ").append(this.g4.getURL());
        }
        return stringBuilder.toString();
    }

    public static Server createWebServer(String ... stringArray) throws SQLException {
        WebServer webServer = new WebServer();
        Server server = new Server(webServer, stringArray);
        webServer.setShutdownHandler(server);
        return server;
    }

    public static Server createTcpServer(String ... stringArray) throws SQLException {
        return new Server(new TcpServer(), stringArray);
    }

    public static Server createPgServer(String ... stringArray) throws SQLException {
        return new Server(new PgServer(), stringArray);
    }

    public Server start() throws SQLException {
        try {
            this.g4.start();
            Thread thread = new Thread(this);
            thread.setDaemon(this.g4.isDaemon());
            String string = this.g4.getName() + " (" + this.g4.getURL() + ")";
            thread.setName(string);
            thread.start();
            for (int i2 = 1; i2 < 64; i2 += i2) {
                Server.do(i2);
                if (!this.isRunning(false)) continue;
                return this;
            }
            if (this.isRunning(true)) {
                return this;
            }
            throw DbException.get(90061, string, "timeout");
        }
        catch (DbException dbException) {
            throw DbException.toSQLException(dbException);
        }
    }

    private static void do(int n2) {
        try {
            long l2 = (long)n2 * (long)n2;
            Thread.sleep(l2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void C() {
        if (this.g5 != null && this.g5.isRunning(false)) {
            this.g5.stop();
            this.g5 = null;
        }
        if (this.g7 != null && this.g7.isRunning(false)) {
            this.g7.stop();
            this.g7 = null;
        }
        if (this.g8 != null && this.g8.isRunning(false)) {
            this.g8.stop();
            this.g8 = null;
        }
    }

    public boolean isRunning(boolean bl) {
        return this.g4.isRunning(bl);
    }

    public void stop() {
        this.g4.stop();
    }

    public String getURL() {
        return this.g4.getURL();
    }

    public int getPort() {
        return this.g4.getPort();
    }

    public void run() {
        try {
            this.g4.listen();
        }
        catch (Exception exception) {
            TraceSystem.traceThrowable(exception);
        }
    }

    public void setShutdownHandler(ShutdownHandler shutdownHandler) {
        this.g6 = shutdownHandler;
    }

    public void shutdown() {
        if (this.g6 != null) {
            this.g6.shutdown();
        } else {
            this.C();
        }
    }

    public Service getService() {
        return this.g4;
    }

    public static void openBrowser(String string) {
        String string2 = SysProperties.getStringSetting("os.name", "linux").toLowerCase();
        Runtime runtime = Runtime.getRuntime();
        try {
            String[] stringArray;
            String string3 = SysProperties.BROWSER;
            if (string3 != null) {
                if (string3.indexOf("%url") >= 0) {
                    String[] stringArray2 = StringUtils.arraySplit(string3, ',', false);
                    for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                        stringArray2[i2] = StringUtils.replaceAll(stringArray2[i2], "%url", string);
                    }
                    runtime.exec(stringArray2);
                } else if (string2.indexOf("windows") >= 0) {
                    runtime.exec(new String[]{"cmd.exe", "/C", string3, string});
                } else {
                    runtime.exec(new String[]{string3, string});
                }
                return;
            }
            try {
                stringArray = Class.forName("java.awt.Desktop");
                Boolean bl = (Boolean)stringArray.getMethod("isDesktopSupported", new Class[0]).invoke(null, new Object[0]);
                String[] stringArray3 = new URI(string);
                if (bl.booleanValue()) {
                    Object object = stringArray.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    stringArray.getMethod("browse", URI.class).invoke(object, new Object[]{stringArray3});
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2.indexOf("windows") >= 0) {
                runtime.exec(new String[]{"rundll32", "url.dll,FileProtocolHandler", string});
            } else if (string2.indexOf("mac") >= 0) {
                Runtime.getRuntime().exec(new String[]{"open", string});
            } else {
                stringArray = new String[]{"firefox", "mozilla-firefox", "mozilla", "konqueror", "netscape", "opera"};
                boolean bl = false;
                for (String string4 : stringArray) {
                    try {
                        runtime.exec(new String[]{string4, string});
                        bl = true;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
                if (!bl) {
                    System.out.println("Please open a browser and go to " + string);
                }
            }
        }
        catch (IOException iOException) {
            System.out.println("Failed to start a browser to open the URL " + string);
            iOException.printStackTrace();
        }
    }

    public static void startWebServer(Connection connection) throws SQLException {
        WebServer webServer = new WebServer();
        Server server = new Server(webServer, "-webPort", "0");
        server.start();
        Server server2 = new Server();
        server2.g5 = server;
        webServer.setShutdownHandler(server2);
        String string = webServer.addSession(connection);
        Server.openBrowser(string);
        while (!webServer.isStopped()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

