/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.ArrayList;
import java.util.Collections;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.util.Cache;
import org.h2.util.CacheHead;
import org.h2.util.CacheObject;
import org.h2.util.CacheSecondLevel;
import org.h2.util.CacheWriter;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.SoftHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CacheLRU
implements Cache {
    static final String TYPE_NAME = "LRU";
    private final CacheWriter do;
    private final CacheObject byte = new CacheHead();
    private final int char;
    private CacheObject[] case;
    private int for;
    private final int try;
    private int int;
    private int new;

    private CacheLRU(CacheWriter cacheWriter, int n2) {
        this.setMaxMemory(n2);
        this.do = cacheWriter;
        this.try = MathUtils.nextPowerOf2(this.int / 64);
        this.char = this.try - 1;
        MathUtils.checkPowerOf2(this.try);
        this.clear();
    }

    public static Cache getCache(CacheWriter cacheWriter, String string, int n2) {
        SoftHashMap softHashMap = null;
        if (string.startsWith("SOFT_")) {
            softHashMap = new SoftHashMap();
            string = string.substring("SOFT_".length());
        }
        if (!TYPE_NAME.equals(string)) {
            throw DbException.getInvalidValueException("CACHE_TYPE", string);
        }
        Cache cache = new CacheLRU(cacheWriter, n2);
        if (softHashMap != null) {
            cache = new CacheSecondLevel(cache, softHashMap);
        }
        return cache;
    }

    public void clear() {
        this.byte.cacheNext = this.byte.cachePrevious = this.byte;
        this.case = null;
        this.case = new CacheObject[this.try];
        this.for = 0;
        this.new = this.try * 8;
    }

    public void put(CacheObject cacheObject) {
        int n2;
        CacheObject cacheObject2;
        if (SysProperties.CHECK && (cacheObject2 = this.find(n2 = cacheObject.getPos())) != null) {
            DbException.throwInternalError("try to add a record twice pos:" + n2);
        }
        n2 = cacheObject.getPos() & this.char;
        cacheObject.cacheChained = this.case[n2];
        this.case[n2] = cacheObject;
        ++this.for;
        this.new += cacheObject.getMemory();
        this.if(cacheObject);
        this.a();
    }

    public CacheObject update(int n2, CacheObject cacheObject) {
        CacheObject cacheObject2 = this.find(n2);
        if (cacheObject2 == null) {
            this.put(cacheObject);
        } else {
            if (SysProperties.CHECK && cacheObject2 != cacheObject) {
                DbException.throwInternalError("old!=record pos:" + n2 + " old:" + cacheObject2 + " new:" + cacheObject);
            }
            this.a(cacheObject);
            this.if(cacheObject);
        }
        return cacheObject2;
    }

    private void a() {
        if (this.new >= this.int) {
            this.if();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void if() {
        int n2 = 0;
        ArrayList arrayList = New.arrayList();
        int n3 = this.new;
        int n4 = this.for;
        boolean bl = false;
        CacheObject cacheObject = this.byte.cacheNext;
        while (n3 * 4 > this.int * 3 && n4 > 16) {
            CacheObject cacheObject2 = cacheObject;
            cacheObject = cacheObject2.cacheNext;
            if (++n2 >= this.for) {
                if (!bl) {
                    this.do.flushLog();
                    bl = true;
                    n2 = 0;
                } else {
                    this.do.getTrace().info("Cannot remove records, cache size too small? records:" + this.for + " memory:" + this.new);
                    break;
                }
            }
            if (SysProperties.CHECK && cacheObject2 == this.byte) {
                DbException.throwInternalError("try to remove head");
            }
            if (!cacheObject2.canRemove()) {
                this.a(cacheObject2);
                this.if(cacheObject2);
                continue;
            }
            --n4;
            n3 -= cacheObject2.getMemory();
            if (cacheObject2.isChanged()) {
                arrayList.add(cacheObject2);
                continue;
            }
            this.remove(cacheObject2.getPos());
        }
        if (arrayList.size() > 0) {
            CacheObject cacheObject3;
            if (!bl) {
                this.do.flushLog();
            }
            Collections.sort(arrayList);
            int n5 = this.int;
            int n6 = arrayList.size();
            try {
                this.int = Integer.MAX_VALUE;
                for (n2 = 0; n2 < n6; ++n2) {
                    cacheObject3 = (CacheObject)arrayList.get(n2);
                    this.do.writeBack(cacheObject3);
                }
            }
            finally {
                this.int = n5;
            }
            for (n2 = 0; n2 < n6; ++n2) {
                cacheObject3 = (CacheObject)arrayList.get(n2);
                this.remove(cacheObject3.getPos());
                if (!SysProperties.CHECK || cacheObject3.cacheNext == null) continue;
                throw DbException.throwInternalError();
            }
        }
    }

    private void if(CacheObject cacheObject) {
        if (SysProperties.CHECK && cacheObject == this.byte) {
            DbException.throwInternalError("try to move head");
        }
        cacheObject.cacheNext = this.byte;
        cacheObject.cachePrevious = this.byte.cachePrevious;
        cacheObject.cachePrevious.cacheNext = cacheObject;
        this.byte.cachePrevious = cacheObject;
    }

    private void a(CacheObject cacheObject) {
        if (SysProperties.CHECK && cacheObject == this.byte) {
            DbException.throwInternalError("try to remove head");
        }
        cacheObject.cachePrevious.cacheNext = cacheObject.cacheNext;
        cacheObject.cacheNext.cachePrevious = cacheObject.cachePrevious;
        cacheObject.cacheNext = null;
        cacheObject.cachePrevious = null;
    }

    public void remove(int n2) {
        CacheObject cacheObject;
        int n3 = n2 & this.char;
        CacheObject cacheObject2 = this.case[n3];
        if (cacheObject2 == null) {
            return;
        }
        if (cacheObject2.getPos() == n2) {
            this.case[n3] = cacheObject2.cacheChained;
        } else {
            do {
                cacheObject = cacheObject2;
                cacheObject2 = cacheObject2.cacheChained;
                if (cacheObject2 != null) continue;
                return;
            } while (cacheObject2.getPos() != n2);
            cacheObject.cacheChained = cacheObject2.cacheChained;
        }
        --this.for;
        this.new -= cacheObject2.getMemory();
        this.a(cacheObject2);
        if (SysProperties.CHECK) {
            cacheObject2.cacheChained = null;
            cacheObject = this.find(n2);
            if (cacheObject != null) {
                DbException.throwInternalError("not removed: " + cacheObject);
            }
        }
    }

    public CacheObject find(int n2) {
        CacheObject cacheObject = this.case[n2 & this.char];
        while (cacheObject != null && cacheObject.getPos() != n2) {
            cacheObject = cacheObject.cacheChained;
        }
        return cacheObject;
    }

    public CacheObject get(int n2) {
        CacheObject cacheObject = this.find(n2);
        if (cacheObject != null) {
            this.a(cacheObject);
            this.if(cacheObject);
        }
        return cacheObject;
    }

    public ArrayList getAllChanged() {
        ArrayList arrayList = New.arrayList();
        CacheObject cacheObject = this.byte.cacheNext;
        while (cacheObject != this.byte) {
            if (cacheObject.isChanged()) {
                arrayList.add(cacheObject);
            }
            cacheObject = cacheObject.cacheNext;
        }
        return arrayList;
    }

    public void setMaxMemory(int n2) {
        int n3 = MathUtils.convertLongToInt((long)n2 * 1024L / 4L);
        this.int = n3 < 0 ? 0 : n3;
        this.a();
    }

    public int getMaxMemory() {
        return (int)((long)this.int * 4L / 1024L);
    }

    public int getMemory() {
        return (int)((long)this.new * 4L / 1024L);
    }
}

