/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.IOException;
import java.net.BindException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.security.CipherFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NetUtils {
    private static final int do = 1000;
    private static InetAddress a;
    private static String if;
    private static long for;

    private NetUtils() {
    }

    public static Socket createLoopbackSocket(int n2, boolean bl) throws IOException {
        InetAddress inetAddress = NetUtils.a();
        if (inetAddress == null) {
            inetAddress = InetAddress.getLocalHost();
        }
        return NetUtils.createSocket(NetUtils.a(inetAddress), n2, bl);
    }

    private static String a(InetAddress inetAddress) {
        String string = inetAddress.getHostAddress();
        if (inetAddress instanceof Inet6Address && string.indexOf(58) >= 0 && !string.startsWith("[")) {
            string = "[" + string + "]";
        }
        return string;
    }

    public static Socket createSocket(String string, int n2, boolean bl) throws IOException {
        int n3 = n2;
        int n4 = string.startsWith("[") ? string.indexOf(93) : 0;
        int n5 = string.indexOf(58, n4);
        if (n5 >= 0) {
            n3 = Integer.decode(string.substring(n5 + 1));
            string = string.substring(0, n5);
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        return NetUtils.createSocket(inetAddress, n3, bl);
    }

    public static Socket createSocket(InetAddress inetAddress, int n2, boolean bl) throws IOException {
        int n3 = 0;
        while (true) {
            try {
                if (bl) {
                    return CipherFactory.createSocket(inetAddress, n2);
                }
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(inetAddress, n2), SysProperties.SOCKET_CONNECT_TIMEOUT);
                return socket;
            }
            catch (IOException iOException) {
                if (n3 >= SysProperties.SOCKET_CONNECT_RETRY) {
                    throw iOException;
                }
                try {
                    long l2 = Math.min(256, n3 * n3);
                    Thread.sleep(l2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n3;
                continue;
            }
            break;
        }
    }

    public static ServerSocket createServerSocket(int n2, boolean bl) {
        try {
            return NetUtils.a(n2, bl);
        }
        catch (Exception exception) {
            return NetUtils.a(n2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress a() throws UnknownHostException {
        String string = SysProperties.BIND_ADDRESS;
        if (string == null || string.length() == 0) {
            return null;
        }
        Class<NetUtils> clazz = NetUtils.class;
        synchronized (NetUtils.class) {
            if (a == null) {
                a = InetAddress.getByName(string);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return a;
        }
    }

    private static ServerSocket a(int n2, boolean bl) {
        try {
            InetAddress inetAddress = NetUtils.a();
            if (bl) {
                return CipherFactory.createServerSocket(n2, inetAddress);
            }
            if (inetAddress == null) {
                return new ServerSocket(n2);
            }
            return new ServerSocket(n2, 0, inetAddress);
        }
        catch (BindException bindException) {
            throw DbException.get(90061, bindException, "" + n2, bindException.toString());
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, "port: " + n2 + " ssl: " + bl);
        }
    }

    public static boolean isLocalAddress(Socket socket) throws UnknownHostException {
        InetAddress inetAddress = socket.getInetAddress();
        if (inetAddress.isLoopbackAddress()) {
            return true;
        }
        InetAddress inetAddress2 = InetAddress.getLocalHost();
        String string = inetAddress2.getHostAddress();
        for (InetAddress inetAddress3 : InetAddress.getAllByName(string)) {
            if (!inetAddress.equals(inetAddress3)) continue;
            return true;
        }
        return false;
    }

    public static ServerSocket closeSilently(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static synchronized String getLocalAddress() {
        String string;
        long l2 = System.currentTimeMillis();
        if (if != null && for + 1000L > l2) {
            return if;
        }
        InetAddress inetAddress = null;
        boolean bl = false;
        try {
            inetAddress = NetUtils.a();
            if (inetAddress == null) {
                bl = true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (bl) {
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                throw DbException.convert(unknownHostException);
            }
        }
        String string2 = string = inetAddress == null ? "localhost" : NetUtils.a(inetAddress);
        if (string.equals("127.0.0.1")) {
            string = "localhost";
        }
        if = string;
        for = l2;
        return string;
    }
}

