/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.lang.ref.SoftReference;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Locale;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.util.New;
import org.h2.util.StatementBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StringUtils {
    private static SoftReference do = new SoftReference<Object>(null);
    private static long if;
    private static final char[] a;

    private StringUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] a() {
        String[] stringArray;
        if (do != null && (stringArray = (String[])do.get()) != null) {
            return stringArray;
        }
        long l2 = System.currentTimeMillis();
        if (if != 0L && l2 - if < 5000L) {
            return null;
        }
        try {
            stringArray = new String[SysProperties.OBJECT_CACHE_SIZE];
            do = new SoftReference<String[]>(stringArray);
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        finally {
            if = System.currentTimeMillis();
        }
    }

    public static boolean equals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    public static String toUpperEnglish(String string) {
        return string.toUpperCase(Locale.ENGLISH);
    }

    public static String toLowerEnglish(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        if (string.length() < string2.length()) {
            return false;
        }
        return string.substring(0, string2.length()).equalsIgnoreCase(string2);
    }

    public static String quoteStringSQL(String string) {
        if (string == null) {
            return "NULL";
        }
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2 + 2);
        stringBuilder.append('\'');
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\'') {
                stringBuilder.append(c2);
            } else if (c2 < ' ' || c2 > '\u007f') {
                return "STRINGDECODE(" + StringUtils.quoteStringSQL(StringUtils.javaEncode(string)) + ")";
            }
            stringBuilder.append(c2);
        }
        stringBuilder.append('\'');
        return stringBuilder.toString();
    }

    public static String javaEncode(String string) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        block8: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block8;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block8;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block8;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block8;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block8;
                }
                default: {
                    int n3 = c2 & 0xFFFF;
                    if (n3 >= 32 && n3 < 128) {
                        stringBuilder.append(c2);
                        continue block8;
                    }
                    stringBuilder.append("\\u");
                    stringBuilder.append(Integer.toHexString(0x10000 | n3).substring(1));
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String addAsterisk(String string, int n2) {
        if (string != null && n2 < string.length()) {
            string = string.substring(0, n2) + "[*]" + string.substring(n2);
        }
        return string;
    }

    private static DbException a(String string, int n2) {
        return DbException.get(90095, StringUtils.addAsterisk(string, n2));
    }

    public static String javaDecode(String string) {
        char c2;
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        block17: for (int i2 = 0; i2 < n2 && (c2 = string.charAt(i2)) != '\"'; ++i2) {
            if (c2 == '\\') {
                if (i2 >= string.length()) {
                    throw StringUtils.a(string, string.length() - 1);
                }
                c2 = string.charAt(++i2);
                switch (c2) {
                    case 't': {
                        stringBuilder.append('\t');
                        continue block17;
                    }
                    case 'r': {
                        stringBuilder.append('\r');
                        continue block17;
                    }
                    case 'n': {
                        stringBuilder.append('\n');
                        continue block17;
                    }
                    case 'b': {
                        stringBuilder.append('\b');
                        continue block17;
                    }
                    case 'f': {
                        stringBuilder.append('\f');
                        continue block17;
                    }
                    case '#': {
                        stringBuilder.append('#');
                        continue block17;
                    }
                    case '=': {
                        stringBuilder.append('=');
                        continue block17;
                    }
                    case ':': {
                        stringBuilder.append(':');
                        continue block17;
                    }
                    case '\"': {
                        stringBuilder.append('\"');
                        continue block17;
                    }
                    case '\\': {
                        stringBuilder.append('\\');
                        continue block17;
                    }
                    case 'u': {
                        try {
                            c2 = (char)Integer.parseInt(string.substring(i2 + 1, i2 + 5), 16);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw StringUtils.a(string, i2);
                        }
                        i2 += 4;
                        stringBuilder.append(c2);
                        continue block17;
                    }
                    default: {
                        if (c2 >= '0' && c2 <= '9') {
                            try {
                                c2 = (char)Integer.parseInt(string.substring(i2, i2 + 3), 8);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw StringUtils.a(string, i2);
                            }
                            i2 += 2;
                            stringBuilder.append(c2);
                            continue block17;
                        }
                        throw StringUtils.a(string, i2);
                    }
                }
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String quoteJavaString(String string) {
        if (string == null) {
            return "null";
        }
        return "\"" + StringUtils.javaEncode(string) + "\"";
    }

    public static byte[] utf8Encode(String string) {
        try {
            return string.getBytes("UTF8");
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
    }

    public static String utf8Decode(byte[] byArray) {
        try {
            return new String(byArray, "UTF8");
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
    }

    private static String a(byte[] byArray, int n2, int n3) {
        try {
            return new String(byArray, n2, n3, "UTF8");
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
    }

    public static String quoteJavaStringArray(String[] stringArray) {
        if (stringArray == null) {
            return "null";
        }
        StatementBuilder statementBuilder = new StatementBuilder("new String[]{");
        for (String string : stringArray) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(StringUtils.quoteJavaString(string));
        }
        return statementBuilder.append('}').toString();
    }

    public static String quoteJavaIntArray(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        StatementBuilder statementBuilder = new StatementBuilder("new int[]{");
        for (int n2 : nArray) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(n2);
        }
        return statementBuilder.append('}').toString();
    }

    public static String enclose(String string) {
        if (string.startsWith("(")) {
            return string;
        }
        return "(" + string + ")";
    }

    public static String unEnclose(String string) {
        if (string.startsWith("(") && string.endsWith(")")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
    }

    public static String urlDecode(String string) {
        int n2 = string.length();
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '+') {
                byArray[n3++] = 32;
                continue;
            }
            if (c2 == '%') {
                byArray[n3++] = (byte)Integer.parseInt(string.substring(i2 + 1, i2 + 3), 16);
                i2 += 2;
                continue;
            }
            if (SysProperties.CHECK && (c2 > '\u007f' || c2 < ' ')) {
                throw new IllegalArgumentException("Unexpected char " + c2 + " decoding " + string);
            }
            byArray[n3++] = (byte)c2;
        }
        String string2 = StringUtils.a(byArray, 0, n3);
        return string2;
    }

    public static String[] arraySplit(String string, char c2, boolean bl) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return new String[0];
        }
        ArrayList arrayList = New.arrayList();
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c3 = string.charAt(i2);
            if (c3 == c2) {
                String string2 = stringBuilder.toString();
                arrayList.add(bl ? string2.trim() : string2);
                stringBuilder.setLength(0);
                continue;
            }
            if (c3 == '\\' && i2 < n2 - 1) {
                stringBuilder.append(string.charAt(++i2));
                continue;
            }
            stringBuilder.append(c3);
        }
        String string3 = stringBuilder.toString();
        arrayList.add(bl ? string3.trim() : string3);
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String arrayCombine(String[] stringArray, char c2) {
        StatementBuilder statementBuilder = new StatementBuilder();
        for (String string : stringArray) {
            statementBuilder.appendExceptFirst(String.valueOf(c2));
            if (string == null) {
                string = "";
            }
            int n2 = string.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c3 = string.charAt(i2);
                if (c3 == '\\' || c3 == c2) {
                    statementBuilder.append('\\');
                }
                statementBuilder.append(c3);
            }
        }
        return statementBuilder.toString();
    }

    public static String xmlAttr(String string, String string2) {
        return " " + string + "=\"" + StringUtils.xmlText(string2) + "\"";
    }

    public static String xmlNode(String string, String string2, String string3) {
        String string4;
        String string5 = string4 = string2 == null ? string : string + string2;
        if (string3 == null) {
            return "<" + string4 + "/>\n";
        }
        if (string3.indexOf(10) >= 0) {
            string3 = "\n" + StringUtils.a(string3);
        }
        return "<" + string4 + ">" + string3 + "</" + string + ">\n";
    }

    private static String a(String string) {
        return StringUtils.do(string, 4);
    }

    private static String do(String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + n2);
        int n3 = 0;
        while (n3 < string.length()) {
            int n4;
            for (n4 = 0; n4 < n2; ++n4) {
                stringBuilder.append(' ');
            }
            n4 = string.indexOf(10, n3);
            n4 = n4 < 0 ? string.length() : n4 + 1;
            stringBuilder.append(string.substring(n3, n4));
            n3 = n4;
        }
        if (!string.endsWith("\n")) {
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static String xmlComment(String string) {
        int n2 = 0;
        while ((n2 = string.indexOf("--", n2)) >= 0) {
            string = string.substring(0, n2 + 1) + " " + string.substring(n2 + 1);
        }
        if (string.indexOf(10) >= 0) {
            return "<!--\n" + StringUtils.a(string) + "-->\n";
        }
        return "<!-- " + string + " -->\n";
    }

    public static String xmlCData(String string) {
        if (string.indexOf("]]>") >= 0) {
            return StringUtils.xmlText(string);
        }
        boolean bl = string.endsWith("\n");
        string = "<![CDATA[" + string + "]]>";
        return bl ? string + "\n" : string;
    }

    public static String xmlStartDoc() {
        return "<?xml version=\"1.0\"?>\n";
    }

    public static String xmlText(String string) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        block8: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block8;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block8;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block8;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block8;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block8;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    stringBuilder.append(c2);
                    continue block8;
                }
                default: {
                    if (c2 < ' ' || c2 > '\u007f') {
                        stringBuilder.append("&#x").append(Integer.toHexString(c2)).append(';');
                        continue block8;
                    }
                    stringBuilder.append(c2);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String replaceAll(String string, String string2, String string3) {
        return StringUtils.a(string, string, string2, string3);
    }

    public static String replaceAllIgnoreCase(String string, String string2, String string3) {
        return StringUtils.a(string, StringUtils.toUpperEnglish(string), StringUtils.toUpperEnglish(string2), string3);
    }

    private static String a(String string, String string2, String string3, String string4) {
        int n2 = string2.indexOf(string3);
        if (n2 < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() - string3.length() + string4.length());
        int n3 = 0;
        do {
            stringBuilder.append(string.substring(n3, n2)).append(string4);
        } while ((n2 = string2.indexOf(string3, n3 = n2 + string3.length())) >= 0);
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }

    public static String quoteIdentifier(String string) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2 + 2);
        stringBuilder.append('\"');
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\"') {
                stringBuilder.append(c2);
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.append('\"').toString();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String quoteRemarkSQL(String string) {
        string = StringUtils.replaceAll(string, "*/", "++/");
        return StringUtils.replaceAll(string, "/*", "/++");
    }

    public static String pad(String string, int n2, String string2, boolean bl) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 < string.length()) {
            return string.substring(0, n2);
        }
        if (n2 == string.length()) {
            return string;
        }
        char c2 = string2 == null || string2.length() == 0 ? (char)' ' : (char)string2.charAt(0);
        StringBuilder stringBuilder = new StringBuilder(n2);
        n2 -= string.length();
        if (bl) {
            stringBuilder.append(string);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(c2);
        }
        if (!bl) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static char[] cloneCharArray(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        int n2 = cArray.length;
        if (n2 == 0) {
            return cArray;
        }
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, 0, cArray2, 0, n2);
        return cArray2;
    }

    public static String trim(String string, boolean bl, boolean bl2, String string2) {
        int n2;
        int n3;
        char c2;
        char c3 = c2 = string2 == null || string2.length() < 1 ? (char)' ' : (char)string2.charAt(0);
        if (bl) {
            n3 = string.length();
            for (n2 = 0; n2 < n3 && string.charAt(n2) == c2; ++n2) {
            }
            String string3 = string = n2 == 0 ? string : string.substring(n2);
        }
        if (bl2) {
            for (n2 = n3 = string.length() - 1; n2 >= 0 && string.charAt(n2) == c2; --n2) {
            }
            string = n2 == n3 ? string : string.substring(0, n2 + 1);
        }
        return string;
    }

    public static String cache(String string) {
        if (!SysProperties.OBJECT_CACHE) {
            return string;
        }
        if (string == null) {
            return string;
        }
        if (string.length() == 0) {
            return "";
        }
        int n2 = string.hashCode();
        String[] stringArray = StringUtils.a();
        if (stringArray != null) {
            int n3 = n2 & SysProperties.OBJECT_CACHE_SIZE - 1;
            String string2 = stringArray[n3];
            if (string2 != null && string.equals(string2)) {
                return string2;
            }
            stringArray[n3] = string;
        }
        return string;
    }

    public static String fromCacheOrNew(String string) {
        if (!SysProperties.OBJECT_CACHE) {
            return string;
        }
        if (string == null) {
            return string;
        }
        if (string.length() == 0) {
            return "";
        }
        int n2 = string.hashCode();
        String[] stringArray = StringUtils.a();
        int n3 = n2 & SysProperties.OBJECT_CACHE_SIZE - 1;
        if (stringArray == null) {
            return string;
        }
        String string2 = stringArray[n3];
        if (string2 != null && string.equals(string2)) {
            return string2;
        }
        stringArray[n3] = string = new String(string);
        return string;
    }

    public static void clearCache() {
        do = new SoftReference<Object>(null);
    }

    public static byte[] convertStringToBytes(String string) {
        int n2 = string.length();
        if (n2 % 2 != 0) {
            throw DbException.get(90003, string);
        }
        byte[] byArray = new byte[n2 /= 2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = (byte)(StringUtils.if(string, i2 + i2) << 4 | StringUtils.if(string, i2 + i2 + 1));
        }
        return byArray;
    }

    private static int if(String string, int n2) {
        char c2 = string.charAt(n2);
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        throw DbException.get(90004, string);
    }

    public static String convertBytesToString(byte[] byArray) {
        return StringUtils.convertBytesToString(byArray, byArray.length);
    }

    public static String convertBytesToString(byte[] byArray, int n2) {
        char[] cArray = new char[n2 + n2];
        char[] cArray2 = a;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byArray[i2] & 0xFF;
            cArray[i2 + i2] = cArray2[n3 >> 4];
            cArray[i2 + i2 + 1] = cArray2[n3 & 0xF];
        }
        return new String(cArray);
    }

    static {
        a = "0123456789abcdef".toCharArray();
    }
}

