/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.Socket;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.engine.SessionInterface;
import org.h2.message.DbException;
import org.h2.message.TraceSystem;
import org.h2.tools.SimpleResultSet;
import org.h2.util.DateTimeUtils;
import org.h2.util.ExactUTF8InputStreamReader;
import org.h2.util.IOUtils;
import org.h2.util.NetUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Transfer {
    private static final int try = 16384;
    private static final int new = 4660;
    private Socket do;
    private DataInputStream a;
    private DataOutputStream int;
    private SessionInterface byte;
    private boolean for;
    private int if;

    public Transfer(SessionInterface sessionInterface) {
        this.byte = sessionInterface;
    }

    public void setSocket(Socket socket) {
        this.do = socket;
    }

    public void init() throws IOException {
        this.a = new DataInputStream(new BufferedInputStream(this.do.getInputStream(), 16384));
        this.int = new DataOutputStream(new BufferedOutputStream(this.do.getOutputStream(), 16384));
    }

    public void flush() throws IOException {
        this.int.flush();
    }

    public Transfer writeBoolean(boolean bl) throws IOException {
        this.int.writeByte((byte)(bl ? 1 : 0));
        return this;
    }

    public boolean readBoolean() throws IOException {
        return this.a.readByte() == 1;
    }

    private Transfer a(byte by) throws IOException {
        this.int.writeByte(by);
        return this;
    }

    private byte if() throws IOException {
        return this.a.readByte();
    }

    public Transfer writeInt(int n2) throws IOException {
        this.int.writeInt(n2);
        return this;
    }

    public int readInt() throws IOException {
        return this.a.readInt();
    }

    public Transfer writeLong(long l2) throws IOException {
        this.int.writeLong(l2);
        return this;
    }

    public long readLong() throws IOException {
        return this.a.readLong();
    }

    private Transfer a(double d2) throws IOException {
        this.int.writeDouble(d2);
        return this;
    }

    private Transfer a(float f2) throws IOException {
        this.int.writeFloat(f2);
        return this;
    }

    private double a() throws IOException {
        return this.a.readDouble();
    }

    private float do() throws IOException {
        return this.a.readFloat();
    }

    public Transfer writeString(String string) throws IOException {
        if (string == null) {
            this.int.writeInt(-1);
        } else {
            int n2 = string.length();
            this.int.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.int.writeChar(string.charAt(i2));
            }
        }
        return this;
    }

    public String readString() throws IOException {
        int n2 = this.a.readInt();
        if (n2 == -1) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(this.a.readChar());
        }
        String string = stringBuilder.toString();
        string = StringUtils.cache(string);
        return string;
    }

    public Transfer writeBytes(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(byArray.length);
            this.int.write(byArray);
        }
        return this;
    }

    public byte[] readBytes() throws IOException {
        int n2 = this.readInt();
        if (n2 == -1) {
            return null;
        }
        byte[] byArray = Utils.newBytes(n2);
        this.a.readFully(byArray);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.do != null) {
            try {
                this.int.flush();
                if (this.do != null) {
                    this.do.close();
                }
            }
            catch (IOException iOException) {
                TraceSystem.traceThrowable(iOException);
            }
            finally {
                this.do = null;
            }
        }
    }

    public void writeValue(Value value) throws IOException {
        int n2 = value.getType();
        this.writeInt(n2);
        switch (n2) {
            case 0: {
                break;
            }
            case 12: 
            case 19: {
                this.writeBytes(value.getBytesNoCopy());
                break;
            }
            case 20: {
                ValueUuid valueUuid = (ValueUuid)value;
                this.writeLong(valueUuid.getHigh());
                this.writeLong(valueUuid.getLow());
                break;
            }
            case 1: {
                this.writeBoolean(value.getBoolean());
                break;
            }
            case 2: {
                this.a(value.getByte());
                break;
            }
            case 9: {
                if (this.if >= 7) {
                    this.writeLong(DateTimeUtils.getTimeLocal(value.getTimeNoCopy()));
                    break;
                }
                this.writeLong(value.getTimeNoCopy().getTime());
                break;
            }
            case 10: {
                if (this.if >= 7) {
                    this.writeLong(DateTimeUtils.getTimeLocal(value.getDateNoCopy()));
                    break;
                }
                this.writeLong(value.getDateNoCopy().getTime());
                break;
            }
            case 11: {
                Timestamp timestamp = value.getTimestampNoCopy();
                if (this.if >= 7) {
                    this.writeLong(DateTimeUtils.getTimeLocal(timestamp));
                } else {
                    this.writeLong(timestamp.getTime());
                }
                this.writeInt(timestamp.getNanos());
                break;
            }
            case 6: {
                this.writeString(value.getString());
                break;
            }
            case 7: {
                this.a(value.getDouble());
                break;
            }
            case 8: {
                this.a(value.getFloat());
                break;
            }
            case 4: {
                this.writeInt(value.getInt());
                break;
            }
            case 5: {
                this.writeLong(value.getLong());
                break;
            }
            case 3: {
                this.writeInt(value.getShort());
                break;
            }
            case 13: 
            case 14: 
            case 21: {
                this.writeString(value.getString());
                break;
            }
            case 15: {
                long l2 = value.getPrecision();
                if (l2 < 0L) {
                    throw DbException.get(90067, "length=" + l2);
                }
                this.writeLong(l2);
                long l3 = IOUtils.copyAndCloseInput(value.getInputStream(), this.int);
                if (l3 != l2) {
                    throw DbException.get(90067, "length:" + l2 + " written:" + l3);
                }
                this.writeInt(4660);
                break;
            }
            case 16: {
                long l4 = value.getPrecision();
                if (l4 < 0L) {
                    throw DbException.get(90067, "length=" + l4);
                }
                this.writeLong(l4);
                Reader reader = value.getReader();
                FilterOutputStream filterOutputStream = new FilterOutputStream(this.int){

                    public void flush() {
                    }
                };
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)filterOutputStream, "UTF8"));
                long l5 = IOUtils.copyAndCloseInput(reader, bufferedWriter);
                if (l5 != l4) {
                    throw DbException.get(90067, "length:" + l4 + " written:" + l5);
                }
                ((Writer)bufferedWriter).flush();
                this.writeInt(4660);
                break;
            }
            case 17: {
                Value[] valueArray = ((ValueArray)value).getList();
                this.writeInt(valueArray.length);
                for (Value value2 : valueArray) {
                    this.writeValue(value2);
                }
                break;
            }
            case 18: {
                try {
                    int n3;
                    ResultSet resultSet = ((ValueResultSet)value).getResultSet();
                    resultSet.beforeFirst();
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n4 = resultSetMetaData.getColumnCount();
                    this.writeInt(n4);
                    for (n3 = 0; n3 < n4; ++n3) {
                        this.writeString(resultSetMetaData.getColumnName(n3 + 1));
                        this.writeInt(resultSetMetaData.getColumnType(n3 + 1));
                        this.writeInt(resultSetMetaData.getPrecision(n3 + 1));
                        this.writeInt(resultSetMetaData.getScale(n3 + 1));
                    }
                    while (resultSet.next()) {
                        this.writeBoolean(true);
                        for (n3 = 0; n3 < n4; ++n3) {
                            int n5 = DataType.convertSQLTypeToValueType(resultSetMetaData.getColumnType(n3 + 1));
                            Value value3 = DataType.readValue(this.byte, resultSet, n3 + 1, n5);
                            this.writeValue(value3);
                        }
                    }
                    this.writeBoolean(false);
                    resultSet.beforeFirst();
                    break;
                }
                catch (SQLException sQLException) {
                    throw DbException.convertToIOException(sQLException);
                }
            }
            default: {
                throw DbException.get(90067, "type=" + n2);
            }
        }
    }

    public Value readValue() throws IOException {
        int n2 = this.readInt();
        switch (n2) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 12: {
                return ValueBytes.getNoCopy(this.readBytes());
            }
            case 20: {
                return ValueUuid.get(this.readLong(), this.readLong());
            }
            case 19: {
                return ValueJavaObject.getNoCopy(this.readBytes());
            }
            case 1: {
                return ValueBoolean.get(this.readBoolean());
            }
            case 2: {
                return ValueByte.get(this.if());
            }
            case 10: {
                if (this.if >= 7) {
                    return ValueDate.getNoCopy(new Date(DateTimeUtils.getTimeGMT(this.readLong())));
                }
                return ValueDate.getNoCopy(new Date(this.readLong()));
            }
            case 9: {
                if (this.if >= 7) {
                    return ValueTime.getNoCopy(new Time(DateTimeUtils.getTimeGMT(this.readLong())));
                }
                return ValueTime.getNoCopy(new Time(this.readLong()));
            }
            case 11: {
                if (this.if >= 7) {
                    Timestamp timestamp = new Timestamp(DateTimeUtils.getTimeGMT(this.readLong()));
                    timestamp.setNanos(this.readInt());
                    return ValueTimestamp.getNoCopy(timestamp);
                }
                Timestamp timestamp = new Timestamp(this.readLong());
                timestamp.setNanos(this.readInt());
                return ValueTimestamp.getNoCopy(timestamp);
            }
            case 6: {
                return ValueDecimal.get(new BigDecimal(this.readString()));
            }
            case 7: {
                return ValueDouble.get(this.a());
            }
            case 8: {
                return ValueFloat.get(this.do());
            }
            case 4: {
                return ValueInt.get(this.readInt());
            }
            case 5: {
                return ValueLong.get(this.readLong());
            }
            case 3: {
                return ValueShort.get((short)this.readInt());
            }
            case 13: {
                return ValueString.get(this.readString());
            }
            case 14: {
                return ValueStringIgnoreCase.get(this.readString());
            }
            case 21: {
                return ValueStringFixed.get(this.readString());
            }
            case 15: {
                long l2 = this.readLong();
                Value value = this.byte.getDataHandler().getLobStorage().createBlob(this.a, l2);
                int n3 = this.readInt();
                if (n3 != 4660) {
                    throw DbException.get(90067, "magic=" + n3);
                }
                return value;
            }
            case 16: {
                long l3 = this.readLong();
                Value value = this.byte.getDataHandler().getLobStorage().createClob(new ExactUTF8InputStreamReader(this.a), l3);
                int n4 = this.readInt();
                if (n4 != 4660) {
                    throw DbException.get(90067, "magic=" + n4);
                }
                return value;
            }
            case 17: {
                int n5 = this.readInt();
                Value[] valueArray = new Value[n5];
                for (int i2 = 0; i2 < n5; ++i2) {
                    valueArray[i2] = this.readValue();
                }
                return ValueArray.get(valueArray);
            }
            case 18: {
                SimpleResultSet simpleResultSet = new SimpleResultSet();
                int n6 = this.readInt();
                for (int i3 = 0; i3 < n6; ++i3) {
                    simpleResultSet.addColumn(this.readString(), this.readInt(), this.readInt(), this.readInt());
                }
                while (this.readBoolean()) {
                    Object[] objectArray = new Object[n6];
                    for (int i4 = 0; i4 < n6; ++i4) {
                        objectArray[i4] = this.readValue().getObject();
                    }
                    simpleResultSet.addRow(objectArray);
                }
                return ValueResultSet.get(simpleResultSet);
            }
        }
        throw DbException.get(90067, "type=" + n2);
    }

    public Socket getSocket() {
        return this.do;
    }

    public void setSession(SessionInterface sessionInterface) {
        this.byte = sessionInterface;
    }

    public void setSSL(boolean bl) {
        this.for = bl;
    }

    public Transfer openNewConnection() throws IOException {
        InetAddress inetAddress = this.do.getInetAddress();
        int n2 = this.do.getPort();
        Socket socket = NetUtils.createSocket(inetAddress, n2, this.for);
        Transfer transfer = new Transfer(null);
        transfer.setSocket(socket);
        transfer.setSSL(this.for);
        return transfer;
    }

    public void setVersion(int n2) {
        this.if = n2;
    }
}

