/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import org.h2.util.MathUtils;
import org.h2.util.StatementBuilder;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueArray
extends Value {
    private final Value[] C;
    private int D;

    private ValueArray(Value[] valueArray) {
        this.C = valueArray;
    }

    public static ValueArray get(Value[] valueArray) {
        return new ValueArray(valueArray);
    }

    public int hashCode() {
        if (this.D != 0) {
            return this.D;
        }
        int n2 = 1;
        for (Value value : this.C) {
            n2 = n2 * 31 + value.hashCode();
        }
        this.D = n2;
        return n2;
    }

    public Value[] getList() {
        return this.C;
    }

    public int getType() {
        return 17;
    }

    public long getPrecision() {
        return 0L;
    }

    public String getString() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        for (Value value : this.C) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(value.getString());
        }
        return statementBuilder.append(')').toString();
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueArray valueArray = (ValueArray)value;
        if (this.C == valueArray.C) {
            return 0;
        }
        int n2 = this.C.length;
        int n3 = valueArray.C.length;
        int n4 = Math.min(n2, n3);
        for (int i2 = 0; i2 < n4; ++i2) {
            Value value2 = this.C[i2];
            Value value3 = valueArray.C[i2];
            int n5 = value2.compareTo(value3, compareMode);
            if (n5 == 0) continue;
            return n5;
        }
        return n2 > n3 ? 1 : (n2 == n3 ? 0 : -1);
    }

    public Object getObject() {
        int n2 = this.C.length;
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = this.C[i2].getObject();
        }
        return objectArray;
    }

    public void set(PreparedStatement preparedStatement, int n2) {
        throw this.throwUnsupportedExceptionForType("PreparedStatement.set");
    }

    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        for (Value value : this.C) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(value.getSQL());
        }
        return statementBuilder.append(')').toString();
    }

    public String getTraceSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        for (Value value : this.C) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(value.getTraceSQL());
        }
        return statementBuilder.append(')').toString();
    }

    public int getDisplaySize() {
        long l2 = 0L;
        for (Value value : this.C) {
            l2 += (long)value.getDisplaySize();
        }
        return MathUtils.convertLongToInt(l2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ValueArray)) {
            return false;
        }
        ValueArray valueArray = (ValueArray)object;
        if (this.C == valueArray.C) {
            return true;
        }
        int n2 = this.C.length;
        if (n2 != valueArray.C.length) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.C[i2].equals(valueArray.C[i2])) continue;
            return false;
        }
        return true;
    }

    public int getMemory() {
        int n2 = 32;
        for (Value value : this.C) {
            n2 += value.getMemory() + 8;
        }
        return n2;
    }
}

