/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.util.MathUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ValueByte
extends Value {
    static final int PRECISION = 3;
    static final int DISPLAY_SIZE = 4;
    private final byte u;

    private ValueByte(byte by) {
        this.u = by;
    }

    public Value add(Value value) {
        ValueByte valueByte = (ValueByte)value;
        return this.if(this.u + valueByte.u);
    }

    private ValueByte if(int n2) {
        if (n2 < -128 || n2 > 127) {
            throw DbException.get(90110, DataType.getDataType((int)2).name);
        }
        return ValueByte.get((byte)n2);
    }

    public int getSignum() {
        return Integer.signum(this.u);
    }

    public Value negate() {
        return this.if(-this.u);
    }

    public Value subtract(Value value) {
        ValueByte valueByte = (ValueByte)value;
        return this.if(this.u - valueByte.u);
    }

    public Value multiply(Value value) {
        ValueByte valueByte = (ValueByte)value;
        return this.if(this.u * valueByte.u);
    }

    public Value divide(Value value) {
        ValueByte valueByte = (ValueByte)value;
        if (valueByte.u == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueByte.get((byte)(this.u / valueByte.u));
    }

    public String getSQL() {
        return this.getString();
    }

    public int getType() {
        return 2;
    }

    public byte getByte() {
        return this.u;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueByte valueByte = (ValueByte)value;
        return MathUtils.compareInt(this.u, valueByte.u);
    }

    public String getString() {
        return String.valueOf(this.u);
    }

    public long getPrecision() {
        return 3L;
    }

    public int hashCode() {
        return this.u;
    }

    public Object getObject() {
        return this.u;
    }

    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        preparedStatement.setByte(n2, this.u);
    }

    public static ValueByte get(byte by) {
        return (ValueByte)Value.cache(new ValueByte(by));
    }

    public int getDisplaySize() {
        return 4;
    }

    public boolean equals(Object object) {
        return object instanceof ValueByte && this.u == ((ValueByte)object).u;
    }
}

