/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueBytes
extends Value {
    private static final ValueBytes ac = new ValueBytes(Utils.EMPTY_BYTES);
    private final byte[] ab;
    private int ad;

    protected ValueBytes(byte[] byArray) {
        this.ab = byArray;
    }

    public static ValueBytes get(byte[] byArray) {
        if (byArray.length == 0) {
            return ac;
        }
        byArray = Utils.cloneByteArray(byArray);
        return ValueBytes.getNoCopy(byArray);
    }

    public static ValueBytes getNoCopy(byte[] byArray) {
        if (byArray.length == 0) {
            return ac;
        }
        ValueBytes valueBytes = new ValueBytes(byArray);
        if (byArray.length > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return valueBytes;
        }
        return (ValueBytes)Value.cache(valueBytes);
    }

    public int getType() {
        return 12;
    }

    public String getSQL() {
        return "X'" + this.getString() + "'";
    }

    public byte[] getBytesNoCopy() {
        return this.ab;
    }

    public byte[] getBytes() {
        return Utils.cloneByteArray(this.ab);
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        byte[] byArray = ((ValueBytes)value).ab;
        return Utils.compareNotNull(this.ab, byArray);
    }

    public String getString() {
        return StringUtils.convertBytesToString(this.ab);
    }

    public long getPrecision() {
        return this.ab.length;
    }

    public int hashCode() {
        if (this.ad == 0) {
            this.ad = Utils.getByteArrayHash(this.ab);
        }
        return this.ad;
    }

    public Object getObject() {
        return this.getBytes();
    }

    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        preparedStatement.setBytes(n2, this.ab);
    }

    public int getDisplaySize() {
        return MathUtils.convertLongToInt((long)this.ab.length * 2L);
    }

    public int getMemory() {
        return this.ab.length + 24;
    }

    public boolean equals(Object object) {
        return object instanceof ValueBytes && Utils.compareNotNull(this.ab, ((ValueBytes)object).ab) == 0;
    }
}

