/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.util.DateTimeUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueTimestamp;

public class ValueDate
extends Value {
    public static final int PRECISION = 8;
    static final int DISPLAY_SIZE = 10;
    private final Date v;

    private ValueDate(Date date) {
        this.v = date;
    }

    public static Date parseDate(String string) {
        return (Date)DateTimeUtils.parseDateTime(string, 10, 90009);
    }

    public Date getDate() {
        return (Date)this.v.clone();
    }

    public Date getDateNoCopy() {
        return this.v;
    }

    public String getSQL() {
        return "DATE '" + this.getString() + "'";
    }

    public int getType() {
        return 10;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueDate valueDate = (ValueDate)value;
        return Integer.signum(this.v.compareTo(valueDate.v));
    }

    public String getString() {
        int n2;
        String string = this.v.toString();
        long l2 = this.v.getTime();
        if (!(l2 >= ValueTimestamp.YEAR_ONE && l2 <= ValueTimestamp.YEAR_9999 || (n2 = DateTimeUtils.getDatePart(this.v, 1)) >= 1 && n2 <= 9999)) {
            string = n2 + string.substring(string.indexOf(45));
        }
        return string;
    }

    public long getPrecision() {
        return 8L;
    }

    public int hashCode() {
        return this.v.hashCode();
    }

    public Object getObject() {
        return this.getDate();
    }

    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        preparedStatement.setDate(n2, this.v);
    }

    public static ValueDate get(Date date) {
        date = DateTimeUtils.cloneAndNormalizeDate(date);
        return ValueDate.getNoCopy(date);
    }

    public static ValueDate getNoCopy(Date date) {
        return (ValueDate)Value.cache(new ValueDate(date));
    }

    public int getDisplaySize() {
        return 10;
    }

    public boolean equals(Object object) {
        return object instanceof ValueDate && this.v.equals(((ValueDate)object).v);
    }
}

