/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.util.MathUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ValueDecimal
extends Value {
    public static final Object ZERO = new ValueDecimal(BigDecimal.ZERO);
    public static final Object ONE = new ValueDecimal(BigDecimal.ONE);
    static final int DEFAULT_PRECISION = 65535;
    static final int DEFAULT_SCALE = Short.MAX_VALUE;
    static final int DEFAULT_DISPLAY_SIZE = 65535;
    private static final int new = 25;
    private final BigDecimal byte;
    private String int;
    private int try;

    private ValueDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            throw new IllegalArgumentException();
        }
        if (!SysProperties.ALLOW_BIG_DECIMAL_EXTENSIONS && !bigDecimal.getClass().equals(BigDecimal.class)) {
            throw DbException.get(90125, BigDecimal.class.getName(), bigDecimal.getClass().getName());
        }
        this.byte = bigDecimal;
    }

    public Value add(Value value) {
        ValueDecimal valueDecimal = (ValueDecimal)value;
        return ValueDecimal.get(this.byte.add(valueDecimal.byte));
    }

    public Value subtract(Value value) {
        ValueDecimal valueDecimal = (ValueDecimal)value;
        return ValueDecimal.get(this.byte.subtract(valueDecimal.byte));
    }

    public Value negate() {
        return ValueDecimal.get(this.byte.negate());
    }

    public Value multiply(Value value) {
        ValueDecimal valueDecimal = (ValueDecimal)value;
        return ValueDecimal.get(this.byte.multiply(valueDecimal.byte));
    }

    public Value divide(Value value) {
        ValueDecimal valueDecimal = (ValueDecimal)value;
        if (valueDecimal.byte.signum() == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        BigDecimal bigDecimal = this.byte.divide(valueDecimal.byte, this.byte.scale() + 25, 5);
        if (bigDecimal.signum() == 0) {
            bigDecimal = BigDecimal.ZERO;
        } else if (bigDecimal.scale() > 0 && !bigDecimal.unscaledValue().testBit(0)) {
            int n2;
            String string = bigDecimal.toString();
            for (n2 = string.length() - 1; n2 >= 0 && string.charAt(n2) == '0'; --n2) {
            }
            if (n2 < string.length() - 1) {
                string = string.substring(0, n2 + 1);
                bigDecimal = new BigDecimal(string);
            }
        }
        return ValueDecimal.get(bigDecimal);
    }

    public String getSQL() {
        return this.getString();
    }

    public int getType() {
        return 6;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueDecimal valueDecimal = (ValueDecimal)value;
        return this.byte.compareTo(valueDecimal.byte);
    }

    public int getSignum() {
        return this.byte.signum();
    }

    public BigDecimal getBigDecimal() {
        return this.byte;
    }

    public String getString() {
        if (this.int == null) {
            this.int = this.byte.toString();
        }
        return this.int;
    }

    public long getPrecision() {
        if (this.try == 0) {
            this.try = MathUtils.precision(this.byte);
        }
        return this.try;
    }

    public boolean checkPrecision(long l2) {
        if (l2 == 65535L) {
            return true;
        }
        return this.getPrecision() <= l2;
    }

    public int getScale() {
        return this.byte.scale();
    }

    public int hashCode() {
        return this.byte.hashCode();
    }

    public Object getObject() {
        return this.byte;
    }

    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        preparedStatement.setBigDecimal(n2, this.byte);
    }

    public Value convertScale(boolean bl, int n2) {
        if (this.byte.scale() == n2) {
            return this;
        }
        if ((bl || n2 >= Short.MAX_VALUE) && this.byte.scale() < n2) {
            return this;
        }
        BigDecimal bigDecimal = MathUtils.setScale(this.byte, n2);
        return ValueDecimal.get(bigDecimal);
    }

    public Value convertPrecision(long l2) {
        if (this.getPrecision() <= l2) {
            return this;
        }
        throw DbException.get(90039, "" + l2);
    }

    public static ValueDecimal get(BigDecimal bigDecimal) {
        if (BigDecimal.ZERO.equals(bigDecimal)) {
            return (ValueDecimal)ZERO;
        }
        if (BigDecimal.ONE.equals(bigDecimal)) {
            return (ValueDecimal)ONE;
        }
        return (ValueDecimal)Value.cache(new ValueDecimal(bigDecimal));
    }

    public int getDisplaySize() {
        return MathUtils.convertLongToInt(this.getPrecision() + 2L);
    }

    public boolean equals(Object object) {
        return object instanceof ValueDecimal && this.byte.equals(((ValueDecimal)object).byte);
    }

    public int getMemory() {
        return MathUtils.precision(this.byte) + 120;
    }
}

