/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueDouble
extends Value {
    public static final int PRECISION = 17;
    public static final int DISPLAY_SIZE = 24;
    private static final double y = 0.0;
    private static final double z = 1.0;
    private static final ValueDouble w = new ValueDouble(0.0);
    private static final ValueDouble x = new ValueDouble(1.0);
    private static final ValueDouble A = new ValueDouble(Double.NaN);
    private final double B;

    private ValueDouble(double d2) {
        this.B = d2;
    }

    public Value add(Value value) {
        ValueDouble valueDouble = (ValueDouble)value;
        return ValueDouble.get(this.B + valueDouble.B);
    }

    public Value subtract(Value value) {
        ValueDouble valueDouble = (ValueDouble)value;
        return ValueDouble.get(this.B - valueDouble.B);
    }

    public Value negate() {
        return ValueDouble.get(-this.B);
    }

    public Value multiply(Value value) {
        ValueDouble valueDouble = (ValueDouble)value;
        return ValueDouble.get(this.B * valueDouble.B);
    }

    public Value divide(Value value) {
        ValueDouble valueDouble = (ValueDouble)value;
        if (valueDouble.B == 0.0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueDouble.get(this.B / valueDouble.B);
    }

    public String getSQL() {
        if (this.B == Double.POSITIVE_INFINITY) {
            return "POWER(0, -1)";
        }
        if (this.B == Double.NEGATIVE_INFINITY) {
            return "(-POWER(0, -1))";
        }
        if (Double.isNaN(this.B)) {
            return "SQRT(-1)";
        }
        return this.getString();
    }

    public int getType() {
        return 7;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueDouble valueDouble = (ValueDouble)value;
        return Double.compare(this.B, valueDouble.B);
    }

    public int getSignum() {
        return this.B == 0.0 ? 0 : (this.B < 0.0 ? -1 : 1);
    }

    public double getDouble() {
        return this.B;
    }

    public String getString() {
        return String.valueOf(this.B);
    }

    public long getPrecision() {
        return 17L;
    }

    public int getScale() {
        return 0;
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.B);
        return (int)(l2 ^ l2 >> 32);
    }

    public Object getObject() {
        return this.B;
    }

    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        preparedStatement.setDouble(n2, this.B);
    }

    public static ValueDouble get(double d2) {
        if (0.0 == d2) {
            return w;
        }
        if (1.0 == d2) {
            return x;
        }
        if (Double.isNaN(d2)) {
            return A;
        }
        return (ValueDouble)Value.cache(new ValueDouble(d2));
    }

    public int getDisplaySize() {
        return 24;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ValueDouble)) {
            return false;
        }
        return this.compareSecure((ValueDouble)object, null) == 0;
    }
}

