/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ValueFloat
extends Value {
    static final int PRECISION = 7;
    static final int DISPLAY_SIZE = 15;
    private static final float long = 0.0f;
    private static final float else = 1.0f;
    private static final ValueFloat case = new ValueFloat(0.0f);
    private static final ValueFloat char = new ValueFloat(1.0f);
    private final float goto;

    private ValueFloat(float f2) {
        this.goto = f2;
    }

    public Value add(Value value) {
        ValueFloat valueFloat = (ValueFloat)value;
        return ValueFloat.get(this.goto + valueFloat.goto);
    }

    public Value subtract(Value value) {
        ValueFloat valueFloat = (ValueFloat)value;
        return ValueFloat.get(this.goto - valueFloat.goto);
    }

    public Value negate() {
        return ValueFloat.get(-this.goto);
    }

    public Value multiply(Value value) {
        ValueFloat valueFloat = (ValueFloat)value;
        return ValueFloat.get(this.goto * valueFloat.goto);
    }

    public Value divide(Value value) {
        ValueFloat valueFloat = (ValueFloat)value;
        if ((double)valueFloat.goto == 0.0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueFloat.get(this.goto / valueFloat.goto);
    }

    public String getSQL() {
        if (this.goto == Float.POSITIVE_INFINITY) {
            return "POWER(0, -1)";
        }
        if (this.goto == Float.NEGATIVE_INFINITY) {
            return "(-POWER(0, -1))";
        }
        if (Double.isNaN(this.goto)) {
            return "SQRT(-1)";
        }
        return this.getString();
    }

    public int getType() {
        return 8;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueFloat valueFloat = (ValueFloat)value;
        return Float.compare(this.goto, valueFloat.goto);
    }

    public int getSignum() {
        return this.goto == 0.0f ? 0 : (this.goto < 0.0f ? -1 : 1);
    }

    public float getFloat() {
        return this.goto;
    }

    public String getString() {
        return String.valueOf(this.goto);
    }

    public long getPrecision() {
        return 7L;
    }

    public int getScale() {
        return 0;
    }

    public int hashCode() {
        long l2 = Float.floatToIntBits(this.goto);
        return (int)(l2 ^ l2 >> 32);
    }

    public Object getObject() {
        return Float.valueOf(this.goto);
    }

    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        preparedStatement.setFloat(n2, this.goto);
    }

    public static ValueFloat get(float f2) {
        if (0.0f == f2) {
            return case;
        }
        if (1.0f == f2) {
            return char;
        }
        return (ValueFloat)Value.cache(new ValueFloat(f2));
    }

    public int getDisplaySize() {
        return 15;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ValueFloat)) {
            return false;
        }
        return this.compareSecure((ValueFloat)object, null) == 0;
    }
}

