/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.util.MathUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ValueInt
extends Value {
    public static final int PRECISION = 10;
    public static final int DISPLAY_SIZE = 11;
    private static final int j = 128;
    private static final int k = 256;
    private static final ValueInt[] h = new ValueInt[128];
    private static final ValueInt[] g = new ValueInt[256];
    private final int i;

    private ValueInt(int n2) {
        this.i = n2;
    }

    public static ValueInt get(int n2) {
        if (n2 >= 0 && n2 < 128) {
            return h[n2];
        }
        ValueInt valueInt = g[n2 & 0xFF];
        if (valueInt == null || valueInt.i != n2) {
            ValueInt.g[n2 & 0xFF] = valueInt = new ValueInt(n2);
        }
        return valueInt;
    }

    public Value add(Value value) {
        ValueInt valueInt = (ValueInt)value;
        return this.for((long)this.i + (long)valueInt.i);
    }

    private ValueInt for(long l2) {
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw DbException.get(90110, DataType.getDataType((int)4).name);
        }
        return ValueInt.get((int)l2);
    }

    public int getSignum() {
        return Integer.signum(this.i);
    }

    public Value negate() {
        return this.for(-((long)this.i));
    }

    public Value subtract(Value value) {
        ValueInt valueInt = (ValueInt)value;
        return this.for((long)this.i - (long)valueInt.i);
    }

    public Value multiply(Value value) {
        ValueInt valueInt = (ValueInt)value;
        return this.for((long)this.i * (long)valueInt.i);
    }

    public Value divide(Value value) {
        ValueInt valueInt = (ValueInt)value;
        if (valueInt.i == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueInt.get(this.i / valueInt.i);
    }

    public String getSQL() {
        return this.getString();
    }

    public int getType() {
        return 4;
    }

    public int getInt() {
        return this.i;
    }

    public long getLong() {
        return this.i;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueInt valueInt = (ValueInt)value;
        return MathUtils.compareInt(this.i, valueInt.i);
    }

    public String getString() {
        return String.valueOf(this.i);
    }

    public long getPrecision() {
        return 10L;
    }

    public int hashCode() {
        return this.i;
    }

    public Object getObject() {
        return this.i;
    }

    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        preparedStatement.setInt(n2, this.i);
    }

    public int getDisplaySize() {
        return 11;
    }

    public boolean equals(Object object) {
        return object instanceof ValueInt && this.i == ((ValueInt)object).i;
    }

    static {
        for (int i2 = 0; i2 < 128; ++i2) {
            ValueInt.h[i2] = new ValueInt(i2);
        }
    }
}

