/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.FileStoreOutputStream;
import org.h2.store.fs.FileSystem;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.SmallLRUCache;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ValueLob
extends Value {
    private static int Y;
    private final int W;
    private long V;
    private DataHandler aa;
    private int Q;
    private int X;
    private String T;
    private boolean P;
    private byte[] S;
    private int U;
    private boolean Z;
    private FileStore R;

    private ValueLob(int n2, DataHandler dataHandler, String string, int n3, int n4, boolean bl, long l2, boolean bl2) {
        this.W = n2;
        this.aa = dataHandler;
        this.T = string;
        this.Q = n3;
        this.X = n4;
        this.P = bl;
        this.V = l2;
        this.Z = bl2;
    }

    private ValueLob(int n2, byte[] byArray) {
        this.W = n2;
        this.S = byArray;
        if (byArray != null) {
            this.V = n2 == 15 ? (long)byArray.length : (long)this.getString().length();
        }
    }

    private static ValueLob a(ValueLob valueLob) {
        ValueLob valueLob2 = new ValueLob(valueLob.W, valueLob.aa, valueLob.T, valueLob.Q, valueLob.X, valueLob.P, valueLob.V, valueLob.Z);
        valueLob2.S = valueLob.S;
        valueLob2.U = valueLob.U;
        return valueLob2;
    }

    public static ValueLob createSmallLob(int n2, byte[] byArray) {
        return new ValueLob(n2, byArray);
    }

    private static String a(DataHandler dataHandler, int n2, int n3) {
        if (SysProperties.CHECK && n2 == 0 && n3 == 0) {
            DbException.throwInternalError("0 LOB");
        }
        String string = n2 < 0 ? ".temp" : ".t" + n2;
        return ValueLob.a(dataHandler.getDatabasePath(), n3) + string + ".lob.db";
    }

    public static ValueLob open(int n2, DataHandler dataHandler, int n3, int n4, long l2, boolean bl) {
        String string = ValueLob.a(dataHandler, n3, n4);
        return new ValueLob(n2, dataHandler, string, n3, n4, true, l2, bl);
    }

    public static ValueLob createClob(Reader reader, long l2, DataHandler dataHandler) {
        try {
            char[] cArray;
            Object object;
            int n2;
            if (dataHandler == null) {
                String string = IOUtils.readStringAndClose(reader, (int)l2);
                return ValueLob.createSmallLob(16, StringUtils.utf8Encode(string));
            }
            boolean bl = dataHandler.getLobCompressionAlgorithm(16) != null;
            long l3 = Long.MAX_VALUE;
            if (l2 >= 0L && l2 < l3) {
                l3 = l2;
            }
            if ((n2 = ValueLob.if(dataHandler, bl, l3)) >= Integer.MAX_VALUE) {
                object = IOUtils.readStringAndClose(reader, -1);
                cArray = ((String)object).toCharArray();
                n2 = cArray.length;
            } else {
                cArray = new char[n2];
                int n3 = n2 = (n2 = IOUtils.readFully(reader, cArray, n2)) < 0 ? 0 : n2;
            }
            if (n2 <= dataHandler.getMaxLengthInplaceLob()) {
                object = StringUtils.utf8Encode(new String(cArray, 0, n2));
                return ValueLob.createSmallLob(16, (byte[])object);
            }
            object = new ValueLob(16, null);
            super.if(cArray, n2, reader, l3, dataHandler);
            return object;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    private static int if(DataHandler dataHandler, boolean bl, long l2) {
        long l3;
        long l4;
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        if ((l4 = (long)dataHandler.getMaxLengthInplaceLob()) >= Integer.MAX_VALUE) {
            l4 = l2;
        }
        long l5 = l3 = bl ? 131072L : 4096L;
        if (l3 < l2 && l3 <= l4) {
            l3 = Math.min(l2, l4 + 1L);
            l3 = MathUtils.roundUpLong(l3, 4096L);
        }
        l3 = Math.min(l2, l3);
        if ((l3 = (long)MathUtils.convertLongToInt(l3)) < 0L) {
            l3 = Integer.MAX_VALUE;
        }
        return (int)l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void if(char[] cArray, int n2, Reader reader, long l2, DataHandler dataHandler) {
        try {
            FileStoreOutputStream fileStoreOutputStream = this.do(dataHandler);
            boolean bl = dataHandler.getLobCompressionAlgorithm(16) != null;
            try {
                do {
                    this.V += (long)n2;
                    byte[] byArray = StringUtils.utf8Encode(new String(cArray, 0, n2));
                    fileStoreOutputStream.write(byArray, 0, byArray.length);
                    if ((l2 -= (long)n2) <= 0L) {
                        break;
                    }
                    n2 = ValueLob.if(dataHandler, bl, l2);
                } while ((n2 = IOUtils.readFully(reader, cArray, n2)) > 0);
            }
            finally {
                fileStoreOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    private static String a(String string, int n2) {
        int n3 = n2 % SysProperties.LOB_FILES_PER_DIRECTORY;
        String string2 = n3 > 0 ? File.separator + n2 : "";
        n2 /= SysProperties.LOB_FILES_PER_DIRECTORY;
        while (n2 > 0) {
            n3 = n2 % SysProperties.LOB_FILES_PER_DIRECTORY;
            string2 = File.separator + n3 + ".lobs.db" + string2;
            n2 /= SysProperties.LOB_FILES_PER_DIRECTORY;
        }
        string2 = IOUtils.normalize(string + ".lobs.db" + string2);
        return string2;
    }

    private int if(DataHandler dataHandler) {
        int n2;
        String string;
        String string2 = dataHandler.getDatabasePath();
        int n3 = 0;
        int n4 = SysProperties.LOB_FILES_PER_DIRECTORY;
        while (true) {
            string = ValueLob.a(string2, n3);
            String[] stringArray = this.if(dataHandler, string);
            int n5 = 0;
            boolean[] blArray = new boolean[n4];
            String[] stringArray2 = stringArray;
            int n6 = stringArray2.length;
            for (int i2 = 0; i2 < n6; ++i2) {
                int n7;
                String string3 = stringArray2[i2];
                if (!string3.endsWith(".db")) continue;
                string3 = IOUtils.getFileName(string3);
                String string4 = string3.substring(0, string3.indexOf(46));
                try {
                    n7 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    n7 = -1;
                }
                if (n7 <= 0) continue;
                ++n5;
                blArray[n7 % n4] = true;
            }
            n2 = -1;
            if (n5 < n4) {
                for (n6 = 1; n6 < n4; ++n6) {
                    if (blArray[n6]) continue;
                    n2 = n6;
                    break;
                }
            }
            if (n2 > 0) break;
            if (n3 > Integer.MAX_VALUE / n4) {
                n3 = 0;
                Y = MathUtils.randomInt(n4 - 1) * n4;
                continue;
            }
            n6 = Y++ / (n4 - 1) + 1;
            n3 *= n4;
            n3 += n6 * n4;
        }
        this.do(dataHandler, string);
        return n3 += n2;
    }

    public static void resetDirCounter() {
        Y = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void do(DataHandler dataHandler, String string) {
        SmallLRUCache smallLRUCache = dataHandler.getLobFileListCache();
        if (smallLRUCache != null) {
            SmallLRUCache smallLRUCache2 = smallLRUCache;
            synchronized (smallLRUCache2) {
                smallLRUCache.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] if(DataHandler dataHandler, String string) {
        String[] stringArray;
        SmallLRUCache smallLRUCache = dataHandler.getLobFileListCache();
        if (smallLRUCache == null) {
            stringArray = IOUtils.listFiles(string);
        } else {
            SmallLRUCache smallLRUCache2 = smallLRUCache;
            synchronized (smallLRUCache2) {
                stringArray = (String[])smallLRUCache.get(string);
                if (stringArray == null) {
                    stringArray = IOUtils.listFiles(string);
                    smallLRUCache.put(string, stringArray);
                }
            }
        }
        return stringArray;
    }

    public static ValueLob createBlob(InputStream inputStream, long l2, DataHandler dataHandler) {
        try {
            byte[] byArray;
            int n2;
            boolean bl;
            if (dataHandler == null) {
                byte[] byArray2 = IOUtils.readBytesAndClose(inputStream, (int)l2);
                return ValueLob.createSmallLob(15, byArray2);
            }
            long l3 = Long.MAX_VALUE;
            boolean bl2 = bl = dataHandler.getLobCompressionAlgorithm(15) != null;
            if (l2 >= 0L && l2 < l3) {
                l3 = l2;
            }
            if ((n2 = ValueLob.if(dataHandler, bl, l3)) >= Integer.MAX_VALUE) {
                byArray = IOUtils.readBytesAndClose(inputStream, -1);
                n2 = byArray.length;
            } else {
                byArray = Utils.newBytes(n2);
                n2 = IOUtils.readFully(inputStream, byArray, 0, n2);
            }
            if (n2 <= dataHandler.getMaxLengthInplaceLob()) {
                byte[] byArray3 = Utils.newBytes(n2);
                System.arraycopy(byArray, 0, byArray3, 0, n2);
                return ValueLob.createSmallLob(15, byArray3);
            }
            ValueLob valueLob = new ValueLob(15, null);
            valueLob.if(byArray, n2, inputStream, l3, dataHandler);
            return valueLob;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileStoreOutputStream do(DataHandler dataHandler) {
        this.aa = dataHandler;
        this.Q = 0;
        this.P = false;
        this.V = 0L;
        this.S = null;
        this.U = 0;
        String string = dataHandler.getLobCompressionAlgorithm(this.W);
        this.Z = string != null;
        Object object = dataHandler;
        synchronized (object) {
            this.X = this.if(dataHandler);
            this.T = ValueLob.a(dataHandler.getDatabasePath(), this.X) + ".temp.db";
            this.R = dataHandler.openFile(this.T, "rw", false);
            this.R.autoDelete();
        }
        object = new FileStoreOutputStream(this.R, dataHandler, string);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void if(byte[] byArray, int n2, InputStream inputStream, long l2, DataHandler dataHandler) {
        try {
            FileStoreOutputStream fileStoreOutputStream = this.do(dataHandler);
            boolean bl = dataHandler.getLobCompressionAlgorithm(15) != null;
            try {
                do {
                    this.V += (long)n2;
                    fileStoreOutputStream.write(byArray, 0, n2);
                    if ((l2 -= (long)n2) <= 0L) {
                        break;
                    }
                    n2 = ValueLob.if(dataHandler, bl, l2);
                } while ((n2 = IOUtils.readFully(inputStream, byArray, 0, n2)) > 0);
            }
            finally {
                fileStoreOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    public Value convertTo(int n2) {
        if (n2 == this.W) {
            return this;
        }
        if (n2 == 16) {
            ValueLob valueLob = ValueLob.createClob(this.getReader(), -1L, this.aa);
            return valueLob;
        }
        if (n2 == 15) {
            ValueLob valueLob = ValueLob.createBlob(this.getInputStream(), -1L, this.aa);
            return valueLob;
        }
        return super.convertTo(n2);
    }

    public boolean isLinked() {
        return this.P;
    }

    public String getFileName() {
        return this.T;
    }

    public void close() {
        if (this.T != null) {
            if (this.R != null) {
                this.R.stopAutoDelete();
            }
            ValueLob.for(this.aa, this.T);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlink() {
        if (this.P && this.T != null) {
            DataHandler dataHandler = this.aa;
            synchronized (dataHandler) {
                String string = ValueLob.a(this.aa, -1, this.X);
                ValueLob.for(this.aa, string);
                ValueLob.a(this.aa, this.T, string);
                this.R = FileStore.open(this.aa, string, "rw");
                this.R.autoDelete();
                this.R.closeSilently();
                this.T = string;
                this.P = false;
            }
        }
    }

    public Value link(DataHandler dataHandler, int n2) {
        if (this.T == null) {
            this.Q = n2;
            return this;
        }
        if (this.P) {
            ValueLob valueLob = ValueLob.a(this);
            valueLob.X = this.if(dataHandler);
            valueLob.Q = n2;
            String string = ValueLob.a(dataHandler, valueLob.Q, valueLob.X);
            this.if(dataHandler, this.T, string);
            valueLob.T = string;
            valueLob.P = true;
            return valueLob;
        }
        if (!this.P) {
            this.Q = n2;
            String string = ValueLob.a(dataHandler, this.Q, this.X);
            if (this.R != null) {
                this.R.stopAutoDelete();
                this.R = null;
            }
            ValueLob.a(dataHandler, this.T, string);
            this.T = string;
            this.P = true;
        }
        return this;
    }

    public int getTableId() {
        return this.Q;
    }

    public int getObjectId() {
        return this.X;
    }

    public int getType() {
        return this.W;
    }

    public long getPrecision() {
        return this.V;
    }

    public String getString() {
        int n2 = this.V > Integer.MAX_VALUE || this.V == 0L ? Integer.MAX_VALUE : (int)this.V;
        try {
            if (this.W == 16) {
                if (this.S != null) {
                    return StringUtils.utf8Decode(this.S);
                }
                return IOUtils.readStringAndClose(this.getReader(), n2);
            }
            byte[] byArray = this.S != null ? this.S : IOUtils.readBytesAndClose(this.getInputStream(), n2);
            return StringUtils.convertBytesToString(byArray);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.T);
        }
    }

    public byte[] getBytes() {
        if (this.W == 16) {
            return super.getBytes();
        }
        byte[] byArray = this.getBytesNoCopy();
        return Utils.cloneByteArray(byArray);
    }

    public byte[] getBytesNoCopy() {
        if (this.W == 16) {
            return super.getBytesNoCopy();
        }
        if (this.S != null) {
            return this.S;
        }
        try {
            return IOUtils.readBytesAndClose(this.getInputStream(), Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.T);
        }
    }

    public int hashCode() {
        if (this.U == 0) {
            if (this.V > 4096L) {
                return (int)(this.V ^ this.V >>> 32);
            }
            this.U = this.W == 16 ? this.getString().hashCode() : Utils.getByteArrayHash(this.getBytes());
        }
        return this.U;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        if (this.W == 16) {
            return Integer.signum(this.getString().compareTo(value.getString()));
        }
        byte[] byArray = value.getBytesNoCopy();
        return Utils.compareNotNull(this.getBytes(), byArray);
    }

    public Object getObject() {
        if (this.W == 16) {
            return this.getReader();
        }
        return this.getInputStream();
    }

    public Reader getReader() {
        return IOUtils.getBufferedReader(this.getInputStream());
    }

    public InputStream getInputStream() {
        if (this.T == null) {
            return new ByteArrayInputStream(this.S);
        }
        FileStore fileStore = this.aa.openFile(this.T, "r", true);
        boolean bl = SysProperties.lobCloseBetweenReads;
        return new BufferedInputStream(new FileStoreInputStream(fileStore, this.aa, this.Z, bl), 4096);
    }

    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        long l2 = this.getPrecision();
        if (l2 > Integer.MAX_VALUE || l2 <= 0L) {
            l2 = -1L;
        }
        if (this.W == 15) {
            preparedStatement.setBinaryStream(n2, this.getInputStream(), (int)l2);
        } else {
            preparedStatement.setCharacterStream(n2, this.getReader(), (int)l2);
        }
    }

    public String getSQL() {
        if (this.W == 16) {
            String string = this.getString();
            return StringUtils.quoteStringSQL(string);
        }
        byte[] byArray = this.getBytes();
        String string = StringUtils.convertBytesToString(byArray);
        return "X'" + string + "'";
    }

    public String getTraceSQL() {
        if (this.S != null && this.getPrecision() <= SysProperties.MAX_TRACE_DATA_LENGTH) {
            return this.getSQL();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.W == 16) {
            stringBuilder.append("SPACE(").append(this.getPrecision());
        } else {
            stringBuilder.append("CAST(REPEAT('00', ").append(this.getPrecision()).append(") AS BINARY");
        }
        stringBuilder.append(" /* ").append(this.T).append(" */)");
        return stringBuilder.toString();
    }

    public byte[] getSmall() {
        return this.S;
    }

    public int getDisplaySize() {
        return MathUtils.convertLongToInt(this.getPrecision());
    }

    public boolean equals(Object object) {
        return object instanceof ValueLob && this.compareSecure((Value)object, null) == 0;
    }

    public void convertToFileIfRequired(DataHandler dataHandler) {
        if (this.S != null && this.S.length > dataHandler.getMaxLengthInplaceLob()) {
            boolean bl = dataHandler.getLobCompressionAlgorithm(this.W) != null;
            int n2 = ValueLob.if(dataHandler, bl, Long.MAX_VALUE);
            int n3 = this.Q;
            if (this.W == 15) {
                this.if(Utils.newBytes(n2), 0, this.getInputStream(), Long.MAX_VALUE, dataHandler);
            } else {
                this.if(new char[n2], 0, this.getReader(), Long.MAX_VALUE, dataHandler);
            }
            Value value = this.link(dataHandler, n3);
            if (SysProperties.CHECK && value != this) {
                DbException.throwInternalError();
            }
        }
    }

    public static void removeAllForTable(DataHandler dataHandler, int n2) {
        String string = ValueLob.a(dataHandler.getDatabasePath(), 0);
        ValueLob.a(dataHandler, string, n2);
    }

    private static void a(DataHandler dataHandler, String string, int n2) {
        for (String string2 : IOUtils.listFiles(string)) {
            if (IOUtils.isDirectory(string2)) {
                ValueLob.a(dataHandler, string2, n2);
                continue;
            }
            if (!string2.endsWith(".t" + n2 + ".lob.db")) continue;
            ValueLob.for(dataHandler, string2);
        }
    }

    public boolean useCompression() {
        return this.Z;
    }

    public boolean isFileBased() {
        return this.T != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void for(DataHandler dataHandler, String string) {
        Object object = dataHandler.getLobSyncObject();
        synchronized (object) {
            IOUtils.delete(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void a(DataHandler dataHandler, String string, String string2) {
        Object object = dataHandler.getLobSyncObject();
        synchronized (object) {
            IOUtils.rename(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void if(DataHandler dataHandler, String string, String string2) {
        Object object = dataHandler.getLobSyncObject();
        synchronized (object) {
            FileSystem.getInstance(string).copy(string, string2);
        }
    }

    public void setFileName(String string, boolean bl) {
        this.T = string;
        this.P = bl;
    }

    public int getMemory() {
        if (this.S != null) {
            return this.S.length + 104;
        }
        return 140;
    }

    public ValueLob copyToTemp() {
        ValueLob valueLob = this.W == 16 ? ValueLob.createClob(this.getReader(), this.V, this.aa) : ValueLob.createBlob(this.getInputStream(), this.V, this.aa);
        return valueLob;
    }
}

