/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.FileStoreOutputStream;
import org.h2.store.LobStorage;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueLobDb
extends Value
implements Value.ValueClob,
Value.ValueBlob {
    private final int M;
    private long L;
    private int G;
    private int K;
    private LobStorage O;
    private long F;
    private byte[] J;
    private DataHandler N;
    private FileStore H;
    private String I;

    private ValueLobDb(int n2, LobStorage lobStorage, String string, int n3, long l2, long l3) {
        this.M = n2;
        this.O = lobStorage;
        this.I = string;
        this.G = n3;
        this.F = l2;
        this.L = l3;
    }

    private ValueLobDb(int n2, byte[] byArray, long l2) {
        this.M = n2;
        this.J = byArray;
        this.L = l2;
    }

    public static ValueLobDb create(int n2, LobStorage lobStorage, String string, int n3, long l2, long l3) {
        return new ValueLobDb(n2, lobStorage, string, n3, l2, l3);
    }

    public static ValueLobDb createSmallLob(int n2, byte[] byArray, long l2) {
        return new ValueLobDb(n2, byArray, l2);
    }

    public Value convertTo(int n2) {
        if (n2 == this.M) {
            return this;
        }
        if (n2 == 16) {
            if (this.O != null) {
                Value value = this.O.createClob(this.getReader(), -1L);
                return value;
            }
        } else if (n2 == 15 && this.O != null) {
            Value value = this.O.createBlob(this.getInputStream(), -1L);
            return value;
        }
        return super.convertTo(n2);
    }

    public boolean isLinked() {
        return this.G != -1;
    }

    public void close() {
        if (this.I != null) {
            if (this.H != null) {
                this.H.stopAutoDelete();
            }
            ValueLobDb.a(this.N, this.I);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void a(DataHandler dataHandler, String string) {
        Object object = dataHandler.getLobSyncObject();
        synchronized (object) {
            IOUtils.delete(string);
        }
    }

    public void unlink() {
        if (this.J == null && this.G != -1) {
            this.O.setTable(this.F, -1);
            this.G = -1;
        }
    }

    public Value link(DataHandler dataHandler, int n2) {
        if (this.J == null) {
            if (n2 != this.G) {
                if (this.G != -2) {
                    return this.O.copyLob(this.M, this.F, n2, this.getPrecision());
                }
                this.O.setTable(this.F, n2);
                this.G = n2;
            }
        } else if (this.J.length > dataHandler.getMaxLengthInplaceLob()) {
            LobStorage lobStorage = dataHandler.getLobStorage();
            Value value = this.M == 15 ? lobStorage.createBlob(this.getInputStream(), this.getPrecision()) : lobStorage.createClob(this.getReader(), this.getPrecision());
            return value.link(dataHandler, n2);
        }
        return this;
    }

    public int getTableId() {
        return this.G;
    }

    public int getType() {
        return this.M;
    }

    public long getPrecision() {
        return this.L;
    }

    public String getString() {
        int n2 = this.L > Integer.MAX_VALUE || this.L == 0L ? Integer.MAX_VALUE : (int)this.L;
        try {
            if (this.M == 16) {
                if (this.J != null) {
                    return StringUtils.utf8Decode(this.J);
                }
                return IOUtils.readStringAndClose(this.getReader(), n2);
            }
            byte[] byArray = this.J != null ? this.J : IOUtils.readBytesAndClose(this.getInputStream(), n2);
            return StringUtils.convertBytesToString(byArray);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.toString());
        }
    }

    public byte[] getBytes() {
        if (this.M == 16) {
            return super.getBytes();
        }
        byte[] byArray = this.getBytesNoCopy();
        return Utils.cloneByteArray(byArray);
    }

    public byte[] getBytesNoCopy() {
        if (this.M == 16) {
            return super.getBytesNoCopy();
        }
        if (this.J != null) {
            return this.J;
        }
        try {
            return IOUtils.readBytesAndClose(this.getInputStream(), Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.toString());
        }
    }

    public int hashCode() {
        if (this.K == 0) {
            if (this.L > 4096L) {
                return (int)(this.L ^ this.L >>> 32);
            }
            this.K = this.M == 16 ? this.getString().hashCode() : Utils.getByteArrayHash(this.getBytes());
        }
        return this.K;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        Object object;
        if (value instanceof ValueLobDb) {
            object = (ValueLobDb)value;
            if (value == this) {
                return 0;
            }
            if (this.F == ((ValueLobDb)object).F && this.J == null && ((ValueLobDb)object).J == null) {
                return 0;
            }
        }
        if (this.M == 16) {
            return Integer.signum(this.getString().compareTo(value.getString()));
        }
        object = value.getBytesNoCopy();
        return Utils.compareNotNull(this.getBytes(), (byte[])object);
    }

    public Object getObject() {
        if (this.M == 16) {
            return this.getReader();
        }
        return this.getInputStream();
    }

    public Reader getReader() {
        return IOUtils.getBufferedReader(this.getInputStream());
    }

    public InputStream getInputStream() {
        if (this.J != null) {
            return new ByteArrayInputStream(this.J);
        }
        if (this.I != null) {
            FileStore fileStore = this.N.openFile(this.I, "r", true);
            boolean bl = SysProperties.lobCloseBetweenReads;
            return new BufferedInputStream(new FileStoreInputStream(fileStore, this.N, false, bl), 4096);
        }
        try {
            return this.O.getInputStream(this.F);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.toString());
        }
    }

    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        long l2 = this.getPrecision();
        if (l2 > Integer.MAX_VALUE || l2 <= 0L) {
            l2 = -1L;
        }
        if (this.M == 15) {
            preparedStatement.setBinaryStream(n2, this.getInputStream(), (int)l2);
        } else {
            preparedStatement.setCharacterStream(n2, this.getReader(), (int)l2);
        }
    }

    public String getSQL() {
        if (this.M == 16) {
            String string = this.getString();
            return StringUtils.quoteStringSQL(string);
        }
        byte[] byArray = this.getBytes();
        String string = StringUtils.convertBytesToString(byArray);
        return "X'" + string + "'";
    }

    public String getTraceSQL() {
        if (this.J != null && this.getPrecision() <= SysProperties.MAX_TRACE_DATA_LENGTH) {
            return this.getSQL();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.M == 16) {
            stringBuilder.append("SPACE(").append(this.getPrecision());
        } else {
            stringBuilder.append("CAST(REPEAT('00', ").append(this.getPrecision()).append(") AS BINARY");
        }
        stringBuilder.append(" /* table: ").append(this.G).append(" id: ").append(this.F).append(" */)");
        return stringBuilder.toString();
    }

    public byte[] getSmall() {
        return this.J;
    }

    public int getDisplaySize() {
        return MathUtils.convertLongToInt(this.getPrecision());
    }

    public boolean equals(Object object) {
        return object instanceof ValueLobDb && this.compareSecure((Value)object, null) == 0;
    }

    public boolean isFileBased() {
        return this.J == null;
    }

    public int getMemory() {
        if (this.J != null) {
            return this.J.length + 104;
        }
        return 140;
    }

    public ValueLobDb copyToTemp() {
        return this;
    }

    public long getLobId() {
        return this.F;
    }

    public void setPrecision(long l2) {
        this.L = l2;
    }

    public String toString() {
        return "lob: " + this.I + " table: " + this.G + " id: " + this.F;
    }

    public static ValueLobDb createTempClob(Reader reader, long l2, DataHandler dataHandler) {
        try {
            char[] cArray;
            Object object;
            int n2;
            boolean bl = dataHandler.getLobCompressionAlgorithm(16) != null;
            long l3 = Long.MAX_VALUE;
            if (l2 >= 0L && l2 < l3) {
                l3 = l2;
            }
            if ((n2 = ValueLobDb.a(dataHandler, bl, l3)) >= Integer.MAX_VALUE) {
                object = IOUtils.readStringAndClose(reader, -1);
                cArray = ((String)object).toCharArray();
                n2 = cArray.length;
            } else {
                cArray = new char[n2];
                int n3 = n2 = (n2 = IOUtils.readFully(reader, cArray, n2)) < 0 ? 0 : n2;
            }
            if (n2 <= dataHandler.getMaxLengthInplaceLob()) {
                object = StringUtils.utf8Encode(new String(cArray, 0, n2));
                return ValueLobDb.createSmallLob(16, (byte[])object, n2);
            }
            object = new ValueLobDb(16, null, 0L);
            super.a(cArray, n2, reader, l3, dataHandler);
            return object;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    public static ValueLobDb createTempBlob(InputStream inputStream, long l2, DataHandler dataHandler) {
        try {
            byte[] byArray;
            int n2;
            boolean bl;
            long l3 = Long.MAX_VALUE;
            boolean bl2 = bl = dataHandler.getLobCompressionAlgorithm(15) != null;
            if (l2 >= 0L && l2 < l3) {
                l3 = l2;
            }
            if ((n2 = ValueLobDb.a(dataHandler, bl, l3)) >= Integer.MAX_VALUE) {
                byArray = IOUtils.readBytesAndClose(inputStream, -1);
                n2 = byArray.length;
            } else {
                byArray = Utils.newBytes(n2);
                n2 = IOUtils.readFully(inputStream, byArray, 0, n2);
            }
            if (n2 <= dataHandler.getMaxLengthInplaceLob()) {
                byte[] byArray2 = Utils.newBytes(n2);
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                return ValueLobDb.createSmallLob(15, byArray2, byArray2.length);
            }
            ValueLobDb valueLobDb = new ValueLobDb(15, null, 0L);
            valueLobDb.a(byArray, n2, inputStream, l3, dataHandler);
            return valueLobDb;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(char[] cArray, int n2, Reader reader, long l2, DataHandler dataHandler) {
        try {
            FileStoreOutputStream fileStoreOutputStream = this.a(dataHandler);
            try {
                do {
                    this.L += (long)n2;
                    byte[] byArray = StringUtils.utf8Encode(new String(cArray, 0, n2));
                    fileStoreOutputStream.write(byArray, 0, byArray.length);
                    if ((l2 -= (long)n2) <= 0L) {
                        break;
                    }
                    n2 = ValueLobDb.a(dataHandler, false, l2);
                } while ((n2 = IOUtils.readFully(reader, cArray, n2)) > 0);
            }
            finally {
                fileStoreOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(byte[] byArray, int n2, InputStream inputStream, long l2, DataHandler dataHandler) {
        try {
            FileStoreOutputStream fileStoreOutputStream = this.a(dataHandler);
            boolean bl = dataHandler.getLobCompressionAlgorithm(15) != null;
            try {
                do {
                    this.L += (long)n2;
                    fileStoreOutputStream.write(byArray, 0, n2);
                    if ((l2 -= (long)n2) <= 0L) {
                        break;
                    }
                    n2 = ValueLobDb.a(dataHandler, bl, l2);
                } while ((n2 = IOUtils.readFully(inputStream, byArray, 0, n2)) > 0);
            }
            finally {
                fileStoreOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    private FileStoreOutputStream a(DataHandler dataHandler) {
        Object object;
        this.L = 0L;
        this.N = dataHandler;
        this.O = dataHandler.getLobStorage();
        this.J = null;
        try {
            object = dataHandler.getDatabasePath();
            if (((String)object).length() == 0) {
                object = SysProperties.PREFIX_TEMP_FILE;
            }
            this.I = IOUtils.createTempFile((String)object, ".temp.db", true, true);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
        this.H = dataHandler.openFile(this.I, "rw", false);
        this.H.autoDelete();
        object = new FileStoreOutputStream(this.H, null, null);
        return object;
    }

    private static int a(DataHandler dataHandler, boolean bl, long l2) {
        long l3;
        long l4;
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        if ((l4 = (long)dataHandler.getMaxLengthInplaceLob()) >= Integer.MAX_VALUE) {
            l4 = l2;
        }
        long l5 = l3 = bl ? 131072L : 4096L;
        if (l3 < l2 && l3 <= l4) {
            l3 = Math.min(l2, l4 + 1L);
            l3 = MathUtils.roundUpLong(l3, 4096L);
        }
        l3 = Math.min(l2, l3);
        if ((l3 = (long)MathUtils.convertLongToInt(l3)) < 0L) {
            l3 = Integer.MAX_VALUE;
        }
        return (int)l3;
    }
}

