/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.util.MathUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;

public class ValueShort
extends Value {
    static final int PRECISION = 5;
    static final int DISPLAY_SIZE = 6;
    private final short t;

    private ValueShort(short s) {
        this.t = s;
    }

    public Value add(Value value) {
        ValueShort valueShort = (ValueShort)value;
        return this.a(this.t + valueShort.t);
    }

    private ValueShort a(int n2) {
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw DbException.get(90110, DataType.getDataType((int)3).name);
        }
        return ValueShort.get((short)n2);
    }

    public int getSignum() {
        return Integer.signum(this.t);
    }

    public Value negate() {
        return this.a(-this.t);
    }

    public Value subtract(Value value) {
        ValueShort valueShort = (ValueShort)value;
        return this.a(this.t - valueShort.t);
    }

    public Value multiply(Value value) {
        ValueShort valueShort = (ValueShort)value;
        return this.a(this.t * valueShort.t);
    }

    public Value divide(Value value) {
        ValueShort valueShort = (ValueShort)value;
        if (valueShort.t == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueShort.get((short)(this.t / valueShort.t));
    }

    public String getSQL() {
        return this.getString();
    }

    public int getType() {
        return 3;
    }

    public short getShort() {
        return this.t;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueShort valueShort = (ValueShort)value;
        return MathUtils.compareInt(this.t, valueShort.t);
    }

    public String getString() {
        return String.valueOf(this.t);
    }

    public long getPrecision() {
        return 5L;
    }

    public int hashCode() {
        return this.t;
    }

    public Object getObject() {
        return this.t;
    }

    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        preparedStatement.setShort(n2, this.t);
    }

    public static ValueShort get(short s) {
        return (ValueShort)Value.cache(new ValueShort(s));
    }

    public int getDisplaySize() {
        return 6;
    }

    public boolean equals(Object object) {
        return object instanceof ValueShort && this.t == ((ValueShort)object).t;
    }
}

