/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import org.h2.util.DateTimeUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ValueTime
extends Value {
    public static final int PRECISION = 6;
    static final int DISPLAY_SIZE = 8;
    private final Time for;

    private ValueTime(Time time) {
        this.for = time;
    }

    public static Time parseTime(String string) {
        return (Time)DateTimeUtils.parseDateTime(string, 9, 90010);
    }

    public Time getTime() {
        return (Time)this.for.clone();
    }

    public Time getTimeNoCopy() {
        return this.for;
    }

    public String getSQL() {
        return "TIME '" + this.getString() + "'";
    }

    public int getType() {
        return 9;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueTime valueTime = (ValueTime)value;
        return Integer.signum(this.for.compareTo(valueTime.for));
    }

    public String getString() {
        return this.for.toString();
    }

    public long getPrecision() {
        return 6L;
    }

    public int hashCode() {
        return this.for.hashCode();
    }

    public Object getObject() {
        return this.getTime();
    }

    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        preparedStatement.setTime(n2, this.for);
    }

    public static ValueTime get(Time time) {
        time = DateTimeUtils.cloneAndNormalizeTime(time);
        return ValueTime.getNoCopy(time);
    }

    public static ValueTime getNoCopy(Time time) {
        return (ValueTime)Value.cache(new ValueTime(time));
    }

    public int getDisplaySize() {
        return 8;
    }

    public boolean equals(Object object) {
        return object instanceof ValueTime && this.for.equals(((ValueTime)object).for);
    }

    public Value add(Value value) {
        Time time = new Time(this.for.getTime() + value.getTime().getTime());
        return ValueTime.get(time);
    }

    public Value subtract(Value value) {
        Time time = new Time(this.for.getTime() - value.getTime().getTime());
        return ValueTime.get(time);
    }

    public Value multiply(Value value) {
        long l2 = ValueTime.get(new Time(0L)).getDate().getTime();
        long l3 = this.for.getTime() - l2;
        l3 = (long)((double)l3 * value.getDouble()) + l2;
        return ValueTime.get(new Time(l3));
    }

    public Value divide(Value value) {
        long l2 = ValueTime.get(new Time(0L)).getDate().getTime();
        long l3 = this.for.getTime() - l2;
        l3 = (long)((double)l3 / value.getDouble()) + l2;
        return ValueTime.get(new Time(l3));
    }
}

