/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.MathUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueTime;

public class ValueTimestamp
extends Value {
    public static final int PRECISION = 23;
    static final int DISPLAY_SIZE = 23;
    static final int DEFAULT_SCALE = 10;
    static final long YEAR_ONE = Date.valueOf("0001-01-02").getTime();
    static final long YEAR_9999 = Date.valueOf("9999-12-20").getTime();
    private final Timestamp c;

    private ValueTimestamp(Timestamp timestamp) {
        this.c = timestamp;
    }

    public Timestamp getTimestamp() {
        return (Timestamp)this.c.clone();
    }

    public Timestamp getTimestampNoCopy() {
        return this.c;
    }

    public String getSQL() {
        return "TIMESTAMP '" + this.getString() + "'";
    }

    public static Timestamp parseTimestamp(String string) {
        return (Timestamp)DateTimeUtils.parseDateTime(string, 11, 90011);
    }

    public int getType() {
        return 11;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueTimestamp valueTimestamp = (ValueTimestamp)value;
        return Integer.signum(this.c.compareTo(valueTimestamp.c));
    }

    public String getString() {
        int n2;
        String string = this.c.toString();
        long l2 = this.c.getTime();
        if (l2 < YEAR_ONE && (n2 = DateTimeUtils.getDatePart(this.c, 1)) < 1) {
            string = n2 + string.substring(string.indexOf(45));
        }
        return string;
    }

    public long getPrecision() {
        return 23L;
    }

    public int getScale() {
        return 10;
    }

    public int hashCode() {
        return this.c.hashCode();
    }

    public Object getObject() {
        return this.getTimestamp();
    }

    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        preparedStatement.setTimestamp(n2, this.c);
    }

    public static ValueTimestamp get(Timestamp timestamp) {
        timestamp = (Timestamp)timestamp.clone();
        return ValueTimestamp.getNoCopy(timestamp);
    }

    public static ValueTimestamp getNoCopy(Timestamp timestamp) {
        return (ValueTimestamp)Value.cache(new ValueTimestamp(timestamp));
    }

    public Value convertScale(boolean bl, int n2) {
        if (n2 < 0 || n2 > 10) {
            throw DbException.getInvalidValueException("scale", n2);
        }
        int n3 = this.c.getNanos();
        BigDecimal bigDecimal = BigDecimal.valueOf(n3);
        bigDecimal = bigDecimal.movePointLeft(9);
        bigDecimal = MathUtils.setScale(bigDecimal, n2);
        int n4 = (bigDecimal = bigDecimal.movePointRight(9)).intValue();
        if (n4 == n3) {
            return this;
        }
        long l2 = this.c.getTime();
        while (n4 >= 1000000000) {
            l2 += 1000L;
            n4 -= 1000000000;
        }
        Timestamp timestamp = new Timestamp(l2);
        timestamp.setNanos(n4);
        return ValueTimestamp.getNoCopy(timestamp);
    }

    public int getDisplaySize() {
        return 23;
    }

    public boolean equals(Object object) {
        return object instanceof ValueTimestamp && this.c.equals(((ValueTimestamp)object).c);
    }

    public Value add(Value value) {
        long l2 = ValueTime.get(new Time(0L)).getDate().getTime();
        long l3 = this.c.getTime() - l2 + value.getTimestamp().getTime();
        Timestamp timestamp = new Timestamp(l3);
        return ValueTimestamp.get(timestamp);
    }

    public Value subtract(Value value) {
        long l2 = ValueTime.get(new Time(0L)).getDate().getTime();
        long l3 = this.c.getTime() + l2 - value.getTimestamp().getTime();
        Timestamp timestamp = new Timestamp(l3);
        return ValueTimestamp.get(timestamp);
    }
}

