/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueUuid
extends Value {
    private static final int s = 16;
    private static final int q = 36;
    private final long r;
    private final long p;

    private ValueUuid(long l2, long l3) {
        this.r = l2;
        this.p = l3;
    }

    public int hashCode() {
        return (int)(this.r >>> 32 ^ this.r ^ this.p >>> 32 ^ this.p);
    }

    public static ValueUuid getNewRandom() {
        long l2 = MathUtils.secureRandomLong();
        long l3 = MathUtils.secureRandomLong();
        l2 = l2 & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        l3 = l3 & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new ValueUuid(l2, l3);
    }

    public static ValueUuid get(byte[] byArray) {
        if (byArray.length < 16) {
            return ValueUuid.get(StringUtils.convertBytesToString(byArray));
        }
        long l2 = Utils.readLong(byArray, 0);
        long l3 = Utils.readLong(byArray, 8);
        return (ValueUuid)Value.cache(new ValueUuid(l2, l3));
    }

    public static ValueUuid get(long l2, long l3) {
        return (ValueUuid)Value.cache(new ValueUuid(l2, l3));
    }

    public static ValueUuid get(String string) {
        long l2 = 0L;
        long l3 = 0L;
        int n2 = 0;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '0' && c2 <= '9') {
                l2 = l2 << 4 | (long)(c2 - 48);
            } else if (c2 >= 'a' && c2 <= 'f') {
                l2 = l2 << 4 | (long)(c2 - 97 + 10);
            } else {
                if (c2 == '-' || c2 < 'A' || c2 > 'F') continue;
                l2 = l2 << 4 | (long)(c2 - 65 + 10);
            }
            if (n2++ != 15) continue;
            l3 = l2;
            l2 = 0L;
        }
        return (ValueUuid)Value.cache(new ValueUuid(l3, l2));
    }

    public String getSQL() {
        return StringUtils.quoteStringSQL(this.getString());
    }

    public int getType() {
        return 20;
    }

    public long getPrecision() {
        return 16L;
    }

    private void a(StringBuilder stringBuilder, long l2, int n2) {
        for (int i2 = n2 * 8 - 4; i2 >= 0; i2 -= 8) {
            stringBuilder.append(Integer.toHexString((int)(l2 >> i2) & 0xF)).append(Integer.toHexString((int)(l2 >> i2 - 4) & 0xF));
        }
    }

    public String getString() {
        StringBuilder stringBuilder = new StringBuilder(36);
        this.a(stringBuilder, this.r >> 32, 4);
        stringBuilder.append('-');
        this.a(stringBuilder, this.r >> 16, 2);
        stringBuilder.append('-');
        this.a(stringBuilder, this.r, 2);
        stringBuilder.append('-');
        this.a(stringBuilder, this.p >> 48, 2);
        stringBuilder.append('-');
        this.a(stringBuilder, this.p, 6);
        return stringBuilder.toString();
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        if (value == this) {
            return 0;
        }
        ValueUuid valueUuid = (ValueUuid)value;
        if (this.r == valueUuid.r) {
            return MathUtils.compareLong(this.p, valueUuid.p);
        }
        return this.r > valueUuid.r ? 1 : -1;
    }

    public boolean equals(Object object) {
        return object instanceof ValueUuid && this.compareSecure((Value)object, null) == 0;
    }

    public Object getObject() {
        return new UUID(this.r, this.p);
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[16];
        for (int i2 = 0; i2 < 8; ++i2) {
            byArray[i2] = (byte)(this.r >> 8 * (7 - i2) & 0xFFL);
            byArray[8 + i2] = (byte)(this.p >> 8 * (7 - i2) & 0xFFL);
        }
        return byArray;
    }

    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        preparedStatement.setBytes(n2, this.getBytes());
    }

    public long getHigh() {
        return this.r;
    }

    public long getLow() {
        return this.p;
    }

    public int getDisplaySize() {
        return 36;
    }
}

