/*
 * Decompiled with CFR 0.152.
 */
package xBaseJ;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import xBaseJ.DBF;
import xBaseJ.Field;
import xBaseJ.Util;
import xBaseJ.xBaseJException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DateField
extends Field {
    private static final long if = 1L;
    private Calendar a;

    protected Object clone() throws CloneNotSupportedException {
        DateField dateField = (DateField)super.clone();
        dateField.Name = new String(this.Name);
        dateField.Length = 8;
        return dateField;
    }

    protected DateField(String string, ByteBuffer byteBuffer) throws xBaseJException {
        super.setField(string, 8, byteBuffer);
    }

    public DateField(String string) throws IOException, xBaseJException {
        super.setField(string, 8, null);
        this.put("");
    }

    private DateField() throws xBaseJException {
        this.Length = 8;
        this.buffer = new byte[this.Length];
        this.put("");
    }

    public char type() {
        return 'D';
    }

    public char getType() {
        return 'D';
    }

    public void put(String string) throws xBaseJException {
        int n2;
        if (!Util.dontTrimFields()) {
            string = string.trim();
        }
        boolean bl = true;
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (string.charAt(n2) == ' ') continue;
            bl = false;
        }
        int n3 = 32;
        if (string.length() == 0 || bl) {
            for (n2 = 0; n2 < 8; ++n2) {
                this.buffer[n2] = n3;
            }
            return;
        }
        if (string.length() != 8) {
            throw new xBaseJException("Invalid length for date Field");
        }
        for (n2 = 0; n2 < 8; ++n2) {
            if (Character.isDigit(string.charAt(n2))) continue;
            throw new xBaseJException("Invalid format for date Field, " + string + " non numeric at position " + n2);
        }
        int n4 = Integer.parseInt(string.substring(0, 4));
        int n5 = Integer.parseInt(string.substring(4, 6));
        if (n5 < 1 || n5 > 12) {
            throw new xBaseJException("Invalid format for date Field (month) " + string);
        }
        int n6 = Integer.parseInt(string.substring(6, 8));
        if (n6 < 1) {
            throw new xBaseJException("Invalid format for date Field (day) " + string);
        }
        int[] nArray = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (n4 == 2000 || n4 % 4 == 0 && n4 % 100 != 0) {
            nArray[2] = nArray[2] + 1;
        }
        if (n6 > nArray[n5]) {
            throw new xBaseJException("Invalid format for date Field, number of days > days in month");
        }
        super.put(string);
    }

    public void put(Date date) throws xBaseJException {
        this.a.setTime(date);
        this.put(this.a);
    }

    public void put(Calendar calendar) throws xBaseJException {
        super.put(String.valueOf(calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5)));
    }

    public void put(long l2) throws xBaseJException {
        this.put(Long.toString(l2));
    }

    public int compareTo(DateField dateField) {
        return this.get().compareTo(dateField.get());
    }

    public int compareTo(Calendar calendar) throws xBaseJException {
        DateField dateField = new DateField();
        dateField.put(calendar);
        return this.compareTo(dateField);
    }

    public Calendar getCalendar() throws xBaseJException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, Integer.parseInt(this.get(1)));
        calendar.set(2, Integer.parseInt(this.get(2)) - 1);
        calendar.set(5, Integer.parseInt(this.get(5)));
        return calendar;
    }

    public String get(int n2) throws xBaseJException {
        switch (n2) {
            case 1: {
                return new String(this.buffer, 0, 4);
            }
            case 2: {
                return new String(this.buffer, 4, 2);
            }
            case 5: {
                return new String(this.buffer, 6, 2);
            }
        }
        throw new xBaseJException("Field type invalid");
    }

    public void set(int n2, int n3) throws xBaseJException {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        switch (n2) {
            case 1: {
                byte[] byArray;
                numberFormat.setMinimumIntegerDigits(4);
                numberFormat.setMaximumIntegerDigits(4);
                String string = numberFormat.format(n3);
                try {
                    byArray = string.getBytes(DBF.encodedType);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray = string.getBytes();
                }
                this.buffer[0] = byArray[0];
                this.buffer[1] = byArray[1];
                this.buffer[2] = byArray[2];
                this.buffer[3] = byArray[3];
                break;
            }
            case 2: {
                if (n3 < 1 || n3 > 12) {
                    throw new xBaseJException("Month value out of range");
                }
                numberFormat.setMinimumIntegerDigits(2);
                numberFormat.setMaximumIntegerDigits(2);
                String string = numberFormat.format(n3);
                byte[] byArray = string.getBytes();
                this.buffer[4] = byArray[0];
                this.buffer[5] = byArray[1];
                break;
            }
            case 5: {
                if (n3 < 1 || n3 > 31) {
                    throw new xBaseJException("Day value out of range");
                }
                numberFormat.setMinimumIntegerDigits(2);
                numberFormat.setMaximumIntegerDigits(2);
                String string = numberFormat.format(n3);
                byte[] byArray = string.getBytes();
                this.buffer[6] = byArray[0];
                this.buffer[7] = byArray[1];
                break;
            }
            default: {
                throw new xBaseJException("Field type invalid");
            }
        }
    }
}

