/*
 * Decompiled with CFR 0.152.
 */
package xBaseJ;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import xBaseJ.DBF;
import xBaseJ.Util;
import xBaseJ.xBaseJException;

public abstract class Field
implements Cloneable,
Externalizable {
    protected String Name;
    protected int Length = 0;
    protected byte[] buffer;
    protected boolean Deleted;
    protected ByteBuffer bytebuffer;
    protected long myoffset;
    public static String otherValidCharacters = null;

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.Name = objectInput.readUTF();
        this.Length = objectInput.readInt();
        objectInput.readFully(this.buffer);
        this.Deleted = objectInput.readBoolean();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.Name);
        objectOutput.writeInt(this.Length);
        objectOutput.write(this.buffer);
        objectOutput.writeBoolean(this.Deleted);
    }

    protected Object clone() throws CloneNotSupportedException {
        Field field = (Field)super.clone();
        field.Name = new String(this.Name);
        field.Length = this.Length;
        return field;
    }

    private void a(String string) throws xBaseJException {
        if (otherValidCharacters == null) {
            try {
                otherValidCharacters = Util.getxBaseJProperty("otherValidCharactersInFieldNames");
            }
            catch (IOException iOException) {
                otherValidCharacters = "";
            }
            if (otherValidCharacters == null) {
                otherValidCharacters = "";
            }
        }
        if (string == null) {
            throw new xBaseJException("Missing field name");
        }
        if (string.length() == 0) {
            throw new xBaseJException("Missing field name");
        }
        if (string.length() > 10) {
            throw new xBaseJException("Invalid field name " + string);
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (Character.isLetter(string.charAt(i2)) || Character.isDigit(string.charAt(i2)) || string.charAt(i2) == '_' || otherValidCharacters.indexOf(string.charAt(i2)) > -1) continue;
            throw new xBaseJException("Invalid field name " + string + ", character invalid at " + i2);
        }
    }

    protected Field() {
        int n2 = this.Length == 0 ? 1 : this.Length;
        this.buffer = new byte[n2];
        this.buffer[0] = 32;
    }

    protected void setField(String string, int n2, ByteBuffer byteBuffer) throws xBaseJException {
        this.Name = string.trim();
        this.a(this.Name);
        this.Length = n2;
        this.setBuffer(byteBuffer);
    }

    protected void setBuffer(ByteBuffer byteBuffer) {
        this.bytebuffer = byteBuffer;
        this.setBufferSpace();
    }

    protected void setBufferSpace() {
        this.buffer = new byte[this.Length];
    }

    public String name() {
        return this.Name;
    }

    public String getName() {
        return this.Name;
    }

    public int length() {
        return this.Length;
    }

    public int getLength() {
        return this.Length;
    }

    public char type() throws xBaseJException {
        throw new xBaseJException("Undefined field");
    }

    public char getType() throws xBaseJException {
        throw new xBaseJException("Undefined field");
    }

    public int decPoint() {
        return 0;
    }

    public int getDecimalPositionCount() {
        return 0;
    }

    protected void read() throws IOException, xBaseJException {
        this.bytebuffer.get(this.buffer);
    }

    public String get() {
        String string;
        int n2;
        for (n2 = 0; n2 < this.Length && this.buffer[n2] != 0; ++n2) {
        }
        if (n2 == 0) {
            return "";
        }
        try {
            string = new String(this.buffer, 0, n2, DBF.encodedType);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(this.buffer, 0, n2);
        }
        return string;
    }

    public byte[] getBytes() {
        return this.buffer;
    }

    protected void write() throws IOException, xBaseJException {
        this.bytebuffer.put(this.buffer);
    }

    protected void update() throws IOException, xBaseJException {
        this.bytebuffer.put(this.buffer);
    }

    public void put(String string) throws xBaseJException {
        byte[] byArray;
        if (string.length() > this.Length) {
            throw new xBaseJException("Field length too long");
        }
        int n2 = Math.min(string.length(), this.Length);
        try {
            byArray = string.getBytes(DBF.encodedType);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        for (n2 = 0; n2 < byArray.length; ++n2) {
            this.buffer[n2] = byArray[n2];
        }
        for (n2 = string.length(); n2 < this.Length; ++n2) {
            this.buffer[n2] = Util.fieldFilledWithSpaces() ? 32 : 0;
        }
    }

    public void put(byte[] byArray) throws xBaseJException {
        int n2;
        if (byArray.length > this.Length) {
            throw new xBaseJException("Field length too long");
        }
        for (n2 = 0; n2 < byArray.length; ++n2) {
            this.buffer[n2] = byArray[n2];
        }
        while (n2 < this.Length) {
            this.buffer[n2] = Util.fieldFilledWithSpaces() ? 32 : 0;
            ++n2;
        }
    }
}

