/*
 * Decompiled with CFR 0.152.
 */
package com.org.facade;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.org.bd.Conexao;
import com.org.bd.DBFUtil;
import com.org.beans.RegiaoSaude;
import com.org.beans.RegiaoSaudePQAVS;
import com.org.beans.UFCoap;
import com.org.beans.UFPQAVS;
import com.org.facade.SessionFacade;
import com.org.model.classes.Agravo;
import com.org.model.classes.DBF;
import com.org.model.classes.agravos.AidsTaxaCrianca;
import com.org.model.classes.agravos.AutoctoneMalariaPactuacao;
import com.org.model.classes.agravos.DengueLetalidadeGrave;
import com.org.model.classes.agravos.ExantematicaOportunoAdequadamente;
import com.org.model.classes.agravos.Hanseniase;
import com.org.model.classes.agravos.HanseniaseCoorteCuraPactuacao;
import com.org.model.classes.agravos.HepatiteBC;
import com.org.model.classes.agravos.Oportunidade;
import com.org.model.classes.agravos.OportunidadePQAVS;
import com.org.model.classes.agravos.OportunidadePQAVSPactuacao;
import com.org.model.classes.agravos.PFA15anos;
import com.org.model.classes.agravos.Regularidade;
import com.org.model.classes.agravos.SemEpidPQAVS;
import com.org.model.classes.agravos.ViolenciaAgravo;
import com.org.model.classes.agravos.oportunidade.OportunidadeAgravoCOAP;
import com.org.model.classes.agravos.oportunidade.OportunidadeAgravoPQAVS;
import com.org.negocio.Configuracao;
import com.org.negocio.Util;
import com.org.service.OportunidadeCOAPService;
import com.org.service.OportunidadePQAVSService;
import com.org.service.OportunidadePQAVSServicePactuacao;
import com.org.service.RecebimentoLoteService;
import com.org.service.SemEpidPQAVSService;
import com.org.util.SinanUtil;
import com.org.view.AidsIndicadorCriancaPactuacao;
import com.org.view.AutoctonesMalariaPactuacao;
import com.org.view.Completitude;
import com.org.view.ContatosExaminadosHanseniasePactuacao;
import com.org.view.ContatosExaminadosTuberculosePactuacao;
import com.org.view.DengueLetalidade;
import com.org.view.ExantematicaOportuno;
import com.org.view.HanseniaseCoorte;
import com.org.view.HepatiteB;
import com.org.view.Master;
import com.org.view.OportunidadeCOAP;
import com.org.view.OportunidadeMalariaPactuacao;
import com.org.view.PreenchimentoOcupacaoTrabalhadorPactuacao;
import com.org.view.RecebimentoLote;
import com.org.view.SaudeTrabalhador;
import com.org.view.SemanaEpidemiologicaPactuacao;
import com.org.view.SifilisCongenitaIncidencia;
import com.org.view.SifilisCongenitaIncidenciaPactuacao;
import com.org.view.TuberculoseCoorte;
import com.org.view.Violencia;
import com.org.view.hanseniaseListagem;
import java.awt.Frame;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.view.JasperViewer;

public class SessionFacadeImpl
extends SwingWorker<Void, Agravo>
implements SessionFacade,
EventListener {
    private static boolean dbf;
    private static String nomeDbf;
    private String uf;
    private String municipio;
    private String regional;
    private String relatorio;
    private JProgressBar jprogress;
    private JProgressBar jprogressGeral;
    private boolean exportarDbf;
    private List beans;
    private Agravo agravo;
    private String dataInicio;
    private String dataFim;
    private JasperViewer viewer;
    private String versao = SinanUtil.getVersaoSinanRelatorios();
    private Map parametros;
    private boolean brasil;
    private boolean temOpcaoTodasUFs = true;
    private boolean todosMunicipios;
    private String dataAvaliacao;
    private String anoAvaliado;
    private String dtInicioAvaliacao;
    private String dtFimAvaliacao;
    private String nomeAgravo;
    private boolean temListagem;
    private boolean auxiliar;
    private String dtInicioTrasnf;
    private String dtFimTransf;
    private String dtInicioReceb;
    private String dtFimReceb;

    private String formataSemana(String semana) {
        if (Integer.parseInt(semana) < 10) {
            return "0" + semana;
        }
        return semana;
    }

    public Map populaSemana(Map parametros) {
        int semanaInicio = Integer.parseInt(parametros.get("parSemanaInicial").toString());
        int semanaFim = Integer.parseInt(parametros.get("parSemanaFinal").toString());
        String semanas = "";
        if (parametros.get("parAnoInicial").toString().equals(parametros.get("parAnoFinal").toString())) {
            for (int i = semanaInicio; i <= semanaFim; ++i) {
                semanas = semanas + "'" + parametros.get("parAnoInicial").toString() + this.formataSemana(String.valueOf(i)) + "'";
                if (i >= semanaFim) continue;
                semanas = semanas + ",";
            }
        } else {
            int i;
            for (i = semanaInicio; i <= 53; ++i) {
                semanas = semanas + "'" + parametros.get("parAnoInicial").toString() + this.formataSemana(String.valueOf(i)) + "'";
                if (i >= 53) continue;
                semanas = semanas + ",";
            }
            for (i = 1; i <= semanaFim; ++i) {
                semanas = semanas + "'" + parametros.get("parAnoInicial").toString() + this.formataSemana(String.valueOf(i)) + "'";
                if (i >= semanaFim) continue;
                semanas = semanas + ",";
            }
        }
        parametros.put("parDataInicio", semanas);
        parametros.put("f", "1");
        return parametros;
    }

    @Override
    public void geraRelatorio(String uf, String municipio) {
        Util util = new Util();
        Conexao con = util.conectarSiceb();
        JRBeanArrayDataSource jrds = null;
        Connection conexao = null;
        if (!SessionFacadeImpl.isDbf()) {
            con.conect();
            conexao = con.getC();
        }
        this.agravo.setColunas(this.agravo.getColunas());
        this.agravo.setBarraStatus(this.jprogress);
        this.agravo.setBarraStatusGeral(this.jprogressGeral);
        if (this.parametros == null) {
            this.parametros = new HashMap();
        }
        this.parametros.putAll(this.agravo.getParametros());
        this.parametros.put("parConfig", "");
        this.parametros.put("parVersao", this.getVersao());
        this.parametros.put("municipios", "nao");
        this.parametros.put("CABECALHO1", "Rep\u00fablica Federativa do Brasil - Minist\u00e9rio da Sa\u00fade");
        this.parametros.put("CABECALHO2", "Sistema de Informa\u00e7\u00e3o de Agravos de Notifica\u00e7\u00e3o - Sinan");
        this.parametros.put("RODAPE1", "SINAN Relat\u00f3rios - Vers\u00e3o " + SinanUtil.getVersaoSinanRelatorios());
        Date data = new Date();
        SimpleDateFormat formatador = new SimpleDateFormat("dd/MM/yyyy");
        this.parametros.put("parDataAtual", formatador.format(data));
        if (this.relatorio.equals("DengueLetalidadeGrave")) {
            this.parametros.put("parPeriodo", "de ano " + this.parametros.get("parAnoInicial").toString() + " semana " + this.parametros.get("parSemanaInicial").toString() + " \na ano " + this.parametros.get("parAnoFinal").toString() + " semana " + this.parametros.get("parSemanaFinal").toString());
            this.parametros = this.agravo.populaSemana(this.parametros);
        }
        if (this.relatorio.equals("SaudeTrabalhador") && this.parametros.get("parDiscriminarPorAgravo").toString().equals("true")) {
            this.parametros.put("parTituloLocal", "Agravo");
        }
        try {
            Object oportunidadePQAVSService;
            Object bean;
            ArrayList<OportunidadeAgravoPQAVS> listaBean;
            List<Object> listaUF;
            ArrayList<RegiaoSaudePQAVS> listaRegiaoSaude;
            JasperPrint impressao = null;
            if (uf.equals("Brasil") || uf.equals("TODAS")) {
                if (municipio.equals("TODOS")) {
                    this.parametros.put("municipios", "sim");
                }
                this.parametros.put("parUf", "brasil");
                if (this.relatorio.equals("AutoctonesMalariaPactuacao") && uf.equals("TODAS")) {
                    this.parametros.put("parUf", "TODAS");
                }
                this.parametros.put("parSgUf", uf);
                this.agravo.getTaxaEstado(conexao, this.parametros);
                this.beans = this.agravo.getBeanMunicipios(conexao, this.parametros);
                this.parametros.put("parCompletitude", this.agravo.getTextoCompletitude() + " " + this.agravo.getPercentualCompletitude());
            } else {
                this.parametros.put("parSgUf", uf);
                this.parametros.put("parUf", String.valueOf(this.getCodigoUf(uf)));
                if (this.parametros.get("parRegiaoSaude") != null && this.parametros.get("parRegiaoSaude") != "") {
                    this.parametros.put("parCodRegiaoSaude", this.getCodRegiaoSaude(this.parametros.get("parRegiaoSaude").toString(), uf));
                    this.parametros.put("parNomeRegiao", this.getRegional());
                }
                if (municipio.equals("TODOS") || municipio.equals("-- Selecione --")) {
                    if (this.regional == null) {
                        this.regional = "-- Selecione --";
                    }
                    if (municipio.equals("-- Selecione --") && (this.regional.equals("-- Selecione --") || this.regional.equals("TODAS"))) {
                        this.parametros.put("nivelAgregacao", "UF");
                        this.parametros.put("taxaEstadual", this.agravo.getTaxaEstado(conexao, this.parametros));
                        this.parametros.put("parCompletitude", this.agravo.getCompletitude(conexao, this.parametros));
                    } else {
                        this.parametros.put("nivelAgregacao", "UF");
                        this.parametros.put("parNomeMunicipio", municipio);
                        this.parametros.put("parNomeRegional", this.getRegional());
                        this.parametros.put("parCodRegional", this.getCodRegional(this.getRegional(), uf, this.relatorio));
                        this.parametros.put("municipios", "sim");
                        this.parametros.put("taxaEstadual", this.agravo.getTaxaEstado(conexao, this.parametros));
                        this.parametros.put("parCompletitude", this.agravo.getCompletitude(conexao, this.parametros));
                    }
                    this.beans = this.agravo.getBeansEstadoEspecifico(conexao, this.parametros);
                } else {
                    this.parametros.put("nivelAgregacao", "Municipio");
                    this.parametros.put("parNomeMunicipio", municipio);
                    this.parametros.put("parMunicipio", this.getCodMunicipio(municipio, uf));
                    this.parametros.put("taxaEstadual", this.agravo.getTaxaEstado(conexao, this.parametros));
                    if (!this.relatorio.equals("RecebimentoLote")) {
                        this.parametros.put("parCompletitude", this.agravo.getCompletitude(conexao, this.parametros));
                        this.beans = this.agravo.getBeansMunicipioEspecifico(conexao, this.parametros);
                    }
                }
            }
            if (this.parametros.get("parNenhum") != null) {
                if (((Boolean)this.parametros.get("parNenhum")).booleanValue()) {
                    this.parametros.put("parDescricaoReg", "");
                } else {
                    this.parametros.put("parDescricaoReg", "Regional de Sa\u00fade");
                    if ((Boolean)this.parametros.get("parIsRegiao") != null && ((Boolean)this.parametros.get("parIsRegiao")).booleanValue()) {
                        this.parametros.put("parDescricaoReg", "Regi\u00e3o de Sa\u00fade");
                    }
                }
            }
            String nomeReg = "Regional";
            if ((Boolean)this.parametros.get("parIsRegiao") != null && ((Boolean)this.parametros.get("parIsRegiao")).booleanValue()) {
                nomeReg = "Regi\u00e3o";
            }
            if (this.getRegional() != null) {
                this.parametros.put("parNomeMunicipio", "N\u00edvel de Agrega\u00e7\u00e3o:\nUF " + this.agravo.getTipoAgregacao() + ": " + uf + "\n" + nomeReg + " " + this.agravo.getTipoAgregacao() + ":" + this.getRegional() + "\nMunic\u00edpio " + this.agravo.getTipoAgregacao() + ":" + municipio);
            } else {
                this.parametros.put("parNomeMunicipio", "N\u00edvel de Agrega\u00e7\u00e3o:\nUF " + this.agravo.getTipoAgregacao() + ": " + uf + "\nMunic\u00edpio " + this.agravo.getTipoAgregacao() + ":" + municipio);
            }
            if (!(this.relatorio.equals("Oportunidade") || this.relatorio.equals("OportunidadePQAVSPactuacao") || this.relatorio.equals("OportunidadeCOAP") || this.relatorio.equals("OportunidadePQAVS") || this.relatorio.equals("RecebimentoLote"))) {
                this.parametros.put("parPeriodo", "Per\u00edodo " + this.agravo.getPeriodo() + ":\n" + this.parametros.get("parPeriodo"));
            }
            if (!this.relatorio.equals("RecebimentoLote") && this.parametros.get("parCompletitude").equals(" null")) {
                this.parametros.put("parCompletitude", "");
            }
            if (this.relatorio != null && this.relatorio.equals("RecebimentoLote")) {
                List teste = new ArrayList();
                RecebimentoLoteService recebimentoLoteService = new RecebimentoLoteService();
                teste = recebimentoLoteService.getCalculaResultado(this.parametros, this.agravo);
            }
            if (this.relatorio != null && this.relatorio.equals("SemEpidPQAVS")) {
                SemEpidPQAVSService semEpidPQAVSService = new SemEpidPQAVSService();
                listaRegiaoSaude = new ArrayList();
                listaUF = new ArrayList();
                semEpidPQAVSService.calcularResultado(this.beans);
                if (this.parametros.get("parDesagregacao").equals("UF subdividida por Regi\u00f5es de Sa\u00fade")) {
                    this.parametros.put("TITULO_COLUNA", "UF       Regi\u00e3o de Sa\u00fade");
                    this.parametros.put("QTDE_REG_MUNIC_AGR", "Regi\u00f5es");
                    listaRegiaoSaude = semEpidPQAVSService.converterMapaRegiaoSaudeEmLista(semEpidPQAVSService.agruparRegiaoSaude2(this.beans), this.parametros);
                    listaUF = semEpidPQAVSService.converterMapaUFRegiaoSaudeEmLista(semEpidPQAVSService.agruparUFRegiaoSaude2(listaRegiaoSaude), this.parametros);
                    semEpidPQAVSService.gerarRelatorioPQAVSUFRegiaoSaude(listaUF, this.parametros, 0, null);
                    if (this.parametros.get("exportarDBF").equals(true)) {
                        listaBean = new ArrayList();
                        for (Object item : listaUF) {
                            for (RegiaoSaudePQAVS regiaoSaudePQAVS : ((UFPQAVS)item).getLista()) {
                                bean = new OportunidadeAgravoPQAVS();
                                ((OportunidadeAgravoPQAVS)bean).setUf(regiaoSaudePQAVS.getUf());
                                ((OportunidadeAgravoPQAVS)bean).setCodRegiaoSaude(regiaoSaudePQAVS.getCodRegiaoSaude());
                                ((OportunidadeAgravoPQAVS)bean).setRegiaoSaude(regiaoSaudePQAVS.getNmAgravo());
                                ((OportunidadeAgravoPQAVS)bean).setNmAgravo("");
                                ((OportunidadeAgravoPQAVS)bean).setQtdOportuno(regiaoSaudePQAVS.getQtdOportuno());
                                ((OportunidadeAgravoPQAVS)bean).setTotal(regiaoSaudePQAVS.getTotal());
                                listaBean.add((OportunidadeAgravoPQAVS)bean);
                            }
                        }
                        semEpidPQAVSService.gerarDBFPQAVSDefineCampos(listaBean);
                    }
                } else {
                    if (this.parametros.get("parDiscriminarPorAgravo").equals(true)) {
                        this.parametros.put("TITULO_COLUNA", "                Agravo");
                        this.parametros.put("QTDE_REG_MUNIC_AGR", "Agravos");
                    } else {
                        this.parametros.put("TITULO_COLUNA", "UF       Regi\u00e3o de Sa\u00fade");
                        this.parametros.put("QTDE_REG_MUNIC_AGR", "Munic\u00edpios");
                    }
                    listaRegiaoSaude = semEpidPQAVSService.converterMapaRegiaoSaudeEmLista(semEpidPQAVSService.agruparRegiaoSaude(this.beans), this.parametros);
                    semEpidPQAVSService.gerarRelatorioPQAVS(listaRegiaoSaude, this.parametros, 0);
                    if (this.parametros.get("exportarDBF").equals(true)) {
                        this.beans.remove(this.beans.size() - 1);
                        semEpidPQAVSService.gerarDBFPQAVSDefineCampos(this.beans);
                    }
                }
            }
            if (this.relatorio != null && this.relatorio.equals("OportunidadePQAVS")) {
                oportunidadePQAVSService = new OportunidadePQAVSService();
                listaRegiaoSaude = new ArrayList();
                listaUF = new ArrayList();
                if (this.parametros.get("parDesagregacao").equals("UF subdividida por Regi\u00f5es de Sa\u00fade")) {
                    this.parametros.put("TITULO_COLUNA", "UF       Regi\u00e3o de Sa\u00fade");
                    this.parametros.put("QTDE_REG_MUNIC_AGR", "Regi\u00f5es");
                    listaRegiaoSaude = ((OportunidadePQAVSService)oportunidadePQAVSService).converterMapaRegiaoSaudeEmLista(((OportunidadePQAVSService)oportunidadePQAVSService).agruparRegiaoSaude2(this.beans), this.parametros);
                    listaUF = ((OportunidadePQAVSService)oportunidadePQAVSService).converterMapaUFRegiaoSaudeEmLista(((OportunidadePQAVSService)oportunidadePQAVSService).agruparUFRegiaoSaude2(listaRegiaoSaude), this.parametros);
                    ((OportunidadePQAVSService)oportunidadePQAVSService).gerarRelatorioPQAVSUFRegiaoSaude(listaUF, this.parametros, 0, null);
                    if (this.parametros.get("exportarDBF").equals(true)) {
                        listaBean = new ArrayList<OportunidadeAgravoPQAVS>();
                        for (Object item : listaUF) {
                            for (RegiaoSaudePQAVS regiaoSaudePQAVS : ((UFPQAVS)item).getLista()) {
                                bean = new OportunidadeAgravoPQAVS();
                                ((OportunidadeAgravoPQAVS)bean).setUf(regiaoSaudePQAVS.getUf());
                                ((OportunidadeAgravoPQAVS)bean).setCodRegiaoSaude(regiaoSaudePQAVS.getCodRegiaoSaude());
                                ((OportunidadeAgravoPQAVS)bean).setRegiaoSaude(regiaoSaudePQAVS.getNmAgravo());
                                ((OportunidadeAgravoPQAVS)bean).setNmAgravo("");
                                ((OportunidadeAgravoPQAVS)bean).setQtdOportuno(regiaoSaudePQAVS.getQtdOportuno());
                                ((OportunidadeAgravoPQAVS)bean).setTotal(regiaoSaudePQAVS.getTotal());
                                listaBean.add((OportunidadeAgravoPQAVS)bean);
                            }
                        }
                        ((OportunidadePQAVSService)oportunidadePQAVSService).gerarDBFPQAVSDefineCampos(listaBean);
                    }
                } else {
                    if (this.parametros.get("parDiscriminarPorAgravo").equals(true)) {
                        this.parametros.put("TITULO_COLUNA", "                Agravo");
                        this.parametros.put("QTDE_REG_MUNIC_AGR", "Agravos");
                    } else {
                        this.parametros.put("TITULO_COLUNA", "UF       Regi\u00e3o de Sa\u00fade");
                        this.parametros.put("QTDE_REG_MUNIC_AGR", "Munic\u00edpios");
                    }
                    listaRegiaoSaude = ((OportunidadePQAVSService)oportunidadePQAVSService).converterMapaRegiaoSaudeEmLista(((OportunidadePQAVSService)oportunidadePQAVSService).agruparRegiaoSaude(this.beans), this.parametros);
                    ((OportunidadePQAVSService)oportunidadePQAVSService).gerarRelatorioPQAVS(listaRegiaoSaude, this.parametros, 0);
                    if (this.parametros.get("exportarDBF").equals(true)) {
                        this.beans.remove(this.beans.size() - 1);
                        ((OportunidadePQAVSService)oportunidadePQAVSService).gerarDBFPQAVSDefineCampos(this.beans);
                    }
                }
            }
            if (this.relatorio != null && this.relatorio.equals("OportunidadePQAVSPactuacao")) {
                oportunidadePQAVSService = new OportunidadePQAVSServicePactuacao();
                listaRegiaoSaude = new ArrayList();
                listaUF = new ArrayList();
                if (!this.parametros.get("parDiscriminarPorAgravo").equals(true)) {
                    if (this.parametros.get("parDesagregacao").equals("UF subdividida por Regi\u00f5es de Sa\u00fade")) {
                        if (this.parametros.get("parNenhum").toString().equals("true")) {
                            this.parametros.put("TITULO_COLUNA", "UF       Regi\u00e3o de Sa\u00fade");
                            this.parametros.put("QTDE_REG_MUNIC_AGR", "Regi\u00f5es");
                            listaRegiaoSaude = ((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).converterMapaRegiaoSaudeEmLista(((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).agruparRegiaoSaude2(this.beans), this.parametros);
                            listaUF = ((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).converterMapaUFRegiaoSaudeEmLista(((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).agruparUFRegiaoSaude2(listaRegiaoSaude), this.parametros);
                            ((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).gerarRelatorioPQAVSUFRegiaoSaude(listaUF, this.parametros, 0, null);
                            if (this.parametros.get("exportarDBF").equals(true)) {
                                listaBean = new ArrayList();
                                for (Object item : listaUF) {
                                    for (RegiaoSaudePQAVS regiaoSaudePQAVS : ((UFPQAVS)item).getLista()) {
                                        bean = new OportunidadeAgravoPQAVS();
                                        ((OportunidadeAgravoPQAVS)bean).setUf(regiaoSaudePQAVS.getUf());
                                        ((OportunidadeAgravoPQAVS)bean).setCodRegiaoSaude(regiaoSaudePQAVS.getCodRegiaoSaude());
                                        ((OportunidadeAgravoPQAVS)bean).setRegiaoSaude(regiaoSaudePQAVS.getNmAgravo());
                                        ((OportunidadeAgravoPQAVS)bean).setNmAgravo("");
                                        ((OportunidadeAgravoPQAVS)bean).setQtdOportuno(regiaoSaudePQAVS.getQtdOportuno());
                                        ((OportunidadeAgravoPQAVS)bean).setTotal(regiaoSaudePQAVS.getTotal());
                                        listaBean.add((OportunidadeAgravoPQAVS)bean);
                                    }
                                }
                                ((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).gerarDBFPQAVSDefineCampos(listaBean, this.parametros);
                            }
                        } else {
                            this.parametros.put("TITULO_COLUNA", "UF       Regi\u00e3o de Sa\u00fade");
                            this.parametros.put("QTDE_REG_MUNIC_AGR", "Munic\u00edpios");
                            listaRegiaoSaude = ((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).converterMapaRegiaoSaudeEmLista(((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).agruparRegiaoSaude(this.beans), this.parametros);
                            ((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).gerarRelatorioPQAVS(listaRegiaoSaude, this.parametros, 0);
                            if (this.parametros.get("exportarDBF").equals(true)) {
                                this.beans.remove(this.beans.size() - 1);
                                ((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).gerarDBFPQAVSDefineCampos(this.beans, this.parametros);
                            }
                        }
                    } else if (this.parametros.get("parDesagregacao").equals("UF subdividida por Regionais de Sa\u00fade")) {
                        if (this.parametros.get("parNenhum").toString().equals("true")) {
                            this.parametros.put("TITULO_COLUNA", "UF       Regionais de Sa\u00fade");
                            this.parametros.put("QTDE_REG_MUNIC_AGR", "Regionais");
                            listaRegiaoSaude = ((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).converterMapaRegionalSaudeEmLista(((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).agruparRegionalSaude2(this.beans), this.parametros);
                            listaUF = ((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).converterMapaUFRegiaoSaudeEmLista(((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).agruparUFRegiaoSaude2(listaRegiaoSaude), this.parametros);
                            ((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).gerarRelatorioPQAVSUFRegiaoSaude(listaUF, this.parametros, 0, null);
                            if (this.parametros.get("exportarDBF").equals(true)) {
                                listaBean = new ArrayList();
                                for (Object item : listaUF) {
                                    for (RegiaoSaudePQAVS regiaoSaudePQAVS : ((UFPQAVS)item).getLista()) {
                                        bean = new OportunidadeAgravoPQAVS();
                                        ((OportunidadeAgravoPQAVS)bean).setUf(regiaoSaudePQAVS.getUf());
                                        ((OportunidadeAgravoPQAVS)bean).setCodRegionalSaude(regiaoSaudePQAVS.getCodRegiaoSaude());
                                        ((OportunidadeAgravoPQAVS)bean).setRegionalSaude(regiaoSaudePQAVS.getNmAgravo());
                                        ((OportunidadeAgravoPQAVS)bean).setNmAgravo("");
                                        ((OportunidadeAgravoPQAVS)bean).setQtdOportuno(regiaoSaudePQAVS.getQtdOportuno());
                                        ((OportunidadeAgravoPQAVS)bean).setTotal(regiaoSaudePQAVS.getTotal());
                                        listaBean.add((OportunidadeAgravoPQAVS)bean);
                                    }
                                }
                                ((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).gerarDBFPQAVSDefineCampos(listaBean, this.parametros);
                            }
                        } else {
                            this.parametros.put("TITULO_COLUNA", "UF       Regional de Sa\u00fade");
                            this.parametros.put("QTDE_REG_MUNIC_AGR", "Munic\u00edpios");
                            listaRegiaoSaude = ((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).converterMapaRegiaoSaudeEmLista(((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).agruparRegionalSaude(this.beans), this.parametros);
                            ((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).gerarRelatorioPQAVS(listaRegiaoSaude, this.parametros, 0);
                            if (this.parametros.get("exportarDBF").equals(true)) {
                                this.beans.remove(this.beans.size() - 1);
                                ((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).gerarDBFPQAVSDefineCampos(this.beans, this.parametros);
                            }
                        }
                    } else if (this.parametros.get("parDesagregacao").equals("Somente munic\u00edpios")) {
                        this.parametros.put("TITULO_COLUNA", "UF       Munic\u00edpios");
                        this.parametros.put("QTDE_REG_MUNIC_AGR", "Quantidade");
                        listaRegiaoSaude = ((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).converterMapaRegiaoSaudeEmLista(((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).agruparRegionalSaude(this.beans), this.parametros);
                        ((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).gerarRelatorioPQAVS(listaRegiaoSaude, this.parametros, 0);
                        if (this.parametros.get("exportarDBF").equals(true)) {
                            this.beans.remove(this.beans.size() - 1);
                            ((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).gerarDBFPQAVSDefineCampos(this.beans, this.parametros);
                        }
                    }
                } else {
                    this.parametros.put("TITULO_COLUNA", "                Agravo");
                    this.parametros.put("QTDE_REG_MUNIC_AGR", "Agravos");
                    listaRegiaoSaude = ((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).converterMapaRegiaoSaudeEmLista(((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).agruparRegiaoSaude(this.beans), this.parametros);
                    ((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).gerarRelatorioPQAVS(listaRegiaoSaude, this.parametros, 0);
                    if (this.parametros.get("exportarDBF").equals(true)) {
                        this.beans.remove(this.beans.size() - 1);
                        ((OportunidadePQAVSServicePactuacao)oportunidadePQAVSService).gerarDBFPQAVSDefineCampos(this.beans, this.parametros);
                    }
                }
                if (this.isTemListagem()) {
                    this.gerarRelatorioListagem(this.agravo.getListagemCasosPQAVS());
                }
            }
            if (this.relatorio != null && this.relatorio.equals("OportunidadeCOAP")) {
                OportunidadeCOAPService oportunidadeCOAPService = new OportunidadeCOAPService();
                listaRegiaoSaude = new ArrayList();
                listaUF = new ArrayList();
                if (this.parametros.get("parDesagregacao").equals("UF subdividida por Regi\u00f5es de Sa\u00fade")) {
                    this.parametros.put("TITULO_COLUNA", "UF       Regi\u00e3o de Sa\u00fade");
                    this.parametros.put("QTDE_REG_MUNIC_AGR", "Regi\u00f5es");
                    listaRegiaoSaude = oportunidadeCOAPService.converterMapaRegiaoSaudeEmLista(oportunidadeCOAPService.agruparRegiaoSaude2(this.beans), this.parametros);
                    listaUF = oportunidadeCOAPService.converterMapaUFRegiaoSaudeEmLista(oportunidadeCOAPService.agruparUFRegiaoSaude2(listaRegiaoSaude), this.parametros);
                    oportunidadeCOAPService.gerarRelatorioCOAPUFRegiaoSaude(listaUF, this.parametros, 0, null);
                    if (this.parametros.get("exportarDBF").equals(true)) {
                        listaBean = new ArrayList();
                        for (Object item : listaUF) {
                            for (RegiaoSaude regiaoSaude : ((UFCoap)item).getLista()) {
                                bean = new OportunidadeAgravoCOAP();
                                ((OportunidadeAgravoCOAP)bean).setUf(regiaoSaude.getUf());
                                ((OportunidadeAgravoCOAP)bean).setCodRegiaoSaude(regiaoSaude.getCodRegiaoSaude());
                                ((OportunidadeAgravoCOAP)bean).setRegiaoSaude(regiaoSaude.getNmAgravo());
                                ((OportunidadeAgravoCOAP)bean).setNmAgravo("");
                                ((OportunidadeAgravoCOAP)bean).setQtdOportuno(regiaoSaude.getQtdOportuno());
                                ((OportunidadeAgravoCOAP)bean).setTotal(regiaoSaude.getTotal());
                                listaBean.add((OportunidadeAgravoPQAVS)bean);
                            }
                        }
                        oportunidadeCOAPService.gerarDBFCOAPDefineCampos(listaBean);
                    }
                } else {
                    if (this.parametros.get("parDiscriminarPorAgravo").equals(true)) {
                        this.parametros.put("TITULO_COLUNA", "                Agravo");
                        this.parametros.put("QTDE_REG_MUNIC_AGR", "Agravos");
                    } else {
                        this.parametros.put("TITULO_COLUNA", "UF       Regi\u00e3o de Sa\u00fade");
                        this.parametros.put("QTDE_REG_MUNIC_AGR", "Munic\u00edpios");
                    }
                    listaRegiaoSaude = oportunidadeCOAPService.converterMapaRegiaoSaudeEmLista(oportunidadeCOAPService.agruparRegiaoSaude(this.beans), this.parametros);
                    oportunidadeCOAPService.gerarRelatorioCOAP(listaRegiaoSaude, this.parametros, 0);
                    if (this.parametros.get("exportarDBF").equals(true)) {
                        this.beans.remove(this.beans.size() - 1);
                        if (this.parametros.get("parDiscriminarPorAgravo").equals(true)) {
                            oportunidadeCOAPService.gerarDBFAgravoCOAPCampos(this.beans);
                        } else {
                            oportunidadeCOAPService.gerarDBFCOAPDefineCampos(this.beans);
                        }
                    }
                }
            } else {
                jrds = new JRBeanArrayDataSource(this.beans.toArray());
                URL arquivo = this.parametros.get("parJasper") == null ? this.getClass().getResource(this.agravo.getCaminhoJasper()) : this.getClass().getResource("/com/org/relatorios/" + this.parametros.get("parJasper").toString() + ".jasper");
                if (this.parametros.get("parFator") != null && this.parametros.get("parFator").toString().equals("1")) {
                    this.parametros.put("parFator", "N\u00e3o se aplica");
                }
                if (this.parametros.get("parVariosArquivos") != null && SessionFacadeImpl.isDbf()) {
                    this.parametros.put("parArquivos", "Arquivos selecionados:\n " + this.parametros.get("parArquivos").toString());
                } else if (!this.relatorio.equals("Regularidade")) {
                    this.parametros.put("parArquivos", "");
                }
                if (!this.relatorio.equals("Regularidade")) {
                    impressao = JasperFillManager.fillReport((InputStream)arquivo.openStream(), (Map)this.parametros, (JRDataSource)jrds);
                    this.viewer = new JasperViewer(impressao, false);
                }
                if (this.isTemListagem()) {
                    this.gerarRelatorioListagem(this.agravo.getListagemCasos());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void gerarRelatorioListagem(List listagem) throws IOException, JRException {
        this.parametros.put("parTitulo1", "Listagem de casos de doen\u00e7as de notifica\u00e7\u00e3o compuls\u00f3ria imediata n\u00e3o encerrados ou inconclusivos");
        JRBeanArrayDataSource jrdsListagem = new JRBeanArrayDataSource(listagem.toArray());
        URL arquivoListagem = this.getClass().getResource("/com/org/relatorios/listagemOportunidade.jasper");
        JasperPrint imprimirListagem = JasperFillManager.fillReport((InputStream)arquivoListagem.openStream(), (Map)this.parametros, (JRDataSource)jrdsListagem);
        JasperViewer viewerListagem = new JasperViewer(imprimirListagem, false);
        viewerListagem.setVisible(true);
    }

    public JPanel retornaPanelPactuacao(String relatorio) {
        JPanel panel = null;
        System.out.println("");
        if (relatorio.equals("N\u00famero de casos novos de AIDS em menores de 5 anos")) {
            panel = new AidsIndicadorCriancaPactuacao();
            this.relatorio = "AidsIndicadorCriancaPactuacao";
        } else if (relatorio.equals("N\u00famero de casos novos de s\u00edfilis cong\u00eanita em menores de 1 ano de idade")) {
            panel = new SifilisCongenitaIncidenciaPactuacao();
            this.relatorio = "SifilisCongenitaIncidenciaPactuacao";
        } else if (relatorio.equals("Propor\u00e7\u00e3o de casos DNCI encerrados em at\u00e9 60 dias ap\u00f3s notifica\u00e7\u00e3o")) {
            panel = new com.org.view.OportunidadePQAVSPactuacao();
            this.relatorio = "OportunidadePQAVSPactuacao";
        } else if (relatorio.equals("N\u00famero de casos aut\u00f3ctones de mal\u00e1ria")) {
            panel = new AutoctonesMalariaPactuacao();
            this.relatorio = "AutoctonesMalariaPactuacao";
        } else if (relatorio.equals("Propor\u00e7\u00e3o de casos de mal\u00e1ria que iniciaram tratamento em tempo oportuno")) {
            panel = new OportunidadeMalariaPactuacao();
            this.relatorio = "OportunidadeMalariaPactuacao";
        } else if (relatorio.equals("Propor\u00e7\u00e3o de contatos examinados de casos novos de tuberculose")) {
            panel = new ContatosExaminadosTuberculosePactuacao();
            this.relatorio = "ExaminadosTuberculosePactuacao";
        } else if (relatorio.equals("Propor\u00e7\u00e3o de notifica\u00e7\u00f5es de Viol\u00eancia com o campo ra\u00e7a/cor preenchido de forma v\u00e1lida")) {
            panel = new Violencia();
            this.relatorio = "Violencia";
        } else if (relatorio.equals("N\u00famero de semanas epidemiol\u00f3gicas com informa\u00e7\u00e3o")) {
            panel = new SemanaEpidemiologicaPactuacao();
            this.relatorio = "SemanaEpidemiologicaPactuacao";
        }
        if (relatorio.equals("Propor\u00e7\u00e3o de cura dos casos novos de hansen\u00edase diagnosticados nos anos das coortes")) {
            panel = new com.org.view.HanseniaseCoorteCuraPactuacao();
            this.relatorio = "HanseniaseCoorteCura";
        } else if (relatorio.equals("Propor\u00e7\u00e3o de contatos examinados de casos novos de hansen\u00edase")) {
            panel = new ContatosExaminadosHanseniasePactuacao();
            this.relatorio = "ExaminadosHanseniasePactuacao";
        } else if (relatorio.equals("Propor\u00e7\u00e3o de preenchimento do campo ocupa\u00e7\u00e3o")) {
            panel = new PreenchimentoOcupacaoTrabalhadorPactuacao();
            this.relatorio = "PreenchimentoOcupacaoTrabalhadorPactuacao";
        }
        return panel;
    }

    @Override
    public JPanel retornaPanel(String relatorio) {
        JPanel panel = null;
        if (relatorio.equals("Listagem de notifica\u00e7\u00f5es de prov\u00e1veis faltosos e abandono do tratamento de hansen\u00edase")) {
            panel = new hanseniaseListagem();
            this.relatorio = "ListagemHanseniase";
        }
        if (relatorio.equals("Taxa de letalidade por Febre Hemorr\u00e1gica Dengue")) {
            panel = new DengueLetalidade();
            this.relatorio = "DengueLetalidade";
        }
        if (relatorio.equals("Taxa de incid\u00eancia de aids em menores de 5 anos de idade")) {
            panel = new com.org.view.AidsTaxaCrianca();
            this.relatorio = "AidsTaxaCrianca";
        }
        if (relatorio.equals("Propor\u00e7\u00e3o de doen\u00e7as exantem\u00e1ticas investigados oportunamente") || relatorio.equals("Propor\u00e7\u00e3o de doen\u00e7as exantem\u00e1ticas investigados oportunamente (PAVS 2010/2011)")) {
            panel = new ExantematicaOportuno("ExantematicaOportuno");
        }
        if (relatorio.equals("Propor\u00e7\u00e3o de doen\u00e7as exantem\u00e1ticas investigados oportuna e adequadamente")) {
            panel = new ExantematicaOportuno("ExantematicaOportunoAdequado");
        }
        if (relatorio.equals("Percentual de casos de hepatites B e C")) {
            panel = new com.org.view.HepatiteBC();
            this.relatorio = "HepatiteBC";
        }
        if (relatorio.equals("Percentual de casos de hepatites B confirmados por sorologia")) {
            panel = new HepatiteB();
            this.relatorio = "HepatiteB";
        }
        if (relatorio.equals("Taxa de notifica\u00e7\u00e3o de casos de PFA em menores de 15 anos") || relatorio.equals("Taxa de notifica\u00e7\u00e3o de casos de PFA em menores de 15 anos (PAVS 2010/2011)")) {
            panel = new com.org.view.PFA15anos();
            this.relatorio = "PFA15anos";
        }
        if (relatorio.equals("Situa\u00e7\u00e3o da coorte de casos novos de Tuberculose")) {
            panel = new TuberculoseCoorte();
            this.relatorio = "TuberculoseCoorte";
        }
        if (relatorio.equals("Situa\u00e7\u00e3o da coorte de casos novos de hansen\u00edase")) {
            panel = new HanseniaseCoorte();
            this.relatorio = "HanseniaseCoorte";
        }
        if (relatorio.equals("Recebimento de Lotes")) {
            panel = new RecebimentoLote();
            this.relatorio = "RecebimentoLote";
        }
        if (relatorio.equals("N\u00famero de semanas epidemiol\u00f3gicas com informa\u00e7\u00e3o")) {
            panel = new com.org.view.SemEpidPQAVS();
            this.relatorio = "SemEpidPQAVS";
        }
        if (relatorio.equals("Propor\u00e7\u00e3o de casos DNCI encerrados em at\u00e9 60 dias ap\u00f3s notifica\u00e7\u00e3o")) {
            panel = new com.org.view.OportunidadePQAVS();
            this.relatorio = "OportunidadePQAVS";
        }
        if (relatorio.equals("COAP - Encerramento Oportuno da Investiga\u00e7\u00e3o")) {
            panel = new OportunidadeCOAP();
            this.relatorio = "OportunidadeCOAP";
        }
        if (relatorio.equals("Encerramento Oportuno da Investiga\u00e7\u00e3o")) {
            panel = new com.org.view.Oportunidade();
            this.relatorio = "Oportunidade";
        }
        if (relatorio.equals("Regularidade na alimenta\u00e7\u00e3o do Sinan")) {
            panel = new com.org.view.Regularidade();
            this.relatorio = "Regularidade";
        }
        if (relatorio.equals("Taxa de letalidade das formas graves de dengue")) {
            panel = new com.org.view.DengueLetalidadeGrave();
            this.relatorio = "DengueLetalidadeGrave";
        }
        if (relatorio.equals("Incid\u00eancia de S\u00edfilis Cong\u00eanita")) {
            panel = new SifilisCongenitaIncidencia();
            this.relatorio = "SifilisCongenitaIncidencia";
        }
        if (relatorio.equals("N\u00famero de notifica\u00e7\u00f5es dos agravos \u00e0 Sa\u00fade do trabalhador")) {
            panel = new SaudeTrabalhador();
            this.relatorio = "SaudeTrabalhador";
        }
        if (relatorio.equals("N\u00famero de casos aut\u00f3ctones de mal\u00e1ria")) {
            panel = new AutoctonesMalariaPactuacao();
            this.relatorio = "AutoctonesMalariaPactuacao";
        }
        if (relatorio.equals("An\u00e1lise de Completitude")) {
            Frame parent = new Frame();
            Completitude completitude = new Completitude(parent, true);
            completitude.setVisible(true);
            return null;
        }
        return panel;
    }

    @Override
    protected Void doInBackground() throws Exception {
        if (this.relatorio.equals("ListagemHanseniase")) {
            this.agravo = new Hanseniase(SessionFacadeImpl.isDbf());
        }
        if (this.relatorio.equals("DengueLetalidade")) {
            this.agravo = new com.org.model.classes.agravos.DengueLetalidade(SessionFacadeImpl.isDbf());
        }
        if (this.relatorio.equals("DengueLetalidadeGrave")) {
            this.agravo = new DengueLetalidadeGrave(SessionFacadeImpl.isDbf());
        }
        if (this.relatorio.equals("AidsTaxaCrianca")) {
            this.agravo = new AidsTaxaCrianca(SessionFacadeImpl.isDbf());
        }
        if (this.relatorio.equals("AidsIndicadorCriancaPactuacao")) {
            this.agravo = new com.org.model.classes.agravos.AidsIndicadorCriancaPactuacao(SessionFacadeImpl.isDbf());
            this.agravo.setAnoAvaliado(this.anoAvaliado);
            this.agravo.setDtInicioAvaliacao(this.dtInicioAvaliacao);
            this.agravo.setDtFimAvaliacao(this.dtFimAvaliacao);
            this.agravo.setDataAvaliacao(this.dataAvaliacao);
            this.agravo.setUf(this.uf);
            this.agravo.setMunicipio(this.municipio);
            this.agravo.setRegional(this.regional);
            this.agravo.setTemListagem(this.temListagem);
        }
        if (this.relatorio.equals("SifilisCongenitaIncidencia")) {
            this.agravo = new com.org.model.classes.agravos.SifilisCongenitaIncidencia(SessionFacadeImpl.isDbf());
        }
        if (this.relatorio.equals("SifilisCongenitaIncidenciaPactuacao")) {
            this.agravo = new com.org.model.classes.agravos.SifilisCongenitaIncidenciaPactuacao(SessionFacadeImpl.isDbf());
            this.agravo.setAnoAvaliado(this.anoAvaliado);
            this.agravo.setDtInicioAvaliacao(this.dtInicioAvaliacao);
            this.agravo.setDtFimAvaliacao(this.dtFimAvaliacao);
            this.agravo.setDataAvaliacao(this.dataAvaliacao);
            this.agravo.setUf(this.uf);
            this.agravo.setMunicipio(this.municipio);
            this.agravo.setRegional(this.regional);
            this.agravo.setTemListagem(this.temListagem);
        }
        if (this.relatorio.equals("SaudeTrabalhador")) {
            this.agravo = new com.org.model.classes.agravos.SaudeTrabalhador(SessionFacadeImpl.isDbf());
        }
        if (this.relatorio.equals("ExantematicaOportunoAdequado")) {
            this.agravo = new ExantematicaOportunoAdequadamente(SessionFacadeImpl.isDbf(), true);
        }
        if (this.relatorio.equals("ExantematicaOportuno")) {
            this.agravo = new com.org.model.classes.agravos.ExantematicaOportuno(SessionFacadeImpl.isDbf(), false);
        }
        if (this.relatorio.equals("HepatiteBC")) {
            this.agravo = new HepatiteBC(SessionFacadeImpl.isDbf());
        }
        if (this.relatorio.equals("HepatiteB")) {
            this.agravo = new com.org.model.classes.agravos.HepatiteB(SessionFacadeImpl.isDbf());
        }
        if (this.relatorio.equals("PFA15anos")) {
            this.agravo = new PFA15anos(SessionFacadeImpl.isDbf());
        }
        if (this.relatorio.equals("AutoctonesMalariaPactuacao")) {
            this.agravo = new AutoctoneMalariaPactuacao(SessionFacadeImpl.isDbf());
            this.agravo.setAnoAvaliado(this.anoAvaliado);
            this.agravo.setDtInicioAvaliacao(this.dtInicioAvaliacao);
            this.agravo.setDtFimAvaliacao(this.dtFimAvaliacao);
            this.agravo.setDataAvaliacao(this.dataAvaliacao);
            this.agravo.setUf(this.uf);
            this.agravo.setMunicipio(this.municipio);
            this.agravo.setRegional(this.regional);
            this.agravo.setTemListagem(this.temListagem);
        }
        if (this.relatorio.equals("SemanaEpidemiologicaPactuacao")) {
            this.agravo = new com.org.model.classes.agravos.SemanaEpidemiologicaPactuacao(SessionFacadeImpl.isDbf());
            this.agravo.setAnoAvaliado(this.anoAvaliado);
            this.agravo.setDtInicioAvaliacao(this.dtInicioAvaliacao);
            this.agravo.setDtFimAvaliacao(this.dtFimAvaliacao);
            this.agravo.setDataAvaliacao(this.dataAvaliacao);
            this.agravo.setUf(this.uf);
            this.agravo.setMunicipio(this.municipio);
            this.agravo.setRegional(this.regional);
            this.agravo.setTemListagem(this.temListagem);
        }
        if (this.relatorio.equals("PreenchimentoOcupacaoTrabalhadorPactuacao")) {
            this.agravo = new com.org.model.classes.agravos.PreenchimentoOcupacaoTrabalhadorPactuacao(SessionFacadeImpl.isDbf());
            this.agravo.setAnoAvaliado(this.anoAvaliado);
            this.agravo.setDtInicioAvaliacao(this.dtInicioAvaliacao);
            this.agravo.setDtFimAvaliacao(this.dtFimAvaliacao);
            this.agravo.setDataAvaliacao(this.dataAvaliacao);
            this.agravo.setUf(this.uf);
            this.agravo.setMunicipio(this.municipio);
            this.agravo.setRegional(this.regional);
            this.agravo.setTemListagem(this.temListagem);
        }
        if (this.relatorio.equals("ExaminadosTuberculosePactuacao")) {
            this.agravo = new com.org.model.classes.agravos.ContatosExaminadosTuberculosePactuacao(SessionFacadeImpl.isDbf());
            this.agravo.setAnoAvaliado(this.anoAvaliado);
            this.agravo.setDtInicioAvaliacao(this.dtInicioAvaliacao);
            this.agravo.setDtFimAvaliacao(this.dtFimAvaliacao);
            this.agravo.setDataAvaliacao(this.dataAvaliacao);
            this.agravo.setUf(this.uf);
            this.agravo.setMunicipio(this.municipio);
            this.agravo.setRegional(this.regional);
            this.agravo.setTemListagem(this.temListagem);
        }
        if (this.relatorio.equals("ExaminadosHanseniasePactuacao")) {
            this.agravo = new com.org.model.classes.agravos.ContatosExaminadosHanseniasePactuacao(SessionFacadeImpl.isDbf());
            this.agravo.setAnoAvaliado(this.anoAvaliado);
            this.agravo.setDtInicioAvaliacao(this.dtInicioAvaliacao);
            this.agravo.setDtFimAvaliacao(this.dtFimAvaliacao);
            this.agravo.setDataAvaliacao(this.dataAvaliacao);
            this.agravo.setUf(this.uf);
            this.agravo.setMunicipio(this.municipio);
            this.agravo.setRegional(this.regional);
            this.agravo.setTemListagem(this.temListagem);
        }
        if (this.relatorio.equals("OportunidadeMalariaPactuacao")) {
            this.agravo = new com.org.model.classes.agravos.OportunidadeMalariaPactuacao(SessionFacadeImpl.isDbf());
            this.agravo.setAnoAvaliado(this.anoAvaliado);
            this.agravo.setDtInicioAvaliacao(this.dtInicioAvaliacao);
            this.agravo.setDtFimAvaliacao(this.dtFimAvaliacao);
            this.agravo.setDataAvaliacao(this.dataAvaliacao);
            this.agravo.setUf(this.uf);
            this.agravo.setMunicipio(this.municipio);
            this.agravo.setRegional(this.regional);
            this.agravo.setTemListagem(this.temListagem);
        }
        if (this.relatorio.equals("OportunidadeCOAP")) {
            this.agravo = new com.org.model.classes.agravos.OportunidadeCOAP(SessionFacadeImpl.isDbf());
            this.agravo.setAnoAvaliado(this.anoAvaliado);
            this.agravo.setDtInicioAvaliacao(this.dtInicioAvaliacao);
            this.agravo.setDtFimAvaliacao(this.dtFimAvaliacao);
            this.agravo.setDataAvaliacao(this.dataAvaliacao);
            this.agravo.setNomeAgravo(this.nomeAgravo);
            this.agravo.setUf(this.uf);
            this.agravo.setMunicipio(this.municipio);
            this.agravo.setRegional(this.regional);
            this.agravo.setTemListagem(this.temListagem);
        }
        if (this.relatorio.equals("RecebimentoLote")) {
            this.agravo = new com.org.model.classes.agravos.RecebimentoLote(SessionFacadeImpl.isDbf());
            this.agravo.setAnoAvaliado("2010");
            this.agravo.setDtInicioAvaliacao(this.dtInicioAvaliacao);
            this.agravo.setDtFimAvaliacao(this.dtFimAvaliacao);
            this.agravo.setDtInicioTransf(this.dtInicioTrasnf);
            this.agravo.setDtFimTransf(this.dtFimTransf);
            this.agravo.setDtInicioReceb(this.dtInicioReceb);
            this.agravo.setDtFimReceb(this.dtFimReceb);
            this.agravo.setDataAvaliacao(this.dtInicioAvaliacao);
            this.agravo.setNomeAgravo("agravo");
            this.agravo.setUf("uf");
            this.agravo.setParametros(this.parametros);
            this.agravo.setMunicipio("municipio");
            this.agravo.setRegional("regional");
            this.agravo.setTemListagem(false);
        }
        if (this.relatorio.equals("SemEpidPQAVS")) {
            this.agravo = new SemEpidPQAVS(SessionFacadeImpl.isDbf());
            this.agravo.setAnoAvaliado(this.anoAvaliado);
            this.agravo.setDtInicioAvaliacao(this.dtInicioAvaliacao);
            this.agravo.setDtFimAvaliacao(this.dtFimAvaliacao);
            this.agravo.setDataAvaliacao(this.dataAvaliacao);
            this.agravo.setNomeAgravo(this.nomeAgravo);
            this.agravo.setUf(this.uf);
            this.agravo.setMunicipio(this.municipio);
            this.agravo.setRegional(this.regional);
            this.agravo.setTemListagem(this.temListagem);
        }
        if (this.relatorio.equals("OportunidadePQAVS")) {
            this.agravo = new OportunidadePQAVS(SessionFacadeImpl.isDbf());
            this.agravo.setAnoAvaliado(this.anoAvaliado);
            this.agravo.setDtInicioAvaliacao(this.dtInicioAvaliacao);
            this.agravo.setDtFimAvaliacao(this.dtFimAvaliacao);
            this.agravo.setDataAvaliacao(this.dataAvaliacao);
            this.agravo.setNomeAgravo(this.nomeAgravo);
            this.agravo.setUf(this.uf);
            this.agravo.setMunicipio(this.municipio);
            this.agravo.setRegional(this.regional);
            this.agravo.setTemListagem(this.temListagem);
        }
        if (this.relatorio.equals("OportunidadePQAVSPactuacao")) {
            this.agravo = new OportunidadePQAVSPactuacao(SessionFacadeImpl.isDbf());
            this.agravo.setAnoAvaliado(this.anoAvaliado);
            this.agravo.setDtInicioAvaliacao(this.dtInicioAvaliacao);
            this.agravo.setDtFimAvaliacao(this.dtFimAvaliacao);
            this.agravo.setDataAvaliacao(this.dataAvaliacao);
            this.agravo.setNomeAgravo(this.nomeAgravo);
            this.agravo.setUf(this.uf);
            this.agravo.setMunicipio(this.municipio);
            this.agravo.setRegional(this.regional);
            this.agravo.setTemListagem(this.temListagem);
        }
        if (this.relatorio.equals("Oportunidade")) {
            this.agravo = new Oportunidade(SessionFacadeImpl.isDbf());
            this.agravo.setAnoAvaliado(this.anoAvaliado);
            this.agravo.setDtInicioAvaliacao(this.dtInicioAvaliacao);
            this.agravo.setDtFimAvaliacao(this.dtFimAvaliacao);
            this.agravo.setDataAvaliacao(this.dataAvaliacao);
            this.agravo.setNomeAgravo(this.nomeAgravo);
            this.agravo.setUf(this.uf);
            this.agravo.setMunicipio(this.municipio);
            this.agravo.setRegional(this.regional);
            this.agravo.setTemListagem(this.temListagem);
        }
        if (this.relatorio.equals("HanseniaseCoorte")) {
            this.agravo = new com.org.model.classes.agravos.HanseniaseCoorte(SessionFacadeImpl.isDbf());
        }
        if (this.relatorio.equals("HanseniaseCoorteCura")) {
            this.agravo = new HanseniaseCoorteCuraPactuacao(SessionFacadeImpl.isDbf());
        }
        if (this.relatorio.equals("TuberculoseCoorte")) {
            this.agravo = new com.org.model.classes.agravos.TuberculoseCoorte(SessionFacadeImpl.isDbf(), this.isAuxiliar());
        }
        if (this.relatorio.equals("Regularidade")) {
            this.agravo = new Regularidade(SessionFacadeImpl.isDbf());
        }
        if (this.relatorio.equals("Violencia")) {
            this.agravo = new ViolenciaAgravo(SessionFacadeImpl.isDbf());
            this.agravo.setAnoAvaliado(this.anoAvaliado);
            this.agravo.setDtInicioAvaliacao(this.dtInicioAvaliacao);
            this.agravo.setDtFimAvaliacao(this.dtFimAvaliacao);
            this.agravo.setDataAvaliacao(this.dataAvaliacao);
            this.agravo.setUf(this.uf);
            this.agravo.setMunicipio(this.municipio);
            this.agravo.setRegional(this.regional);
            this.agravo.setTemListagem(this.temListagem);
        }
        this.agravo.setDataFim(this.dataFim);
        this.agravo.setDataInicio(this.dataInicio);
        this.geraRelatorio(this.uf, this.municipio);
        if (this.exportarDbf) {
            if (!Master.setNomeArquivoDBF()) {
                this.viewer.setVisible(true);
                return null;
            }
            new DBF().beanToDbf(this.agravo.getColunas(), this.beans, this.agravo);
        }
        if (this.relatorio.equals("Regularidade")) {
            if (Configuracao.getPropriedade("gtsinan").toString().equals("1")) {
                return null;
            }
            this.viewer.setVisible(true);
        } else {
            this.viewer.setVisible(true);
        }
        System.out.println(this.relatorio + " - " + this.agravo.getCaminhoJasper());
        return null;
    }

    @Override
    public String[] retornaSubgrupos(String grupo) {
        String[] subgrupos = new String[]{""};
        if (grupo.equals("Pactua\u00e7\u00f5es Anteriores")) {
            subgrupos = new String[]{"Selecione a pactua\u00e7\u00e3o", "COAP at\u00e9 2015", "PACTO 2008/2009", "PACTO 2010/2011", "PQAVS at\u00e9 2016"};
            return subgrupos;
        }
        return subgrupos;
    }

    @Override
    public String[] retornaGrupos() {
        String[] grupos = new String[]{"Selecione um Grupo", "PQAVS a partir de 2017", "Pactua\u00e7\u00e3o Interfederativa 2017 a 2021", "Outros relat\u00f3rios"};
        return grupos;
    }

    @Override
    public String[] retornaAgravos(String grupo) {
        String[] grupos = new String[]{""};
        if (grupo.equals("An\u00e1lise de Completitude")) {
            grupos = new String[]{"--"};
        }
        if (grupo.equals("Recebimento de Lotes")) {
            grupos = new String[]{"-------"};
        }
        if (grupo.equals("PQAVS at\u00e9 2016")) {
            grupos = new String[]{"------"};
        }
        if (grupo.equals("COAP at\u00e9 2015")) {
            grupos = new String[]{"-----"};
        }
        if (grupo.equals("Pactua\u00e7\u00e3o Interfederativa 2017 a 2021")) {
            grupos = new String[]{"--"};
        }
        if (grupo.equals("PACTO 2010/2011")) {
            grupos = new String[]{"--"};
        }
        if (grupo.equals("PACTO 2008/2009")) {
            grupos = new String[]{"--"};
        }
        return grupos;
    }

    @Override
    public String[] retornaRelatorios(String grupo, String agravo) {
        String[] relatorios = new String[]{""};
        if (agravo.equals("---")) {
            relatorios = new String[]{"Regularidade na alimenta\u00e7\u00e3o do Sinan"};
        } else if (agravo.equals("-------")) {
            relatorios = new String[]{"Recebimento de Lotes"};
        } else if (agravo.equals("------")) {
            relatorios = new String[]{"Selecione o Relat\u00f3rio", "N\u00famero de semanas epidemiol\u00f3gicas com informa\u00e7\u00e3o", "Propor\u00e7\u00e3o de casos DNCI encerrados em at\u00e9 60 dias ap\u00f3s notifica\u00e7\u00e3o"};
        } else if (agravo.equals("-----")) {
            relatorios = new String[]{"COAP - Encerramento Oportuno da Investiga\u00e7\u00e3o"};
        } else {
            if (grupo.equals("PACTO 2010/2011")) {
                relatorios = new String[]{"Selecione o Relat\u00f3rio", "Encerramento Oportuno da Investiga\u00e7\u00e3o", "Situa\u00e7\u00e3o da coorte de casos novos de Tuberculose", "Incid\u00eancia de S\u00edfilis Cong\u00eanita", "N\u00famero de notifica\u00e7\u00f5es dos agravos \u00e0 Sa\u00fade do trabalhador", "Situa\u00e7\u00e3o da coorte de casos novos de hansen\u00edase", "Percentual de casos de hepatites B confirmados por sorologia", "Taxa de letalidade das formas graves de dengue", "Taxa de incid\u00eancia de aids em menores de 5 anos de idade"};
            }
            if (grupo.equals("Pactua\u00e7\u00e3o Interfederativa 2017 a 2021")) {
                relatorios = new String[]{"Selecione o Relat\u00f3rio", "N\u00famero de casos novos de AIDS em menores de 5 anos", "N\u00famero de casos novos de s\u00edfilis cong\u00eanita em menores de 1 ano de idade", "Propor\u00e7\u00e3o de casos DNCI encerrados em at\u00e9 60 dias ap\u00f3s notifica\u00e7\u00e3o", "N\u00famero de casos aut\u00f3ctones de mal\u00e1ria", "Propor\u00e7\u00e3o de cura dos casos novos de hansen\u00edase diagnosticados nos anos das coortes", "Propor\u00e7\u00e3o de preenchimento do campo ocupa\u00e7\u00e3o"};
            }
            if (grupo.equals("PACTO 2008/2009")) {
                relatorios = new String[]{"Selecione o Relat\u00f3rio", "Situa\u00e7\u00e3o da coorte de casos novos de Tuberculose", "Taxa de notifica\u00e7\u00e3o de casos de PFA em menores de 15 anos", "Percentual de casos de hepatites B e C", "Propor\u00e7\u00e3o de doen\u00e7as exantem\u00e1ticas investigados oportunamente", "Taxa de letalidade por Febre Hemorr\u00e1gica Dengue", "Taxa de incid\u00eancia de aids em menores de 5 anos de idade", "Situa\u00e7\u00e3o da coorte de casos novos de hansen\u00edase"};
            }
            if (grupo.equals("Regularidade na alimenta\u00e7\u00e3o do Sinan")) {
                relatorios = new String[]{"Selecione o Relat\u00f3rio", "Regularidade na alimenta\u00e7\u00e3o do Sinan"};
            }
            if (grupo.equals("Recebimento de Lotes")) {
                relatorios = new String[]{"Recebimento de Lotes"};
            }
            if (grupo.equals("PQAVS at\u00e9 2016")) {
                relatorios = new String[]{"Selecione o Relat\u00f3rio", "N\u00famero de semanas epidemiol\u00f3gicas com informa\u00e7\u00e3o", "Propor\u00e7\u00e3o de casos DNCI encerrados em at\u00e9 60 dias ap\u00f3s notifica\u00e7\u00e3o"};
            }
            if (grupo.equals("COAP at\u00e9 2015")) {
                relatorios = new String[]{"Selecione o Relat\u00f3rio", "COAP - Encerramento Oportuno da Investiga\u00e7\u00e3o"};
            }
            if (grupo.equals("An\u00e1lise de Completitude")) {
                Frame parent = new Frame();
                Completitude completitude = new Completitude(parent, true);
                completitude.setVisible(true);
            }
            if (grupo.equals("PQAVS a partir de 2017")) {
                relatorios = new String[]{"Selecione o Relat\u00f3rio", "N\u00famero de semanas epidemiol\u00f3gicas com informa\u00e7\u00e3o", "Propor\u00e7\u00e3o de casos DNCI encerrados em at\u00e9 60 dias ap\u00f3s notifica\u00e7\u00e3o", "Propor\u00e7\u00e3o de notifica\u00e7\u00f5es de Viol\u00eancia com o campo ra\u00e7a/cor preenchido de forma v\u00e1lida", "Propor\u00e7\u00e3o de casos de mal\u00e1ria que iniciaram tratamento em tempo oportuno", "Propor\u00e7\u00e3o de contatos examinados de casos novos de hansen\u00edase", "Propor\u00e7\u00e3o de contatos examinados de casos novos de tuberculose", "Propor\u00e7\u00e3o de preenchimento do campo ocupa\u00e7\u00e3o"};
            }
            if (grupo.equals("Outros relat\u00f3rios")) {
                relatorios = new String[]{"Selecione o Relat\u00f3rio", "Regularidade na alimenta\u00e7\u00e3o do Sinan"};
            }
        }
        return relatorios;
    }

    public static boolean isDbf() {
        return dbf;
    }

    public static void setDbf(boolean aDbf) {
        dbf = aDbf;
    }

    public static String getNomeDbf() {
        return nomeDbf;
    }

    public static void setNomeDbf(String aNomeDbf) {
        nomeDbf = aNomeDbf;
    }

    public SessionFacadeImpl(boolean dbf) {
        SessionFacadeImpl.setDbf(dbf);
    }

    public SessionFacadeImpl() {
    }

    public String getCodRegionalCOAP(String regional, String uf) throws SQLException {
        ResultSet rs;
        if (regional == null) {
            return "";
        }
        if (regional.equals("TODAS") || regional.isEmpty()) {
            return "";
        }
        if (SessionFacadeImpl.isDbf()) {
            DBFReader reader = SessionFacadeImpl.retornaObjetoDbfCaminhoArquivo("REGIAO", "dbf\\");
            DBFUtil utilDbf = new DBFUtil();
            try {
                Object[] rowObjects;
                utilDbf.mapearPosicoes(reader);
                while ((rowObjects = reader.nextRecord()) != null) {
                    if (!regional.equals(utilDbf.getString(rowObjects, "NM_REGIAO")) || !uf.equals(utilDbf.getString(rowObjects, "SG_UF"))) continue;
                    return utilDbf.getString(rowObjects, "ID_REGIAO");
                }
            }
            catch (DBFException e) {
                Master.mensagem("Erro: regional nao encontrada.Verifique se existe a pasta DBF e se os arquivo REGIAO.DBF est\u00e1 l\u00e1:\n" + (Object)((Object)e));
            }
            return "";
        }
        String config = null;
        String sql = "select co_seq_regional from dblocalidade.tb_regional_svs where no_regional = '" + regional + "'";
        Util util = new Util();
        Conexao con = util.conectarSiceb();
        con.conect();
        Statement stm = con.getC().createStatement();
        try {
            rs = stm.executeQuery(sql);
        }
        catch (Exception exception) {
            sql = "select co_seq_regional from tb_regional_svs where no_regional = '" + regional + "'";
            rs = stm.executeQuery(sql);
        }
        rs.next();
        try {
            config = rs.getString("co_seq_regional");
        }
        catch (Exception exception) {
            try {
                config = rs.getString("co_regional_saude");
            }
            catch (Exception exception1) {
                config = "";
            }
        }
        return config;
    }

    public String getCodRegional(String regional, String uf, String relatorio) throws SQLException {
        ResultSet rs;
        if (regional == null) {
            return "";
        }
        if (regional.equals("TODAS") || regional.isEmpty()) {
            return "";
        }
        if (SessionFacadeImpl.isDbf()) {
            if (relatorio == null || !relatorio.equals("OportunidadeCOAP")) {
                DBFReader reader = SessionFacadeImpl.retornaObjetoDbfCaminhoArquivo("REGIONET", "dbf\\");
                DBFUtil utilDbf = new DBFUtil();
                try {
                    Object[] rowObjects;
                    utilDbf.mapearPosicoes(reader);
                    while ((rowObjects = reader.nextRecord()) != null) {
                        if (!regional.equals(utilDbf.getString(rowObjects, "NM_REGIONA")) || !uf.equals(utilDbf.getString(rowObjects, "SG_UF"))) continue;
                        return utilDbf.getString(rowObjects, "ID_REGIONA");
                    }
                }
                catch (DBFException e) {
                    Master.mensagem("Erro: regional nao encontrada.Verifique se existe a pasta DBF e se os arquivo REGIONET.DBF est\u00e1 l\u00e1:\n" + (Object)((Object)e));
                }
            } else {
                return this.getCodRegionalCOAP(regional, uf);
            }
            return "";
        }
        String config = null;
        String sql = "select co_seq_regional from dblocalidade.tb_regional_svs where no_regional = '" + regional + "'";
        Util util = new Util();
        Conexao con = util.conectarSiceb();
        con.conect();
        Statement stm = con.getC().createStatement();
        try {
            rs = stm.executeQuery(sql);
        }
        catch (Exception exception) {
            sql = "select co_seq_regional from tb_regional_svs where no_regional = '" + regional + "'";
            rs = stm.executeQuery(sql);
        }
        rs.next();
        try {
            config = rs.getString("co_seq_regional");
        }
        catch (Exception exception) {
            try {
                config = rs.getString("co_regional_saude");
            }
            catch (Exception exception1) {
                config = "";
            }
        }
        return config;
    }

    public String getCodRegiao(String regional, String uf, String relatorio) throws SQLException {
        ResultSet rs;
        if (regional == null) {
            return "";
        }
        if (regional.equals("TODAS") || regional.isEmpty()) {
            return "";
        }
        if (SessionFacadeImpl.isDbf()) {
            if (relatorio == null || !relatorio.equals("OportunidadeCOAP")) {
                DBFReader reader = SessionFacadeImpl.retornaObjetoDbfCaminhoArquivo("REGIAO", "dbf\\");
                DBFUtil utilDbf = new DBFUtil();
                try {
                    Object[] rowObjects;
                    utilDbf.mapearPosicoes(reader);
                    while ((rowObjects = reader.nextRecord()) != null) {
                        if (!regional.equals(utilDbf.getString(rowObjects, "NM_REGIAO")) || !uf.equals(utilDbf.getString(rowObjects, "SG_UF"))) continue;
                        return utilDbf.getString(rowObjects, "ID_REGIAO");
                    }
                }
                catch (DBFException e) {
                    Master.mensagem("Erro: regional nao encontrada.Verifique se existe a pasta DBF e se os arquivo REGIONET.DBF est\u00e1 l\u00e1:\n" + (Object)((Object)e));
                }
            } else {
                return this.getCodRegionalCOAP(regional, uf);
            }
            return "";
        }
        String config = null;
        String sql = "select co_seq_regional from dblocalidade.tb_regional_svs where no_regional = '" + regional + "'";
        Util util = new Util();
        Conexao con = util.conectarSiceb();
        con.conect();
        Statement stm = con.getC().createStatement();
        try {
            rs = stm.executeQuery(sql);
        }
        catch (Exception exception) {
            sql = "select co_seq_regional from tb_regional_svs where no_regional = '" + regional + "'";
            rs = stm.executeQuery(sql);
        }
        rs.next();
        try {
            config = rs.getString("co_seq_regional");
        }
        catch (Exception exception) {
            try {
                config = rs.getString("co_regional_saude");
            }
            catch (Exception exception1) {
                config = "";
            }
        }
        return config;
    }

    public String getCodRegiaoSaude(String regiaoSaude, String UF2) throws SQLException {
        ResultSet rs;
        if (regiaoSaude == null) {
            return "";
        }
        if (regiaoSaude.equals("TODAS") || regiaoSaude.isEmpty()) {
            return "";
        }
        if (SessionFacadeImpl.isDbf()) {
            DBFReader reader = SessionFacadeImpl.retornaObjetoDbfCaminhoArquivo("REGIAO", "dbf\\");
            DBFUtil utilDbf = new DBFUtil();
            try {
                Object[] rowObjects;
                utilDbf.mapearPosicoes(reader);
                while ((rowObjects = reader.nextRecord()) != null) {
                    if (!regiaoSaude.equals(utilDbf.getString(rowObjects, "NM_REGIAO")) || !UF2.equals(utilDbf.getString(rowObjects, "SG_UF"))) continue;
                    return utilDbf.getString(rowObjects, "ID_REGIAO");
                }
            }
            catch (DBFException e) {
                Master.mensagem("Erro: regiao nao encontrada.Verifique se existe a pasta DBF e se os arquivo REGIAO.DBF est\u00e1 l\u00e1:\n" + (Object)((Object)e));
            }
            return "";
        }
        String config = null;
        String sql = "select co_seq_regional from dblocalidade.tb_regional_svs where no_regional = '" + regiaoSaude + "'";
        Util util = new Util();
        Conexao con = util.conectarSiceb();
        con.conect();
        Statement stm = con.getC().createStatement();
        try {
            rs = stm.executeQuery(sql);
        }
        catch (Exception exception) {
            sql = "select co_seq_regional from tb_regional_svs where no_regional = '" + regiaoSaude + "'";
            rs = stm.executeQuery(sql);
        }
        rs.next();
        try {
            config = rs.getString("co_seq_regional");
        }
        catch (Exception exception) {
            try {
                config = rs.getString("co_regional_saude");
            }
            catch (Exception exception1) {
                config = "";
            }
        }
        return config;
    }

    @Override
    public Vector<String> retornaUFs() {
        Vector<String> ufs;
        block11: {
            ufs = new Vector<String>();
            ufs.add(0, "-- Selecione --");
            try {
                Util util = new Util();
                if (!SessionFacadeImpl.isDbf()) {
                    Conexao con = util.conectarSiceb();
                    con.conect();
                    String sql = "select sg_uf from dbgeral.tb_uf order by sg_uf";
                    ResultSet rs = null;
                    Statement stm = con.getC().createStatement();
                    rs = stm.executeQuery(sql);
                    while (rs.next()) {
                        ufs.add(rs.getString("sg_uf"));
                    }
                    con.disconect();
                    break block11;
                }
                DBFReader reader = SessionFacadeImpl.retornaObjetoDbfCaminhoArquivo("UF", "dbf\\");
                if (reader == null) {
                    Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, "Erro ao carregar as UFs. Verifique se existe a pasta DBF e se os arquivo UF.DBF est\u00e1 l\u00e1:\n");
                    throw new NullPointerException("N\u00e3o foi poss\u00edvel carregar as UFs. Verifique se a pasta DBF existe e se o arquivo UF.DBF est\u00e1 l\u00e1!\n");
                }
                DBFUtil utilDbf = new DBFUtil();
                try {
                    Object[] rowObjects;
                    utilDbf.mapearPosicoes(reader);
                    Vector<String> ufsdbf = new Vector<String>();
                    if (this.isBrasil()) {
                        ufs.add("Brasil");
                    }
                    if (this.isTemOpcaoTodasUFs()) {
                        ufs.add("TODAS");
                    }
                    while ((rowObjects = reader.nextRecord()) != null) {
                        ufsdbf.add(utilDbf.getString(rowObjects, "SG_UF"));
                    }
                    Collections.sort(ufsdbf);
                    for (int i = 0; i < ufsdbf.size(); ++i) {
                        ufs.add((String)ufsdbf.get(i));
                    }
                }
                catch (DBFException e) {
                    Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, "Erro: tabela uf.dbf nao encontrada. Verifique se existe a pasta DBF e se os arquivo UF.DBF est\u00e1 l\u00e1:" + (Object)((Object)e));
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return ufs;
    }

    public Vector<String> retornaRegioes(String UF2) {
        String SG_UF = UF2;
        UF2 = String.valueOf(this.getCodigoUf(UF2));
        Vector<String> regionais = new Vector<String>();
        try {
            Util util = new Util();
            if (!SessionFacadeImpl.isDbf()) {
                Conexao con = util.conectarSiceb();
                con.conect();
                String sql = "select no_regional from dblocalidade.tb_regional_svs where co_uf_ibge=" + UF2 + " and no_regional not like '%ignorado%' order by no_regional";
                ResultSet rs = null;
                Statement stm = con.getC().createStatement();
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    regionais.add(rs.getString("no_regional"));
                }
                con.disconect();
            } else {
                DBFReader reader = SessionFacadeImpl.retornaObjetoDbfCaminhoArquivo("REGIAO", "dbf\\");
                DBFUtil utilDbf = new DBFUtil();
                try {
                    Object[] rowObjects;
                    utilDbf.mapearPosicoes(reader);
                    while ((rowObjects = reader.nextRecord()) != null) {
                        if (!SG_UF.equals(utilDbf.getString(rowObjects, "SG_UF"))) continue;
                        regionais.add(utilDbf.getString(rowObjects, "NM_REGIAO"));
                    }
                    Collections.sort(regionais);
                    regionais.add(0, "-- Selecione --");
                    regionais.add(1, "TODAS");
                }
                catch (DBFException e) {
                    Master.mensagem("Erro ao carregar regionais. Verifique se existe a pasta DBF e se os arquivo REGIONET.DBF est\u00e1 l\u00e1:\n" + (Object)((Object)e));
                    System.out.println("Erro ao carregar REGIONAIS: " + (Object)((Object)e));
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        return regionais;
    }

    @Override
    public Vector<String> retornaRegionais(String UF2) {
        String SG_UF = UF2;
        UF2 = String.valueOf(this.getCodigoUf(UF2));
        Vector<String> regionais = new Vector<String>();
        try {
            Util util = new Util();
            if (!SessionFacadeImpl.isDbf()) {
                Conexao con = util.conectarSiceb();
                con.conect();
                String sql = "select no_regional from dblocalidade.tb_regional_svs where co_uf_ibge=" + UF2 + " and no_regional not like '%ignorado%' order by no_regional";
                ResultSet rs = null;
                Statement stm = con.getC().createStatement();
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    regionais.add(rs.getString("no_regional"));
                }
                con.disconect();
            } else {
                DBFReader reader = SessionFacadeImpl.retornaObjetoDbfCaminhoArquivo("REGIONET", "dbf\\");
                DBFUtil utilDbf = new DBFUtil();
                try {
                    Object[] rowObjects;
                    utilDbf.mapearPosicoes(reader);
                    while ((rowObjects = reader.nextRecord()) != null) {
                        if (!SG_UF.equals(utilDbf.getString(rowObjects, "SG_UF"))) continue;
                        regionais.add(utilDbf.getString(rowObjects, "NM_REGIONA"));
                    }
                    Collections.sort(regionais);
                    regionais.add(0, "-- Selecione --");
                    regionais.add(1, "TODAS");
                }
                catch (DBFException e) {
                    Master.mensagem("Erro ao carregar regionais. Verifique se existe a pasta DBF e se os arquivo REGIONET.DBF est\u00e1 l\u00e1:\n" + (Object)((Object)e));
                    System.out.println("Erro ao carregar REGIONAIS: " + (Object)((Object)e));
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        return regionais;
    }

    @Override
    public Vector<String> retornaMunicipios(String UF2) {
        String sgUf = UF2;
        UF2 = String.valueOf(this.getCodigoUf(UF2));
        Vector<String> municipios = new Vector<String>();
        municipios.add(0, "-- Selecione --");
        try {
            Util util = new Util();
            if (!SessionFacadeImpl.isDbf()) {
                Conexao con = util.conectarSiceb();
                con.conect();
                String sql = "select no_municipio from dbgeral.tb_municipio where co_uf_ibge=" + UF2 + " and (no_municipio not like '%IGNORADO%' and no_municipio not like '%ignorado%' and no_municipio not like '%Ignorado%')  order by no_municipio";
                ResultSet rs = null;
                Statement stm = con.getC().createStatement();
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    municipios.add(rs.getString("no_municipio"));
                }
                con.disconect();
            } else {
                DBFReader reader = SessionFacadeImpl.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
                DBFUtil utilDbf = new DBFUtil();
                try {
                    Object[] rowObjects;
                    utilDbf.mapearPosicoes(reader);
                    while ((rowObjects = reader.nextRecord()) != null) {
                        if (!sgUf.equals(utilDbf.getString(rowObjects, "SG_UF")) || utilDbf.getString(rowObjects, "NM_MUNICIP").startsWith("IGNORADO") || utilDbf.getString(rowObjects, "NM_MUNICIP").lastIndexOf("TRANSF.") != -1 || (!utilDbf.getString(rowObjects, "SG_UF").equals("DF") || !utilDbf.getString(rowObjects, "NM_MUNICIP").equals("BRASILIA")) && utilDbf.getString(rowObjects, "SG_UF").equals("DF")) continue;
                        municipios.add(utilDbf.getString(rowObjects, "NM_MUNICIP"));
                    }
                    Collections.sort(municipios);
                }
                catch (DBFException e) {
                    Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, "Erro ao carregar municipios:\n" + (Object)((Object)e));
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.isTodosMunicipios()) {
            municipios.add(1, "TODOS");
        }
        return municipios;
    }

    public Vector<String> retornaMunicipiosCOAP(int indexNivelDesagregacao, String UF2, String regional) {
        String codUf = String.valueOf(this.getCodigoUf(UF2));
        String codRegional = "";
        try {
            codRegional = String.valueOf(this.getCodRegionalCOAP(regional, UF2));
        }
        catch (SQLException e) {
            System.out.println(e);
        }
        Vector<String> municipios = new Vector<String>();
        municipios.add(0, "-- Selecione --");
        try {
            Util util = new Util();
            if (!regional.equals("-- Selecione --") && !regional.equals("TODAS") && indexNivelDesagregacao >= 2) {
                if (!SessionFacadeImpl.isDbf()) {
                    Conexao con = util.conectarSiceb();
                    con.conect();
                    String sql = "select no_municipio from dbgeral.tb_municipio as t1, dblocalidade.rl_regional_municipio_svs as t2 where t2.co_uf_ibge=" + codUf + " and t1.co_municipio_ibge=t2.co_municipio_ibge and co_regional = '" + codRegional + "' and (no_municipio not like '%Ignorado%' and no_municipio not like '%IGNORADO%')  order by no_municipio";
                    ResultSet rs = null;
                    Statement stm = con.getC().createStatement();
                    rs = stm.executeQuery(sql);
                    while (rs.next()) {
                        municipios.add(rs.getString("no_municipio"));
                    }
                    con.disconect();
                } else {
                    DBFReader reader = SessionFacadeImpl.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
                    DBFUtil utilDbf = new DBFUtil();
                    try {
                        Object[] rowObjects;
                        utilDbf.mapearPosicoes(reader);
                        while ((rowObjects = reader.nextRecord()) != null) {
                            if (!codRegional.equals(utilDbf.getString(rowObjects, "ID_REGIAO")) || utilDbf.getString(rowObjects, "NM_MUNICIP").startsWith("IGNORADO") || utilDbf.getString(rowObjects, "NM_MUNICIP").lastIndexOf("TRANSF.") != -1 || (!utilDbf.getString(rowObjects, "SG_UF").equals("DF") || !utilDbf.getString(rowObjects, "NM_MUNICIP").equals("BRASILIA")) && utilDbf.getString(rowObjects, "SG_UF").equals("DF")) continue;
                            municipios.add(utilDbf.getString(rowObjects, "NM_MUNICIP"));
                        }
                        Collections.sort(municipios);
                    }
                    catch (DBFException e) {
                        Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, "Erro ao carregar municipios:\n" + (Object)((Object)e));
                    }
                }
            } else {
                this.retornaMunicipios(UF2);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.isTodosMunicipios()) {
            municipios.add(1, "TODOS");
        }
        return municipios;
    }

    public Vector<String> retornaMunicipiosPQAVS(String UF2, String regional) {
        String codUf = String.valueOf(this.getCodigoUf(UF2));
        String codRegional = "";
        try {
            codRegional = String.valueOf(this.getCodRegionalCOAP(regional, UF2));
        }
        catch (SQLException e) {
            System.out.println(e);
        }
        Vector<String> municipios = new Vector<String>();
        municipios.add(0, "-- Selecione --");
        try {
            Util util = new Util();
            if (!regional.equals("-- Selecione --") && !regional.equals("TODAS")) {
                if (!SessionFacadeImpl.isDbf()) {
                    Conexao con = util.conectarSiceb();
                    con.conect();
                    String sql = "select no_municipio from dbgeral.tb_municipio as t1, dblocalidade.rl_regional_municipio_svs as t2 where t2.co_uf_ibge=" + codUf + " and t1.co_municipio_ibge=t2.co_municipio_ibge and co_regional = '" + codRegional + "' and (no_municipio not like '%Ignorado%' and no_municipio not like '%IGNORADO%')  order by no_municipio";
                    ResultSet rs = null;
                    Statement stm = con.getC().createStatement();
                    rs = stm.executeQuery(sql);
                    while (rs.next()) {
                        municipios.add(rs.getString("no_municipio"));
                    }
                    con.disconect();
                } else {
                    DBFReader reader = SessionFacadeImpl.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
                    DBFUtil utilDbf = new DBFUtil();
                    try {
                        Object[] rowObjects;
                        utilDbf.mapearPosicoes(reader);
                        while ((rowObjects = reader.nextRecord()) != null) {
                            if (!codRegional.equals(utilDbf.getString(rowObjects, "ID_REGIAO")) || utilDbf.getString(rowObjects, "NM_MUNICIP").startsWith("IGNORADO") || utilDbf.getString(rowObjects, "NM_MUNICIP").lastIndexOf("TRANSF.") != -1 || (!utilDbf.getString(rowObjects, "SG_UF").equals("DF") || !utilDbf.getString(rowObjects, "NM_MUNICIP").equals("BRASILIA")) && utilDbf.getString(rowObjects, "SG_UF").equals("DF")) continue;
                            municipios.add(utilDbf.getString(rowObjects, "NM_MUNICIP"));
                        }
                        Collections.sort(municipios);
                    }
                    catch (DBFException e) {
                        Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, "Erro ao carregar municipios:\n" + (Object)((Object)e));
                    }
                }
            } else {
                this.retornaMunicipios(UF2);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.isTodosMunicipios()) {
            municipios.add(1, "TODOS");
        }
        return municipios;
    }

    public Vector<String> retornaMunicipiosPQAVS(int indexNivelDesagregacao, String UF2, String regional) {
        String codUf = String.valueOf(this.getCodigoUf(UF2));
        String codRegional = "";
        try {
            codRegional = String.valueOf(this.getCodRegionalCOAP(regional, UF2));
        }
        catch (SQLException e) {
            System.out.println(e);
        }
        Vector<String> municipios = new Vector<String>();
        municipios.add(0, "-- Selecione --");
        try {
            Util util = new Util();
            if (!regional.equals("-- Selecione --") && !regional.equals("TODAS") && indexNivelDesagregacao >= 2) {
                if (!SessionFacadeImpl.isDbf()) {
                    Conexao con = util.conectarSiceb();
                    con.conect();
                    String sql = "select no_municipio from dbgeral.tb_municipio as t1, dblocalidade.rl_regional_municipio_svs as t2 where t2.co_uf_ibge=" + codUf + " and t1.co_municipio_ibge=t2.co_municipio_ibge and co_regional = '" + codRegional + "' and (no_municipio not like '%Ignorado%' and no_municipio not like '%IGNORADO%')  order by no_municipio";
                    ResultSet rs = null;
                    Statement stm = con.getC().createStatement();
                    rs = stm.executeQuery(sql);
                    while (rs.next()) {
                        municipios.add(rs.getString("no_municipio"));
                    }
                    con.disconect();
                } else {
                    DBFReader reader = SessionFacadeImpl.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
                    DBFUtil utilDbf = new DBFUtil();
                    try {
                        Object[] rowObjects;
                        utilDbf.mapearPosicoes(reader);
                        while ((rowObjects = reader.nextRecord()) != null) {
                            if (!codRegional.equals(utilDbf.getString(rowObjects, "ID_REGIAO")) || utilDbf.getString(rowObjects, "NM_MUNICIP").startsWith("IGNORADO") || utilDbf.getString(rowObjects, "NM_MUNICIP").lastIndexOf("TRANSF.") != -1 || (!utilDbf.getString(rowObjects, "SG_UF").equals("DF") || !utilDbf.getString(rowObjects, "NM_MUNICIP").equals("BRASILIA")) && utilDbf.getString(rowObjects, "SG_UF").equals("DF")) continue;
                            municipios.add(utilDbf.getString(rowObjects, "NM_MUNICIP"));
                        }
                        Collections.sort(municipios);
                    }
                    catch (DBFException e) {
                        Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, "Erro ao carregar municipios:\n" + (Object)((Object)e));
                    }
                }
            } else {
                this.retornaMunicipios(UF2);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.isTodosMunicipios()) {
            municipios.add(1, "TODOS");
        }
        return municipios;
    }

    public Vector<String> retornaMunicipiosPactuacao(int isRegiao, String UF2, String regional) {
        String codUf = String.valueOf(this.getCodigoUf(UF2));
        String codReg = "";
        String nomeVar = "ID_REGIONA";
        try {
            if (isRegiao == 1) {
                codReg = String.valueOf(this.getCodRegiao(regional, UF2, "Pactuacao"));
                nomeVar = "ID_REGIAO";
            } else if (isRegiao == 2) {
                codReg = String.valueOf(this.getCodRegional(regional, UF2, "Pactuacao"));
            }
        }
        catch (SQLException e) {
            System.out.println(e);
        }
        Vector<String> municipios = new Vector<String>();
        municipios.add(0, "-- Selecione --");
        try {
            Util util = new Util();
            if (!(regional.equals("-- Selecione --") || regional.equals("TODAS") || codReg.isEmpty())) {
                if (!SessionFacadeImpl.isDbf()) {
                    Conexao con = util.conectarSiceb();
                    con.conect();
                    String sql = "select no_municipio from dbgeral.tb_municipio as t1, dblocalidade.rl_regional_municipio_svs as t2 where t2.co_uf_ibge=" + codUf + " and t1.co_municipio_ibge=t2.co_municipio_ibge and co_regional = '" + codReg + "' and (no_municipio not like '%Ignorado%' and no_municipio not like '%IGNORADO%')  order by no_municipio";
                    ResultSet rs = null;
                    Statement stm = con.getC().createStatement();
                    rs = stm.executeQuery(sql);
                    while (rs.next()) {
                        municipios.add(rs.getString("no_municipio"));
                    }
                    con.disconect();
                } else {
                    DBFReader reader = SessionFacadeImpl.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
                    DBFUtil utilDbf = new DBFUtil();
                    try {
                        Object[] rowObjects;
                        utilDbf.mapearPosicoes(reader);
                        while ((rowObjects = reader.nextRecord()) != null) {
                            if (!codReg.equals(utilDbf.getString(rowObjects, nomeVar)) || utilDbf.getString(rowObjects, "NM_MUNICIP").startsWith("IGNORADO") || utilDbf.getString(rowObjects, "NM_MUNICIP").lastIndexOf("TRANSF.") != -1 || (!utilDbf.getString(rowObjects, "SG_UF").equals("DF") || !utilDbf.getString(rowObjects, "NM_MUNICIP").equals("BRASILIA")) && utilDbf.getString(rowObjects, "SG_UF").equals("DF")) continue;
                            municipios.add(utilDbf.getString(rowObjects, "NM_MUNICIP"));
                        }
                        Collections.sort(municipios);
                    }
                    catch (DBFException e) {
                        Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, "Erro ao carregar municipios:\n" + (Object)((Object)e));
                    }
                }
            } else {
                this.retornaMunicipios(UF2);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.isTodosMunicipios()) {
            municipios.add(1, "TODOS");
        }
        return municipios;
    }

    @Override
    public Vector<String> retornaMunicipios(String UF2, String regional) {
        String codUf = String.valueOf(this.getCodigoUf(UF2));
        String codRegional = "";
        try {
            codRegional = String.valueOf(this.getCodRegional(regional, UF2, this.relatorio));
        }
        catch (SQLException e) {
            System.out.println(e);
        }
        Vector<String> municipios = new Vector<String>();
        municipios.add(0, "-- Selecione --");
        try {
            Util util = new Util();
            if (!regional.equals("-- Selecione --") && !regional.equals("TODAS")) {
                if (!SessionFacadeImpl.isDbf()) {
                    Conexao con = util.conectarSiceb();
                    con.conect();
                    String sql = "select no_municipio from dbgeral.tb_municipio as t1, dblocalidade.rl_regional_municipio_svs as t2 where t2.co_uf_ibge=" + codUf + " and t1.co_municipio_ibge=t2.co_municipio_ibge and co_regional = '" + codRegional + "' and (no_municipio not like '%Ignorado%' and no_municipio not like '%IGNORADO%')  order by no_municipio";
                    ResultSet rs = null;
                    Statement stm = con.getC().createStatement();
                    rs = stm.executeQuery(sql);
                    while (rs.next()) {
                        municipios.add(rs.getString("no_municipio"));
                    }
                    con.disconect();
                } else {
                    DBFReader reader = SessionFacadeImpl.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
                    DBFUtil utilDbf = new DBFUtil();
                    try {
                        Object[] rowObjects;
                        utilDbf.mapearPosicoes(reader);
                        while ((rowObjects = reader.nextRecord()) != null) {
                            if (!codRegional.equals(utilDbf.getString(rowObjects, "ID_REGIONA")) || utilDbf.getString(rowObjects, "NM_MUNICIP").startsWith("IGNORADO") || utilDbf.getString(rowObjects, "NM_MUNICIP").lastIndexOf("TRANSF.") != -1 || (!utilDbf.getString(rowObjects, "SG_UF").equals("DF") || !utilDbf.getString(rowObjects, "NM_MUNICIP").equals("BRASILIA")) && utilDbf.getString(rowObjects, "SG_UF").equals("DF")) continue;
                            municipios.add(utilDbf.getString(rowObjects, "NM_MUNICIP"));
                        }
                        Collections.sort(municipios);
                    }
                    catch (DBFException e) {
                        Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, "Erro ao carregar municipios:\n" + (Object)((Object)e));
                    }
                }
            } else {
                this.retornaMunicipios(UF2);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.isTodosMunicipios()) {
            municipios.add(1, "TODOS");
        }
        return municipios;
    }

    @Override
    public int getCodigoUf(String UF2) {
        int codigo;
        block7: {
            codigo = 0;
            try {
                Util util = new Util();
                if (!SessionFacadeImpl.isDbf()) {
                    Conexao con = util.conectarSiceb();
                    con.conect();
                    String sql = "select co_uf_ibge from dbgeral.tb_uf where sg_uf='" + UF2 + "'";
                    ResultSet rs = null;
                    Statement stm = con.getC().createStatement();
                    rs = stm.executeQuery(sql);
                    while (rs.next()) {
                        codigo = rs.getInt("co_uf_ibge");
                    }
                    con.disconect();
                    break block7;
                }
                DBFReader reader = SessionFacadeImpl.retornaObjetoDbfCaminhoArquivo("UF", "dbf\\");
                DBFUtil utilDbf = new DBFUtil();
                try {
                    Object[] rowObjects;
                    utilDbf.mapearPosicoes(reader);
                    while ((rowObjects = reader.nextRecord()) != null) {
                        if (!UF2.equals(utilDbf.getString(rowObjects, "SG_UF"))) continue;
                        codigo = utilDbf.getInt(rowObjects, "ID_UF");
                    }
                }
                catch (DBFException e) {
                    Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, "Erro: uf nao encontrada.Verifique se existe a pasta DBF e se os arquivo UF.DBF est\u00e1 l\u00e1\n" + (Object)((Object)e));
                    System.out.println("Erro ao carregar municipios: " + (Object)((Object)e));
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return codigo;
    }

    @Override
    public String getCodMunicipio(String municipio, String UF2) {
        String codigo;
        block7: {
            codigo = "";
            try {
                Util util = new Util();
                if (!SessionFacadeImpl.isDbf()) {
                    Conexao con = util.conectarSiceb();
                    con.conect();
                    String sql = "select co_municipio_ibge from dbgeral.tb_municipio where sg_uf = '" + UF2 + "' and no_municipio = '" + municipio + "'";
                    ResultSet rs = null;
                    Statement stm = con.getC().createStatement();
                    rs = stm.executeQuery(sql);
                    while (rs.next()) {
                        codigo = rs.getString("co_municipio_ibge");
                    }
                    con.disconect();
                    break block7;
                }
                DBFReader reader = SessionFacadeImpl.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
                DBFUtil utilDbf = new DBFUtil();
                try {
                    Object[] rowObjects;
                    utilDbf.mapearPosicoes(reader);
                    while ((rowObjects = reader.nextRecord()) != null) {
                        if (!municipio.equals(utilDbf.getString(rowObjects, "NM_MUNICIP")) || !UF2.equals(utilDbf.getString(rowObjects, "SG_UF"))) continue;
                        codigo = utilDbf.getString(rowObjects, "ID_MUNICIP");
                    }
                }
                catch (DBFException e) {
                    Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, "Erro: uf nao encontrada.Verifique se existe a pasta DBF e se os arquivo MUNIC.DBF est\u00e1 l\u00e1\n" + (Object)((Object)e));
                    System.out.println("Erro ao carregar municipios: " + (Object)((Object)e));
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return codigo;
    }

    public static DBFReader retornaObjetoDbfCaminhoArquivo(String arquivo, String caminho) {
        DBFReader reader = null;
        FileInputStream inputStream = null;
        try {
            inputStream = System.getProperty("os.name").compareTo("Linux") == 0 ? new FileInputStream(caminho.replace("\\", "/") + arquivo + ".DBF") : new FileInputStream(caminho + arquivo + ".DBF");
        }
        catch (FileNotFoundException e) {
            Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, "Erro: tabela " + arquivo + ".dbf nao encontrada.\n" + e);
            return reader;
        }
        try {
            reader = new DBFReader((InputStream)inputStream);
        }
        catch (DBFException e) {
            Logger.getLogger(SessionFacadeImpl.class.getName()).log(Level.SEVERE, null, "Erro: tabela " + arquivo + ".dbf nao encontrada.\n" + (Object)((Object)e));
        }
        return reader;
    }

    public String getUf() {
        return this.uf;
    }

    public void setUf(String uf) {
        this.uf = uf;
    }

    public String getMunicipio() {
        return this.municipio;
    }

    public void setMunicipio(String municipio) {
        this.municipio = municipio;
    }

    public String getRelatorio() {
        return this.relatorio;
    }

    public void setRelatorio(String relatorio) {
        this.relatorio = relatorio;
    }

    public JProgressBar getJprogress() {
        return this.jprogress;
    }

    public JProgressBar getJprogressGeral() {
        return this.jprogressGeral;
    }

    public void setJprogress(JProgressBar jprogress) {
        this.jprogress = jprogress;
    }

    public void setJprogressGeral(JProgressBar jprogressGeral) {
        this.jprogressGeral = jprogressGeral;
    }

    public boolean isExportarDbf() {
        return this.exportarDbf;
    }

    public void setExportarDbf(boolean exportarDbf) {
        this.exportarDbf = exportarDbf;
    }

    public String getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(String dataInicio) {
        this.dataInicio = dataInicio;
    }

    public String getDataFim() {
        return this.dataFim;
    }

    public void setDataFim(String dataFim) {
        this.dataFim = dataFim;
    }

    public boolean isBrasil() {
        return this.brasil;
    }

    public void setBrasil(boolean brasil) {
        this.brasil = brasil;
    }

    public String getRegional() {
        return this.regional;
    }

    public void setRegional(String regional) {
        this.regional = regional;
    }

    public boolean isTodosMunicipios() {
        return this.todosMunicipios;
    }

    public void setTodosMunicipios(boolean todosMunicipios) {
        this.todosMunicipios = todosMunicipios;
    }

    public String getVersao() {
        return this.versao;
    }

    public void setVersao(String versao) {
        this.versao = versao;
    }

    public String getDataAvaliacao() {
        return this.dataAvaliacao;
    }

    public void setDataAvaliacao(String dataAvaliacao) {
        this.dataAvaliacao = dataAvaliacao;
    }

    public String getAnoAvaliado() {
        return this.anoAvaliado;
    }

    public void setAnoAvaliado(String anoAvaliado) {
        this.anoAvaliado = anoAvaliado;
    }

    public String getDtInicioAvaliacao() {
        return this.dtInicioAvaliacao;
    }

    public void setDtInicioAvaliacao(String dtInicioAvaliacao) {
        this.dtInicioAvaliacao = dtInicioAvaliacao;
    }

    public String getDtFimAvaliacao() {
        return this.dtFimAvaliacao;
    }

    public void setDtFimAvaliacao(String dtFimAvaliacao) {
        this.dtFimAvaliacao = dtFimAvaliacao;
    }

    public String getNomeAgravo() {
        return this.nomeAgravo;
    }

    public void setNomeAgravo(String nomeAgravo) {
        this.nomeAgravo = nomeAgravo;
    }

    public boolean isTemListagem() {
        return this.temListagem;
    }

    public void setTemListagem(boolean temListagem) {
        this.temListagem = temListagem;
    }

    public Map getParametros() {
        return this.parametros;
    }

    public void setParametros(Map parametros) {
        this.parametros = parametros;
    }

    public boolean isTemOpcaoTodasUFs() {
        return this.temOpcaoTodasUFs;
    }

    public void setTemOpcaoTodasUFs(boolean temOpcaoTodasUFs) {
        this.temOpcaoTodasUFs = temOpcaoTodasUFs;
    }

    public boolean isAuxiliar() {
        return this.auxiliar;
    }

    public void setAuxiliar(boolean auxiliar) {
        this.auxiliar = auxiliar;
    }

    public String getDtFimReceb() {
        return this.dtFimReceb;
    }

    public void setDtFimReceb(String dtFimReceb) {
        this.dtFimReceb = dtFimReceb;
    }

    public String getDtFimTransf() {
        return this.dtFimTransf;
    }

    public void setDtFimTransf(String dtFimTransf) {
        this.dtFimTransf = dtFimTransf;
    }

    public String getDtInicioReceb() {
        return this.dtInicioReceb;
    }

    public void setDtInicioReceb(String dtInicioReceb) {
        this.dtInicioReceb = dtInicioReceb;
    }

    public String getDtInicioTrasnf() {
        return this.dtInicioTrasnf;
    }

    public void setDtInicioTrasnf(String dtInicioTrasnf) {
        this.dtInicioTrasnf = dtInicioTrasnf;
    }
}

