/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import com.org.bd.DBFUtil;
import com.org.model.classes.ColunasDbf;
import com.org.model.classes.agravos.DengueLetalidade;
import com.org.model.classes.agravos.HanseniaseCoorte;
import com.org.model.classes.agravos.HanseniaseCoorteCura;
import com.org.model.classes.agravos.TuberculoseCoorte;
import com.org.model.classes.agravos.oportunidade.CasoOportunidade;
import com.org.model.classes.agravos.oportunidade.CasoOportunidadeCOAP;
import com.org.model.classes.agravos.oportunidade.CasoOportunidadePQAVS;
import com.org.negocio.Configuracao;
import com.org.negocio.Util;
import com.org.util.SinanUtil;
import com.org.view.Master;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.filechooser.FileNameExtensionFilter;

public class Agravo {
    private String nomeMunicipio;
    private String codMunicipio;
    private String numerador;
    private Integer numeradorInt;
    private Integer denominadorInt;
    private String denominador;
    private String periodo;
    private String taxa;
    private String tipoAgregacao;
    private String sqlNumeradorMunicipioEspecifico;
    private String sqlDenominadorMunicipioEspecifico;
    private String sqlNumeradorBeanMunicipios;
    private String sqlDenominadorBeanMunicipios;
    private String sqlNumeradorEstado;
    private String sqlDenominandorEstado;
    private String sqlNumeradorCompletitude;
    private String Titulo1;
    private String TextoCompletitude;
    private String TituloColuna;
    private String Rodape;
    private String Tipo;
    private int Multiplicador;
    private JLabel label;
    private String transfNaoEspecificada;
    private JProgressBar barraStatus;
    private JProgressBar barraStatusGeral;
    private HashMap<String, ColunasDbf> colunas;
    private Map parametros;
    private String caminhoJasper;
    private String[] ordemColunas;
    private Util util = new Util();
    private Configuracao conf = new Configuracao();
    private String arquivo;
    private String taxaEstadual;
    private List beans;
    private String percentualCompletitude;
    private boolean DBF;
    private String dataInicio;
    private String dataFim;
    private String dataAvaliacao;
    private List<CasoOportunidade> listagemCasos = new ArrayList<CasoOportunidade>();
    private List<CasoOportunidadeCOAP> listagemCasosCOAP = new ArrayList<CasoOportunidadeCOAP>();
    private List<CasoOportunidadePQAVS> listagemCasosPQAVS = new ArrayList<CasoOportunidadePQAVS>();
    private String anoAvaliado;
    private String dtInicioAvaliacao;
    private String dtFimAvaliacao;
    private String dtInicioTransf;
    private String dtFimTransf;
    private String dtInicioReceb;
    private String dtFimReceb;
    private String nomeAgravo;
    private boolean temListagem;
    private String uf;
    private String municipio;
    private String regional;
    private String codRegional;
    private String regiaoSaude;
    private String codRegiaoSaude;

    public Agravo() {
    }

    public Agravo(boolean isDbf) {
        this.setDBF(isDbf);
    }

    public void init(String tipo) {
    }

    public Agravo adicionaBrasil(Collection<Agravo> municipioBean) {
        DecimalFormat df = new DecimalFormat("0.00");
        Agravo agravoBean = new Agravo();
        agravoBean.setNomeMunicipio("BRASIL");
        agravoBean.setCodMunicipio("51");
        agravoBean.setNumerador("0");
        agravoBean.setDenominador("0");
        for (Agravo agravoUF : municipioBean) {
            agravoBean.setNumerador(String.valueOf(Integer.parseInt(agravoUF.getNumerador()) + Integer.parseInt(agravoBean.getNumerador())));
            agravoBean.setDenominador(String.valueOf(Integer.parseInt(agravoUF.getDenominador()) + Integer.parseInt(agravoBean.getDenominador())));
            if (agravoBean.getDenominador().equals("0")) {
                agravoBean.setTaxa("0.00");
                continue;
            }
            agravoBean.setTaxa(df.format(Double.parseDouble(agravoBean.getNumerador()) / Double.parseDouble(agravoBean.getDenominador()) * (double)this.getMultiplicador()));
        }
        return agravoBean;
    }

    public Agravo adicionaRegional(Collection<Agravo> municipioBean, String nomeRegional, String codRegional) {
        DecimalFormat df = new DecimalFormat("0.00");
        Agravo agravoBean = new Agravo();
        agravoBean.setNomeMunicipio(nomeRegional);
        agravoBean.setCodMunicipio(codRegional);
        agravoBean.setNumerador("0");
        agravoBean.setDenominador("0");
        for (Agravo agravoUF : municipioBean) {
            agravoBean.setNumerador(String.valueOf(Integer.parseInt(agravoUF.getNumerador()) + Integer.parseInt(agravoBean.getNumerador())));
            agravoBean.setDenominador(String.valueOf(Integer.parseInt(agravoUF.getDenominador()) + Integer.parseInt(agravoBean.getDenominador())));
            if (agravoBean.getDenominador().equals("0")) {
                agravoBean.setTaxa("0.00");
                continue;
            }
            agravoBean.setTaxa(df.format(Double.parseDouble(agravoBean.getNumerador()) / Double.parseDouble(agravoBean.getDenominador()) * (double)this.getMultiplicador()));
        }
        return agravoBean;
    }

    public Agravo adicionaTotal(Collection<Agravo> municipioBean, String codRegiao) {
        DecimalFormat df = new DecimalFormat("0");
        Agravo agravoBean = new Agravo();
        agravoBean.setNomeMunicipio("TOTAL");
        agravoBean.setCodMunicipio(codRegiao);
        agravoBean.setNumerador("0");
        agravoBean.setDenominador("0");
        agravoBean.setUf("");
        for (Agravo agravoUF : municipioBean) {
            agravoBean.setNumerador(String.valueOf(Integer.parseInt(agravoUF.getNumerador()) + Integer.parseInt(agravoBean.getNumerador())));
            agravoBean.setDenominador(String.valueOf(Integer.parseInt(agravoUF.getDenominador()) + Integer.parseInt(agravoBean.getDenominador())));
            if (agravoBean.getTaxa() == null || agravoUF.getTaxa() == null) {
                agravoBean.setTaxa("0");
                continue;
            }
            if (agravoUF.getTaxa().split(",").length > 1) {
                agravoUF.setTaxa(agravoUF.getTaxa().split(",")[0] + "." + agravoUF.getTaxa().split(",")[1]);
            }
            agravoBean.setTaxa(df.format(Double.parseDouble(agravoUF.getTaxa()) + Double.parseDouble(agravoBean.getTaxa())));
        }
        return agravoBean;
    }

    public String getNomeMunicipio(String codMunicipio) {
        DBFUtil utilDbf = new DBFUtil();
        String retorno = "";
        DBFReader readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
        try {
            Object[] rowObjects1;
            utilDbf.mapearPosicoes(readerMunicipio);
            while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                if (!codMunicipio.equals(utilDbf.getString(rowObjects1, "ID_MUNICIP"))) continue;
                retorno = utilDbf.getString(rowObjects1, "SG_UF") + " - " + utilDbf.getString(rowObjects1, "NM_MUNICIP");
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
        }
        return retorno;
    }

    public String getNomeMunicipioNormal(String codMunicipio) {
        DBFUtil utilDbf = new DBFUtil();
        String retorno = "";
        DBFReader readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
        try {
            Object[] rowObjects1;
            utilDbf.mapearPosicoes(readerMunicipio);
            while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                if (!codMunicipio.equals(utilDbf.getString(rowObjects1, "ID_MUNICIP"))) continue;
                retorno = utilDbf.getString(rowObjects1, "NM_MUNICIP");
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
        }
        return retorno;
    }

    public void initAdequadamente(String tipo) {
    }

    public String decodificaNome(String texto) {
        String s = "";
        for (int i = 0; i < texto.length(); ++i) {
            char chr = texto.charAt(i);
            int j = i;
            if (j == 0) {
                ++j;
            }
            int temp = chr + j % 24;
            char c = (char)temp;
            s = s + c;
        }
        return s;
    }

    public List getBeanMunicipioEspecifico(Connection con, Map parametros) throws SQLException {
        double denominador;
        double numerador;
        String municipio;
        DecimalFormat df2;
        DecimalFormat df;
        Agravo d1;
        ArrayList<Agravo> beans;
        block24: {
            ResultSet rs;
            PreparedStatement stm2;
            ResultSet rs2;
            if (this.isDBF()) {
                return this.getBeans();
            }
            this.getBarraStatus().setString("Aguarde... calculando munic\u00edpio: ");
            Statement stm = con.createStatement();
            Object noMunicipio = null;
            beans = new ArrayList<Agravo>();
            d1 = null;
            df = new DecimalFormat("0.00");
            df2 = new DecimalFormat(",###,##");
            municipio = parametros.get("parMunicipio").toString();
            if (this.getTipo().equals("dengueGrave")) {
                rs2 = con.createStatement().executeQuery("SELECT  count(*) as numerador FROM  dbsinan.tb_notificacao where co_cid = 'A90' and ds_semana_sintoma in (" + parametros.get("parDataInicio") + ") and co_uf_residencia= " + parametros.get("parUf").toString() + " and co_municipio_residencia = " + municipio + " and tp_evolucao_caso = '2' and tp_classificacao_final in (2,3,4)");
            } else {
                stm2 = con.prepareStatement(this.getSqlNumeradorMunicipioEspecifico());
                stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
                stm2.setDate(2, this.transformaDate(parametros.get("parDataFim").toString()));
                if (this.getTipo().equals("trabalhador")) {
                    stm2.setString(3, municipio);
                    stm2.setDate(4, this.transformaDate(parametros.get("parDataInicio").toString()));
                    stm2.setDate(5, this.transformaDate(parametros.get("parDataFim").toString()));
                    stm2.setString(6, parametros.get("parUf").toString());
                    stm2.setString(7, municipio);
                } else {
                    stm2.setString(3, parametros.get("parUf").toString());
                    stm2.setString(4, municipio);
                }
                rs2 = stm2.executeQuery();
            }
            rs2.next();
            numerador = rs2.getDouble("numerador");
            if (this.getTipo().equals("dengueGrave")) {
                rs = con.createStatement().executeQuery("SELECT  count(*) as denominador FROM  dbsinan.tb_notificacao where co_cid = 'A90' and ds_semana_sintoma in (" + parametros.get("parDataInicio") + ") and co_uf_residencia= " + parametros.get("parUf").toString() + " and co_municipio_residencia = " + municipio + " and  tp_classificacao_final in (2,3,4)");
            } else {
                stm2 = con.prepareStatement(this.getSqlDenominadorMunicipioEspecifico());
                if (this.getTipo().equals("populacao")) {
                    stm2.setString(1, municipio);
                    stm2.setString(2, parametros.get("parAno").toString());
                    int multiplicador = 100000;
                } else {
                    int multiplicador = 100;
                    if (!this.getTipo().equals("trabalhador")) {
                        stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
                        stm2.setDate(2, this.transformaDate(parametros.get("parDataFim").toString()));
                        stm2.setString(3, parametros.get("parUf").toString());
                        stm2.setString(4, municipio);
                    } else {
                        stm2.setString(1, municipio);
                        stm2.setString(2, parametros.get("parUf").toString());
                        stm2.setString(3, municipio);
                    }
                }
                rs = stm2.executeQuery();
            }
            rs.next();
            denominador = 0.0;
            if (this.getTipo().equals("populacao")) {
                try {
                    if (this.getTitulo1().equals("Taxa de incid\u00eancia de aids em menores de 5 anos de idade ")) {
                        denominador = this.getPopulacao(municipio, 5, parametros.get("parAno").toString());
                        break block24;
                    }
                    denominador = this.getPopulacao(municipio, 15, parametros.get("parAno").toString());
                }
                catch (DBFException ex) {
                    Logger.getLogger(Agravo.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                denominador = rs.getInt("denominador");
            }
        }
        d1 = new Agravo();
        d1.setCodMunicipio(municipio);
        d1.setNomeMunicipio(parametros.get("parNomeMunicipio").toString());
        if (this.getTipo().equals("sifilis") || this.getTipo().equals("trabalhador")) {
            if (this.getTipo().equals("trabalhador")) {
                d1.setNumerador(String.valueOf(NumberFormat.getNumberInstance().format(denominador)));
                d1.setDenominador(String.valueOf(NumberFormat.getNumberInstance().format(numerador)));
                if (denominador > 0.0) {
                    d1.setTaxa(String.valueOf(df.format((numerador - denominador) * 100.0 / denominador)));
                } else {
                    d1.setTaxa("0");
                }
            } else {
                d1.setNumerador(String.valueOf(NumberFormat.getNumberInstance().format(numerador)));
                d1.setDenominador(String.valueOf(NumberFormat.getNumberInstance().format(denominador)));
                d1.setTaxa(this.getTaxaSililis(con, parametros, null));
            }
        } else if (!String.valueOf(denominador).equals("0.0")) {
            d1.setNumerador(String.valueOf(df2.format(numerador)));
            d1.setDenominador(String.valueOf(NumberFormat.getNumberInstance().format(denominador)));
            d1.setTaxa(String.valueOf(df.format(numerador / denominador * (double)this.getMultiplicador())));
        } else {
            d1.setNumerador("0");
            d1.setDenominador("0");
            d1.setTaxa("0.00");
        }
        beans.add(d1);
        this.getBarraStatus().setString(null);
        return beans;
    }

    public String getTaxaSililis(Connection con, Map parametros, String municipio) throws SQLException {
        String sql = "SELECT  count(*) as taxa FROM  dbsinan.tb_notificacao where co_cid = 'A50.9' and (dt_diagnostico_sintoma BETWEEN ?  AND ?) and co_uf_residencia= ? ";
        if (parametros.get("nivelAgregacao").equals("Municipio") || municipio != null) {
            sql = sql + " and co_municipio_residencia = ? ";
        }
        PreparedStatement stm2 = con.prepareStatement(sql);
        stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
        stm2.setDate(2, this.transformaDate(parametros.get("parDataFim").toString()));
        stm2.setString(3, parametros.get("parUf").toString());
        if (parametros.get("nivelAgregacao").equals("Municipio") || municipio != null) {
            if (municipio != null) {
                stm2.setString(4, municipio);
            } else {
                stm2.setString(4, parametros.get("parMunicipio").toString());
            }
        }
        ResultSet rs = stm2.executeQuery();
        rs.next();
        return rs.getString("taxa");
    }

    public List getBeanMunicipios(Connection con, Map parametros) throws SQLException {
        ResultSet rs;
        if (this.isDBF()) {
            return this.getBeans();
        }
        Statement stm = con.createStatement();
        String noMunicipio = null;
        ArrayList<DengueLetalidade> beans = new ArrayList<DengueLetalidade>();
        DengueLetalidade d1 = null;
        DecimalFormat df = new DecimalFormat("0.00");
        DecimalFormat df2 = new DecimalFormat(",###,##");
        String sql = parametros.get("parNomeRegional").equals("-- Selecione --") || parametros.get("parNomeRegional").equals("") ? "select co_municipio_ibge,no_municipio from dbgeral.tb_municipio where sg_uf = '" + parametros.get("parSgUf") + "' order by no_municipio" : "select t1.co_municipio_ibge,no_municipio from dbgeral.tb_municipio as t1, dblocalidade.rl_regional_municipio_svs as t2 where t2.co_uf_ibge=" + parametros.get("parUf") + " and t1.co_municipio_ibge=t2.co_municipio_ibge and co_regional is null and no_municipio not like '%Ignorado%'  order by no_municipio";
        try {
            rs = stm.executeQuery(sql);
        }
        catch (Exception exception) {
            sql = parametros.get("parNomeRegional").equals("Todas Regionais") || parametros.get("parNomeRegional").equals("") ? "select co_municipio_ibge,no_municipio from dbgeral.tb_municipio where sg_uf = '" + parametros.get("parSgUf") + "' order by no_municipio" : "select t1.co_municipio_ibge,no_municipio from dbgeral.tb_municipio as t1, dblocalidade.rl_regional_municipio_svs as t2 where t2.co_uf_ibge=" + parametros.get("parUf") + " and t1.co_municipio_ibge=t2.co_municipio_ibge and co_regional = '" + parametros.get("parCodRegional") + "' and no_municipio not like '%Ignorado%'  order by no_municipio";
            rs = stm.executeQuery(sql);
        }
        while (rs.next()) {
            ResultSet rs2;
            String municipio = rs.getString("co_municipio_ibge");
            noMunicipio = rs.getString("no_municipio");
            this.getBarraStatus().setString("Calculando munic\u00edpio: " + noMunicipio);
            PreparedStatement stm2 = con.prepareStatement(this.getSqlNumeradorBeanMunicipios());
            if (this.getTipo().equals("dengueGrave")) {
                rs2 = con.createStatement().executeQuery("SELECT  count(*) as numerador FROM  dbsinan.tb_notificacao where co_cid = 'A90' and ds_semana_sintoma in (" + parametros.get("parDataInicio") + ") and co_uf_residencia= " + parametros.get("parUf").toString() + " and co_municipio_residencia = " + municipio + " and tp_evolucao_caso = '2' and tp_classificacao_final in (2,3,4)");
            } else {
                stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
                stm2.setDate(2, this.transformaDate(parametros.get("parDataFim").toString()));
                if (this.getTipo().equals("trabalhador")) {
                    stm2.setString(3, municipio);
                    stm2.setDate(4, this.transformaDate(parametros.get("parDataInicio").toString()));
                    stm2.setDate(5, this.transformaDate(parametros.get("parDataFim").toString()));
                    stm2.setString(6, parametros.get("parUf").toString());
                    stm2.setString(7, municipio);
                } else {
                    stm2.setString(3, parametros.get("parUf").toString());
                    stm2.setString(4, municipio);
                }
                rs2 = stm2.executeQuery();
            }
            rs2.next();
            double numerador = rs2.getDouble("numerador");
            if (this.getTipo().equals("dengueGrave")) {
                rs2 = con.createStatement().executeQuery("SELECT  count(*) as denominador FROM  dbsinan.tb_notificacao where co_cid = 'A90' and ds_semana_sintoma in (" + parametros.get("parDataInicio") + ") and co_uf_residencia= " + parametros.get("parUf").toString() + " and co_municipio_residencia = " + municipio + " and  tp_classificacao_final in (2,3,4)");
            } else {
                int multiplicador;
                stm2 = con.prepareStatement(this.getSqlDenominadorBeanMunicipios());
                if (this.getTipo().equals("populacao")) {
                    stm2.setString(1, municipio);
                    stm2.setString(2, parametros.get("parAno").toString());
                    multiplicador = 100000;
                } else {
                    multiplicador = 100;
                    if (!this.getTipo().equals("trabalhador")) {
                        stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
                        stm2.setDate(2, this.transformaDate(parametros.get("parDataFim").toString()));
                        stm2.setString(3, parametros.get("parUf").toString());
                        stm2.setString(4, municipio);
                    } else {
                        stm2.setString(1, municipio);
                        stm2.setString(2, parametros.get("parUf").toString());
                        stm2.setString(3, municipio);
                    }
                }
                rs2 = stm2.executeQuery();
            }
            rs2.next();
            try {
                double denominador;
                block29: {
                    denominador = 0.0;
                    if (this.getTipo().equals("populacao")) {
                        try {
                            if (this.getTitulo1().equals("Taxa de incid\u00eancia de aids em menores de 5 anos de idade ")) {
                                denominador = this.getPopulacao(municipio, 5, parametros.get("parAno").toString());
                                break block29;
                            }
                            denominador = this.getPopulacao(municipio, 15, parametros.get("parAno").toString());
                        }
                        catch (DBFException ex) {
                            Logger.getLogger(Agravo.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } else {
                        denominador = rs2.getDouble("denominador");
                    }
                }
                d1 = new DengueLetalidade();
                d1.setCodMunicipio(municipio);
                d1.setNomeMunicipio(noMunicipio);
                if (this.getTipo().equals("sifilis") || this.getTipo().equals("trabalhador")) {
                    if (this.getTipo().equals("trabalhador")) {
                        d1.setNumerador(String.valueOf(NumberFormat.getNumberInstance().format(denominador)));
                        d1.setDenominador(String.valueOf(NumberFormat.getNumberInstance().format(numerador)));
                        if (denominador > 0.0) {
                            d1.setTaxa(String.valueOf(df.format((numerador - denominador) * 100.0 / denominador)));
                        } else {
                            d1.setTaxa("0");
                        }
                    } else {
                        d1.setNumerador(String.valueOf(NumberFormat.getNumberInstance().format(numerador)));
                        d1.setDenominador(String.valueOf(NumberFormat.getNumberInstance().format(denominador)));
                        d1.setTaxa(this.getTaxaSililis(con, parametros, municipio));
                    }
                } else if (!String.valueOf(denominador).equals("0.0")) {
                    d1.setNumerador(String.valueOf(df2.format(numerador)));
                    d1.setDenominador(String.valueOf(NumberFormat.getNumberInstance().format(denominador)));
                    d1.setTaxa(String.valueOf(df.format(numerador / denominador * (double)this.getMultiplicador())));
                } else {
                    d1.setNumerador("0");
                    d1.setDenominador("0");
                    d1.setTaxa("0.00");
                }
                beans.add(d1);
            }
            catch (Exception exception) {
                System.out.println(municipio + "\n" + exception);
            }
        }
        this.getBarraStatus().setString(null);
        return beans;
    }

    public List getBeanEstadoEspecifico(Connection con, Map parametros) throws SQLException {
        double denominador;
        double numerador;
        DecimalFormat df;
        Agravo d1;
        ArrayList<Agravo> beans;
        block26: {
            if (this.isDBF()) {
                return this.getBeans();
            }
            this.getBarraStatus().setString("Aguarde... calculando munic\u00edpio: ");
            ResultSet rs = null;
            ResultSet rs2 = null;
            Object municipio = null;
            beans = new ArrayList<Agravo>();
            d1 = null;
            df = new DecimalFormat("0.00");
            PreparedStatement stm2 = con.prepareStatement(this.getSqlNumeradorEstado());
            System.out.println("Numerador: " + this.getSqlNumeradorEstado());
            if (this.getTipo().equals("dengueGrave")) {
                rs2 = con.createStatement().executeQuery("SELECT  count(*) as numerador FROM  dbsinan.tb_notificacao where co_cid = 'A90' and ds_semana_sintoma in (" + parametros.get("parDataInicio") + ") and co_uf_residencia= " + parametros.get("parUf").toString() + " and tp_evolucao_caso = '2' and tp_classificacao_final in (2,3,4)");
                rs2.next();
            } else {
                stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
                stm2.setDate(2, this.transformaDate(parametros.get("parDataFim").toString()));
            }
            if (this.getTipo().equals("trabalhador")) {
                stm2.setString(3, parametros.get("parUf").toString() + '%');
                stm2.setDate(4, this.transformaDate(parametros.get("parDataInicio").toString()));
                stm2.setDate(5, this.transformaDate(parametros.get("parDataFim").toString()));
                stm2.setString(6, parametros.get("parUf").toString());
            } else {
                stm2.setString(3, parametros.get("parUf").toString());
            }
            if (!this.getTipo().equals("dengueGrave")) {
                rs2 = stm2.executeQuery();
                rs2.next();
            }
            numerador = rs2.getDouble("numerador");
            stm2 = con.prepareStatement(this.getSqlDenominandorEstado());
            System.out.println("Denominador: " + this.getSqlDenominandorEstado());
            if (this.getTipo().equals("populacao")) {
                stm2.setString(1, parametros.get("parUf").toString());
                stm2.setString(2, parametros.get("parAno").toString());
                int multiplicador = 100000;
            } else {
                int multiplicador = 100;
                if (!this.getTipo().equals("trabalhador")) {
                    if (this.getTipo().equals("dengueGrave")) {
                        rs = con.createStatement().executeQuery("SELECT  count(*) as denominador FROM  dbsinan.tb_notificacao where co_cid = 'A90' and ds_semana_sintoma in (" + parametros.get("parDataInicio") + ") and co_uf_residencia= " + parametros.get("parUf").toString() + " and  tp_classificacao_final in (2,3,4)");
                        rs.next();
                    } else {
                        stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
                        stm2.setDate(2, this.transformaDate(parametros.get("parDataFim").toString()));
                    }
                    stm2.setString(3, parametros.get("parUf").toString());
                } else {
                    stm2.setString(1, parametros.get("parUf").toString() + '%');
                    stm2.setString(2, parametros.get("parUf").toString());
                }
            }
            if (!this.getTipo().equals("dengueGrave")) {
                rs = stm2.executeQuery();
                rs.next();
            }
            denominador = 0.0;
            if (this.getTipo().equals("populacao")) {
                try {
                    if (this.getTitulo1().equals("Taxa de incid\u00eancia de aids em menores de 5 anos de idade ")) {
                        denominador = this.getPopulacao(parametros.get("parUf").toString(), 5, parametros.get("parAno").toString());
                        break block26;
                    }
                    denominador = this.getPopulacao(parametros.get("parUf").toString(), 15, parametros.get("parAno").toString());
                }
                catch (DBFException ex) {
                    Logger.getLogger(Agravo.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                denominador = rs.getDouble("denominador");
            }
        }
        d1 = new Agravo();
        d1.setCodMunicipio(parametros.get("parUf").toString());
        d1.setNomeMunicipio(parametros.get("parSgUf").toString());
        if (this.getTipo().equals("sifilis") || this.getTipo().equals("trabalhador")) {
            if (this.getTipo().equals("trabalhador")) {
                d1.setNumerador(String.valueOf(NumberFormat.getNumberInstance().format(denominador)));
                d1.setDenominador(String.valueOf(NumberFormat.getNumberInstance().format(numerador)));
                if (denominador > 0.0) {
                    d1.setTaxa(String.valueOf(df.format((numerador - denominador) * 100.0 / denominador)));
                } else {
                    d1.setTaxa("0");
                }
            } else {
                d1.setNumerador(String.valueOf(NumberFormat.getNumberInstance().format(numerador)));
                d1.setDenominador(String.valueOf(NumberFormat.getNumberInstance().format(denominador)));
                d1.setTaxa(this.getTaxaSililis(con, parametros, null));
            }
        } else if (!String.valueOf(denominador).equals("0.0")) {
            d1.setNumerador(String.valueOf(NumberFormat.getNumberInstance().format(numerador)));
            d1.setDenominador(String.valueOf(NumberFormat.getNumberInstance().format(denominador)));
            d1.setTaxa(String.valueOf(df.format(numerador / denominador * (double)this.getMultiplicador())));
        } else {
            d1.setNumerador("0");
            d1.setDenominador("0");
            d1.setTaxa("0.00");
        }
        beans.add(d1);
        this.getBarraStatus().setString(null);
        return beans;
    }

    public List getBeansEstadoEspecifico(Connection con, Map parametros) throws SQLException {
        if (parametros.get("municipios").equals("sim")) {
            return this.getBeanMunicipios(con, parametros);
        }
        return this.getBeanEstadoEspecifico(con, parametros);
    }

    public List getListaEstadoEspecifico(Connection con, Map parametros) throws SQLException {
        ArrayList beans = new ArrayList();
        return beans;
    }

    public List getListaMunicipioEspecifico(Connection con, Map parametros) throws SQLException {
        ArrayList beans = new ArrayList();
        return beans;
    }

    public List getListaMunicipioEspecifico(Map parametros) {
        if (this.isDBF()) {
            return this.getListaHanseniase(parametros);
        }
        ArrayList beans = new ArrayList();
        return beans;
    }

    public static File abreJanelaEscolherCaminho() {
        JFileChooser fileopen = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Arquivo DBF", "dbf");
        fileopen.addChoosableFileFilter(filter);
        int ret = fileopen.showDialog(null, "Abrir DBF");
        if (ret == 0) {
            File file = fileopen.getSelectedFile();
            System.out.println(file);
            return file;
        }
        return null;
    }

    public void calcula(DBFReader reader, Map parametros) {
    }

    public DBFReader getReader() {
        DBFReader reader = Util.retornaObjetoDbf(this.getConf().getCaminho());
        if (reader == null) {
            Agravo.abreJanelaEscolherCaminho();
        }
        return reader;
    }

    public String getTaxaEstado(Connection con, Map parametros) throws SQLException {
        if (this.isDBF()) {
            DBFReader reader = null;
            if (parametros.get("parVariosArquivos") == null && (reader = Util.retornaObjetoDbf(Configuracao.getPropriedade("caminho"))) == null) {
                Agravo.abreJanelaEscolherCaminho();
            }
            this.calcula(reader, parametros);
            return this.getTaxaEstadual();
        }
        Statement stm = con.createStatement();
        ResultSet rs2 = null;
        DecimalFormat df = new DecimalFormat("0.00");
        PreparedStatement stm2 = con.prepareStatement(this.getSqlNumeradorEstado());
        System.out.println(this.getSqlNumeradorEstado());
        if (this.getTipo().equals("dengueGrave")) {
            rs2 = con.createStatement().executeQuery("SELECT  count(*) as numerador FROM  dbsinan.tb_notificacao where co_cid = 'A90' and ds_semana_sintoma in (" + parametros.get("parDataInicio") + ") and co_uf_residencia= " + parametros.get("parUf").toString() + " and tp_evolucao_caso = '2' and tp_classificacao_final in (2,3,4)");
            rs2.next();
        } else {
            stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
            stm2.setDate(2, this.transformaDate(parametros.get("parDataFim").toString()));
        }
        if (this.getTipo().equals("trabalhador")) {
            stm2.setString(3, parametros.get("parUf").toString() + '%');
            stm2.setDate(4, this.transformaDate(parametros.get("parDataInicio").toString()));
            stm2.setDate(5, this.transformaDate(parametros.get("parDataFim").toString()));
            stm2.setString(6, parametros.get("parUf").toString());
        } else {
            stm2.setString(3, parametros.get("parUf").toString());
        }
        if (!this.getTipo().equals("dengueGrave")) {
            rs2 = stm2.executeQuery();
            rs2.next();
        }
        double numerador = rs2.getDouble("numerador");
        stm2 = con.prepareStatement(this.getSqlDenominandorEstado());
        if (this.getTipo().equals("populacao")) {
            stm2.setString(1, parametros.get("parUf").toString());
            stm2.setString(2, parametros.get("parAno").toString());
            int multiplicador = 100000;
        } else {
            int multiplicador = 100;
            if (!this.getTipo().equals("trabalhador")) {
                if (this.getTipo().equals("dengueGrave")) {
                    rs2 = con.createStatement().executeQuery("SELECT  count(*) as denominador FROM  dbsinan.tb_notificacao where co_cid = 'A90' and ds_semana_sintoma in (" + parametros.get("parDataInicio") + ") and co_uf_residencia= " + parametros.get("parUf").toString() + " and  tp_classificacao_final in (2,3,4)");
                    rs2.next();
                } else {
                    stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
                    stm2.setDate(2, this.transformaDate(parametros.get("parDataFim").toString()));
                }
                stm2.setString(3, parametros.get("parUf").toString());
            } else {
                stm2.setString(1, parametros.get("parUf").toString() + '%');
                stm2.setString(2, parametros.get("parUf").toString());
            }
        }
        if (!this.getTipo().equals("dengueGrave")) {
            rs2 = stm2.executeQuery();
            rs2.next();
        }
        double denominador = 0.0;
        if (this.getTipo().equals("populacao")) {
            try {
                denominador = this.getPopulacao(parametros.get("parUf").toString(), 5, parametros.get("parAno").toString());
            }
            catch (DBFException ex) {
                Logger.getLogger(Agravo.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            denominador = rs2.getDouble("denominador");
        }
        String total = !String.valueOf(denominador).equals("0.0") ? df.format(numerador / denominador * (double)this.getMultiplicador()) : "0";
        if (this.getTipo().equals("sifilis")) {
            return NumberFormat.getNumberInstance().format(numerador + denominador) + " (Menor que 1 ano:" + NumberFormat.getNumberInstance().format(numerador) + " | Sem informa\u00e7\u00e3o de idade: " + NumberFormat.getNumberInstance().format(denominador) + ")";
        }
        if (this.getTipo().equals("trabalhador")) {
            return df.format((numerador - denominador) * 100.0 / denominador);
        }
        return total + " (Numerador:" + numerador + " / Denominador: " + denominador + ")";
    }

    public Date transformaDate(String data) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = new Date(formatter.parse(data).getTime());
        }
        catch (Exception exception) {
            System.out.println("erro: parametro data no calculo do getTaxaEstado:" + exception);
        }
        return date;
    }

    public String getCompletitude(Connection con, Map parametros) throws SQLException {
        String total;
        if (this.isDBF()) {
            String total2 = "";
            total2 = this.getSqlNumeradorCompletitude().isEmpty() ? "" : this.getPercentualCompletitude();
            return this.getTextoCompletitude() + total2;
        }
        if (this.getSqlNumeradorCompletitude().isEmpty()) {
            total = "";
        } else {
            double numerador;
            Statement stm = con.createStatement();
            ResultSet rs = null;
            PreparedStatement stm2 = null;
            double denominador = 0.0;
            DecimalFormat df = new DecimalFormat("0.00");
            String complemento = "";
            if (parametros.get("nivelAgregacao").toString().equals("Municipio")) {
                complemento = " and t1.co_municipio_residencia = ?";
            }
            if (this.getTipo().equals("dengueGrave")) {
                String query = "SELECT  count(*) as numerador FROM  dbsinan.tb_notificacao where co_cid = 'A90' and ds_semana_sintoma in (" + parametros.get("parDataInicio") + ") and co_uf_residencia= " + parametros.get("parUf").toString() + " and tp_evolucao_caso is null and tp_classificacao_final in (2,3,4)";
                if (parametros.get("nivelAgregacao").toString().equals("Municipio")) {
                    query = query + " and co_municipio_residencia = " + parametros.get("parMunicipio").toString();
                }
                rs = con.createStatement().executeQuery(query);
                rs.next();
                numerador = rs.getDouble("numerador");
                query = "SELECT  count(*) as denominador FROM  dbsinan.tb_notificacao as t1 where co_cid = 'A90' and ds_semana_sintoma in (" + parametros.get("parDataInicio") + ") and co_uf_residencia= " + parametros.get("parUf").toString() + " and tp_classificacao_final in (2,3,4)";
                if (parametros.get("nivelAgregacao").toString().equals("Municipio")) {
                    query = query + " and co_municipio_residencia = " + parametros.get("parMunicipio").toString();
                }
                rs = con.createStatement().executeQuery(query);
                rs.next();
                denominador = rs.getDouble("denominador");
            } else {
                stm2 = con.prepareStatement(this.getSqlNumeradorCompletitude() + complemento);
                stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
                stm2.setDate(2, this.transformaDate(parametros.get("parDataFim").toString()));
                stm2.setString(3, parametros.get("parUf").toString());
                if (parametros.get("nivelAgregacao").toString().equals("Municipio")) {
                    stm2.setString(4, parametros.get("parMunicipio").toString());
                }
                rs = stm2.executeQuery();
                rs.next();
                numerador = rs.getDouble("numerador");
                PreparedStatement stm3 = con.prepareStatement(this.getSqlDenominandorEstado() + complemento);
                stm3.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
                stm3.setDate(2, this.transformaDate(parametros.get("parDataFim").toString()));
                stm3.setString(3, parametros.get("parUf").toString());
                if (parametros.get("nivelAgregacao").toString().equals("Municipio")) {
                    stm3.setString(4, parametros.get("parMunicipio").toString());
                }
                rs = stm3.executeQuery();
                rs.next();
                denominador = rs.getDouble("denominador");
            }
            total = !String.valueOf(denominador).equals("0.0") ? df.format(numerador / denominador * 100.0) : "0";
        }
        return this.getTextoCompletitude() + total;
    }

    public DBFWriter getLinhas(HashMap<String, ColunasDbf> colunas, List bean, DBFWriter writer) throws DBFException, IOException {
        return null;
    }

    public boolean isBetweenDates(java.util.Date dataParametro, String dataInicio, String dataFim) throws ParseException {
        java.util.Date dtInicio = this.convertToDate(dataInicio);
        java.util.Date dtFim = this.convertToDate(dataFim);
        return !(dataParametro == null || !dataParametro.after(dtInicio) && !dataParametro.equals(dtInicio) || !dataParametro.before(dtFim) && !dataParametro.equals(dtFim));
    }

    public static java.util.Date converterParaData(String data) throws ParseException {
        try {
            DateFormat dt = DateFormat.getDateInstance(3, Locale.US);
            java.util.Date date = dt.parse(data);
            return new java.util.Date(date.getTime());
        }
        catch (NumberFormatException ex) {
            Master.mensagem("Erro:\n" + ex);
        }
        catch (ParseException ex) {
            Master.mensagem("Erro:\n" + ex);
        }
        return null;
    }

    private java.util.Date convertToDate(String data) throws ParseException {
        try {
            String mes = data.substring(5, 7);
            String dia = data.substring(8, 10);
            String ano = data.substring(2, 4);
            String str = mes + "/" + dia + "/" + ano;
            DateFormat dt = DateFormat.getDateInstance(3, Locale.US);
            java.util.Date date = dt.parse(str);
            return new java.util.Date(date.getTime());
        }
        catch (NumberFormatException ex) {
            Master.mensagem("Erro:\n" + ex);
        }
        catch (ParseException ex) {
            Master.mensagem("Erro:\n" + ex);
        }
        return null;
    }

    public List<String> verificaMunicipio(String codRegional) {
        ArrayList<String> municipiosRegionais = new ArrayList<String>();
        if (codRegional.length() > 0) {
            DBFUtil utilDbf = new DBFUtil();
            DBFReader readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
            try {
                Object[] rowObjects1;
                utilDbf.mapearPosicoes(readerMunicipio);
                while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                    if (!codRegional.equals(utilDbf.getString(rowObjects1, "ID_REGIONA"))) continue;
                    municipiosRegionais.add(utilDbf.getString(rowObjects1, "ID_MUNICIP"));
                }
            }
            catch (DBFException e) {
                Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
            }
        }
        return municipiosRegionais;
    }

    public List<String> verificaMunicipioRegiaoSaude(String codRegiaoSaude) {
        ArrayList<String> municipiosRegiaoSaude = new ArrayList<String>();
        if (codRegiaoSaude.length() > 0) {
            DBFUtil utilDbf = new DBFUtil();
            DBFReader readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
            try {
                Object[] rowObjects1;
                utilDbf.mapearPosicoes(readerMunicipio);
                while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                    if (!codRegiaoSaude.equals(utilDbf.getString(rowObjects1, "ID_REGIAO"))) continue;
                    municipiosRegiaoSaude.add(utilDbf.getString(rowObjects1, "ID_MUNICIP"));
                }
            }
            catch (DBFException e) {
                Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
            }
        }
        return municipiosRegiaoSaude;
    }

    public HashMap<String, Agravo> populaMunicipiosBeans(String sgUfResidencia, String codRegional) {
        Agravo agravoDbf;
        Object[] rowObjects1;
        DBFReader readerMunicipio;
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap municipios = new HashMap();
        HashMap<String, Agravo> municipiosBeans = new HashMap<String, Agravo>();
        if (codRegional.length() > 0) {
            readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
            try {
                utilDbf.mapearPosicoes(readerMunicipio);
                while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                    if (!codRegional.equals(utilDbf.getString(rowObjects1, "ID_REGIONA")) || utilDbf.getString(rowObjects1, "NM_MUNICIP").startsWith("IGNORADO") || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("TRANSF.") != -1 || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("ATUAL BENTO GONCALVES") != -1 || (!utilDbf.getString(rowObjects1, "SG_UF").equals("DF") || !utilDbf.getString(rowObjects1, "NM_MUNICIP").equals("BRASILIA")) && utilDbf.getString(rowObjects1, "SG_UF").equals("DF")) continue;
                    agravoDbf = new Agravo();
                    agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_MUNICIP"));
                    agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    agravoDbf.setCodRegional(utilDbf.getString(rowObjects1, "ID_REGIONA"));
                    try {
                        agravoDbf.setRegional(this.buscaRegionalSaude(utilDbf.getString(rowObjects1, "ID_REGIONA")));
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(Agravo.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    agravoDbf.setDenominador("0");
                    agravoDbf.setNumerador("0");
                    agravoDbf.setDenominadorInt(0);
                    agravoDbf.setNumeradorInt(0);
                    municipios.put(utilDbf.getString(rowObjects1, "ID_MUNICIP"), utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipiosBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
                }
            }
            catch (DBFException e) {
                Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
            }
        } else {
            readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
            try {
                utilDbf.mapearPosicoes(readerMunicipio);
                while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                    if (!sgUfResidencia.equals(utilDbf.getString(rowObjects1, "SG_UF")) && !sgUfResidencia.equals("BR") || utilDbf.getString(rowObjects1, "NM_MUNICIP").startsWith("IGNORADO") || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("TRANSF.") != -1 || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("ATUAL BENTO GONCALVES") != -1 || (!utilDbf.getString(rowObjects1, "SG_UF").equals("DF") || !utilDbf.getString(rowObjects1, "NM_MUNICIP").equals("BRASILIA")) && utilDbf.getString(rowObjects1, "SG_UF").equals("DF")) continue;
                    agravoDbf = new Agravo();
                    agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_MUNICIP"));
                    agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    agravoDbf.setCodRegional(utilDbf.getString(rowObjects1, "ID_REGIONA"));
                    try {
                        agravoDbf.setRegional(this.buscaRegionalSaude(utilDbf.getString(rowObjects1, "ID_REGIONA")));
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(Agravo.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    agravoDbf.setDenominador("0");
                    agravoDbf.setNumerador("0");
                    municipios.put(utilDbf.getString(rowObjects1, "ID_MUNICIP"), utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipiosBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
                }
            }
            catch (DBFException e) {
                Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
            }
        }
        municipios = this.sortHashMapByValues(municipios, false);
        Set municipiosKeys = ((HashMap)municipios).keySet();
        HashMap<String, Agravo> municipiosBeansRetorno = new HashMap<String, Agravo>();
        for (String key : municipiosKeys) {
            municipiosBeansRetorno.put(key, (Agravo)municipiosBeans.get(key));
        }
        return municipiosBeansRetorno;
    }

    public HashMap<String, Agravo> populaMunicipiosBeansMAL(String sgUfResidencia, String codRegiao, String municipio, String regiao) {
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap municipios = new HashMap();
        HashMap<String, Agravo> municipiosBeans = new HashMap<String, Agravo>();
        DBFReader readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
        String sg_uf = "";
        Boolean sgUF = false;
        Boolean reg = false;
        Boolean temReg = false;
        Boolean temMunicipio = false;
        Boolean MunicipioIgual = false;
        Boolean somenteMunicipios = false;
        int i = 1;
        try {
            Object[] rowObjects1;
            utilDbf.mapearPosicoes(readerMunicipio);
            double TotalRegistros = Double.parseDouble(String.valueOf(readerMunicipio.getRecordCount()));
            while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                if (utilDbf.getString(rowObjects1, "SG_UF") != null && sgUfResidencia != "TODAS") {
                    sg_uf = utilDbf.getString(rowObjects1, "SG_UF");
                    sgUF = sg_uf.equals(sgUfResidencia);
                }
                if (regiao.equals("true")) {
                    if (utilDbf.getString(rowObjects1, "ID_REGIAO") != null) {
                        reg = utilDbf.getString(rowObjects1, "ID_REGIAO").equals(codRegiao);
                    }
                } else if (utilDbf.getString(rowObjects1, "ID_REGIONA") != null) {
                    reg = utilDbf.getString(rowObjects1, "ID_REGIONA").equals(codRegiao);
                }
                if (sgUfResidencia.equals("TODAS")) {
                    if (!codRegiao.isEmpty()) {
                        if (regiao.equals("true")) {
                            if (utilDbf.getString(rowObjects1, "ID_REGIAO") != null) {
                                temReg = true;
                            }
                        } else if (utilDbf.getString(rowObjects1, "ID_REGIONA") != null) {
                            temReg = true;
                        }
                    } else {
                        somenteMunicipios = true;
                    }
                }
                if (!municipio.equals("TODOS") && !municipio.equals("NENHUM")) {
                    temMunicipio = true;
                    MunicipioIgual = utilDbf.getString(rowObjects1, "ID_MUNICIP").equals(municipio);
                }
                if ((temReg.booleanValue() || somenteMunicipios.booleanValue() || sgUF.booleanValue() && codRegiao.length() == 0 || reg.booleanValue() && codRegiao.length() != 0) && (sg_uf.equals(sgUfResidencia) || sgUfResidencia.equals("TODAS")) && !utilDbf.getString(rowObjects1, "NM_MUNICIP").startsWith("IGNORADO") && utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("TRANSF.") == -1 && utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("ATUAL BENTO GONCALVES") == -1 && (!temMunicipio.booleanValue() || MunicipioIgual.booleanValue())) {
                    Agravo agravoDbf = new Agravo();
                    agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_MUNICIP"));
                    agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    agravoDbf.setUf(utilDbf.getString(rowObjects1, "SG_UF"));
                    if (regiao.equals("true")) {
                        agravoDbf.setCodRegiaoSaude(utilDbf.getString(rowObjects1, "ID_REGIAO"));
                    } else {
                        agravoDbf.setCodRegional(utilDbf.getString(rowObjects1, "ID_REGIONA"));
                    }
                    try {
                        if (regiao.equals("true")) {
                            agravoDbf.setRegiaoSaude(this.buscaRegiaoSaude(agravoDbf.getCodRegiaoSaude()));
                        } else {
                            agravoDbf.setRegional(this.buscaRegionalSaude(agravoDbf.getCodRegional()));
                        }
                        if (agravoDbf.getRegiaoSaude() == null) {
                            agravoDbf.setRegiaoSaude("");
                        }
                        if (agravoDbf.getRegional() == null) {
                            agravoDbf.setRegional("");
                        }
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(Agravo.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    agravoDbf.setDenominador("0");
                    agravoDbf.setNumerador("0");
                    agravoDbf.setNumeradorInt(0);
                    agravoDbf.setDenominadorInt(0);
                    municipios.put(utilDbf.getString(rowObjects1, "ID_MUNICIP"), utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipiosBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
                }
                temReg = false;
                float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                this.getBarraStatus().setString("Preparando arquivos... " + (int)percentual + "%");
                this.getBarraStatus().setValue((int)percentual);
                ++i;
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
        }
        this.getBarraStatus().setString(null);
        municipios = this.sortHashMapByValues(municipios, false);
        Set municipiosKeys = ((HashMap)municipios).keySet();
        HashMap<String, Agravo> municipiosBeansRetorno = new HashMap<String, Agravo>();
        for (String key : municipiosKeys) {
            municipiosBeansRetorno.put(key, (Agravo)municipiosBeans.get(key));
        }
        return municipiosBeansRetorno;
    }

    public HashMap<String, Agravo> populaMunicipiosBeansMAL(String sgUfResidencia, String codRegiao, String regiao) {
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap municipios = new HashMap();
        HashMap<String, Agravo> municipiosBeans = new HashMap<String, Agravo>();
        DBFReader readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
        Boolean sgUF = false;
        Boolean reg = false;
        Boolean temReg = false;
        Boolean temMunicipio = false;
        int i = 1;
        try {
            Object[] rowObjects1;
            utilDbf.mapearPosicoes(readerMunicipio);
            double TotalRegistros = Double.parseDouble(String.valueOf(readerMunicipio.getRecordCount()));
            while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                if (utilDbf.getString(rowObjects1, "SG_UF") != null && sgUfResidencia != "TODAS") {
                    sgUF = utilDbf.getString(rowObjects1, "SG_UF").equals(sgUfResidencia);
                }
                if (regiao.equals("true")) {
                    if (utilDbf.getString(rowObjects1, "ID_REGIAO") != null) {
                        reg = utilDbf.getString(rowObjects1, "ID_REGIAO").equals(codRegiao);
                    }
                } else if (utilDbf.getString(rowObjects1, "ID_REGIONA") != null) {
                    reg = utilDbf.getString(rowObjects1, "ID_REGIONA").equals(codRegiao);
                }
                if (sgUfResidencia.equals("TODAS")) {
                    if (regiao.equals("true")) {
                        if (utilDbf.getString(rowObjects1, "ID_REGIAO") != null) {
                            temReg = true;
                        }
                    } else if (utilDbf.getString(rowObjects1, "ID_REGIONA") != null) {
                        temReg = true;
                    }
                }
                if (temMunicipio.booleanValue()) {
                    // empty if block
                }
                if ((temReg.booleanValue() || sgUF.booleanValue() && codRegiao.length() == 0 || reg.booleanValue() && codRegiao.length() != 0) && !utilDbf.getString(rowObjects1, "NM_MUNICIP").startsWith("IGNORADO") && utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("TRANSF.") == -1 && utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("ATUAL BENTO GONCALVES") == -1) {
                    Agravo agravoDbf = new Agravo();
                    agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_MUNICIP"));
                    agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    agravoDbf.setUf(utilDbf.getString(rowObjects1, "SG_UF"));
                    if (regiao.equals("true")) {
                        agravoDbf.setCodRegiaoSaude(utilDbf.getString(rowObjects1, "ID_REGIAO"));
                    } else {
                        agravoDbf.setCodRegional(utilDbf.getString(rowObjects1, "ID_REGIONA"));
                    }
                    try {
                        if (regiao.equals("true")) {
                            agravoDbf.setRegiaoSaude(this.buscaRegiaoSaude(agravoDbf.getCodRegiaoSaude()));
                        } else {
                            agravoDbf.setRegional(this.buscaRegionalSaude(agravoDbf.getCodRegional()));
                        }
                        if (agravoDbf.getRegiaoSaude() == null) {
                            agravoDbf.setRegiaoSaude("");
                        }
                        if (agravoDbf.getRegional() == null) {
                            agravoDbf.setRegional("");
                        }
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(Agravo.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    agravoDbf.setDenominador("0");
                    agravoDbf.setNumerador("0");
                    agravoDbf.setNumeradorInt(0);
                    agravoDbf.setDenominadorInt(0);
                    municipios.put(utilDbf.getString(rowObjects1, "ID_MUNICIP"), utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipiosBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
                }
                temReg = false;
                float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                this.getBarraStatus().setValue((int)percentual);
                ++i;
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
        }
        municipios = this.sortHashMapByValues(municipios, false);
        Set municipiosKeys = ((HashMap)municipios).keySet();
        HashMap<String, Agravo> municipiosBeansRetorno = new HashMap<String, Agravo>();
        for (String key : municipiosKeys) {
            municipiosBeansRetorno.put(key, (Agravo)municipiosBeans.get(key));
        }
        return municipiosBeansRetorno;
    }

    public HashMap<String, Agravo> populaMunicipiosBeansPactuacao(String sgUfResidencia, String codRegiao) {
        Agravo agravoDbf;
        Object[] rowObjects1;
        DBFReader readerMunicipio;
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap municipios = new HashMap();
        HashMap<String, Agravo> municipiosBeans = new HashMap<String, Agravo>();
        if (codRegiao.length() > 0) {
            readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
            try {
                utilDbf.mapearPosicoes(readerMunicipio);
                while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                    if (!codRegiao.equals(utilDbf.getString(rowObjects1, "ID_REGIAO")) || utilDbf.getString(rowObjects1, "NM_MUNICIP").startsWith("IGNORADO") || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("TRANSF.") != -1 || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("ATUAL BENTO GONCALVES") != -1 || (!utilDbf.getString(rowObjects1, "SG_UF").equals("DF") || !utilDbf.getString(rowObjects1, "NM_MUNICIP").equals("BRASILIA")) && utilDbf.getString(rowObjects1, "SG_UF").equals("DF")) continue;
                    agravoDbf = new Agravo();
                    agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_MUNICIP"));
                    agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    agravoDbf.setUf(utilDbf.getString(rowObjects1, "SG_UF"));
                    agravoDbf.setCodRegiaoSaude(utilDbf.getString(rowObjects1, "ID_REGIAO"));
                    agravoDbf.setDenominador("0");
                    agravoDbf.setNumerador("0");
                    agravoDbf.setDenominadorInt(0);
                    agravoDbf.setNumeradorInt(0);
                    municipios.put(utilDbf.getString(rowObjects1, "ID_MUNICIP"), utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipiosBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
                }
            }
            catch (DBFException e) {
                Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
            }
        } else {
            readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
            try {
                utilDbf.mapearPosicoes(readerMunicipio);
                while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                    if (!sgUfResidencia.equals(utilDbf.getString(rowObjects1, "SG_UF")) && !sgUfResidencia.equals("BR") || utilDbf.getString(rowObjects1, "NM_MUNICIP").startsWith("IGNORADO") || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("TRANSF.") != -1 || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("ATUAL BENTO GONCALVES") != -1 || (!utilDbf.getString(rowObjects1, "SG_UF").equals("DF") || !utilDbf.getString(rowObjects1, "NM_MUNICIP").equals("BRASILIA")) && utilDbf.getString(rowObjects1, "SG_UF").equals("DF")) continue;
                    agravoDbf = new Agravo();
                    agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_MUNICIP"));
                    agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    agravoDbf.setUf(utilDbf.getString(rowObjects1, "SG_UF"));
                    agravoDbf.setCodRegiaoSaude(utilDbf.getString(rowObjects1, "ID_REGIAO"));
                    agravoDbf.setDenominador("0");
                    agravoDbf.setNumerador("0");
                    agravoDbf.setDenominadorInt(0);
                    agravoDbf.setNumeradorInt(0);
                    municipios.put(utilDbf.getString(rowObjects1, "ID_MUNICIP"), utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipiosBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
                }
            }
            catch (DBFException e) {
                Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
            }
        }
        municipios = this.sortHashMapByValues(municipios, false);
        Set municipiosKeys = ((HashMap)municipios).keySet();
        HashMap<String, Agravo> municipiosBeansRetorno = new HashMap<String, Agravo>();
        for (String key : municipiosKeys) {
            municipiosBeansRetorno.put(key, (Agravo)municipiosBeans.get(key));
        }
        return municipiosBeansRetorno;
    }

    public HashMap<String, TuberculoseCoorte> populaMunicipiosBeansTube(String sgUfResidencia, String codRegional) {
        TuberculoseCoorte agravoDbf;
        Object[] rowObjects1;
        DBFReader readerMunicipio;
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap municipios = new HashMap();
        HashMap<String, TuberculoseCoorte> municipiosBeans = new HashMap<String, TuberculoseCoorte>();
        if (codRegional.length() > 0) {
            readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
            try {
                utilDbf.mapearPosicoes(readerMunicipio);
                while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                    if (!codRegional.equals(utilDbf.getString(rowObjects1, "ID_REGIONA")) || utilDbf.getString(rowObjects1, "NM_MUNICIP").startsWith("IGNORADO") || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("TRANSF.") != -1 || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("ATUAL BENTO GONCALVES") != -1 || (!utilDbf.getString(rowObjects1, "SG_UF").equals("DF") || !utilDbf.getString(rowObjects1, "NM_MUNICIP").equals("BRASILIA")) && utilDbf.getString(rowObjects1, "SG_UF").equals("DF")) continue;
                    agravoDbf = new TuberculoseCoorte();
                    agravoDbf.init("");
                    agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_MUNICIP"));
                    agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipios.put(utilDbf.getString(rowObjects1, "ID_MUNICIP"), utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipiosBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
                }
            }
            catch (DBFException e) {
                Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
            }
        } else {
            readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
            try {
                utilDbf.mapearPosicoes(readerMunicipio);
                while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                    if (!sgUfResidencia.equals(utilDbf.getString(rowObjects1, "SG_UF")) && !sgUfResidencia.equals("BR") || utilDbf.getString(rowObjects1, "NM_MUNICIP").startsWith("IGNORADO") || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("TRANSF.") != -1 || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("ATUAL BENTO GONCALVES") != -1 || (!utilDbf.getString(rowObjects1, "SG_UF").equals("DF") || !utilDbf.getString(rowObjects1, "NM_MUNICIP").equals("BRASILIA")) && utilDbf.getString(rowObjects1, "SG_UF").equals("DF")) continue;
                    agravoDbf = new TuberculoseCoorte();
                    agravoDbf.init("");
                    agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_MUNICIP"));
                    agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipios.put(utilDbf.getString(rowObjects1, "ID_MUNICIP"), utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipiosBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
                }
            }
            catch (DBFException e) {
                Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
            }
        }
        municipios = this.sortHashMapByValues(municipios, false);
        Set municipiosKeys = ((HashMap)municipios).keySet();
        HashMap<String, TuberculoseCoorte> municipiosBeansRetorno = new HashMap<String, TuberculoseCoorte>();
        for (String key : municipiosKeys) {
            municipiosBeansRetorno.put(key, (TuberculoseCoorte)municipiosBeans.get(key));
        }
        return municipiosBeansRetorno;
    }

    public HashMap<String, Agravo> populaUfsBeans() {
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap uf = new HashMap();
        HashMap<String, Agravo> ufsBeans = new HashMap<String, Agravo>();
        DBFReader readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("UF", "dbf\\");
        try {
            Object[] rowObjects1;
            utilDbf.mapearPosicoes(readerMunicipio);
            while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                Agravo agravoDbf = new Agravo();
                agravoDbf.init("");
                agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_UF"));
                agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "SG_UF"));
                agravoDbf.setDenominador("0");
                agravoDbf.setNumerador("0");
                uf.put(utilDbf.getString(rowObjects1, "ID_UF"), utilDbf.getString(rowObjects1, "SG_UF"));
                ufsBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
        }
        uf = this.sortHashMapByValues(uf, false);
        Set ufKeys = ((HashMap)uf).keySet();
        HashMap<String, Agravo> ufsBeansRetorno = new HashMap<String, Agravo>();
        for (String key : ufKeys) {
            ufsBeansRetorno.put(key, (Agravo)ufsBeans.get(key));
        }
        return ufsBeansRetorno;
    }

    public HashMap<String, Agravo> populaRegiaoBeans(String SG_UF, String id_Regiao) {
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap regiao = new HashMap();
        HashMap<String, Agravo> RegBeans = new HashMap<String, Agravo>();
        Boolean sgUF = false;
        Boolean reg = false;
        Boolean temReg = false;
        DBFReader readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("REGIAO", "dbf\\");
        try {
            Object[] rowObjects1;
            utilDbf.mapearPosicoes(readerMunicipio);
            while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                if (utilDbf.getString(rowObjects1, "SG_UF") != null) {
                    sgUF = utilDbf.getString(rowObjects1, "SG_UF").equals(SG_UF);
                }
                if (utilDbf.getString(rowObjects1, "ID_REGIAO") != null) {
                    reg = utilDbf.getString(rowObjects1, "ID_REGIAO").equals(id_Regiao);
                }
                if ((SG_UF.equals("TODAS") || SG_UF.equalsIgnoreCase("Brasil") || SG_UF.equals("BR")) && utilDbf.getString(rowObjects1, "ID_REGIAO") != null) {
                    temReg = true;
                }
                String ufNot = utilDbf.getString(rowObjects1, "SG_UF");
                if (temReg.booleanValue() || sgUF.booleanValue() && id_Regiao.isEmpty() || reg.booleanValue() && !id_Regiao.isEmpty()) {
                    Agravo agravoDbf = new Agravo();
                    agravoDbf.init("");
                    agravoDbf.setUf(utilDbf.getString(rowObjects1, "SG_UF"));
                    agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_REGIAO"));
                    agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "NM_REGIAO"));
                    agravoDbf.setDenominador("0");
                    agravoDbf.setNumerador("0");
                    agravoDbf.setNumeradorInt(0);
                    agravoDbf.setDenominadorInt(0);
                    regiao.put(utilDbf.getString(rowObjects1, "ID_REGIAO"), utilDbf.getString(rowObjects1, "NM_REGIAO"));
                    RegBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
                }
                temReg = false;
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
        }
        regiao = this.sortHashMapByValues(regiao, false);
        Set RegKeys = ((HashMap)regiao).keySet();
        HashMap<String, Agravo> regBeansRetorno = new HashMap<String, Agravo>();
        for (String key : RegKeys) {
            regBeansRetorno.put(key, (Agravo)RegBeans.get(key));
        }
        return regBeansRetorno;
    }

    public HashMap<String, Agravo> populaRegionalBeans(String SG_UF, String id_Regiao) {
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap regiao = new HashMap();
        HashMap<String, Agravo> RegBeans = new HashMap<String, Agravo>();
        Boolean temReg = false;
        DBFReader readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("REGIONET", "dbf\\");
        try {
            Object[] rowObjects1;
            utilDbf.mapearPosicoes(readerMunicipio);
            while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                if ((SG_UF.equals("TODAS") || SG_UF.equalsIgnoreCase("Brasil") || SG_UF.equals("BR")) && utilDbf.getString(rowObjects1, "ID_REGIONA") != null) {
                    temReg = true;
                }
                if (temReg.booleanValue() || utilDbf.getString(rowObjects1, "SG_UF").equals(SG_UF) && id_Regiao.isEmpty() || !id_Regiao.isEmpty() && utilDbf.getString(rowObjects1, "ID_REGIONA").equals(id_Regiao)) {
                    Agravo agravoDbf = new Agravo();
                    agravoDbf.init("");
                    agravoDbf.setUf(utilDbf.getString(rowObjects1, "SG_UF"));
                    agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_REGIONA"));
                    agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "NM_REGIONA"));
                    agravoDbf.setDenominador("0");
                    agravoDbf.setNumerador("0");
                    agravoDbf.setNumeradorInt(0);
                    agravoDbf.setDenominadorInt(0);
                    regiao.put(utilDbf.getString(rowObjects1, "ID_REGIONA"), utilDbf.getString(rowObjects1, "NM_REGIONA"));
                    RegBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
                }
                temReg = false;
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
        }
        regiao = this.sortHashMapByValues(regiao, false);
        Set RegKeys = ((HashMap)regiao).keySet();
        HashMap<String, Agravo> regBeansRetorno = new HashMap<String, Agravo>();
        for (String key : RegKeys) {
            regBeansRetorno.put(key, (Agravo)RegBeans.get(key));
        }
        return regBeansRetorno;
    }

    public HashMap<String, TuberculoseCoorte> populaUfsBeansTube() {
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap uf = new HashMap();
        HashMap<String, TuberculoseCoorte> ufsBeans = new HashMap<String, TuberculoseCoorte>();
        DBFReader readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("UF", "dbf\\");
        try {
            Object[] rowObjects1;
            utilDbf.mapearPosicoes(readerMunicipio);
            while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                TuberculoseCoorte agravoDbf = new TuberculoseCoorte();
                agravoDbf.init("");
                agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_UF"));
                agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "SG_UF"));
                uf.put(utilDbf.getString(rowObjects1, "ID_UF"), utilDbf.getString(rowObjects1, "SG_UF"));
                ufsBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
        }
        uf = this.sortHashMapByValues(uf, false);
        Set ufKeys = ((HashMap)uf).keySet();
        HashMap<String, TuberculoseCoorte> ufsBeansRetorno = new HashMap<String, TuberculoseCoorte>();
        for (String key : ufKeys) {
            ufsBeansRetorno.put(key, (TuberculoseCoorte)ufsBeans.get(key));
        }
        return ufsBeansRetorno;
    }

    public HashMap<String, HanseniaseCoorte> populaUfsBeansHans() {
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap uf = new HashMap();
        HashMap<String, HanseniaseCoorte> ufsBeans = new HashMap<String, HanseniaseCoorte>();
        DBFReader readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("UF", "dbf\\");
        try {
            Object[] rowObjects1;
            utilDbf.mapearPosicoes(readerMunicipio);
            while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                HanseniaseCoorte agravoDbf = new HanseniaseCoorte();
                agravoDbf.init("");
                agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_UF"));
                agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "SG_UF"));
                uf.put(utilDbf.getString(rowObjects1, "ID_UF"), utilDbf.getString(rowObjects1, "SG_UF"));
                ufsBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
        }
        uf = this.sortHashMapByValues(uf, false);
        Set ufKeys = ((HashMap)uf).keySet();
        HashMap<String, HanseniaseCoorte> ufsBeansRetorno = new HashMap<String, HanseniaseCoorte>();
        for (String key : ufKeys) {
            ufsBeansRetorno.put(key, (HanseniaseCoorte)ufsBeans.get(key));
        }
        return ufsBeansRetorno;
    }

    public HashMap<String, HanseniaseCoorte> populaMunicipiosBeansHans(String sgUfResidencia, String codRegional) {
        HanseniaseCoorte agravoDbf;
        Object[] rowObjects1;
        DBFReader readerMunicipio;
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap municipios = new HashMap();
        HashMap<String, HanseniaseCoorte> municipiosBeans = new HashMap<String, HanseniaseCoorte>();
        if (codRegional.length() > 0) {
            readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
            try {
                utilDbf.mapearPosicoes(readerMunicipio);
                while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                    if (!codRegional.equals(utilDbf.getString(rowObjects1, "ID_REGIONA")) || utilDbf.getString(rowObjects1, "NM_MUNICIP").startsWith("IGNORADO") || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("TRANSF.") != -1 || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("ATUAL BENTO GONCALVES") != -1 || (!utilDbf.getString(rowObjects1, "SG_UF").equals("DF") || !utilDbf.getString(rowObjects1, "NM_MUNICIP").equals("BRASILIA")) && utilDbf.getString(rowObjects1, "SG_UF").equals("DF")) continue;
                    agravoDbf = new HanseniaseCoorte();
                    agravoDbf.init("");
                    agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_MUNICIP"));
                    agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipios.put(utilDbf.getString(rowObjects1, "ID_MUNICIP"), utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipiosBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
                }
            }
            catch (DBFException e) {
                Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
            }
        } else {
            readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
            try {
                utilDbf.mapearPosicoes(readerMunicipio);
                while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                    if (!sgUfResidencia.equals(utilDbf.getString(rowObjects1, "SG_UF")) && !sgUfResidencia.equals("BR") || utilDbf.getString(rowObjects1, "NM_MUNICIP").startsWith("IGNORADO") || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("TRANSF.") != -1 || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("ATUAL BENTO GONCALVES") != -1 || (!utilDbf.getString(rowObjects1, "SG_UF").equals("DF") || !utilDbf.getString(rowObjects1, "NM_MUNICIP").equals("BRASILIA")) && utilDbf.getString(rowObjects1, "SG_UF").equals("DF")) continue;
                    agravoDbf = new HanseniaseCoorte();
                    agravoDbf.init("");
                    agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_MUNICIP"));
                    agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipios.put(utilDbf.getString(rowObjects1, "ID_MUNICIP"), utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipiosBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
                }
            }
            catch (DBFException e) {
                Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
            }
        }
        municipios = this.sortHashMapByValues(municipios, false);
        Set municipiosKeys = ((HashMap)municipios).keySet();
        HashMap<String, HanseniaseCoorte> municipiosBeansRetorno = new HashMap<String, HanseniaseCoorte>();
        for (String key : municipiosKeys) {
            municipiosBeansRetorno.put(key, (HanseniaseCoorte)municipiosBeans.get(key));
        }
        return municipiosBeansRetorno;
    }

    public HashMap<String, HanseniaseCoorteCura> populaMunicipiosBeansHansCura(String sgUfResidencia, String codRegional) {
        HanseniaseCoorteCura agravoDbf;
        Object[] rowObjects1;
        DBFReader readerMunicipio;
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap municipios = new HashMap();
        HashMap<String, HanseniaseCoorteCura> municipiosBeans = new HashMap<String, HanseniaseCoorteCura>();
        if (codRegional.length() > 0) {
            readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
            try {
                utilDbf.mapearPosicoes(readerMunicipio);
                while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                    if (!codRegional.equals(utilDbf.getString(rowObjects1, "ID_REGIONA")) || utilDbf.getString(rowObjects1, "NM_MUNICIP").startsWith("IGNORADO") || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("TRANSF.") != -1 || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("ATUAL BENTO GONCALVES") != -1 || (!utilDbf.getString(rowObjects1, "SG_UF").equals("DF") || !utilDbf.getString(rowObjects1, "NM_MUNICIP").equals("BRASILIA")) && utilDbf.getString(rowObjects1, "SG_UF").equals("DF")) continue;
                    agravoDbf = new HanseniaseCoorteCura();
                    agravoDbf.init("");
                    agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_MUNICIP"));
                    agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipios.put(utilDbf.getString(rowObjects1, "ID_MUNICIP"), utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipiosBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
                }
            }
            catch (DBFException e) {
                Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
            }
        } else {
            readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
            try {
                utilDbf.mapearPosicoes(readerMunicipio);
                while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                    if (!sgUfResidencia.equals(utilDbf.getString(rowObjects1, "SG_UF")) && !sgUfResidencia.equals("BR") || utilDbf.getString(rowObjects1, "NM_MUNICIP").startsWith("IGNORADO") || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("TRANSF.") != -1 || utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("ATUAL BENTO GONCALVES") != -1 || (!utilDbf.getString(rowObjects1, "SG_UF").equals("DF") || !utilDbf.getString(rowObjects1, "NM_MUNICIP").equals("BRASILIA")) && utilDbf.getString(rowObjects1, "SG_UF").equals("DF")) continue;
                    agravoDbf = new HanseniaseCoorteCura();
                    agravoDbf.init("");
                    agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_MUNICIP"));
                    agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipios.put(utilDbf.getString(rowObjects1, "ID_MUNICIP"), utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                    municipiosBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
                }
            }
            catch (DBFException e) {
                Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
            }
        }
        municipios = this.sortHashMapByValues(municipios, false);
        Set municipiosKeys = ((HashMap)municipios).keySet();
        HashMap<String, HanseniaseCoorteCura> municipiosBeansRetorno = new HashMap<String, HanseniaseCoorteCura>();
        for (String key : municipiosKeys) {
            municipiosBeansRetorno.put(key, (HanseniaseCoorteCura)municipiosBeans.get(key));
        }
        return municipiosBeansRetorno;
    }

    public List getListaHanseniase(Map parametros) {
        ArrayList beans = new ArrayList();
        return beans;
    }

    public LinkedHashMap sortHashMapByValues(HashMap passedMap, boolean ascending) {
        ArrayList mapKeys = new ArrayList(passedMap.keySet());
        ArrayList mapValues = new ArrayList(passedMap.values());
        Collections.sort(mapValues);
        Collections.sort(mapKeys);
        if (!ascending) {
            Collections.reverse(mapValues);
        }
        LinkedHashMap someMap = new LinkedHashMap();
        block0: for (Object val : mapValues) {
            for (Object key : mapKeys) {
                if (!passedMap.get(key).toString().equals(val.toString())) continue;
                passedMap.remove(key);
                mapKeys.remove(key);
                someMap.put(key, val);
                continue block0;
            }
        }
        return someMap;
    }

    public static int dataDiff(java.util.Date dataLow, java.util.Date dataHigh) {
        GregorianCalendar startTime = new GregorianCalendar();
        GregorianCalendar endTime = new GregorianCalendar();
        GregorianCalendar curTime = new GregorianCalendar();
        GregorianCalendar baseTime = new GregorianCalendar();
        try {
            startTime.setTime(dataLow);
            endTime.setTime(dataHigh);
            int dif_multiplier = 1;
            if (dataLow.compareTo(dataHigh) < 0) {
                baseTime.setTime(dataHigh);
                curTime.setTime(dataLow);
                dif_multiplier = 1;
            } else {
                baseTime.setTime(dataLow);
                curTime.setTime(dataHigh);
                dif_multiplier = -1;
            }
            int result_years = 0;
            int result_months = 0;
            int result_days = 0;
            while (curTime.get(1) < baseTime.get(1) || curTime.get(2) < baseTime.get(2)) {
                int max_day = curTime.getActualMaximum(5);
                result_months += max_day;
                curTime.add(2, 1);
            }
            return result_years + (result_months *= dif_multiplier) + (result_days += endTime.get(5) - startTime.get(5));
        }
        catch (Exception e) {
            System.out.println(e);
            return -1;
        }
    }

    public boolean verificaMunicipio(String municipioResidencia, String municipio) {
        if (municipioResidencia.equals("")) {
            return true;
        }
        return municipioResidencia.equals(municipio);
    }

    public Double preencheAno(String dataInicio, String dataFim) {
        String ano = null;
        String[] arrayInicio = dataInicio.split("/");
        String[] arrayFim = dataFim.split("/");
        if (arrayFim[2].equals(arrayInicio[2])) {
            ano = arrayInicio[2];
        }
        if (ano != null) {
            return Double.parseDouble(ano);
        }
        return null;
    }

    public Double preencheAnoSemana(String semanaInicio, String semanaFim) {
        String ano = null;
        String anoInicio = semanaInicio.substring(0, 4);
        String anoFim = semanaFim.substring(0, 4);
        if (semanaInicio.substring(4, 6).equals("01") && semanaFim.substring(4, 6).equals("52") && anoInicio.equals(anoFim)) {
            ano = anoFim;
        }
        if (ano != null) {
            return Double.parseDouble(ano);
        }
        return null;
    }

    public int getPopulacao(String ufResidencia, int idade, String ano) throws DBFException {
        Object[] rowObjects;
        if (ufResidencia.length() == 2) {
            return this.getPopulacaoEstadual(ufResidencia, idade, ano);
        }
        double pop1 = 0.0;
        double pop1a4 = 0.0;
        double pop5a9 = 0.0;
        double pop10a14 = 0.0;
        DBFReader reader = Util.retornaObjetoDbfCaminhoArquivo("populacao" + ano, "dbf\\");
        DBFUtil utilDbf = new DBFUtil();
        utilDbf.mapearPosicoes(reader);
        while ((rowObjects = reader.nextRecord()) != null) {
            String municipioPesquisa = utilDbf.getString(rowObjects, "ID_MUNIC");
            if ((municipioPesquisa.length() <= 4 || ufResidencia.length() <= 4) && (municipioPesquisa.length() != 4 || ufResidencia.length() != 2) || !utilDbf.getString(rowObjects, "ID_MUNIC", ufResidencia.length()).equals(ufResidencia)) continue;
            pop1 = Double.parseDouble(utilDbf.getString(rowObjects, "NU_POP1ANO"));
            pop1a4 = Double.parseDouble(utilDbf.getString(rowObjects, "NU_POP1A4A"));
            pop5a9 = Double.parseDouble(utilDbf.getString(rowObjects, "NU_POP5A9A"));
            pop10a14 = Double.parseDouble(utilDbf.getString(rowObjects, "NU_POP10A1"));
        }
        if (idade > 5) {
            return (int)(pop1 + pop1a4 + pop5a9 + pop10a14);
        }
        return (int)(pop1 + pop1a4);
    }

    public int getPopulacaoEstadual(String ufResidencia, int idade, String ano) throws DBFException {
        Object[] rowObjects;
        double pop1 = 0.0;
        double pop1a4 = 0.0;
        double pop5a9 = 0.0;
        double pop10a14 = 0.0;
        double totalPop1a4 = 0.0;
        double totalPop1a14 = 0.0;
        DBFReader reader = Util.retornaObjetoDbfCaminhoArquivo("populacao" + ano, "dbf\\");
        DBFUtil utilDbf = new DBFUtil();
        utilDbf.mapearPosicoes(reader);
        while ((rowObjects = reader.nextRecord()) != null) {
            String municipioPesquisa = utilDbf.getString(rowObjects, "ID_MUNIC");
            if (municipioPesquisa.length() != 2 || !municipioPesquisa.equals(ufResidencia)) continue;
            pop1 = Double.parseDouble(utilDbf.getString(rowObjects, "NU_POP1ANO"));
            pop1a4 = Double.parseDouble(utilDbf.getString(rowObjects, "NU_POP1A4A"));
            pop5a9 = Double.parseDouble(utilDbf.getString(rowObjects, "NU_POP5A9A"));
            pop10a14 = Double.parseDouble(utilDbf.getString(rowObjects, "NU_POP10A1"));
            totalPop1a4 = pop1 + pop1a4;
            totalPop1a14 = pop1 + pop1a4 + pop5a9 + pop10a14;
            break;
        }
        if (idade > 5) {
            return (int)totalPop1a14;
        }
        return (int)totalPop1a4;
    }

    public String buscaRegionalSaude(String idRegiao) throws SQLException {
        if (idRegiao == null) {
            return "";
        }
        DBFReader reader = SinanUtil.retornaObjetoDbfCaminhoArquivo("REGIONET", "dbf\\");
        DBFUtil utilDbf = new DBFUtil();
        try {
            Object[] rowObjects;
            utilDbf.mapearPosicoes(reader);
            while ((rowObjects = reader.nextRecord()) != null) {
                if (!idRegiao.equals(utilDbf.getString(rowObjects, "ID_REGIONA"))) continue;
                return utilDbf.getString(rowObjects, "NM_REGIONA");
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro: regional nao encontrada.Verifique se existe a pasta DBF e se os arquivo REGIAO.DBF est\u00e1 l\u00e1:\n" + (Object)((Object)e));
        }
        return "";
    }

    public String buscaIdRegionalSaude(String idMunicipio) throws SQLException {
        if (idMunicipio == null) {
            return "";
        }
        DBFReader reader = SinanUtil.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
        DBFUtil utilDbf = new DBFUtil();
        try {
            Object[] rowObjects;
            utilDbf.mapearPosicoes(reader);
            while ((rowObjects = reader.nextRecord()) != null) {
                if (!idMunicipio.equals(utilDbf.getString(rowObjects, "ID_MUNICIP"))) continue;
                return utilDbf.getString(rowObjects, "ID_REGIONA");
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro: regional nao encontrada.Verifique se existe a pasta DBF e se os arquivo REGIAO.DBF est\u00e1 l\u00e1:\n" + (Object)((Object)e));
        }
        return "";
    }

    public String buscaRegiaoSaude(String idRegiao) throws SQLException {
        if (idRegiao == null) {
            return "";
        }
        DBFReader reader = SinanUtil.retornaObjetoDbfCaminhoArquivo("REGIAO", "dbf\\");
        DBFUtil utilDbf = new DBFUtil();
        try {
            Object[] rowObjects;
            utilDbf.mapearPosicoes(reader);
            while ((rowObjects = reader.nextRecord()) != null) {
                if (!idRegiao.equals(utilDbf.getString(rowObjects, "ID_REGIAO"))) continue;
                return utilDbf.getString(rowObjects, "NM_REGIAO");
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro: regional nao encontrada.Verifique se existe a pasta DBF e se os arquivo REGIAO.DBF est\u00e1 l\u00e1:\n" + (Object)((Object)e));
        }
        return "";
    }

    public String buscaIdRegiaoSaude(String idMunicipio) throws SQLException {
        if (idMunicipio == null) {
            return "";
        }
        DBFReader reader = SinanUtil.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
        DBFUtil utilDbf = new DBFUtil();
        try {
            Object[] rowObjects;
            utilDbf.mapearPosicoes(reader);
            while ((rowObjects = reader.nextRecord()) != null) {
                if (!idMunicipio.equals(utilDbf.getString(rowObjects, "ID_MUNICIP"))) continue;
                return utilDbf.getString(rowObjects, "ID_REGIAO");
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro: regional nao encontrada.Verifique se existe a pasta DBF e se os arquivo REGIAO.DBF est\u00e1 l\u00e1:\n" + (Object)((Object)e));
        }
        return "";
    }

    public List getBeansMunicipioEspecifico(Connection con, Map parametros) throws SQLException {
        return this.getBeanMunicipioEspecifico(con, parametros);
    }

    public String getNomeMunicipio() {
        return this.nomeMunicipio;
    }

    public void setNomeMunicipio(String nomeMunicipio) {
        this.nomeMunicipio = nomeMunicipio;
    }

    public String getCodMunicipio() {
        return this.codMunicipio;
    }

    public void setCodMunicipio(String codMunicipio) {
        this.codMunicipio = codMunicipio;
    }

    public String getNumerador() {
        if (this.numerador == null) {
            return "0";
        }
        return this.numerador;
    }

    public void setNumerador(String numerador) {
        this.numerador = numerador;
    }

    public String getTaxa() {
        return this.taxa;
    }

    public void setTaxa(String taxa) {
        this.taxa = taxa;
    }

    public String getDenominador() {
        return this.denominador;
    }

    public void setDenominador(String denominador) {
        this.denominador = denominador;
    }

    public String getSqlNumeradorMunicipioEspecifico() {
        return this.sqlNumeradorMunicipioEspecifico;
    }

    public void setSqlNumeradorMunicipioEspecifico(String sqlNumeradorMunicipioEspecifico) {
        this.sqlNumeradorMunicipioEspecifico = sqlNumeradorMunicipioEspecifico;
    }

    public String getSqlDenominadorMunicipioEspecifico() {
        return this.sqlDenominadorMunicipioEspecifico;
    }

    public void setSqlDenominadorMunicipioEspecifico(String sqlDenominadorMunicipioEspecifico) {
        this.sqlDenominadorMunicipioEspecifico = sqlDenominadorMunicipioEspecifico;
    }

    public String getSqlNumeradorBeanMunicipios() {
        return this.sqlNumeradorBeanMunicipios;
    }

    public void setSqlNumeradorBeanMunicipios(String sqlNumeradorBeanMunicipios) {
        this.sqlNumeradorBeanMunicipios = sqlNumeradorBeanMunicipios;
    }

    public String getSqlDenominadorBeanMunicipios() {
        return this.sqlDenominadorBeanMunicipios;
    }

    public void setSqlDenominadorBeanMunicipios(String sqlDenominadorBeanMunicipios) {
        this.sqlDenominadorBeanMunicipios = sqlDenominadorBeanMunicipios;
    }

    public String getSqlNumeradorEstado() {
        return this.sqlNumeradorEstado;
    }

    public String getSqlDenominandorEstado() {
        return this.sqlDenominandorEstado;
    }

    public void setSqlNumeradorEstado(String sqlNumeradorEstado) {
        this.sqlNumeradorEstado = sqlNumeradorEstado;
    }

    public void setSqlDenominandorEstado(String sqlDenominandorEstado) {
        this.sqlDenominandorEstado = sqlDenominandorEstado;
    }

    public String getSqlNumeradorCompletitude() {
        return this.sqlNumeradorCompletitude;
    }

    public int getMultiplicador() {
        return this.Multiplicador;
    }

    public void setMultiplicador(int Multiplicador) {
        this.Multiplicador = Multiplicador;
    }

    public void setSqlNumeradorCompletitude(String sqlNumeradorCompletitude) {
        this.sqlNumeradorCompletitude = sqlNumeradorCompletitude;
    }

    public String getTitulo1() {
        return this.Titulo1;
    }

    public void setTitulo1(String Titulo1) {
        this.Titulo1 = Titulo1;
    }

    public String getTextoCompletitude() {
        return this.TextoCompletitude;
    }

    public void setTextoCompletitude(String TextoCompletitude) {
        this.TextoCompletitude = TextoCompletitude;
    }

    public String getTituloColuna() {
        return this.TituloColuna;
    }

    public void setTituloColuna(String TituloColuna) {
        this.TituloColuna = TituloColuna;
    }

    public String getRodape() {
        return this.Rodape;
    }

    public void setRodape(String Rodape1) {
        this.Rodape = Rodape1;
    }

    public String getTipo() {
        return this.Tipo;
    }

    public void setTipo(String Tipo) {
        this.Tipo = Tipo;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setLabel(JLabel label) {
        this.label = label;
    }

    public String getTransfNaoEspecificada() {
        return this.transfNaoEspecificada;
    }

    public void setTransfNaoEspecificada(String transfNaoEspecificada) {
        this.transfNaoEspecificada = transfNaoEspecificada;
    }

    public JProgressBar getBarraStatus() {
        return this.barraStatus;
    }

    public void setBarraStatus(JProgressBar barraStatus) {
        this.barraStatus = barraStatus;
    }

    public HashMap<String, ColunasDbf> getColunas() {
        return this.colunas;
    }

    public void setColunas(HashMap<String, ColunasDbf> colunas) {
        this.colunas = colunas;
    }

    public Map getParametros() {
        return this.parametros;
    }

    public void setParametros(Map parametros) {
        this.parametros = parametros;
    }

    public String getCaminhoJasper() {
        return this.caminhoJasper;
    }

    public void setCaminhoJasper(String caminhoJasper) {
        this.caminhoJasper = caminhoJasper;
    }

    public String[] getOrdemColunas() {
        return this.ordemColunas;
    }

    public void setOrdemColunas(String[] ordemColunas) {
        this.ordemColunas = ordemColunas;
    }

    public Util getUtil() {
        return this.util;
    }

    public void setUtil(Util util) {
        this.util = util;
    }

    public Configuracao getConf() {
        return this.conf;
    }

    public void setConf(Configuracao conf) {
        this.conf = conf;
    }

    public String getArquivo() {
        return this.arquivo;
    }

    public void setArquivo(String arquivo) {
        this.arquivo = arquivo;
    }

    public String getTaxaEstadual() {
        return this.taxaEstadual;
    }

    public void setTaxaEstadual(String taxaEstadual) {
        this.taxaEstadual = taxaEstadual;
    }

    public List getBeans() {
        return this.beans;
    }

    public void setBeans(List beans) {
        this.beans = beans;
    }

    public String getPercentualCompletitude() {
        return this.percentualCompletitude;
    }

    public void setPercentualCompletitude(String percentualCompletitude) {
        this.percentualCompletitude = percentualCompletitude;
    }

    public boolean isDBF() {
        return this.DBF;
    }

    public void setDBF(boolean DBF2) {
        this.DBF = DBF2;
    }

    public String getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(String dataInicio) {
        this.dataInicio = dataInicio;
    }

    public String getDataFim() {
        return this.dataFim;
    }

    public void setDataFim(String dataFim) {
        this.dataFim = dataFim;
    }

    public String getDataAvaliacao() {
        return this.dataAvaliacao;
    }

    public void setDataAvaliacao(String dataAvaliacao) {
        this.dataAvaliacao = dataAvaliacao;
    }

    public String getAnoAvaliado() {
        return this.anoAvaliado;
    }

    public void setAnoAvaliado(String anoAvaliado) {
        this.anoAvaliado = anoAvaliado;
    }

    public String getDtInicioAvaliacao() {
        return this.dtInicioAvaliacao;
    }

    public void setDtInicioAvaliacao(String dtInicioAvaliacao) {
        this.dtInicioAvaliacao = dtInicioAvaliacao;
    }

    public String getDtFimAvaliacao() {
        return this.dtFimAvaliacao;
    }

    public void setDtFimAvaliacao(String dtFimAvaliacao) {
        this.dtFimAvaliacao = dtFimAvaliacao;
    }

    public String getNomeAgravo() {
        return this.nomeAgravo;
    }

    public void setNomeAgravo(String nomeAgravo) {
        this.nomeAgravo = nomeAgravo;
    }

    public boolean isTemListagem() {
        return this.temListagem;
    }

    public void setTemListagem(boolean temListagem) {
        this.temListagem = temListagem;
    }

    public String getUf() {
        return this.uf;
    }

    public void setUf(String uf) {
        this.uf = uf;
    }

    public String getMunicipio() {
        return this.municipio;
    }

    public void setMunicipio(String municipio) {
        this.municipio = municipio;
    }

    public String getRegional() {
        return this.regional;
    }

    public void setRegional(String regional) {
        this.regional = regional;
    }

    public List<CasoOportunidade> getListagemCasos() {
        return this.listagemCasos;
    }

    public void setListagemCasos(List<CasoOportunidade> listagemCasos) {
        this.listagemCasos = listagemCasos;
    }

    public List<CasoOportunidadeCOAP> getListagemCasosCOAP() {
        return this.listagemCasosCOAP;
    }

    public List<CasoOportunidadePQAVS> getListagemCasosPQAVS() {
        return this.listagemCasosPQAVS;
    }

    public void setListagemCasosCOAP(List<CasoOportunidadeCOAP> listagemCasosCOAP) {
        this.listagemCasosCOAP = listagemCasosCOAP;
    }

    public void setListagemCasosPQAVS(List<CasoOportunidadePQAVS> listagemCasosPQAVS) {
        this.listagemCasosPQAVS = listagemCasosPQAVS;
    }

    public String getPeriodo() {
        return this.periodo;
    }

    public void setPeriodo(String periodo) {
        this.periodo = periodo;
    }

    public String getTipoAgregacao() {
        return this.tipoAgregacao;
    }

    public void setTipoAgregacao(String tipoAgregacao) {
        this.tipoAgregacao = tipoAgregacao;
    }

    public Map populaSemana(Map parametros) {
        return null;
    }

    public JProgressBar getBarraStatusGeral() {
        return this.barraStatusGeral;
    }

    public void setBarraStatusGeral(JProgressBar barraStatusGeral) {
        this.barraStatusGeral = barraStatusGeral;
    }

    public String getDtFimReceb() {
        return this.dtFimReceb;
    }

    public void setDtFimReceb(String dtFimReceb) {
        this.dtFimReceb = dtFimReceb;
    }

    public String getDtFimTransf() {
        return this.dtFimTransf;
    }

    public void setDtFimTransf(String dtFimTransf) {
        this.dtFimTransf = dtFimTransf;
    }

    public String getDtInicioReceb() {
        return this.dtInicioReceb;
    }

    public void setDtInicioReceb(String dtInicioReceb) {
        this.dtInicioReceb = dtInicioReceb;
    }

    public String getDtInicioTransf() {
        return this.dtInicioTransf;
    }

    public void setDtInicioTransf(String dtInicioTransf) {
        this.dtInicioTransf = dtInicioTransf;
    }

    public String getRegiaoSaude() {
        return this.regiaoSaude;
    }

    public void setRegiaoSaude(String regiaoSaude) {
        this.regiaoSaude = regiaoSaude;
    }

    public String getCodRegional() {
        return this.codRegional;
    }

    public void setCodRegional(String codRegional) {
        this.codRegional = codRegional;
    }

    public String getCodRegiaoSaude() {
        return this.codRegiaoSaude;
    }

    public void setCodRegiaoSaude(String codRegiaoSaude) {
        this.codRegiaoSaude = codRegiaoSaude;
    }

    public Integer getNumeradorInt() {
        if (this.numeradorInt == null) {
            return 0;
        }
        return this.numeradorInt;
    }

    public void setNumeradorInt(Integer numeradorInt) {
        this.numeradorInt = numeradorInt;
    }

    public Integer getDenominadorInt() {
        if (this.denominadorInt == null) {
            return 0;
        }
        return this.denominadorInt;
    }

    public void setDenominadorInt(Integer denominadorInt) {
        this.denominadorInt = denominadorInt;
    }

    public String getCodIbgeUF(String sigla_uf) {
        switch (sigla_uf) {
            case "RO": {
                return "11";
            }
            case "AC": {
                return "12";
            }
            case "AM": {
                return "13";
            }
            case "RR": {
                return "14";
            }
            case "PA": {
                return "15";
            }
            case "AP": {
                return "16";
            }
            case "TO": {
                return "17";
            }
            case "MA": {
                return "21";
            }
            case "PI": {
                return "22";
            }
            case "CE": {
                return "23";
            }
            case "RN": {
                return "24";
            }
            case "PB": {
                return "25";
            }
            case "PE": {
                return "26";
            }
            case "AL": {
                return "27";
            }
            case "SE": {
                return "28";
            }
            case "BA": {
                return "29";
            }
            case "MG": {
                return "31";
            }
            case "ES": {
                return "32";
            }
            case "RJ": {
                return "33";
            }
            case "SP": {
                return "35";
            }
            case "PR": {
                return "41";
            }
            case "SC": {
                return "42";
            }
            case "RS": {
                return "43";
            }
            case "MS": {
                return "50";
            }
            case "MT": {
                return "51";
            }
            case "GO": {
                return "52";
            }
            case "DF": {
                return "53";
            }
        }
        return "";
    }

    public String getUFCodIbge(String cod_ibge) {
        switch (cod_ibge) {
            case "11": {
                return "RO";
            }
            case "12": {
                return "AC";
            }
            case "13": {
                return "AM";
            }
            case "14": {
                return "RR";
            }
            case "15": {
                return "PA";
            }
            case "16": {
                return "AP";
            }
            case "17": {
                return "TO";
            }
            case "21": {
                return "MA";
            }
            case "22": {
                return "PI";
            }
            case "23": {
                return "CE";
            }
            case "24": {
                return "RN";
            }
            case "25": {
                return "PB";
            }
            case "26": {
                return "PE";
            }
            case "27": {
                return "AL";
            }
            case "28": {
                return "SE";
            }
            case "29": {
                return "BA";
            }
            case "31": {
                return "MG";
            }
            case "32": {
                return "ES";
            }
            case "33": {
                return "RJ";
            }
            case "35": {
                return "SP";
            }
            case "41": {
                return "PR";
            }
            case "42": {
                return "SC";
            }
            case "43": {
                return "RS";
            }
            case "50": {
                return "MS";
            }
            case "51": {
                return "MT";
            }
            case "52": {
                return "GO";
            }
            case "53": {
                return "DF";
            }
        }
        return "";
    }
}

