/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes.agravos;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import com.org.bd.DBFUtil;
import com.org.model.classes.Agravo;
import com.org.model.classes.ColunasDbf;
import com.org.negocio.Configuracao;
import com.org.negocio.Util;
import com.org.view.Master;
import java.io.IOException;
import java.sql.Date;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;

public class AidsTaxaCrianca
extends Agravo {
    static String ANO;

    public AidsTaxaCrianca(boolean isDbf) {
        this.setDBF(isDbf);
        this.setPeriodo("de Diagn\u00f3stico");
        this.setTipoAgregacao("de Resid\u00eancia");
        this.init("postgres");
    }

    @Override
    public void init(String tipoBanco) {
        this.setArquivo("AIDSCNET");
        this.setTextoCompletitude("");
        this.setMultiplicador(100000);
        this.setTipo("");
        this.setTipo("populacao");
        this.setTitulo1("Taxa de incid\u00eancia de aids em menores de 5 anos de idade ");
        this.setTituloColuna("Taxa de Incid\u00eancia por 100.000");
        this.setRodape("Numerador: N\u00ba de casos de aids em menores de 5 anos diagnosticados em  determinado ano, por local de resid\u00eancia  \nDenominador: Popula\u00e7\u00e3o total residente de menores de 5 anos de idade nesse mesmo ano e local");
        this.setSqlNumeradorCompletitude("");
        if (!this.isDBF()) {
            this.setSqlNumeradorMunicipioEspecifico("select count(*) as numerador from dbsinan.tb_notificacao as t1, dbsinan.tb_investiga_aids_crianca as t2 where  t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao and nu_idade < 4005 and tp_criterio_definicao not in (900,901) and (t1.dt_diagnostico_sintoma BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and t1.co_municipio_residencia = ?");
            this.setSqlDenominadorMunicipioEspecifico("select nu_pop1a4anos+nu_pop1ano as denominador from dblocalidade.tb_estatistica_ibge where co_uf_municipio_ibge = ? and nu_ano = ?");
            this.setSqlNumeradorEstado("select count(*) as numerador from dbsinan.tb_notificacao as t1, dbsinan.tb_investiga_aids_crianca as t2 where  t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao and nu_idade < 4005 and tp_criterio_definicao not in (900,901) and (t1.dt_diagnostico_sintoma BETWEEN ?  AND ?) and t1.co_uf_residencia= ? ");
            this.setSqlDenominandorEstado(this.getSqlDenominadorMunicipioEspecifico());
            this.setSqlNumeradorBeanMunicipios(this.getSqlNumeradorMunicipioEspecifico());
            this.setSqlDenominadorBeanMunicipios(this.getSqlDenominadorMunicipioEspecifico());
        }
    }

    private void calculaBrasil(DBFReader reader, Map parametros) throws ParseException {
        String coluna;
        HashMap<Object, Object> municipiosBeans = new HashMap();
        DBFUtil utilDbf = new DBFUtil();
        if (parametros.get("municipios").toString().equals("sim")) {
            municipiosBeans = this.populaMunicipiosBeans("BR", "");
            coluna = "ID_MN_RESI";
        } else {
            municipiosBeans = this.populaUfsBeans();
            coluna = "SG_UF";
        }
        int completitude = 0;
        DecimalFormat df = new DecimalFormat("0.00");
        int numerador = 0;
        int numeradorEstadual = 0;
        int denominadorEstadual = 0;
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim = (String)parametros.get("parDataFim");
        String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
        for (int k = 0; k < arquivos.length; ++k) {
            int i = 1;
            try {
                Object[] rowObjects;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                utilDbf.mapearPosicoes(reader);
                double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    if (utilDbf.getString(rowObjects, coluna) != null) {
                        Agravo municipioResidencia = (Agravo)municipiosBeans.get(utilDbf.getString(rowObjects, coluna));
                        Date dtDiagnostico = utilDbf.getDate(rowObjects, "DT_DIAG");
                        String criterio = utilDbf.getString(rowObjects, "CRITERIO", 3);
                        int idade = Integer.parseInt(utilDbf.getString(rowObjects, "NU_IDADE_N", 4));
                        if (municipioResidencia != null && criterio != null) {
                            if (this.isBetweenDates(dtDiagnostico, dataInicio, dataFim) && idade < 4005 && idade > 0 && !criterio.equals("900") && !criterio.equals("901")) {
                                numerador = Integer.parseInt(municipioResidencia.getNumerador());
                                municipioResidencia.setNumerador(String.valueOf(++numerador));
                                ++numeradorEstadual;
                            }
                        } else if (criterio != null && this.isBetweenDates(dtDiagnostico, dataInicio, dataFim) && idade < 4005 && idade > 0 && !criterio.equals("900") && !criterio.equals("901")) {
                            ++numeradorEstadual;
                        }
                    }
                    float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                    this.getBarraStatus().setValue((int)percentual);
                    System.out.println(++i);
                }
                continue;
            }
            catch (DBFException ex) {
                Master.mensagem("Erro:\n" + (Object)((Object)ex));
            }
        }
        String ano = dataInicio.substring(0, 4);
        this.setTaxaEstadual("");
        this.setPercentualCompletitude(df.format(Double.parseDouble(String.valueOf(completitude)) / Double.parseDouble(String.valueOf(denominadorEstadual)) * 100.0));
        this.setBeans(new ArrayList());
        Collection<Object> municipioBean = municipiosBeans.values();
        for (Agravo agravo : municipioBean) {
            double num = Double.parseDouble(agravo.getNumerador());
            try {
                agravo.setDenominador(String.valueOf(this.getPopulacao(agravo.getCodMunicipio().toString(), 2, ano)));
            }
            catch (DBFException e) {
                System.out.println((Object)e);
            }
            double den = Double.parseDouble(agravo.getDenominador());
            if (den == 0.0) {
                agravo.setTaxa("0.00");
            } else {
                agravo.setTaxa(df.format(num / den * 100000.0));
            }
            this.getBeans().add(agravo);
            this.getBarraStatus().setString("Buscando pop. de: " + agravo.getNomeMunicipio());
        }
        this.getBarraStatus().setString(null);
        Collections.sort(this.getBeans(), new BeanComparator("nomeMunicipio"));
        this.getBeans().add(this.adicionaBrasil(municipioBean));
        if (!parametros.get("parSgUf").toString().equals("TODAS") && !parametros.get("municipios").toString().equals("sim")) {
            Agravo agravoBrasil = (Agravo)this.getBeans().get(27);
            ArrayList<Agravo> arrayList = new ArrayList<Agravo>();
            arrayList.add(agravoBrasil);
            this.setBeans(arrayList);
        }
    }

    private void calculaMunicipios(DBFReader reader, Map parametros) throws ParseException {
        HashMap<Object, Object> municipiosBeans = new HashMap();
        String ufResidencia = (String)parametros.get("parUf");
        String sgUfResidencia = (String)parametros.get("parSgUf");
        String codRegional = (String)parametros.get("parCodRegional");
        DBFUtil utilDbf = new DBFUtil();
        municipiosBeans = this.populaMunicipiosBeans(sgUfResidencia, codRegional);
        int completitude = 0;
        DecimalFormat df = new DecimalFormat("0.00");
        int numerador = 0;
        int numeradorEstadual = 0;
        int denominadorEstadual = 0;
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim = (String)parametros.get("parDataFim");
        String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
        for (int k = 0; k < arquivos.length; ++k) {
            int i = 1;
            try {
                Object[] rowObjects;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                utilDbf.mapearPosicoes(reader);
                double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    if (utilDbf.getString(rowObjects, "SG_UF") != null) {
                        Agravo municipioResidencia = (Agravo)municipiosBeans.get(utilDbf.getString(rowObjects, "ID_MN_RESI"));
                        Date dtDiagnostico = utilDbf.getDate(rowObjects, "DT_DIAG");
                        String criterio = utilDbf.getString(rowObjects, "CRITERIO", 3);
                        int idade = Integer.parseInt(utilDbf.getString(rowObjects, "NU_IDADE_N", 4));
                        if (municipioResidencia != null && criterio != null) {
                            if (this.isBetweenDates(dtDiagnostico, dataInicio, dataFim) && idade < 4005 && idade > 0 && !criterio.equals("900") && !criterio.equals("901")) {
                                numerador = Integer.parseInt(municipioResidencia.getNumerador());
                                municipioResidencia.setNumerador(String.valueOf(++numerador));
                                ++numeradorEstadual;
                            }
                        } else if (criterio != null && this.isBetweenDates(dtDiagnostico, dataInicio, dataFim) && idade < 4005 && idade > 0 && !criterio.equals("900") && !criterio.equals("901")) {
                            ++numeradorEstadual;
                        }
                    }
                    float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
                continue;
            }
            catch (DBFException ex) {
                Master.mensagem("Erro:\n" + (Object)((Object)ex));
            }
        }
        String ano = dataInicio.substring(0, 4);
        try {
            denominadorEstadual = this.getPopulacao(ufResidencia, 2, ano);
        }
        catch (DBFException e) {
            System.out.println((Object)e);
        }
        String total = df.format(Double.parseDouble(String.valueOf(numeradorEstadual)) / Double.parseDouble(String.valueOf(denominadorEstadual)) * 100000.0);
        this.setTaxaEstadual(total + " (Numerador:" + String.valueOf(numeradorEstadual) + " / Denominador: " + String.valueOf(denominadorEstadual) + ")");
        this.setPercentualCompletitude(df.format(Double.parseDouble(String.valueOf(completitude)) / Double.parseDouble(String.valueOf(denominadorEstadual)) * 100.0));
        this.setBeans(new ArrayList());
        Collection<Object> municipioBean = municipiosBeans.values();
        for (Agravo agravo : municipioBean) {
            double num = Double.parseDouble(agravo.getNumerador());
            try {
                agravo.setDenominador(String.valueOf(this.getPopulacao(agravo.getCodMunicipio().toString(), 2, ano)));
            }
            catch (DBFException e) {
                System.out.println((Object)e);
            }
            double den = Double.parseDouble(agravo.getDenominador());
            if (den == 0.0) {
                agravo.setTaxa("0.00");
            } else {
                agravo.setTaxa(df.format(num / den * 100000.0));
            }
            this.getBeans().add(agravo);
            this.getBarraStatus().setString("Buscando pop. de: " + agravo.getNomeMunicipio());
        }
        this.getBarraStatus().setString(null);
        Collections.sort(this.getBeans(), new BeanComparator("nomeMunicipio"));
    }

    @Override
    public void calcula(DBFReader reader, Map parametros) {
        String municipios = (String)parametros.get("municipios");
        String brasil = (String)parametros.get("parUf");
        if (municipios.equals("sim") && !brasil.equals("brasil")) {
            try {
                this.calculaMunicipios(reader, parametros);
            }
            catch (ParseException ex) {
                System.out.println(ex);
            }
        } else {
            try {
                if (brasil.equals("brasil")) {
                    this.calculaBrasil(reader, parametros);
                } else {
                    DBFUtil utilDbf = new DBFUtil();
                    int completitude = 0;
                    DecimalFormat df = new DecimalFormat("0.00");
                    int denominadorEstadual = 0;
                    int numeradorEstadual = 0;
                    int denominadorEspecifico = 0;
                    int numeradorEspecifico = 0;
                    String ufResidencia = (String)parametros.get("parUf");
                    String municipioResidencia = (String)parametros.get("parMunicipio");
                    if (municipioResidencia == null) {
                        municipioResidencia = "";
                    }
                    String dataInicio = (String)parametros.get("parDataInicio");
                    String dataFim = (String)parametros.get("parDataFim");
                    String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
                    for (int k = 0; k < arquivos.length; ++k) {
                        Object[] rowObjects;
                        int i = 1;
                        reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                        utilDbf.mapearPosicoes(reader);
                        double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                        while ((rowObjects = reader.nextRecord()) != null) {
                            if (utilDbf.getString(rowObjects, "SG_UF") != null && utilDbf.getString(rowObjects, "SG_UF").equals(ufResidencia)) {
                                Date dtDiagnostico = utilDbf.getDate(rowObjects, "DT_DIAG");
                                String criterio = utilDbf.getString(rowObjects, "CRITERIO", 3);
                                int idade = Integer.parseInt(utilDbf.getString(rowObjects, "NU_IDADE_N", 4));
                                if (this.verificaMunicipio(municipioResidencia, utilDbf.getString(rowObjects, "ID_MN_RESI")) && criterio != null) {
                                    if (this.isBetweenDates(dtDiagnostico, dataInicio, dataFim) && idade < 4005 && idade > 0 && !criterio.equals("900") && !criterio.equals("901")) {
                                        ++numeradorEspecifico;
                                        ++numeradorEstadual;
                                    }
                                } else if (criterio != null && this.isBetweenDates(dtDiagnostico, dataInicio, dataFim) && idade < 4005 && idade > 0 && !criterio.equals("900") && !criterio.equals("901")) {
                                    ++numeradorEstadual;
                                }
                            }
                            float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                            this.getBarraStatus().setValue((int)percentual);
                            ++i;
                        }
                    }
                    String ano = dataInicio.substring(0, 4);
                    denominadorEstadual = this.getPopulacao(ufResidencia, 2, ano);
                    denominadorEspecifico = municipioResidencia.length() == 0 ? denominadorEstadual : this.getPopulacao(municipioResidencia, 2, ano);
                    String total = df.format(Double.parseDouble(String.valueOf(numeradorEstadual)) / Double.parseDouble(String.valueOf(denominadorEstadual)) * 100000.0);
                    this.setTaxaEstadual(total + " (Numerador:" + String.valueOf(numeradorEstadual) + " / Denominador: " + String.valueOf(denominadorEstadual) + ")");
                    this.setPercentualCompletitude(df.format(Double.parseDouble(String.valueOf(completitude)) / Double.parseDouble(String.valueOf(denominadorEstadual)) * 100000.0));
                    Agravo d1 = new Agravo();
                    d1.setCodMunicipio((String)parametros.get("parMunicipio"));
                    if (municipioResidencia.equals("")) {
                        d1.setNomeMunicipio((String)parametros.get("parSgUf"));
                        d1.setCodMunicipio(ufResidencia);
                    } else {
                        d1.setNomeMunicipio((String)parametros.get("parNomeMunicipio"));
                        d1.setCodMunicipio(municipioResidencia);
                    }
                    if (!String.valueOf(denominadorEspecifico).equals("0.0")) {
                        d1.setNumerador(String.valueOf(NumberFormat.getNumberInstance().format(Double.parseDouble(String.valueOf(numeradorEspecifico)))));
                        d1.setDenominador(String.valueOf(NumberFormat.getNumberInstance().format(Double.parseDouble(String.valueOf(denominadorEspecifico)))));
                        total = df.format(Double.parseDouble(String.valueOf(numeradorEspecifico)) / Double.parseDouble(String.valueOf(denominadorEspecifico)) * 100000.0);
                        d1.setTaxa(total);
                    } else {
                        d1.setNumerador("0");
                        d1.setDenominador("0");
                        d1.setTaxa("0.00");
                    }
                    this.setBeans(new ArrayList());
                    this.getBeans().add(d1);
                }
            }
            catch (NumberFormatException ex) {
                System.out.println(ex);
            }
            catch (ParseException ex) {
                System.out.println(ex);
            }
            catch (DBFException ex) {
                System.out.println((Object)ex);
            }
        }
    }

    @Override
    public Map getParametros() {
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("parDataInicio", Util.formataData(this.getDataInicio()));
        parametros.put("parDataFim", Util.formataData(this.getDataFim()));
        parametros.put("parPeriodo", "de " + this.getDataInicio() + " a " + this.getDataFim());
        parametros.put("parTituloColuna", this.getTituloColuna());
        parametros.put("parFator", String.valueOf(this.getMultiplicador()));
        parametros.put("parAno", Util.getAno(this.getDataFim()));
        parametros.put("parRodape", this.getRodape());
        parametros.put("parConfig", "");
        parametros.put("parTitulo1", "Taxa de incid\u00eancia de aids em menores de 5 anos de idade ");
        ANO = "";
        if (Util.getAno(this.getDataFim()).equals(Util.getAno(this.getDataInicio()))) {
            ANO = Util.getAno(this.getDataFim());
        }
        this.setDataInicio(this.getDataInicio());
        this.setDataFim(this.getDataFim());
        return parametros;
    }

    @Override
    public String[] getOrdemColunas() {
        return new String[]{"ID_LOCRES", "DS_LOCRES", "ID_UFRES", "N_INCAIDS", "D_INCAIDS", "I_INCAIDS", "ANO_DIAG", "DT_DIAGIN", "DT_DIAGFI", "ORIGEM"};
    }

    @Override
    public HashMap<String, ColunasDbf> getColunas() {
        HashMap<String, ColunasDbf> hashColunas = new HashMap<String, ColunasDbf>();
        hashColunas.put("ID_LOCRES", new ColunasDbf(7));
        hashColunas.put("DS_LOCRES", new ColunasDbf(30));
        hashColunas.put("ID_UFRES", new ColunasDbf(2));
        hashColunas.put("N_INCAIDS", new ColunasDbf(10, 0));
        hashColunas.put("D_INCAIDS", new ColunasDbf(10, 0));
        hashColunas.put("I_INCAIDS", new ColunasDbf(6, 2));
        hashColunas.put("ANO_DIAG", new ColunasDbf(4, 0));
        hashColunas.put("DT_DIAGIN", new ColunasDbf(10));
        hashColunas.put("DT_DIAGFI", new ColunasDbf(10));
        hashColunas.put("ORIGEM", new ColunasDbf(30));
        this.setColunas(hashColunas);
        return hashColunas;
    }

    @Override
    public DBFWriter getLinhas(HashMap<String, ColunasDbf> colunas, List bean, DBFWriter writer) throws DBFException, IOException {
        for (int i = 0; i < bean.size(); ++i) {
            Object[] rowData = new Object[colunas.size()];
            Agravo agravo = (Agravo)bean.get(i);
            if (agravo.getNomeMunicipio().equals("BRASIL")) {
                rowData[0] = null;
                rowData[2] = null;
            } else {
                rowData[0] = agravo.getCodMunicipio();
                rowData[2] = agravo.getCodMunicipio().substring(0, 2);
            }
            rowData[1] = agravo.getNomeMunicipio();
            rowData[3] = Double.parseDouble(agravo.getNumerador());
            rowData[4] = Double.parseDouble(agravo.getDenominador().replace(".", ""));
            rowData[5] = Double.parseDouble(agravo.getTaxa().replace(",", "."));
            rowData[6] = this.preencheAno(this.getDataInicio(), this.getDataFim());
            rowData[7] = this.getDataInicio();
            rowData[8] = this.getDataFim();
            rowData[9] = "AIDS-SINANNET";
            writer.addRecord(rowData);
        }
        return writer;
    }

    @Override
    public String getCaminhoJasper() {
        return "/com/org/relatorios/agravo1.jasper";
    }
}

