/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes.agravos;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import com.org.bd.DBFUtil;
import com.org.model.classes.Agravo;
import com.org.model.classes.ColunasDbf;
import com.org.negocio.Configuracao;
import com.org.negocio.Util;
import com.org.view.Master;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;

public class DengueLetalidade
extends Agravo {
    static String ANO;

    public DengueLetalidade(boolean isDbf) {
        this.setDBF(isDbf);
        this.setPeriodo("de Primeiros Sintomas");
        this.setTipoAgregacao("de Resid\u00eancia");
        this.init("postgres");
    }

    public DengueLetalidade() {
    }

    @Override
    public void init(String tipoBanco) {
        this.setArquivo("DENGNET");
        this.setMultiplicador(100);
        this.setTitulo1("Taxa de letalidade por febre hemorr\u00e1gica dengue por local de resid\u00eancia ");
        this.setTextoCompletitude("% de n\u00e3o preenchimento do campo Evolu\u00e7\u00e3o do caso: ");
        this.setTituloColuna("Taxa Letalidade");
        this.setRodape("Numerador: N\u00famero de \u00f3bitos confirmados por febre hemorr\u00e1gica da dengue (FHD) e s\u00edndrome do choque da dengue (SCD), por local de resid\u00eancia e ano de dos primeiros sintomas \nDenominador: N\u00famero de casos confirmados por febre hemorr\u00e1gica da dengue (FHD) e s\u00edndrome do choque da dengue (SCD), por local de resid\u00eancia e ano de dos primeiros sintomas ");
        this.setTipo("");
        this.setSqlNumeradorCompletitude("tem completitude");
        if (!this.isDBF()) {
            if (tipoBanco.equals("INTERBASE")) {
                this.setSqlNumeradorMunicipioEspecifico("SELECT  count(*)  numerador FROM  tb_notificacao where co_cid = 'A90' and (dt_diagnostico_sintoma BETWEEN ?  AND ?) and co_uf_residencia= ? and co_municipio_residencia = ? and tp_evolucao_caso = '2' and tp_classificacao_final in (3,4) and tp_criterio_confirmacao = 1");
                this.setSqlDenominadorMunicipioEspecifico("SELECT count(*) denominador FROM  tb_notificacao where co_cid = 'A90' and (dt_diagnostico_sintoma BETWEEN  ? AND ?) and co_uf_residencia= ? and co_municipio_residencia = ? and tp_classificacao_final in (3,4) and tp_criterio_confirmacao = 1");
                this.setSqlNumeradorEstado("SELECT count(*) numerador FROM tb_notificacao where co_cid = 'A90' and (dt_diagnostico_sintoma BETWEEN ? AND ?) and co_uf_residencia= ? and tp_evolucao_caso = '2' and tp_classificacao_final in (3,4) and tp_criterio_confirmacao = 1");
                this.setSqlDenominandorEstado("SELECT count(*) denominador FROM tb_notificacao where co_cid = 'A90' and (dt_diagnostico_sintoma BETWEEN ? AND ?) and co_uf_residencia= ? and tp_classificacao_final in (3,4) and tp_criterio_confirmacao = 1");
                this.setSqlNumeradorCompletitude("SELECT  count(*) numerador FROM tb_notificacao where co_cid = 'A90'  and (dt_diagnostico_sintoma BETWEEN ?  AND ?) and co_uf_residencia= ? and tp_evolucao_caso is null and tp_classificacao_final in (3,4) and tp_criterio_confirmacao = 1");
            } else {
                this.setSqlNumeradorMunicipioEspecifico("SELECT  count(*) as numerador FROM dbsinan.tb_notificacao as t1 where co_cid = 'A90' and (dt_diagnostico_sintoma BETWEEN ? AND ?) and co_uf_residencia= ? and co_municipio_residencia = ? and tp_evolucao_caso = '2' and tp_classificacao_final in (3,4) and tp_criterio_confirmacao = 1");
                this.setSqlDenominadorMunicipioEspecifico("SELECT count(*) as denominador FROM dbsinan.tb_notificacao as t1 where co_cid = 'A90' and (dt_diagnostico_sintoma BETWEEN ? AND ?) and co_uf_residencia= ? and co_municipio_residencia = ? and tp_classificacao_final in (3,4) and tp_criterio_confirmacao = 1");
                this.setSqlNumeradorEstado("SELECT  count(*) as numerador FROM dbsinan.tb_notificacao as t1 where co_cid = 'A90' and (dt_diagnostico_sintoma BETWEEN ? AND ?) and co_uf_residencia= ? and tp_evolucao_caso = '2' and tp_classificacao_final in (3,4) and tp_criterio_confirmacao = 1");
                this.setSqlDenominandorEstado("SELECT count(*) as denominador FROM  dbsinan.tb_notificacao as t1 where co_cid = 'A90' and (dt_diagnostico_sintoma BETWEEN ? AND ?) and co_uf_residencia= ? and tp_classificacao_final in (3,4) and tp_criterio_confirmacao = 1");
                this.setSqlNumeradorCompletitude("SELECT count(*) as numerador FROM dbsinan.tb_notificacao as t1 where co_cid = 'A90' and (dt_diagnostico_sintoma BETWEEN ? AND ?) and co_uf_residencia= ? and tp_evolucao_caso is null and tp_classificacao_final in (3,4) and tp_criterio_confirmacao = 1");
            }
            this.setSqlNumeradorBeanMunicipios(this.getSqlNumeradorMunicipioEspecifico());
            this.setSqlDenominadorBeanMunicipios(this.getSqlDenominadorMunicipioEspecifico());
        }
    }

    public boolean verificaClassificacaoFinal(int classificacaoFinal) {
        return classificacaoFinal == 3 || classificacaoFinal == 4;
    }

    public boolean verificaCriterio(int criterio) {
        return criterio == 1;
    }

    public boolean verificaPeriodo(Map parametros, DBFUtil utilDbf, Object[] rowObjects) throws ParseException {
        return this.isBetweenDates(utilDbf.getDate(rowObjects, "DT_SIN_PRI"), (String)parametros.get("parDataInicio"), (String)parametros.get("parDataFim"));
    }

    private void calculaBrasil(DBFReader reader, Map parametros) throws ParseException {
        String coluna;
        HashMap<Object, Object> municipiosBeans = new HashMap();
        DBFUtil utilDbf = new DBFUtil();
        if (parametros.get("municipios").toString().equals("sim")) {
            municipiosBeans = this.populaMunicipiosBeans("BR", "");
            coluna = "ID_MN_RESI";
        } else {
            municipiosBeans = this.populaUfsBeans();
            coluna = "SG_UF";
        }
        int completitude = 0;
        int denominadorCompletitude = 0;
        int criterio = 0;
        DecimalFormat df = new DecimalFormat("0.00");
        int denominador = 0;
        int numerador = 0;
        int numeradorEstadual = 0;
        int denominadorEstadual = 0;
        boolean isBetween = false;
        String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
        for (int k = 0; k < arquivos.length; ++k) {
            int i = 1;
            try {
                Object[] rowObjects;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                utilDbf.mapearPosicoes(reader);
                double d = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    if (utilDbf.getString(rowObjects, coluna) != null) {
                        Agravo municipioResidencia = (Agravo)municipiosBeans.get(utilDbf.getString(rowObjects, coluna));
                        String evolucao = utilDbf.getString(rowObjects, "EVOLUCAO");
                        int classificacaoFinal = utilDbf.getInt(rowObjects, "CLASSI_FIN");
                        criterio = utilDbf.getInt(rowObjects, "CRITERIO");
                        isBetween = this.verificaPeriodo(parametros, utilDbf, rowObjects);
                        if (municipioResidencia != null) {
                            if (evolucao != null) {
                                if (this.verificaClassificacaoFinal(classificacaoFinal) && this.verificaCriterio(criterio) && isBetween) {
                                    denominador = Integer.parseInt(municipioResidencia.getDenominador());
                                    municipioResidencia.setDenominador(String.valueOf(++denominador));
                                    if (evolucao.equals("2")) {
                                        numerador = Integer.parseInt(municipioResidencia.getNumerador());
                                        municipioResidencia.setNumerador(String.valueOf(++numerador));
                                    }
                                    ++denominadorCompletitude;
                                }
                            } else if (isBetween && this.verificaClassificacaoFinal(classificacaoFinal) && this.verificaCriterio(criterio)) {
                                ++completitude;
                            }
                        }
                    }
                    float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(d)) * 100.0f;
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
                continue;
            }
            catch (DBFException dBFException) {
                Master.mensagem("Erro:\n" + (Object)((Object)dBFException));
            }
        }
        String total = df.format(Double.parseDouble(String.valueOf(numeradorEstadual + numerador)) / Double.parseDouble(String.valueOf(denominadorEstadual + denominador)) * 100.0);
        this.setTaxaEstadual(total + " (Numerador:" + String.valueOf(numeradorEstadual + numerador) + " / Denominador: " + String.valueOf(denominadorEstadual + denominador) + ")");
        this.setPercentualCompletitude(df.format(Double.parseDouble(String.valueOf(completitude)) / Double.parseDouble(String.valueOf(denominadorCompletitude)) * 100.0));
        this.setBeans(new ArrayList());
        Collection<Object> municipioBean = municipiosBeans.values();
        if (parametros.get("parSgUf").toString().equals("TODAS") || parametros.get("municipios").toString().equals("sim")) {
            for (Agravo agravo : municipioBean) {
                double num = Double.parseDouble(agravo.getNumerador());
                double den = Double.parseDouble(agravo.getDenominador());
                if (den == 0.0) {
                    agravo.setTaxa("0.00");
                } else {
                    agravo.setTaxa(df.format(num / den * 100.0));
                }
                this.getBeans().add(agravo);
            }
            Collections.sort(this.getBeans(), new BeanComparator("nomeMunicipio"));
        }
        this.getBeans().add(this.adicionaBrasil(municipioBean));
    }

    private void calculaMunicipios(DBFReader reader, Map parametros) throws ParseException {
        HashMap<Object, Object> municipiosBeans = new HashMap();
        String ufResidencia = (String)parametros.get("parUf");
        String sgUfResidencia = (String)parametros.get("parSgUf");
        String codRegional = (String)parametros.get("parCodRegional");
        DBFUtil utilDbf = new DBFUtil();
        if (codRegional == null) {
            codRegional = "";
        }
        municipiosBeans = this.populaMunicipiosBeans(sgUfResidencia, codRegional);
        int completitude = 0;
        int denominadorCompletitude = 0;
        int criterio = 0;
        DecimalFormat df = new DecimalFormat("0.00");
        int denominador = 0;
        int numerador = 0;
        int numeradorEstadual = 0;
        int denominadorEstadual = 0;
        int numeradorRegional = 0;
        int denominadorRegional = 0;
        boolean isBetween = false;
        String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
        for (int k = 0; k < arquivos.length; ++k) {
            int i = 1;
            try {
                Object[] rowObjects;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                utilDbf.mapearPosicoes(reader);
                double d = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    if (utilDbf.getString(rowObjects, "SG_UF") != null) {
                        Agravo municipioResidencia = (Agravo)municipiosBeans.get(utilDbf.getString(rowObjects, "ID_MN_RESI"));
                        String evolucao = utilDbf.getString(rowObjects, "EVOLUCAO");
                        int classificacaoFinal = utilDbf.getInt(rowObjects, "CLASSI_FIN");
                        criterio = utilDbf.getInt(rowObjects, "CRITERIO");
                        isBetween = this.verificaPeriodo(parametros, utilDbf, rowObjects);
                        if (municipioResidencia != null) {
                            if (evolucao != null) {
                                if (this.verificaClassificacaoFinal(classificacaoFinal) && this.verificaCriterio(criterio) && isBetween) {
                                    denominador = Integer.parseInt(municipioResidencia.getDenominador());
                                    municipioResidencia.setDenominador(String.valueOf(++denominador));
                                    ++denominadorEstadual;
                                    ++denominadorRegional;
                                    if (evolucao.equals("2")) {
                                        numerador = Integer.parseInt(municipioResidencia.getNumerador());
                                        municipioResidencia.setNumerador(String.valueOf(++numerador));
                                        ++numeradorEstadual;
                                        ++numeradorRegional;
                                    }
                                    ++denominadorCompletitude;
                                }
                            } else if (isBetween && this.verificaClassificacaoFinal(classificacaoFinal) && this.verificaCriterio(criterio)) {
                                ++completitude;
                            }
                        }
                    }
                    float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(d)) * 100.0f;
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
                continue;
            }
            catch (DBFException dBFException) {
                Master.mensagem("Erro:\n" + (Object)((Object)dBFException));
            }
        }
        String total = df.format(Double.parseDouble(String.valueOf(numeradorEstadual)) / Double.parseDouble(String.valueOf(denominadorEstadual)) * 100.0);
        this.setTaxaEstadual(total + " (Numerador:" + String.valueOf(numeradorEstadual) + " / Denominador: " + String.valueOf(denominadorEstadual) + ")");
        if (!codRegional.equals("")) {
            total = df.format(Double.parseDouble(String.valueOf(numeradorRegional)) / Double.parseDouble(String.valueOf(denominadorRegional)) * 100.0);
            this.setTaxaEstadual(this.getTaxaEstadual() + " Taxa Regional: " + total + " (Numerador:" + String.valueOf(numeradorRegional) + " / Denominador: " + String.valueOf(denominadorRegional) + ")");
        }
        this.setPercentualCompletitude(df.format(Double.parseDouble(String.valueOf(completitude)) / Double.parseDouble(String.valueOf(denominadorCompletitude)) * 100.0));
        this.setBeans(new ArrayList());
        Collection<Object> municipioBean = municipiosBeans.values();
        for (Agravo agravo : municipioBean) {
            double num = Double.parseDouble(agravo.getNumerador());
            double den = Double.parseDouble(agravo.getDenominador());
            if (den == 0.0) {
                agravo.setTaxa("0.00");
            } else {
                agravo.setTaxa(df.format(num / den * 100.0));
            }
            this.getBeans().add(agravo);
        }
        Collections.sort(this.getBeans(), new BeanComparator("nomeMunicipio"));
    }

    @Override
    public void calcula(DBFReader reader, Map parametros) {
        String municipios = (String)parametros.get("municipios");
        String brasil = (String)parametros.get("parUf");
        if (municipios.equals("sim") && !brasil.equals("brasil")) {
            try {
                this.calculaMunicipios(reader, parametros);
            }
            catch (ParseException ex) {
                System.out.println(ex);
            }
        } else if (brasil.equals("brasil")) {
            try {
                this.calculaBrasil(reader, parametros);
            }
            catch (ParseException ex) {
                System.out.println(ex);
            }
        } else {
            String municipioResidencia;
            DBFUtil utilDbf = new DBFUtil();
            int completitude = 0;
            int denominadorCompletitude = 0;
            int criterio = 0;
            DecimalFormat df = new DecimalFormat("0.00");
            int denominadorEstadual = 0;
            int numeradorEstadual = 0;
            int denominadorEspecifico = 0;
            int numeradorEspecifico = 0;
            boolean isBetween = false;
            String ufResidencia = (String)parametros.get("parUf");
            String parMunicipio = municipioResidencia = (String)parametros.get("parMunicipio");
            if (municipioResidencia == null) {
                municipioResidencia = "";
                parMunicipio = ufResidencia;
            }
            String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
            for (int k = 0; k < arquivos.length; ++k) {
                int i = 1;
                try {
                    Object[] rowObjects;
                    reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                    utilDbf.mapearPosicoes(reader);
                    double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                    while ((rowObjects = reader.nextRecord()) != null) {
                        if (utilDbf.getString(rowObjects, "SG_UF") != null && utilDbf.getString(rowObjects, "SG_UF").equals(ufResidencia)) {
                            String evolucao = utilDbf.getString(rowObjects, "EVOLUCAO");
                            int classificacaoFinal = utilDbf.getInt(rowObjects, "CLASSI_FIN");
                            criterio = utilDbf.getInt(rowObjects, "CRITERIO");
                            try {
                                isBetween = this.verificaPeriodo(parametros, utilDbf, rowObjects);
                            }
                            catch (ParseException ex) {
                                System.out.println(ex);
                            }
                            if (this.verificaMunicipio(municipioResidencia, utilDbf.getString(rowObjects, "ID_MN_RESI"))) {
                                if (evolucao != null) {
                                    if (this.verificaClassificacaoFinal(classificacaoFinal) && this.verificaCriterio(criterio)) {
                                        try {
                                            if (isBetween) {
                                                System.out.println(utilDbf.getString(rowObjects, "DT_SIN_PRI") + ";" + utilDbf.getString(rowObjects, "NU_NOTIFIC"));
                                                ++denominadorEspecifico;
                                                ++denominadorEstadual;
                                                if (evolucao.equals("2")) {
                                                    ++numeradorEspecifico;
                                                    ++numeradorEstadual;
                                                }
                                                ++denominadorCompletitude;
                                            }
                                        }
                                        catch (NumberFormatException ex) {
                                            Master.mensagem("Erro:\n" + ex);
                                            System.out.println(ex);
                                        }
                                    }
                                } else if (isBetween && this.verificaClassificacaoFinal(classificacaoFinal) && this.verificaCriterio(criterio)) {
                                    ++completitude;
                                    ++denominadorEspecifico;
                                    ++denominadorEstadual;
                                    ++denominadorCompletitude;
                                }
                            }
                        }
                        float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                        this.getBarraStatus().setValue((int)percentual);
                        ++i;
                    }
                    continue;
                }
                catch (DBFException ex) {
                    Master.mensagem("Erro:\n" + (Object)((Object)ex));
                    System.out.println((Object)ex);
                }
            }
            String total = df.format(Double.parseDouble(String.valueOf(numeradorEstadual)) / Double.parseDouble(String.valueOf(denominadorEstadual)) * 100.0);
            this.setTaxaEstadual(total + " (Numerador:" + String.valueOf(numeradorEstadual) + " / Denominador: " + String.valueOf(denominadorEstadual) + ")");
            Agravo d1 = new Agravo();
            d1.setCodMunicipio(parMunicipio);
            if (municipioResidencia.equals("")) {
                d1.setNomeMunicipio((String)parametros.get("parSgUf"));
            } else {
                d1.setNomeMunicipio((String)parametros.get("parNomeMunicipio"));
            }
            if (!String.valueOf(denominadorEspecifico).equals("0.0")) {
                d1.setNumerador(String.valueOf(NumberFormat.getNumberInstance().format(Double.parseDouble(String.valueOf(numeradorEspecifico)))));
                d1.setDenominador(String.valueOf(NumberFormat.getNumberInstance().format(Double.parseDouble(String.valueOf(denominadorEspecifico)))));
                total = df.format(Double.parseDouble(String.valueOf(numeradorEspecifico)) / Double.parseDouble(String.valueOf(denominadorEspecifico)) * 100.0);
                this.setPercentualCompletitude(df.format(Double.parseDouble(String.valueOf(completitude)) / Double.parseDouble(String.valueOf(denominadorCompletitude)) * 100.0));
                d1.setTaxa(total);
            } else {
                d1.setNumerador("0");
                d1.setDenominador("0");
                d1.setTaxa("0.00");
                this.setPercentualCompletitude("0.00");
            }
            this.setBeans(new ArrayList());
            this.getBeans().add(d1);
        }
    }

    @Override
    public HashMap<String, ColunasDbf> getColunas() {
        HashMap<String, ColunasDbf> hashColunas = new HashMap<String, ColunasDbf>();
        hashColunas.put("ID_LOCRES", new ColunasDbf(7));
        hashColunas.put("DS_LOCRES", new ColunasDbf(30));
        hashColunas.put("ID_UFRES", new ColunasDbf(2));
        hashColunas.put("N_LETDENG", new ColunasDbf(10, 0));
        hashColunas.put("D_LETDENG", new ColunasDbf(10, 0));
        hashColunas.put("I_LETDENG", new ColunasDbf(6, 2));
        hashColunas.put("ANO_PRSIN", new ColunasDbf(4, 0));
        hashColunas.put("DT_PRINIC", new ColunasDbf(10));
        hashColunas.put("DT_PRIFIN", new ColunasDbf(10));
        hashColunas.put("ORIGEM", new ColunasDbf(30));
        this.setColunas(hashColunas);
        return hashColunas;
    }

    @Override
    public String[] getOrdemColunas() {
        return new String[]{"ID_LOCRES", "DS_LOCRES", "ID_UFRES", "N_LETDENG", "D_LETDENG", "I_LETDENG", "ANO_PRSIN", "DT_PRINIC", "DT_PRIFIN", "ORIGEM"};
    }

    @Override
    public Map getParametros() {
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("parDataInicio", Util.formataData(this.getDataInicio()));
        parametros.put("parDataFim", Util.formataData(this.getDataFim()));
        parametros.put("parPeriodo", "de " + this.getDataInicio() + " a " + this.getDataFim());
        parametros.put("parTituloColuna", this.getTituloColuna());
        parametros.put("parFator", String.valueOf(this.getMultiplicador()));
        parametros.put("parAno", Util.getAno(this.getDataFim()));
        parametros.put("parRodape", this.getRodape());
        parametros.put("parConfig", "");
        parametros.put("parTitulo1", "Taxa de letalidade por febre hemorr\u00e1gica dengue por local de resid\u00eancia");
        ANO = "";
        if (Util.getAno(this.getDataFim()).equals(Util.getAno(this.getDataInicio()))) {
            ANO = Util.getAno(this.getDataFim());
        }
        this.setDataInicio(this.getDataInicio());
        this.setDataFim(this.getDataFim());
        return parametros;
    }

    @Override
    public DBFWriter getLinhas(HashMap<String, ColunasDbf> colunas, List bean, DBFWriter writer) throws DBFException, IOException {
        for (int i = 0; i < bean.size(); ++i) {
            Object[] rowData = new Object[colunas.size()];
            Agravo agravo = (Agravo)bean.get(i);
            if (agravo.getNomeMunicipio().equals("BRASIL")) {
                rowData[0] = null;
                rowData[2] = null;
            } else {
                rowData[0] = agravo.getCodMunicipio();
                rowData[2] = agravo.getCodMunicipio().substring(0, 2);
            }
            rowData[1] = agravo.getNomeMunicipio();
            rowData[3] = Double.parseDouble(agravo.getNumerador());
            rowData[4] = Double.parseDouble(agravo.getDenominador());
            rowData[5] = Double.parseDouble(agravo.getTaxa().replace(",", "."));
            rowData[6] = this.preencheAno(this.getDataInicio(), this.getDataFim());
            rowData[7] = this.getDataInicio();
            rowData[8] = this.getDataFim();
            rowData[9] = "DENGUELETALIDADE-SINANNET";
            writer.addRecord(rowData);
        }
        return writer;
    }

    @Override
    public String getCaminhoJasper() {
        return "/com/org/relatorios/agravo1.jasper";
    }
}

