/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes.agravos;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFWriter;
import com.org.bd.DBFUtil;
import com.org.model.classes.Agravo;
import com.org.model.classes.ColunasDbf;
import com.org.model.classes.agravos.DengueLetalidade;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DengueLetalidadeGrave
extends DengueLetalidade {
    static String ANO;
    List<String> semanasAvaliacao = new ArrayList<String>();
    private String semanaInicioDbf;
    private String semanaFimDbf;

    public DengueLetalidadeGrave(boolean isDbf) {
        this.setDBF(isDbf);
        this.setPeriodo("de Primeiros Sintomas");
        this.setTipoAgregacao("de Resid\u00eancia");
        this.init("postgres");
    }

    public DengueLetalidadeGrave() {
    }

    @Override
    public void init(String tipoBanco) {
        this.setArquivo("DENGNET");
        this.setMultiplicador(100);
        this.setTitulo1("Taxa de letalidade das Formas graves de Dengue");
        this.setTextoCompletitude("% de n\u00e3o preenchimento do campo Evolu\u00e7\u00e3o do caso: ");
        this.setTituloColuna("Taxa Letalidade");
        this.setRodape("Numerador: N\u00famero de \u00f3bitos confirmados por Dengue com Complica\u00e7\u00f5es ou Febre Hemorr\u00e1gica da Dengue (FHD) ou S\u00edndrome do Choque da Dengue (SCD) por local de resid\u00eancia e ano de primeiros sintomas. \nDenominador: N\u00famero de casos confirmados por Dengue com Complica\u00e7\u00f5es ou Febre Hemorr\u00e1gica da Dengue (FHD) ou S\u00edndrome do Choque da Dengue (SCD) por local de resid\u00eancia e ano de primeiros sintomas.");
        this.setTipo("dengueGrave");
        this.setSqlNumeradorCompletitude("tem completitude");
        if (!this.isDBF()) {
            this.setSqlNumeradorMunicipioEspecifico("SELECT  count(*) as numerador FROM dbsinan.tb_notificacao where co_cid = 'A90' and ds_semana_sintoma in (?) and 1=? and co_uf_residencia= ? and co_municipio_residencia = ? and tp_evolucao_caso = '2' and tp_classificacao_final in (2,3,4) and tp_criterio_confirmacao in(1,2)");
            this.setSqlDenominadorMunicipioEspecifico("SELECT count(*) as denominador FROM  dbsinan.tb_notificacao where co_cid = 'A90' and ds_semana_sintoma in (?) and 1=? and co_uf_residencia= ? and co_municipio_residencia = ? and tp_classificacao_final in (2,3,4) and tp_criterio_confirmacao in(1,2)");
            this.setSqlNumeradorEstado("SELECT  count(*) as numerador FROM  dbsinan.tb_notificacao as t1 where co_cid = 'A90' and ds_semana_sintoma in (?) and 1=? and co_uf_residencia= ? and tp_evolucao_caso = '2' and tp_classificacao_final in (2,3,4) and tp_criterio_confirmacao in(1,2)");
            this.setSqlDenominandorEstado("SELECT count(*) as denominador FROM dbsinan.tb_notificacao as t1 where co_cid = 'A90' and ds_semana_sintoma in (?) and 1=? and co_uf_residencia= ? and tp_classificacao_final in (2,3,4) and tp_criterio_confirmacao in(1,2)");
            this.setSqlNumeradorCompletitude("SELECT count(*) as numerador FROM  dbsinan.tb_notificacao as t1 where co_cid = 'A90' and ds_semana_sintoma in (?) and co_uf_residencia= ? and tp_evolucao_caso is null and tp_classificacao_final in (2,3,4) and tp_criterio_confirmacao in(1,2)");
            this.setSqlNumeradorBeanMunicipios(this.getSqlNumeradorMunicipioEspecifico());
            this.setSqlDenominadorBeanMunicipios(this.getSqlDenominadorMunicipioEspecifico());
        }
    }

    @Override
    public boolean verificaClassificacaoFinal(int classificacaoFinal) {
        return classificacaoFinal == 2 || classificacaoFinal == 3 || classificacaoFinal == 4;
    }

    @Override
    public boolean verificaCriterio(int criterio) {
        return criterio == 1 || criterio == 2;
    }

    @Override
    public boolean verificaPeriodo(Map parametros, DBFUtil utilDbf, Object[] rowObjects) throws ParseException {
        if (this.semanasAvaliacao.isEmpty()) {
            parametros = this.populaSemana(parametros);
        }
        ANO = parametros.get("parAnoInicial").toString().equals(parametros.get("parAnoFinal").toString()) ? parametros.get("parAnoFinal").toString() : "";
        return this.isBetweenDates(utilDbf.getString(rowObjects, "SEM_PRI"), (String)parametros.get("parAnoInicial"), (String)parametros.get("parDataFim"));
    }

    @Override
    public Map populaSemana(Map parametros) {
        int semanaInicio = Integer.parseInt(parametros.get("parSemanaInicial").toString());
        int semanaFim = Integer.parseInt(parametros.get("parSemanaFinal").toString());
        this.setSemanaInicioDbf(parametros.get("parAnoInicial").toString() + this.formataSemana(parametros.get("parSemanaInicial").toString()));
        this.setSemanaFimDbf(parametros.get("parAnoFinal").toString() + this.formataSemana(parametros.get("parSemanaFinal").toString()));
        String semanas = "";
        if (parametros.get("parAnoInicial").toString().equals(parametros.get("parAnoFinal").toString())) {
            for (int i = semanaInicio; i <= semanaFim; ++i) {
                semanas = semanas + "'" + parametros.get("parAnoInicial").toString() + this.formataSemana(String.valueOf(i)) + "'";
                this.semanasAvaliacao.add(parametros.get("parAnoInicial").toString() + this.formataSemana(String.valueOf(i)));
                if (i >= semanaFim) continue;
                semanas = semanas + ",";
            }
        } else {
            int i;
            for (i = semanaInicio; i <= 53; ++i) {
                semanas = semanas + "'" + parametros.get("parAnoInicial").toString() + this.formataSemana(String.valueOf(i)) + "'";
                this.semanasAvaliacao.add(parametros.get("parAnoInicial").toString() + this.formataSemana(String.valueOf(i)));
                if (i >= 53) continue;
                semanas = semanas + ",";
            }
            for (i = 1; i <= semanaFim; ++i) {
                semanas = semanas + "'" + parametros.get("parAnoInicial").toString() + this.formataSemana(String.valueOf(i)) + "'";
                this.semanasAvaliacao.add(parametros.get("parAnoInicial").toString() + this.formataSemana(String.valueOf(i)));
                if (i >= semanaFim) continue;
                semanas = semanas + ",";
            }
        }
        System.out.println(semanas);
        parametros.put("parDataInicio", semanas);
        parametros.put("parDataFim", "1");
        ANO = parametros.get("parAnoInicial").toString().equals(parametros.get("parAnoFinal").toString()) ? parametros.get("parAnoFinal").toString() : "";
        return parametros;
    }

    private String formataSemana(String semana) {
        if (Integer.parseInt(semana) < 10) {
            return "0" + semana;
        }
        return semana;
    }

    public boolean isBetweenDates(String dataParametro, String dataInicio, String dataFim) throws ParseException {
        return this.semanasAvaliacao.contains(dataParametro);
    }

    @Override
    public Map getParametros() {
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("parTituloColuna", this.getTituloColuna());
        parametros.put("parFator", String.valueOf(this.getMultiplicador()));
        parametros.put("parRodape", this.getRodape());
        parametros.put("parConfig", "");
        parametros.put("parTitulo1", "Taxa de letalidade das Formas graves de Dengue");
        return parametros;
    }

    @Override
    public HashMap<String, ColunasDbf> getColunas() {
        HashMap<String, ColunasDbf> hashColunas = new HashMap<String, ColunasDbf>();
        hashColunas.put("ID_LOCRES", new ColunasDbf(7));
        hashColunas.put("DS_LOCRES", new ColunasDbf(30));
        hashColunas.put("ID_UFRES", new ColunasDbf(2));
        hashColunas.put("N_LETDENG", new ColunasDbf(10, 0));
        hashColunas.put("D_LETDENG", new ColunasDbf(10, 0));
        hashColunas.put("I_LETDENG", new ColunasDbf(6, 2));
        hashColunas.put("ANO_EPPRI", new ColunasDbf(4, 0));
        hashColunas.put("SE_PRINIC", new ColunasDbf(6));
        hashColunas.put("SE_PRIFIN", new ColunasDbf(6));
        hashColunas.put("ORIGEM", new ColunasDbf(30));
        this.setColunas(hashColunas);
        return hashColunas;
    }

    @Override
    public String[] getOrdemColunas() {
        return new String[]{"ID_LOCRES", "DS_LOCRES", "ID_UFRES", "N_LETDENG", "D_LETDENG", "I_LETDENG", "ANO_EPPRI", "SE_PRINIC", "SE_PRIFIN", "ORIGEM"};
    }

    @Override
    public DBFWriter getLinhas(HashMap<String, ColunasDbf> colunas, List bean, DBFWriter writer) throws DBFException, IOException {
        for (int i = 0; i < bean.size(); ++i) {
            Object[] rowData = new Object[colunas.size()];
            Agravo agravo = (Agravo)bean.get(i);
            if (agravo.getNomeMunicipio().equals("BRASIL")) {
                rowData[0] = null;
                rowData[2] = null;
            } else {
                rowData[0] = agravo.getCodMunicipio();
                rowData[2] = agravo.getCodMunicipio().substring(0, 2);
            }
            rowData[1] = agravo.getNomeMunicipio();
            rowData[3] = Double.parseDouble(agravo.getNumerador());
            rowData[4] = Double.parseDouble(agravo.getDenominador());
            rowData[5] = Double.parseDouble(agravo.getTaxa().replace(",", "."));
            rowData[6] = this.preencheAnoSemana(this.getSemanaInicioDbf(), this.getSemanaFimDbf());
            rowData[7] = this.getSemanaInicioDbf();
            rowData[8] = this.getSemanaFimDbf();
            rowData[9] = "DENGUE-SINANNET";
            writer.addRecord(rowData);
        }
        return writer;
    }

    public String getSemanaInicioDbf() {
        return this.semanaInicioDbf;
    }

    public void setSemanaInicioDbf(String semanaInicioDbf) {
        this.semanaInicioDbf = semanaInicioDbf;
    }

    public String getSemanaFimDbf() {
        return this.semanaFimDbf;
    }

    public void setSemanaFimDbf(String semanaFimDbf) {
        this.semanaFimDbf = semanaFimDbf;
    }
}

