/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes.agravos;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import com.org.bd.DBFUtil;
import com.org.model.classes.Agravo;
import com.org.model.classes.ColunasDbf;
import com.org.negocio.Util;
import com.org.util.SinanUtil;
import com.org.view.Master;
import java.io.IOException;
import java.sql.Date;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;

public class ExantematicaOportuno
extends Agravo {
    static String ANO;
    private boolean isAdequadamente = false;

    public ExantematicaOportuno(boolean isDbf, boolean relAdequado) {
        this.setDBF(isDbf);
        this.setPeriodo("de notifica\u00e7\u00e3o");
        this.setTipoAgregacao("de Resid\u00eancia");
        if (!relAdequado) {
            this.init("postgres");
        } else {
            this.initAdequadamente("postgres");
        }
    }

    @Override
    public void init(String tipoBanco) {
        this.setArquivo("EXANTNET");
        this.setTextoCompletitude("");
        this.setMultiplicador(100);
        this.setTipo("");
        this.setTitulo1("Propor\u00e7\u00e3o de doen\u00e7as exantem\u00e1ticas investigados oportunamente");
        this.setTituloColuna("Propor\u00e7\u00e3o");
        this.setRodape("Numerador: Total de casos suspeitos de sarampo e rub\u00e9ola investigados em at\u00e9 48 horas ap\u00f3s a notifica\u00e7\u00e3o, residentes em determinado local e notificados em determinado per\u00edodo \nDenominador: Total de casos suspeitos de sarampo e rub\u00e9ola,  residentes em determinado local e notificados em determinado per\u00edodo ");
        this.setSqlNumeradorCompletitude("");
        if (!this.isDBF()) {
            this.setSqlNumeradorMunicipioEspecifico("select count(*) as numerador from dbsinan.tb_notificacao as t1 where t1.co_cid = 'B09' and  (dt_notificacao BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and t1.co_municipio_residencia = ? and dt_investigacao is not null   and (dt_investigacao-dt_notificacao) <= 2 and (dt_investigacao-dt_notificacao) >= 0 and (tp_duplicidade is null or tp_duplicidade <2)");
            this.setSqlDenominadorMunicipioEspecifico("select count(*) as denominador from dbsinan.tb_notificacao as t1 where t1.co_cid = 'B09' and  (dt_notificacao BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and t1.co_municipio_residencia = ? and (tp_duplicidade is null or tp_duplicidade <2)");
            this.setSqlNumeradorEstado("select count(*) as numerador from dbsinan.tb_notificacao as t1 where t1.co_cid = 'B09' and  (dt_notificacao BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and dt_investigacao is not null   and (dt_investigacao-dt_notificacao) <= 2 and (dt_investigacao-dt_notificacao) >= 0 and (tp_duplicidade is null or tp_duplicidade <2)");
            this.setSqlDenominandorEstado("select count(*) as denominador from dbsinan.tb_notificacao as t1 where t1.co_cid = 'B09' and  (dt_notificacao BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and (tp_duplicidade is null or tp_duplicidade <2)");
        }
        this.setSqlNumeradorBeanMunicipios(this.getSqlNumeradorMunicipioEspecifico());
        this.setSqlDenominadorBeanMunicipios(this.getSqlDenominadorMunicipioEspecifico());
    }

    @Override
    public void initAdequadamente(String tipoBanco) {
        this.setArquivo("EXANTNET");
        this.setTextoCompletitude("");
        this.setMultiplicador(100);
        this.setTipo("");
        this.setTitulo1("Propor\u00e7\u00e3o de doen\u00e7as exantem\u00e1ticas investigados oportunamente e adequadamente");
        this.setTituloColuna("Propor\u00e7\u00e3o");
        this.setRodape("Numerador: Total de casos suspeitos de sarampo e rub\u00e9ola investigados em at\u00e9 48 horas ap\u00f3s a notifica\u00e7\u00e3o, residentes em determinado local e notificados em determinado per\u00edodo e que tenham as vari\u00e1veis data da investiga\u00e7\u00e3o, data do exantema, data da coleta e se realizou bloqueio vacinal prenchidas \nDenominador: Total de casos suspeitos de sarampo e rub\u00e9ola,  residentes em determinado local e notificados em determinado per\u00edodo ");
        this.setSqlNumeradorCompletitude("");
        this.setSqlNumeradorMunicipioEspecifico("select count(*) as numerador from dbsinan.tb_notificacao as t1 inner join dbsinan.tb_investiga_exantematica t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao) where t1.co_cid = 'B09' and  (t2.dt_notificacao BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and t1.co_municipio_residencia = ? and dt_investigacao is not null and dt_coleta_soro_1 is not null and dt_exantema is not null and tp_bloqueio_vacinal in (1,2,3,4) and tp_bloqueio_vacinal is not null and tp_bloqueio_vacinal <> 9 and ((dt_investigacao-t2.dt_notificacao) <= 2) and (tp_duplicidade is null or tp_duplicidade <2)");
        this.setSqlDenominadorMunicipioEspecifico("select count(*) as denominador from dbsinan.tb_notificacao as t1 where t1.co_cid = 'B09' and  (t1.dt_notificacao BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and t1.co_municipio_residencia = ? and (tp_duplicidade is null or tp_duplicidade <2)");
        this.setSqlNumeradorEstado("select count(*) as numerador from dbsinan.tb_notificacao as t1 inner join dbsinan.tb_investiga_exantematica t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao) where t1.co_cid = 'B09' and  (t2.dt_notificacao BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and dt_investigacao is not null and dt_coleta_soro_1 is not null and dt_exantema is not null and tp_bloqueio_vacinal in (1,2,3,4) and tp_bloqueio_vacinal is not null and tp_bloqueio_vacinal <> 9 and ((dt_investigacao-t2.dt_notificacao) <= 2) and (tp_duplicidade is null or tp_duplicidade <2)");
        this.setSqlDenominandorEstado("select count(*) as denominador from dbsinan.tb_notificacao as t1 where t1.co_cid = 'B09' and  (t1.dt_notificacao BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and (tp_duplicidade is null or tp_duplicidade <2)");
        this.setSqlNumeradorBeanMunicipios(this.getSqlNumeradorMunicipioEspecifico());
        this.setSqlDenominadorBeanMunicipios(this.getSqlDenominadorMunicipioEspecifico());
    }

    public void calculaBrasil(DBFReader reader, Map parametros) throws ParseException {
        String coluna;
        HashMap<Object, Object> municipiosBeans = new HashMap();
        DBFUtil utilDbf = new DBFUtil();
        if (parametros.get("municipios").toString().equals("sim")) {
            municipiosBeans = this.populaMunicipiosBeans("BR", "");
            coluna = "ID_MN_RESI";
        } else {
            municipiosBeans = this.populaUfsBeans();
            coluna = "SG_UF";
        }
        boolean completitude = false;
        DecimalFormat df = new DecimalFormat("0.00");
        int denominador = 0;
        int numerador = 0;
        int numeradorEstadual = 0;
        int denominadorEstadual = 0;
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim = (String)parametros.get("parDataFim");
        int i = 1;
        try {
            Object[] rowObjects;
            utilDbf.mapearPosicoes(reader);
            double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
            while ((rowObjects = reader.nextRecord()) != null) {
                if (utilDbf.getString(rowObjects, coluna) != null) {
                    Agravo municipioResidencia = (Agravo)municipiosBeans.get(utilDbf.getString(rowObjects, coluna));
                    Date dtNotificacao = utilDbf.getDate(rowObjects, "DT_NOTIFIC");
                    Date dtInvestigacao = utilDbf.getDate(rowObjects, "DT_INVEST");
                    if (municipioResidencia != null && this.isBetweenDates(dtNotificacao, dataInicio, dataFim)) {
                        denominador = Integer.parseInt(municipioResidencia.getDenominador());
                        municipioResidencia.setDenominador(String.valueOf(++denominador));
                        ++denominadorEstadual;
                        if (dtInvestigacao != null) {
                            if (ExantematicaOportuno.dataDiff(dtNotificacao, dtInvestigacao) <= 2) {
                                numerador = Integer.parseInt(municipioResidencia.getNumerador());
                                municipioResidencia.setNumerador(String.valueOf(++numerador));
                                ++numeradorEstadual;
                            }
                        }
                    }
                }
                float f = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                this.getBarraStatus().setValue((int)f);
                ++i;
            }
        }
        catch (DBFException ex) {
            Master.mensagem("Erro:\n" + (Object)((Object)ex));
        }
        this.setTaxaEstadual("");
        this.setBeans(new ArrayList());
        Collection<Object> municipioBean = municipiosBeans.values();
        if (parametros.get("parSgUf").toString().equals("TODAS") || parametros.get("municipios").toString().equals("sim")) {
            for (Agravo agravo : municipioBean) {
                double num = Double.parseDouble(agravo.getNumerador());
                double den = Double.parseDouble(agravo.getDenominador());
                if (den == 0.0) {
                    agravo.setTaxa("0.00");
                } else {
                    agravo.setTaxa(df.format(num / den * 100.0));
                }
                this.getBeans().add(agravo);
            }
            Collections.sort(this.getBeans(), new BeanComparator("nomeMunicipio"));
        }
        this.getBeans().add(this.adicionaBrasil(municipioBean));
    }

    public void calculaMunicipios(DBFReader reader, Map parametros) throws ParseException {
        HashMap<Object, Object> municipiosBeans = new HashMap();
        String ufResidencia = (String)parametros.get("parUf");
        String sgUfResidencia = (String)parametros.get("parSgUf");
        String codRegional = (String)parametros.get("parCodRegional");
        DBFUtil utilDbf = new DBFUtil();
        municipiosBeans = this.populaMunicipiosBeans(sgUfResidencia, codRegional);
        boolean completitude = false;
        DecimalFormat df = new DecimalFormat("0.00");
        int denominador = 0;
        int numerador = 0;
        int numeradorEstadual = 0;
        int denominadorEstadual = 0;
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim = (String)parametros.get("parDataFim");
        int i = 1;
        try {
            Object[] rowObjects;
            utilDbf.mapearPosicoes(reader);
            double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
            while ((rowObjects = reader.nextRecord()) != null) {
                if (utilDbf.getString(rowObjects, "SG_UF") != null) {
                    Agravo municipioResidencia = (Agravo)municipiosBeans.get(utilDbf.getString(rowObjects, "ID_MN_RESI"));
                    Date dtNotificacao = utilDbf.getDate(rowObjects, "DT_NOTIFIC");
                    Date dtInvestigacao = utilDbf.getDate(rowObjects, "DT_INVEST");
                    if (municipioResidencia != null && this.isBetweenDates(dtNotificacao, dataInicio, dataFim)) {
                        denominador = Integer.parseInt(municipioResidencia.getDenominador());
                        municipioResidencia.setDenominador(String.valueOf(++denominador));
                        ++denominadorEstadual;
                        if (dtInvestigacao != null) {
                            if (ExantematicaOportuno.dataDiff(dtNotificacao, dtInvestigacao) <= 2) {
                                numerador = Integer.parseInt(municipioResidencia.getNumerador());
                                municipioResidencia.setNumerador(String.valueOf(++numerador));
                                ++numeradorEstadual;
                            }
                        }
                    }
                }
                float f = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                this.getBarraStatus().setValue((int)f);
                ++i;
            }
        }
        catch (DBFException ex) {
            Master.mensagem("Erro:\n" + (Object)((Object)ex));
        }
        String total = df.format(Double.parseDouble(String.valueOf(numeradorEstadual)) / Double.parseDouble(String.valueOf(denominadorEstadual)) * 100.0);
        this.setTaxaEstadual(total + " (Numerador:" + String.valueOf(numeradorEstadual) + " / Denominador: " + String.valueOf(denominadorEstadual) + ")");
        this.setBeans(new ArrayList());
        Collection<Object> municipioBean = municipiosBeans.values();
        for (Agravo agravo : municipioBean) {
            double num = Double.parseDouble(agravo.getNumerador());
            double den = Double.parseDouble(agravo.getDenominador());
            if (den == 0.0) {
                agravo.setTaxa("0.00");
            } else {
                agravo.setTaxa(df.format(num / den * 100.0));
            }
            this.getBeans().add(agravo);
        }
        Collections.sort(this.getBeans(), new BeanComparator("nomeMunicipio"));
        if (codRegional.length() == 0) {
            this.getBeans().add(this.adicionaTotal(municipioBean, ""));
        }
    }

    @Override
    public void calcula(DBFReader reader, Map parametros) {
        block32: {
            String municipios = (String)parametros.get("municipios");
            String brasil = (String)parametros.get("parUf");
            if (parametros.get("parTitulo1").equals("Propor\u00e7\u00e3o de doen\u00e7as exantem\u00e1ticas investigados oportunamente e adequadamente")) {
                this.isAdequadamente = true;
            }
            if (municipios.equals("sim") && !brasil.equals("brasil")) {
                try {
                    this.calculaMunicipios(reader, parametros);
                }
                catch (ParseException ex) {
                    System.out.println(ex);
                }
            } else {
                try {
                    Object[] rowObjects;
                    if (brasil.equals("brasil")) {
                        this.calculaBrasil(reader, parametros);
                        break block32;
                    }
                    DBFUtil utilDbf = new DBFUtil();
                    boolean completitude = false;
                    DecimalFormat df = new DecimalFormat("0.00");
                    int denominadorEstadual = 0;
                    int numeradorEstadual = 0;
                    int denominadorEspecifico = 0;
                    int numeradorEspecifico = 0;
                    Date dtColetaSoro = null;
                    Date dtEnxantema = null;
                    String tpBloqueioVacinal = "";
                    String ufResidencia = (String)parametros.get("parUf");
                    String municipioResidencia = (String)parametros.get("parMunicipio");
                    if (municipioResidencia == null) {
                        municipioResidencia = "";
                    }
                    String dataInicio = (String)parametros.get("parDataInicio");
                    String dataFim = (String)parametros.get("parDataFim");
                    int i = 1;
                    utilDbf.mapearPosicoes(reader);
                    double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                    while ((rowObjects = reader.nextRecord()) != null) {
                        if (utilDbf.getString(rowObjects, "SG_UF") != null && utilDbf.getString(rowObjects, "SG_UF").equals(ufResidencia)) {
                            Date dtNotificacao = utilDbf.getDate(rowObjects, "DT_NOTIFIC");
                            Date dtInvestigacao = utilDbf.getDate(rowObjects, "DT_INVEST");
                            if (this.isAdequadamente) {
                                dtColetaSoro = utilDbf.getDate(rowObjects, "DT_COL_1");
                                try {
                                    dtEnxantema = utilDbf.getDate(rowObjects, "DT_INICIO_");
                                }
                                catch (Exception e) {
                                    dtEnxantema = null;
                                }
                                tpBloqueioVacinal = utilDbf.getString(rowObjects, "CS_VACINAL");
                                if (tpBloqueioVacinal == null) {
                                    tpBloqueioVacinal = "";
                                }
                            }
                            if (this.verificaMunicipio(municipioResidencia, utilDbf.getString(rowObjects, "ID_MN_RESI"))) {
                                if (this.isBetweenDates(dtNotificacao, dataInicio, dataFim)) {
                                    System.out.println(utilDbf.getString(rowObjects, "NU_NOTIFIC"));
                                    ++denominadorEspecifico;
                                    ++denominadorEstadual;
                                    if (dtInvestigacao != null) {
                                        if (ExantematicaOportuno.dataDiff(dtNotificacao, dtInvestigacao) <= 2) {
                                            if (this.isAdequadamente) {
                                                if (dtColetaSoro != null && dtEnxantema != null && (tpBloqueioVacinal.equals("1") || tpBloqueioVacinal.equals("2") || tpBloqueioVacinal.equals("3") || tpBloqueioVacinal.equals("4"))) {
                                                    ++numeradorEspecifico;
                                                }
                                                ++numeradorEstadual;
                                            } else {
                                                ++numeradorEspecifico;
                                                ++numeradorEstadual;
                                            }
                                        }
                                    }
                                }
                            } else if (this.isBetweenDates(dtNotificacao, dataInicio, dataFim)) {
                                ++denominadorEstadual;
                                if (dtInvestigacao != null) {
                                    if (ExantematicaOportuno.dataDiff(dtNotificacao, dtInvestigacao) <= 2) {
                                        ++numeradorEstadual;
                                    }
                                }
                            }
                        }
                        float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                        this.getBarraStatus().setValue((int)percentual);
                        ++i;
                    }
                    String total = df.format(Double.parseDouble(String.valueOf(numeradorEstadual)) / Double.parseDouble(String.valueOf(denominadorEstadual)) * 100.0);
                    this.setTaxaEstadual(total + " (Numerador:" + String.valueOf(numeradorEstadual) + " / Denominador: " + String.valueOf(denominadorEstadual) + ")");
                    Agravo d1 = new Agravo();
                    d1.setCodMunicipio((String)parametros.get("parMunicipio"));
                    if (municipioResidencia.equals("")) {
                        d1.setNomeMunicipio((String)parametros.get("parSgUf"));
                    } else {
                        d1.setNomeMunicipio((String)parametros.get("parNomeMunicipio"));
                    }
                    if (!String.valueOf(denominadorEspecifico).equals("0.0")) {
                        d1.setNumerador(String.valueOf(NumberFormat.getNumberInstance().format(Double.parseDouble(String.valueOf(numeradorEspecifico)))));
                        d1.setDenominador(String.valueOf(NumberFormat.getNumberInstance().format(Double.parseDouble(String.valueOf(denominadorEspecifico)))));
                        total = df.format(Double.parseDouble(String.valueOf(numeradorEspecifico)) / Double.parseDouble(String.valueOf(denominadorEspecifico)) * 100.0);
                        d1.setTaxa(total);
                    } else {
                        d1.setNumerador("0");
                        d1.setDenominador("0");
                        d1.setTaxa("0.00");
                    }
                    this.setBeans(new ArrayList());
                    this.getBeans().add(d1);
                }
                catch (NumberFormatException ex) {
                    System.out.println(ex);
                }
                catch (ParseException ex) {
                    System.out.println(ex);
                }
                catch (DBFException ex) {
                    System.out.println((Object)ex);
                }
            }
        }
    }

    @Override
    public HashMap<String, ColunasDbf> getColunas() {
        HashMap<String, ColunasDbf> hashColunas = new HashMap<String, ColunasDbf>();
        hashColunas.put("ID_LOCRES", new ColunasDbf(7));
        hashColunas.put("DS_LOCRES", new ColunasDbf(30));
        hashColunas.put("ID_UFRES", new ColunasDbf(2));
        if (this.isAdequadamente) {
            hashColunas.put("N_ADQEXAN", new ColunasDbf(10, 0));
            hashColunas.put("D_ADQEXAN", new ColunasDbf(10, 0));
            hashColunas.put("I_ADQEXAN", new ColunasDbf(6, 2));
        } else {
            hashColunas.put("N_OPOEXAN", new ColunasDbf(10, 0));
            hashColunas.put("D_OPOEXAN", new ColunasDbf(10, 0));
            hashColunas.put("I_OPOEXAN", new ColunasDbf(6, 2));
        }
        hashColunas.put("ANO_NOTIF", new ColunasDbf(4, 0));
        hashColunas.put("DT_NOTINI", new ColunasDbf(10));
        hashColunas.put("DT_NOTFIN", new ColunasDbf(10));
        hashColunas.put("ORIGEM", new ColunasDbf(30));
        this.setColunas(hashColunas);
        return hashColunas;
    }

    @Override
    public String[] getOrdemColunas() {
        if (this.isAdequadamente) {
            return new String[]{"ID_LOCRES", "DS_LOCRES", "ID_UFRES", "N_ADQEXAN", "D_ADQEXAN", "I_ADQEXAN", "ANO_NOTIF", "DT_NOTINI", "DT_NOTFIN", "ORIGEM"};
        }
        return new String[]{"ID_LOCRES", "DS_LOCRES", "ID_UFRES", "N_OPOEXAN", "D_OPOEXAN", "I_OPOEXAN", "ANO_NOTIF", "DT_NOTINI", "DT_NOTFIN", "ORIGEM"};
    }

    @Override
    public Map getParametros() {
        Util util = new Util();
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("parDataInicio", Util.formataData(this.getDataInicio()));
        parametros.put("parDataFim", Util.formataData(this.getDataFim()));
        parametros.put("parPeriodo", "de " + this.getDataInicio() + " a " + this.getDataFim());
        parametros.put("parTituloColuna", this.getTituloColuna());
        parametros.put("parFator", String.valueOf(this.getMultiplicador()));
        parametros.put("parAno", Util.getAno(this.getDataFim()));
        parametros.put("parRodape", this.getRodape());
        parametros.put("parConfig", "");
        parametros.put("parTitulo1", this.getTitulo1());
        ANO = "";
        if (Util.getAno(this.getDataFim()).equals(Util.getAno(this.getDataInicio()))) {
            ANO = Util.getAno(this.getDataFim());
        }
        this.setDataInicio(this.getDataInicio());
        this.setDataFim(this.getDataFim());
        return parametros;
    }

    @Override
    public DBFWriter getLinhas(HashMap<String, ColunasDbf> colunas, List bean, DBFWriter writer) throws DBFException, IOException {
        Double totalTaxa = 0.0;
        for (int i = 0; i < bean.size(); ++i) {
            Object[] rowData = new Object[colunas.size()];
            Agravo agravo = (Agravo)bean.get(i);
            if (agravo.getNomeMunicipio().equals("BRASIL") || agravo.getNomeMunicipio().equals("TOTAL")) {
                rowData[0] = null;
                rowData[2] = null;
                totalTaxa = Double.parseDouble(agravo.getNumerador()) / Double.parseDouble(agravo.getDenominador()) * 100.0;
                totalTaxa = Double.parseDouble(totalTaxa.toString().replace(",", "."));
                System.out.println(totalTaxa);
            } else {
                if (agravo.getCodMunicipio() == null || agravo.getCodMunicipio().equals("")) {
                    rowData[0] = SinanUtil.siglaUFToIDUF(agravo.getNomeMunicipio());
                    rowData[2] = SinanUtil.siglaUFToIDUF(agravo.getNomeMunicipio());
                } else {
                    rowData[0] = agravo.getCodMunicipio();
                    rowData[2] = agravo.getCodMunicipio().substring(0, 2);
                }
                totalTaxa = Double.parseDouble(agravo.getTaxa().replace(",", "."));
            }
            rowData[1] = agravo.getNomeMunicipio();
            rowData[3] = Double.parseDouble(agravo.getNumerador());
            rowData[4] = Double.parseDouble(agravo.getDenominador());
            rowData[5] = totalTaxa;
            rowData[6] = this.preencheAno(this.getDataInicio(), this.getDataFim());
            rowData[7] = this.getDataInicio();
            rowData[8] = this.getDataFim();
            rowData[9] = "EXANTEMATICAS-SINANNET";
            writer.addRecord(rowData);
        }
        return writer;
    }

    @Override
    public String getCaminhoJasper() {
        return "/com/org/relatorios/agravo1.jasper";
    }
}

