/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes.agravos;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.org.bd.DBFUtil;
import com.org.model.classes.Agravo;
import com.org.model.classes.agravos.ExantematicaOportuno;
import com.org.view.Master;
import java.sql.Date;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;

public class ExantematicaOportunoAdequadamente
extends ExantematicaOportuno {
    public ExantematicaOportunoAdequadamente(boolean isDbf, boolean relAdequado) {
        super(isDbf, relAdequado);
    }

    @Override
    public void initAdequadamente(String tipoBanco) {
        this.setArquivo("EXANTNET");
        this.setTextoCompletitude("");
        this.setMultiplicador(100);
        this.setTipo("");
        this.setTitulo1("Propor\u00e7\u00e3o de doen\u00e7as exantem\u00e1ticas investigados oportunamente e adequadamente");
        this.setTituloColuna("Propor\u00e7\u00e3o");
        this.setRodape("Numerador: Total de casos suspeitos de sarampo e rub\u00e9ola investigados em at\u00e9 48 horas ap\u00f3s a notifica\u00e7\u00e3o, residentes em determinado local e notificados em determinado per\u00edodo e que tenham as vari\u00e1veis data da investiga\u00e7\u00e3o, data do exantema, data da coleta e se realizou bloqueio vacinal prenchidas \nDenominador: Total de casos suspeitos de sarampo e rub\u00e9ola,  residentes em determinado local e notificados em determinado per\u00edodo ");
        this.setSqlNumeradorCompletitude("");
        if (!this.isDBF()) {
            this.setSqlNumeradorMunicipioEspecifico("select count(*) as numerador from dbsinan.tb_notificacao as t1 inner join dbsinan.tb_investiga_exantematica t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao) where t1.co_cid = 'B09' and  (t2.dt_notificacao BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and t1.co_municipio_residencia = ? and dt_investigacao is not null and dt_coleta_soro_1 is not null and dt_exantema is not null and tp_bloqueio_vacinal in (1,2,3,4) and tp_bloqueio_vacinal is not null and tp_bloqueio_vacinal <> 9 and ((dt_investigacao-t2.dt_notificacao) <= 2) and (tp_duplicidade is null or tp_duplicidade <2)");
            this.setSqlDenominadorMunicipioEspecifico("select count(*) as denominador from dbsinan.tb_notificacao as t1 where t1.co_cid = 'B09' and  (t1.dt_notificacao BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and t1.co_municipio_residencia = ? and (tp_duplicidade is null or tp_duplicidade <2)");
            this.setSqlNumeradorEstado("select count(*) as numerador from dbsinan.tb_notificacao as t1 inner join dbsinan.tb_investiga_exantematica t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao) where t1.co_cid = 'B09' and  (t2.dt_notificacao BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and dt_investigacao is not null and dt_coleta_soro_1 is not null and dt_exantema is not null and tp_bloqueio_vacinal in (1,2,3,4) and tp_bloqueio_vacinal is not null and tp_bloqueio_vacinal <> 9 and ((dt_investigacao-t2.dt_notificacao) <= 2) and (tp_duplicidade is null or tp_duplicidade <2)");
            this.setSqlDenominandorEstado("select count(*) as denominador from dbsinan.tb_notificacao as t1 where t1.co_cid = 'B09' and  (t1.dt_notificacao BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and (tp_duplicidade is null or tp_duplicidade <2)");
        }
        this.setSqlNumeradorBeanMunicipios(this.getSqlNumeradorMunicipioEspecifico());
        this.setSqlDenominadorBeanMunicipios(this.getSqlDenominadorMunicipioEspecifico());
    }

    @Override
    public void calculaBrasil(DBFReader reader, Map parametros) throws ParseException {
        String coluna;
        HashMap<Object, Object> municipiosBeans = new HashMap();
        DBFUtil utilDbf = new DBFUtil();
        if (parametros.get("municipios").toString().equals("sim")) {
            municipiosBeans = this.populaMunicipiosBeans("BR", "");
            coluna = "ID_MN_RESI";
        } else {
            municipiosBeans = this.populaUfsBeans();
            coluna = "SG_UF";
        }
        boolean completitude = false;
        DecimalFormat df = new DecimalFormat("0.00");
        int denominador = 0;
        int numerador = 0;
        int numeradorEstadual = 0;
        int denominadorEstadual = 0;
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim = (String)parametros.get("parDataFim");
        int i = 1;
        try {
            Object[] rowObjects;
            utilDbf.mapearPosicoes(reader);
            double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
            while ((rowObjects = reader.nextRecord()) != null) {
                if (utilDbf.getString(rowObjects, coluna) != null) {
                    Agravo municipioResidencia = (Agravo)municipiosBeans.get(utilDbf.getString(rowObjects, coluna));
                    Date dtNotificacao = utilDbf.getDate(rowObjects, "DT_NOTIFIC");
                    Date dtInvestigacao = utilDbf.getDate(rowObjects, "DT_INVEST");
                    Date dtColeta = utilDbf.getDate(rowObjects, "DT_COL_1");
                    Date dtExantema = utilDbf.getDate(rowObjects, "DT_INICIO_");
                    String bloqueioVacinal = utilDbf.getString(rowObjects, "CS_VACINAL");
                    if (municipioResidencia != null && this.isBetweenDates(dtNotificacao, dataInicio, dataFim)) {
                        denominador = Integer.parseInt(municipioResidencia.getDenominador());
                        municipioResidencia.setDenominador(String.valueOf(++denominador));
                        ++denominadorEstadual;
                        if (dtInvestigacao != null && dtColeta != null && dtExantema != null && bloqueioVacinal != null) {
                            if (ExantematicaOportunoAdequadamente.dataDiff(dtNotificacao, dtInvestigacao) <= 2 && (bloqueioVacinal.equals("1") || bloqueioVacinal.equals("2") || bloqueioVacinal.equals("3") || bloqueioVacinal.equals("4")) && !bloqueioVacinal.equals("9")) {
                                numerador = Integer.parseInt(municipioResidencia.getNumerador());
                                municipioResidencia.setNumerador(String.valueOf(++numerador));
                                ++numeradorEstadual;
                            }
                        }
                    }
                }
                float f = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                this.getBarraStatus().setValue((int)f);
                ++i;
            }
        }
        catch (DBFException ex) {
            Master.mensagem("Erro:\n" + (Object)((Object)ex));
        }
        this.setTaxaEstadual("");
        this.setBeans(new ArrayList());
        Collection<Object> municipioBean = municipiosBeans.values();
        if (parametros.get("parSgUf").toString().equals("TODAS") || parametros.get("municipios").toString().equals("sim")) {
            for (Agravo agravo : municipioBean) {
                double num = Double.parseDouble(agravo.getNumerador());
                double den = Double.parseDouble(agravo.getDenominador());
                if (den == 0.0) {
                    agravo.setTaxa("0.00");
                } else {
                    agravo.setTaxa(df.format(num / den * 100.0));
                }
                this.getBeans().add(agravo);
            }
            Collections.sort(this.getBeans(), new BeanComparator("nomeMunicipio"));
        }
        this.getBeans().add(this.adicionaBrasil(municipioBean));
    }

    @Override
    public void calculaMunicipios(DBFReader reader, Map parametros) throws ParseException {
        HashMap<Object, Object> municipiosBeans = new HashMap();
        String ufResidencia = (String)parametros.get("parUf");
        String sgUfResidencia = (String)parametros.get("parSgUf");
        String codRegional = (String)parametros.get("parCodRegional");
        DBFUtil utilDbf = new DBFUtil();
        municipiosBeans = this.populaMunicipiosBeans(sgUfResidencia, codRegional);
        boolean completitude = false;
        DecimalFormat df = new DecimalFormat("0.00");
        int denominador = 0;
        int numerador = 0;
        int numeradorEstadual = 0;
        int denominadorEstadual = 0;
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim = (String)parametros.get("parDataFim");
        int i = 1;
        try {
            Object[] rowObjects;
            utilDbf.mapearPosicoes(reader);
            double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
            while ((rowObjects = reader.nextRecord()) != null) {
                if (utilDbf.getString(rowObjects, "SG_UF") != null) {
                    Agravo municipioResidencia = (Agravo)municipiosBeans.get(utilDbf.getString(rowObjects, "ID_MN_RESI"));
                    Date dtNotificacao = utilDbf.getDate(rowObjects, "DT_NOTIFIC");
                    Date dtInvestigacao = utilDbf.getDate(rowObjects, "DT_INVEST");
                    Date dtColeta = utilDbf.getDate(rowObjects, "DT_COL_1");
                    Date dtExantema = utilDbf.getDate(rowObjects, "DT_INICIO_");
                    String bloqueioVacinal = utilDbf.getString(rowObjects, "CS_VACINAL");
                    if (municipioResidencia != null && this.isBetweenDates(dtNotificacao, dataInicio, dataFim)) {
                        denominador = Integer.parseInt(municipioResidencia.getDenominador());
                        municipioResidencia.setDenominador(String.valueOf(++denominador));
                        ++denominadorEstadual;
                        if (dtInvestigacao != null && dtColeta != null && dtExantema != null && bloqueioVacinal != null) {
                            if (ExantematicaOportunoAdequadamente.dataDiff(dtNotificacao, dtInvestigacao) <= 2 && (bloqueioVacinal.equals("1") || bloqueioVacinal.equals("2") || bloqueioVacinal.equals("3") || bloqueioVacinal.equals("4")) && !bloqueioVacinal.equals("9")) {
                                numerador = Integer.parseInt(municipioResidencia.getNumerador());
                                municipioResidencia.setNumerador(String.valueOf(++numerador));
                                ++numeradorEstadual;
                            }
                        }
                    }
                }
                float f = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                this.getBarraStatus().setValue((int)f);
                ++i;
            }
        }
        catch (DBFException ex) {
            Master.mensagem("Erro:\n" + (Object)((Object)ex));
        }
        String total = df.format(Double.parseDouble(String.valueOf(numeradorEstadual)) / Double.parseDouble(String.valueOf(denominadorEstadual)) * 100.0);
        this.setTaxaEstadual(total + " (Numerador:" + String.valueOf(numeradorEstadual) + " / Denominador: " + String.valueOf(denominadorEstadual) + ")");
        this.setBeans(new ArrayList());
        Collection<Object> municipioBean = municipiosBeans.values();
        for (Agravo agravo : municipioBean) {
            double num = Double.parseDouble(agravo.getNumerador());
            double den = Double.parseDouble(agravo.getDenominador());
            if (den == 0.0) {
                agravo.setTaxa("0.00");
            } else {
                agravo.setTaxa(df.format(num / den * 100.0));
            }
            this.getBeans().add(agravo);
        }
        Collections.sort(this.getBeans(), new BeanComparator("nomeMunicipio"));
    }
}

