/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes.agravos;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import com.org.bd.DBFUtil;
import com.org.model.classes.Agravo;
import com.org.model.classes.ColunasDbf;
import com.org.model.classes.Faltoso;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;

public class Hanseniase
extends Agravo {
    public Hanseniase(boolean isDbf) {
        this.setDBF(isDbf);
        this.setPeriodo("de Diagn\u00f3stico");
        this.setTipoAgregacao("de Notifica\u00e7\u00e3o Atual");
    }

    @Override
    public List getBeansMunicipioEspecifico(Connection con, Map parametros) throws SQLException {
        return this.getListaMunicipioEspecifico(con, parametros);
    }

    @Override
    public String getCompletitude(Connection con, Map parametros) throws SQLException {
        return "";
    }

    @Override
    public String getTaxaEstado(Connection con, Map parametros) throws SQLException {
        return "";
    }

    @Override
    public List getListaMunicipioEspecifico(Connection con, Map parametros) throws SQLException {
        ArrayList<Faltoso> beans = new ArrayList<Faltoso>();
        if (this.isDBF()) {
            DBFReader reader = this.getReader();
            DBFUtil utilDbf = new DBFUtil();
            try {
                utilDbf.mapearPosicoes(reader);
            }
            catch (DBFException ex) {
                System.out.println((Object)ex);
            }
            String noMunicipio = null;
            String municipio = parametros.get("parMunicipio").toString();
            noMunicipio = parametros.get("parNomeMunicipio").toString();
            SimpleDateFormat formato = new SimpleDateFormat("dd/MM/yyyy");
            java.util.Date dtAtual = new java.util.Date(new java.util.Date().getTime());
            try {
                Object[] rowObjects;
                double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                int i = 1;
                while ((rowObjects = reader.nextRecord()) != null) {
                    Date dtUltimoComparecimento;
                    int diferenca;
                    String codMunicipioAtual;
                    String tpAlta = utilDbf.getString(rowObjects, "TPALTA_N");
                    if (tpAlta == null) {
                        tpAlta = "";
                    }
                    if ((codMunicipioAtual = utilDbf.getString(rowObjects, "ID_MUNI_AT")) == null) {
                        codMunicipioAtual = "";
                    }
                    if (codMunicipioAtual.equals(municipio) && tpAlta.isEmpty() && (diferenca = Agravo.dataDiff(dtUltimoComparecimento = utilDbf.getDate(rowObjects, "DTULTCOMP"), dtAtual)) > 91) {
                        Faltoso f = new Faltoso();
                        f.setNome(utilDbf.getString(rowObjects, "NM_PACIENT"));
                        f.setNuMesesSemInformacao(String.valueOf(diferenca / 30));
                        f.setNumero(utilDbf.getString(rowObjects, "NU_NOT_AT"));
                        f.setClassificacao(utilDbf.getString(rowObjects, "CLASSATUAL"));
                        f.setDtDiagnostico(formato.format(utilDbf.getDate(rowObjects, "DT_DIAG")));
                        f.setDtInicioTratamento(formato.format(utilDbf.getDate(rowObjects, "DTINICTRAT")));
                        f.setDtNotificacao(formato.format(utilDbf.getDate(rowObjects, "DT_NOTIFIC")));
                        f.setProntuario(utilDbf.getString(rowObjects, "NU_PRONTUA"));
                        f.setUnidade(utilDbf.getString(rowObjects, "ID_UNID_AT"));
                        f.setNoUnidade("");
                        f.setNomeMunicipio(noMunicipio);
                        f.setCodMunicipio(municipio);
                        f.setDtUltimoComparecimento(formato.format(dtUltimoComparecimento));
                        f.setDtHoje(formato.format(dtAtual));
                        beans.add(f);
                    }
                    float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
            }
            catch (NumberFormatException ex) {
                System.out.println(ex);
            }
            catch (ParseException ex) {
                System.out.println(ex);
            }
            catch (DBFException ex) {
                System.out.println((Object)ex);
            }
            System.out.println("terminou");
            Collections.sort(beans, new BeanComparator("unidade"));
        } else {
            ResultSet rs2;
            String noMunicipio = null;
            String municipio = parametros.get("parMunicipio").toString();
            noMunicipio = parametros.get("parNomeMunicipio").toString();
            String sql1 = "select nu_notificacao_atual as notificacao,ds_prontuario as prontuario,co_cnes as unidade,ds_estabelecimento as noUnidade,t1.dt_notificacao as dt_notificacao,no_nome_paciente as nome,tp_classific_operacao_atual as classificacao,dt_diagnostico_sintoma as dt_diagnostico,dt_ini_tratamento as dt_inicio,dt_ultimo_comparecimento as dt_limite,trunc(DATE_PART('days',now()-dt_ultimo_comparecimento)/30) as meses from dbsinan.tb_investiga_hanseniase t1 inner join dbsinan.tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao  and t1.co_municipio_notificacao=t2.co_municipio_notificacao)  inner join dblocalidade.tb_estabelecimento_saude t3 on t1.co_unidade_atual = t3.co_estabelecimento  where t1.co_municipio_atual= ?  " + parametros.get("parCasosNovos") + " and (tp_alta is null or tp_alta = '') and ((now()-dt_ultimo_comparecimento) > age('08/12/2006','05/12/2006'))  order by ds_estabelecimento,t1.dt_notificacao desc";
            try {
                PreparedStatement stm2 = con.prepareStatement(sql1);
                stm2.setString(1, municipio);
                rs2 = stm2.executeQuery();
            }
            catch (Exception exception) {
                SimpleDateFormat formato2 = new SimpleDateFormat("yyyy-MM-dd");
                String dataAtual = formato2.format(new java.util.Date());
                sql1 = "select nu_notificacao_atual as notificacao, ds_prontuario as prontuario, co_cnes as unidade, ds_estabelecimento as noUnidade, t1.dt_notificacao as dt_notificacao, no_nome_paciente as nome, tp_classific_operacao_atual as classificacao, dt_diagnostico_sintoma as dt_diagnostico, dt_ini_tratamento as dt_inicio, dt_ultimo_comparecimento as dt_limite, (cast('today' as date)-cast (dt_ultimo_comparecimento as date))/30 meses from tb_investiga_hanseniase t1 inner join tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao  and t1.co_municipio_notificacao=t2.co_municipio_notificacao)  inner join tb_estabelecimento_saude t3 on t1.co_unidade_atual = t3.co_estabelecimento where t1.co_municipio_atual= " + municipio + " and (tp_alta is null or tp_alta = '') and cast('today' as date)-cast(dt_ultimo_comparecimento as date) > 90  order by ds_estabelecimento,t1.dt_notificacao desc";
                System.out.println(sql1);
                Statement stm = con.createStatement();
                rs2 = stm.executeQuery(sql1);
            }
            SimpleDateFormat formato = new SimpleDateFormat("dd/MM/yyyy");
            while (rs2.next()) {
                Faltoso f = new Faltoso();
                f.setNome("");
                f.setNuMesesSemInformacao(rs2.getString("meses"));
                f.setNumero(rs2.getString("notificacao"));
                f.setClassificacao(rs2.getString("classificacao"));
                f.setDtDiagnostico(formato.format(rs2.getDate("dt_diagnostico")));
                f.setDtInicioTratamento(formato.format(rs2.getDate("dt_inicio")));
                f.setDtNotificacao(formato.format(rs2.getDate("dt_notificacao")));
                f.setProntuario(rs2.getString("prontuario"));
                f.setUnidade(rs2.getString("unidade"));
                f.setNoUnidade(rs2.getString("noUnidade"));
                f.setNomeMunicipio(noMunicipio);
                f.setCodMunicipio(municipio);
                f.setDtUltimoComparecimento(formato.format(rs2.getDate("dt_limite")));
                beans.add(f);
            }
            System.out.println("terminou");
        }
        return beans;
    }

    @Override
    public List getListaEstadoEspecifico(Connection con, Map parametros) throws SQLException {
        ArrayList<Faltoso> beans = new ArrayList<Faltoso>();
        String uf = parametros.get("parUf").toString();
        String noUF = parametros.get("parSgUf").toString();
        String sql1 = "select nu_notificacao_atual as notificacao,ds_prontuario as prontuario,no_nome_paciente as nome,tp_classific_operacao_atual as classificacao,to_char(dt_diagnostico_sintoma,'DD/MM/YYYY') as dt_diagnostico,to_char(dt_ini_tratamento,'DD/MM/YYYY') as dt_inicio,to_char(dt_ultimo_comparecimento,'DD/MM/YYYY') as dt_limite,to_char(now(),'DD/MM/YYYY') as dt_atual,trunc(DATE_PART('days',now()-dt_ultimo_comparecimento)/30) as meses from dbsinan.tb_investiga_hanseniase t1 inner join dbsinan.tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao  and t1.co_municipio_notificacao=t2.co_municipio_notificacao)    where t1.co_uf_atual= ?  " + parametros.get("parCasosNovos") + " and (tp_alta is null or tp_alta = '') and ((now()-dt_ultimo_comparecimento) > 90)";
        PreparedStatement stm2 = con.prepareStatement(sql1);
        stm2.setString(1, uf);
        ResultSet rs2 = stm2.executeQuery();
        while (rs2.next()) {
            Faltoso f = new Faltoso();
            f.setNome(rs2.getString("nome"));
            f.setNuMesesSemInformacao(rs2.getString("meses"));
            f.setNumero(rs2.getString("notificacao"));
            f.setClassificacao(rs2.getString("classificacao"));
            f.setDtDiagnostico(rs2.getString("dt_diagnostico"));
            f.setDtHoje(rs2.getString("dt_atual"));
            f.setDtInicioTratamento(rs2.getString("dt_inicio"));
            f.setProntuario(rs2.getString("prontuario"));
            f.setNomeMunicipio(noUF);
            f.setCodMunicipio(uf);
            f.setDtUltimoComparecimento(rs2.getString("dt_limite"));
            beans.add(f);
        }
        System.out.println("terminou");
        return beans;
    }

    @Override
    public String[] getOrdemColunas() {
        return new String[]{"NUM_NOTIF", "NUM_PRONT", "DT_NOTIFI", "NM_PACIEN", "CLA_OPATU", "DT_DIAGN", "DT_INITRAT", "DT_ULTCOM", "DT_RELATO", "MES_SINFO", "ORIGEM"};
    }

    @Override
    public HashMap<String, ColunasDbf> getColunas() {
        HashMap<String, ColunasDbf> hashColunas = new HashMap<String, ColunasDbf>();
        hashColunas.put("NUM_NOTIF", new ColunasDbf(7));
        hashColunas.put("NUM_PRONT", new ColunasDbf(7));
        hashColunas.put("DT_NOTIFI", new ColunasDbf(10));
        hashColunas.put("NM_PACIEN", new ColunasDbf(30));
        hashColunas.put("CLA_OPATU", new ColunasDbf(1));
        hashColunas.put("DT_DIAGN", new ColunasDbf(10));
        hashColunas.put("DT_INITRAT", new ColunasDbf(10));
        hashColunas.put("DT_ULTCOM", new ColunasDbf(10));
        hashColunas.put("DT_RELATO", new ColunasDbf(10));
        hashColunas.put("MES_SINFO", new ColunasDbf(4, 0));
        hashColunas.put("ORIGEM", new ColunasDbf(30));
        this.setColunas(hashColunas);
        return hashColunas;
    }

    @Override
    public Map getParametros() {
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("parCasosNovos", "");
        this.setTitulo1("Listagem de notifica\u00e7\u00f5es de prov\u00e1veis faltosos e abandono do tratamento de hansen\u00edase");
        this.setRodape("1 -Este relat\u00f3rio lista as notifica\u00e7\u00f5es com tipo de sa\u00edda n\u00e3o preenchido e cujo intervalo entre data de emiss\u00e3o do relat\u00f3rio e data do \u00faltimo comparecimento ultrapasse 91 dias. Esses casos podem ser conseq\u00fcente da falta de digita\u00e7\u00e3o dos dados de acompanhamento, da falta de comparecimento do paciente \u00e0 US ou ao acompanhamento da PSF (faltoso = 03 meses e mais a 11 meses; abandono de tratamento =12 meses e mais) e falta de atualiza\u00e7\u00e3o do campo tipo de sa\u00edda com categoria 7-abandono. Tem como finalidade alertar as SMS  e  US sobre a necessidade de fazer buscas ativas dos faltosos, confirmar poss\u00edveis abandonos e fazer as devidas atualiza\u00e7\u00f5es na base de dados.\n\n2- os dados das notifica\u00e7\u00f5es dessa lista devem ser atualizados por meio do preenchimento do Boletim de Acompanhamento de Hansen\u00edase emitido e enviado mensalmente pela SMS.");
        parametros.put("parTitulo1", this.getTitulo1());
        parametros.put("parRodape", this.getRodape());
        parametros.put("parConfig", "");
        return parametros;
    }

    @Override
    public DBFWriter getLinhas(HashMap<String, ColunasDbf> colunas, List bean, DBFWriter writer) throws DBFException, IOException {
        for (int i = 0; i < bean.size(); ++i) {
            Object[] rowData = new Object[colunas.size()];
            Faltoso faltoso = (Faltoso)bean.get(i);
            rowData[0] = faltoso.getNumero();
            if (faltoso.getProntuario() != null) {
                rowData[1] = faltoso.getProntuario();
            }
            rowData[2] = faltoso.getDtNotificacao();
            rowData[3] = faltoso.getNome();
            rowData[4] = faltoso.getClassificacao();
            rowData[5] = faltoso.getDtDiagnostico();
            rowData[6] = faltoso.getDtInicioTratamento();
            rowData[7] = faltoso.getDtUltimoComparecimento();
            java.util.Date data = new java.util.Date();
            SimpleDateFormat formatador = new SimpleDateFormat("dd/MM/yyyy");
            rowData[8] = formatador.format(data);
            rowData[9] = Double.parseDouble(faltoso.getNuMesesSemInformacao());
            rowData[10] = "HANSENIASE-SINANNET";
            writer.addRecord(rowData);
        }
        return writer;
    }

    @Override
    public String getCaminhoJasper() {
        return "/com/org/relatorios/hanseniase_listagem.jasper";
    }
}

