/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes.agravos;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import com.org.bd.DBFUtil;
import com.org.model.classes.Agravo;
import com.org.model.classes.ColunasDbf;
import com.org.negocio.Configuracao;
import com.org.negocio.Util;
import com.org.view.Master;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;

public class HanseniaseCoorte
extends Agravo {
    private String cura;
    private String abandono;
    private String transfMesmoMunicipio;
    private String transfOutroMunicipio;
    private String transfOutroUf;
    private String naoPreenchido;
    private String erroDiagnostico;
    private String perNaoPreenchido;
    private String subTotal;
    private String total;
    private String perAbandono;
    private String perCura;
    private String transfOutroPais;
    private String obito;
    private String transfNaoEspecificada;
    static String dtPbInicial;
    static String dtPbFinal;
    static String dtMbInicial;
    static String dtMbFinal;

    public HanseniaseCoorte(boolean isDbf) {
        this.setDBF(isDbf);
        this.setPeriodo("de Diagn\u00f3stico");
        this.setTipoAgregacao("de Resid\u00eancia Atual");
        this.init("postgres");
    }

    public HanseniaseCoorte() {
    }

    @Override
    public void init(String tipoBanco) {
        this.setMultiplicador(100000);
        this.setTipo("hans");
        this.setTitulo1("Situa\u00e7\u00e3o da coorte de casos novos de hansen\u00edase ");
        this.setRodape("OBS. sobre m\u00e9todo de c\u00e1lculo: \nSele\u00e7\u00e3o das coortes: Casos novos (modo de entrada = 1-Caso novo) paucibacilares (classifica\u00e7\u00e3o operacional atual) diagnosticados no ano anterior ao ano de avalia\u00e7\u00e3o e casos novos multibacilares diagnosticados 2 anos anteriores ao ano de avalia\u00e7\u00e3o. No relat\u00f3rio s\u00e3o somados os PB e os MB selecionados na base de dados do Sinan, segundo local de resid\u00eancia atual.\nC\u00e1lculo do percentual de cura, de abandono de tratamento e de tipo de sa\u00edda N\u00e3o Preenchido: os casos novos com \"tipo de sa\u00edda\" igual a \"erro diagn\u00f3stico\" n\u00e3o s\u00e3o considerados no c\u00e1lculo desses indicadores. ");
        this.setCura("0");
        this.setAbandono("0");
        this.setTransfMesmoMunicipio("0");
        this.setTransfOutroMunicipio("0");
        this.setTransfOutroPais("0");
        this.setTransfOutroUf("0");
        this.setErroDiagnostico("0");
        this.setObito("0");
        this.setNaoPreenchido("0");
        this.setSubTotal("0");
        this.setTotal("0");
        this.setTransfNaoEspecificada("0");
        this.setSqlNumeradorCompletitude("");
    }

    private void calculaBrasil(DBFReader reader, Map parametros) throws ParseException {
        String coluna;
        HashMap<Object, Object> ufsBeans = new HashMap();
        DBFUtil utilDbf = new DBFUtil();
        ufsBeans = this.populaUfsBeansHanseniase();
        if (parametros.get("municipios").toString().equals("sim")) {
            ufsBeans = this.populaMunicipiosBeansHans("BR", "");
            coluna = "MUNIRESAT";
        } else {
            ufsBeans = this.populaUfsBeansHanseniase();
            coluna = "UFRESAT";
        }
        String dataInicio1 = (String)parametros.get("parDataInicio1");
        String dataFim1 = (String)parametros.get("parDataFim1");
        String dataInicio2 = (String)parametros.get("parDataInicio2");
        String dataFim2 = (String)parametros.get("parDataFim2");
        String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
        for (int k = 0; k < arquivos.length; ++k) {
            int i = 1;
            try {
                Object[] rowObjects;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                utilDbf.mapearPosicoes(reader);
                double d = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    if (utilDbf.getString(rowObjects, coluna) != null) {
                        HanseniaseCoorte hanseniaseUfResidencia = (HanseniaseCoorte)ufsBeans.get(utilDbf.getString(rowObjects, coluna));
                        String modoEntrada = utilDbf.getString(rowObjects, "MODOENTR", 1);
                        String classificacaoOperacionalAtual = utilDbf.getString(rowObjects, "CLASSATUAL", 1);
                        Date dtDiagnostico = utilDbf.getDate(rowObjects, "DT_DIAG");
                        if (hanseniaseUfResidencia != null && modoEntrada.equals("1")) {
                            if (classificacaoOperacionalAtual != null) {
                                String tipoAlta;
                                if (this.isBetweenDates(dtDiagnostico, dataInicio1, dataFim1) && classificacaoOperacionalAtual.equals("1")) {
                                    tipoAlta = utilDbf.getString(rowObjects, "TPALTA_N", 1);
                                    hanseniaseUfResidencia = this.classificaAlta(tipoAlta, hanseniaseUfResidencia);
                                }
                                if (this.isBetweenDates(dtDiagnostico, dataInicio2, dataFim2) && classificacaoOperacionalAtual.equals("2")) {
                                    tipoAlta = utilDbf.getString(rowObjects, "TPALTA_N", 1);
                                    hanseniaseUfResidencia = this.classificaAlta(tipoAlta, hanseniaseUfResidencia);
                                }
                            } else {
                                System.out.println("Classificacao operacional atual em branco");
                            }
                        }
                    }
                    float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(d)) * 100.0f;
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
                continue;
            }
            catch (DBFException dBFException) {
                Master.mensagem("Erro:\n" + (Object)((Object)dBFException));
            }
        }
        this.setBeans(new ArrayList());
        Collection<Object> municipioBean = ufsBeans.values();
        if (parametros.get("parSgUf").toString().equals("TODAS") || parametros.get("municipios").toString().equals("sim")) {
            for (HanseniaseCoorte hanseniaseCoorte : municipioBean) {
                this.getBeans().add(this.insereNoBean(hanseniaseCoorte));
            }
            Collections.sort(this.getBeans(), new BeanComparator("nomeMunicipio"));
        }
        HanseniaseCoorte agravoBean = new HanseniaseCoorte();
        agravoBean.setNomeMunicipio("BRASIL");
        agravoBean.init("");
        for (HanseniaseCoorte hanseniaseCoorte : municipioBean) {
            agravoBean.setAbandono(String.valueOf(Integer.parseInt(hanseniaseCoorte.getAbandono()) + Integer.parseInt(agravoBean.getAbandono())));
            agravoBean.setCura(String.valueOf(Integer.parseInt(hanseniaseCoorte.getCura()) + Integer.parseInt(agravoBean.getCura())));
            agravoBean.setErroDiagnostico(String.valueOf(Integer.parseInt(hanseniaseCoorte.getErroDiagnostico()) + Integer.parseInt(agravoBean.getErroDiagnostico())));
            agravoBean.setNaoPreenchido(String.valueOf(Integer.parseInt(hanseniaseCoorte.getNaoPreenchido()) + Integer.parseInt(agravoBean.getNaoPreenchido())));
            agravoBean.setObito(String.valueOf(Integer.parseInt(hanseniaseCoorte.getObito()) + Integer.parseInt(agravoBean.getObito())));
            agravoBean.setSubTotal(String.valueOf(Integer.parseInt(hanseniaseCoorte.getSubTotal()) + Integer.parseInt(agravoBean.getSubTotal())));
            agravoBean.setTotal(String.valueOf(Integer.parseInt(hanseniaseCoorte.getTotal()) + Integer.parseInt(agravoBean.getTotal())));
            agravoBean.setTransfMesmoMunicipio(String.valueOf(Integer.parseInt(hanseniaseCoorte.getTransfMesmoMunicipio()) + Integer.parseInt(agravoBean.getTransfMesmoMunicipio())));
            agravoBean.setTransfNaoEspecificada(String.valueOf(Integer.parseInt(hanseniaseCoorte.getTransfNaoEspecificada()) + Integer.parseInt(agravoBean.getTransfNaoEspecificada())));
            agravoBean.setTransfOutroMunicipio(String.valueOf(Integer.parseInt(hanseniaseCoorte.getTransfOutroMunicipio()) + Integer.parseInt(agravoBean.getTransfOutroMunicipio())));
            agravoBean.setTransfOutroPais(String.valueOf(Integer.parseInt(hanseniaseCoorte.getTransfOutroPais()) + Integer.parseInt(agravoBean.getTransfOutroPais())));
            agravoBean.setTransfOutroUf(String.valueOf(Integer.parseInt(hanseniaseCoorte.getTransfOutroUf()) + Integer.parseInt(agravoBean.getTransfOutroUf())));
        }
        this.getBeans().add(this.insereNoBean(agravoBean));
    }

    private void calculaMunicipios(DBFReader reader, Map parametros) throws ParseException {
        HashMap<Object, Object> municipiosBeans = new HashMap();
        String ufResidencia = (String)parametros.get("parUf");
        String sgUfResidencia = (String)parametros.get("parSgUf");
        String codRegional = (String)parametros.get("parCodRegional");
        DBFUtil utilDbf = new DBFUtil();
        if (codRegional == null) {
            codRegional = "";
        }
        municipiosBeans = this.populaMunicipiosBeansHans(sgUfResidencia, codRegional);
        DecimalFormat df = new DecimalFormat("0.00");
        String dataInicio1 = (String)parametros.get("parDataInicio1");
        String dataFim1 = (String)parametros.get("parDataFim1");
        String dataInicio2 = (String)parametros.get("parDataInicio2");
        String dataFim2 = (String)parametros.get("parDataFim2");
        String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
        for (int k = 0; k < arquivos.length; ++k) {
            int i = 1;
            try {
                Object[] rowObjects;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                utilDbf.mapearPosicoes(reader);
                double d = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    if (utilDbf.getString(rowObjects, "UFRESAT") != null) {
                        HanseniaseCoorte municipioResidencia = (HanseniaseCoorte)municipiosBeans.get(utilDbf.getString(rowObjects, "MUNIRESAT"));
                        String modoEntrada = utilDbf.getString(rowObjects, "MODOENTR", 1);
                        String classificacaoOperacionalAtual = utilDbf.getString(rowObjects, "CLASSATUAL", 1);
                        Date dtDiagnostico = utilDbf.getDate(rowObjects, "DT_DIAG");
                        if (municipioResidencia != null && modoEntrada.equals("1")) {
                            String tipoAlta;
                            if (this.isBetweenDates(dtDiagnostico, dataInicio1, dataFim1) && classificacaoOperacionalAtual.equals("1")) {
                                tipoAlta = utilDbf.getString(rowObjects, "TPALTA_N", 1);
                                municipioResidencia = this.classificaAlta(tipoAlta, municipioResidencia);
                            }
                            if (this.isBetweenDates(dtDiagnostico, dataInicio2, dataFim2) && classificacaoOperacionalAtual.equals("2")) {
                                tipoAlta = utilDbf.getString(rowObjects, "TPALTA_N", 1);
                                municipioResidencia = this.classificaAlta(tipoAlta, municipioResidencia);
                            }
                        }
                    }
                    float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(d)) * 100.0f;
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
                continue;
            }
            catch (DBFException dBFException) {
                Master.mensagem("Erro:\n" + (Object)((Object)dBFException));
            }
        }
        this.setBeans(new ArrayList());
        Collection<Object> municipioBean = municipiosBeans.values();
        for (HanseniaseCoorte hanseniaseCoorte : municipioBean) {
            this.getBeans().add(this.insereNoBean(hanseniaseCoorte));
        }
        Collections.sort(this.getBeans(), new BeanComparator("nomeMunicipio"));
    }

    @Override
    public void calcula(DBFReader reader, Map parametros) {
        this.populaDatas(parametros);
        this.init("");
        String municipios = (String)parametros.get("municipios");
        String brasil = (String)parametros.get("parUf");
        if (municipios.equals("sim") && !brasil.equals("brasil")) {
            try {
                this.calculaMunicipios(reader, parametros);
            }
            catch (ParseException ex) {
                System.out.println(ex);
            }
        } else {
            try {
                if (brasil.equals("brasil")) {
                    this.calculaBrasil(reader, parametros);
                } else {
                    DBFUtil utilDbf = new DBFUtil();
                    String ufResidencia = (String)parametros.get("parUf");
                    String municipioResidencia = (String)parametros.get("parMunicipio");
                    if (municipioResidencia == null) {
                        municipioResidencia = "";
                    }
                    String dataInicio1 = (String)parametros.get("parDataInicio1");
                    String dataFim1 = (String)parametros.get("parDataFim1");
                    String dataInicio2 = (String)parametros.get("parDataInicio2");
                    String dataFim2 = (String)parametros.get("parDataFim2");
                    String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
                    for (int k = 0; k < arquivos.length; ++k) {
                        Object[] rowObjects;
                        int i = 1;
                        reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                        utilDbf.mapearPosicoes(reader);
                        double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                        while ((rowObjects = reader.nextRecord()) != null) {
                            if (utilDbf.getString(rowObjects, "UFRESAT") != null && utilDbf.getString(rowObjects, "UFRESAT").equals(ufResidencia)) {
                                String modoEntrada = utilDbf.getString(rowObjects, "MODOENTR", 1);
                                String classificacaoOperacionalAtual = utilDbf.getString(rowObjects, "CLASSATUAL", 1);
                                Date dtDiagnostico = utilDbf.getDate(rowObjects, "DT_DIAG");
                                if (this.verificaMunicipio(municipioResidencia, utilDbf.getString(rowObjects, "MUNIRESAT")) && modoEntrada.equals("1")) {
                                    String tipoAlta;
                                    if (this.isBetweenDates(dtDiagnostico, dataInicio1, dataFim1) && classificacaoOperacionalAtual.equals("1")) {
                                        tipoAlta = utilDbf.getString(rowObjects, "TPALTA_N", 1);
                                        this.classificaAlta(tipoAlta);
                                    }
                                    if (this.isBetweenDates(dtDiagnostico, dataInicio2, dataFim2) && classificacaoOperacionalAtual.equals("2")) {
                                        tipoAlta = utilDbf.getString(rowObjects, "TPALTA_N", 1);
                                        this.classificaAlta(tipoAlta);
                                    }
                                }
                            }
                            float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                            this.getBarraStatus().setValue((int)percentual);
                            ++i;
                        }
                    }
                    this.setBeans(new ArrayList());
                    String nomeElemento = municipioResidencia.equals("") ? (String)parametros.get("parSgUf") : (String)parametros.get("parNomeMunicipio");
                    this.getBeans().add(this.insereNoBean(ufResidencia, nomeElemento));
                }
            }
            catch (NumberFormatException ex) {
                System.out.println(ex);
            }
            catch (ParseException ex) {
                System.out.println(ex);
            }
            catch (DBFException ex) {
                System.out.println((Object)ex);
            }
        }
    }

    @Override
    public List getBeansMunicipioEspecifico(Connection con, Map parametros) throws SQLException {
        ResultSet rs2;
        PreparedStatement stm2;
        this.populaDatas(parametros);
        if (this.isDBF()) {
            return this.getBeans();
        }
        this.init("");
        String noMunicipio = null;
        ArrayList<HanseniaseCoorte> beans = new ArrayList<HanseniaseCoorte>();
        Object d1 = null;
        DecimalFormat df = new DecimalFormat("0.0");
        String municipio = parametros.get("parMunicipio").toString();
        noMunicipio = parametros.get("parNomeMunicipio").toString();
        String sql1 = "select distinct(tp_alta) as alta,count(*) as c  from dbsinan.tb_investiga_hanseniase t1 inner join dbsinan.tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao  and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A30.9'  and  t1.co_municipio_residencia_atual= ? and tp_modo_entrada=1 and dt_diagnostico_sintoma between ? and ? and tp_classific_operacao_atual=? and ( tp_duplicidade is null or tp_duplicidade=1  ) group by tp_alta";
        try {
            stm2 = con.prepareStatement(sql1);
            stm2.setString(1, municipio);
            stm2.setString(2, parametros.get("parDataInicio1").toString());
            stm2.setString(3, parametros.get("parDataFim1").toString());
            stm2.setString(4, "1");
            rs2 = stm2.executeQuery();
        }
        catch (Exception exception) {
            sql1 = "select distinct(tp_alta) as alta,count(*) as c  from tb_investiga_hanseniase t1 inner join tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A30.9'  and  t1.co_municipio_residencia_atual = " + municipio + " and tp_modo_entrada=1 and dt_diagnostico_sintoma between '" + parametros.get("parDataInicio1").toString() + "' and '" + parametros.get("parDataFim1").toString() + "' and tp_classific_operacao_atual=1 and ( tp_duplicidade is null or tp_duplicidade=1  ) group by tp_alta";
            System.out.println(sql1);
            stm2 = con.prepareStatement(sql1);
            rs2 = stm2.executeQuery();
        }
        this.preencheValores(rs2);
        try {
            stm2 = con.prepareStatement(sql1);
            stm2.setString(1, municipio);
            stm2.setString(2, parametros.get("parDataInicio2").toString());
            stm2.setString(3, parametros.get("parDataFim2").toString());
            stm2.setString(4, "2");
            rs2 = stm2.executeQuery();
        }
        catch (Exception exception) {
            sql1 = "select distinct(tp_alta) as alta,count(*) as c  from tb_investiga_hanseniase t1 inner join tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao  and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A30.9'  and  t1.co_municipio_residencia_atual = " + municipio + " and tp_modo_entrada=1 and dt_diagnostico_sintoma between '" + parametros.get("parDataInicio2").toString() + "' and '" + parametros.get("parDataFim2").toString() + "' and tp_classific_operacao_atual=2 and ( tp_duplicidade is null or tp_duplicidade=1  ) group by tp_alta";
            System.out.println(sql1);
            stm2 = con.prepareStatement(sql1);
            rs2 = stm2.executeQuery();
        }
        this.preencheValores(rs2);
        beans.add(this.insereNoBean(municipio, noMunicipio));
        System.out.println("terminou");
        return beans;
    }

    public static String formataData(String data) {
        String[] d = data.split("-");
        return d[2] + "/" + d[1] + "/" + d[0];
    }

    public void populaDatas(Map parametros) {
        dtMbFinal = HanseniaseCoorte.formataData(parametros.get("parDataFim2").toString());
        dtMbInicial = HanseniaseCoorte.formataData(parametros.get("parDataInicio2").toString());
        dtPbFinal = HanseniaseCoorte.formataData(parametros.get("parDataFim1").toString());
        dtPbInicial = HanseniaseCoorte.formataData(parametros.get("parDataInicio1").toString());
    }

    @Override
    public List getBeansEstadoEspecifico(Connection con, Map parametros) throws SQLException {
        this.populaDatas(parametros);
        if (this.isDBF()) {
            return this.getBeans();
        }
        if (parametros.get("municipios").equals("nao")) {
            return this.getBeanEstadoEspecifico(con, parametros);
        }
        return this.getBeanMunicipios(con, parametros);
    }

    @Override
    public List getBeanMunicipios(Connection con, Map parametros) throws SQLException {
        ResultSet rs;
        this.populaDatas(parametros);
        if (this.isDBF()) {
            return this.getBeans();
        }
        Statement stm = con.createStatement();
        String noMunicipio = null;
        ArrayList<HanseniaseCoorte> beans = new ArrayList<HanseniaseCoorte>();
        Object d1 = null;
        if (parametros.get("parNomeRegional") == null) {
            parametros.put("parNomeRegional", "-- Selecione --");
        }
        String sql = parametros.get("parNomeRegional").equals("Todas Regionais") || parametros.get("parNomeRegional").equals("-- Selecione --") ? "select co_municipio_ibge,no_municipio from dbgeral.tb_municipio where sg_uf = '" + parametros.get("parSgUf") + "' order by no_municipio" : "select t1.co_municipio_ibge,no_municipio from dbgeral.tb_municipio as t1, dblocalidade.rl_regional_municipio_svs as t2 where t2.co_uf_ibge=" + parametros.get("parUf") + " and t1.co_municipio_ibge=t2.co_municipio_ibge and co_regional = '" + parametros.get("parCodRegional") + "' and no_municipio not like '%Ignorado%'  order by no_municipio";
        try {
            rs = stm.executeQuery(sql);
        }
        catch (Exception exception) {
            sql = parametros.get("parNomeRegional").equals("Todas Regionais") || parametros.get("parNomeRegional").equals("-- Selecione --") ? "select co_municipio_ibge,no_municipio from tb_municipio where sg_uf = '" + parametros.get("parSgUf") + "' order by no_municipio" : "select t1.co_municipio_ibge,no_municipio from tb_municipio as t1, rl_regional_municipio_svs as t2 where t2.co_uf_ibge=" + parametros.get("parUf") + " and t1.co_municipio_ibge=t2.co_municipio_ibge and co_regional = '" + parametros.get("parCodRegional") + "' and no_municipio not like '%Ignorado%'  order by no_municipio";
            rs = stm.executeQuery(sql);
        }
        this.init("");
        while (rs.next()) {
            ResultSet rs2;
            PreparedStatement stm2;
            this.init("");
            String municipio = rs.getString("co_municipio_ibge");
            noMunicipio = rs.getString("no_municipio");
            String sql1 = "select distinct(tp_alta) as alta,count(*) as c  from dbsinan.tb_investiga_hanseniase t1 inner join dbsinan.tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao  and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A30.9'  and  t1.co_municipio_residencia_atual= ? and tp_modo_entrada=1 and dt_diagnostico_sintoma between ? and ? and tp_classific_operacao_atual=? and ( tp_duplicidade is null or tp_duplicidade=1  ) group by tp_alta";
            try {
                stm2 = con.prepareStatement(sql1);
                stm2.setString(1, municipio);
                stm2.setString(2, parametros.get("parDataInicio1").toString());
                stm2.setString(3, parametros.get("parDataFim1").toString());
                stm2.setString(4, "1");
                rs2 = stm2.executeQuery();
            }
            catch (Exception exception) {
                sql1 = "select distinct(tp_alta) as alta,count(*) as c  from tb_investiga_hanseniase t1 inner join tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao  and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A30.9'  and  t1.co_municipio_residencia_atual = " + municipio + " and tp_modo_entrada=1 and dt_diagnostico_sintoma between '" + parametros.get("parDataInicio1").toString() + "' and '" + parametros.get("parDataFim1").toString() + "' and tp_classific_operacao_atual=1 and ( tp_duplicidade is null or tp_duplicidade=1  ) group by tp_alta";
                stm2 = con.prepareStatement(sql1);
                rs2 = stm2.executeQuery();
            }
            this.preencheValores(rs2);
            try {
                stm2 = con.prepareStatement(sql1);
                stm2.setString(1, municipio);
                stm2.setString(2, parametros.get("parDataInicio2").toString());
                stm2.setString(3, parametros.get("parDataFim2").toString());
                stm2.setString(4, "2");
                rs2 = stm2.executeQuery();
            }
            catch (Exception exception) {
                sql1 = "select distinct(tp_alta) as alta,count(*) as c  from tb_investiga_hanseniase t1 inner join tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao  and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A30.9'  and  t1.co_municipio_residencia_atual = " + municipio + " and tp_modo_entrada=1 and dt_diagnostico_sintoma between '" + parametros.get("parDataInicio2").toString() + "' and '" + parametros.get("parDataFim2").toString() + "' and tp_classific_operacao_atual=2 and ( tp_duplicidade is null or tp_duplicidade=1  ) group by tp_alta";
                stm2 = con.prepareStatement(sql1);
                rs2 = stm2.executeQuery();
            }
            this.preencheValores(rs2);
            beans.add(this.insereNoBean(municipio, noMunicipio));
        }
        System.out.println("terminou");
        return beans;
    }

    public void preencheValores(ResultSet rs2) throws SQLException {
        int temp = 0;
        while (rs2.next()) {
            String tipoAlta = rs2.getString("alta");
            temp = rs2.getInt("c");
            if (tipoAlta != null && !tipoAlta.equals("")) {
                this.setSubTotal(String.valueOf(temp + Integer.parseInt(this.getSubTotal())));
                if (tipoAlta.equals("1")) {
                    this.setCura(String.valueOf(temp += Integer.parseInt(this.getCura())));
                }
                if (tipoAlta.equals("2")) {
                    this.setTransfMesmoMunicipio(String.valueOf(temp += Integer.parseInt(this.getTransfMesmoMunicipio())));
                }
                if (tipoAlta.equals("3")) {
                    this.setTransfOutroMunicipio(String.valueOf(temp += Integer.parseInt(this.getTransfOutroMunicipio())));
                }
                if (tipoAlta.equals("4")) {
                    this.setTransfOutroUf(String.valueOf(temp += Integer.parseInt(this.getTransfOutroUf())));
                }
                if (tipoAlta.equals("5")) {
                    this.setTransfOutroPais(String.valueOf(temp += Integer.parseInt(this.getTransfOutroPais())));
                }
                if (tipoAlta.equals("6")) {
                    this.setObito(String.valueOf(temp += Integer.parseInt(this.getObito())));
                }
                if (tipoAlta.equals("7")) {
                    this.setAbandono(String.valueOf(temp += Integer.parseInt(this.getAbandono())));
                }
                if (tipoAlta.equals("8")) {
                    this.setSubTotal(String.valueOf(Integer.parseInt(this.getSubTotal()) - temp));
                    this.setErroDiagnostico(String.valueOf(temp += Integer.parseInt(this.getErroDiagnostico())));
                }
                if (tipoAlta.equals("9")) {
                    this.setTransfNaoEspecificada(String.valueOf(temp += Integer.parseInt(this.getTransfNaoEspecificada())));
                }
            } else {
                this.setSubTotal(String.valueOf(Integer.parseInt(this.getSubTotal()) + temp));
                this.setNaoPreenchido(String.valueOf(temp += Integer.parseInt(this.getNaoPreenchido())));
            }
            this.setSubTotal(String.valueOf(Integer.parseInt(this.getSubTotal())));
        }
    }

    private void classificaAlta(String tipoAlta) {
        int temp = 1;
        if (tipoAlta != null && !tipoAlta.equals("")) {
            this.setSubTotal(String.valueOf(temp + Integer.parseInt(this.getSubTotal())));
            if (tipoAlta.equals("1")) {
                this.setCura(String.valueOf(temp += Integer.parseInt(this.getCura())));
            }
            if (tipoAlta.equals("2")) {
                this.setTransfMesmoMunicipio(String.valueOf(temp += Integer.parseInt(this.getTransfMesmoMunicipio())));
            }
            if (tipoAlta.equals("3")) {
                this.setTransfOutroMunicipio(String.valueOf(temp += Integer.parseInt(this.getTransfOutroMunicipio())));
            }
            if (tipoAlta.equals("4")) {
                this.setTransfOutroUf(String.valueOf(temp += Integer.parseInt(this.getTransfOutroUf())));
            }
            if (tipoAlta.equals("5")) {
                this.setTransfOutroPais(String.valueOf(temp += Integer.parseInt(this.getTransfOutroPais())));
            }
            if (tipoAlta.equals("6")) {
                this.setObito(String.valueOf(temp += Integer.parseInt(this.getObito())));
            }
            if (tipoAlta.equals("7")) {
                this.setAbandono(String.valueOf(temp += Integer.parseInt(this.getAbandono())));
            }
            if (tipoAlta.equals("8")) {
                this.setSubTotal(String.valueOf(Integer.parseInt(this.getSubTotal()) - temp));
                this.setErroDiagnostico(String.valueOf(temp += Integer.parseInt(this.getErroDiagnostico())));
            }
            if (tipoAlta.equals("9")) {
                this.setTransfNaoEspecificada(String.valueOf(temp += Integer.parseInt(this.getTransfNaoEspecificada())));
            }
        } else {
            this.setSubTotal(String.valueOf(Integer.parseInt(this.getSubTotal()) + temp));
            this.setNaoPreenchido(String.valueOf(temp += Integer.parseInt(this.getNaoPreenchido())));
        }
        this.setSubTotal(String.valueOf(Integer.parseInt(this.getSubTotal())));
    }

    private HanseniaseCoorte classificaAlta(String tipoAlta, HanseniaseCoorte beanMunicipioResidencia) {
        int temp = 1;
        if (tipoAlta != null && !tipoAlta.equals("")) {
            beanMunicipioResidencia.setSubTotal(String.valueOf(temp + Integer.parseInt(beanMunicipioResidencia.getSubTotal())));
            if (tipoAlta.equals("1")) {
                beanMunicipioResidencia.setCura(String.valueOf(temp += Integer.parseInt(beanMunicipioResidencia.getCura())));
            }
            if (tipoAlta.equals("2")) {
                beanMunicipioResidencia.setTransfMesmoMunicipio(String.valueOf(temp += Integer.parseInt(beanMunicipioResidencia.getTransfMesmoMunicipio())));
            }
            if (tipoAlta.equals("3")) {
                beanMunicipioResidencia.setTransfOutroMunicipio(String.valueOf(temp += Integer.parseInt(beanMunicipioResidencia.getTransfOutroMunicipio())));
            }
            if (tipoAlta.equals("4")) {
                beanMunicipioResidencia.setTransfOutroUf(String.valueOf(temp += Integer.parseInt(beanMunicipioResidencia.getTransfOutroUf())));
            }
            if (tipoAlta.equals("5")) {
                beanMunicipioResidencia.setTransfOutroPais(String.valueOf(temp += Integer.parseInt(beanMunicipioResidencia.getTransfOutroPais())));
            }
            if (tipoAlta.equals("6")) {
                beanMunicipioResidencia.setObito(String.valueOf(temp += Integer.parseInt(beanMunicipioResidencia.getObito())));
            }
            if (tipoAlta.equals("7")) {
                beanMunicipioResidencia.setAbandono(String.valueOf(temp += Integer.parseInt(beanMunicipioResidencia.getAbandono())));
            }
            if (tipoAlta.equals("8")) {
                beanMunicipioResidencia.setSubTotal(String.valueOf(Integer.parseInt(beanMunicipioResidencia.getSubTotal()) - temp));
                beanMunicipioResidencia.setErroDiagnostico(String.valueOf(temp += Integer.parseInt(beanMunicipioResidencia.getErroDiagnostico())));
            }
            if (tipoAlta.equals("9")) {
                beanMunicipioResidencia.setTransfNaoEspecificada(String.valueOf(temp += Integer.parseInt(beanMunicipioResidencia.getTransfNaoEspecificada())));
            }
        } else {
            beanMunicipioResidencia.setSubTotal(String.valueOf(Integer.parseInt(beanMunicipioResidencia.getSubTotal()) + temp));
            beanMunicipioResidencia.setNaoPreenchido(String.valueOf(temp += Integer.parseInt(beanMunicipioResidencia.getNaoPreenchido())));
        }
        beanMunicipioResidencia.setSubTotal(String.valueOf(Integer.parseInt(beanMunicipioResidencia.getSubTotal())));
        return beanMunicipioResidencia;
    }

    public HanseniaseCoorte insereNoBean(HanseniaseCoorte beanHans) {
        DecimalFormat df = new DecimalFormat("0.0");
        if (beanHans.getSubTotal().equals("-1")) {
            beanHans.setSubTotal("0");
        }
        String sub = beanHans.getSubTotal();
        if (beanHans.getSubTotal().equals("0")) {
            sub = "1";
        }
        beanHans.setTotal(String.valueOf(Integer.valueOf(beanHans.getSubTotal()) + Integer.valueOf(beanHans.getErroDiagnostico())));
        beanHans.setPerAbandono(df.format(Float.valueOf(beanHans.getAbandono()).floatValue() / Float.valueOf(sub).floatValue() * 100.0f));
        beanHans.setPerCura(df.format(Float.valueOf(beanHans.getCura()).floatValue() / Float.valueOf(sub).floatValue() * 100.0f));
        beanHans.setPerNaoPreenchido(df.format(Float.valueOf(beanHans.getNaoPreenchido()).floatValue() / Float.valueOf(sub).floatValue() * 100.0f));
        return beanHans;
    }

    public HanseniaseCoorte insereNoBean(String municipio, String noMunicipio) {
        DecimalFormat df = new DecimalFormat("0.0");
        HanseniaseCoorte d1 = new HanseniaseCoorte(true);
        d1.setCodMunicipio(municipio);
        d1.setNomeMunicipio(noMunicipio);
        this.getBarraStatus().setString("Calculando munic\u00edpio: " + noMunicipio);
        this.setCura(String.valueOf(Integer.parseInt(this.getCura())));
        d1.setCura(this.getCura());
        d1.setTransfMesmoMunicipio(this.getTransfMesmoMunicipio());
        d1.setTransfOutroMunicipio(this.getTransfOutroMunicipio());
        d1.setTransfOutroPais(this.getTransfOutroPais());
        d1.setTransfOutroUf(this.getTransfOutroUf());
        d1.setObito(this.getObito());
        d1.setAbandono(this.getAbandono());
        d1.setErroDiagnostico(this.getErroDiagnostico());
        d1.setNaoPreenchido(this.getNaoPreenchido());
        d1.setTransfNaoEspecificada(this.getTransfNaoEspecificada());
        if (this.getSubTotal().equals("-1")) {
            this.setSubTotal("0");
        }
        d1.setSubTotal(this.getSubTotal());
        String sub = this.getSubTotal();
        if (d1.getSubTotal().equals("0")) {
            sub = "1";
        }
        d1.setTotal(String.valueOf(Integer.valueOf(this.getSubTotal()) + Integer.valueOf(this.getErroDiagnostico())));
        d1.setPerAbandono(df.format(Float.valueOf(this.getAbandono()).floatValue() / Float.valueOf(sub).floatValue() * 100.0f));
        d1.setPerCura(df.format(Float.valueOf(this.getCura()).floatValue() / Float.valueOf(sub).floatValue() * 100.0f));
        d1.setPerNaoPreenchido(df.format(Float.valueOf(this.getNaoPreenchido()).floatValue() / Float.valueOf(sub).floatValue() * 100.0f));
        return d1;
    }

    public HashMap<String, HanseniaseCoorte> populaUfsBeansHanseniase() {
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap uf = new HashMap();
        HashMap<String, HanseniaseCoorte> ufsBeans = new HashMap<String, HanseniaseCoorte>();
        DBFReader readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("UF", "dbf\\");
        try {
            Object[] rowObjects1;
            utilDbf.mapearPosicoes(readerMunicipio);
            while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                HanseniaseCoorte agravoDbf = new HanseniaseCoorte();
                agravoDbf.init("");
                agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_UF"));
                agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "SG_UF"));
                uf.put(utilDbf.getString(rowObjects1, "ID_UF"), utilDbf.getString(rowObjects1, "SG_UF"));
                ufsBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
        }
        uf = this.sortHashMapByValues(uf, false);
        Set ufKeys = ((HashMap)uf).keySet();
        HashMap<String, HanseniaseCoorte> ufsBeansRetorno = new HashMap<String, HanseniaseCoorte>();
        for (String key : ufKeys) {
            ufsBeansRetorno.put(key, (HanseniaseCoorte)ufsBeans.get(key));
        }
        return ufsBeansRetorno;
    }

    @Override
    public String getTaxaEstado(Connection con, Map parametros) throws SQLException {
        if (this.isDBF()) {
            DBFReader reader = null;
            this.calcula(reader, parametros);
            return this.getTaxaEstadual();
        }
        this.getBeanEstadoEspecifico(con, parametros);
        return "";
    }

    @Override
    public List getBeanEstadoEspecifico(Connection con, Map parametros) throws SQLException {
        ResultSet rs2;
        PreparedStatement stm2;
        this.init("");
        String noUF = null;
        ArrayList<HanseniaseCoorte> beans = new ArrayList<HanseniaseCoorte>();
        Object d1 = null;
        DecimalFormat df = new DecimalFormat("0.0");
        String uf = parametros.get("parUf").toString();
        noUF = parametros.get("parSgUf").toString();
        String sql1 = "select distinct(tp_alta) as alta,count(*) as c  from dbsinan.tb_investiga_hanseniase t1 inner join dbsinan.tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao  and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A30.9'  and  t1.co_uf_residencia_atual = ? and tp_modo_entrada=1 and dt_diagnostico_sintoma between ? and ? and tp_classific_operacao_atual=? and ( tp_duplicidade is null or tp_duplicidade=1  ) group by tp_alta";
        try {
            stm2 = con.prepareStatement(sql1);
            stm2.setString(1, uf);
            System.out.println(sql1);
            System.out.println(uf);
            System.out.println(parametros.get("parDataInicio1").toString());
            System.out.println(parametros.get("parDataFim1").toString());
            stm2.setString(2, parametros.get("parDataInicio1").toString());
            stm2.setString(3, parametros.get("parDataFim1").toString());
            stm2.setString(4, "1");
            rs2 = stm2.executeQuery();
        }
        catch (Exception exception) {
            sql1 = "select distinct(tp_alta) as alta,count(*) as c  from tb_investiga_hanseniase t1 inner join tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao  and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A30.9'  and  t1.co_uf_residencia_atual = " + uf + " and tp_modo_entrada=1 and dt_diagnostico_sintoma between '" + parametros.get("parDataInicio1").toString() + "' and '" + parametros.get("parDataFim1").toString() + "' and tp_classific_operacao_atual=1 and ( tp_duplicidade is null or tp_duplicidade=1  ) group by tp_alta";
            stm2 = con.prepareStatement(sql1);
            rs2 = stm2.executeQuery();
        }
        this.preencheValores(rs2);
        try {
            stm2.setString(4, "2");
            stm2.setString(2, parametros.get("parDataInicio2").toString());
            stm2.setString(3, parametros.get("parDataFim2").toString());
            rs2 = stm2.executeQuery();
        }
        catch (Exception exception) {
            sql1 = "select distinct(tp_alta) as alta,count(*) as c  from tb_investiga_hanseniase t1 inner join tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao  and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A30.9'  and  t1.co_uf_residencia_atual = " + uf + " and tp_modo_entrada=1 and dt_diagnostico_sintoma between '" + parametros.get("parDataInicio2").toString() + "' and '" + parametros.get("parDataFim2").toString() + "' and tp_classific_operacao_atual=2 and ( tp_duplicidade is null or tp_duplicidade=1  ) group by tp_alta";
            stm2 = con.prepareStatement(sql1);
            rs2 = stm2.executeQuery();
        }
        this.preencheValores(rs2);
        beans.add(this.insereNoBean(uf, noUF));
        System.out.println("terminou");
        return beans;
    }

    public void reset() {
        this.setCura("0");
        this.setAbandono("0");
        this.setTransfMesmoMunicipio("0");
        this.setTransfOutroMunicipio("0");
        this.setTransfOutroPais("0");
        this.setTransfOutroUf("0");
        this.setErroDiagnostico("0");
        this.setObito("0");
        this.setNaoPreenchido("0");
        this.setSubTotal("0");
        this.setTransfNaoEspecificada("0");
    }

    @Override
    public HashMap<String, ColunasDbf> getColunas() {
        HashMap<String, ColunasDbf> hashColunas = new HashMap<String, ColunasDbf>();
        hashColunas.put("ID_LOCRES", new ColunasDbf(7));
        hashColunas.put("DS_LOCRES", new ColunasDbf(30));
        hashColunas.put("ID_UFRES", new ColunasDbf(2));
        hashColunas.put("N_CURHANS", new ColunasDbf(10, 0));
        hashColunas.put("I_CURHANS", new ColunasDbf(4, 2));
        hashColunas.put("TS_ABAND", new ColunasDbf(10, 0));
        hashColunas.put("P_TSABAND", new ColunasDbf(4, 2));
        hashColunas.put("TS_MESMUN", new ColunasDbf(10, 0));
        hashColunas.put("TS_OUTMUN", new ColunasDbf(10, 0));
        hashColunas.put("TS_OUTUF", new ColunasDbf(10, 0));
        hashColunas.put("TS_OUTPA", new ColunasDbf(10, 0));
        hashColunas.put("TS_IGNOR", new ColunasDbf(10, 0));
        hashColunas.put("P_TSIGNOR", new ColunasDbf(4, 2));
        hashColunas.put("TS_TRANNE", new ColunasDbf(10, 0));
        hashColunas.put("TS_OBITO", new ColunasDbf(10, 0));
        hashColunas.put("D_SUBHANS", new ColunasDbf(4, 0));
        hashColunas.put("TS_ERRDIA", new ColunasDbf(10, 0));
        hashColunas.put("TOTAL_NOT", new ColunasDbf(4, 0));
        hashColunas.put("ORIGEM", new ColunasDbf(30));
        hashColunas.put("ANO_DIGPB", new ColunasDbf(4, 0));
        hashColunas.put("DT_DPBINI", new ColunasDbf(10));
        hashColunas.put("DT_DPBFIN", new ColunasDbf(10));
        hashColunas.put("ANO_DIGMB", new ColunasDbf(4, 0));
        hashColunas.put("DT_DMBINI", new ColunasDbf(10));
        hashColunas.put("DT_DMBFIN", new ColunasDbf(10));
        this.setColunas(hashColunas);
        return hashColunas;
    }

    @Override
    public String[] getOrdemColunas() {
        return new String[]{"ID_LOCRES", "DS_LOCRES", "ID_UFRES", "N_CURHANS", "I_CURHANS", "TS_ABAND", "P_TSABAND", "TS_MESMUN", "TS_OUTMUN", "TS_OUTUF", "TS_OUTPA", "TS_IGNOR", "P_TSIGNOR", "TS_TRANNE", "TS_OBITO", "D_SUBHANS", "TS_ERRDIA", "TOTAL_NOT", "ANO_DIGPB", "DT_DPBINI", "DT_DPBFIN", "ANO_DIGMB", "DT_DMBINI", "DT_DMBFIN", "ORIGEM"};
    }

    @Override
    public Map getParametros() {
        Util util = new Util();
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("parRodape", this.getRodape());
        parametros.put("parConfig", "");
        parametros.put("parTitulo1", this.getTitulo1());
        return parametros;
    }

    @Override
    public DBFWriter getLinhas(HashMap<String, ColunasDbf> colunas, List bean, DBFWriter writer) throws DBFException, IOException {
        for (int i = 0; i < bean.size(); ++i) {
            Object[] rowData = new Object[colunas.size()];
            HanseniaseCoorte agravo = (HanseniaseCoorte)bean.get(i);
            if (agravo.getNomeMunicipio().equals("BRASIL")) {
                rowData[0] = null;
                rowData[2] = null;
            } else {
                rowData[0] = agravo.getCodMunicipio();
                rowData[2] = agravo.getCodMunicipio().substring(0, 2);
            }
            rowData[1] = agravo.getNomeMunicipio();
            rowData[3] = Double.parseDouble(agravo.getCura());
            rowData[4] = Double.parseDouble(agravo.getPerCura().replace(",", "."));
            rowData[5] = Double.parseDouble(agravo.getAbandono());
            rowData[6] = Double.parseDouble(agravo.getPerAbandono().replace(",", "."));
            rowData[7] = Double.parseDouble(agravo.getTransfMesmoMunicipio());
            rowData[8] = Double.parseDouble(agravo.getTransfOutroMunicipio());
            rowData[9] = Double.parseDouble(agravo.getTransfOutroUf());
            rowData[10] = Double.parseDouble(agravo.getTransfOutroPais());
            rowData[11] = Double.parseDouble(agravo.getNaoPreenchido());
            rowData[12] = Double.parseDouble(agravo.getPerNaoPreenchido().replace(",", "."));
            rowData[13] = Double.parseDouble(agravo.getTransfNaoEspecificada());
            rowData[14] = Double.parseDouble(agravo.getObito());
            rowData[15] = Double.parseDouble(agravo.getSubTotal());
            rowData[16] = Double.parseDouble(agravo.getErroDiagnostico());
            rowData[17] = Double.parseDouble(agravo.getTotal());
            rowData[18] = this.preencheAno(dtPbInicial, dtPbFinal);
            rowData[19] = dtPbInicial;
            rowData[20] = dtPbFinal;
            rowData[21] = this.preencheAno(dtMbInicial, dtMbFinal);
            rowData[22] = dtMbInicial;
            rowData[23] = dtMbFinal;
            rowData[24] = "HANSENIASE-SINANNET";
            writer.addRecord(rowData);
        }
        return writer;
    }

    @Override
    public String getCaminhoJasper() {
        return "/com/org/relatorios/hanseniase.jasper";
    }

    public String getCura() {
        return this.cura;
    }

    public void setCura(String cura) {
        this.cura = cura;
    }

    public String getAbandono() {
        return this.abandono;
    }

    public void setAbandono(String abandono) {
        this.abandono = abandono;
    }

    public String getTransfMesmoMunicipio() {
        return this.transfMesmoMunicipio;
    }

    public void setTransfMesmoMunicipio(String transfMesmoMunicipio) {
        this.transfMesmoMunicipio = transfMesmoMunicipio;
    }

    public String getTransfOutroMunicipio() {
        return this.transfOutroMunicipio;
    }

    public void setTransfOutroMunicipio(String transfOutroMunicipio) {
        this.transfOutroMunicipio = transfOutroMunicipio;
    }

    public String getTransfOutroUf() {
        return this.transfOutroUf;
    }

    public void setTransfOutroUf(String transfOutroUf) {
        this.transfOutroUf = transfOutroUf;
    }

    public String getNaoPreenchido() {
        return this.naoPreenchido;
    }

    public void setNaoPreenchido(String naoPreenchido) {
        this.naoPreenchido = naoPreenchido;
    }

    public String getErroDiagnostico() {
        return this.erroDiagnostico;
    }

    public void setErroDiagnostico(String erroDiagnostico) {
        this.erroDiagnostico = erroDiagnostico;
    }

    public String getPerNaoPreenchido() {
        return this.perNaoPreenchido;
    }

    public void setPerNaoPreenchido(String perNaoPreenchido) {
        this.perNaoPreenchido = perNaoPreenchido;
    }

    public String getSubTotal() {
        return this.subTotal;
    }

    public void setSubTotal(String subTotal) {
        this.subTotal = subTotal;
    }

    public String getTotal() {
        return this.total;
    }

    public void setTotal(String total) {
        this.total = total;
    }

    public String getPerAbandono() {
        return this.perAbandono;
    }

    public void setPerAbandono(String perAbandono) {
        this.perAbandono = perAbandono;
    }

    public String getPerCura() {
        return this.perCura;
    }

    public void setPerCura(String perCura) {
        this.perCura = perCura;
    }

    public String getTransfOutroPais() {
        return this.transfOutroPais;
    }

    public void setTransfOutroPais(String transfOutroPais) {
        this.transfOutroPais = transfOutroPais;
    }

    public String getObito() {
        return this.obito;
    }

    public void setObito(String obito) {
        this.obito = obito;
    }

    @Override
    public String getTransfNaoEspecificada() {
        return this.transfNaoEspecificada;
    }

    @Override
    public void setTransfNaoEspecificada(String transfNaoEspecificada) {
        this.transfNaoEspecificada = transfNaoEspecificada;
    }

    public String getDtPbInicial() {
        return dtPbInicial;
    }

    public void setDtPbInicial(String dtPbInicial) {
        HanseniaseCoorte.dtPbInicial = dtPbInicial;
    }

    public String getDtPbFinal() {
        return dtPbFinal;
    }

    public void setDtPbFinal(String dtPbFinal) {
        HanseniaseCoorte.dtPbFinal = dtPbFinal;
    }

    public String getDtMbInicial() {
        return dtMbInicial;
    }

    public void setDtMbInicial(String dtMbInicial) {
        HanseniaseCoorte.dtMbInicial = dtMbInicial;
    }

    public String getDtMbFinal() {
        return dtMbFinal;
    }

    public void setDtMbFinal(String dtMbFinal) {
        HanseniaseCoorte.dtMbFinal = dtMbFinal;
    }
}

