/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes.agravos;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import com.org.bd.DBFUtil;
import com.org.model.classes.Agravo;
import com.org.model.classes.ColunasDbf;
import com.org.negocio.Configuracao;
import com.org.negocio.Util;
import com.org.view.Master;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;

public class HanseniaseCoorteCura
extends Agravo {
    private String cura;
    private String abandono;
    private String transfMesmoMunicipio;
    private String transfOutroMunicipio;
    private String transfOutroUf;
    private String naoPreenchido;
    private String erroDiagnostico;
    private String perNaoPreenchido;
    private String subTotal;
    private String total;
    private String perAbandono;
    private String perCura;
    private String transfOutroPais;
    private String obito;
    private String transfNaoEspecificada;
    static String dtPbInicial;
    static String dtPbFinal;
    static String dtMbInicial;
    static String dtMbFinal;

    public HanseniaseCoorteCura(boolean isDbf) {
        this.setDBF(isDbf);
        this.setPeriodo("de Diagn\u00f3stico");
        this.setTipoAgregacao("de Resid\u00eancia Atual");
        this.init("postgres");
    }

    public HanseniaseCoorteCura() {
    }

    @Override
    public void init(String tipoBanco) {
        this.setMultiplicador(100000);
        this.setTipo("hans");
        this.setTitulo1("Propor\u00e7\u00e3o de cura dos casos novos de hansen\u00edase diagnosticados nos anos das coortes");
        this.setRodape("OBS. sobre m\u00e9todo de c\u00e1lculo: \nSele\u00e7\u00e3o das coortes: Casos novos (modo de entrada = 1-Caso novo) paucibacilares (classifica\u00e7\u00e3o operacional atual) diagnosticados no ano anterior ao ano de avalia\u00e7\u00e3o e casos novos multibacilares diagnosticados 2 anos anteriores ao ano de avalia\u00e7\u00e3o. No relat\u00f3rio s\u00e3o somados os PB e os MB selecionados na base de dados do Sinan, segundo local de resid\u00eancia atual.\nC\u00e1lculo do percentual de cura: n\u00e3o s\u00e3o considerados no c\u00e1lculo desses indicadores na avalia\u00e7\u00e3o municipal:\ntranfer\u00eancia para outro munic\u00edpio, transfer\u00eancia para outro estado,tranfer\u00eancia para outro pa\u00eds e erro de diagn\u00f3stico e transfer\u00eancia n\u00e3o especificada.\nN\u00e3o s\u00e3o consierados no c\u00e1lculo desse indicador na avalia\u00e7\u00e3o estadual: transfer\u00eancia para outro estado,tranfer\u00eancia para outro pa\u00eds e erro de diagn\u00f3stico e transfer\u00eancia n\u00e3o especificada.");
        this.setCura("0");
        this.setAbandono("0");
        this.setTransfMesmoMunicipio("0");
        this.setTransfOutroMunicipio("0");
        this.setTransfOutroPais("0");
        this.setTransfOutroUf("0");
        this.setErroDiagnostico("0");
        this.setObito("0");
        this.setNaoPreenchido("0");
        this.setSubTotal("0");
        this.setTotal("0");
        this.setTransfNaoEspecificada("0");
        this.setSqlNumeradorCompletitude("");
    }

    private void calculaBrasil(DBFReader reader, Map parametros) throws ParseException {
        double taxa;
        String coluna;
        HashMap<Object, Object> ufsBeans = new HashMap();
        DBFUtil utilDbf = new DBFUtil();
        ufsBeans = this.populaUfsBeansHanseniase();
        if (parametros.get("municipios").toString().equals("sim")) {
            ufsBeans = this.populaMunicipiosBeansHansCura("BR", "");
            coluna = "MUNIRESAT";
        } else {
            ufsBeans = this.populaUfsBeansHanseniase();
            coluna = "UFRESAT";
        }
        DecimalFormat df = new DecimalFormat("0.00");
        String dataInicio1 = (String)parametros.get("parDataInicio1");
        String dataFim1 = (String)parametros.get("parDataFim1");
        String dataInicio2 = (String)parametros.get("parDataInicio2");
        String dataFim2 = (String)parametros.get("parDataFim2");
        String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
        for (int k = 0; k < arquivos.length; ++k) {
            int i = 1;
            try {
                Object[] rowObjects;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                utilDbf.mapearPosicoes(reader);
                double d = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    if (utilDbf.getString(rowObjects, coluna) != null) {
                        HanseniaseCoorteCura hanseniaseUfResidencia = (HanseniaseCoorteCura)ufsBeans.get(utilDbf.getString(rowObjects, coluna));
                        String modoEntrada = utilDbf.getString(rowObjects, "MODOENTR", 1);
                        String classificacaoOperacionalAtual = utilDbf.getString(rowObjects, "CLASSATUAL", 1);
                        Date dtDiagnostico = utilDbf.getDate(rowObjects, "DT_DIAG");
                        String esquemaDeTratamentoAtual = utilDbf.getString(rowObjects, "ESQ_ATU_N");
                        String string = esquemaDeTratamentoAtual = esquemaDeTratamentoAtual != null ? esquemaDeTratamentoAtual : "0";
                        if (hanseniaseUfResidencia != null && modoEntrada.equals("1") && (this.isBetweenDates(dtDiagnostico, dataInicio1, dataFim1) || this.isBetweenDates(dtDiagnostico, dataInicio2, dataFim2))) {
                            this.validaCriterios(rowObjects, utilDbf, classificacaoOperacionalAtual, esquemaDeTratamentoAtual, hanseniaseUfResidencia);
                        }
                    }
                    float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(d)) * 100.0f;
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
                continue;
            }
            catch (DBFException dBFException) {
                Master.mensagem("Erro:\n" + (Object)((Object)dBFException));
            }
        }
        this.setBeans(new ArrayList());
        Collection<Object> municipioBean = ufsBeans.values();
        if (parametros.get("parSgUf").toString().equals("TODAS") || parametros.get("municipios").toString().equals("sim")) {
            for (HanseniaseCoorteCura hanseniaseCoorteCura : municipioBean) {
                if (!hanseniaseCoorteCura.getCura().equals("0") && !hanseniaseCoorteCura.getSubTotal().equals("0")) {
                    taxa = Double.parseDouble(hanseniaseCoorteCura.getCura()) / Double.parseDouble(hanseniaseCoorteCura.getSubTotal());
                    hanseniaseCoorteCura.setTaxa(df.format(taxa * 100.0));
                } else {
                    hanseniaseCoorteCura.setTaxa(df.format(0L));
                }
                this.getBeans().add(this.insereNoBean(hanseniaseCoorteCura));
            }
            Collections.sort(this.getBeans(), new BeanComparator("nomeMunicipio"));
        }
        HanseniaseCoorteCura agravoBean = new HanseniaseCoorteCura();
        agravoBean.setNomeMunicipio("BRASIL");
        agravoBean.init("");
        for (HanseniaseCoorteCura hanseniaseCoorteCura : municipioBean) {
            agravoBean.setAbandono(String.valueOf(Integer.parseInt(hanseniaseCoorteCura.getAbandono()) + Integer.parseInt(agravoBean.getAbandono())));
            agravoBean.setCura(String.valueOf(Integer.parseInt(hanseniaseCoorteCura.getCura()) + Integer.parseInt(agravoBean.getCura())));
            agravoBean.setErroDiagnostico(String.valueOf(Integer.parseInt(hanseniaseCoorteCura.getErroDiagnostico()) + Integer.parseInt(agravoBean.getErroDiagnostico())));
            agravoBean.setNaoPreenchido(String.valueOf(Integer.parseInt(hanseniaseCoorteCura.getNaoPreenchido()) + Integer.parseInt(agravoBean.getNaoPreenchido())));
            agravoBean.setObito(String.valueOf(Integer.parseInt(hanseniaseCoorteCura.getObito()) + Integer.parseInt(agravoBean.getObito())));
            agravoBean.setSubTotal(String.valueOf(Integer.parseInt(hanseniaseCoorteCura.getSubTotal()) + Integer.parseInt(agravoBean.getSubTotal())));
            agravoBean.setTotal(String.valueOf(Integer.parseInt(hanseniaseCoorteCura.getTotal()) + Integer.parseInt(agravoBean.getTotal())));
            agravoBean.setTransfMesmoMunicipio(String.valueOf(Integer.parseInt(hanseniaseCoorteCura.getTransfMesmoMunicipio()) + Integer.parseInt(agravoBean.getTransfMesmoMunicipio())));
            agravoBean.setTransfNaoEspecificada(String.valueOf(Integer.parseInt(hanseniaseCoorteCura.getTransfNaoEspecificada()) + Integer.parseInt(agravoBean.getTransfNaoEspecificada())));
            agravoBean.setTransfOutroMunicipio(String.valueOf(Integer.parseInt(hanseniaseCoorteCura.getTransfOutroMunicipio()) + Integer.parseInt(agravoBean.getTransfOutroMunicipio())));
            agravoBean.setTransfOutroPais(String.valueOf(Integer.parseInt(hanseniaseCoorteCura.getTransfOutroPais()) + Integer.parseInt(agravoBean.getTransfOutroPais())));
            agravoBean.setTransfOutroUf(String.valueOf(Integer.parseInt(hanseniaseCoorteCura.getTransfOutroUf()) + Integer.parseInt(agravoBean.getTransfOutroUf())));
            if (!agravoBean.getCura().equals("0") && !agravoBean.getSubTotal().equals("0")) {
                taxa = Double.parseDouble(agravoBean.getCura()) / Double.parseDouble(agravoBean.getSubTotal());
                agravoBean.setTaxa(df.format(taxa * 100.0));
                continue;
            }
            agravoBean.setTaxa(df.format(0L));
        }
        this.getBeans().add(this.insereNoBean(agravoBean));
    }

    private void validaCriteriosSemReferenciaDeMunicipio(Object[] rowObjects, DBFUtil utilDbf, String classificacaoOperacionalAtual, String esquemaDeTratamentoAtual, HanseniaseCoorteCura municipioResidencia) {
        if ((classificacaoOperacionalAtual.equals("1") || classificacaoOperacionalAtual.equals("2")) && (esquemaDeTratamentoAtual.equals("1") || esquemaDeTratamentoAtual.equals("2"))) {
            String tipoAlta = utilDbf.getString(rowObjects, "TPALTA_N", 1);
            tipoAlta = tipoAlta != null ? tipoAlta : "";
            this.classificaAlta(tipoAlta);
        }
    }

    private void calculaMunicipios(DBFReader reader, Map parametros) throws ParseException {
        HashMap<Object, Object> municipiosBeans = new HashMap();
        String ufResidencia = (String)parametros.get("parUf");
        String sgUfResidencia = (String)parametros.get("parSgUf");
        String codRegional = (String)parametros.get("parCodRegional");
        DBFUtil utilDbf = new DBFUtil();
        if (codRegional == null) {
            codRegional = "";
        }
        municipiosBeans = this.populaMunicipiosBeansHansCura(sgUfResidencia, codRegional);
        DecimalFormat df = new DecimalFormat("0.00");
        String dataInicio1 = (String)parametros.get("parDataInicio1");
        String dataFim1 = (String)parametros.get("parDataFim1");
        String dataInicio2 = (String)parametros.get("parDataInicio2");
        String dataFim2 = (String)parametros.get("parDataFim2");
        String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
        for (int k = 0; k < arquivos.length; ++k) {
            int i = 1;
            try {
                Object[] rowObjects;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                utilDbf.mapearPosicoes(reader);
                double d = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    if (utilDbf.getString(rowObjects, "UFRESAT") != null) {
                        HanseniaseCoorteCura municipioResidencia = (HanseniaseCoorteCura)municipiosBeans.get(utilDbf.getString(rowObjects, "MUNIRESAT"));
                        String modoEntrada = utilDbf.getString(rowObjects, "MODOENTR", 1);
                        String classificacaoOperacionalAtual = utilDbf.getString(rowObjects, "CLASSATUAL", 1);
                        Date dtDiagnostico = utilDbf.getDate(rowObjects, "DT_DIAG");
                        String esquemaDeTratamentoAtual = utilDbf.getString(rowObjects, "ESQ_ATU_N");
                        String string = esquemaDeTratamentoAtual = esquemaDeTratamentoAtual != null ? esquemaDeTratamentoAtual : "0";
                        if (municipioResidencia != null && modoEntrada.equals("1") && (this.isBetweenDates(dtDiagnostico, dataInicio1, dataFim1) || this.isBetweenDates(dtDiagnostico, dataInicio2, dataFim2))) {
                            this.validaCriterios(rowObjects, utilDbf, classificacaoOperacionalAtual, esquemaDeTratamentoAtual, municipioResidencia);
                        }
                    }
                    float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(d)) * 100.0f;
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
                continue;
            }
            catch (DBFException dBFException) {
                Master.mensagem("Erro:\n" + (Object)((Object)dBFException));
            }
        }
        this.setBeans(new ArrayList());
        Collection<Object> municipioBean = municipiosBeans.values();
        for (HanseniaseCoorteCura hanseniaseCoorteCura : municipioBean) {
            double taxa = !hanseniaseCoorteCura.getCura().equals("0") && !hanseniaseCoorteCura.getSubTotal().equals("0") ? Double.parseDouble(hanseniaseCoorteCura.getCura()) / Double.parseDouble(hanseniaseCoorteCura.getSubTotal()) : 0.0;
            hanseniaseCoorteCura.setTaxa(df.format(taxa * 100.0));
            this.getBeans().add(this.insereNoBean(hanseniaseCoorteCura));
        }
        Collections.sort(this.getBeans(), new BeanComparator("nomeMunicipio"));
    }

    private void validaCriterios(Object[] rowObjects, DBFUtil utilDbf, String classificacaoOperacionalAtual, String esquemaDeTratamentoAtual, HanseniaseCoorteCura municipioResidencia) {
        if ((classificacaoOperacionalAtual.equals("1") || classificacaoOperacionalAtual.equals("2")) && (esquemaDeTratamentoAtual.equals("1") || esquemaDeTratamentoAtual.equals("2"))) {
            String tipoAlta = utilDbf.getString(rowObjects, "TPALTA_N", 1);
            tipoAlta = tipoAlta != null ? tipoAlta : "";
            municipioResidencia = this.classificaAlta(tipoAlta, municipioResidencia);
        }
    }

    @Override
    public void calcula(DBFReader reader, Map parametros) {
        this.populaDatas(parametros);
        this.init("");
        String municipios = (String)parametros.get("municipios");
        String brasil = (String)parametros.get("parUf");
        if (municipios.equals("sim") && !brasil.equals("brasil")) {
            try {
                this.calculaMunicipios(reader, parametros);
            }
            catch (ParseException ex) {
                System.out.println(ex);
            }
        } else {
            try {
                if (brasil.equals("brasil")) {
                    this.calculaBrasil(reader, parametros);
                } else {
                    DBFUtil utilDbf = new DBFUtil();
                    DecimalFormat df = new DecimalFormat("0.00");
                    String ufResidencia = (String)parametros.get("parUf");
                    String municipioResidencia = (String)parametros.get("parMunicipio");
                    if (municipioResidencia == null) {
                        municipioResidencia = "";
                    }
                    String dataInicio1 = (String)parametros.get("parDataInicio1");
                    String dataFim1 = (String)parametros.get("parDataFim1");
                    String dataInicio2 = (String)parametros.get("parDataInicio2");
                    String dataFim2 = (String)parametros.get("parDataFim2");
                    String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
                    for (int k = 0; k < arquivos.length; ++k) {
                        Object[] rowObjects;
                        int i = 1;
                        reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                        utilDbf.mapearPosicoes(reader);
                        double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                        while ((rowObjects = reader.nextRecord()) != null) {
                            if (utilDbf.getString(rowObjects, "UFRESAT") != null && utilDbf.getString(rowObjects, "UFRESAT").equals(ufResidencia)) {
                                String modoEntrada = utilDbf.getString(rowObjects, "MODOENTR", 1);
                                String classificacaoOperacionalAtual = utilDbf.getString(rowObjects, "CLASSATUAL", 1);
                                Date dtDiagnostico = utilDbf.getDate(rowObjects, "DT_DIAG");
                                String esquemaDeTratamentoAtual = utilDbf.getString(rowObjects, "ESQ_ATU_N");
                                String string = esquemaDeTratamentoAtual = esquemaDeTratamentoAtual != null ? esquemaDeTratamentoAtual : "0";
                                if (this.verificaMunicipio(municipioResidencia, utilDbf.getString(rowObjects, "MUNIRESAT")) && modoEntrada.equals("1") && (this.isBetweenDates(dtDiagnostico, dataInicio1, dataFim1) || this.isBetweenDates(dtDiagnostico, dataInicio2, dataFim2))) {
                                    this.validaCriteriosSemReferenciaDeMunicipio(rowObjects, utilDbf, classificacaoOperacionalAtual, esquemaDeTratamentoAtual, this);
                                }
                            }
                            float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                            this.getBarraStatus().setValue((int)percentual);
                            ++i;
                        }
                    }
                    this.setBeans(new ArrayList());
                    String nomeElemento = municipioResidencia.equals("") ? (String)parametros.get("parSgUf") : (String)parametros.get("parNomeMunicipio");
                    this.getBeans().add(this.insereNoBean(ufResidencia, nomeElemento));
                }
            }
            catch (NumberFormatException ex) {
                System.out.println(ex);
            }
            catch (ParseException ex) {
                System.out.println(ex);
            }
            catch (DBFException ex) {
                System.out.println((Object)ex);
            }
        }
    }

    @Override
    public List getBeansMunicipioEspecifico(Connection con, Map parametros) throws SQLException {
        ResultSet rs2;
        PreparedStatement stm2;
        this.populaDatas(parametros);
        if (this.isDBF()) {
            return this.getBeans();
        }
        this.init("");
        String noMunicipio = null;
        ArrayList<HanseniaseCoorteCura> beans = new ArrayList<HanseniaseCoorteCura>();
        Object d1 = null;
        DecimalFormat df = new DecimalFormat("0.00");
        String municipio = parametros.get("parMunicipio").toString();
        noMunicipio = parametros.get("parNomeMunicipio").toString();
        String sql1 = "select distinct(tp_alta) as alta,count(*) as c  from dbsinan.tb_investiga_hanseniase t1 inner join dbsinan.tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao  and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A30.9'  and  t1.co_municipio_residencia_atual= ? and tp_modo_entrada=1 and dt_diagnostico_sintoma between ? and ? and tp_classific_operacao_atual=? and ( tp_duplicidade is null or tp_duplicidade=1  ) group by tp_alta";
        try {
            stm2 = con.prepareStatement(sql1);
            stm2.setString(1, municipio);
            stm2.setString(2, parametros.get("parDataInicio1").toString());
            stm2.setString(3, parametros.get("parDataFim1").toString());
            stm2.setString(4, "1");
            rs2 = stm2.executeQuery();
        }
        catch (Exception exception) {
            sql1 = "select distinct(tp_alta) as alta,count(*) as c  from tb_investiga_hanseniase t1 inner join tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A30.9'  and  t1.co_municipio_residencia_atual = " + municipio + " and tp_modo_entrada=1 and dt_diagnostico_sintoma between '" + parametros.get("parDataInicio1").toString() + "' and '" + parametros.get("parDataFim1").toString() + "' and tp_classific_operacao_atual=1 and ( tp_duplicidade is null or tp_duplicidade=1  ) group by tp_alta";
            System.out.println(sql1);
            stm2 = con.prepareStatement(sql1);
            rs2 = stm2.executeQuery();
        }
        this.preencheValores(rs2);
        try {
            stm2 = con.prepareStatement(sql1);
            stm2.setString(1, municipio);
            stm2.setString(2, parametros.get("parDataInicio2").toString());
            stm2.setString(3, parametros.get("parDataFim2").toString());
            stm2.setString(4, "2");
            rs2 = stm2.executeQuery();
        }
        catch (Exception exception) {
            sql1 = "select distinct(tp_alta) as alta,count(*) as c  from tb_investiga_hanseniase t1 inner join tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao  and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A30.9'  and  t1.co_municipio_residencia_atual = " + municipio + " and tp_modo_entrada=1 and dt_diagnostico_sintoma between '" + parametros.get("parDataInicio2").toString() + "' and '" + parametros.get("parDataFim2").toString() + "' and tp_classific_operacao_atual=2 and ( tp_duplicidade is null or tp_duplicidade=1  ) group by tp_alta";
            System.out.println(sql1);
            stm2 = con.prepareStatement(sql1);
            rs2 = stm2.executeQuery();
        }
        this.preencheValores(rs2);
        beans.add(this.insereNoBean(municipio, noMunicipio));
        System.out.println("terminou");
        return beans;
    }

    public static String formataData(String data) {
        String[] d = data.split("-");
        return d[2] + "/" + d[1] + "/" + d[0];
    }

    public void populaDatas(Map parametros) {
        dtMbFinal = HanseniaseCoorteCura.formataData(parametros.get("parDataFim2").toString());
        dtMbInicial = HanseniaseCoorteCura.formataData(parametros.get("parDataInicio2").toString());
        dtPbFinal = HanseniaseCoorteCura.formataData(parametros.get("parDataFim1").toString());
        dtPbInicial = HanseniaseCoorteCura.formataData(parametros.get("parDataInicio1").toString());
    }

    @Override
    public List getBeansEstadoEspecifico(Connection con, Map parametros) throws SQLException {
        this.populaDatas(parametros);
        if (this.isDBF()) {
            return this.getBeans();
        }
        if (parametros.get("municipios").equals("nao")) {
            return this.getBeanEstadoEspecifico(con, parametros);
        }
        return this.getBeanMunicipios(con, parametros);
    }

    @Override
    public List getBeanMunicipios(Connection con, Map parametros) throws SQLException {
        ResultSet rs;
        this.populaDatas(parametros);
        if (this.isDBF()) {
            return this.getBeans();
        }
        Statement stm = con.createStatement();
        String noMunicipio = null;
        ArrayList<HanseniaseCoorteCura> beans = new ArrayList<HanseniaseCoorteCura>();
        Object d1 = null;
        if (parametros.get("parNomeRegional") == null) {
            parametros.put("parNomeRegional", "-- Selecione --");
        }
        String sql = parametros.get("parNomeRegional").equals("Todas Regionais") || parametros.get("parNomeRegional").equals("-- Selecione --") ? "select co_municipio_ibge,no_municipio from dbgeral.tb_municipio where sg_uf = '" + parametros.get("parSgUf") + "' order by no_municipio" : "select t1.co_municipio_ibge,no_municipio from dbgeral.tb_municipio as t1, dblocalidade.rl_regional_municipio_svs as t2 where t2.co_uf_ibge=" + parametros.get("parUf") + " and t1.co_municipio_ibge=t2.co_municipio_ibge and co_regional = '" + parametros.get("parCodRegional") + "' and no_municipio not like '%Ignorado%'  order by no_municipio";
        try {
            rs = stm.executeQuery(sql);
        }
        catch (Exception exception) {
            sql = parametros.get("parNomeRegional").equals("Todas Regionais") || parametros.get("parNomeRegional").equals("-- Selecione --") ? "select co_municipio_ibge,no_municipio from tb_municipio where sg_uf = '" + parametros.get("parSgUf") + "' order by no_municipio" : "select t1.co_municipio_ibge,no_municipio from tb_municipio as t1, rl_regional_municipio_svs as t2 where t2.co_uf_ibge=" + parametros.get("parUf") + " and t1.co_municipio_ibge=t2.co_municipio_ibge and co_regional = '" + parametros.get("parCodRegional") + "' and no_municipio not like '%Ignorado%'  order by no_municipio";
            rs = stm.executeQuery(sql);
        }
        this.init("");
        while (rs.next()) {
            ResultSet rs2;
            PreparedStatement stm2;
            this.init("");
            String municipio = rs.getString("co_municipio_ibge");
            noMunicipio = rs.getString("no_municipio");
            String sql1 = "select distinct(tp_alta) as alta,count(*) as c  from dbsinan.tb_investiga_hanseniase t1 inner join dbsinan.tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao  and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A30.9'  and  t1.co_municipio_residencia_atual= ? and tp_modo_entrada=1 and dt_diagnostico_sintoma between ? and ? and tp_classific_operacao_atual=? and ( tp_duplicidade is null or tp_duplicidade=1  ) group by tp_alta";
            try {
                stm2 = con.prepareStatement(sql1);
                stm2.setString(1, municipio);
                stm2.setString(2, parametros.get("parDataInicio1").toString());
                stm2.setString(3, parametros.get("parDataFim1").toString());
                stm2.setString(4, "1");
                rs2 = stm2.executeQuery();
            }
            catch (Exception exception) {
                sql1 = "select distinct(tp_alta) as alta,count(*) as c  from tb_investiga_hanseniase t1 inner join tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao  and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A30.9'  and  t1.co_municipio_residencia_atual = " + municipio + " and tp_modo_entrada=1 and dt_diagnostico_sintoma between '" + parametros.get("parDataInicio1").toString() + "' and '" + parametros.get("parDataFim1").toString() + "' and tp_classific_operacao_atual=1 and ( tp_duplicidade is null or tp_duplicidade=1  ) group by tp_alta";
                stm2 = con.prepareStatement(sql1);
                rs2 = stm2.executeQuery();
            }
            this.preencheValores(rs2);
            try {
                stm2 = con.prepareStatement(sql1);
                stm2.setString(1, municipio);
                stm2.setString(2, parametros.get("parDataInicio2").toString());
                stm2.setString(3, parametros.get("parDataFim2").toString());
                stm2.setString(4, "2");
                rs2 = stm2.executeQuery();
            }
            catch (Exception exception) {
                sql1 = "select distinct(tp_alta) as alta,count(*) as c  from tb_investiga_hanseniase t1 inner join tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao  and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A30.9'  and  t1.co_municipio_residencia_atual = " + municipio + " and tp_modo_entrada=1 and dt_diagnostico_sintoma between '" + parametros.get("parDataInicio2").toString() + "' and '" + parametros.get("parDataFim2").toString() + "' and tp_classific_operacao_atual=2 and ( tp_duplicidade is null or tp_duplicidade=1  ) group by tp_alta";
                stm2 = con.prepareStatement(sql1);
                rs2 = stm2.executeQuery();
            }
            this.preencheValores(rs2);
            beans.add(this.insereNoBean(municipio, noMunicipio));
        }
        System.out.println("terminou");
        return beans;
    }

    public void preencheValores(ResultSet rs2) throws SQLException {
        int temp = 0;
        while (rs2.next()) {
            String tipoAlta = rs2.getString("alta");
            temp = rs2.getInt("c");
            if (tipoAlta != null && !tipoAlta.equals("")) {
                this.setSubTotal(String.valueOf(temp + Integer.parseInt(this.getSubTotal())));
                if (tipoAlta.equals("1")) {
                    this.setCura(String.valueOf(temp += Integer.parseInt(this.getCura())));
                }
                if (tipoAlta.equals("2")) {
                    this.setTransfMesmoMunicipio(String.valueOf(temp += Integer.parseInt(this.getTransfMesmoMunicipio())));
                }
                if (tipoAlta.equals("3")) {
                    this.setTransfOutroMunicipio(String.valueOf(temp += Integer.parseInt(this.getTransfOutroMunicipio())));
                }
                if (tipoAlta.equals("4")) {
                    this.setTransfOutroUf(String.valueOf(temp += Integer.parseInt(this.getTransfOutroUf())));
                }
                if (tipoAlta.equals("5")) {
                    this.setTransfOutroPais(String.valueOf(temp += Integer.parseInt(this.getTransfOutroPais())));
                }
                if (tipoAlta.equals("6")) {
                    this.setObito(String.valueOf(temp += Integer.parseInt(this.getObito())));
                }
                if (tipoAlta.equals("7")) {
                    this.setAbandono(String.valueOf(temp += Integer.parseInt(this.getAbandono())));
                }
                if (tipoAlta.equals("8")) {
                    this.setSubTotal(String.valueOf(Integer.parseInt(this.getSubTotal()) - temp));
                    this.setErroDiagnostico(String.valueOf(temp += Integer.parseInt(this.getErroDiagnostico())));
                }
                if (tipoAlta.equals("9")) {
                    this.setTransfNaoEspecificada(String.valueOf(temp += Integer.parseInt(this.getTransfNaoEspecificada())));
                }
            } else {
                this.setSubTotal(String.valueOf(Integer.parseInt(this.getSubTotal()) + temp));
                this.setNaoPreenchido(String.valueOf(temp += Integer.parseInt(this.getNaoPreenchido())));
            }
            this.setSubTotal(String.valueOf(Integer.parseInt(this.getSubTotal())));
        }
    }

    private void classificaAlta(String tipoAlta) {
        if (tipoAlta.equals("1") || tipoAlta.equals("2") || tipoAlta.equals("3") || tipoAlta.equals("6") || tipoAlta.equals("7") || tipoAlta.equals("")) {
            this.setSubTotal(String.valueOf(1 + Integer.parseInt(this.getSubTotal())));
        }
        if (tipoAlta.equals("1")) {
            this.setCura(String.valueOf(1 + Integer.parseInt(this.getCura())));
        }
        this.setSubTotal(String.valueOf(Integer.parseInt(this.getSubTotal())));
    }

    private HanseniaseCoorteCura classificaAlta(String tipoAlta, HanseniaseCoorteCura beanMunicipioResidencia) {
        if (tipoAlta.equals("1") || tipoAlta.equals("2") || tipoAlta.equals("3") || tipoAlta.equals("6") || tipoAlta.equals("7") || tipoAlta.equals("")) {
            beanMunicipioResidencia.setSubTotal(String.valueOf(1 + Integer.parseInt(beanMunicipioResidencia.getSubTotal())));
        }
        if (tipoAlta.equals("1")) {
            beanMunicipioResidencia.setCura(String.valueOf(1 + Integer.parseInt(beanMunicipioResidencia.getCura())));
        }
        return beanMunicipioResidencia;
    }

    public HanseniaseCoorteCura insereNoBean(HanseniaseCoorteCura beanHans) {
        DecimalFormat df = new DecimalFormat("0.00");
        if (beanHans.getSubTotal().equals("-1")) {
            beanHans.setSubTotal("0");
        }
        String sub = beanHans.getSubTotal();
        if (beanHans.getSubTotal().equals("0")) {
            sub = "1";
        }
        beanHans.setTotal(String.valueOf(Integer.valueOf(beanHans.getSubTotal()) + Integer.valueOf(beanHans.getErroDiagnostico())));
        beanHans.setPerAbandono(df.format(Float.valueOf(beanHans.getAbandono()).floatValue() / Float.valueOf(sub).floatValue() * 100.0f));
        beanHans.setPerCura(df.format(Float.valueOf(beanHans.getCura()).floatValue() / Float.valueOf(sub).floatValue() * 100.0f));
        beanHans.setPerNaoPreenchido(df.format(Float.valueOf(beanHans.getNaoPreenchido()).floatValue() / Float.valueOf(sub).floatValue() * 100.0f));
        return beanHans;
    }

    public HanseniaseCoorteCura insereNoBean(String municipio, String noMunicipio) {
        DecimalFormat df = new DecimalFormat("0.00");
        HanseniaseCoorteCura d1 = new HanseniaseCoorteCura(true);
        d1.setCodMunicipio(municipio);
        d1.setNomeMunicipio(noMunicipio);
        this.getBarraStatus().setString("Calculando munic\u00edpio: " + noMunicipio);
        this.setCura(String.valueOf(Integer.parseInt(this.getCura())));
        d1.setCura(this.getCura());
        d1.setTransfMesmoMunicipio(this.getTransfMesmoMunicipio());
        d1.setTransfOutroMunicipio(this.getTransfOutroMunicipio());
        d1.setTransfOutroPais(this.getTransfOutroPais());
        d1.setTransfOutroUf(this.getTransfOutroUf());
        d1.setObito(this.getObito());
        d1.setAbandono(this.getAbandono());
        d1.setErroDiagnostico(this.getErroDiagnostico());
        d1.setNaoPreenchido(this.getNaoPreenchido());
        d1.setTransfNaoEspecificada(this.getTransfNaoEspecificada());
        if (this.getSubTotal().equals("-1")) {
            this.setSubTotal("0");
        }
        d1.setSubTotal(this.getSubTotal());
        String sub = this.getSubTotal();
        if (d1.getSubTotal().equals("0")) {
            sub = "1";
        }
        d1.setTotal(String.valueOf(Integer.valueOf(this.getSubTotal()) + Integer.valueOf(this.getErroDiagnostico())));
        d1.setPerAbandono(df.format(Float.valueOf(this.getAbandono()).floatValue() / Float.valueOf(sub).floatValue() * 100.0f));
        d1.setPerCura(df.format(Float.valueOf(this.getCura()).floatValue() / Float.valueOf(sub).floatValue() * 100.0f));
        d1.setPerNaoPreenchido(df.format(Float.valueOf(this.getNaoPreenchido()).floatValue() / Float.valueOf(sub).floatValue() * 100.0f));
        double taxa = !d1.getCura().equals("0") && !d1.getSubTotal().equals("0") ? Double.parseDouble(d1.getCura()) / Double.parseDouble(d1.getSubTotal()) : 0.0;
        d1.setTaxa(df.format(taxa * 100.0));
        return d1;
    }

    public HashMap<String, HanseniaseCoorteCura> populaUfsBeansHanseniase() {
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap uf = new HashMap();
        HashMap<String, HanseniaseCoorteCura> ufsBeans = new HashMap<String, HanseniaseCoorteCura>();
        DBFReader readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("UF", "dbf\\");
        try {
            Object[] rowObjects1;
            utilDbf.mapearPosicoes(readerMunicipio);
            while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                HanseniaseCoorteCura agravoDbf = new HanseniaseCoorteCura();
                agravoDbf.init("");
                agravoDbf.setCodMunicipio(utilDbf.getString(rowObjects1, "ID_UF"));
                agravoDbf.setNomeMunicipio(utilDbf.getString(rowObjects1, "SG_UF"));
                uf.put(utilDbf.getString(rowObjects1, "ID_UF"), utilDbf.getString(rowObjects1, "SG_UF"));
                ufsBeans.put(agravoDbf.getCodMunicipio(), agravoDbf);
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
        }
        uf = this.sortHashMapByValues(uf, false);
        Set ufKeys = ((HashMap)uf).keySet();
        HashMap<String, HanseniaseCoorteCura> ufsBeansRetorno = new HashMap<String, HanseniaseCoorteCura>();
        for (String key : ufKeys) {
            ufsBeansRetorno.put(key, (HanseniaseCoorteCura)ufsBeans.get(key));
        }
        return ufsBeansRetorno;
    }

    @Override
    public String getTaxaEstado(Connection con, Map parametros) throws SQLException {
        if (this.isDBF()) {
            DBFReader reader = null;
            this.calcula(reader, parametros);
            return this.getTaxaEstadual();
        }
        this.getBeanEstadoEspecifico(con, parametros);
        return "";
    }

    @Override
    public List getBeanEstadoEspecifico(Connection con, Map parametros) throws SQLException {
        ResultSet rs2;
        PreparedStatement stm2;
        this.init("");
        String noUF = null;
        ArrayList<HanseniaseCoorteCura> beans = new ArrayList<HanseniaseCoorteCura>();
        Object d1 = null;
        DecimalFormat df = new DecimalFormat("0.00");
        String uf = parametros.get("parUf").toString();
        noUF = parametros.get("parSgUf").toString();
        String sql1 = "select distinct(tp_alta) as alta,count(*) as c  from dbsinan.tb_investiga_hanseniase t1 inner join dbsinan.tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao  and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A30.9'  and  t1.co_uf_residencia_atual = ? and tp_modo_entrada=1 and dt_diagnostico_sintoma between ? and ? and tp_classific_operacao_atual=? and ( tp_duplicidade is null or tp_duplicidade=1  ) group by tp_alta";
        try {
            stm2 = con.prepareStatement(sql1);
            stm2.setString(1, uf);
            System.out.println(sql1);
            System.out.println(uf);
            System.out.println(parametros.get("parDataInicio1").toString());
            System.out.println(parametros.get("parDataFim1").toString());
            stm2.setString(2, parametros.get("parDataInicio1").toString());
            stm2.setString(3, parametros.get("parDataFim1").toString());
            stm2.setString(4, "1");
            rs2 = stm2.executeQuery();
        }
        catch (Exception exception) {
            sql1 = "select distinct(tp_alta) as alta,count(*) as c  from tb_investiga_hanseniase t1 inner join tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao  and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A30.9'  and  t1.co_uf_residencia_atual = " + uf + " and tp_modo_entrada=1 and dt_diagnostico_sintoma between '" + parametros.get("parDataInicio1").toString() + "' and '" + parametros.get("parDataFim1").toString() + "' and tp_classific_operacao_atual=1 and ( tp_duplicidade is null or tp_duplicidade=1  ) group by tp_alta";
            stm2 = con.prepareStatement(sql1);
            rs2 = stm2.executeQuery();
        }
        this.preencheValores(rs2);
        try {
            stm2.setString(4, "2");
            stm2.setString(2, parametros.get("parDataInicio2").toString());
            stm2.setString(3, parametros.get("parDataFim2").toString());
            rs2 = stm2.executeQuery();
        }
        catch (Exception exception) {
            sql1 = "select distinct(tp_alta) as alta,count(*) as c  from tb_investiga_hanseniase t1 inner join tb_notificacao t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao  and t1.co_municipio_notificacao=t2.co_municipio_notificacao)   where t2.co_cid='A30.9'  and  t1.co_uf_residencia_atual = " + uf + " and tp_modo_entrada=1 and dt_diagnostico_sintoma between '" + parametros.get("parDataInicio2").toString() + "' and '" + parametros.get("parDataFim2").toString() + "' and tp_classific_operacao_atual=2 and ( tp_duplicidade is null or tp_duplicidade=1  ) group by tp_alta";
            stm2 = con.prepareStatement(sql1);
            rs2 = stm2.executeQuery();
        }
        this.preencheValores(rs2);
        beans.add(this.insereNoBean(uf, noUF));
        System.out.println("terminou");
        return beans;
    }

    public void reset() {
        this.setCura("0");
        this.setAbandono("0");
        this.setTransfMesmoMunicipio("0");
        this.setTransfOutroMunicipio("0");
        this.setTransfOutroPais("0");
        this.setTransfOutroUf("0");
        this.setErroDiagnostico("0");
        this.setObito("0");
        this.setNaoPreenchido("0");
        this.setSubTotal("0");
        this.setTransfNaoEspecificada("0");
    }

    @Override
    public HashMap<String, ColunasDbf> getColunas() {
        HashMap<String, ColunasDbf> hashColunas = new HashMap<String, ColunasDbf>();
        hashColunas.put("ID_LOCRES", new ColunasDbf(7));
        hashColunas.put("DS_LOCRES", new ColunasDbf(30));
        hashColunas.put("ID_UFRES", new ColunasDbf(2));
        hashColunas.put("N_CURHANS", new ColunasDbf(10, 0));
        hashColunas.put("I_CURHANS", new ColunasDbf(4, 2));
        hashColunas.put("D_SUBHANS", new ColunasDbf(4, 0));
        hashColunas.put("TOTAL_NOT", new ColunasDbf(4, 0));
        hashColunas.put("ORIGEM", new ColunasDbf(30));
        hashColunas.put("ANO_DIGPB", new ColunasDbf(4, 0));
        hashColunas.put("DT_DPBINI", new ColunasDbf(10));
        hashColunas.put("DT_DPBFIN", new ColunasDbf(10));
        hashColunas.put("ANO_DIGMB", new ColunasDbf(4, 0));
        hashColunas.put("DT_DMBINI", new ColunasDbf(10));
        hashColunas.put("DT_DMBFIN", new ColunasDbf(10));
        this.setColunas(hashColunas);
        return hashColunas;
    }

    @Override
    public String[] getOrdemColunas() {
        return new String[]{"ID_LOCRES", "DS_LOCRES", "ID_UFRES", "N_CURHANS", "I_CURHANS", "D_SUBHANS", "TOTAL_NOT", "ANO_DIGPB", "DT_DPBINI", "DT_DPBFIN", "ANO_DIGMB", "DT_DMBINI", "DT_DMBFIN", "ORIGEM"};
    }

    @Override
    public Map getParametros() {
        Util util = new Util();
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("parRodape", this.getRodape());
        parametros.put("parConfig", "");
        parametros.put("parTitulo1", this.getTitulo1());
        return parametros;
    }

    @Override
    public DBFWriter getLinhas(HashMap<String, ColunasDbf> colunas, List bean, DBFWriter writer) throws DBFException, IOException {
        for (int i = 0; i < bean.size(); ++i) {
            Object[] rowData = new Object[colunas.size()];
            HanseniaseCoorteCura agravo = (HanseniaseCoorteCura)bean.get(i);
            if (agravo.getNomeMunicipio().equals("BRASIL")) {
                rowData[0] = null;
                rowData[2] = null;
            } else {
                rowData[0] = agravo.getCodMunicipio();
                rowData[2] = agravo.getCodMunicipio().substring(0, 2);
            }
            rowData[1] = agravo.getNomeMunicipio();
            rowData[3] = Double.parseDouble(agravo.getCura());
            rowData[4] = Double.parseDouble(agravo.getPerCura().replace(",", "."));
            rowData[5] = Double.parseDouble(agravo.getSubTotal());
            rowData[6] = Double.parseDouble(agravo.getTotal());
            rowData[7] = this.preencheAno(dtPbInicial, dtPbFinal);
            rowData[8] = dtPbInicial;
            rowData[9] = dtPbFinal;
            rowData[10] = this.preencheAno(dtMbInicial, dtMbFinal);
            rowData[11] = dtMbInicial;
            rowData[12] = dtMbFinal;
            rowData[13] = "HANSENIASE-SINANNET";
            writer.addRecord(rowData);
        }
        return writer;
    }

    @Override
    public String getCaminhoJasper() {
        return "/com/org/relatorios/hanseniaseCura.jasper";
    }

    public String getCura() {
        return this.cura;
    }

    public void setCura(String cura) {
        this.cura = cura;
    }

    public String getAbandono() {
        return this.abandono;
    }

    public void setAbandono(String abandono) {
        this.abandono = abandono;
    }

    public String getTransfMesmoMunicipio() {
        return this.transfMesmoMunicipio;
    }

    public void setTransfMesmoMunicipio(String transfMesmoMunicipio) {
        this.transfMesmoMunicipio = transfMesmoMunicipio;
    }

    public String getTransfOutroMunicipio() {
        return this.transfOutroMunicipio;
    }

    public void setTransfOutroMunicipio(String transfOutroMunicipio) {
        this.transfOutroMunicipio = transfOutroMunicipio;
    }

    public String getTransfOutroUf() {
        return this.transfOutroUf;
    }

    public void setTransfOutroUf(String transfOutroUf) {
        this.transfOutroUf = transfOutroUf;
    }

    public String getNaoPreenchido() {
        return this.naoPreenchido;
    }

    public void setNaoPreenchido(String naoPreenchido) {
        this.naoPreenchido = naoPreenchido;
    }

    public String getErroDiagnostico() {
        return this.erroDiagnostico;
    }

    public void setErroDiagnostico(String erroDiagnostico) {
        this.erroDiagnostico = erroDiagnostico;
    }

    public String getPerNaoPreenchido() {
        return this.perNaoPreenchido;
    }

    public void setPerNaoPreenchido(String perNaoPreenchido) {
        this.perNaoPreenchido = perNaoPreenchido;
    }

    public String getSubTotal() {
        return this.subTotal;
    }

    public void setSubTotal(String subTotal) {
        this.subTotal = subTotal;
    }

    public String getTotal() {
        return this.total;
    }

    public void setTotal(String total) {
        this.total = total;
    }

    public String getPerAbandono() {
        return this.perAbandono;
    }

    public void setPerAbandono(String perAbandono) {
        this.perAbandono = perAbandono;
    }

    public String getPerCura() {
        return this.perCura;
    }

    public void setPerCura(String perCura) {
        this.perCura = perCura;
    }

    public String getTransfOutroPais() {
        return this.transfOutroPais;
    }

    public void setTransfOutroPais(String transfOutroPais) {
        this.transfOutroPais = transfOutroPais;
    }

    public String getObito() {
        return this.obito;
    }

    public void setObito(String obito) {
        this.obito = obito;
    }

    @Override
    public String getTransfNaoEspecificada() {
        return this.transfNaoEspecificada;
    }

    @Override
    public void setTransfNaoEspecificada(String transfNaoEspecificada) {
        this.transfNaoEspecificada = transfNaoEspecificada;
    }

    public String getDtPbInicial() {
        return dtPbInicial;
    }

    public void setDtPbInicial(String dtPbInicial) {
        HanseniaseCoorteCura.dtPbInicial = dtPbInicial;
    }

    public String getDtPbFinal() {
        return dtPbFinal;
    }

    public void setDtPbFinal(String dtPbFinal) {
        HanseniaseCoorteCura.dtPbFinal = dtPbFinal;
    }

    public String getDtMbInicial() {
        return dtMbInicial;
    }

    public void setDtMbInicial(String dtMbInicial) {
        HanseniaseCoorteCura.dtMbInicial = dtMbInicial;
    }

    public String getDtMbFinal() {
        return dtMbFinal;
    }

    public void setDtMbFinal(String dtMbFinal) {
        HanseniaseCoorteCura.dtMbFinal = dtMbFinal;
    }
}

