/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes.agravos;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import com.org.bd.DBFUtil;
import com.org.model.classes.Agravo;
import com.org.model.classes.ColunasDbf;
import com.org.model.classes.agravos.ViolenciaAgravo;
import com.org.negocio.Configuracao;
import com.org.negocio.Util;
import com.org.util.SinanDateUtil;
import com.org.view.Master;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;

public class HanseniaseCoorteCuraPactuacao
extends Agravo {
    static String ANO;
    private String cura;
    private String subTotal;
    private String total;
    private String perCura;
    static String dtPbInicial;
    static String dtPbFinal;
    static String dtMbInicial;
    static String dtMbFinal;
    private boolean porRegiao;
    private boolean porRegional;
    private int qtdZeros;

    public HanseniaseCoorteCuraPactuacao(boolean isDbf) {
        this.setDBF(isDbf);
        this.setPeriodo("de Diagn\u00f3stico");
        this.setTipoAgregacao("de Resid\u00eancia");
        this.init("postgres");
    }

    @Override
    public void init(String tipoBanco) {
        this.setMultiplicador(100);
        this.setTipo("hans");
        this.setTitulo1("Propor\u00e7\u00e3o de cura dos casos novos de hansen\u00edase diagnosticados nos anos das coortes");
        this.setRodape("OBS. sobre m\u00e9todo de c\u00e1lculo: \nSele\u00e7\u00e3o das coortes: Casos novos (modo de entrada = 1-Caso novo) paucibacilares (classifica\u00e7\u00e3o operacional atual) diagnosticados no ano anterior ao ano de avalia\u00e7\u00e3o e casos novos multibacilares diagnosticados 2 anos anteriores ao ano de avalia\u00e7\u00e3o. No relat\u00f3rio s\u00e3o somados os PB e os MB selecionados na base de dados do Sinan, segundo local de resid\u00eancia atual.\nC\u00e1lculo do percentual de cura: n\u00e3o s\u00e3o considerados no c\u00e1lculo desses indicadores na avalia\u00e7\u00e3o municipal:\ntranfer\u00eancia para outro munic\u00edpio, transfer\u00eancia para outro estado,tranfer\u00eancia para outro pa\u00eds e erro de diagn\u00f3stico e transfer\u00eancia n\u00e3o especificada.\nN\u00e3o s\u00e3o consierados no c\u00e1lculo desse indicador na avalia\u00e7\u00e3o estadual: transfer\u00eancia para outro estado,tranfer\u00eancia para outro pa\u00eds e erro de diagn\u00f3stico e transfer\u00eancia n\u00e3o especificada.");
        this.setCura("0");
        this.setSubTotal("0");
        this.setTotal("0");
        this.setTransfNaoEspecificada("0");
        this.setSqlNumeradorCompletitude("");
    }

    private void setStatusBarra(int indexDoRegistroEmLeitura, double TotalRegistros) {
        float percentual = Float.parseFloat(String.valueOf(indexDoRegistroEmLeitura)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
        this.getBarraStatus().setValue((int)percentual);
    }

    /*
     * WARNING - void declaration
     */
    private void calculaRegiao(DBFReader reader, Map parametros) {
        try {
            void var27_30;
            void var27_25;
            String idMunicipio;
            HashMap<Object, Object> municipiosBeans = new HashMap();
            DBFUtil utilDbf = new DBFUtil();
            String ufResidencia = (String)parametros.get("parUf");
            String sgUfResidencia = (String)parametros.get("parSgUf");
            String codRegional = (String)parametros.get("parCodRegional");
            String codRegiao = (String)parametros.get("parCodRegiaoSaude");
            DecimalFormat df = new DecimalFormat("0.00");
            Agravo regiaoNotificacao = null;
            String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
            String dataInicioPB = (String)parametros.get("parDataInicioCoortePB");
            String dataFimPB = (String)parametros.get("parDataFimCoortePB");
            String dataInicioMB = (String)parametros.get("parDataInicioCoorteMB");
            String dataFimMB = (String)parametros.get("parDataFimCoorteMB");
            HashMap<Object, Object> regBeans = new HashMap();
            Agravo ag = null;
            parametros.put("numeradorTotal", 0);
            parametros.put("denominadorTotal", 0);
            ArrayList<String> conteudo = new ArrayList<String>();
            if (parametros.get("parMunicipio") != null) {
                idMunicipio = (String)parametros.get("parMunicipio");
                if (idMunicipio.equals("")) {
                    idMunicipio = "TODOS";
                }
            } else {
                idMunicipio = "TODOS";
            }
            if (codRegional == null) {
                codRegional = "";
            }
            if (codRegiao == null) {
                codRegiao = "";
            }
            if (((Boolean)parametros.get("parIsRegiao")).booleanValue()) {
                municipiosBeans = this.populaRegiaoBeans(sgUfResidencia, codRegiao);
                regBeans = this.populaMunicipiosBeansMAL(sgUfResidencia, codRegiao, idMunicipio, parametros.get("parIsRegiao").toString());
            } else {
                municipiosBeans = this.populaRegionalBeans(sgUfResidencia, codRegional);
                regBeans = this.populaMunicipiosBeansMAL(sgUfResidencia, codRegional, idMunicipio, parametros.get("parIsRegiao").toString());
            }
            String[] stringArray = arquivos;
            int n = stringArray.length;
            boolean bl = false;
            while (var27_25 < n) {
                String arquivo = stringArray[var27_25];
                int indexDoRegistroEmLeitura = 1;
                try {
                    Object[] rowObjects;
                    reader = Util.retornaObjetoDbfCaminhoArquivo(arquivo.substring(0, arquivo.length() - 4), Configuracao.getPropriedade("caminho"));
                    utilDbf.mapearPosicoes(reader);
                    double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                    while ((rowObjects = reader.nextRecord()) != null) {
                        if (utilDbf.getString(rowObjects, "UFRESAT") != null && (ag = (Agravo)regBeans.get(utilDbf.getString(rowObjects, "MUNIRESAT"))) != null) {
                            regiaoNotificacao = (Boolean)parametros.get("parIsRegiao") != false ? (Agravo)municipiosBeans.get(ag.getCodRegiaoSaude()) : (Agravo)municipiosBeans.get(ag.getCodRegional());
                            if (regiaoNotificacao != null) {
                                regiaoNotificacao.setTaxa("0");
                            }
                            String modoEntrada = utilDbf.getString(rowObjects, "MODOENTR", 1);
                            String classificacaoOperacionalAtual = utilDbf.getString(rowObjects, "CLASSATUAL", 1);
                            Date dtDiagnostico = utilDbf.getDate(rowObjects, "DT_DIAG");
                            String esquemaDeTratamentoAtual = utilDbf.getString(rowObjects, "ESQ_ATU_N");
                            String string = esquemaDeTratamentoAtual = esquemaDeTratamentoAtual != null ? esquemaDeTratamentoAtual : "0";
                            if (regiaoNotificacao != null && modoEntrada.equals("1")) {
                                if (this.isBetweenDates(dtDiagnostico, dataInicioPB, dataFimPB) && classificacaoOperacionalAtual.equals("1") && esquemaDeTratamentoAtual.equals("1")) {
                                    this.validaCriterios(rowObjects, utilDbf, classificacaoOperacionalAtual, esquemaDeTratamentoAtual, regiaoNotificacao);
                                } else if (this.isBetweenDates(dtDiagnostico, dataInicioMB, dataFimMB) && classificacaoOperacionalAtual.equals("2") && esquemaDeTratamentoAtual.equals("2")) {
                                    this.validaCriterios(rowObjects, utilDbf, classificacaoOperacionalAtual, esquemaDeTratamentoAtual, regiaoNotificacao);
                                    conteudo.add(ag.getNomeMunicipio() + ";" + classificacaoOperacionalAtual + ";" + esquemaDeTratamentoAtual);
                                }
                            }
                        }
                        this.setStatusBarra(indexDoRegistroEmLeitura, TotalRegistros);
                        ++indexDoRegistroEmLeitura;
                    }
                }
                catch (DBFException ex) {
                    Master.mensagem("Erro:\n" + (Object)((Object)ex));
                }
                ++var27_25;
            }
            this.setTaxaEstadual("");
            this.setBeans(new ArrayList());
            Collection<Object> municipioBean = municipiosBeans.values();
            for (Agravo agravo : municipioBean) {
                if (!agravo.getNumerador().equals("0") && !agravo.getDenominador().equals("0")) {
                    agravo.setTaxa(df.format(Double.parseDouble(agravo.getNumerador()) / Double.parseDouble(agravo.getDenominador()) * 100.0));
                } else if (null == agravo.getTaxa()) {
                    agravo.setTaxa("0");
                }
                this.getBeans().add(agravo);
                this.getBarraStatus().setString("Calculando indicador para: " + agravo.getNomeMunicipio());
            }
            this.getBarraStatus().setString(null);
            ComparatorChain chain = new ComparatorChain(Arrays.asList(new BeanComparator("uf"), new BeanComparator("nomeMunicipio")));
            Collections.sort(this.getBeans(), chain);
            Agravo agravo = new Agravo();
            if (((Boolean)parametros.get("parIsRegiao")).booleanValue()) {
                Agravo agravo2 = this.adicionaTotal(municipioBean, codRegiao);
                this.adicionaParamentrosTotais(parametros, agravo2);
            } else {
                Agravo agravo3 = this.adicionaTotal(municipioBean, codRegional);
                this.adicionaParamentrosTotais(parametros, agravo3);
            }
            var27_30.setCodMunicipio("####");
            var27_30.setTaxa(String.valueOf(Double.parseDouble(var27_30.getNumerador()) / Double.parseDouble(var27_30.getDenominador()) * 100.0));
            this.getBeans().add(var27_30);
            this.setParametroRegiaoOuRegional(parametros);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
    }

    private void setParametroRegiaoOuRegional(Map parametros) {
        if (((Boolean)parametros.get("parIsRegiao")).booleanValue()) {
            parametros.put("parDescricaoRegional", "Regi\u00e3o de resid\u00eancia atual:");
        } else {
            parametros.put("parDescricaoRegional", "Regional de resid\u00eancia atual:");
        }
    }

    private void validaCriterios(Object[] rowObjects, DBFUtil utilDbf, String classificacaoOperacionalAtual, String esquemaDeTratamentoAtual, Agravo municipioResidencia) {
        if ((classificacaoOperacionalAtual.equals("1") || classificacaoOperacionalAtual.equals("2")) && (esquemaDeTratamentoAtual.equals("1") || esquemaDeTratamentoAtual.equals("2"))) {
            String tipoAlta = utilDbf.getString(rowObjects, "TPALTA_N", 1);
            tipoAlta = tipoAlta != null ? tipoAlta : "";
            municipioResidencia = this.classificaAlta(tipoAlta, municipioResidencia);
        }
    }

    private Agravo classificaAlta(String tipoAlta, Agravo beanMunicipioResidencia) {
        DecimalFormat df = new DecimalFormat("0.00");
        if (tipoAlta.equals("1") || tipoAlta.equals("2") || tipoAlta.equals("3") || tipoAlta.equals("6") || tipoAlta.equals("7") || tipoAlta.equals("")) {
            beanMunicipioResidencia.setDenominador(String.valueOf(1 + Integer.parseInt(beanMunicipioResidencia.getDenominador())));
        }
        if (tipoAlta.equals("1")) {
            beanMunicipioResidencia.setNumerador(String.valueOf(1 + Integer.parseInt(beanMunicipioResidencia.getNumerador())));
        }
        this.calcularTaxaIndividual(df, beanMunicipioResidencia);
        return beanMunicipioResidencia;
    }

    private Agravo getMunicipioPelaRegiaoOuRegional(Map parametros, Map<String, Agravo> municipiosBeans, DBFUtil utilDbf, Object[] rowObjects) {
        Agravo regiaoResidencia = new Agravo();
        try {
            regiaoResidencia = ((Boolean)parametros.get("parIsRegiao")).booleanValue() ? municipiosBeans.get(this.buscaIdRegiaoSaude(utilDbf.getString(rowObjects, "MUNIRESAT"))) : municipiosBeans.get(this.buscaIdRegionalSaude(utilDbf.getString(rowObjects, "MUNIRESAT")));
        }
        catch (SQLException ex) {
            Logger.getLogger(ViolenciaAgravo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return regiaoResidencia;
    }

    /*
     * WARNING - void declaration
     */
    private void calculaMunicipios(DBFReader reader, Map parametros) {
        try {
            void var27_28;
            void var27_23;
            HashMap<Object, Object> municipiosBeans = new HashMap();
            DBFUtil utilDbf = new DBFUtil();
            String ufResidencia = (String)parametros.get("parUf");
            String sgUfResidencia = (String)parametros.get("parSgUf");
            String codRegional = (String)parametros.get("parCodRegional");
            String codRegiao = (String)parametros.get("parCodRegiaoSaude");
            String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
            String dataInicioPB = (String)parametros.get("parDataInicioCoortePB");
            String dataFimPB = (String)parametros.get("parDataFimCoortePB");
            String dataInicioMB = (String)parametros.get("parDataInicioCoorteMB");
            String dataFimMB = (String)parametros.get("parDataFimCoorteMB");
            Boolean somenteMunicipios = parametros.get("parDesagregacao").equals("Somente munic\u00edpios");
            String idMunicipio = "";
            DecimalFormat df = new DecimalFormat("0");
            DecimalFormat df2 = new DecimalFormat("0.00");
            if (codRegional == null) {
                codRegional = "";
            }
            if (codRegiao == null) {
                codRegiao = "";
            }
            idMunicipio = parametros.get("parMunicipio") != null ? (String)parametros.get("parMunicipio") : "TODOS";
            municipiosBeans = somenteMunicipios != false ? this.populaMunicipiosBeansMAL(sgUfResidencia, "", idMunicipio, "false") : ((Boolean)parametros.get("parIsRegiao") != false ? this.populaMunicipiosBeansMAL(sgUfResidencia, codRegiao, idMunicipio, parametros.get("parIsRegiao").toString()) : this.populaMunicipiosBeansMAL(sgUfResidencia, codRegional, idMunicipio, parametros.get("parIsRegiao").toString()));
            String[] stringArray = arquivos;
            int n = stringArray.length;
            boolean bl = false;
            while (var27_23 < n) {
                String arquivo = stringArray[var27_23];
                int indexDoRegistroEmLeitura = 1;
                try {
                    Object[] rowObjects;
                    reader = Util.retornaObjetoDbfCaminhoArquivo(arquivo.substring(0, arquivo.length() - 4), Configuracao.getPropriedade("caminho"));
                    utilDbf.mapearPosicoes(reader);
                    double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                    while ((rowObjects = reader.nextRecord()) != null) {
                        if (utilDbf.getString(rowObjects, "UFRESAT") != null) {
                            Agravo municipioResidencia = (Agravo)municipiosBeans.get(utilDbf.getString(rowObjects, "MUNIRESAT"));
                            if (municipioResidencia != null) {
                                municipioResidencia.setTaxa("0");
                                if (somenteMunicipios.booleanValue()) {
                                    municipioResidencia.setCodRegional("");
                                    municipioResidencia.setCodRegiaoSaude("");
                                }
                            }
                            String modoEntrada = utilDbf.getString(rowObjects, "MODOENTR", 1);
                            String classificacaoOperacionalAtual = utilDbf.getString(rowObjects, "CLASSATUAL", 1);
                            Date dtDiagnostico = utilDbf.getDate(rowObjects, "DT_DIAG");
                            String esquemaDeTratamentoAtual = utilDbf.getString(rowObjects, "ESQ_ATU_N");
                            String string = esquemaDeTratamentoAtual = esquemaDeTratamentoAtual != null ? esquemaDeTratamentoAtual : "0";
                            if (municipioResidencia != null && modoEntrada.equals("1")) {
                                if (this.isBetweenDates(dtDiagnostico, dataInicioPB, dataFimPB) && classificacaoOperacionalAtual.equals("1") && esquemaDeTratamentoAtual.equals("1")) {
                                    this.validaCriterios(rowObjects, utilDbf, classificacaoOperacionalAtual, esquemaDeTratamentoAtual, municipioResidencia);
                                } else if (this.isBetweenDates(dtDiagnostico, dataInicioMB, dataFimMB) && classificacaoOperacionalAtual.equals("2") && esquemaDeTratamentoAtual.equals("2")) {
                                    this.validaCriterios(rowObjects, utilDbf, classificacaoOperacionalAtual, esquemaDeTratamentoAtual, municipioResidencia);
                                }
                            }
                        }
                        this.setStatusBarra(indexDoRegistroEmLeitura, TotalRegistros);
                        ++indexDoRegistroEmLeitura;
                    }
                }
                catch (DBFException ex) {
                    Master.mensagem("Erro:\n" + (Object)((Object)ex));
                }
                ++var27_23;
            }
            this.setBeans(new ArrayList());
            Collection<Object> municipioBean = municipiosBeans.values();
            for (Agravo agravo : municipioBean) {
                if (!agravo.getNumerador().equals("0") && !agravo.getDenominador().equals("0")) {
                    agravo.setTaxa(df2.format(Double.parseDouble(agravo.getNumerador()) / Double.parseDouble(agravo.getDenominador()) * 100.0));
                } else if (null == agravo.getTaxa()) {
                    agravo.setTaxa("0");
                }
                this.getBeans().add(agravo);
                this.getBarraStatus().setString("Calculando indicador para: " + agravo.getNomeMunicipio());
            }
            this.getBarraStatus().setString(null);
            ComparatorChain chain = somenteMunicipios != false ? new ComparatorChain(Arrays.asList(new BeanComparator("uf"), new BeanComparator("nomeMunicipio"))) : ((Boolean)parametros.get("parIsRegiao") != false ? new ComparatorChain(Arrays.asList(new BeanComparator("uf"), new BeanComparator("regiaoSaude"), new BeanComparator("nomeMunicipio"))) : new ComparatorChain(Arrays.asList(new BeanComparator("uf"), new BeanComparator("regional"), new BeanComparator("nomeMunicipio"))));
            Collections.sort(this.getBeans(), chain);
            Agravo agravo = new Agravo();
            if (((Boolean)parametros.get("parIsRegiao")).booleanValue()) {
                Agravo agravo2 = this.adicionaTotal(municipioBean, codRegiao);
                this.adicionaParamentrosTotais(parametros, agravo2);
            } else {
                Agravo agravo3 = this.adicionaTotal(municipioBean, codRegional);
                this.adicionaParamentrosTotais(parametros, agravo3);
            }
            var27_28.setCodMunicipio("####");
            var27_28.setTaxa(String.valueOf(Double.parseDouble(var27_28.getNumerador()) / Double.parseDouble(var27_28.getDenominador()) * 100.0));
            this.getBeans().add(var27_28);
            this.setParametroRegiaoOuRegional(parametros);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
    }

    private void adicionaParamentrosTotais(Map parametros, Agravo totalAgravo) {
        DecimalFormat df = new DecimalFormat("0.00");
        parametros.put("numeradorTotal", totalAgravo.getNumerador());
        parametros.put("denominadorTotal", totalAgravo.getDenominador());
        Double numerador = Double.parseDouble(totalAgravo.getNumerador());
        Double denominador = Double.parseDouble(totalAgravo.getDenominador());
        double taxa = numerador == 0.0 && denominador == 0.0 ? 0.0 : Double.parseDouble(totalAgravo.getNumerador()) / Double.parseDouble(totalAgravo.getDenominador()) * 100.0;
        parametros.put("taxaTotal", df.format(taxa));
    }

    private Agravo calcularTaxaTotal(DecimalFormat df) {
        Agravo agravo = (Agravo)this.getBeans().get(this.getBeans().size() - 1);
        if (null != agravo.getNumerador() && Double.parseDouble(agravo.getNumerador()) != 0.0 && null != agravo.getDenominador() && Double.parseDouble(agravo.getDenominador()) != 0.0) {
            agravo.setTaxa(df.format(Double.parseDouble(agravo.getNumerador()) / Double.parseDouble(agravo.getDenominador()) * 100.0));
        } else {
            agravo.setTaxa("0");
        }
        return agravo;
    }

    private void calcularTaxaIndividual(DecimalFormat df, Agravo municipioResidencia) {
        if (null != municipioResidencia.getNumerador() && Double.parseDouble(municipioResidencia.getNumerador()) != 0.0 && null != municipioResidencia.getDenominador() && Double.parseDouble(municipioResidencia.getDenominador()) != 0.0) {
            municipioResidencia.setTaxa(df.format(Double.parseDouble(municipioResidencia.getNumerador()) / Double.parseDouble(municipioResidencia.getDenominador()) * 100.0));
        } else {
            municipioResidencia.setTaxa("0");
        }
    }

    @Override
    public void calcula(DBFReader reader, Map parametros) {
        String municipios = (String)parametros.get("municipios");
        String municipioEspecifico = (String)parametros.get("municipioEspecifico");
        String filtroUF = (String)parametros.get("parUf");
        boolean isRegiaoSelecionada = (Boolean)parametros.get("parIsRegiao");
        boolean isRegionalSelecionada = (Boolean)parametros.get("parIsRegional");
        boolean estadoEMunicipio = municipios.equals("sim") && !filtroUF.equals("brasil");
        HanseniaseCoorteCuraPactuacao.setDtPbInicial((String)parametros.get("parDataInicioCoortePB"));
        HanseniaseCoorteCuraPactuacao.setDtPbFinal((String)parametros.get("parDataFimCoortePB"));
        HanseniaseCoorteCuraPactuacao.setDtMbInicial((String)parametros.get("parDataInicioCoorteMB"));
        HanseniaseCoorteCuraPactuacao.setDtMbFinal((String)parametros.get("parDataFimCoorteMB"));
        if (isRegiaoSelecionada) {
            this.setPorRegiao(true);
        }
        if (isRegionalSelecionada) {
            this.setPorRegional(true);
        }
        if ((isRegionalSelecionada || isRegiaoSelecionada) && municipioEspecifico == "NENHUM") {
            this.calculaRegiao(reader, parametros);
        } else if (municipios.equals("sim")) {
            this.calculaMunicipios(reader, parametros);
        } else {
            this.calculaMunicipioIndividual(municipios, filtroUF, reader, parametros);
        }
    }

    private void calculaMunicipioIndividual(String municipios, String filtroUF, DBFReader reader, Map parametros) {
        try {
            DBFUtil utilDbf = new DBFUtil();
            DecimalFormat df = new DecimalFormat("0.00");
            String ufResidencia = (String)parametros.get("parUf");
            String municipioResidencia = (String)parametros.get("parMunicipio");
            String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
            String dataInicioPB = (String)parametros.get("parDataInicioCoortePB");
            String dataFimPB = (String)parametros.get("parDataFimCoortePB");
            String dataInicioMB = (String)parametros.get("parDataInicioCoorteMB");
            String dataFimMB = (String)parametros.get("parDataFimCoorteMB");
            if (municipioResidencia == null) {
                municipioResidencia = "";
            }
            for (String arquivo : arquivos) {
                Object[] rowObjects;
                int indexDoRegistroEmLeitura = 1;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivo.substring(0, arquivo.length() - 4), Configuracao.getPropriedade("caminho"));
                utilDbf.mapearPosicoes(reader);
                double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    if (utilDbf.getString(rowObjects, "UFRESAT") != null && utilDbf.getString(rowObjects, "UFRESAT").equals(ufResidencia)) {
                        String modoEntrada = utilDbf.getString(rowObjects, "MODOENTR", 1);
                        String classificacaoOperacionalAtual = utilDbf.getString(rowObjects, "CLASSATUAL", 1);
                        Date dtDiagnostico = utilDbf.getDate(rowObjects, "DT_DIAG");
                        String esquemaDeTratamentoAtual = utilDbf.getString(rowObjects, "ESQ_ATU_N");
                        String string = esquemaDeTratamentoAtual = esquemaDeTratamentoAtual != null ? esquemaDeTratamentoAtual : "0";
                        if (this.verificaMunicipio(municipioResidencia, utilDbf.getString(rowObjects, "MUNIRESAT")) && modoEntrada.equals("1")) {
                            if (this.isBetweenDates(dtDiagnostico, dataInicioPB, dataFimPB) && classificacaoOperacionalAtual.equals("1") && esquemaDeTratamentoAtual.equals("1")) {
                                this.validaCriteriosSemReferenciaDeMunicipio(rowObjects, utilDbf, classificacaoOperacionalAtual, esquemaDeTratamentoAtual, this);
                            } else if (this.isBetweenDates(dtDiagnostico, dataInicioMB, dataFimMB) && classificacaoOperacionalAtual.equals("2") && esquemaDeTratamentoAtual.equals("2")) {
                                this.validaCriteriosSemReferenciaDeMunicipio(rowObjects, utilDbf, classificacaoOperacionalAtual, esquemaDeTratamentoAtual, this);
                            }
                        }
                    }
                    this.setStatusBarra(indexDoRegistroEmLeitura, TotalRegistros);
                    ++indexDoRegistroEmLeitura;
                }
            }
            Agravo hanseniaseMunicipio = new Agravo();
            hanseniaseMunicipio.setCodMunicipio((String)parametros.get("parMunicipio"));
            hanseniaseMunicipio.setUf((String)parametros.get("parSgUf"));
            hanseniaseMunicipio.setNomeMunicipio((String)parametros.get("parNomeMunicipio"));
            hanseniaseMunicipio.setCodMunicipio(municipioResidencia);
            if (!String.valueOf(this.getTotal()).equals("0.0")) {
                String total = "";
                this.preencheResultadoDaBusca(hanseniaseMunicipio, Integer.parseInt(this.getCura()), Integer.parseInt(this.getSubTotal()), total, df);
            } else {
                hanseniaseMunicipio.setNumerador("0");
                hanseniaseMunicipio.setDenominador("0");
                hanseniaseMunicipio.setTaxa("0.00");
            }
            this.setBeans(new ArrayList());
            this.getBeans().add(hanseniaseMunicipio);
            this.setParametroRegiaoOuRegional(parametros);
        }
        catch (DBFException | NumberFormatException | ParseException ex) {
            ex.printStackTrace();
        }
    }

    private void validaCriteriosSemReferenciaDeMunicipio(Object[] rowObjects, DBFUtil utilDbf, String classificacaoOperacionalAtual, String esquemaDeTratamentoAtual, HanseniaseCoorteCuraPactuacao municipioResidencia) {
        if ((classificacaoOperacionalAtual.equals("1") || classificacaoOperacionalAtual.equals("2")) && (esquemaDeTratamentoAtual.equals("1") || esquemaDeTratamentoAtual.equals("2"))) {
            String tipoAlta = utilDbf.getString(rowObjects, "TPALTA_N", 1);
            tipoAlta = tipoAlta != null ? tipoAlta : "";
            this.classificaAlta(tipoAlta);
        }
    }

    private void classificaAlta(String tipoAlta) {
        if (tipoAlta.equals("1") || tipoAlta.equals("2") || tipoAlta.equals("6") || tipoAlta.equals("7") || tipoAlta.equals("")) {
            this.setSubTotal(String.valueOf(1 + Integer.parseInt(this.getSubTotal())));
        }
        if (tipoAlta.equals("1")) {
            this.setCura(String.valueOf(1 + Integer.parseInt(this.getCura())));
        }
        this.setSubTotal(String.valueOf(Integer.parseInt(this.getSubTotal())));
    }

    private void preencheResultadoDaBusca(Agravo hanseniaseMunicipio, int numerador, int denominador, String total, DecimalFormat df) {
        hanseniaseMunicipio.setNumerador(String.valueOf(NumberFormat.getNumberInstance().format(Double.parseDouble(String.valueOf(numerador)))));
        hanseniaseMunicipio.setDenominador(String.valueOf(NumberFormat.getNumberInstance().format(Double.parseDouble(String.valueOf(denominador)))));
        total = numerador != 0 && denominador != 0 ? df.format(Double.parseDouble(String.valueOf(numerador)) / Double.parseDouble(String.valueOf(denominador)) * 100.0) : "0.00";
        hanseniaseMunicipio.setTaxa(total);
    }

    @Override
    public Map getParametros() {
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("parDataInicio", Util.formataData(this.getDataInicio()));
        parametros.put("parDataFim", Util.formataData(this.getDataFim()));
        parametros.put("parDataInicioCoortePB", Util.formataData(SinanDateUtil.subtrairAno(this.getDataInicio(), -1)));
        parametros.put("parDataFimCoortePB", Util.formataData(SinanDateUtil.subtrairAno(this.getDataFim(), -1)));
        parametros.put("parPeriodoCoortePB", SinanDateUtil.subtrairAno(this.getDataInicio(), -1) + " a " + SinanDateUtil.subtrairAno(this.getDataFim(), -1) + " (PB)");
        parametros.put("parDataInicioCoorteMB", Util.formataData(SinanDateUtil.subtrairAno(this.getDataInicio(), -2)));
        parametros.put("parDataFimCoorteMB", Util.formataData(SinanDateUtil.subtrairAno(this.getDataFim(), -2)));
        parametros.put("parPeriodoCoorteMB", SinanDateUtil.subtrairAno(this.getDataInicio(), -2) + " a " + SinanDateUtil.subtrairAno(this.getDataFim(), -2) + " (MB)");
        parametros.put("parPeriodoAvaliacao", this.getDataInicio() + " a " + this.getDataFim());
        parametros.put("parPeriodo", "de " + this.getDataInicio() + " a " + this.getDataFim());
        parametros.put("parTituloColuna", this.getTituloColuna());
        parametros.put("parFator", String.valueOf(this.getMultiplicador()));
        parametros.put("parAno", Util.getAno(this.getDataFim()));
        parametros.put("parRodape", this.getRodape());
        parametros.put("parConfig", "");
        parametros.put("parTitulo1", "Propor\u00e7\u00e3o de notifica\u00e7\u00f5es de viol\u00eancia interpessoal e autoprovocada com o campo ra\u00e7a/cor preenchido com informa\u00e7\u00e3o v\u00e1lida.");
        ANO = "";
        if (Util.getAno(this.getDataFim()).equals(Util.getAno(this.getDataInicio()))) {
            ANO = Util.getAno(this.getDataFim());
        }
        this.setDataInicio(this.getDataInicio());
        this.setDataFim(this.getDataFim());
        return parametros;
    }

    @Override
    public String[] getOrdemColunas() {
        if (this.isPorRegiao()) {
            return new String[]{"IDLOCRESAT", "DSLOCRESAT", "COUUFRESAT", "NOME_CIR", "COD_CIR", "N_CURHANS", "D_SUBHANS", "I_CURHANS", "DT_DPBINI", "DT_DPBFIN", "DT_DMBINI", "DT_DMBFIN", "ORIGEM"};
        }
        if (this.isPorRegional()) {
            return new String[]{"IDLOCRESAT", "DSLOCRESAT", "COUUFRESAT", "REGIONAL", "ID_REGION", "N_CURHANS", "D_SUBHANS", "I_CURHANS", "DT_DPBINI", "DT_DPBFIN", "DT_DMBINI", "DT_DMBFIN", "ORIGEM"};
        }
        return new String[]{"IDLOCRESAT", "DSLOCRESAT", "COUUFRESAT", "N_CURHANS", "D_SUBHANS", "I_CURHANS", "DT_DPBINI", "DT_DPBFIN", "DT_DMBINI", "DT_DMBFIN", "ORIGEM"};
    }

    @Override
    public HashMap<String, ColunasDbf> getColunas() {
        HashMap<String, ColunasDbf> hashColunas = new HashMap<String, ColunasDbf>();
        hashColunas.put("IDLOCRESAT", new ColunasDbf(7));
        hashColunas.put("DSLOCRESAT", new ColunasDbf(30));
        hashColunas.put("COUUFRESAT", new ColunasDbf(2));
        if (this.isPorRegiao()) {
            hashColunas.put("NOME_CIR", new ColunasDbf(30));
            hashColunas.put("COD_CIR", new ColunasDbf(7));
        } else if (this.isPorRegional()) {
            hashColunas.put("REGIONAL", new ColunasDbf(30));
            hashColunas.put("ID_REGION", new ColunasDbf(7));
        }
        hashColunas.put("N_CURHANS", new ColunasDbf(10, 0));
        hashColunas.put("D_SUBHANS", new ColunasDbf(4, 0));
        hashColunas.put("I_CURHANS", new ColunasDbf(4, 2));
        hashColunas.put("ORIGEM", new ColunasDbf(30));
        hashColunas.put("DT_DPBINI", new ColunasDbf(10));
        hashColunas.put("DT_DPBFIN", new ColunasDbf(10));
        hashColunas.put("DT_DMBINI", new ColunasDbf(10));
        hashColunas.put("DT_DMBFIN", new ColunasDbf(10));
        this.setColunas(hashColunas);
        return hashColunas;
    }

    @Override
    public DBFWriter getLinhas(HashMap<String, ColunasDbf> colunas, List bean, DBFWriter writer) throws DBFException, IOException {
        for (int i = 0; i < bean.size(); ++i) {
            Object[] rowData = new Object[colunas.size()];
            Agravo agravo = (Agravo)bean.get(i);
            if (agravo.getCodMunicipio() == null || agravo.getCodMunicipio().equals("")) continue;
            rowData = this.adicionarInformacoesDbf(agravo, rowData);
            writer.addRecord(rowData);
        }
        return writer;
    }

    private Object[] adicionarInformacoesDbf(Agravo agravo, Object[] rowData) throws NumberFormatException {
        if (agravo.getNomeMunicipio().equals("BRASIL")) {
            rowData[0] = null;
            rowData[2] = null;
        } else if (agravo.getCodMunicipio() != null) {
            rowData[0] = agravo.getCodMunicipio();
            rowData[2] = agravo.getCodMunicipio().substring(0, 2);
        } else {
            rowData[0] = "";
            rowData[2] = "";
        }
        rowData[1] = agravo.getNomeMunicipio();
        if (this.isPorRegional() || this.isPorRegiao()) {
            if (this.isPorRegional()) {
                rowData[2] = agravo.getCodIbgeUF(agravo.getUf());
                rowData[3] = agravo.getRegional();
                rowData[4] = agravo.getCodRegional();
            } else {
                rowData[3] = agravo.getRegiaoSaude();
                rowData[4] = agravo.getCodRegiaoSaude();
            }
            rowData[5] = Double.parseDouble(agravo.getNumerador().replace(",", "."));
            rowData[6] = Double.parseDouble(agravo.getDenominador().replace(",", "."));
            rowData[7] = Double.parseDouble(agravo.getTaxa().replace(",", "."));
            rowData[8] = HanseniaseCoorteCuraPactuacao.getDtPbInicial();
            rowData[9] = HanseniaseCoorteCuraPactuacao.getDtPbFinal();
            rowData[10] = HanseniaseCoorteCuraPactuacao.getDtMbInicial();
            rowData[11] = HanseniaseCoorteCuraPactuacao.getDtMbFinal();
            rowData[12] = "HANSENIASE-SINANNET";
        } else {
            rowData[3] = Double.parseDouble(agravo.getNumerador().replace(",", "."));
            rowData[4] = Double.parseDouble(agravo.getDenominador().replace(",", "."));
            rowData[5] = Double.parseDouble(agravo.getTaxa().replace(",", "."));
            rowData[6] = HanseniaseCoorteCuraPactuacao.getDtPbInicial();
            rowData[7] = HanseniaseCoorteCuraPactuacao.getDtPbFinal();
            rowData[8] = HanseniaseCoorteCuraPactuacao.getDtMbInicial();
            rowData[9] = HanseniaseCoorteCuraPactuacao.getDtMbFinal();
            rowData[10] = "HANSENIASE-SINANNET";
        }
        return rowData;
    }

    @Override
    public String getCaminhoJasper() {
        return "/com/org/relatorios/hanseniaseCoorteCuraPactuacao.jasper";
    }

    public String getCura() {
        return this.cura;
    }

    public void setCura(String cura) {
        this.cura = cura;
    }

    public String getSubTotal() {
        return this.subTotal;
    }

    public void setSubTotal(String subTotal) {
        this.subTotal = subTotal;
    }

    public String getTotal() {
        return this.total;
    }

    public void setTotal(String total) {
        this.total = total;
    }

    public String getPerCura() {
        return this.perCura;
    }

    public void setPerCura(String perCura) {
        this.perCura = perCura;
    }

    public static String getDtPbInicial() {
        return dtPbInicial;
    }

    public static void setDtPbInicial(String dtPbInicial) {
        HanseniaseCoorteCuraPactuacao.dtPbInicial = dtPbInicial;
    }

    public static String getDtPbFinal() {
        return dtPbFinal;
    }

    public static void setDtPbFinal(String dtPbFinal) {
        HanseniaseCoorteCuraPactuacao.dtPbFinal = dtPbFinal;
    }

    public static String getDtMbInicial() {
        return dtMbInicial;
    }

    public static void setDtMbInicial(String dtMbInicial) {
        HanseniaseCoorteCuraPactuacao.dtMbInicial = dtMbInicial;
    }

    public static String getDtMbFinal() {
        return dtMbFinal;
    }

    public static void setDtMbFinal(String dtMbFinal) {
        HanseniaseCoorteCuraPactuacao.dtMbFinal = dtMbFinal;
    }

    public boolean isPorRegiao() {
        return this.porRegiao;
    }

    public void setPorRegiao(boolean porRegiao) {
        this.porRegiao = porRegiao;
    }

    public boolean isPorRegional() {
        return this.porRegional;
    }

    public void setPorRegional(boolean porRegional) {
        this.porRegional = porRegional;
    }
}

