/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes.agravos;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import com.org.bd.DBFUtil;
import com.org.model.classes.Agravo;
import com.org.model.classes.ColunasDbf;
import com.org.negocio.Util;
import com.org.view.Master;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;

public class HepatiteBC
extends Agravo {
    static String ANO;

    public HepatiteBC(boolean isDbf) {
        this.setDBF(isDbf);
        this.setPeriodo("de notifica\u00e7\u00e3o");
        this.setTipoAgregacao("de Resid\u00eancia");
        this.init("postgres");
    }

    @Override
    public void init(String tipoBanco) {
        this.setArquivo("HEPANET");
        this.setMultiplicador(100);
        this.setTitulo1("Propor\u00e7\u00e3o de casos de hepatites B e C confirmados por sorologia");
        this.setTextoCompletitude("% de n\u00e3o preenchimento do campo classifica\u00e7\u00e3o etiol\u00f3gica: ");
        this.setTituloColuna("Propor\u00e7\u00e3o ");
        this.setRodape("Numerador:  N\u00famero de casos de hepatite B, hepatite C e hepatite B e C, confirmados por sorologia reagente, residentes em determinado local e notificados em determinado per\u00edodo \nDenominador:  N\u00famero de casos de hepatite B, hepatite C e hepatite B e C, residentes em determinado local e notificados em determinado per\u00edodo");
        this.setTipo("");
        this.setSqlNumeradorCompletitude("tem completitude");
        if (!this.isDBF()) {
            this.setSqlNumeradorMunicipioEspecifico("select count(*) as numerador from dbsinan.tb_notificacao as t1, dbsinan.tb_investiga_hepatite as t2 where t1.co_cid = 'B19' and (t1.dt_notificacao BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and t1.co_municipio_residencia = ? and t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao and ((t1.tp_classificacao_final=1 and t2.tp_classificacao_etiologica = '02' and tp_soro_hbsag = 1) or (t1.tp_classificacao_final=1 and t2.tp_classificacao_etiologica = '03' and tp_soro_hcv = 1) or (t1.tp_classificacao_final=1 and t2.tp_classificacao_etiologica = '06' and tp_soro_hcv = 1 and tp_soro_hbsag = 1))");
            this.setSqlDenominadorMunicipioEspecifico("select count(*) as denominador from dbsinan.tb_notificacao as t1, dbsinan.tb_investiga_hepatite as t2 where t1.co_cid = 'B19' and (t1.dt_notificacao BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and t1.co_municipio_residencia = ? and t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao and t1.tp_classificacao_final=1 and t2.tp_classificacao_etiologica in ('02','03','06')");
            this.setSqlNumeradorEstado("select count(*) as numerador from dbsinan.tb_notificacao as t1, dbsinan.tb_investiga_hepatite as t2 where t1.co_cid = 'B19' and (t1.dt_notificacao BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao and ((t1.tp_classificacao_final=1 and t2.tp_classificacao_etiologica = '02' and tp_soro_hbsag = 1) or (t1.tp_classificacao_final=1 and t2.tp_classificacao_etiologica = '03' and tp_soro_hcv = 1) or (t1.tp_classificacao_final=1 and t2.tp_classificacao_etiologica = '06' and tp_soro_hcv = 1 and tp_soro_hbsag = 1))");
            this.setSqlDenominandorEstado("select count(*) as denominador from dbsinan.tb_notificacao as t1, dbsinan.tb_investiga_hepatite as t2 where t1.co_cid = 'B19' and (t1.dt_notificacao BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao and t1.tp_classificacao_final=1 and t2.tp_classificacao_etiologica in ('02','03','06')");
            this.setSqlNumeradorCompletitude("select count(*) as numerador from dbsinan.tb_notificacao as t1, dbsinan.tb_investiga_hepatite as t2 where t1.co_cid = 'B19' and (t1.dt_notificacao BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao and t1.tp_classificacao_final=1 and t2.tp_classificacao_etiologica is null");
            this.setSqlNumeradorBeanMunicipios(this.getSqlNumeradorMunicipioEspecifico());
            this.setSqlDenominadorBeanMunicipios(this.getSqlDenominadorMunicipioEspecifico());
        }
    }

    private void calculaBrasil(DBFReader reader, Map parametros) throws ParseException {
        String coluna;
        HashMap<Object, Object> municipiosBeans = new HashMap();
        DBFUtil utilDbf = new DBFUtil();
        if (parametros.get("municipios").toString().equals("sim")) {
            municipiosBeans = this.populaMunicipiosBeans("BR", "");
            coluna = "ID_MN_RESI";
        } else {
            municipiosBeans = this.populaUfsBeans();
            coluna = "SG_UF";
        }
        int completitude = 0;
        int denominadorCompletitude = 0;
        DecimalFormat df = new DecimalFormat("0.00");
        int denominador = 0;
        int numerador = 0;
        int numeradorEstadual = 0;
        int denominadorEstadual = 0;
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim = (String)parametros.get("parDataFim");
        int i = 1;
        try {
            Object[] rowObjects;
            utilDbf.mapearPosicoes(reader);
            double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
            while ((rowObjects = reader.nextRecord()) != null) {
                if (utilDbf.getString(rowObjects, coluna) != null) {
                    Agravo municipioResidencia = (Agravo)municipiosBeans.get(utilDbf.getString(rowObjects, coluna));
                    int soroHBSAG = utilDbf.getInt(rowObjects, "AGHBS");
                    int soroHCV = utilDbf.getInt(rowObjects, "ANTIHCV");
                    String classificacaoEtiologica = utilDbf.getString(rowObjects, "CLAS_ETIOL");
                    int classificacaoFinal = utilDbf.getInt(rowObjects, "CLASSI_FIN");
                    if (municipioResidencia != null) {
                        if (classificacaoEtiologica != null) {
                            if (classificacaoFinal == 1 && (classificacaoEtiologica.equals("02") || classificacaoEtiologica.equals("03") || classificacaoEtiologica.equals("06"))) {
                                try {
                                    if (this.isBetweenDates(utilDbf.getDate(rowObjects, "DT_NOTIFIC"), dataInicio, dataFim)) {
                                        denominador = Integer.parseInt(municipioResidencia.getDenominador());
                                        municipioResidencia.setDenominador(String.valueOf(++denominador));
                                        ++denominadorEstadual;
                                        if (classificacaoEtiologica.equals("02") && soroHBSAG == 1) {
                                            numerador = Integer.parseInt(municipioResidencia.getNumerador());
                                            municipioResidencia.setNumerador(String.valueOf(++numerador));
                                            ++numeradorEstadual;
                                        }
                                        if (classificacaoEtiologica.equals("03") && soroHCV == 1) {
                                            numerador = Integer.parseInt(municipioResidencia.getNumerador());
                                            municipioResidencia.setNumerador(String.valueOf(++numerador));
                                            ++numeradorEstadual;
                                        }
                                        if (classificacaoEtiologica.equals("06") && soroHBSAG == 1 && soroHCV == 1) {
                                            numerador = Integer.parseInt(municipioResidencia.getNumerador());
                                            municipioResidencia.setNumerador(String.valueOf(++numerador));
                                            ++numeradorEstadual;
                                        }
                                        ++denominadorCompletitude;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    Master.mensagem("Erro:\n" + numberFormatException);
                                }
                                catch (ParseException parseException) {
                                    Master.mensagem("Erro:\n" + parseException);
                                }
                            }
                        } else if (this.isBetweenDates(utilDbf.getDate(rowObjects, "DT_NOTIFIC"), dataInicio, dataFim)) {
                            ++completitude;
                        }
                    }
                }
                float f = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                this.getBarraStatus().setValue((int)f);
                ++i;
            }
        }
        catch (DBFException ex) {
            Master.mensagem("Erro:\n" + (Object)((Object)ex));
        }
        this.setTaxaEstadual("");
        this.setPercentualCompletitude(df.format(Double.parseDouble(String.valueOf(completitude)) / Double.parseDouble(String.valueOf(denominadorCompletitude)) * 100.0));
        this.setBeans(new ArrayList());
        Collection<Object> municipioBean = municipiosBeans.values();
        if (parametros.get("parSgUf").toString().equals("TODAS") || parametros.get("municipios").toString().equals("sim")) {
            for (Agravo agravo : municipioBean) {
                double num = Double.parseDouble(agravo.getNumerador());
                double den = Double.parseDouble(agravo.getDenominador());
                if (den == 0.0) {
                    agravo.setTaxa("0.00");
                } else {
                    agravo.setTaxa(df.format(num / den * 100.0));
                }
                this.getBeans().add(agravo);
            }
            Collections.sort(this.getBeans(), new BeanComparator("nomeMunicipio"));
        }
        this.getBeans().add(this.adicionaBrasil(municipioBean));
    }

    private void calculaMunicipios(DBFReader reader, Map parametros) throws ParseException {
        HashMap<Object, Object> municipiosBeans = new HashMap();
        String sgUfResidencia = (String)parametros.get("parSgUf");
        String codRegional = (String)parametros.get("parCodRegional");
        String codReg = "";
        DBFUtil utilDbf = new DBFUtil();
        municipiosBeans = this.populaMunicipiosBeans(sgUfResidencia, codRegional);
        int completitude = 0;
        int denominadorCompletitude = 0;
        DecimalFormat df = new DecimalFormat("0.00");
        int denominador = 0;
        int numerador = 0;
        int numeradorEstadual = 0;
        int denominadorEstadual = 0;
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim = (String)parametros.get("parDataFim");
        int i = 1;
        try {
            Object[] rowObjects;
            utilDbf.mapearPosicoes(reader);
            double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
            while ((rowObjects = reader.nextRecord()) != null) {
                if (utilDbf.getString(rowObjects, "SG_UF") != null) {
                    Agravo municipioResidencia = (Agravo)municipiosBeans.get(utilDbf.getString(rowObjects, "ID_MN_RESI"));
                    int soroHBSAG = utilDbf.getInt(rowObjects, "AGHBS");
                    int soroHCV = utilDbf.getInt(rowObjects, "ANTIHCV");
                    String classificacaoEtiologica = utilDbf.getString(rowObjects, "CLAS_ETIOL");
                    int classificacaoFinal = utilDbf.getInt(rowObjects, "CLASSI_FIN");
                    if (municipioResidencia != null) {
                        if (classificacaoEtiologica != null) {
                            if (classificacaoFinal == 1 && (classificacaoEtiologica.equals("02") || classificacaoEtiologica.equals("03") || classificacaoEtiologica.equals("06"))) {
                                try {
                                    if (this.isBetweenDates(utilDbf.getDate(rowObjects, "DT_NOTIFIC"), dataInicio, dataFim)) {
                                        denominador = Integer.parseInt(municipioResidencia.getDenominador());
                                        municipioResidencia.setDenominador(String.valueOf(++denominador));
                                        ++denominadorEstadual;
                                        if (classificacaoEtiologica.equals("02") && soroHBSAG == 1) {
                                            numerador = Integer.parseInt(municipioResidencia.getNumerador());
                                            municipioResidencia.setNumerador(String.valueOf(++numerador));
                                            ++numeradorEstadual;
                                        }
                                        if (classificacaoEtiologica.equals("03") && soroHCV == 1) {
                                            numerador = Integer.parseInt(municipioResidencia.getNumerador());
                                            municipioResidencia.setNumerador(String.valueOf(++numerador));
                                            ++numeradorEstadual;
                                        }
                                        if (classificacaoEtiologica.equals("06") && soroHBSAG == 1 && soroHCV == 1) {
                                            numerador = Integer.parseInt(municipioResidencia.getNumerador());
                                            municipioResidencia.setNumerador(String.valueOf(++numerador));
                                            ++numeradorEstadual;
                                        }
                                        ++denominadorCompletitude;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    Master.mensagem("Erro:\n" + numberFormatException);
                                }
                                catch (ParseException parseException) {
                                    Master.mensagem("Erro:\n" + parseException);
                                }
                            }
                        } else if (this.isBetweenDates(utilDbf.getDate(rowObjects, "DT_NOTIFIC"), dataInicio, dataFim)) {
                            ++completitude;
                        }
                    }
                }
                float f = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                this.getBarraStatus().setValue((int)f);
                ++i;
            }
        }
        catch (DBFException ex) {
            Master.mensagem("Erro:\n" + (Object)((Object)ex));
        }
        String total = df.format(Double.parseDouble(String.valueOf(numeradorEstadual)) / Double.parseDouble(String.valueOf(denominadorEstadual)) * 100.0);
        this.setTaxaEstadual(total + " (Numerador:" + String.valueOf(numeradorEstadual) + " / Denominador: " + String.valueOf(denominadorEstadual) + ")");
        this.setPercentualCompletitude(df.format(Double.parseDouble(String.valueOf(completitude)) / Double.parseDouble(String.valueOf(denominadorCompletitude)) * 100.0));
        this.setBeans(new ArrayList());
        Collection<Object> municipioBean = municipiosBeans.values();
        for (Agravo agravo : municipioBean) {
            double num = Double.parseDouble(agravo.getNumerador());
            double den = Double.parseDouble(agravo.getDenominador());
            if (den == 0.0) {
                agravo.setTaxa("0.00");
            } else {
                agravo.setTaxa(df.format(num / den * 100.0));
            }
            this.getBeans().add(agravo);
            codReg = agravo.getCodRegional();
        }
        Collections.sort(this.getBeans(), new BeanComparator("nomeMunicipio"));
        if (codRegional.length() == 0) {
            this.getBeans().add(this.adicionaTotal(municipioBean, codRegional));
        }
    }

    @Override
    public void calcula(DBFReader reader, Map parametros) {
        String municipios = (String)parametros.get("municipios");
        String brasil = (String)parametros.get("parUf");
        if (municipios.equals("sim") && !brasil.equals("brasil")) {
            try {
                this.calculaMunicipios(reader, parametros);
            }
            catch (ParseException ex) {
                System.out.println(ex);
            }
        } else if (brasil.equals("brasil")) {
            try {
                this.calculaBrasil(reader, parametros);
            }
            catch (ParseException ex) {
                System.out.println(ex);
            }
        } else {
            String municipioResidencia;
            DBFUtil utilDbf = new DBFUtil();
            int completitude = 0;
            int denominadorCompletitude = 0;
            DecimalFormat df = new DecimalFormat("0.00");
            int denominadorEstadual = 0;
            int numeradorEstadual = 0;
            int denominadorEspecifico = 0;
            int numeradorEspecifico = 0;
            String ufResidencia = (String)parametros.get("parUf");
            String parMunicipio = municipioResidencia = (String)parametros.get("parMunicipio");
            if (municipioResidencia == null) {
                municipioResidencia = "";
                parMunicipio = ufResidencia;
            }
            String dataInicio = (String)parametros.get("parDataInicio");
            String dataFim = (String)parametros.get("parDataFim");
            int i = 1;
            try {
                Object[] rowObjects;
                utilDbf.mapearPosicoes(reader);
                double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    if (utilDbf.getString(rowObjects, "SG_UF") != null && utilDbf.getString(rowObjects, "SG_UF").equals(ufResidencia)) {
                        int soroHBSAG = utilDbf.getInt(rowObjects, "AGHBS");
                        int soroHCV = utilDbf.getInt(rowObjects, "ANTIHCV");
                        String classificacaoEtiologica = utilDbf.getString(rowObjects, "CLAS_ETIOL");
                        int classificacaoFinal = utilDbf.getInt(rowObjects, "CLASSI_FIN");
                        if (this.verificaMunicipio(municipioResidencia, utilDbf.getString(rowObjects, "ID_MN_RESI"))) {
                            if (classificacaoEtiologica != null) {
                                if (classificacaoFinal == 1 && (classificacaoEtiologica.equals("02") || classificacaoEtiologica.equals("03") || classificacaoEtiologica.equals("06"))) {
                                    try {
                                        if (this.isBetweenDates(utilDbf.getDate(rowObjects, "DT_NOTIFIC"), dataInicio, dataFim)) {
                                            ++denominadorEspecifico;
                                            ++denominadorEstadual;
                                            if (classificacaoEtiologica.equals("02") && soroHBSAG == 1) {
                                                ++numeradorEspecifico;
                                                ++numeradorEstadual;
                                            } else if (classificacaoEtiologica.equals("03") && soroHCV == 1) {
                                                ++numeradorEspecifico;
                                                ++numeradorEstadual;
                                            } else if (classificacaoEtiologica.equals("06") && soroHBSAG == 1 && soroHCV == 1) {
                                                ++numeradorEspecifico;
                                                ++numeradorEstadual;
                                            }
                                            ++denominadorCompletitude;
                                        }
                                    }
                                    catch (NumberFormatException ex) {
                                        Master.mensagem("Erro:\n" + ex);
                                    }
                                    catch (ParseException ex) {
                                        Master.mensagem("Erro:\n" + ex);
                                    }
                                }
                            } else {
                                try {
                                    if (this.isBetweenDates(utilDbf.getDate(rowObjects, "DT_NOTIFIC"), dataInicio, dataFim)) {
                                        ++completitude;
                                    }
                                }
                                catch (NumberFormatException ex) {
                                    Master.mensagem("Erro:\n" + ex);
                                }
                                catch (ParseException ex) {
                                    Master.mensagem("Erro:\n" + ex);
                                }
                            }
                        }
                    }
                    float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
            }
            catch (DBFException ex) {
                Master.mensagem("Erro:\n" + (Object)((Object)ex));
                System.out.println((Object)ex);
            }
            String total = df.format(Double.parseDouble(String.valueOf(numeradorEstadual)) / Double.parseDouble(String.valueOf(denominadorEstadual)) * 100.0);
            this.setTaxaEstadual(total + " (Numerador:" + String.valueOf(numeradorEstadual) + " / Denominador: " + String.valueOf(denominadorEstadual) + ")");
            Agravo d1 = new Agravo();
            d1.setCodMunicipio(parMunicipio);
            if (municipioResidencia.equals("")) {
                d1.setNomeMunicipio((String)parametros.get("parSgUf"));
            } else {
                d1.setNomeMunicipio((String)parametros.get("parNomeMunicipio"));
            }
            if (!String.valueOf(denominadorEspecifico).equals("0.0")) {
                d1.setNumerador(String.valueOf(NumberFormat.getNumberInstance().format(Double.parseDouble(String.valueOf(numeradorEspecifico)))));
                d1.setDenominador(String.valueOf(NumberFormat.getNumberInstance().format(Double.parseDouble(String.valueOf(denominadorEspecifico)))));
                total = df.format(Double.parseDouble(String.valueOf(numeradorEspecifico)) / Double.parseDouble(String.valueOf(denominadorEspecifico)) * 100.0);
                this.setPercentualCompletitude(df.format(Double.parseDouble(String.valueOf(completitude)) / Double.parseDouble(String.valueOf(denominadorCompletitude)) * 100.0));
                d1.setTaxa(total);
            } else {
                d1.setNumerador("0");
                d1.setDenominador("0");
                d1.setTaxa("0.00");
                this.setPercentualCompletitude("0.00");
            }
            this.setBeans(new ArrayList());
            this.getBeans().add(d1);
        }
    }

    @Override
    public String[] getOrdemColunas() {
        return new String[]{"ID_LOCRES", "DS_LOCRES", "ID_UFRES", "N_ETIOHEP", "D_ETIOHEP", "I_ETIOHEP", "ANO_NOTIF", "DT_NOTINI", "DT_NOTFIN", "ORIGEM"};
    }

    @Override
    public HashMap<String, ColunasDbf> getColunas() {
        HashMap<String, ColunasDbf> hashColunas = new HashMap<String, ColunasDbf>();
        hashColunas.put("ID_LOCRES", new ColunasDbf(7));
        hashColunas.put("DS_LOCRES", new ColunasDbf(30));
        hashColunas.put("ID_UFRES", new ColunasDbf(2));
        hashColunas.put("N_ETIOHEP", new ColunasDbf(10, 0));
        hashColunas.put("D_ETIOHEP", new ColunasDbf(10, 0));
        hashColunas.put("I_ETIOHEP", new ColunasDbf(6, 2));
        hashColunas.put("ANO_NOTIF", new ColunasDbf(4, 0));
        hashColunas.put("DT_NOTINI", new ColunasDbf(10));
        hashColunas.put("DT_NOTFIN", new ColunasDbf(10));
        hashColunas.put("ORIGEM", new ColunasDbf(30));
        this.setColunas(hashColunas);
        return hashColunas;
    }

    @Override
    public Map getParametros() {
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("parDataInicio", Util.formataData(this.getDataInicio()));
        parametros.put("parDataFim", Util.formataData(this.getDataFim()));
        parametros.put("parPeriodo", "de " + this.getDataInicio() + " a " + this.getDataFim());
        parametros.put("parTituloColuna", this.getTituloColuna());
        parametros.put("parFator", String.valueOf(this.getMultiplicador()));
        parametros.put("parAno", Util.getAno(this.getDataFim()));
        parametros.put("parRodape", this.getRodape());
        parametros.put("parConfig", "");
        parametros.put("parTitulo1", "Propor\u00e7\u00e3o de casos de hepatites B e C confirmados por sorologia");
        ANO = "";
        if (Util.getAno(this.getDataFim()).equals(Util.getAno(this.getDataInicio()))) {
            ANO = Util.getAno(this.getDataFim());
        }
        this.setDataInicio(this.getDataInicio());
        this.setDataFim(this.getDataFim());
        return parametros;
    }

    @Override
    public DBFWriter getLinhas(HashMap<String, ColunasDbf> colunas, List bean, DBFWriter writer) throws DBFException, IOException {
        for (int i = 0; i < bean.size(); ++i) {
            Object[] rowData = new Object[colunas.size()];
            Agravo agravo = (Agravo)bean.get(i);
            if (agravo.getNomeMunicipio().equals("BRASIL")) {
                rowData[0] = null;
                rowData[2] = null;
            } else {
                rowData[0] = agravo.getCodMunicipio();
                rowData[2] = agravo.getCodMunicipio().substring(0, 2);
            }
            rowData[1] = agravo.getNomeMunicipio();
            rowData[3] = Double.parseDouble(agravo.getNumerador());
            rowData[4] = Double.parseDouble(agravo.getDenominador());
            rowData[5] = Double.parseDouble(agravo.getTaxa().replace(",", "."));
            rowData[6] = this.preencheAno(this.getDataInicio(), this.getDataFim());
            rowData[7] = this.getDataInicio();
            rowData[8] = this.getDataFim();
            rowData[9] = "HEPATITE-SINANNET";
            writer.addRecord(rowData);
        }
        return writer;
    }

    @Override
    public String getCaminhoJasper() {
        return "/com/org/relatorios/agravo1.jasper";
    }
}

