/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes.agravos;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import com.org.bd.Conexao;
import com.org.bd.DBFUtil;
import com.org.model.classes.Agravo;
import com.org.model.classes.ColunasDbf;
import com.org.model.classes.agravos.oportunidade.CasoOportunidadePQAVS;
import com.org.model.classes.agravos.oportunidade.OportunidadeAgravoPQAVS;
import com.org.negocio.Configuracao;
import com.org.negocio.Municipio;
import com.org.negocio.Util;
import com.org.util.SinanUtil;
import com.org.view.Master;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.BeanComparator;

public class OportunidadePQAVS
extends Agravo {
    private boolean periodoValido180dias = true;
    private boolean periodoValido60dias = true;
    private boolean porAgravo;
    private String dataAvaliacao;
    private String anoAvaliado;
    private String dtInicioAvaliacao;
    private String dtFimAvaliacao;
    private String nomeAgravo;
    private String uf;
    private String municipio;
    private String sqlCalculoAgravos180dias;
    private String sqlCalculoAgravos60dias;
    private String sqlCalculoAgravosMalaria60dias;
    private List<String> agravosValidos = new ArrayList<String>();
    private String sqlCalculoAgravoEspecifico;
    private List<Municipio> municipios = new ArrayList<Municipio>();
    private List<CasoOportunidadePQAVS> listExportacao = new ArrayList<CasoOportunidadePQAVS>();

    public List<CasoOportunidadePQAVS> getListExportacao() {
        return this.listExportacao;
    }

    public void setListExportacao(List<CasoOportunidadePQAVS> listExportacao) {
        this.listExportacao = listExportacao;
    }

    public OportunidadePQAVS(boolean isDbf) {
        this.setDBF(isDbf);
        this.setPeriodo("de avalia\u00e7\u00e3o");
        this.setTipoAgregacao("de Resid\u00eancia");
        this.init("postgres");
    }

    @Override
    public void calcula(DBFReader reader, Map parametros) {
        if (this.uf.equals("Brasil")) {
            try {
                this.setBeans(this.getCalculaResultado(reader, parametros));
            }
            catch (Exception e) {
                System.out.println(e);
            }
        } else {
            try {
                if (this.isDBF()) {
                    this.setBeans(this.getCalculaResultado(reader, parametros));
                } else {
                    Conexao con = new Util().conectarSiceb();
                    con.conect();
                    this.setBeans(this.getCalculaResultado(con.getC(), parametros));
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    @Override
    public void init(String tipoBanco) {
        this.setSqlNumeradorCompletitude("");
        this.setTextoCompletitude("");
        this.setMultiplicador(100);
        this.setTipo("Oportunidade");
        this.setTitulo1("Propor\u00e7\u00e3o de doen\u00e7as exantem\u00e1ticas investigados oportunamente");
        this.setTituloColuna("Propor\u00e7\u00e3o");
        this.setRodape("Numerador: Total de casos suspeitos de sarampo e rub\u00e9ola investigados em at\u00e9 48 horas ap\u00f3s a notifica\u00e7\u00e3o, residentes em determinado local e notificados em determinado per\u00edodo \nDenominador: Total de casos suspeitos de sarampo e rub\u00e9ola,  residentes em determinado local e notificados em determinado per\u00edodo ");
        if (!this.isDBF()) {
            this.setSqlCalculoAgravoEspecifico("select (dt_encerramento-dt_notificacao) as  diff,dt_encerramento,tp_classificacao_final,dt_notificacao,tp_classificacao_final,no_agravo as co_cid,nu_notificacao,co_cnes as co_unidade_notificacao,co_municipio_notificacao,co_municipio_notificacao,no_municipio,co_uf_residencia,co_municipio_residencia,co_uf_notificacao  from dbsinan.tb_notificacao as t1 inner join dbsinan.tb_agravo t2 on t1.co_cid=t2.co_cid inner join dbgeral.tb_municipio t3 on t1.co_municipio_residencia=t3.co_municipio_ibge  left join dblocalidade.tb_estabelecimento_saude us on t1.co_unidade_notificacao = us.co_estabelecimento  where (dt_notificacao BETWEEN ?  AND ?) and co_uf_residencia= ? and t1.co_cid = ? and(tp_duplicidade <> 2 or tp_duplicidade is null) ");
            this.setSqlCalculoAgravos180dias("select (dt_encerramento-dt_notificacao) as  diff,dt_encerramento,tp_classificacao_final,dt_notificacao,tp_classificacao_final,no_agravo as co_cid,nu_notificacao,co_cnes as co_unidade_notificacao,co_municipio_notificacao,co_municipio_notificacao,no_municipio,co_uf_residencia,co_municipio_residencia,co_uf_notificacao from dbsinan.tb_notificacao as t1 inner join dbsinan.tb_agravo t2 on t1.co_cid=t2.co_cid inner join dbgeral.tb_municipio t3 on t1.co_municipio_residencia=t3.co_municipio_ibge  left join dblocalidade.tb_estabelecimento_saude us on t1.co_unidade_notificacao = us.co_estabelecimento  where  t1.co_cid in( 'B19','B55.1','P35.0' ) and  (dt_notificacao BETWEEN ?  AND ?) and co_uf_residencia= ? and (tp_duplicidade <> 2 or tp_duplicidade is null) ");
            this.setSqlCalculoAgravos60dias("select (dt_encerramento-dt_notificacao) as  diff,dt_encerramento,tp_classificacao_final,tp_suspeita,dt_notificacao,tp_classificacao_final,no_agravo as co_cid,nu_notificacao,co_cnes as co_unidade_notificacao,co_municipio_notificacao,co_municipio_notificacao,no_municipio,co_uf_residencia,co_municipio_residencia,co_uf_notificacao  from dbsinan.tb_notificacao as t1 inner join dbsinan.tb_agravo t2 on t1.co_cid=t2.co_cid inner join dbgeral.tb_municipio t3 on t1.co_municipio_residencia=t3.co_municipio_ibge   left join dblocalidade.tb_estabelecimento_saude us on t1.co_unidade_notificacao = us.co_estabelecimento  where  (t1.co_cid in('A35','B09','B57.1','A00.9','A37.9','A36.9','A95.9','A01.0','A27.9','A80.9','A20.9','A82.9','A33','B55.0','A98.8','A77.9','G03.9','A05.1','A77.9','A92.3') or (t1.co_cid='A90' and tp_classificacao_final in(2,3,4))) and  (dt_notificacao BETWEEN ?  AND ?) and co_uf_residencia= ? and (tp_duplicidade <> 2 or tp_duplicidade is null)");
            this.setSqlCalculoAgravosMalaria60dias("select (dt_encerramento-dt_notificacao) as  diff,dt_encerramento,tp_classificacao_final,tp_suspeita,dt_notificacao,tp_classificacao_final,no_agravo as co_cid,nu_notificacao,co_cnes as co_unidade_notificacao,co_municipio_notificacao,co_municipio_notificacao,no_municipio,co_uf_residencia,co_municipio_residencia,co_uf_notificacao  from dbsinan.tb_notificacao as t1 inner join dbsinan.tb_agravo t2 on t1.co_cid=t2.co_cid inner join dbgeral.tb_municipio t3 on t1.co_municipio_residencia=t3.co_municipio_ibge   left join dblocalidade.tb_estabelecimento_saude us on t1.co_unidade_notificacao = us.co_estabelecimento  where  (t1.co_cid in('A35','B09','B57.1','A00.9','A37.9','A36.9','A95.9','A01.0','A27.9','A80.9','A20.9','A82.9','A33','B55.0','A98.8','A77.9','G03.9','A05.1','A77.9','A92.3','B54') or (t1.co_cid='A90' and tp_classificacao_final in(2,3,4))) and  (dt_notificacao BETWEEN ?  AND ?) and co_uf_residencia= ? and (tp_duplicidade <> 2 or tp_duplicidade is null)");
            this.setSqlNumeradorBeanMunicipios(this.getSqlNumeradorMunicipioEspecifico());
            this.setSqlDenominadorBeanMunicipios(this.getSqlDenominadorMunicipioEspecifico());
        }
    }

    private void iniciaAgravosValidos() {
        this.getAgravosValidos().add("A229");
        this.getAgravosValidos().add("A969");
        this.getAgravosValidos().add("A051");
        this.getAgravosValidos().add("A009");
        this.getAgravosValidos().add("A90");
        this.getAgravosValidos().add("A984");
        this.getAgravosValidos().add("Y59");
        this.getAgravosValidos().add("A959");
        this.getAgravosValidos().add("A920");
        this.getAgravosValidos().add("A923");
        this.getAgravosValidos().add("A779");
        this.getAgravosValidos().add("A484");
        this.getAgravosValidos().add("J11");
        this.getAgravosValidos().add("A962");
        this.getAgravosValidos().add("B54");
        this.getAgravosValidos().add("A983");
        this.getAgravosValidos().add("A809");
        this.getAgravosValidos().add("A209");
        this.getAgravosValidos().add("A829");
        this.getAgravosValidos().add("B092");
        this.getAgravosValidos().add("B091");
        this.getAgravosValidos().add("P350");
        this.getAgravosValidos().add("U049");
        this.getAgravosValidos().add("A219");
        this.getAgravosValidos().add("B03");
    }

    private String buscaRegiao(String uf) {
        if (uf.equals("TO")) {
            return "NORTE";
        }
        if (uf.equals("AC")) {
            return "NORTE";
        }
        if (uf.equals("AL")) {
            return "NORDESTE";
        }
        if (uf.equals("AM")) {
            return "NORTE";
        }
        if (uf.equals("AP")) {
            return "NORTE";
        }
        if (uf.equals("BA")) {
            return "NORDESTE";
        }
        if (uf.equals("CE")) {
            return "NORDESTE";
        }
        if (uf.equals("DF")) {
            return "CENTRO-OESTE";
        }
        if (uf.equals("ES")) {
            return "SUDESTE";
        }
        if (uf.equals("GO")) {
            return "CENTRO-OESTE";
        }
        if (uf.equals("MA")) {
            return "NORDESTE";
        }
        if (uf.equals("MG")) {
            return "SUDESTE";
        }
        if (uf.equals("MS")) {
            return "CENTRO-OESTE";
        }
        if (uf.equals("MT")) {
            return "CENTRO-OESTE";
        }
        if (uf.equals("PA")) {
            return "NORTE";
        }
        if (uf.equals("PB")) {
            return "NORDESTE";
        }
        if (uf.equals("PE")) {
            return "NORDESTE";
        }
        if (uf.equals("PI")) {
            return "NORDESTE";
        }
        if (uf.equals("PR")) {
            return "SUL";
        }
        if (uf.equals("RJ")) {
            return "SUDESTE";
        }
        if (uf.equals("RN")) {
            return "NORDESTE";
        }
        if (uf.equals("RO")) {
            return "NORTE";
        }
        if (uf.equals("RR")) {
            return "NORTE";
        }
        if (uf.equals("RS")) {
            return "SUL";
        }
        if (uf.equals("RO")) {
            return "NORTE";
        }
        if (uf.equals("SC")) {
            return "SUL";
        }
        if (uf.equals("SE")) {
            return "NORDESTE";
        }
        if (uf.equals("SP")) {
            return "SUDESTE";
        }
        return null;
    }

    @Override
    public String buscaRegiaoSaude(String idRegiao) throws SQLException {
        if (idRegiao == null) {
            return "";
        }
        DBFReader reader = SinanUtil.retornaObjetoDbfCaminhoArquivo("REGIAO", "dbf\\");
        DBFUtil utilDbf = new DBFUtil();
        try {
            Object[] rowObjects;
            utilDbf.mapearPosicoes(reader);
            while ((rowObjects = reader.nextRecord()) != null) {
                if (!idRegiao.equals(utilDbf.getString(rowObjects, "ID_REGIAO"))) continue;
                return utilDbf.getString(rowObjects, "NM_REGIAO");
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro: regional nao encontrada.Verifique se existe a pasta DBF e se os arquivo REGIAO.DBF est\u00e1 l\u00e1:\n" + (Object)((Object)e));
        }
        return "";
    }

    private HashMap<String, OportunidadeAgravoPQAVS> populaMunicipiosBeansOportuno(String uf, String idMunicipio, String codRegional) {
        float percentual;
        Object[] rowObjects1;
        DBFReader readerMunicipio;
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap municipios = new HashMap();
        HashMap<String, OportunidadeAgravoPQAVS> municipiosBeans = new HashMap<String, OportunidadeAgravoPQAVS>();
        int i = 1;
        if (codRegional.length() > 0 || "".equals(idMunicipio) && !"BR".equals(uf)) {
            readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
            try {
                utilDbf.mapearPosicoes(readerMunicipio);
                while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                    int TotalRegistrosInt = readerMunicipio.getRecordCount();
                    if (codRegional.length() > 0 && codRegional.equals(utilDbf.getString(rowObjects1, "ID_REGIAO"))) {
                        if (!utilDbf.getString(rowObjects1, "NM_MUNICIP").startsWith("IGNORADO") && utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("TRANSF.") == -1 && utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("ATUAL BENTO GONCALVES") == -1 && (utilDbf.getString(rowObjects1, "SG_UF").equals("DF") && utilDbf.getString(rowObjects1, "NM_MUNICIP").equals("BRASILIA") || !utilDbf.getString(rowObjects1, "SG_UF").equals("DF"))) {
                            OportunidadeAgravoPQAVS agravoDbf = new OportunidadeAgravoPQAVS();
                            agravoDbf.setNmAgravo(utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                            agravoDbf.setCodAgravo(utilDbf.getString(rowObjects1, "ID_MUNICIP"));
                            agravoDbf.setRegiao(this.buscaRegiao(agravoDbf.getNmAgravo()));
                            agravoDbf.setUf(utilDbf.getString(rowObjects1, "SG_UF"));
                            agravoDbf.setCodRegiaoSaude(utilDbf.getString(rowObjects1, "ID_REGIAO"));
                            try {
                                agravoDbf.setRegiaoSaude(this.buscaRegiaoSaude(utilDbf.getString(rowObjects1, "ID_REGIAO")));
                            }
                            catch (SQLException ex) {
                                Logger.getLogger(OportunidadePQAVS.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            agravoDbf.setQtdDataInvalida(0);
                            agravoDbf.setQtdInoportuno(0);
                            agravoDbf.setQtdNaoEncerrado(0);
                            agravoDbf.setQtdOportuno(0);
                            agravoDbf.setTotal(0);
                            municipios.put(utilDbf.getString(rowObjects1, "ID_MUNICIP"), utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                            municipiosBeans.put(agravoDbf.getCodAgravo(), agravoDbf);
                        }
                    } else if (uf.equals(utilDbf.getString(rowObjects1, "SG_UF")) && codRegional.length() == 0 && !utilDbf.getString(rowObjects1, "NM_MUNICIP").startsWith("IGNORADO") && utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("TRANSF.") == -1 && utilDbf.getString(rowObjects1, "NM_MUNICIP").lastIndexOf("ATUAL BENTO GONCALVES") == -1 && (utilDbf.getString(rowObjects1, "SG_UF").equals("DF") && utilDbf.getString(rowObjects1, "NM_MUNICIP").equals("BRASILIA") || !utilDbf.getString(rowObjects1, "SG_UF").equals("DF"))) {
                        OportunidadeAgravoPQAVS agravoDbf = new OportunidadeAgravoPQAVS();
                        agravoDbf.setNmAgravo(utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                        agravoDbf.setCodAgravo(utilDbf.getString(rowObjects1, "ID_MUNICIP"));
                        agravoDbf.setRegiao(this.buscaRegiao(agravoDbf.getNmAgravo()));
                        agravoDbf.setUf(utilDbf.getString(rowObjects1, "SG_UF"));
                        agravoDbf.setCodRegiaoSaude(utilDbf.getString(rowObjects1, "ID_REGIAO"));
                        try {
                            agravoDbf.setRegiaoSaude(this.buscaRegiaoSaude(utilDbf.getString(rowObjects1, "ID_REGIAO")));
                        }
                        catch (SQLException ex) {
                            Logger.getLogger(OportunidadePQAVS.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        agravoDbf.setQtdDataInvalida(0);
                        agravoDbf.setQtdInoportuno(0);
                        agravoDbf.setQtdNaoEncerrado(0);
                        agravoDbf.setQtdOportuno(0);
                        agravoDbf.setTotal(0);
                        municipios.put(utilDbf.getString(rowObjects1, "ID_MUNICIP"), utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                        municipiosBeans.put(agravoDbf.getCodAgravo(), agravoDbf);
                    }
                    percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistrosInt)) * 100.0f;
                    this.getBarraStatus().setString("Preparando arquivos... ");
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
                this.getBarraStatus().setValue(0);
            }
            catch (DBFException e) {
                Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
            }
        } else {
            readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("MUNICNET", "dbf\\");
            try {
                utilDbf.mapearPosicoes(readerMunicipio);
                int TotalRegistrosInt = readerMunicipio.getRecordCount();
                while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                    if (utilDbf.getString(rowObjects1, "NM_MUNICIP").equals("BRASILIA")) {
                        SinanUtil.imprimirConsole("TESTE");
                    }
                    if ((utilDbf.getString(rowObjects1, "SG_UF").equals("DF") && utilDbf.getString(rowObjects1, "ID_MUNICIP").equals("530010") || !utilDbf.getString(rowObjects1, "SG_UF").equals("DF")) && (idMunicipio.equals("") || idMunicipio.equals(utilDbf.getString(rowObjects1, "ID_MUNICIP")))) {
                        OportunidadeAgravoPQAVS agravoDbf = new OportunidadeAgravoPQAVS();
                        agravoDbf.setNmAgravo(utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                        agravoDbf.setCodAgravo(utilDbf.getString(rowObjects1, "ID_MUNICIP"));
                        agravoDbf.setRegiao(this.buscaRegiao(agravoDbf.getNmAgravo()));
                        agravoDbf.setUf(utilDbf.getString(rowObjects1, "SG_UF"));
                        agravoDbf.setCodRegiaoSaude(utilDbf.getString(rowObjects1, "ID_REGIAO"));
                        try {
                            agravoDbf.setRegiaoSaude(this.buscaRegiaoSaude(utilDbf.getString(rowObjects1, "ID_REGIAO")));
                        }
                        catch (SQLException ex) {
                            Logger.getLogger(OportunidadePQAVS.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        agravoDbf.setQtdDataInvalida(0);
                        agravoDbf.setQtdInoportuno(0);
                        agravoDbf.setQtdNaoEncerrado(0);
                        agravoDbf.setQtdOportuno(0);
                        agravoDbf.setTotal(0);
                        municipios.put(utilDbf.getString(rowObjects1, "ID_MUNICIP"), utilDbf.getString(rowObjects1, "NM_MUNICIP"));
                        municipiosBeans.put(agravoDbf.getCodAgravo(), agravoDbf);
                    }
                    percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistrosInt)) * 100.0f;
                    this.getBarraStatus().setString("Preparando arquivos... ");
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
                this.getBarraStatus().setValue(0);
            }
            catch (DBFException e) {
                Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
            }
        }
        municipios = new Agravo().sortHashMapByValues(municipios, false);
        Set municipiosKeys = ((HashMap)municipios).keySet();
        HashMap<String, OportunidadeAgravoPQAVS> municipiosBeansRetorno = new HashMap<String, OportunidadeAgravoPQAVS>();
        for (String key : municipiosKeys) {
            municipiosBeansRetorno.put(key, municipiosBeans.get(key));
        }
        return municipiosBeans;
    }

    public String buscaNomeAgravo(String codAgravo) {
        String retorno = "";
        if (codAgravo.equals("A229")) {
            retorno = "ANTRAZ PNEUMONICO";
        }
        if (codAgravo.equals("A969")) {
            retorno = "ARENAVIRUS";
        }
        if (codAgravo.equals("A051")) {
            retorno = "BOTULISMO";
        }
        if (codAgravo.equals("A009")) {
            retorno = "COLERA";
        }
        if (codAgravo.equals("A90")) {
            retorno = "DENGUE (OBITOS)";
        }
        if (codAgravo.equals("A984")) {
            retorno = "EBOLA";
        }
        if (codAgravo.equals("Y59")) {
            retorno = "EVENTOS ADVERSOS GRAVES OU OBITOS POS-VACINACAO";
        }
        if (codAgravo.equals("A959")) {
            retorno = "FEBRE AMARELA";
        }
        if (codAgravo.equals("A920")) {
            retorno = "FEBRE DE CHIKUNGUNYA";
        }
        if (codAgravo.equals("A923")) {
            retorno = "FEBRE DO NILO OCIDENTAL";
        }
        if (codAgravo.equals("A779")) {
            retorno = "FEBRE MACULOSA E OUTRAS RIQUETISIOSES";
        }
        if (codAgravo.equals("A484")) {
            retorno = "FEBRE PURPURICA BRASILEIRA";
        }
        if (codAgravo.equals("J11")) {
            retorno = "INFLUENZA HUMANA PRODUZIDA POR NOVO SUBTIPO VIRAL";
        }
        if (codAgravo.equals("A962")) {
            retorno = "LASSA";
        }
        if (codAgravo.equals("B54")) {
            retorno = "MALARIA NA REGIAO EXTRA AMAZONICA";
        }
        if (codAgravo.equals("A983")) {
            retorno = "MARBURG";
        }
        if (codAgravo.equals("A809")) {
            retorno = "PARALISIA FLACIDA AGUDA";
        }
        if (codAgravo.equals("A209")) {
            retorno = "PESTE";
        }
        if (codAgravo.equals("A829")) {
            retorno = "RAIVA HUMANA";
        }
        if (codAgravo.equals("B092")) {
            retorno = "RUBEOLA";
        }
        if (codAgravo.equals("B091")) {
            retorno = "SARAMPO";
        }
        if (codAgravo.equals("P350")) {
            retorno = "SINDROME DA RUBEOLA CONGENITA";
        }
        if (codAgravo.equals("U049")) {
            retorno = "SINDROME RESPIRAT. AGUDA GRAVE ASSOC. A CORONAVIRUS";
        }
        if (codAgravo.equals("A219")) {
            retorno = "TULAREMIA";
        }
        if (codAgravo.equals("B03")) {
            retorno = "VARIOLA";
        }
        return retorno;
    }

    public HashMap<String, OportunidadeAgravoPQAVS> populaAgravosBeans(String agravoSelecionado) {
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap hashAgravos = new HashMap();
        HashMap<String, OportunidadeAgravoPQAVS> agravosBeans = new HashMap<String, OportunidadeAgravoPQAVS>();
        int exantematica = 1;
        List<String> agravos = null;
        if (agravoSelecionado.equals("TODOS") || agravoSelecionado.isEmpty()) {
            agravos = this.getAgravosValidos();
        } else {
            agravos = new ArrayList<String>();
            agravos.add(agravoSelecionado);
        }
        for (int i = 0; i < agravos.size(); ++i) {
            OportunidadeAgravoPQAVS agravoDbf = new OportunidadeAgravoPQAVS();
            if (agravos.get(i).equals("B09")) {
                agravoDbf.setCodAgravo("B09" + exantematica);
                if (exantematica == 1) {
                    agravoDbf.setNmAgravo("SARAMPO");
                    ++exantematica;
                    --i;
                } else {
                    agravoDbf.setNmAgravo("RUBEOLA");
                }
            } else {
                agravoDbf.setCodAgravo(agravos.get(i));
                agravoDbf.setNmAgravo(this.buscaNomeAgravo(agravos.get(i)));
            }
            agravoDbf.setQtdDataInvalida(0);
            agravoDbf.setQtdInoportuno(0);
            agravoDbf.setQtdNaoEncerrado(0);
            agravoDbf.setQtdOportuno(0);
            agravoDbf.setTotal(0);
            hashAgravos.put(agravoDbf.getCodAgravo(), agravoDbf.getNmAgravo());
            agravosBeans.put(agravoDbf.getCodAgravo(), agravoDbf);
        }
        hashAgravos = this.sortHashMapByValues(hashAgravos, false);
        Set agravoKeys = ((HashMap)hashAgravos).keySet();
        HashMap<String, OportunidadeAgravoPQAVS> agravosBeansRetorno = new HashMap<String, OportunidadeAgravoPQAVS>();
        for (String key : agravoKeys) {
            agravosBeansRetorno.put(key, (OportunidadeAgravoPQAVS)agravosBeans.get(key));
        }
        return agravosBeansRetorno;
    }

    private boolean verificaAgravoOportuno(String agravo) {
        return this.getAgravosValidos().contains(agravo);
    }

    public String formataData(String data) {
        return data.split("-")[2] + "/" + data.split("-")[1] + "/" + data.split("-")[0];
    }

    private String retornaNome(String codMunicipio) {
        String nomeMunicipio = "";
        for (int i = 0; i < this.getMunicipios().size(); ++i) {
            if (!this.getMunicipios().get(i).getCodMunicipio().equals(codMunicipio)) continue;
            nomeMunicipio = this.getMunicipios().get(i).getNmMunicipio();
        }
        return nomeMunicipio;
    }

    private int retornaDiferenca(String agravo) {
        if (agravo.equals("B19") || agravo.equals("B551") || agravo.equals("P350")) {
            return 180;
        }
        return 60;
    }

    private String classificaSituacao(String situacao) {
        if (situacao.equals("Oportuno")) {
            return "1";
        }
        if (situacao.equals("Inoportuno com outras categorias")) {
            return "2";
        }
        if (situacao.equals("Inconclusivo")) {
            return "2";
        }
        if (situacao.equals("N\u00e3o Encerrado")) {
            return "3";
        }
        if (situacao.equals("Data inv\u00e1lida")) {
            return "4";
        }
        return "";
    }

    private void populaBeanExportacaoDBF(String situacao, String agravo, String idMunicipioNotificacao, String idMunicipioResidencia, String dtNotificacao, String nmNotificacao, String idUnidade, String dtEncerramento) {
        CasoOportunidadePQAVS caso = new CasoOportunidadePQAVS();
        caso.setAgravo(agravo);
        caso.setSituacao(this.classificaSituacao(situacao));
        caso.setIdMunicipio(idMunicipioNotificacao);
        caso.setIdMunicipioResidencia(idMunicipioResidencia);
        caso.setDtNotificacao(dtNotificacao);
        caso.setNumNotificacao(nmNotificacao);
        caso.setIdUnidade(idUnidade);
        caso.setAno(dtNotificacao.substring(6, 10));
        caso.setSgUF(idMunicipioNotificacao.substring(0, 2));
        if (idMunicipioResidencia != null) {
            caso.setSgUFResidencia(idMunicipioResidencia.substring(0, 2));
        }
        caso.setDtEncerramento(dtEncerramento);
        this.getListExportacao().add(caso);
    }

    private String classificaNotificacao(int diferencaDatas, int diferencaValida, OportunidadeAgravoPQAVS agravoBean, int classificaoFinal) {
        String retorno = "";
        if (diferencaDatas < 0) {
            agravoBean.setQtdDataInvalida(agravoBean.getQtdDataInvalida() + 1);
            retorno = "Data Inv\u00e1lida";
        } else if (diferencaDatas > diferencaValida) {
            if (classificaoFinal == 8) {
                agravoBean.setQtdInoportuno(agravoBean.getQtdInoportuno() + 1);
                retorno = "Inconclusivo";
            } else {
                agravoBean.setQtdInoportunoOutras(agravoBean.getQtdInoportunoOutras() + 1);
                retorno = "Inoportuno com outras categorias";
            }
        } else if (diferencaDatas <= diferencaValida) {
            agravoBean.setQtdOportuno(agravoBean.getQtdOportuno() + 1);
            retorno = "Oportuno";
        }
        agravoBean.setTotal(agravoBean.getTotal() + 1);
        return retorno;
    }

    private List calculaEstadoMunicipio(DBFReader reader, Map parametros) throws ParseException, DBFException {
        HashMap<Object, Object> municipiosBeans = new HashMap();
        DBFUtil utilDbf = new DBFUtil();
        List<Object> municipiosRegionais = new ArrayList();
        CasoOportunidadePQAVS casoListado = null;
        boolean todosMunicipio = true;
        String agravoSelecionado = this.buscaCodigoAgravo(parametros.get("parAgravo").toString());
        if (agravoSelecionado.equals("")) {
            agravoSelecionado = "TODOS";
        }
        Agravo agravodbf = new Agravo();
        this.iniciaAgravosValidos();
        if (parametros.get("parNomeMunicipio") == null) {
            parametros.put("parNomeMunicipio", "");
            todosMunicipio = false;
        }
        if (parametros.get("parCodRegional") == null) {
            parametros.put("parCodRegional", "");
        }
        if (parametros.get("parNomeMunicipio").equals("TODOS")) {
            todosMunicipio = true;
        }
        if (parametros.get("parNomeMunicipio").equals("-- Selecione --") && parametros.get("parCodRegional").toString().length() > 0) {
            todosMunicipio = true;
            parametros.put("parNomeMunicipio", "TODOS");
        }
        boolean porRegional = false;
        if (todosMunicipio && parametros.get("parCodRegional").toString().length() > 0) {
            municipiosRegionais = this.verificaMunicipioRegiaoSaude(parametros.get("parCodRegional").toString());
            porRegional = true;
        }
        if (!parametros.get("parNomeMunicipio").equals("") && !parametros.get("parNomeMunicipio").equals("TODOS")) {
            if (parametros.get("parDiscriminarPorAgravo").equals(false)) {
                municipiosBeans = this.populaMunicipiosBeansOportuno(parametros.get("parSgUf").toString(), parametros.get("parMunicipio").toString(), parametros.get("parCodRegional").toString());
                this.setPorAgravo(false);
            } else {
                municipiosBeans = this.populaAgravosBeans(agravoSelecionado);
                this.setPorAgravo(true);
            }
        } else {
            if (parametros.get("parDiscriminarPorAgravo").equals(false)) {
                parametros.put("parNomeMunicipio", "Todos Munic\u00edpios");
            }
            if (parametros.get("parNomeMunicipio").toString().equals("Todos Munic\u00edpios")) {
                municipiosBeans = this.populaMunicipiosBeansOportuno(parametros.get("parSgUf").toString(), "", parametros.get("parCodRegional").toString());
                this.setPorAgravo(false);
            } else {
                municipiosBeans = this.populaAgravosBeans(agravoSelecionado);
                this.setPorAgravo(true);
            }
        }
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim60 = (String)parametros.get("parDataFim60");
        String dataFim180 = (String)parametros.get("parDataFim180");
        String ufResidencia = (String)parametros.get("parUf");
        String ufResidenciaDbf = "";
        String parMunicipioResidencia = (String)parametros.get("parMunicipio");
        String parMunicipioResidenciaDbf = "";
        int i = 1;
        int anoAvaliadoMalaria = Integer.parseInt(parametros.get("parDataInicio").toString().split("-")[0]);
        if (anoAvaliadoMalaria == 2008 && agravoSelecionado.equals("B54")) {
            Master.mensagem("Mal\u00e1ria est\u00e1 dispon\u00edvel a partir do ano de 2009");
            return null;
        }
        String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
        boolean denqueOnLine = SinanUtil.verificaDBDengueOnLine(arquivos);
        for (int k = 0; k < arquivos.length; ++k) {
            i = 1;
            String arquivo = arquivos[k].substring(0, 5);
            try {
                Object[] rowObjects;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                utilDbf.mapearPosicoes(reader);
                double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                while ((rowObjects = reader.nextRecord()) != null) {
                    if (utilDbf.getString(rowObjects, "SG_UF") == null) continue;
                    Date dtNotificacao = utilDbf.getDate(rowObjects, "DT_NOTIFIC");
                    Date dtEncerramento = utilDbf.getDate(rowObjects, "DT_ENCERRA");
                    String agravo = utilDbf.getString(rowObjects, "ID_AGRAVO");
                    ufResidenciaDbf = utilDbf.getString(rowObjects, "SG_UF");
                    parMunicipioResidenciaDbf = utilDbf.getString(rowObjects, "ID_MN_RESI");
                    if (arquivo.equals("DENGO") || arquivo.equals("NINDI") && denqueOnLine && !agravo.equals("A90") || arquivo.equals("NINDI") && !denqueOnLine || arquivo.equals("INFLU")) {
                        if (agravo.equals("B09")) {
                            int suspeita = utilDbf.getInt(rowObjects, "CS_SUSPEIT");
                            agravo = suspeita == 1 ? "B091" : "B092";
                        }
                        OportunidadeAgravoPQAVS municipioResidencia = parametros.get("parNomeMunicipio").toString().equals("Todos Munic\u00edpios") ? (OportunidadeAgravoPQAVS)municipiosBeans.get(parMunicipioResidenciaDbf) : (!parametros.get("parNomeMunicipio").toString().equals("") && !this.isPorAgravo() ? (OportunidadeAgravoPQAVS)municipiosBeans.get(parMunicipioResidenciaDbf) : (OportunidadeAgravoPQAVS)municipiosBeans.get(agravo));
                        boolean continuaCalculo = true;
                        if (!agravoSelecionado.equals("TODOS") && !agravoSelecionado.equals(agravo)) {
                            continuaCalculo = false;
                        }
                        if (porRegional && !municipiosRegionais.contains(utilDbf.getString(rowObjects, "ID_MN_RESI"))) {
                            continuaCalculo = false;
                        }
                        if (agravoSelecionado.equals("TODOS") && anoAvaliadoMalaria == 2008 && agravo.equals("B54")) {
                            continuaCalculo = false;
                        }
                        if (ufResidenciaDbf == null) {
                            continuaCalculo = false;
                        } else if (!ufResidencia.equals(ufResidenciaDbf)) {
                            continuaCalculo = false;
                        }
                        if (parMunicipioResidencia != null) {
                            if (parMunicipioResidenciaDbf == null) {
                                continuaCalculo = false;
                            } else if (!parMunicipioResidencia.equals(parMunicipioResidenciaDbf)) {
                                continuaCalculo = false;
                            }
                        }
                        if (agravo.equals("A90")) {
                            String evolucao = utilDbf.getString(rowObjects, "EVOLUCAO", 1);
                            if (evolucao == null) {
                                continuaCalculo = false;
                            } else {
                                int cf = Integer.parseInt(evolucao);
                                if (cf < 2 || cf > 4) {
                                    continuaCalculo = false;
                                }
                            }
                        }
                        if (municipioResidencia != null && this.verificaAgravoOportuno(agravo) && continuaCalculo) {
                            String dataFim = dataFim60;
                            String colunaClassificacao = "CLASSI_FIN";
                            if (agravo.equals("B19") || agravo.equals("P350") || agravo.equals("B551")) {
                                dataFim = dataFim180;
                                if (agravo.equals("B551")) {
                                    colunaClassificacao = "CLASSI_FIN";
                                }
                            }
                            if (agravodbf.isBetweenDates(dtNotificacao, dataInicio, dataFim)) {
                                casoListado = new CasoOportunidadePQAVS();
                                String situacao = "";
                                if (dtEncerramento == null) {
                                    if (this.isTemListagem()) {
                                        casoListado.setAgravo(this.buscaNomeAgravo(agravo));
                                        casoListado.setDtNotificacao(this.formataData(dtNotificacao.toString()));
                                        casoListado.setIdUnidade(utilDbf.getString(rowObjects, "ID_UNIDADE"));
                                        casoListado.setNumNotificacao(utilDbf.getString(rowObjects, "NU_NOTIFIC"));
                                        casoListado.setIdMunicipio(utilDbf.getString(rowObjects, "ID_MUNICIP"));
                                        String nomeMunicipio = this.retornaNome(utilDbf.getString(rowObjects, "ID_MN_RESI"));
                                        if (nomeMunicipio.equals("")) {
                                            Municipio municipioNovo = new Municipio();
                                            municipioNovo.setCodMunicipio(utilDbf.getString(rowObjects, "ID_MN_RESI"));
                                            municipioNovo.setNmMunicipio(agravodbf.getNomeMunicipio(utilDbf.getString(rowObjects, "ID_MN_RESI")));
                                            casoListado.setNmMunicipio(municipioNovo.getNmMunicipio());
                                            this.getMunicipios().add(municipioNovo);
                                        } else {
                                            casoListado.setNmMunicipio(nomeMunicipio);
                                        }
                                        casoListado.setSituacao("N\u00e3o Encerrado");
                                        this.getListagemCasosPQAVS().add(casoListado);
                                        situacao = "N\u00e3o Encerrado";
                                    }
                                    municipioResidencia.setQtdNaoEncerrado(municipioResidencia.getQtdNaoEncerrado() + 1);
                                    municipioResidencia.setTotal(municipioResidencia.getTotal() + 1);
                                } else {
                                    int diferenca = Agravo.dataDiff(dtNotificacao, dtEncerramento);
                                    int diferencaOportuna = this.retornaDiferenca(agravo);
                                    situacao = this.classificaNotificacao(diferenca, diferencaOportuna, municipioResidencia, utilDbf.getInt(rowObjects, colunaClassificacao));
                                    if (agravo.equals("A010")) {
                                        System.out.println(utilDbf.getString(rowObjects, "NU_NOTIFIC"));
                                    }
                                    if (this.isTemListagem() && !situacao.equals("Oportuno") && !situacao.equals("Inoportuno com outras categorias")) {
                                        casoListado.setAgravo(this.buscaNomeAgravo(agravo));
                                        casoListado.setDtNotificacao(this.formataData(dtNotificacao.toString()));
                                        casoListado.setIdUnidade(utilDbf.getString(rowObjects, "ID_UNIDADE"));
                                        casoListado.setNumNotificacao(utilDbf.getString(rowObjects, "NU_NOTIFIC"));
                                        casoListado.setIdMunicipio(utilDbf.getString(rowObjects, "ID_MUNICIP"));
                                        String nomeMunicipio = this.retornaNome(utilDbf.getString(rowObjects, "ID_MN_RESI"));
                                        if (nomeMunicipio.equals("")) {
                                            Municipio municipioNovo = new Municipio();
                                            municipioNovo.setCodMunicipio(utilDbf.getString(rowObjects, "ID_MN_RESI"));
                                            municipioNovo.setNmMunicipio(agravodbf.getNomeMunicipio(utilDbf.getString(rowObjects, "ID_MN_RESI")));
                                            casoListado.setNmMunicipio(municipioNovo.getNmMunicipio());
                                            this.getMunicipios().add(municipioNovo);
                                        } else {
                                            casoListado.setNmMunicipio(nomeMunicipio);
                                        }
                                        casoListado.setSituacao(situacao);
                                        this.getListagemCasosPQAVS().add(casoListado);
                                    }
                                }
                                if (dtEncerramento == null) {
                                    String dtEncerramentoExportacao = "";
                                } else {
                                    String string = this.formataData(dtEncerramento.toString());
                                }
                            }
                        }
                    }
                    float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                    this.getBarraStatus().setString((int)percentual + "%");
                    this.getBarraStatus().setValue((int)percentual);
                    ++i;
                }
                continue;
            }
            catch (DBFException ex) {
                Master.mensagem("Erro:\n" + (Object)((Object)ex));
            }
        }
        ArrayList<OportunidadeAgravoPQAVS> beans = new ArrayList<OportunidadeAgravoPQAVS>();
        Collection<Object> municipioBean = municipiosBeans.values();
        for (OportunidadeAgravoPQAVS oportunidadeAgravoPQAVS : municipioBean) {
            beans.add(oportunidadeAgravoPQAVS);
        }
        Collections.sort(beans, new BeanComparator("nmAgravo"));
        Collections.sort(this.getListagemCasos(), new BeanComparator("situacao"));
        Collections.sort(this.getListagemCasos(), new BeanComparator("nmMunicipio"));
        OportunidadeAgravoPQAVS agravoBean = new OportunidadeAgravoPQAVS();
        agravoBean.setNmAgravo("TOTAL");
        for (i = 0; i < beans.size(); ++i) {
            agravoBean.setQtdOportuno(((OportunidadeAgravoPQAVS)beans.get(i)).getQtdOportuno() + agravoBean.getQtdOportuno());
            agravoBean.setQtdInoportuno(((OportunidadeAgravoPQAVS)beans.get(i)).getQtdInoportuno() + agravoBean.getQtdInoportuno());
            agravoBean.setQtdInoportunoOutras(((OportunidadeAgravoPQAVS)beans.get(i)).getQtdInoportunoOutras() + agravoBean.getQtdInoportunoOutras());
            agravoBean.setQtdNaoEncerrado(((OportunidadeAgravoPQAVS)beans.get(i)).getQtdNaoEncerrado() + agravoBean.getQtdNaoEncerrado());
            agravoBean.setQtdDataInvalida(((OportunidadeAgravoPQAVS)beans.get(i)).getQtdDataInvalida() + agravoBean.getQtdDataInvalida());
            agravoBean.setTotal(((OportunidadeAgravoPQAVS)beans.get(i)).getTotal() + agravoBean.getTotal());
        }
        if (!this.isPorAgravo() && !todosMunicipio) {
            beans = new ArrayList();
            agravoBean.setNmAgravo(parametros.get("parSgUf").toString());
        }
        beans.add(agravoBean);
        return beans;
    }

    public HashMap<String, OportunidadeAgravoPQAVS> populaUfsBeansOportuno() {
        DBFUtil utilDbf = new DBFUtil();
        LinkedHashMap uf = new HashMap();
        HashMap<String, OportunidadeAgravoPQAVS> ufsBeans = new HashMap<String, OportunidadeAgravoPQAVS>();
        DBFReader readerMunicipio = Util.retornaObjetoDbfCaminhoArquivo("UF", "dbf\\");
        try {
            Object[] rowObjects1;
            utilDbf.mapearPosicoes(readerMunicipio);
            while ((rowObjects1 = readerMunicipio.nextRecord()) != null) {
                OportunidadeAgravoPQAVS agravoDbf = new OportunidadeAgravoPQAVS();
                agravoDbf.setNmAgravo(utilDbf.getString(rowObjects1, "SG_UF"));
                agravoDbf.setUf(utilDbf.getString(rowObjects1, "SG_UF"));
                agravoDbf.setCodAgravo(utilDbf.getString(rowObjects1, "ID_UF"));
                agravoDbf.setRegiao(this.buscaRegiao(agravoDbf.getNmAgravo()));
                agravoDbf.setCodRegiaoSaude(utilDbf.getString(rowObjects1, "ID_REGIAO"));
                try {
                    agravoDbf.setRegiaoSaude(this.buscaRegiaoSaude(utilDbf.getString(rowObjects1, "ID_REGIAO")));
                }
                catch (SQLException ex) {
                    Logger.getLogger(OportunidadePQAVS.class.getName()).log(Level.SEVERE, null, ex);
                }
                agravoDbf.setQtdDataInvalida(0);
                agravoDbf.setQtdInoportuno(0);
                agravoDbf.setQtdNaoEncerrado(0);
                agravoDbf.setQtdOportuno(0);
                agravoDbf.setTotal(0);
                uf.put(utilDbf.getString(rowObjects1, "ID_UF"), utilDbf.getString(rowObjects1, "SG_UF"));
                ufsBeans.put(agravoDbf.getCodAgravo(), agravoDbf);
            }
        }
        catch (DBFException e) {
            Master.mensagem("Erro ao carregar municipios:\n" + (Object)((Object)e));
        }
        uf = this.sortHashMapByValues(uf, false);
        Set ufKeys = ((HashMap)uf).keySet();
        HashMap<String, OportunidadeAgravoPQAVS> ufsBeansRetorno = new HashMap<String, OportunidadeAgravoPQAVS>();
        for (String key : ufKeys) {
            ufsBeansRetorno.put(key, (OportunidadeAgravoPQAVS)ufsBeans.get(key));
        }
        return ufsBeansRetorno;
    }

    public List getCalculaResultado(DBFReader reader, Map parametros) throws ParseException, DBFException {
        String coluna;
        if (!parametros.get("parUf").equals("brasil")) {
            return this.calculaEstadoMunicipio(reader, parametros);
        }
        CasoOportunidadePQAVS casoListado = null;
        HashMap<Object, Object> municipiosBeans = new HashMap();
        DBFUtil utilDbf = new DBFUtil();
        Agravo agravodbf = new Agravo();
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim60 = (String)parametros.get("parDataFim60");
        String dataFim180 = (String)parametros.get("parDataFim180");
        int i = 1;
        String agravoSelecionado = this.buscaCodigoAgravo(parametros.get("parAgravo").toString());
        if (parametros.get("municipios").toString().equals("sim")) {
            municipiosBeans = this.populaMunicipiosBeansOportuno("BR", "", "");
            coluna = "ID_MN_RESI";
        } else {
            municipiosBeans = this.populaUfsBeansOportuno();
            coluna = "SG_UF";
        }
        this.iniciaAgravosValidos();
        if (parametros.get("parDiscriminarPorAgravo").equals(true)) {
            municipiosBeans = this.populaAgravosBeans(agravoSelecionado);
            coluna = "ID_AGRAVO";
        }
        String[] arquivos = parametros.get("parArquivos").toString().split("\\|\\|");
        boolean denqueOnLine = SinanUtil.verificaDBDengueOnLine(arquivos);
        for (int k = 0; k < arquivos.length; ++k) {
            i = 1;
            String arquivo = arquivos[k].substring(0, 5);
            try {
                Object[] rowObjects;
                reader = Util.retornaObjetoDbfCaminhoArquivo(arquivos[k].substring(0, arquivos[k].length() - 4), Configuracao.getPropriedade("caminho"));
                utilDbf.mapearPosicoes(reader);
                int TotalRegistrosInt = reader.getRecordCount();
                while ((rowObjects = reader.nextRecord()) != null) {
                    if (utilDbf.getString(rowObjects, coluna) != null) {
                        String agravo = utilDbf.getString(rowObjects, "ID_AGRAVO");
                        if (arquivo.equals("DENGO") || arquivo.equals("NINDI") && denqueOnLine && !agravo.equals("A90") || arquivo.equals("NINDI") && !denqueOnLine || arquivo.equals("INFLU")) {
                            boolean bl;
                            if (agravo.equals("B09")) {
                                int n = utilDbf.getInt(rowObjects, "CS_SUSPEIT");
                                agravo = n == 1 ? "B091" : "B092";
                            }
                            OportunidadeAgravoPQAVS municipioResidencia = coluna.equals("ID_AGRAVO") ? (OportunidadeAgravoPQAVS)municipiosBeans.get(agravo) : (OportunidadeAgravoPQAVS)municipiosBeans.get(utilDbf.getString(rowObjects, coluna));
                            Date dtNotificacao = utilDbf.getDate(rowObjects, "DT_NOTIFIC");
                            Date dtEncerramento = utilDbf.getDate(rowObjects, "DT_ENCERRA");
                            boolean bl2 = true;
                            if (agravo.equals("A90")) {
                                String evolucao = utilDbf.getString(rowObjects, "EVOLUCAO", 1);
                                if (evolucao == null) {
                                    boolean bl3 = false;
                                } else {
                                    int cf = Integer.parseInt(evolucao);
                                    if (cf < 2 || cf > 4) {
                                        boolean bl4 = false;
                                    }
                                }
                            }
                            if (agravoSelecionado.length() > 0 && !agravoSelecionado.equals(agravo)) {
                                boolean bl5 = false;
                            }
                            int anoAvaliadoMalaria = Integer.parseInt(parametros.get("parDataInicio").toString().split("-")[0]);
                            if (agravoSelecionado.length() == 0 && anoAvaliadoMalaria == 2008 && agravo.equals("B54")) {
                                bl = false;
                            }
                            if (anoAvaliadoMalaria == 2008 && agravoSelecionado.equals("B54")) {
                                Master.mensagem("Mal\u00e1ria est\u00e1 dispon\u00edvel a partir do ano de 2009");
                                return null;
                            }
                            if (municipioResidencia != null && this.verificaAgravoOportuno(agravo) && bl) {
                                String dataFim = dataFim60;
                                String colunaClassificacao = "CLASSI_FIN";
                                if (agravo.equals("B19") || agravo.equals("P350") || agravo.equals("B551")) {
                                    dataFim = dataFim180;
                                    if (agravo.equals("B551")) {
                                        colunaClassificacao = "CLASSI_FIN";
                                    }
                                }
                                if (agravodbf.isBetweenDates(dtNotificacao, dataInicio, dataFim)) {
                                    casoListado = new CasoOportunidadePQAVS();
                                    String situacao = "";
                                    if (dtEncerramento == null) {
                                        if (this.isTemListagem()) {
                                            casoListado.setAgravo(this.buscaNomeAgravo(agravo));
                                            casoListado.setDtNotificacao(this.formataData(dtNotificacao.toString()));
                                            casoListado.setIdUnidade(utilDbf.getString(rowObjects, "ID_UNIDADE"));
                                            casoListado.setNumNotificacao(utilDbf.getString(rowObjects, "NU_NOTIFIC"));
                                            casoListado.setIdMunicipio(utilDbf.getString(rowObjects, "ID_MUNICIP"));
                                            String nomeMunicipio = this.retornaNome(utilDbf.getString(rowObjects, "ID_MN_RESI"));
                                            if (nomeMunicipio.equals("")) {
                                                Municipio municipioNovo = new Municipio();
                                                municipioNovo.setCodMunicipio(utilDbf.getString(rowObjects, "ID_MN_RESI"));
                                                municipioNovo.setNmMunicipio(agravodbf.getNomeMunicipio(utilDbf.getString(rowObjects, "ID_MN_RESI")));
                                                casoListado.setNmMunicipio(municipioNovo.getNmMunicipio());
                                                this.getMunicipios().add(municipioNovo);
                                            } else {
                                                casoListado.setNmMunicipio(nomeMunicipio);
                                            }
                                            casoListado.setSituacao("N\u00e3o Encerrado");
                                            this.getListagemCasosPQAVS().add(casoListado);
                                        }
                                        situacao = "N\u00e3o Encerrado";
                                        municipioResidencia.setQtdNaoEncerrado(municipioResidencia.getQtdNaoEncerrado() + 1);
                                        municipioResidencia.setTotal(municipioResidencia.getTotal() + 1);
                                    } else {
                                        int diferencaOportuna;
                                        int diferenca = OportunidadePQAVS.dataDiff(dtNotificacao, dtEncerramento);
                                        situacao = this.classificaNotificacao(diferenca, diferencaOportuna = this.retornaDiferenca(agravo), municipioResidencia, utilDbf.getInt(rowObjects, colunaClassificacao));
                                        if (situacao.equals("Data Inv\u00e1lida")) {
                                            System.out.println("dt_notificacao:" + this.formataData(dtNotificacao.toString()) + "\nnum notificacao:" + utilDbf.getString(rowObjects, "NU_NOTIFIC") + "\nmunicipio:" + utilDbf.getString(rowObjects, "ID_MUNICIP"));
                                        }
                                        if (this.isTemListagem() && !situacao.equals("Oportuno") && !situacao.equals("Inoportuno com outras categorias")) {
                                            casoListado.setAgravo(this.buscaNomeAgravo(agravo));
                                            casoListado.setDtNotificacao(this.formataData(dtNotificacao.toString()));
                                            casoListado.setIdUnidade(utilDbf.getString(rowObjects, "ID_UNIDADE"));
                                            casoListado.setNumNotificacao(utilDbf.getString(rowObjects, "NU_NOTIFIC"));
                                            casoListado.setIdMunicipio(utilDbf.getString(rowObjects, "ID_MUNICIP"));
                                            String nomeMunicipio = this.retornaNome(utilDbf.getString(rowObjects, "ID_MN_RESI"));
                                            if (nomeMunicipio.equals("")) {
                                                Municipio municipioNovo = new Municipio();
                                                municipioNovo.setCodMunicipio(utilDbf.getString(rowObjects, "ID_MN_RESI"));
                                                municipioNovo.setNmMunicipio(agravodbf.getNomeMunicipio(utilDbf.getString(rowObjects, "ID_MN_RESI")));
                                                casoListado.setNmMunicipio(municipioNovo.getNmMunicipio());
                                                this.getMunicipios().add(municipioNovo);
                                            } else {
                                                casoListado.setNmMunicipio(nomeMunicipio);
                                            }
                                            casoListado.setSituacao(situacao);
                                            this.getListagemCasosPQAVS().add(casoListado);
                                        }
                                    }
                                    if (dtEncerramento == null) {
                                        String dtEncerramentoExportacao = "";
                                    } else {
                                        String string = this.formataData(dtEncerramento.toString());
                                    }
                                }
                            }
                        }
                    }
                    float f = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistrosInt)) * 100.0f;
                    this.getBarraStatus().setString((int)f + "%");
                    this.getBarraStatus().setValue((int)f);
                    ++i;
                }
                continue;
            }
            catch (DBFException ex) {
                Master.mensagem("Erro:\n" + (Object)((Object)ex));
            }
        }
        ArrayList<OportunidadeAgravoPQAVS> beans = new ArrayList<OportunidadeAgravoPQAVS>();
        Collection<Object> municipioBean = municipiosBeans.values();
        for (OportunidadeAgravoPQAVS oportunidadeAgravoPQAVS : municipioBean) {
            beans.add(oportunidadeAgravoPQAVS);
        }
        Collections.sort(beans, new BeanComparator("nmAgravo"));
        if (!parametros.get("municipios").toString().equals("sim") && parametros.get("parDiscriminarPorAgravo").equals(false)) {
            Collections.sort(beans, new BeanComparator("regiao"));
        }
        Collections.sort(this.getListagemCasos(), new BeanComparator("situacao"));
        Collections.sort(this.getListagemCasos(), new BeanComparator("nmMunicipio"));
        OportunidadeAgravoPQAVS agravoBean = new OportunidadeAgravoPQAVS();
        agravoBean.setNmAgravo("TOTAL");
        for (i = 0; i < beans.size(); ++i) {
            agravoBean.setQtdOportuno(((OportunidadeAgravoPQAVS)beans.get(i)).getQtdOportuno() + agravoBean.getQtdOportuno());
            agravoBean.setQtdInoportuno(((OportunidadeAgravoPQAVS)beans.get(i)).getQtdInoportuno() + agravoBean.getQtdInoportuno());
            agravoBean.setQtdInoportunoOutras(((OportunidadeAgravoPQAVS)beans.get(i)).getQtdInoportunoOutras() + agravoBean.getQtdInoportunoOutras());
            agravoBean.setQtdNaoEncerrado(((OportunidadeAgravoPQAVS)beans.get(i)).getQtdNaoEncerrado() + agravoBean.getQtdNaoEncerrado());
            agravoBean.setQtdDataInvalida(((OportunidadeAgravoPQAVS)beans.get(i)).getQtdDataInvalida() + agravoBean.getQtdDataInvalida());
            agravoBean.setTotal(((OportunidadeAgravoPQAVS)beans.get(i)).getTotal() + agravoBean.getTotal());
        }
        beans.add(agravoBean);
        return beans;
    }

    private String converteCodigoParaCompleto(String agravoSelecionado) {
        if (agravoSelecionado.length() > 3) {
            return agravoSelecionado.substring(0, 3) + "." + agravoSelecionado.substring(3);
        }
        return agravoSelecionado;
    }

    private List getCalculaResultadoPorMunicipio(Connection con, Map parametros) throws SQLException {
        ResultSet rs;
        String noMunicipio = null;
        String situacao = "";
        String codCid = "";
        String rsIdMunicipio = "";
        String rsIdMunicipioResidencia = "";
        String rsNumeroNotificacao = "";
        String rsIdUnidade = "";
        Statement stm = con.createStatement();
        OportunidadeAgravoPQAVS agravoBean = null;
        ArrayList<OportunidadeAgravoPQAVS> beans = new ArrayList<OportunidadeAgravoPQAVS>();
        CasoOportunidadePQAVS casoListado = null;
        boolean prosseguir = true;
        String sql = parametros.get("parNomeRegional").equals("-- Selecione --") || parametros.get("parNomeRegional").equals("TODAS") || parametros.get("parNomeRegional").equals("") ? "select co_municipio_ibge,no_municipio from dbgeral.tb_municipio where sg_uf = '" + parametros.get("parSgUf") + "' order by no_municipio" : "select t1.co_municipio_ibge,no_municipio from dbgeral.tb_municipio as t1, dblocalidade.rl_regional_municipio_svs as t2 where t2.co_uf_ibge=" + parametros.get("parUf") + " and t1.co_municipio_ibge=t2.co_municipio_ibge and co_regional = '" + parametros.get("parCodRegional") + "' and no_municipio not like '%Ignorado%'  order by no_municipio";
        try {
            rs = stm.executeQuery(sql);
        }
        catch (Exception exception) {
            sql = parametros.get("parNomeRegional").equals("TODAS") || parametros.get("parNomeRegional").equals("-- Selecione --") ? "select co_municipio_ibge,no_municipio from dbgeral.tb_municipio where sg_uf = '" + parametros.get("parSgUf") + "' order by no_municipio" : "select t1.co_municipio_ibge,no_municipio from dbgeral.tb_municipio as t1, dblocalidade.rl_regional_municipio_svs as t2 where t2.co_uf_ibge=" + parametros.get("parUf") + " and t1.co_municipio_ibge=t2.co_municipio_ibge and co_regional = '" + parametros.get("parCodRegional") + "' and no_municipio not like '%Ignorado%'  order by no_municipio";
            rs = stm.executeQuery(sql);
        }
        while (rs.next()) {
            ResultSet rs2;
            PreparedStatement stm2;
            String municipio = rs.getString("co_municipio_ibge");
            noMunicipio = rs.getString("no_municipio");
            this.getBarraStatus().setString("Aguarde, calculado do munic\u00edpio de " + noMunicipio);
            agravoBean = new OportunidadeAgravoPQAVS();
            agravoBean.setNmAgravo(noMunicipio);
            beans.add(agravoBean);
            String agravoSelecionado = parametros.get("parAgravo").toString();
            if (agravoSelecionado.equals("TODOS") || agravoSelecionado.equals("B19") || agravoSelecionado.equals("B551") || agravoSelecionado.equals("P350")) {
                if (agravoSelecionado.equals("TODOS")) {
                    sql = this.getSqlCalculoAgravos180dias() + " and co_municipio_residencia = ?  order by co_cid,tp_suspeita";
                } else {
                    sql = this.getSqlCalculoAgravoEspecifico() + " and co_municipio_residencia = ?  order by co_cid,tp_suspeita";
                    agravoSelecionado = this.converteCodigoParaCompleto(agravoSelecionado);
                    prosseguir = false;
                }
                stm2 = con.prepareStatement(sql);
                stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
                stm2.setDate(2, this.transformaDate(parametros.get("parDataFim180").toString()));
                stm2.setString(3, parametros.get("parUf").toString());
                if (!agravoSelecionado.equals("TODOS")) {
                    stm2.setString(4, agravoSelecionado);
                    stm2.setString(5, municipio);
                } else {
                    stm2.setString(4, municipio);
                }
                rs2 = stm2.executeQuery();
                while (rs2.next()) {
                    casoListado = new CasoOportunidadePQAVS();
                    Date dtEncerramento = rs2.getDate("dt_encerramento");
                    Date dtNotificacao = rs2.getDate("dt_notificacao");
                    codCid = rs2.getString("co_cid");
                    rsIdMunicipio = rs2.getString("co_municipio_notificacao");
                    rsIdMunicipioResidencia = rs2.getString("co_municipio_residencia");
                    rsNumeroNotificacao = rs2.getString("nu_notificacao");
                    rsIdUnidade = rs2.getString("co_unidade_notificacao");
                    if (dtEncerramento == null) {
                        if (this.isTemListagem()) {
                            casoListado.setAgravo(codCid);
                            casoListado.setDtNotificacao(this.formataData(((java.util.Date)dtNotificacao).toString()));
                            casoListado.setIdUnidade(rsIdUnidade);
                            casoListado.setNumNotificacao(rsNumeroNotificacao);
                            casoListado.setIdMunicipio(rsIdMunicipio);
                            casoListado.setNmMunicipio(rs2.getString("no_municipio"));
                            casoListado.setSituacao("N\u00e3o Encerrado");
                            casoListado.setIdMunicipioResidencia(rsIdMunicipioResidencia);
                            casoListado.setSgUF(rs2.getString("co_uf_notificacao"));
                            casoListado.setSgUFResidencia(rs2.getString("co_uf_residencia"));
                            casoListado.setAno(casoListado.getDtNotificacao().substring(6, 10));
                            this.getListagemCasosPQAVS().add(casoListado);
                        }
                        situacao = "N\u00e3o encerrado";
                        agravoBean.setQtdNaoEncerrado(agravoBean.getQtdNaoEncerrado() + 1);
                        agravoBean.setTotal(agravoBean.getTotal() + 1);
                    } else {
                        situacao = this.classificaNotificacao(rs2.getInt("diff"), 180, agravoBean, rs2.getInt("tp_classificacao_final"));
                        if (this.isTemListagem() && !situacao.equals("Oportuno") && !situacao.equals("Inoportuno com outras categorias")) {
                            casoListado.setAgravo(codCid);
                            casoListado.setDtNotificacao(this.formataData(((java.util.Date)dtNotificacao).toString()));
                            casoListado.setIdUnidade(rsIdUnidade);
                            casoListado.setNumNotificacao(rsNumeroNotificacao);
                            casoListado.setIdMunicipio(rsIdMunicipio);
                            casoListado.setNmMunicipio(rs2.getString("no_municipio"));
                            casoListado.setSituacao(situacao);
                            casoListado.setIdMunicipioResidencia(rsIdMunicipioResidencia);
                            casoListado.setSgUF(rs2.getString("co_uf_notificacao"));
                            casoListado.setSgUFResidencia(rs2.getString("co_uf_residencia"));
                            casoListado.setAno(casoListado.getDtNotificacao().substring(6, 10));
                            this.getListagemCasosPQAVS().add(casoListado);
                        }
                    }
                    String dtEncerramentoExportacao = dtEncerramento == null ? "" : this.formataData(((java.util.Date)dtEncerramento).toString());
                    this.populaBeanExportacaoDBF(situacao, codCid, rsIdMunicipio, rsIdMunicipioResidencia, this.formataData(((java.util.Date)dtNotificacao).toString()), rsNumeroNotificacao, rsIdUnidade, dtEncerramentoExportacao);
                }
            }
            if (!prosseguir) continue;
            int anoAvaliadoMalaria = Integer.parseInt(parametros.get("parDataInicio").toString().split("-")[0]);
            if (agravoSelecionado.equals("TODOS")) {
                stm2 = anoAvaliadoMalaria > 2008 ? con.prepareStatement(this.getSqlCalculoAgravosMalaria60dias() + " and co_municipio_residencia = ?  order by co_cid,tp_suspeita") : con.prepareStatement(this.getSqlCalculoAgravos60dias() + " and co_municipio_residencia = ?  order by co_cid,tp_suspeita");
            } else {
                if (anoAvaliadoMalaria == 2008 && agravoSelecionado.equals("B54")) {
                    Master.mensagem("Mal\u00e1ria est\u00e1 dispon\u00edvel a partir do ano de 2009");
                    return null;
                }
                stm2 = (agravoSelecionado = this.converteCodigoParaCompleto(agravoSelecionado)).equals("A90") ? con.prepareStatement(this.getSqlCalculoAgravoEspecifico() + " and tp_classificacao_final in(2,3,4) and co_municipio_residencia = ?  order by co_cid,tp_suspeita") : con.prepareStatement(this.getSqlCalculoAgravoEspecifico() + " and co_municipio_residencia = ?  order by co_cid,tp_suspeita");
            }
            stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
            stm2.setDate(2, this.transformaDate(parametros.get("parDataFim60").toString()));
            stm2.setString(3, parametros.get("parUf").toString());
            if (!agravoSelecionado.equals("TODOS")) {
                stm2.setString(4, agravoSelecionado);
                stm2.setString(5, municipio);
            } else {
                stm2.setString(4, municipio);
            }
            rs2 = stm2.executeQuery();
            while (rs2.next()) {
                codCid = rs2.getString("co_cid");
                if (codCid.equals("DOENCAS EXANTEMATICAS")) {
                    codCid = rs2.getInt("tp_suspeita") == 1 ? "SARAMPO" : "RUBEOLA";
                }
                casoListado = new CasoOportunidadePQAVS();
                Date dtEncerramento = rs2.getDate("dt_encerramento");
                Date dtNotificacao = rs2.getDate("dt_notificacao");
                codCid = rs2.getString("co_cid");
                rsIdMunicipio = rs2.getString("co_municipio_notificacao");
                rsIdMunicipioResidencia = rs2.getString("co_municipio_residencia");
                rsNumeroNotificacao = rs2.getString("nu_notificacao");
                rsIdUnidade = rs2.getString("co_unidade_notificacao");
                if (dtEncerramento == null) {
                    if (this.isTemListagem()) {
                        casoListado.setAgravo(codCid);
                        casoListado.setDtNotificacao(this.formataData(((java.util.Date)dtNotificacao).toString()));
                        casoListado.setIdUnidade(rsIdUnidade);
                        casoListado.setNumNotificacao(rsNumeroNotificacao);
                        casoListado.setIdMunicipio(rsIdMunicipio);
                        casoListado.setNmMunicipio(rs2.getString("no_municipio"));
                        casoListado.setSituacao("N\u00e3o Encerrado");
                        casoListado.setIdMunicipioResidencia(rsIdMunicipioResidencia);
                        casoListado.setSgUF(rs2.getString("co_uf_notificacao"));
                        casoListado.setSgUFResidencia(rs2.getString("co_uf_residencia"));
                        casoListado.setAno(casoListado.getDtNotificacao().substring(6, 10));
                        this.getListagemCasosPQAVS().add(casoListado);
                        situacao = "N\u00e3o Encerrado";
                    }
                    agravoBean.setQtdNaoEncerrado(agravoBean.getQtdNaoEncerrado() + 1);
                    agravoBean.setTotal(agravoBean.getTotal() + 1);
                } else {
                    situacao = this.classificaNotificacao(rs2.getInt("diff"), 60, agravoBean, rs2.getInt("tp_classificacao_final"));
                    if (this.isTemListagem() && !situacao.equals("Oportuno") && !situacao.equals("Inoportuno com outras categorias")) {
                        casoListado.setAgravo(codCid);
                        casoListado.setDtNotificacao(this.formataData(((java.util.Date)dtNotificacao).toString()));
                        casoListado.setIdUnidade(rsIdUnidade);
                        casoListado.setNumNotificacao(rsNumeroNotificacao);
                        casoListado.setIdMunicipio(rsIdMunicipio);
                        casoListado.setNmMunicipio(rs2.getString("no_municipio"));
                        casoListado.setSituacao(situacao);
                        casoListado.setIdMunicipioResidencia(rsIdMunicipioResidencia);
                        casoListado.setSgUF(rs2.getString("co_uf_notificacao"));
                        casoListado.setSgUFResidencia(rs2.getString("co_uf_residencia"));
                        casoListado.setAno(casoListado.getDtNotificacao().substring(6, 10));
                        this.getListagemCasosPQAVS().add(casoListado);
                    }
                }
                String dtEncerramentoExportacao = dtEncerramento == null ? "" : this.formataData(((java.util.Date)dtEncerramento).toString());
                this.populaBeanExportacaoDBF(situacao, codCid, rsIdMunicipio, rsIdMunicipioResidencia, this.formataData(((java.util.Date)dtNotificacao).toString()), rsNumeroNotificacao, rsIdUnidade, dtEncerramentoExportacao);
            }
        }
        this.getBarraStatus().setString(null);
        Collections.sort(beans, new BeanComparator("nmAgravo"));
        Collections.sort(this.getListagemCasos(), new BeanComparator("situacao"));
        Collections.sort(this.getListagemCasos(), new BeanComparator("nmMunicipio"));
        agravoBean = new OportunidadeAgravoPQAVS();
        agravoBean.setNmAgravo("TOTAL");
        for (int i = 0; i < beans.size(); ++i) {
            agravoBean.setQtdOportuno(((OportunidadeAgravoPQAVS)beans.get(i)).getQtdOportuno() + agravoBean.getQtdOportuno());
            agravoBean.setQtdInoportuno(((OportunidadeAgravoPQAVS)beans.get(i)).getQtdInoportuno() + agravoBean.getQtdInoportuno());
            agravoBean.setQtdInoportunoOutras(((OportunidadeAgravoPQAVS)beans.get(i)).getQtdInoportunoOutras() + agravoBean.getQtdInoportunoOutras());
            agravoBean.setQtdNaoEncerrado(((OportunidadeAgravoPQAVS)beans.get(i)).getQtdNaoEncerrado() + agravoBean.getQtdNaoEncerrado());
            agravoBean.setQtdDataInvalida(((OportunidadeAgravoPQAVS)beans.get(i)).getQtdDataInvalida() + agravoBean.getQtdDataInvalida());
            agravoBean.setTotal(((OportunidadeAgravoPQAVS)beans.get(i)).getTotal() + agravoBean.getTotal());
        }
        beans.add(agravoBean);
        return beans;
    }

    public List getCalculaResultado(Connection con, Map parametros) throws SQLException, ParseException {
        ResultSet rs2;
        PreparedStatement stm2;
        String agravoSelecionado;
        String situacao = "";
        String codCid = "";
        String rsIdMunicipio = "";
        String rsIdMunicipioResidencia = "";
        String rsNumeroNotificacao = "";
        String rsIdUnidade = "";
        String agravo = "";
        OportunidadeAgravoPQAVS agravoBean = null;
        ArrayList<OportunidadeAgravoPQAVS> beans = new ArrayList<OportunidadeAgravoPQAVS>();
        CasoOportunidadePQAVS casoListado = null;
        boolean prosseguir = true;
        if (parametros.get("parNomeMunicipio") == null) {
            parametros.put("parNomeMunicipio", "");
        }
        if (parametros.get("parNomeMunicipio").equals("TODOS")) {
            parametros.put("parNomeMunicipio", "Todos Munic\u00edpios");
        }
        if (parametros.get("parNomeMunicipio").toString().equals("Todos Munic\u00edpios")) {
            return this.getCalculaResultadoPorMunicipio(con, parametros);
        }
        String municipio = "";
        if (parametros.get("parMunicipio") != null) {
            municipio = " and co_municipio_residencia = ? ";
        }
        if ((agravoSelecionado = this.buscaCodigoAgravo(parametros.get("parAgravo").toString())).equals("")) {
            agravoSelecionado = "TODOS";
        }
        if (agravoSelecionado.equals("TODOS") || agravoSelecionado.equals("B19") || agravoSelecionado.equals("B551") || agravoSelecionado.equals("P350")) {
            String sql;
            if (agravoSelecionado.equals("TODOS")) {
                sql = this.getSqlCalculoAgravos180dias() + municipio + " order by co_cid,tp_suspeita";
            } else {
                sql = this.getSqlCalculoAgravoEspecifico() + municipio + " order by co_cid,tp_suspeita";
                agravoSelecionado = this.converteCodigoParaCompleto(agravoSelecionado);
                prosseguir = false;
            }
            stm2 = con.prepareStatement(sql);
            stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
            stm2.setDate(2, this.transformaDate(parametros.get("parDataFim180").toString()));
            stm2.setString(3, parametros.get("parUf").toString());
            if (!municipio.equals("")) {
                if (!agravoSelecionado.equals("TODOS")) {
                    stm2.setString(4, agravoSelecionado);
                    stm2.setString(5, parametros.get("parMunicipio").toString());
                } else {
                    stm2.setString(4, parametros.get("parMunicipio").toString());
                }
            } else if (!agravoSelecionado.equals("TODOS")) {
                stm2.setString(4, agravoSelecionado);
            }
            rs2 = stm2.executeQuery();
            while (rs2.next()) {
                codCid = rs2.getString("co_cid");
                if (!agravo.equals(codCid)) {
                    agravoBean = new OportunidadeAgravoPQAVS();
                    agravoBean.setNmAgravo(codCid);
                    beans.add(agravoBean);
                    agravo = codCid;
                }
                casoListado = new CasoOportunidadePQAVS();
                Date dtEncerramento = rs2.getDate("dt_encerramento");
                Date dtNotificacao = rs2.getDate("dt_notificacao");
                codCid = rs2.getString("co_cid");
                rsIdMunicipio = rs2.getString("co_municipio_notificacao");
                rsIdMunicipioResidencia = rs2.getString("co_municipio_residencia");
                rsNumeroNotificacao = rs2.getString("nu_notificacao");
                rsIdUnidade = rs2.getString("co_unidade_notificacao");
                if (dtEncerramento == null) {
                    if (this.isTemListagem()) {
                        casoListado.setAgravo(codCid);
                        casoListado.setDtNotificacao(this.formataData(((java.util.Date)dtNotificacao).toString()));
                        casoListado.setIdUnidade(rsIdUnidade);
                        casoListado.setNumNotificacao(rsNumeroNotificacao);
                        casoListado.setIdMunicipio(rsIdMunicipio);
                        casoListado.setNmMunicipio(rs2.getString("no_municipio"));
                        casoListado.setSituacao("N\u00e3o Encerrado");
                        casoListado.setIdMunicipioResidencia(rsIdMunicipioResidencia);
                        casoListado.setSgUF(rs2.getString("co_uf_notificacao"));
                        casoListado.setSgUFResidencia(rs2.getString("co_uf_residencia"));
                        casoListado.setAno(casoListado.getDtNotificacao().substring(6, 10));
                        this.getListagemCasosPQAVS().add(casoListado);
                    }
                    agravoBean.setQtdNaoEncerrado(agravoBean.getQtdNaoEncerrado() + 1);
                    agravoBean.setTotal(agravoBean.getTotal() + 1);
                } else {
                    situacao = this.classificaNotificacao(rs2.getInt("diff"), 180, agravoBean, rs2.getInt("tp_classificacao_final"));
                    if (this.isTemListagem() && !situacao.equals("Oportuno") && !situacao.equals("Inoportuno com outras categorias")) {
                        casoListado.setAgravo(codCid);
                        casoListado.setDtNotificacao(this.formataData(((java.util.Date)dtNotificacao).toString()));
                        casoListado.setIdUnidade(rsIdUnidade);
                        casoListado.setNumNotificacao(rsNumeroNotificacao);
                        casoListado.setIdMunicipio(rsIdMunicipio);
                        casoListado.setNmMunicipio(rs2.getString("no_municipio"));
                        casoListado.setSituacao(situacao);
                        casoListado.setIdMunicipioResidencia(rsIdMunicipioResidencia);
                        casoListado.setSgUF(rs2.getString("co_uf_notificacao"));
                        casoListado.setSgUFResidencia(rs2.getString("co_uf_residencia"));
                        casoListado.setAno(casoListado.getDtNotificacao().substring(6, 10));
                        this.getListagemCasosPQAVS().add(casoListado);
                    }
                }
                String dtEncerramentoExportacao = dtEncerramento == null ? "" : this.formataData(((java.util.Date)dtEncerramento).toString());
                this.populaBeanExportacaoDBF(situacao, codCid, rsIdMunicipio, rsIdMunicipioResidencia, this.formataData(((java.util.Date)dtNotificacao).toString()), rsNumeroNotificacao, rsIdUnidade, dtEncerramentoExportacao);
            }
        }
        if (prosseguir) {
            int anoAvaliadoMalaria = Integer.parseInt(parametros.get("parDataInicio").toString().split("-")[0]);
            if (agravoSelecionado.equals("TODOS")) {
                stm2 = anoAvaliadoMalaria > 2008 ? con.prepareStatement(this.getSqlCalculoAgravosMalaria60dias() + municipio + " order by co_cid,tp_suspeita") : con.prepareStatement(this.getSqlCalculoAgravos60dias() + municipio + " order by co_cid,tp_suspeita");
            } else {
                if (anoAvaliadoMalaria == 2008 && agravoSelecionado.equals("B54")) {
                    Master.mensagem("Mal\u00e1ria est\u00e1 dispon\u00edvel a partir do ano de 2009");
                    return null;
                }
                stm2 = (agravoSelecionado = this.converteCodigoParaCompleto(agravoSelecionado)).equals("A90") ? con.prepareStatement(this.getSqlCalculoAgravoEspecifico() + " and tp_classificacao_final in(2,3,4) order by co_cid,tp_suspeita") : con.prepareStatement(this.getSqlCalculoAgravoEspecifico() + municipio + " order by co_cid,tp_suspeita");
            }
            stm2.setDate(1, this.transformaDate(parametros.get("parDataInicio").toString()));
            stm2.setDate(2, this.transformaDate(parametros.get("parDataFim60").toString()));
            stm2.setString(3, parametros.get("parUf").toString());
            if (!municipio.equals("")) {
                if (!agravoSelecionado.equals("TODOS")) {
                    stm2.setString(4, agravoSelecionado);
                    stm2.setString(5, parametros.get("parMunicipio").toString());
                } else {
                    stm2.setString(4, parametros.get("parMunicipio").toString());
                }
            } else if (!agravoSelecionado.equals("TODOS")) {
                stm2.setString(4, agravoSelecionado);
            }
            rs2 = stm2.executeQuery();
            agravo = "";
            agravoBean = null;
            while (rs2.next()) {
                codCid = rs2.getString("co_cid");
                if (codCid.equals("DOENCAS EXANTEMATICAS")) {
                    codCid = rs2.getInt("tp_suspeita") == 1 ? "SARAMPO" : "RUBEOLA";
                }
                if (!agravo.equals(codCid)) {
                    agravoBean = new OportunidadeAgravoPQAVS();
                    agravoBean.setNmAgravo(codCid);
                    beans.add(agravoBean);
                    agravo = codCid;
                }
                casoListado = new CasoOportunidadePQAVS();
                Date dtEncerramento = rs2.getDate("dt_encerramento");
                Date dtNotificacao = rs2.getDate("dt_notificacao");
                codCid = rs2.getString("co_cid");
                rsIdMunicipio = rs2.getString("co_municipio_notificacao");
                rsIdMunicipioResidencia = rs2.getString("co_municipio_residencia");
                rsNumeroNotificacao = rs2.getString("nu_notificacao");
                rsIdUnidade = rs2.getString("co_unidade_notificacao");
                if (dtEncerramento == null) {
                    if (this.isTemListagem()) {
                        casoListado.setAgravo(codCid);
                        casoListado.setDtNotificacao(this.formataData(((java.util.Date)dtNotificacao).toString()));
                        casoListado.setIdUnidade(rsIdUnidade);
                        casoListado.setNumNotificacao(rsNumeroNotificacao);
                        casoListado.setIdMunicipio(rsIdMunicipio);
                        casoListado.setNmMunicipio(rs2.getString("no_municipio"));
                        casoListado.setSituacao("N\u00e3o Encerrado");
                        casoListado.setIdMunicipioResidencia(rsIdMunicipioResidencia);
                        casoListado.setSgUF(rs2.getString("co_uf_notificacao"));
                        casoListado.setSgUFResidencia(rs2.getString("co_uf_residencia"));
                        casoListado.setAno(casoListado.getDtNotificacao().substring(6, 10));
                        this.getListagemCasosPQAVS().add(casoListado);
                    }
                    agravoBean.setQtdNaoEncerrado(agravoBean.getQtdNaoEncerrado() + 1);
                    agravoBean.setTotal(agravoBean.getTotal() + 1);
                } else {
                    situacao = this.classificaNotificacao(rs2.getInt("diff"), 60, agravoBean, rs2.getInt("tp_classificacao_final"));
                    if (this.isTemListagem() && !situacao.equals("Oportuno") && !situacao.equals("Inoportuno com outras categorias")) {
                        casoListado.setAgravo(codCid);
                        casoListado.setDtNotificacao(this.formataData(((java.util.Date)dtNotificacao).toString()));
                        casoListado.setIdUnidade(rsIdUnidade);
                        casoListado.setNumNotificacao(rsNumeroNotificacao);
                        casoListado.setIdMunicipio(rsIdMunicipio);
                        casoListado.setNmMunicipio(rs2.getString("no_municipio"));
                        casoListado.setSituacao(situacao);
                        casoListado.setIdMunicipioResidencia(rsIdMunicipioResidencia);
                        casoListado.setAno(casoListado.getDtNotificacao().substring(6, 10));
                        casoListado.setSgUF(rs2.getString("co_uf_notificacao"));
                        casoListado.setSgUFResidencia(rs2.getString("co_uf_residencia"));
                        this.getListagemCasosPQAVS().add(casoListado);
                    }
                }
                String dtEncerramentoExportacao = dtEncerramento == null ? "" : this.formataData(((java.util.Date)dtEncerramento).toString());
                this.populaBeanExportacaoDBF(situacao, codCid, rsIdMunicipio, rsIdMunicipioResidencia, this.formataData(((java.util.Date)dtNotificacao).toString()), rsNumeroNotificacao, rsIdUnidade, dtEncerramentoExportacao);
            }
        }
        if (beans.size() == 0) {
            agravoBean = new OportunidadeAgravoPQAVS();
            agravoBean.setNmAgravo(this.buscaNomeAgravo(agravoSelecionado));
            beans.add(agravoBean);
        }
        agravoBean = new OportunidadeAgravoPQAVS();
        agravoBean.setNmAgravo("TOTAL");
        for (int i = 0; i < beans.size(); ++i) {
            agravoBean.setQtdOportuno(((OportunidadeAgravoPQAVS)beans.get(i)).getQtdOportuno() + agravoBean.getQtdOportuno());
            agravoBean.setQtdInoportuno(((OportunidadeAgravoPQAVS)beans.get(i)).getQtdInoportuno() + agravoBean.getQtdInoportuno());
            agravoBean.setQtdInoportunoOutras(((OportunidadeAgravoPQAVS)beans.get(i)).getQtdInoportunoOutras() + agravoBean.getQtdInoportunoOutras());
            agravoBean.setQtdNaoEncerrado(((OportunidadeAgravoPQAVS)beans.get(i)).getQtdNaoEncerrado() + agravoBean.getQtdNaoEncerrado());
            agravoBean.setQtdDataInvalida(((OportunidadeAgravoPQAVS)beans.get(i)).getQtdDataInvalida() + agravoBean.getQtdDataInvalida());
            agravoBean.setTotal(((OportunidadeAgravoPQAVS)beans.get(i)).getTotal() + agravoBean.getTotal());
        }
        beans.add(agravoBean);
        Collections.sort(beans, new BeanComparator("nmAgravo"));
        Collections.sort(this.getListagemCasos(), new BeanComparator("situacao"));
        Collections.sort(this.getListagemCasos(), new BeanComparator("nmMunicipio"));
        return beans;
    }

    @Override
    public List getBeansMunicipioEspecifico(Connection con, Map parametros) throws SQLException {
        return this.getBeanMunicipioEspecifico(con, parametros);
    }

    @Override
    public List getBeanMunicipioEspecifico(Connection con, Map parametros) throws SQLException {
        return this.getBeans();
    }

    @Override
    public List getBeansEstadoEspecifico(Connection con, Map parametros) throws SQLException {
        return this.getBeans();
    }

    @Override
    public Map getParametros() {
        String dataInicio = "";
        String dataFim60 = "";
        String dataFim180 = "";
        try {
            if (this.dtInicioAvaliacao != null) {
                dataInicio = this.retornaDataInicioNotificacao(this.dtInicioAvaliacao, this.dataAvaliacao);
                dataFim60 = this.retornaDataFimNotificacao(this.dtFimAvaliacao, this.dataAvaliacao, 60);
                dataFim180 = this.retornaDataFimNotificacao(this.dtFimAvaliacao, this.dataAvaliacao, 180);
            } else {
                dataInicio = this.retornaDataInicio(this.anoAvaliado, this.dataAvaliacao);
                dataFim60 = this.retornaDataFim(this.anoAvaliado, this.dataAvaliacao, 60);
                dataFim180 = this.retornaDataFim(this.anoAvaliado, this.dataAvaliacao, 180);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("parVersao", "");
        if (this.nomeAgravo.toString().equals("TODOS")) {
            parametros.put("parAgravo", "TODOS");
        } else {
            parametros.put("parAgravo", this.buscaCodigoAgravo(this.nomeAgravo.toString()));
        }
        if (this.dtInicioAvaliacao != null) {
            parametros.put("parAnoAvaliacao", this.dtInicioAvaliacao.toString() + " a " + this.dtFimAvaliacao.toString());
        } else {
            parametros.put("parAnoAvaliacao", this.anoAvaliado.toString());
        }
        parametros.put("parAnoAvaliacao", this.anoAvaliado.toString());
        parametros.put("parDataAvaliacao", this.dataAvaliacao);
        parametros.put("parDataInicio", Util.formataData(dataInicio));
        parametros.put("parDataFim60", Util.formataData(dataFim60));
        parametros.put("parDataFim180", Util.formataData(dataFim180));
        if (this.isPeriodoValido180dias() && this.isPeriodoValido60dias()) {
            parametros.put("parPeriodo", "\n    SRC, LTA e HEPATITES: de " + dataInicio + " a " + dataFim180 + "\n    Demais agravos de " + dataInicio + " a " + dataFim60);
            parametros.put("parPeriodo60", dataInicio + " a " + dataFim60);
        } else if (!this.isPeriodoValido180dias()) {
            parametros.put("parPeriodo", "\n    SRC, LTA e HEPATITES: intervalo insuficiente \n    Demais agravos de " + dataInicio + " a " + dataFim60);
            parametros.put("parPeriodo60", dataInicio + " a " + dataFim60);
        } else if (!this.isPeriodoValido60dias()) {
            parametros.put("parPeriodo", "\n    SRC, LTA e HEPATITES: intervalo insuficiente \n    Demais agravos: intervalo insuficiente ");
            parametros.put("parPeriodo60", " Intervalo insuficiente");
        }
        parametros.put("parTitulo1", "Propor\u00e7\u00e3o de Notifica\u00e7\u00f5es Segundo Oportunidade do Encerramento da Investiga\u00e7\u00e3o");
        parametros.put("parTituloColuna", "Coluna");
        parametros.put("parRodape", "Para a realiza\u00e7\u00e3o da avalia\u00e7\u00e3o da oportunidade do encerramento dos casos \u00e9 verificado o percentual de casos notificados que foram encerrados oportunamente, isto \u00e9, as fichas de investiga\u00e7\u00e3o que cont\u00e9m informa\u00e7\u00f5es do diagn\u00f3stico final e data do encerramento preenchidas, no prazo estabelecido para cada agravo.");
        parametros.put("parAno", Util.getAno(dataFim60));
        if (this.getUf().equals("Brasil")) {
            parametros.put("parUf", "brasil");
            parametros.put("parSgUf", "Todas UFs");
        }
        if (this.uf.equals("Brasil")) {
            parametros.put("parTituloColuna", "Agravo");
        } else if (this.municipio.isEmpty()) {
            parametros.put("parTituloColuna", "Agravo");
        } else if (this.municipio.equals("Todos Munic\u00edpios")) {
            parametros.put("parTituloColuna", "Munic\u00edpio");
        } else {
            parametros.put("parTituloColuna", "Agravo");
        }
        parametros.put("parAgravo", this.nomeAgravo);
        return parametros;
    }

    private String retornaDataInicio(String anoAvaliado, String dataAvaliacao) throws ParseException {
        String anoAvaliacao = dataAvaliacao.split("/")[2];
        SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy");
        Date dataInicio = new Date(fmt.parse("01/01/" + anoAvaliacao).getTime());
        Date dataFim = new Date(fmt.parse(dataAvaliacao).getTime());
        if (anoAvaliacao.equals(anoAvaliado)) {
            if (Agravo.dataDiff(dataInicio, dataFim) > 60) {
                return fmt.format(dataInicio).toString();
            }
        } else {
            return "01/01/" + anoAvaliado;
        }
        Master.mensagem("O intervalo entre data de avalia\u00e7\u00e3o e ano/per\u00edodo avaliado \u00e9 insuficiente para avaliar agravos cujo prazo de encerramento oportuno \u00e9 de 60 dias");
        this.setPeriodoValido60dias(false);
        return null;
    }

    private String retornaDataFim(String ano, String dataAvaliacao, int intervalo) throws ParseException {
        SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy");
        Calendar calendarData = Calendar.getInstance();
        Date dataFim = new Date(fmt.parse(dataAvaliacao).getTime());
        calendarData.setTime(dataFim);
        calendarData.add(5, -intervalo);
        java.util.Date dataFim2 = calendarData.getTime();
        if (ano.equals(dataAvaliacao.split("/")[2])) {
            return fmt.format(dataFim2).toString();
        }
        Date dataParametro = new Date(fmt.parse("31/12/" + ano).getTime());
        if (dataFim2.before(dataParametro)) {
            return fmt.format(dataFim2).toString();
        }
        return "31/12/" + ano;
    }

    private String retornaDataInicioNotificacao(String dtInicioNotificacao, String dataAvaliacao) throws ParseException {
        Date dataFim;
        SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy");
        Date dataInicio = new Date(fmt.parse(dtInicioNotificacao).getTime());
        if (Agravo.dataDiff(dataInicio, dataFim = new Date(fmt.parse(dataAvaliacao).getTime())) > 60) {
            return fmt.format(dataInicio).toString();
        }
        Master.mensagem("O intervalo entre data de avalia\u00e7\u00e3o e ano/per\u00edodo avaliado \u00e9 insuficiente para avaliar agravos cujo prazo de encerramento oportuno \u00e9 de 60 dias");
        this.setPeriodoValido60dias(false);
        return null;
    }

    private String retornaDataFimNotificacao(String dtFimNotificacao, String dataAvaliacao, int intervalo) throws ParseException {
        SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy");
        Calendar calendarData = Calendar.getInstance();
        Date dataFim = new Date(fmt.parse(dataAvaliacao).getTime());
        calendarData.setTime(dataFim);
        calendarData.add(5, -intervalo);
        java.util.Date dataFim2 = calendarData.getTime();
        Date dataParametro = new Date(fmt.parse(dtFimNotificacao).getTime());
        if (dataFim2.before(dataParametro)) {
            return fmt.format(dataFim2).toString();
        }
        return dtFimNotificacao;
    }

    public String buscaCodigoAgravo(String nomeAgravo) {
        String retorno = "";
        if (nomeAgravo.equals("ANTRAZ PNEUMONICO")) {
            retorno = "A229";
        }
        if (nomeAgravo.equals("ARENAVIRUS")) {
            retorno = "A969";
        }
        if (nomeAgravo.equals("BOTULISMO")) {
            retorno = "A051";
        }
        if (nomeAgravo.equals("COLERA")) {
            retorno = "A009";
        }
        if (nomeAgravo.equals("DENGUE (OBITOS)")) {
            retorno = "A90";
        }
        if (nomeAgravo.equals("EBOLA")) {
            retorno = "A984";
        }
        if (nomeAgravo.equals("EVENTOS ADVERSOS GRAVES OU OBITOS POS-VACINACAO")) {
            retorno = "Y59";
        }
        if (nomeAgravo.equals("FEBRE AMARELA")) {
            retorno = "A959";
        }
        if (nomeAgravo.equals("FEBRE DE CHIKUNGUNYA")) {
            retorno = "A920";
        }
        if (nomeAgravo.equals("FEBRE DO NILO OCIDENTAL")) {
            retorno = "A923";
        }
        if (nomeAgravo.equals("FEBRE MACULOSA E OUTRAS RIQUETISIOSES")) {
            retorno = "A779";
        }
        if (nomeAgravo.equals("FEBRE PURPURICA BRASILEIRA")) {
            retorno = "A484";
        }
        if (nomeAgravo.equals("INFLUENZA HUMANA PRODUZIDA POR NOVO SUBTIPO VIRAL")) {
            retorno = "J11";
        }
        if (nomeAgravo.equals("LASSA")) {
            retorno = "A962";
        }
        if (nomeAgravo.equals("MALARIA NA REGIAO EXTRA AMAZONICA")) {
            retorno = "B54";
        }
        if (nomeAgravo.equals("MARBURG")) {
            retorno = "A983";
        }
        if (nomeAgravo.equals("PARALISIA FLACIDA AGUDA")) {
            retorno = "A809";
        }
        if (nomeAgravo.equals("PESTE")) {
            retorno = "A209";
        }
        if (nomeAgravo.equals("RAIVA HUMANA")) {
            retorno = "A829";
        }
        if (nomeAgravo.equals("RUBEOLA")) {
            retorno = "B092";
        }
        if (nomeAgravo.equals("SARAMPO")) {
            retorno = "B091";
        }
        if (nomeAgravo.equals("SINDROME DA RUBEOLA CONGENITA")) {
            retorno = "P350";
        }
        if (nomeAgravo.equals("SINDROME RESPIRAT. AGUDA GRAVE ASSOC. A CORONAVIRUS")) {
            retorno = "U049";
        }
        if (nomeAgravo.equals("TULAREMIA")) {
            retorno = "A219";
        }
        if (nomeAgravo.equals("VARIOLA")) {
            retorno = "B03";
        }
        return retorno;
    }

    public boolean isPeriodoValido180dias() {
        return this.periodoValido180dias;
    }

    public void setPeriodoValido180dias(boolean periodoValido180dias) {
        this.periodoValido180dias = periodoValido180dias;
    }

    public boolean isPeriodoValido60dias() {
        return this.periodoValido60dias;
    }

    public void setPeriodoValido60dias(boolean periodoValido60dias) {
        this.periodoValido60dias = periodoValido60dias;
    }

    @Override
    public String getDataAvaliacao() {
        return this.dataAvaliacao;
    }

    @Override
    public void setDataAvaliacao(String dataAvaliacao) {
        this.dataAvaliacao = dataAvaliacao;
    }

    @Override
    public String getAnoAvaliado() {
        return this.anoAvaliado;
    }

    @Override
    public void setAnoAvaliado(String anoAvaliado) {
        this.anoAvaliado = anoAvaliado;
    }

    @Override
    public String getDtInicioAvaliacao() {
        return this.dtInicioAvaliacao;
    }

    @Override
    public void setDtInicioAvaliacao(String dtInicioAvaliacao) {
        this.dtInicioAvaliacao = dtInicioAvaliacao;
    }

    @Override
    public String getDtFimAvaliacao() {
        return this.dtFimAvaliacao;
    }

    @Override
    public void setDtFimAvaliacao(String dtFimAvaliacao) {
        this.dtFimAvaliacao = dtFimAvaliacao;
    }

    @Override
    public String getNomeAgravo() {
        return this.nomeAgravo;
    }

    @Override
    public void setNomeAgravo(String nomeAgravo) {
        this.nomeAgravo = nomeAgravo;
    }

    @Override
    public String getUf() {
        return this.uf;
    }

    @Override
    public void setUf(String uf) {
        this.uf = uf;
    }

    @Override
    public String getMunicipio() {
        return this.municipio;
    }

    @Override
    public void setMunicipio(String municipio) {
        this.municipio = municipio;
    }

    @Override
    public HashMap<String, ColunasDbf> getColunas() {
        HashMap<String, ColunasDbf> hashColunas = new HashMap<String, ColunasDbf>();
        if (this.isPorAgravo()) {
            hashColunas.put("ID_AGRAVO", new ColunasDbf(5));
            hashColunas.put("DS_AGRAVO", new ColunasDbf(30));
        } else {
            hashColunas.put("ID_LOCRES", new ColunasDbf(7));
            hashColunas.put("DS_LOCRES", new ColunasDbf(30));
            hashColunas.put("ID_UFRES", new ColunasDbf(2));
        }
        hashColunas.put("NUM_NENC", new ColunasDbf(10, 0));
        hashColunas.put("PER_NENC", new ColunasDbf(5, 2));
        hashColunas.put("NUM_INOIN", new ColunasDbf(10, 0));
        hashColunas.put("PER_INOIN", new ColunasDbf(5, 2));
        hashColunas.put("NUM_INOOT", new ColunasDbf(10, 0));
        hashColunas.put("PER_INOOT", new ColunasDbf(5, 2));
        hashColunas.put("N_ENCOPOR", new ColunasDbf(10, 0));
        hashColunas.put("I_ENCOPOR", new ColunasDbf(5, 2));
        hashColunas.put("NUM_DTINV", new ColunasDbf(10, 0));
        hashColunas.put("PER_DTINV", new ColunasDbf(5, 2));
        hashColunas.put("D_ENCOPOR", new ColunasDbf(10, 0));
        hashColunas.put("ANO_NOTIF", new ColunasDbf(4, 0));
        hashColunas.put("DT_AVALIA", new ColunasDbf(10));
        hashColunas.put("ORIGEM", new ColunasDbf(30));
        this.setColunas(hashColunas);
        return hashColunas;
    }

    @Override
    public String[] getOrdemColunas() {
        if (this.isPorAgravo()) {
            return new String[]{"ID_AGRAVO", "DS_AGRAVO", "NUM_NENC", "PER_NENC", "NUM_INOIN", "PER_INOIN", "NUM_INOOT", "PER_INOOT", "N_ENCOPOR", "I_ENCOPOR", "NUM_DTINV", "PER_DTINV", "D_ENCOPOR", "ANO_NOTIF", "DT_AVALIA", "ORIGEM"};
        }
        return new String[]{"ID_LOCRES", "DS_LOCRES", "ID_UFRES", "NUM_NENC", "PER_NENC", "NUM_INOIN", "PER_INOIN", "NUM_INOOT", "PER_INOOT", "N_ENCOPOR", "I_ENCOPOR", "NUM_DTINV", "PER_DTINV", "D_ENCOPOR", "ANO_NOTIF", "DT_AVALIA", "ORIGEM"};
    }

    @Override
    public DBFWriter getLinhas(HashMap<String, ColunasDbf> colunas, List bean, DBFWriter writer) throws DBFException, IOException {
        for (int i = 0; i < bean.size(); ++i) {
            int k;
            Object[] rowData = new Object[colunas.size()];
            OportunidadeAgravoPQAVS agravo = (OportunidadeAgravoPQAVS)bean.get(i);
            if (this.isPorAgravo()) {
                rowData[0] = agravo.getCodAgravo() == null ? null : agravo.getCodAgravo();
                k = 2;
            } else {
                if (agravo.getCodAgravo() == null) {
                    rowData[0] = SinanUtil.siglaUFToIDUF(agravo.getNmAgravo());
                    rowData[2] = SinanUtil.siglaUFToIDUF(agravo.getNmAgravo());
                } else {
                    rowData[0] = agravo.getCodAgravo();
                    rowData[2] = agravo.getCodAgravo().substring(0, 2);
                }
                k = 3;
            }
            rowData[1] = agravo.getNmAgravo();
            rowData[k] = Double.parseDouble(agravo.getQtdNaoEncerrado().toString());
            rowData[++k] = Double.parseDouble(this.calculaPercentual(agravo.getQtdNaoEncerrado().toString(), agravo.getTotal().toString()));
            rowData[++k] = Double.parseDouble(agravo.getQtdInoportuno().toString());
            rowData[++k] = Double.parseDouble(this.calculaPercentual(agravo.getQtdInoportuno().toString(), agravo.getTotal().toString()));
            rowData[++k] = Double.parseDouble(agravo.getQtdInoportunoOutras().toString());
            rowData[++k] = Double.parseDouble(this.calculaPercentual(agravo.getQtdInoportunoOutras().toString(), agravo.getTotal().toString()));
            rowData[++k] = Double.parseDouble(agravo.getQtdOportuno().toString());
            rowData[++k] = Double.parseDouble(this.calculaPercentual(agravo.getQtdOportuno().toString(), agravo.getTotal().toString()));
            rowData[++k] = Double.parseDouble(agravo.getQtdDataInvalida().toString());
            rowData[++k] = Double.parseDouble(this.calculaPercentual(agravo.getQtdDataInvalida().toString(), agravo.getTotal().toString()));
            ++k;
            if (agravo.getTotal() != null) {
                rowData[k] = Double.parseDouble(agravo.getTotal().toString());
                ++k;
            } else {
                rowData[k] = Double.parseDouble("0");
                ++k;
            }
            rowData[k] = Double.parseDouble(this.getAnoAvaliado());
            rowData[++k] = this.getDataAvaliacao();
            rowData[++k] = "ENCOPORTUNO-SINANNET";
            writer.addRecord(rowData);
        }
        return writer;
    }

    public String calculaPercentual(String num, String den) {
        double numd = Double.parseDouble(num);
        double dend = Double.parseDouble(den);
        DecimalFormat df = new DecimalFormat("0.00");
        if (dend > 0.0) {
            return df.format(numd / dend * 100.0).replace(",", ".");
        }
        return "0.0";
    }

    @Override
    public String getCaminhoJasper() {
        return "/com/org/relatorios/oportunidadePQAVS.jasper";
    }

    @Override
    public String getTaxaEstado(Connection con, Map parametros) throws SQLException {
        if (this.isDBF()) {
            DBFReader reader = null;
            this.calcula(reader, parametros);
            return this.getTaxaEstadual();
        }
        try {
            this.setBeans(this.getCalculaResultado(con, parametros));
        }
        catch (ParseException ex) {
            System.out.println(ex);
        }
        return this.getTaxaEstadual();
    }

    public String getSqlCalculoAgravos180dias() {
        return this.sqlCalculoAgravos180dias;
    }

    public void setSqlCalculoAgravos180dias(String sqlCalculoAgravos180dias) {
        this.sqlCalculoAgravos180dias = sqlCalculoAgravos180dias;
    }

    public String getSqlCalculoAgravos60dias() {
        return this.sqlCalculoAgravos60dias;
    }

    public void setSqlCalculoAgravos60dias(String sqlCalculoAgravos60dias) {
        this.sqlCalculoAgravos60dias = sqlCalculoAgravos60dias;
    }

    public String getSqlCalculoAgravosMalaria60dias() {
        return this.sqlCalculoAgravosMalaria60dias;
    }

    public void setSqlCalculoAgravosMalaria60dias(String sqlCalculoAgravosMalaria60dias) {
        this.sqlCalculoAgravosMalaria60dias = sqlCalculoAgravosMalaria60dias;
    }

    public String getSqlCalculoAgravoEspecifico() {
        return this.sqlCalculoAgravoEspecifico;
    }

    public void setSqlCalculoAgravoEspecifico(String sqlCalculoAgravoEspecifico) {
        this.sqlCalculoAgravoEspecifico = sqlCalculoAgravoEspecifico;
    }

    public List<String> getAgravosValidos() {
        return this.agravosValidos;
    }

    public void setAgravosValidos(List<String> agravosValidos) {
        this.agravosValidos = agravosValidos;
    }

    public List<Municipio> getMunicipios() {
        return this.municipios;
    }

    public void setMunicipios(List<Municipio> municipios) {
        this.municipios = municipios;
    }

    public boolean isPorAgravo() {
        return this.porAgravo;
    }

    public void setPorAgravo(boolean porAgravo) {
        this.porAgravo = porAgravo;
    }
}

