/*
 * Decompiled with CFR 0.152.
 */
package com.org.model.classes.agravos;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import com.org.bd.DBFUtil;
import com.org.model.classes.Agravo;
import com.org.model.classes.ColunasDbf;
import com.org.negocio.Util;
import com.org.view.Master;
import java.io.IOException;
import java.sql.Date;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;

public class PFA15anos
extends Agravo {
    static String ANO;

    public PFA15anos(boolean isDbf) {
        this.setDBF(isDbf);
        this.setPeriodo("de notifica\u00e7\u00e3o");
        this.setTipoAgregacao("de Resid\u00eancia");
        this.init("postgres");
    }

    @Override
    public void init(String tipoBanco) {
        this.setArquivo("PFANET");
        this.setTextoCompletitude("");
        this.setMultiplicador(100000);
        this.setTipo("populacao");
        this.setTitulo1("Taxa de notifica\u00e7\u00e3o de casos de paralisia fl\u00e1cida aguda \u2013 PFA em menores de 15 anos ");
        this.setTituloColuna("Taxa de Notifica\u00e7\u00e3o por 100.000");
        this.setRodape("Numerador: N\u00famero de casos de PFA em menores de 15 anos, residentes em determinado local, com in\u00edcio da defici\u00eancia motora em determinado ano \nDenominador: Total da popula\u00e7\u00e3o menor de 15 anos residentes em determinado local no mesmo ano de in\u00edcio da defici\u00eancia motora");
        this.setSqlNumeradorCompletitude("");
        if (!this.isDBF()) {
            this.setSqlNumeradorMunicipioEspecifico("select count(*) as numerador from dbsinan.tb_notificacao as t1 inner join dbsinan.tb_investiga_pfa t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao)where t1.co_cid = 'A80.9' and nu_idade < 4015 and (t2.dt_deficiencia BETWEEN ?  AND ?) and t1.co_uf_residencia= ? and t1.co_municipio_residencia = ?");
            this.setSqlDenominadorMunicipioEspecifico("select nu_pop1a4anos+nu_pop1ano+nu_pop5a9anos+nu_pop10a14anos as denominador from dblocalidade.tb_estatistica_ibge where co_uf_municipio_ibge = ? and nu_ano = ?");
            this.setSqlNumeradorEstado("select count(*) as numerador from dbsinan.tb_notificacao as t1 inner join dbsinan.tb_investiga_pfa t2 on (t1.nu_notificacao=t2.nu_notificacao and t1.dt_notificacao=t2.dt_notificacao and t1.co_municipio_notificacao=t2.co_municipio_notificacao)where t1.co_cid = 'A80.9' and nu_idade < 4015 and (t2.dt_deficiencia BETWEEN ?  AND ?) and t1.co_uf_residencia= ? ");
            this.setSqlDenominandorEstado(this.getSqlDenominadorMunicipioEspecifico());
            this.setSqlNumeradorBeanMunicipios(this.getSqlNumeradorMunicipioEspecifico());
            this.setSqlDenominadorBeanMunicipios(this.getSqlDenominadorMunicipioEspecifico());
        }
    }

    private void calculaBrasil(DBFReader reader, Map parametros) throws ParseException {
        String coluna;
        HashMap<Object, Object> municipiosBeans = new HashMap();
        DBFUtil utilDbf = new DBFUtil();
        if (parametros.get("municipios").toString().equals("sim")) {
            municipiosBeans = this.populaMunicipiosBeans("BR", "");
            coluna = "ID_MN_RESI";
        } else {
            municipiosBeans = this.populaUfsBeans();
            coluna = "SG_UF";
        }
        int completitude = 0;
        DecimalFormat df = new DecimalFormat("0.00");
        int numerador = 0;
        int numeradorEstadual = 0;
        int denominadorEstadual = 0;
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim = (String)parametros.get("parDataFim");
        int i = 1;
        try {
            Object[] rowObjects;
            utilDbf.mapearPosicoes(reader);
            double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
            while ((rowObjects = reader.nextRecord()) != null) {
                if (utilDbf.getString(rowObjects, coluna) != null) {
                    Agravo municipioResidencia = (Agravo)municipiosBeans.get(utilDbf.getString(rowObjects, coluna));
                    Date dtInicioDeficiencia = utilDbf.getDate(rowObjects, "CLI_DT");
                    int idade = Integer.parseInt(utilDbf.getString(rowObjects, "NU_IDADE_N", 4));
                    if (municipioResidencia != null) {
                        if (this.isBetweenDates(dtInicioDeficiencia, dataInicio, dataFim) && idade < 4015 && idade > 0) {
                            numerador = Integer.parseInt(municipioResidencia.getNumerador());
                            municipioResidencia.setNumerador(String.valueOf(++numerador));
                            ++numeradorEstadual;
                        }
                    } else if (this.isBetweenDates(dtInicioDeficiencia, dataInicio, dataFim) && idade < 4015 && idade > 0) {
                        ++numeradorEstadual;
                    }
                }
                float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                this.getBarraStatus().setValue((int)percentual);
                ++i;
            }
        }
        catch (DBFException ex) {
            Master.mensagem("Erro:\n" + (Object)((Object)ex));
        }
        String ano = dataInicio.substring(0, 4);
        this.setTaxaEstadual("");
        this.setPercentualCompletitude(df.format(Double.parseDouble(String.valueOf(completitude)) / Double.parseDouble(String.valueOf(denominadorEstadual)) * 100.0));
        this.setBeans(new ArrayList());
        Collection<Object> municipioBean = municipiosBeans.values();
        for (Agravo agravo : municipioBean) {
            double num = Double.parseDouble(agravo.getNumerador());
            try {
                agravo.setDenominador(String.valueOf(this.getPopulacao(agravo.getCodMunicipio().toString(), 15, ano)));
            }
            catch (DBFException ex) {
                System.out.println((Object)ex);
            }
            double den = Double.parseDouble(agravo.getDenominador());
            if (den == 0.0) {
                agravo.setTaxa("0.00");
            } else {
                agravo.setTaxa(df.format(num / den * 100000.0));
            }
            this.getBeans().add(agravo);
            this.getBarraStatus().setString("Buscando pop. de: " + agravo.getNomeMunicipio());
        }
        this.getBarraStatus().setString(null);
        Collections.sort(this.getBeans(), new BeanComparator("nomeMunicipio"));
        this.getBeans().add(this.adicionaBrasil(municipioBean));
        if (!parametros.get("parSgUf").toString().equals("TODAS") && !parametros.get("municipios").toString().equals("sim")) {
            Agravo agravoBrasil = (Agravo)this.getBeans().get(27);
            ArrayList<Agravo> arrayList = new ArrayList<Agravo>();
            arrayList.add(agravoBrasil);
            this.setBeans(arrayList);
        }
    }

    private void calculaMunicipios(DBFReader reader, Map parametros) throws ParseException, DBFException {
        HashMap<Object, Object> municipiosBeans = new HashMap();
        String ufResidencia = (String)parametros.get("parUf");
        String sgUfResidencia = (String)parametros.get("parSgUf");
        String codRegional = (String)parametros.get("parCodRegional");
        DBFUtil utilDbf = new DBFUtil();
        municipiosBeans = this.populaMunicipiosBeans(sgUfResidencia, codRegional);
        int completitude = 0;
        DecimalFormat df = new DecimalFormat("0.00");
        int numerador = 0;
        int numeradorEstadual = 0;
        int denominadorEstadual = 0;
        String dataInicio = (String)parametros.get("parDataInicio");
        String dataFim = (String)parametros.get("parDataFim");
        int i = 1;
        try {
            Object[] rowObjects;
            utilDbf.mapearPosicoes(reader);
            double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
            while ((rowObjects = reader.nextRecord()) != null) {
                if (utilDbf.getString(rowObjects, "SG_UF") != null) {
                    Agravo municipioResidencia = (Agravo)municipiosBeans.get(utilDbf.getString(rowObjects, "ID_MN_RESI"));
                    Date dtInicioDeficiencia = utilDbf.getDate(rowObjects, "CLI_DT");
                    int idade = Integer.parseInt(utilDbf.getString(rowObjects, "NU_IDADE_N", 4));
                    if (municipioResidencia != null) {
                        if (this.isBetweenDates(dtInicioDeficiencia, dataInicio, dataFim) && idade < 4015 && idade > 0) {
                            numerador = Integer.parseInt(municipioResidencia.getNumerador());
                            municipioResidencia.setNumerador(String.valueOf(++numerador));
                            ++numeradorEstadual;
                        }
                    } else if (this.isBetweenDates(dtInicioDeficiencia, dataInicio, dataFim) && idade < 4015 && idade > 0) {
                        ++numeradorEstadual;
                    }
                }
                float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                this.getBarraStatus().setValue((int)percentual);
                ++i;
            }
        }
        catch (DBFException ex) {
            Master.mensagem("Erro:\n" + (Object)((Object)ex));
        }
        String ano = dataInicio.substring(0, 4);
        denominadorEstadual = this.getPopulacao(ufResidencia, 15, ano);
        String total = df.format(Double.parseDouble(String.valueOf(numeradorEstadual)) / Double.parseDouble(String.valueOf(denominadorEstadual)) * 100000.0);
        this.setTaxaEstadual(total + " (Numerador:" + String.valueOf(numeradorEstadual) + " / Denominador: " + String.valueOf(denominadorEstadual) + ")");
        this.setPercentualCompletitude(df.format(Double.parseDouble(String.valueOf(completitude)) / Double.parseDouble(String.valueOf(denominadorEstadual)) * 100.0));
        this.setBeans(new ArrayList());
        Collection<Object> municipioBean = municipiosBeans.values();
        for (Agravo agravo : municipioBean) {
            double num = Double.parseDouble(agravo.getNumerador());
            agravo.setDenominador(String.valueOf(this.getPopulacao(agravo.getCodMunicipio().toString(), 15, ano)));
            double den = Double.parseDouble(agravo.getDenominador());
            if (den == 0.0) {
                agravo.setTaxa("0.00");
            } else {
                agravo.setTaxa(df.format(num / den * 100000.0));
            }
            this.getBeans().add(agravo);
            this.getBarraStatus().setString("Buscando pop. de: " + agravo.getNomeMunicipio());
        }
        this.getBarraStatus().setString(null);
        Collections.sort(this.getBeans(), new BeanComparator("nomeMunicipio"));
        if (codRegional.length() == 0) {
            this.getBeans().add(this.adicionaTotal(municipioBean, codRegional));
        }
    }

    @Override
    public void calcula(DBFReader reader, Map parametros) {
        String municipios = (String)parametros.get("municipios");
        String brasil = (String)parametros.get("parUf");
        if (municipios.equals("sim") && !brasil.equals("brasil")) {
            try {
                try {
                    this.calculaMunicipios(reader, parametros);
                }
                catch (DBFException ex) {
                    System.out.println((Object)ex);
                }
            }
            catch (ParseException ex) {
                System.out.println(ex);
            }
        } else {
            try {
                if (brasil.equals("brasil")) {
                    this.calculaBrasil(reader, parametros);
                } else {
                    Object[] rowObjects;
                    DBFUtil utilDbf = new DBFUtil();
                    int completitude = 0;
                    DecimalFormat df = new DecimalFormat("0.00");
                    int denominadorEstadual = 0;
                    int numeradorEstadual = 0;
                    int denominadorEspecifico = 0;
                    int numeradorEspecifico = 0;
                    String ufResidencia = (String)parametros.get("parUf");
                    String municipioResidencia = (String)parametros.get("parMunicipio");
                    if (municipioResidencia == null) {
                        municipioResidencia = "";
                    }
                    String dataInicio = (String)parametros.get("parDataInicio");
                    String dataFim = (String)parametros.get("parDataFim");
                    int i = 1;
                    utilDbf.mapearPosicoes(reader);
                    double TotalRegistros = Double.parseDouble(String.valueOf(reader.getRecordCount()));
                    while ((rowObjects = reader.nextRecord()) != null) {
                        if (utilDbf.getString(rowObjects, "SG_UF") != null && utilDbf.getString(rowObjects, "SG_UF").equals(ufResidencia)) {
                            Date dtInicioDeficiencia = utilDbf.getDate(rowObjects, "CLI_DT");
                            int idade = Integer.parseInt(utilDbf.getString(rowObjects, "NU_IDADE_N", 4));
                            if (this.verificaMunicipio(municipioResidencia, utilDbf.getString(rowObjects, "ID_MN_RESI"))) {
                                if (this.isBetweenDates(dtInicioDeficiencia, dataInicio, dataFim) && idade < 4015 && idade > 0) {
                                    ++numeradorEspecifico;
                                    ++numeradorEstadual;
                                }
                            } else if (this.isBetweenDates(dtInicioDeficiencia, dataInicio, dataFim) && idade < 4015 && idade > 0) {
                                ++numeradorEstadual;
                            }
                        }
                        float percentual = Float.parseFloat(String.valueOf(i)) / Float.parseFloat(String.valueOf(TotalRegistros)) * 100.0f;
                        this.getBarraStatus().setValue((int)percentual);
                        ++i;
                    }
                    String ano = dataInicio.substring(0, 4);
                    denominadorEstadual = this.getPopulacao(ufResidencia, 15, ano);
                    denominadorEspecifico = municipioResidencia.length() == 0 ? denominadorEstadual : this.getPopulacao(municipioResidencia, 15, ano);
                    String total = df.format(Double.parseDouble(String.valueOf(numeradorEstadual)) / Double.parseDouble(String.valueOf(denominadorEstadual)) * 100000.0);
                    this.setTaxaEstadual(total + " (Numerador:" + String.valueOf(numeradorEstadual) + " / Denominador: " + String.valueOf(denominadorEstadual) + ")");
                    this.setPercentualCompletitude(df.format(Double.parseDouble(String.valueOf(completitude)) / Double.parseDouble(String.valueOf(denominadorEstadual)) * 100000.0));
                    Agravo d1 = new Agravo();
                    d1.setCodMunicipio((String)parametros.get("parMunicipio"));
                    if (municipioResidencia.equals("")) {
                        d1.setNomeMunicipio((String)parametros.get("parSgUf"));
                    } else {
                        d1.setNomeMunicipio((String)parametros.get("parNomeMunicipio"));
                    }
                    if (!String.valueOf(denominadorEspecifico).equals("0.0")) {
                        d1.setNumerador(String.valueOf(NumberFormat.getNumberInstance().format(Double.parseDouble(String.valueOf(numeradorEspecifico)))));
                        d1.setDenominador(String.valueOf(NumberFormat.getNumberInstance().format(Double.parseDouble(String.valueOf(denominadorEspecifico)))));
                        total = df.format(Double.parseDouble(String.valueOf(numeradorEspecifico)) / Double.parseDouble(String.valueOf(denominadorEspecifico)) * 100000.0);
                        d1.setTaxa(total);
                    } else {
                        d1.setNumerador("0");
                        d1.setDenominador("0");
                        d1.setTaxa("0.00");
                    }
                    this.setBeans(new ArrayList());
                    this.getBeans().add(d1);
                }
            }
            catch (NumberFormatException ex) {
                System.out.println(ex);
            }
            catch (ParseException ex) {
                System.out.println(ex);
            }
            catch (DBFException ex) {
                System.out.println((Object)ex);
            }
        }
    }

    @Override
    public String[] getOrdemColunas() {
        return new String[]{"ID_LOCRES", "DS_LOCRES", "ID_UFRES", "N_TNOTPFA", "D_TNOTPFA", "I_TNOTPFA", "ANO_NOTIF", "DT_NOTINI", "DT_NOTFIN", "ORIGEM"};
    }

    @Override
    public HashMap<String, ColunasDbf> getColunas() {
        HashMap<String, ColunasDbf> hashColunas = new HashMap<String, ColunasDbf>();
        hashColunas.put("ID_LOCRES", new ColunasDbf(7));
        hashColunas.put("DS_LOCRES", new ColunasDbf(30));
        hashColunas.put("ID_UFRES", new ColunasDbf(2));
        hashColunas.put("N_TNOTPFA", new ColunasDbf(10, 0));
        hashColunas.put("D_TNOTPFA", new ColunasDbf(10, 0));
        hashColunas.put("I_TNOTPFA", new ColunasDbf(6, 2));
        hashColunas.put("ANO_NOTIF", new ColunasDbf(4, 0));
        hashColunas.put("DT_NOTINI", new ColunasDbf(10));
        hashColunas.put("DT_NOTFIN", new ColunasDbf(10));
        hashColunas.put("ORIGEM", new ColunasDbf(30));
        this.setColunas(hashColunas);
        return hashColunas;
    }

    @Override
    public Map getParametros() {
        Util util = new Util();
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("parDataInicio", Util.formataData(this.getDataInicio()));
        parametros.put("parDataFim", Util.formataData(this.getDataFim()));
        parametros.put("parPeriodo", "de " + this.getDataInicio() + " a " + this.getDataFim());
        parametros.put("parTituloColuna", this.getTituloColuna());
        parametros.put("parFator", String.valueOf(this.getMultiplicador()));
        parametros.put("parAno", Util.getAno(this.getDataFim()));
        parametros.put("parRodape", this.getRodape());
        parametros.put("parConfig", "");
        parametros.put("parTitulo1", "Taxa de notifica\u00e7\u00e3o de casos de paralisia fl\u00e1cida aguda \u2013 PFA em menores de 15 anos ");
        ANO = "";
        if (Util.getAno(this.getDataFim()).equals(Util.getAno(this.getDataInicio()))) {
            ANO = Util.getAno(this.getDataFim());
        }
        this.setDataInicio(this.getDataInicio());
        this.setDataFim(this.getDataFim());
        return parametros;
    }

    @Override
    public DBFWriter getLinhas(HashMap<String, ColunasDbf> colunas, List bean, DBFWriter writer) throws DBFException, IOException {
        for (int i = 0; i < bean.size(); ++i) {
            Object[] rowData = new Object[colunas.size()];
            Agravo agravo = (Agravo)bean.get(i);
            if (agravo.getNomeMunicipio().equals("BRASIL")) {
                rowData[0] = null;
                rowData[2] = null;
            } else {
                rowData[0] = agravo.getCodMunicipio();
                rowData[2] = agravo.getCodMunicipio().substring(0, 2);
            }
            rowData[1] = agravo.getNomeMunicipio();
            rowData[3] = Double.parseDouble(agravo.getNumerador());
            rowData[4] = Double.parseDouble(agravo.getDenominador().replace(".", ""));
            rowData[5] = Double.parseDouble(agravo.getTaxa().replace(",", "."));
            rowData[6] = this.preencheAno(this.getDataInicio(), this.getDataFim());
            rowData[7] = this.getDataInicio();
            rowData[8] = this.getDataFim();
            rowData[9] = "PFA-SINANNET";
            writer.addRecord(rowData);
        }
        return writer;
    }

    @Override
    public String getCaminhoJasper() {
        return "/com/org/relatorios/agravo1.jasper";
    }
}

